/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.api.KafkaSasl$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.log.LogConfig$;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\teg\u0001B\u0013'\u0001-BQa\r\u0001\u0005\u0002QBqA\u000e\u0001C\u0002\u0013\u0005s\u0007\u0003\u0004?\u0001\u0001\u0006I\u0001\u000f\u0005\u0006\u007f\u0001!\t\u0006\u0011\u0005\b\u001d\u0002\u0011\r\u0011\"\u0003P\u0011\u0019A\u0006\u0001)A\u0005!\"9\u0011\f\u0001b\u0001\n\u0013Q\u0006BB2\u0001A\u0003%1\fC\u0004e\u0001\t\u0007I\u0011B(\t\r\u0015\u0004\u0001\u0015!\u0003Q\u0011\u00151\u0007\u0001\"\u0015h\u0011\u001d\u0001\bA1A\u0005REDaa\u001f\u0001!\u0002\u0013\u0011\bb\u0002?\u0001\u0005\u0004%\t&\u001d\u0005\u0007{\u0002\u0001\u000b\u0011\u0002:\t\u000by\u0004A\u0011I@\t\u000f\u0005\u0015\u0002\u0001\"\u0011\u0002(!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005\u001d\u0002bBA\u001e\u0001\u0011%\u0011Q\b\u0005\b\u0003c\u0002A\u0011BA:\u0011\u001d\t9\b\u0001C\u0005\u0003sBq!a#\u0001\t\u0013\ti\tC\u0004\u0002P\u0002!I!!5\t\u000f\u0005\u0005\b\u0001\"\u0003\u0002d\"9\u00111\u001e\u0001\u0005\n\u00055\bbBA{\u0001\u0011%\u0011q\u001f\u0005\b\u0003w\u0004A\u0011BA\u007f\u0011%\u0011I\u0005AI\u0001\n\u0013\u0011Y\u0005C\u0004\u0003f\u0001!IAa\u001a\t\u000f\t\u0005\u0005\u0001\"\u0003\u0003\u0004\"I!q\u0013\u0001\u0012\u0002\u0013%!Q\n\u0005\b\u00053\u0003A\u0011\u0002BN\u0011\u001d\u0011y\n\u0001C\u0005\u0005CCqAa/\u0001\t\u0013\u0011i\fC\u0005\u0003L\u0002\t\n\u0011\"\u0003\u0003N\"9!\u0011\u001b\u0001\u0005\n\tM'aC'fiJL7m\u001d+fgRT!a\n\u0015\u0002\u0007\u0005\u0004\u0018NC\u0001*\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u00171!\tic&D\u0001'\u0013\tycE\u0001\fJ]R,wM]1uS>tG+Z:u\u0011\u0006\u0014h.Z:t!\ti\u0013'\u0003\u00023M\tI1+Y:m'\u0016$X\u000f]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0002\"!\f\u0001\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u0002qA\u0011\u0011\bP\u0007\u0002u)\t1(A\u0003tG\u0006d\u0017-\u0003\u0002>u\t\u0019\u0011J\u001c;\u0002\u0019\t\u0014xn[3s\u0007>,h\u000e\u001e\u0011\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0016\u0003\u0005\u0003\"A\u0011'\u000e\u0003\rS!\u0001R#\u0002\u000f9,Go^8sW*\u0011aiR\u0001\u0007G>lWn\u001c8\u000b\u0005%B%BA%K\u0003\u0019\t\u0007/Y2iK*\t1*A\u0002pe\u001eL!!T\"\u0003\u00191K7\u000f^3oKJt\u0015-\\3\u00021-\fgm[1DY&,g\u000e^*bg2lUm\u00195b]&\u001cX.F\u0001Q!\t\tf+D\u0001S\u0015\t\u0019F+\u0001\u0003mC:<'\"A+\u0002\t)\fg/Y\u0005\u0003/J\u0013aa\u0015;sS:<\u0017!G6bM.\f7\t\\5f]R\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[\u0002\n\u0011d[1gW\u0006\u001cVM\u001d<feN\u000b7\u000f\\'fG\"\fg.[:ngV\t1\fE\u0002]CBk\u0011!\u0018\u0006\u0003=~\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005\u0001T\u0014AC2pY2,7\r^5p]&\u0011!-\u0018\u0002\u0005\u0019&\u001cH/\u0001\u000elC\u001a\\\u0017mU3sm\u0016\u00148+Y:m\u001b\u0016\u001c\u0007.\u00198jg6\u001c\b%\u0001\rlC\u001a\\\u0017mU3sm\u0016\u0014(*Y1t\u000b:$(/\u001f(b[\u0016\f\u0011d[1gW\u0006\u001cVM\u001d<fe*\u000b\u0017m]#oiJLh*Y7fA\u0005\u00012/Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\\u000b\u0002QB\u0011\u0011N\\\u0007\u0002U*\u00111\u000e\\\u0001\u0005CV$\bN\u0003\u0002n\u000b\u0006A1/Z2ve&$\u00180\u0003\u0002pU\n\u00012+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\\u0001\u0015g\u0016\u0014h/\u001a:TCNd\u0007K]8qKJ$\u0018.Z:\u0016\u0003I\u00042!O:v\u0013\t!(H\u0001\u0003T_6,\u0007C\u0001<z\u001b\u00059(B\u0001=U\u0003\u0011)H/\u001b7\n\u0005i<(A\u0003)s_B,'\u000f^5fg\u0006)2/\u001a:wKJ\u001c\u0016m\u001d7Qe>\u0004XM\u001d;jKN\u0004\u0013\u0001F2mS\u0016tGoU1tYB\u0013x\u000e]3si&,7/A\u000bdY&,g\u000e^*bg2\u0004&o\u001c9feRLWm\u001d\u0011\u0002\u000bM,G/\u00169\u0015\t\u0005\u0005\u0011q\u0001\t\u0004s\u0005\r\u0011bAA\u0003u\t!QK\\5u\u0011\u001d\tI\u0001\u0005a\u0001\u0003\u0017\t\u0001\u0002^3ti&sgm\u001c\t\u0005\u0003\u001b\tI\"\u0004\u0002\u0002\u0010)\u0019q%!\u0005\u000b\t\u0005M\u0011QC\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t9BS\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u00037\tyA\u0001\u0005UKN$\u0018J\u001c4pQ\r\u0001\u0012q\u0004\t\u0005\u0003\u001b\t\t#\u0003\u0003\u0002$\u0005=!A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000e\u0006\u0002\u0002\u0002!\u001a\u0011#a\u000b\u0011\t\u00055\u0011QF\u0005\u0005\u0003_\tyAA\u0005BMR,'/R1dQ\u0006YA/Z:u\u001b\u0016$(/[2tQ\r\u0011\u0012Q\u0007\t\u0005\u0003\u001b\t9$\u0003\u0003\u0002:\u0005=!\u0001\u0002+fgR\f1b]3oIJ+7m\u001c:egRQ\u0011\u0011AA \u0003;\n\t'!\u001a\t\u000f\u0005\u00053\u00031\u0001\u0002D\u0005A\u0001O]8ek\u000e,'\u000f\u0005\u0005\u0002F\u00055\u0013\u0011KA)\u001b\t\t9E\u0003\u0003\u0002B\u0005%#bAA&\u000f\u000691\r\\5f]R\u001c\u0018\u0002BA(\u0003\u000f\u0012QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\b#B\u001d\u0002T\u0005]\u0013bAA+u\t)\u0011I\u001d:bsB\u0019\u0011(!\u0017\n\u0007\u0005m#H\u0001\u0003CsR,\u0007BBA0'\u0001\u0007\u0001(\u0001\u0006ok6\u0014VmY8sINDa!a\u0019\u0014\u0001\u0004A\u0014A\u0003:fG>\u0014HmU5{K\"9\u0011qM\nA\u0002\u0005%\u0014A\u0001;q!\u0011\tY'!\u001c\u000e\u0003\u0015K1!a\u001cF\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fQdZ3oKJ\fG/Z!vi\",g\u000e^5dCRLwN\u001c$bS2,(/\u001a\u000b\u0005\u0003\u0003\t)\bC\u0004\u0002hQ\u0001\r!!\u001b\u0002SY,'/\u001b4z\u0017\u000647.\u0019*bi\u0016lU\r\u001e:jGND\u0015M^3Dk6,H.\u0019;jm\u0016\u001cu.\u001e8u)\u0019\t\t!a\u001f\u0002~!9\u0011\u0011I\u000bA\u0002\u0005\r\u0003bBA@+\u0001\u0007\u0011\u0011Q\u0001\tG>t7/^7feBA\u00111QAD\u0003#\n\t&\u0004\u0002\u0002\u0006*!\u0011qPA%\u0013\u0011\tI)!\"\u0003\u001b-\u000bgm[1D_:\u001cX/\\3s\u0003i1XM]5gs\u000ec\u0017.\u001a8u-\u0016\u00148/[8o\u001b\u0016$(/[2t)\u0019\t\t!a$\u00028\"9\u0011\u0011\u0013\fA\u0002\u0005M\u0015aB7fiJL7m\u001d\u0019\u0005\u0003+\u000b)\u000bE\u0004w\u0003/\u000bY*!)\n\u0007\u0005euOA\u0002NCB\u0004B!a\u001b\u0002\u001e&\u0019\u0011qT#\u0003\u00155+GO]5d\u001d\u0006lW\r\u0005\u0003\u0002$\u0006\u0015F\u0002\u0001\u0003\r\u0003O\u000by)!A\u0001\u0002\u000b\u0005\u0011\u0011\u0016\u0002\u0004?\u0012\n\u0014\u0003BAV\u0003c\u00032!OAW\u0013\r\tyK\u000f\u0002\b\u001d>$\b.\u001b8h!\u0011\tY'a-\n\u0007\u0005UVI\u0001\u0004NKR\u0014\u0018n\u0019\u0005\b\u0003s3\u0002\u0019AA^\u0003\u0019)g\u000e^5usB!\u0011QXAf\u001d\u0011\ty,a2\u0011\u0007\u0005\u0005'(\u0004\u0002\u0002D*\u0019\u0011Q\u0019\u0016\u0002\rq\u0012xn\u001c;?\u0013\r\tIMO\u0001\u0007!J,G-\u001a4\n\u0007]\u000biMC\u0002\u0002Jj\n\u0011E^3sS\u001aL(I]8lKJ\fU\u000f\u001e5f]RL7-\u0019;j_:lU\r\u001e:jGN$B!!\u0001\u0002T\"9\u0011Q[\fA\u0002\u0005]\u0017AB:feZ,'\u000f\u0005\u0003\u0002Z\u0006uWBAAn\u0015\r\t)\u000eK\u0005\u0005\u0003?\fYNA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\u0018\u0001\n<fe&4\u0017P\u0011:pW\u0016\u0014X*Z:tC\u001e,7i\u001c8wKJ\u001c\u0018n\u001c8NKR\u0014\u0018nY:\u0015\u0011\u0005\u0005\u0011Q]At\u0003SDq!!6\u0019\u0001\u0004\t9\u000e\u0003\u0004\u0002da\u0001\r\u0001\u000f\u0005\b\u0003OB\u0002\u0019AA5\u0003U1XM]5gs\n\u0013xn[3s5.lU\r\u001e:jGN$b!!\u0001\u0002p\u0006E\bbBAk3\u0001\u0007\u0011q\u001b\u0005\b\u0003gL\u0002\u0019AA^\u0003\u0015!x\u000e]5d\u0003a1XM]5gs\n\u0013xn[3s\u000bJ\u0014xN]'fiJL7m\u001d\u000b\u0005\u0003\u0003\tI\u0010C\u0004\u0002Vj\u0001\r!a6\u0002#Y,'/\u001b4z\u0017\u000647.Y'fiJL7-\u0006\u0003\u0002\u0000\n\u0015AC\u0003B\u0001\u0005[\u0011\tD!\u0010\u0003@Q!!1\u0001B\t!\u0011\t\u0019K!\u0002\u0005\u000f\t\u001d1D1\u0001\u0003\n\t\tA+\u0005\u0003\u0002,\n-\u0001cA\u001d\u0003\u000e%\u0019!q\u0002\u001e\u0003\u0007\u0005s\u0017\u0010C\u0004\u0003\u0014m\u0001\rA!\u0006\u0002\rY,'/\u001b4z!\u001dI$q\u0003B\u000e\u0005\u0007I1A!\u0007;\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0004\u0003\u001e\t\u001d\u0012\u0011\u0017\b\u0005\u0005?\u0011\u0019C\u0004\u0003\u0002B\n\u0005\u0012\"A\u001e\n\u0007\t\u0015\"(A\u0004qC\u000e\\\u0017mZ3\n\t\t%\"1\u0006\u0002\t\u0013R,'/\u00192mK*\u0019!Q\u0005\u001e\t\u000f\t=2\u00041\u0001\u0002<\u0006!a.Y7f\u0011\u001d\t\tj\u0007a\u0001\u0005g\u0001DA!\u000e\u0003:A9a/a&\u0002\u001c\n]\u0002\u0003BAR\u0005s!ABa\u000f\u00032\u0005\u0005\t\u0011!B\u0001\u0003S\u00131a\u0018\u00133\u0011\u001d\tIl\u0007a\u0001\u0003wC\u0011B!\u0011\u001c!\u0003\u0005\rAa\u0011\u0002\u000b\u001d\u0014x.\u001e9\u0011\u000be\u0012)%a/\n\u0007\t\u001d#H\u0001\u0004PaRLwN\\\u0001\u001cm\u0016\u0014\u0018NZ=LC\u001a\\\u0017-T3ue&\u001cG\u0005Z3gCVdG\u000f\n\u001b\u0016\t\t5#1M\u000b\u0003\u0005\u001fRCAa\u0011\u0003R-\u0012!1\u000b\t\u0005\u0005+\u0012y&\u0004\u0002\u0003X)!!\u0011\fB.\u0003%)hn\u00195fG.,GMC\u0002\u0003^i\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\tGa\u0016\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rB\u0004\u0003\bq\u0011\rA!\u0003\u0002'5\f\u0007pS1gW\u0006lU\r\u001e:jGZ\u000bG.^3\u0015\u0015\t%$q\u000eB9\u0005{\u0012y\bE\u0002:\u0005WJ1A!\u001c;\u0005\u0019!u.\u001e2mK\"9!qF\u000fA\u0002\u0005m\u0006bBAI;\u0001\u0007!1\u000f\u0019\u0005\u0005k\u0012I\bE\u0004w\u0003/\u000bYJa\u001e\u0011\t\u0005\r&\u0011\u0010\u0003\r\u0005w\u0012\t(!A\u0001\u0002\u000b\u0005\u0011\u0011\u0016\u0002\u0004?\u0012\u001a\u0004bBA];\u0001\u0007\u00111\u0018\u0005\b\u0005\u0003j\u0002\u0019\u0001B\"\u0003e1XM]5gs.\u000bgm[1NKR\u0014\u0018n\u0019*fG>\u0014H-\u001a3\u0015\u0015\u0005\u0005!Q\u0011BD\u0005'\u0013)\nC\u0004\u00030y\u0001\r!a/\t\u000f\u0005Ee\u00041\u0001\u0003\nB\"!1\u0012BH!\u001d1\u0018qSAN\u0005\u001b\u0003B!a)\u0003\u0010\u0012a!\u0011\u0013BD\u0003\u0003\u0005\tQ!\u0001\u0002*\n\u0019q\f\n\u001b\t\u000f\u0005ef\u00041\u0001\u0002<\"I!\u0011\t\u0010\u0011\u0002\u0003\u0007!1I\u0001$m\u0016\u0014\u0018NZ=LC\u001a\\\u0017-T3ue&\u001c'+Z2pe\u0012,G\r\n3fM\u0006,H\u000e\u001e\u00135\u0003EI\u0018-\\7fe6+GO]5d-\u0006dW/\u001a\u000b\u0005\u0005\u0017\u0011i\nC\u0004\u00030\u0001\u0002\r!a/\u0002\u001fe\fW.\\3s\u0011&\u001cHo\\4sC6$BAa)\u0003:B!!Q\u0015B[\u001b\t\u00119K\u0003\u0003\u0003*\n-\u0016\u0001B2pe\u0016TA!!%\u0003.*!!q\u0016BY\u0003\u0019I\u0018-\\7fe*\u0011!1W\u0001\u0004G>l\u0017\u0002\u0002B\\\u0005O\u0013\u0011\u0002S5ti><'/Y7\t\u000f\t=\u0012\u00051\u0001\u0002<\u0006Qb/\u001a:jMfL\u0016-\\7fe6+GO]5d%\u0016\u001cwN\u001d3fIR1!\u0011\u000eB`\u0005\u0003DqAa\f#\u0001\u0004\tY\fC\u0005\u0003\u0014\t\u0002\n\u00111\u0001\u0003DB9\u0011Ha\u0006\u0003j\t\u0015\u0007cA\u001d\u0003H&\u0019!\u0011\u001a\u001e\u0003\u000f\t{w\u000e\\3b]\u0006!c/\u001a:jMfL\u0016-\\7fe6+GO]5d%\u0016\u001cwN\u001d3fI\u0012\"WMZ1vYR$#'\u0006\u0002\u0003P*\"!1\u0019B)\u0003Y1XM]5gs:{'+Z9vKN$X*\u001a;sS\u000e\u001cH\u0003BA\u0001\u0005+DqAa6%\u0001\u0004\tY,\u0001\u0007feJ|'/T3tg\u0006<W\r")
public class MetricsTest
extends IntegrationTestHarness
implements SaslSetup {
    private final int brokerCount;
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final String kafkaServerJaasEntryName;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private File kafka$api$SaslSetup$$workDir;
    private Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public String jaasAdminLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasAdminLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasAdminLoginModule$default$2() {
        return SaslSetup.jaasAdminLoginModule$default$2$(this);
    }

    @Override
    public String jaasScramClientLoginModule(String clientSaslScramMechanism, String scramUser, String scramPassword) {
        return SaslSetup.jaasScramClientLoginModule$(this, clientSaslScramMechanism, scramUser, scramPassword);
    }

    @Override
    public Admin createPrivilegedAdminClient() {
        return SaslSetup.createPrivilegedAdminClient$(this);
    }

    @Override
    public Admin createAdminClient(String brokerList, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> clientSaslProperties, String scramMechanism, String user, String password) {
        return SaslSetup.createAdminClient$(this, brokerList, securityProtocol, trustStoreFile, clientSaslProperties, scramMechanism, user, password);
    }

    @Override
    public void createScramCredentialsViaPrivilegedAdminClient(String userName, String password) {
        SaslSetup.createScramCredentialsViaPrivilegedAdminClient$(this, userName, password);
    }

    @Override
    public void createScramCredentials(Admin adminClient, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, adminClient, userName, password);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, zkConnect, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    public ListenerName listenerName() {
        return new ListenerName("CLIENT");
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    private String kafkaServerJaasEntryName() {
        return this.kafkaServerJaasEntryName;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.verifyNoRequestMetrics("Request metrics not removed in a previous test");
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), KafkaSasl$.MODULE$, this.kafkaServerJaasEntryName()));
        super.setUp(testInfo);
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
        this.verifyNoRequestMetrics("Request metrics not removed in this test");
    }

    @Test
    public void testMetrics() {
        String topic = "topicWithOldMessageFormat";
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        this.createTopic(topic, 1, 1, props, this.createTopic$default$5(), this.createTopic$default$6());
        TopicPartition tp = new TopicPartition(topic, 0);
        int numRecords = 10;
        int recordSize = 100000;
        Properties prop = new Properties();
        prop.setProperty("enable.idempotence", "false");
        ByteArraySerializer x$2 = this.createProducer$default$1();
        ByteArraySerializer x$3 = this.createProducer$default$2();
        KafkaProducer producer = this.createProducer(x$2, x$3, prop);
        this.sendRecords(producer, numRecords, recordSize, tp);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)tp, (List)Nil$.MODULE$)).asJava());
        consumer.seek(tp, 0L);
        TestUtils$.MODULE$.consumeRecords(consumer, numRecords, 15000L);
        this.verifyKafkaRateMetricsHaveCumulativeCount(producer, consumer);
        this.verifyClientVersionMetrics(consumer.metrics(), "Consumer");
        this.verifyClientVersionMetrics(producer.metrics(), "Producer");
        KafkaServer server = (KafkaServer)this.servers().head();
        this.verifyBrokerMessageConversionMetrics(server, recordSize, tp);
        this.verifyBrokerErrorMetrics((KafkaServer)this.servers().head());
        this.verifyBrokerZkMetrics(server, topic);
        this.generateAuthenticationFailure(tp);
        this.verifyBrokerAuthenticationMetrics(server);
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, int recordSize, TopicPartition tp) {
        byte[] bytes = new byte[recordSize];
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)i -> producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), Predef$.MODULE$.long2Long((long)BoxesRunTime.unboxToInt((Object)i)), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(), (Object)bytes)));
        producer.flush();
    }

    private void generateAuthenticationFailure(TopicPartition tp) {
        Properties saslProps = new Properties();
        saslProps.put("sasl.mechanism", this.kafkaClientSaslMechanism());
        saslProps.put("sasl.jaas.config", TestJaasConfig.jaasConfigProperty((String)this.kafkaClientSaslMechanism(), (String)"badUser", (String)"badPass"));
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        SecurityProtocol x$5 = this.securityProtocol();
        Option<File> x$6 = this.trustStoreFile();
        Some x$7 = new Some((Object)saslProps);
        long x$8 = 0x100000L;
        int x$9 = Integer.MAX_VALUE;
        int x$10 = 30000;
        int x$11 = 0;
        int x$12 = 16384;
        String x$13 = "none";
        ByteArraySerializer x$14 = new ByteArraySerializer();
        ByteArraySerializer x$15 = new ByteArraySerializer();
        boolean x$16 = false;
        try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$1, 0, 1000L, x$8, x$9, x$10, x$11, x$12, x$13, 1000, x$5, x$6, (Option<Properties>)x$7, x$14, x$15, x$16);){
            try {
                producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), (Object)"key".getBytes(), (Object)"value".getBytes())).get();
            }
            catch (Exception exception) {}
        }
    }

    private void verifyKafkaRateMetricsHaveCumulativeCount(KafkaProducer<byte[], byte[]> producer, KafkaConsumer<byte[], byte[]> consumer) {
        Set consumerMetricNames = CollectionConverters$.MODULE$.SetHasAsScala(consumer.metrics().keySet()).asScala().toSet();
        ((IterableOnceOps)consumerMetricNames.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaRateMetricsHaveCumulativeCount$1(x$1)))).foreach((Function1 & Serializable)x$2 -> {
            MetricsTest.verify$1(x$2, consumerMetricNames);
            return BoxedUnit.UNIT;
        });
        Set producerMetricNames = CollectionConverters$.MODULE$.SetHasAsScala(producer.metrics().keySet()).asScala().toSet();
        Set producerExclusions = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"compression-rate"}));
        ((IterableOnceOps)((IterableOps)producerMetricNames.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaRateMetricsHaveCumulativeCount$3(x$3)))).filterNot((Function1 & Serializable)metricName -> BoxesRunTime.boxToBoolean((boolean)producerExclusions.contains((Object)metricName.name())))).foreach((Function1 & Serializable)x$4 -> {
            MetricsTest.verify$1(x$4, producerMetricNames);
            return BoxedUnit.UNIT;
        });
        this.verifyKafkaMetricRecorded("records-consumed-rate", consumer.metrics(), "Consumer", (Option<String>)None$.MODULE$);
        this.verifyKafkaMetricRecorded("records-consumed-total", consumer.metrics(), "Consumer", (Option<String>)None$.MODULE$);
        this.verifyKafkaMetricRecorded("record-send-rate", producer.metrics(), "Producer", (Option<String>)None$.MODULE$);
        this.verifyKafkaMetricRecorded("record-send-total", producer.metrics(), "Producer", (Option<String>)None$.MODULE$);
    }

    private void verifyClientVersionMetrics(Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity) {
        new .colon.colon((Object)"commit-id", (List)new .colon.colon((Object)"version", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)name -> {
            MetricsTest.$anonfun$verifyClientVersionMetrics$1(this, metrics, entity, name);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private void verifyBrokerAuthenticationMetrics(KafkaServer server) {
        Map metrics = server.metrics().metrics();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetricsTest.$anonfun$verifyBrokerAuthenticationMetrics$1(this, metrics)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"failed-authentication-total not updated");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.verifyKafkaMetricRecorded("successful-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("successful-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
    }

    private void verifyBrokerMessageConversionMetrics(KafkaServer server, int recordSize, TopicPartition tp) {
        String requestMetricsPrefix = "kafka.network:type=RequestMetrics";
        double requestBytes = this.verifyYammerMetricRecorded(new StringBuilder(34).append(requestMetricsPrefix).append(",name=RequestBytes,request=Produce").toString(), this.verifyYammerMetricRecorded$default$2());
        double tempBytes = this.verifyYammerMetricRecorded(new StringBuilder(42).append(requestMetricsPrefix).append(",name=TemporaryMemoryBytes,request=Produce").toString(), this.verifyYammerMetricRecorded$default$2());
        Assertions.assertTrue((tempBytes >= (double)recordSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("Unexpected temporary memory size requestBytes ").append(requestBytes).append(" tempBytes ").append(tempBytes).toString());
        this.verifyYammerMetricRecorded("kafka.server:type=BrokerTopicMetrics,name=ProduceMessageConversionsPerSec", this.verifyYammerMetricRecorded$default$2());
        String verifyYammerMetricRecorded_name = new StringBuilder(46).append(requestMetricsPrefix).append(",name=MessageConversionsTimeMs,request=Produce").toString();
        double verifyYammerMetricRecorded_metricValue = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(verifyYammerMetricRecorded_name));
        Assertions.assertTrue((boolean)MetricsTest.$anonfun$verifyBrokerMessageConversionMetrics$1(verifyYammerMetricRecorded_metricValue), (String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(verifyYammerMetricRecorded_name).append(" value ").append(verifyYammerMetricRecorded_metricValue).toString());
        Object var9_7 = null;
        this.verifyYammerMetricRecorded(new StringBuilder(32).append(requestMetricsPrefix).append(",name=RequestBytes,request=Fetch").toString(), this.verifyYammerMetricRecorded$default$2());
        String verifyYammerMetricRecorded_name2 = new StringBuilder(40).append(requestMetricsPrefix).append(",name=TemporaryMemoryBytes,request=Fetch").toString();
        double verifyYammerMetricRecorded_metricValue2 = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(verifyYammerMetricRecorded_name2));
        Assertions.assertTrue((boolean)MetricsTest.$anonfun$verifyBrokerMessageConversionMetrics$2(verifyYammerMetricRecorded_metricValue2), (String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(verifyYammerMetricRecorded_name2).append(" value ").append(verifyYammerMetricRecorded_metricValue2).toString());
        Object var12_9 = null;
        this.verifyYammerMetricRecorded(new StringBuilder(35).append(requestMetricsPrefix).append(",name=RequestBytes,request=Metadata").toString(), this.verifyYammerMetricRecorded$default$2());
    }

    private void verifyBrokerZkMetrics(KafkaServer server, String topic) {
        Histogram histogram = this.yammerHistogram("kafka.server:type=ZooKeeperClientMetrics,name=ZooKeeperRequestLatencyMs");
        long initialCount = histogram.count();
        ((KafkaServer)this.servers().head()).zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assertions.assertTrue((histogram.count() > initialCount ? 1 : 0) != 0, (String)"ZooKeeper latency not recorded");
        double min = histogram.min();
        Assertions.assertTrue((min >= 0.0 ? 1 : 0) != 0, (String)new StringBuilder(36).append("Min latency should not be negative: ").append(min).toString());
        Assertions.assertEquals((Object)"CONNECTED", (Object)this.yammerMetricValue("SessionState"), (String)"Unexpected ZK state");
    }

    private void verifyBrokerErrorMetrics(KafkaServer server) {
        int startErrorMetricCount = MetricsTest.errorMetricCount$1();
        String errorMetricPrefix = "kafka.network:type=RequestMetrics,name=ErrorsPerSec";
        this.verifyYammerMetricRecorded(new StringBuilder(28).append(errorMetricPrefix).append(",request=Metadata,error=NONE").toString(), this.verifyYammerMetricRecorded$default$2());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        try {
            consumer.partitionsFor("12{}!");
        }
        catch (InvalidTopicException invalidTopicException) {}
        this.verifyYammerMetricRecorded(new StringBuilder(47).append(errorMetricPrefix).append(",request=Metadata,error=INVALID_TOPIC_EXCEPTION").toString(), this.verifyYammerMetricRecorded$default$2());
        int currentErrorMetricCount = MetricsTest.errorMetricCount$1();
        Assertions.assertEquals((int)(startErrorMetricCount + 1), (int)currentErrorMetricCount);
        Assertions.assertTrue((currentErrorMetricCount < 10 ? 1 : 0) != 0, (String)new StringBuilder(23).append("Too many error metrics ").append(currentErrorMetricCount).toString());
        try {
            consumer.partitionsFor("non-existing-topic");
        }
        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {}
        this.verifyYammerMetricRecorded(new StringBuilder(50).append(errorMetricPrefix).append(",request=Metadata,error=UNKNOWN_TOPIC_OR_PARTITION").toString(), this.verifyYammerMetricRecorded$default$2());
    }

    private <T> T verifyKafkaMetric(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group, Function1<Iterable<org.apache.kafka.common.Metric>, T> verify) {
        scala.collection.mutable.Map matchingMetrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(metrics).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$1(name, group, x0$1)));
        Assertions.assertTrue((boolean)matchingMetrics.nonEmpty(), (String)new StringBuilder(17).append("Metric not found ").append(name).toString());
        return (T)verify.apply((Object)matchingMetrics.values());
    }

    private <T> Option<String> verifyKafkaMetric$default$4() {
        return None$.MODULE$;
    }

    private double maxKafkaMetricValue(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        scala.collection.mutable.Map verifyKafkaMetric_matchingMetrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(metrics).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$1(name, group, x0$1)));
        Assertions.assertTrue((boolean)verifyKafkaMetric_matchingMetrics.nonEmpty(), (String)new StringBuilder(17).append("Metric not found ").append(name).toString());
        return MetricsTest.$anonfun$maxKafkaMetricValue$1(verifyKafkaMetric_matchingMetrics.values());
    }

    private void verifyKafkaMetricRecorded(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        double value = this.maxKafkaMetricValue(name, metrics, entity, group);
        Assertions.assertTrue((value > 0.0 ? 1 : 0) != 0, (String)new StringBuilder(42).append(entity).append(" metric not recorded correctly for ").append(name).append(" value ").append(value).toString());
    }

    private Option<String> verifyKafkaMetricRecorded$default$4() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private Object yammerMetricValue(String name) {
        void var4_4;
        scala.collection.mutable.Map allMetrics = CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Tuple2 tuple2 = (Tuple2)allMetrics.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$yammerMetricValue$1(name, x0$1))).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(43).append("Unable to find broker metric ").append(name).append(": allMetrics: ").append(allMetrics.keySet().map((Function1 & Serializable)x$7 -> x$7.getMBeanName())).toString()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Metric metric = (Metric)tuple2._2();
        if (var4_4 instanceof Meter) {
            return BoxesRunTime.boxToDouble((double)((Meter)var4_4).count());
        }
        if (var4_4 instanceof Histogram) {
            return BoxesRunTime.boxToDouble((double)((Histogram)var4_4).max());
        }
        if (var4_4 instanceof Gauge) {
            return ((Gauge)var4_4).value();
        }
        return Assertions.fail((String)new StringBuilder(34).append("Unexpected broker metric of class ").append(var4_4.getClass()).toString());
    }

    /*
     * WARNING - void declaration
     */
    private Histogram yammerHistogram(String name) {
        void var4_4;
        scala.collection.mutable.Map allMetrics = CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Tuple2 tuple2 = (Tuple2)allMetrics.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$yammerHistogram$1(name, x0$1))).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(43).append("Unable to find broker metric ").append(name).append(": allMetrics: ").append(allMetrics.keySet().map((Function1 & Serializable)x$8 -> x$8.getMBeanName())).toString()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Metric metric = (Metric)tuple2._2();
        if (var4_4 instanceof Histogram) {
            return (Histogram)var4_4;
        }
        throw new AssertionError((Object)new StringBuilder(34).append("Unexpected broker metric of class ").append(var4_4.getClass()).toString());
    }

    private double verifyYammerMetricRecorded(String name, Function1<Object, Object> verify) {
        double metricValue = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(name));
        Assertions.assertTrue((boolean)verify.apply$mcZD$sp(metricValue), (String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(name).append(" value ").append(metricValue).toString());
        return metricValue;
    }

    private Function1<Object, Object> verifyYammerMetricRecorded$default$2() {
        return (JFunction1.mcZD.sp & Serializable)d -> d > 0.0;
    }

    private void verifyNoRequestMetrics(String errorMessage) {
        scala.collection.mutable.Map metrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyNoRequestMetrics$1(x0$1)));
        Assertions.assertTrue((boolean)metrics.isEmpty(), (String)new StringBuilder(2).append(errorMessage).append(": ").append(metrics.keys()).toString());
    }

    private static final boolean exists$1(String name, MetricName rateMetricName, Set allMetricNames) {
        return allMetricNames.contains((Object)new MetricName(name, rateMetricName.group(), "", rateMetricName.tags()));
    }

    private static final void verify$1(MetricName rateMetricName, Set allMetricNames) {
        String name = rateMetricName.name();
        boolean totalExists = MetricsTest.exists$1(name.replace("-rate", "-total"), rateMetricName, allMetricNames);
        boolean totalTimeExists = MetricsTest.exists$1(name.replace("-rate", "-time"), rateMetricName, allMetricNames);
        Assertions.assertTrue((totalExists || totalTimeExists ? 1 : 0) != 0, (String)new StringBuilder(48).append("No cumulative count/time metric for rate metric ").append(rateMetricName).toString());
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaRateMetricsHaveCumulativeCount$1(MetricName x$1) {
        return x$1.name().endsWith("-rate");
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaRateMetricsHaveCumulativeCount$3(MetricName x$3) {
        return x$3.name().endsWith("-rate");
    }

    public static final /* synthetic */ void $anonfun$verifyClientVersionMetrics$2(String entity$1, String name$1, Iterable matchingMetrics) {
        Assertions.assertEquals((int)1, (int)matchingMetrics.size());
        org.apache.kafka.common.Metric metric = (org.apache.kafka.common.Metric)matchingMetrics.head();
        Object value = metric.metricValue();
        Assertions.assertNotNull((Object)value, (String)new StringBuilder(21).append(entity$1).append(" metric not recorded ").append(name$1).toString());
        Assertions.assertNotNull((Object)BoxesRunTime.boxToBoolean((value instanceof String && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)value)) ? 1 : 0) != 0), (String)new StringBuilder(37).append(entity$1).append(" metric ").append(name$1).append(" should be a non-empty String").toString());
        Assertions.assertTrue((boolean)metric.metricName().tags().containsKey("client-id"), (String)"Client-id not specified");
    }

    public static final /* synthetic */ void $anonfun$verifyClientVersionMetrics$1(MetricsTest $this, Map metrics$1, String entity$1, String name) {
        None$ verifyKafkaMetric_group = None$.MODULE$;
        scala.collection.mutable.Map verifyKafkaMetric_matchingMetrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(metrics$1).asScala().filter(arg_0 -> MetricsTest.$anonfun$verifyKafkaMetric$1$adapted(name, (Option)verifyKafkaMetric_group, arg_0));
        Assertions.assertTrue((boolean)verifyKafkaMetric_matchingMetrics.nonEmpty(), (String)new StringBuilder(17).append("Metric not found ").append(name).toString());
        Iterable iterable = verifyKafkaMetric_matchingMetrics.values();
        MetricsTest.$anonfun$verifyClientVersionMetrics$2(entity$1, name, iterable);
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerAuthenticationMetrics$1(MetricsTest $this, Map metrics$2) {
        return $this.maxKafkaMetricValue("failed-authentication-total", metrics$2, "Broker", (Option<String>)new Some((Object)"socket-server-metrics")) > 0.0;
    }

    public static final /* synthetic */ String $anonfun$verifyBrokerAuthenticationMetrics$2() {
        return "failed-authentication-total not updated";
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerMessageConversionMetrics$1(double value) {
        return value > 0.0;
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerMessageConversionMetrics$2(double value) {
        return value == 0.0;
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerErrorMetrics$1(com.yammer.metrics.core.MetricName x$5) {
        String string = x$5.getName();
        String string2 = "ErrorsPerSec";
        return string != null && string.equals(string2);
    }

    private static final int errorMetricCount$1() {
        return CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().count((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyBrokerErrorMetrics$1(x$5)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaMetric$2(MetricName metricName$1, String x$6) {
        String string = x$6;
        String string2 = metricName$1.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaMetric$1(String name$2, Option group$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName metricName = (MetricName)x0$1._1();
            String string = metricName.name();
            return !(string != null ? !string.equals(name$2) : name$2 != null) && group$1.forall((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$2(metricName, x$6)));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ double $anonfun$maxKafkaMetricValue$2(double max, org.apache.kafka.common.Metric metric) {
        return Math.max(max, BoxesRunTime.unboxToDouble((Object)metric.metricValue()));
    }

    public static final /* synthetic */ double $anonfun$maxKafkaMetricValue$1(Iterable matchingMetrics) {
        return BoxesRunTime.unboxToDouble((Object)matchingMetrics.foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, metric) -> BoxesRunTime.boxToDouble((double)MetricsTest.$anonfun$maxKafkaMetricValue$2(BoxesRunTime.unboxToDouble((Object)max), metric))));
    }

    public static final /* synthetic */ boolean $anonfun$yammerMetricValue$1(String name$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().endsWith(name$3);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$yammerHistogram$1(String name$4, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().endsWith(name$4);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyNoRequestMetrics$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().startsWith("kafka.network:type=RequestMetrics");
        }
        throw new MatchError(null);
    }

    public MetricsTest() {
        SaslSetup.$init$(this);
        this.brokerCount = 1;
        this.kafkaClientSaslMechanism = "PLAIN";
        this.kafkaServerSaslMechanisms = new .colon.colon((Object)this.kafkaClientSaslMechanism(), (List)Nil$.MODULE$);
        this.kafkaServerJaasEntryName = new StringBuilder(1).append(this.listenerName().value().toLowerCase(Locale.ROOT)).append(".").append(JaasTestUtils$.MODULE$.KafkaServerContextName()).toString();
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "2.8");
        this.producerConfig().setProperty("linger.ms", "10");
        this.producerConfig().setProperty("compression.type", "gzip");
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
        Statics.releaseFence();
    }

    public static final /* synthetic */ Object $anonfun$maxKafkaMetricValue$1$adapted(Iterable matchingMetrics) {
        return BoxesRunTime.boxToDouble((double)MetricsTest.$anonfun$maxKafkaMetricValue$1(matchingMetrics));
    }

    public static final /* synthetic */ Object $anonfun$verifyClientVersionMetrics$2$adapted(String entity$1, String name$1, Iterable matchingMetrics) {
        MetricsTest.$anonfun$verifyClientVersionMetrics$2(entity$1, name$1, matchingMetrics);
        return BoxedUnit.UNIT;
    }
}

