/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import kafka.api.AdminClientWithPoliciesIntegrationTest$;
import kafka.api.PlaintextAdminIntegrationTest$;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@Timeout(value=120L)
@ScalaSignature(bytes="\u0006\u0005\t%d\u0001B\u0011#\u0001\u001dBQ\u0001\u000e\u0001\u0005\u0002UB\u0011\u0002\u000f\u0001A\u0002\u0003\u0007I\u0011A\u001d\t\u0013\u001d\u0003\u0001\u0019!a\u0001\n\u0003A\u0005\"C)\u0001\u0001\u0004\u0005\t\u0015)\u0003;\u0011\u001d\u0011\u0006A1A\u0005\u0002MCaa\u0016\u0001!\u0002\u0013!\u0006\"\u0002-\u0001\t\u0003J\u0006\"B5\u0001\t\u0003R\u0007\"B8\u0001\t\u0003\u0001\bbBA\u000b\u0001\u0011\u0005\u0013q\u0003\u0005\b\u0003c\u0001A\u0011IA\u001a\u0011\u001d\tY\u0005\u0001C\u0005\u0003\u001bBq!a\u0015\u0001\t\u0003\t)\u0006C\u0004\u0002\n\u0002!\t!a#\t\u000f\u0005U\u0005\u0001\"\u0001\u0002\u0018\u001e9\u0011Q\u0016\u0012\t\u0002\u0005=fAB\u0011#\u0011\u0003\t\t\f\u0003\u00045#\u0011\u0005\u0011\u0011\u0018\u0005\n\u0003w\u000b\"\u0019!C\u0001\u0003{C\u0001\"!9\u0012A\u0003%\u0011q\u0018\u0005\b\u0003G\fB\u0011AAs\r\u0019\ti0\u0005\u0001\u0002\u0000\"1AG\u0006C\u0001\u0005\u000fA1B!\u0004\u0017\u0001\u0004\u0005\r\u0011\"\u0001\u0003\u0010!Y!q\u0006\fA\u0002\u0003\u0007I\u0011\u0001B\u0019\u0011-\u0011yB\u0006a\u0001\u0002\u0003\u0006KA!\u0005\t\u0013\tub\u00031A\u0005\u0002\t}\u0002\"\u0003B$-\u0001\u0007I\u0011\u0001B%\u0011!\u0011iE\u0006Q!\n\t\u0005\u0003b\u0002B(-\u0011\u0005!\u0011\u000b\u0005\b\u0005?2B\u0011\u0001B1\u0011\u0019\u00119G\u0006C\u0001U\n1\u0013\tZ7j]\u000ec\u0017.\u001a8u/&$\b\u000eU8mS\u000eLWm]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005\r\"\u0013aA1qS*\tQ%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Ac\u0006\u0005\u0002*Y5\t!F\u0003\u0002,I\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0013\ti#F\u0001\fLC\u001a\\\u0017mU3sm\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t!\ty#'D\u00011\u0015\t\tD%A\u0003vi&d7/\u0003\u00024a\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u00017!\t9\u0004!D\u0001#\u0003\u0019\u0019G.[3oiV\t!\b\u0005\u0002<\u000b6\tAH\u0003\u0002>}\u0005)\u0011\rZ7j]*\u0011q\bQ\u0001\bG2LWM\u001c;t\u0015\t)\u0013I\u0003\u0002C\u0007\u00061\u0011\r]1dQ\u0016T\u0011\u0001R\u0001\u0004_J<\u0017B\u0001$=\u0005\u0015\tE-\\5o\u0003)\u0019G.[3oi~#S-\u001d\u000b\u0003\u0013>\u0003\"AS'\u000e\u0003-S\u0011\u0001T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001d.\u0013A!\u00168ji\"9\u0001kAA\u0001\u0002\u0004Q\u0014a\u0001=%c\u000591\r\\5f]R\u0004\u0013a\u00032s_.,'oQ8v]R,\u0012\u0001\u0016\t\u0003\u0015VK!AV&\u0003\u0007%sG/\u0001\u0007ce>\\WM]\"pk:$\b%A\u0003tKR,\u0006\u000f\u0006\u0002J5\")1l\u0002a\u00019\u0006AA/Z:u\u0013:4w\u000e\u0005\u0002^G6\taL\u0003\u0002$?*\u0011\u0001-Y\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u00117)A\u0003kk:LG/\u0003\u0002e=\nAA+Z:u\u0013:4w\u000e\u000b\u0002\bMB\u0011QlZ\u0005\u0003Qz\u0013!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^tG#A%)\u0005!a\u0007CA/n\u0013\tqgLA\u0005BMR,'/R1dQ\u0006a1M]3bi\u0016\u001cuN\u001c4jOV\t\u0011\u000fE\u0003sof\fI!D\u0001t\u0015\t!X/\u0001\u0003vi&d'\"\u0001<\u0002\t)\fg/Y\u0005\u0003qN\u00141!T1q!\rQ\u00181\u0001\b\u0003w~\u0004\"\u0001`&\u000e\u0003uT!A \u0014\u0002\rq\u0012xn\u001c;?\u0013\r\t\taS\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0011q\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u00051\n\u0005\u0003\u0002\f\u0005EQBAA\u0007\u0015\r\ty!^\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u0014\u00055!AB(cU\u0016\u001cG/A\bhK:,'/\u0019;f\u0007>tg-[4t+\t\tI\u0002\u0005\u0004\u0002\u001c\u0005\u0005\u0012QE\u0007\u0003\u0003;Q1!a\bL\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003G\tiBA\u0002TKF\u0004B!a\n\u0002.5\u0011\u0011\u0011\u0006\u0006\u0004\u0003W!\u0013AB:feZ,'/\u0003\u0003\u00020\u0005%\"aC&bM.\f7i\u001c8gS\u001e\fac\u001b:bMR\u001cuN\u001c;s_2dWM]\"p]\u001aLwm\u001d\u000b\u0003\u0003k\u0001b!a\u000e\u0002B\u0005\u0015c\u0002BA\u001d\u0003{q1\u0001`A\u001e\u0013\u0005a\u0015bAA \u0017\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u0012\u0003\u0007R1!a\u0010L!\r\u0011\u0018qI\u0005\u0004\u0003\u0013\u001a(A\u0003)s_B,'\u000f^5fg\u0006\u0019rN^3se&$WMT8eK\u000e{gNZ5hgR\u0019\u0011*a\u0014\t\u000f\u0005EC\u00021\u0001\u0002F\u0005)\u0001O]8qg\u0006)B/Z:u-\u0006d\u0017\u000eZ!mi\u0016\u00148i\u001c8gS\u001e\u001cHcA%\u0002X!1\u0011\u0011L\u0007A\u0002e\fa!];peVl\u0007fB\u0007\u0002^\u00055\u0014q\u000e\t\u0005\u0003?\nI'\u0004\u0002\u0002b)!\u00111MA3\u0003!\u0001(o\u001c<jI\u0016\u0014(bAA4?\u00061\u0001/\u0019:b[NLA!a\u001b\u0002b\tYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONdC!!\u001d\u0002v\u0005\u0012\u00111O\u0001\u0003u.\f#!a\u001e\u0002\u000b-\u0014\u0018M\u001a;)\u000f5\tY(a!\u0002\u0006B!\u0011QPA@\u001b\t\t)'\u0003\u0003\u0002\u0002\u0006\u0015$!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\t\t9)\u0001\r|I&\u001c\b\u000f\\1z\u001d\u0006lW- \u0018rk>\u0014X/\\\u001f|au\fq\u0003^3ti&sg/\u00197jI\u0006cG/\u001a:D_:4\u0017nZ:\u0015\u0007%\u000bi\t\u0003\u0004\u0002Z9\u0001\r!\u001f\u0015\b\u001d\u0005u\u0013QNAIY\u0011\t\t(!\u001e)\u000f9\tY(a!\u0002\u0006\u0006\u0011C/Z:u\u0013:4\u0018\r\\5e\u00032$XM]\"p]\u001aLwm\u001d#vKR{\u0007k\u001c7jGf$2!SAM\u0011\u0019\tIf\u0004a\u0001s\":q\"!\u0018\u0002n\u0005uE\u0006BA9\u0003kBsaDA>\u0003\u0007\u000b)\tK\u0004\u0001\u0003G\u000bI+a+\u0011\u0007u\u000b)+C\u0002\u0002(z\u0013q\u0001V5nK>,H/A\u0003wC2,XMH\u0001y\u0003\u0019\nE-\\5o\u00072LWM\u001c;XSRD\u0007k\u001c7jG&,7/\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\t\u0003oE\u00192!EAZ!\rQ\u0015QW\u0005\u0004\u0003o[%AB!osJ+g\r\u0006\u0002\u00020\u0006Ya/\u00197jI\u0006$\u0018n\u001c8t+\t\ty\f\u0005\u0004\u0002B\u0006\u001d\u00171Z\u0007\u0003\u0003\u0007TA!!2\u0002\u001e\u00059Q.\u001e;bE2,\u0017\u0002BAe\u0003\u0007\u0014!\u0002T5ti\n+hMZ3s!\u0011\ti-a7\u000f\t\u0005=\u0017q[\u0007\u0003\u0003#TA!a5\u0002V\u00061\u0001o\u001c7jGfT1!a\u000bA\u0013\u0011\tI.!5\u0002#\u0005cG/\u001a:D_:4\u0017n\u001a)pY&\u001c\u00170\u0003\u0003\u0002^\u0006}'a\u0004*fcV,7\u000f^'fi\u0006$\u0017\r^1\u000b\t\u0005e\u0017\u0011[\u0001\rm\u0006d\u0017\u000eZ1uS>t7\u000fI\u0001\u0017m\u0006d\u0017\u000eZ1uS>t7OR8s%\u0016\u001cx.\u001e:dKR!\u0011q]Au!\u0019\t9$!\u0011\u0002L\"9\u00111^\u000bA\u0002\u00055\u0018\u0001\u0003:fg>,(oY3\u0011\t\u0005=\u0018\u0011`\u0007\u0003\u0003cTA!a=\u0002v\u000611m\u001c8gS\u001eT1!a>A\u0003\u0019\u0019w.\\7p]&!\u00111`Ay\u00059\u0019uN\u001c4jOJ+7o\\;sG\u0016\u0014a\u0001U8mS\u000eL8#\u0002\f\u0002\n\t\u0005\u0001\u0003BAh\u0005\u0007IAA!\u0002\u0002R\n\t\u0012\t\u001c;fe\u000e{gNZ5h!>d\u0017nY=\u0015\u0005\t%\u0001c\u0001B\u0006-5\t\u0011#A\u0004d_:4\u0017nZ:\u0016\u0005\tE\u0001\u0007\u0002B\n\u00057\u0001bA\u001fB\u000bs\n]\u0011b\u0001=\u0002\bA!!\u0011\u0004B\u000e\u0019\u0001!1B!\b\u001b\u0003\u0003\u0005\tQ!\u0001\u0003\"\t\u0019q\fJ\u0019\u0002\u0011\r|gNZ5hg\u0002\nBAa\t\u0003*A\u0019!J!\n\n\u0007\t\u001d2JA\u0004O_RD\u0017N\\4\u0011\u0007)\u0013Y#C\u0002\u0003.-\u00131!\u00118z\u0003-\u0019wN\u001c4jON|F%Z9\u0015\u0007%\u0013\u0019\u0004\u0003\u0005Q3\u0005\u0005\t\u0019\u0001B\u001ba\u0011\u00119Da\u000f\u0011\ri\u0014)\"\u001fB\u001d!\u0011\u0011IBa\u000f\u0005\u0019\tu!1GA\u0001\u0002\u0003\u0015\tA!\t\u0002\r\rdwn]3e+\t\u0011\t\u0005E\u0002K\u0005\u0007J1A!\u0012L\u0005\u001d\u0011un\u001c7fC:\f!b\u00197pg\u0016$w\fJ3r)\rI%1\n\u0005\t!r\t\t\u00111\u0001\u0003B\u000591\r\\8tK\u0012\u0004\u0013!C2p]\u001aLw-\u001e:f)\rI%1\u000b\u0005\b\u0005\u001bq\u0002\u0019\u0001B+a\u0011\u00119Fa\u0017\u0011\u000bI<\u0018P!\u0017\u0011\t\te!1\f\u0003\r\u0005;\u0012\u0019&!A\u0001\u0002\u000b\u0005!\u0011\u0005\u0002\u0004?\u0012\u0012\u0014\u0001\u0003<bY&$\u0017\r^3\u0015\u0007%\u0013\u0019\u0007C\u0004\u0003f}\u0001\r!a3\u0002\u001fI,\u0017/^3ti6+G/\u00193bi\u0006\fQa\u00197pg\u0016\u0004")
public class AdminClientWithPoliciesIntegrationTest
extends KafkaServerTestHarness {
    private Admin client;
    private final int brokerCount;

    public static scala.collection.immutable.Seq<AlterConfigPolicy.RequestMetadata> validationsForResource(ConfigResource resource) {
        return AdminClientWithPoliciesIntegrationTest$.MODULE$.validationsForResource(resource);
    }

    public static ListBuffer<AlterConfigPolicy.RequestMetadata> validations() {
        return AdminClientWithPoliciesIntegrationTest$.MODULE$.validations();
    }

    public Admin client() {
        return this.client;
    }

    public void client_$eq(Admin x$1) {
        this.client = x$1;
    }

    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.brokers(), 15000L);
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.client() != null) {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"AdminClient");
        }
        super.tearDown();
    }

    public java.util.Map<String, Object> createConfig() {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.bootstrapServers(this.bootstrapServers$default$1()))}))).asJava();
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Seq<Properties> configs = TestUtils$.MODULE$.createBrokerConfigs(this.brokerCount(), this.zkConnectOrNull(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false);
        configs.foreach((Function1 & Serializable)props -> {
            this.overrideNodeConfigs(props);
            return BoxedUnit.UNIT;
        });
        return (Seq)configs.map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
    }

    public scala.collection.immutable.Seq<Properties> kraftControllerConfigs() {
        Properties props = new Properties();
        this.overrideNodeConfigs(props);
        return new .colon.colon((Object)props, (List)Nil$.MODULE$);
    }

    private void overrideNodeConfigs(Properties props) {
        props.put(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), Policy.class);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testValidAlterConfigs(String quorum) {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "describe-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topicConfig1 = new Properties();
        topicConfig1.setProperty("max.message.bytes", "500000");
        topicConfig1.setProperty("retention.ms", "60000000");
        this.createTopic(topic1, 1, 1, topicConfig1, this.createTopic$default$5(), this.createTopic$default$6());
        String topic2 = "describe-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, 1, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        PlaintextAdminIntegrationTest$.MODULE$.checkValidAlterConfigs(this.client(), this, topicResource1, topicResource2);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testInvalidAlterConfigs(String quorum) {
        this.client_$eq(Admin.create(this.createConfig()));
        PlaintextAdminIntegrationTest$.MODULE$.checkInvalidAlterConfigs(this, this.client());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testInvalidAlterConfigsDueToPolicy(String quorum) {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "invalid-alter-configs-due-to-policy-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        this.createTopic(topic1, 1, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        String topic2 = "invalid-alter-configs-due-to-policy-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, 1, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        String topic3 = "invalid-alter-configs-due-to-policy-topic-3";
        ConfigResource topicResource3 = new ConfigResource(ConfigResource.Type.TOPIC, topic3);
        this.createTopic(topic3, 1, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(((KafkaBroker)this.brokers().head()).config().brokerId()));
        java.util.List brokerConfigs = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConfigEntry(KafkaConfig$.MODULE$.MessageMaxBytesProp(), "50000"), (List)Nil$.MODULE$)).asJava();
        this.client().alterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigs))}))).asJava()).all().get();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.MessageMaxBytesProp()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(((AlterConfigPolicy.RequestMetadata)AdminClientWithPoliciesIntegrationTest$.MODULE$.validationsForResource(brokerResource).head()).configs().keySet()).asScala());
        AdminClientWithPoliciesIntegrationTest$.MODULE$.validations().clear();
        java.util.List topicConfigEntries1 = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConfigEntry("min.cleanable.dirty.ratio", "0.9"), (List)new .colon.colon((Object)new ConfigEntry("min.insync.replicas", "2"), (List)Nil$.MODULE$))).asJava();
        java.util.List topicConfigEntries2 = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConfigEntry("min.cleanable.dirty.ratio", "0.8"), (List)Nil$.MODULE$)).asJava();
        java.util.List topicConfigEntries3 = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConfigEntry("min.insync.replicas", "-1"), (List)Nil$.MODULE$)).asJava();
        java.util.List brokerConfigEntries = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConfigEntry(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "12313"), (List)Nil$.MODULE$)).asJava();
        AlterConfigsResult alterResult = this.client().alterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource3), (Object)new Config((Collection)topicConfigEntries3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigEntries))}))).asJava());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topicResource1), PolicyViolationException.class, (Option<String>)None$.MODULE$);
        ((KafkaFuture)alterResult.values().get(topicResource2)).get();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topicResource3), InvalidConfigurationException.class, (Option<String>)None$.MODULE$);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(brokerResource), InvalidRequestException.class, (Option<String>)None$.MODULE$);
        Assertions.assertTrue((boolean)AdminClientWithPoliciesIntegrationTest$.MODULE$.validationsForResource(brokerResource).isEmpty(), (String)"Should not see the broker resource in the AlterConfig policy when the broker configs are not being updated.");
        AdminClientWithPoliciesIntegrationTest$.MODULE$.validations().clear();
        this.ensureConsistentKRaftMetadata();
        java.util.Map configs = (java.util.Map)this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicResource1, (List)new .colon.colon((Object)topicResource2, (List)new .colon.colon((Object)topicResource3, (List)new .colon.colon((Object)brokerResource, (List)Nil$.MODULE$))))).asJava()).all().get();
        Assertions.assertEquals((int)4, (int)configs.size());
        Assertions.assertEquals((Object)Double.toString(0.5), (Object)((Config)configs.get(topicResource1)).get("min.cleanable.dirty.ratio").value());
        Assertions.assertEquals((Object)Integer.toString(1), (Object)((Config)configs.get(topicResource1)).get("min.insync.replicas").value());
        Assertions.assertEquals((Object)"0.8", (Object)((Config)configs.get(topicResource2)).get("min.cleanable.dirty.ratio").value());
        Assertions.assertNull((Object)((Config)configs.get(brokerResource)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
        topicConfigEntries2 = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConfigEntry("min.cleanable.dirty.ratio", "0.7"), (List)Nil$.MODULE$)).asJava();
        alterResult = this.client().alterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigEntries)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource3), (Object)new Config((Collection)topicConfigEntries3))}))).asJava(), new AlterConfigsOptions().validateOnly(true));
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topicResource1), PolicyViolationException.class, (Option<String>)None$.MODULE$);
        ((KafkaFuture)alterResult.values().get(topicResource2)).get();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topicResource3), InvalidConfigurationException.class, (Option<String>)None$.MODULE$);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(brokerResource), InvalidRequestException.class, (Option<String>)None$.MODULE$);
        Assertions.assertTrue((boolean)AdminClientWithPoliciesIntegrationTest$.MODULE$.validationsForResource(brokerResource).isEmpty(), (String)"Should not see the broker resource in the AlterConfig policy when the broker configs are not being updated.");
        AdminClientWithPoliciesIntegrationTest$.MODULE$.validations().clear();
        this.ensureConsistentKRaftMetadata();
        configs = (java.util.Map)this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicResource1, (List)new .colon.colon((Object)topicResource2, (List)new .colon.colon((Object)topicResource3, (List)new .colon.colon((Object)brokerResource, (List)Nil$.MODULE$))))).asJava()).all().get();
        Assertions.assertEquals((int)4, (int)configs.size());
        Assertions.assertEquals((Object)Double.toString(0.5), (Object)((Config)configs.get(topicResource1)).get("min.cleanable.dirty.ratio").value());
        Assertions.assertEquals((Object)Integer.toString(1), (Object)((Config)configs.get(topicResource1)).get("min.insync.replicas").value());
        Assertions.assertEquals((Object)"0.8", (Object)((Config)configs.get(topicResource2)).get("min.cleanable.dirty.ratio").value());
        Assertions.assertNull((Object)((Config)configs.get(brokerResource)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
        alterResult = this.client().incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.MaxConnectionsProp(), "9999"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection())}))).asJava());
        alterResult.all().get();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.MaxConnectionsProp()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(((AlterConfigPolicy.RequestMetadata)AdminClientWithPoliciesIntegrationTest$.MODULE$.validationsForResource(brokerResource).head()).configs().keySet()).asScala());
    }

    public AdminClientWithPoliciesIntegrationTest() {
        this.brokerCount = 3;
    }

    public static class Policy
    implements AlterConfigPolicy {
        private scala.collection.immutable.Map<String, Object> configs;
        private boolean closed = false;

        public scala.collection.immutable.Map<String, Object> configs() {
            return this.configs;
        }

        public void configs_$eq(scala.collection.immutable.Map<String, Object> x$1) {
            this.configs = x$1;
        }

        public boolean closed() {
            return this.closed;
        }

        public void closed_$eq(boolean x$1) {
            this.closed = x$1;
        }

        public void configure(java.util.Map<String, ?> configs) {
            AdminClientWithPoliciesIntegrationTest$.MODULE$.validations().clear();
            this.configs_$eq((scala.collection.immutable.Map<String, Object>)CollectionConverters$.MODULE$.MapHasAsScala(configs).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }

        public void validate(AlterConfigPolicy.RequestMetadata requestMetadata) {
            AdminClientWithPoliciesIntegrationTest$.MODULE$.validations().append((Object)requestMetadata);
            Predef$.MODULE$.require(!this.closed(), (Function0 & Serializable)() -> "Policy should not be closed");
            Predef$.MODULE$.require(this.configs().nonEmpty(), (Function0 & Serializable)() -> "configure should have been called with non empty configs");
            Predef$.MODULE$.require(!requestMetadata.configs().isEmpty(), (Function0 & Serializable)() -> "request configs should not be empty");
            Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(requestMetadata.resource().name())), (Function0 & Serializable)() -> "resource name should not be empty");
            if (requestMetadata.configs().containsKey("min.insync.replicas")) {
                throw new PolicyViolationException("Min in sync replicas cannot be updated");
            }
        }

        public void close() {
            this.closed_$eq(true);
        }
    }
}

