/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.server.ApiRequestHandler;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRequestHandler;
import kafka.server.KafkaRequestHandler$;
import kafka.server.RequestLocal;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.log.remote.storage.RemoteStorageMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t4AAB\u0004\u0001\u0019!)1\u0003\u0001C\u0001)!)q\u0003\u0001C\u00011!)\u0011\u0006\u0001C\u00011!)1\u0006\u0001C\u0001Y!)A\t\u0001C\u0001\u000b\n92*\u00194lCJ+\u0017/^3ti\"\u000bg\u000e\u001a7feR+7\u000f\u001e\u0006\u0003\u0011%\taa]3sm\u0016\u0014(\"\u0001\u0006\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0004\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u00059\u0011A\u0005;fgR\u001c\u0015\r\u001c7cC\u000e\\G+[7j]\u001e$\u0012!\u0007\t\u0003\u001diI!aG\b\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005u\u0001\"AH\u0014\u000e\u0003}Q!\u0001I\u0011\u0002\u0007\u0005\u0004\u0018N\u0003\u0002#G\u00059!.\u001e9ji\u0016\u0014(B\u0001\u0013&\u0003\u0015QWO\\5u\u0015\u00051\u0013aA8sO&\u0011\u0001f\b\u0002\u0005)\u0016\u001cH/\u0001\u0010uKN$8)\u00197mE\u0006\u001c7\u000e\u0016:z\u0007>l\u0007\u000f\\3uK\u0006\u001bG/[8og\"\u00121!H\u0001\u000fi\u0016\u001cH\u000fV8qS\u000e\u001cF/\u0019;t)\tIR\u0006C\u0003/\t\u0001\u0007q&\u0001\u000etsN$X-\u001c*f[>$Xm\u0015;pe\u0006<W-\u00128bE2,G\r\u0005\u0002\u000fa%\u0011\u0011g\u0004\u0002\b\u0005>|G.Z1oQ\u0011!1g\u000f\u001f\u0011\u0005QJT\"A\u001b\u000b\u0005Y:\u0014\u0001\u00039s_ZLG-\u001a:\u000b\u0005a\n\u0013A\u00029be\u0006l7/\u0003\u0002;k\tYa+\u00197vKN{WO]2f\u0003!\u0011wn\u001c7fC:\u001cHFA\u001f?3\u0005\t\u0011$\u0001\u0001)\u0005\u0011\u0001\u0005CA!C\u001b\u00059\u0014BA\"8\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\f[\u0006\\WMU3rk\u0016\u001cH\u000fF\u0002G!v\u0003\"aR'\u000f\u0005![U\"A%\u000b\u0005)K\u0011a\u00028fi^|'o[\u0005\u0003\u0019&\u000baBU3rk\u0016\u001cHo\u00115b]:,G.\u0003\u0002O\u001f\n9!+Z9vKN$(B\u0001'J\u0011\u0015\tV\u00011\u0001S\u0003\u0011!\u0018.\\3\u0011\u0005M[V\"\u0001+\u000b\u0005U3\u0016!B;uS2\u001c(BA,Y\u0003\u0019\u0019w.\\7p]*\u0011!\"\u0017\u0006\u00035\u0016\na!\u00199bG\",\u0017B\u0001/U\u0005\u0011!\u0016.\\3\t\u000by+\u0001\u0019A0\u0002\u000f5,GO]5dgB\u0011q\tY\u0005\u0003C>\u0013q!T3ue&\u001c7\u000f")
public class KafkaRequestHandlerTest {
    @Test
    public void testCallbackTiming() {
        MockTime time = new MockTime();
        long startTime = time.nanoseconds();
        RequestChannel.Metrics metrics = new RequestChannel.Metrics(Option$.MODULE$.option2Iterable((Option)None$.MODULE$));
        RequestChannel requestChannel = new RequestChannel(10, "", (Time)time, metrics);
        ApiRequestHandler apiHandler = (ApiRequestHandler)Mockito.mock(ApiRequestHandler.class);
        try {
            KafkaRequestHandler handler = new KafkaRequestHandler(0, 0, (Meter)Mockito.mock(Meter.class), new AtomicInteger(1), requestChannel, apiHandler, (Time)time);
            RequestChannel.Request request = this.makeRequest((Time)time, metrics);
            requestChannel.sendRequest(request);
            apiHandler.handle((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (RequestLocal)ArgumentMatchers.any());
            Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$1 -> {
                KafkaRequestHandlerTest.$anonfun$testCallbackTiming$1(time, request, handler, x$1);
                return BoxedUnit.UNIT;
            });
            handler.run();
            Assertions.assertEquals((long)startTime, (long)request.requestDequeueTimeNanos());
            Assertions.assertEquals((long)(startTime + 2000000L), (long)request.apiLocalCompleteTimeNanos());
            Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)(startTime + 2000000L))), (Object)request.callbackRequestDequeueTimeNanos());
            Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)(startTime + 3000000L))), (Object)request.callbackRequestCompleteTimeNanos());
        }
        finally {
            metrics.close();
        }
    }

    @Test
    public void testCallbackTryCompleteActions() {
        MockTime time = new MockTime();
        RequestChannel.Metrics metrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
        ApiRequestHandler apiHandler = (ApiRequestHandler)Mockito.mock(ApiRequestHandler.class);
        RequestChannel requestChannel = new RequestChannel(10, "", (Time)time, metrics);
        KafkaRequestHandler handler = new KafkaRequestHandler(0, 0, (Meter)Mockito.mock(Meter.class), new AtomicInteger(1), requestChannel, apiHandler, (Time)time);
        IntRef handledCount = IntRef.create((int)0);
        IntRef tryCompleteActionCount = IntRef.create((int)0);
        RequestChannel.Request request = this.makeRequest((Time)time, metrics);
        requestChannel.sendRequest(request);
        apiHandler.handle((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$3 -> {
            KafkaRequestHandlerTest.$anonfun$testCallbackTryCompleteActions$1(handledCount, handler, x$3);
            return BoxedUnit.UNIT;
        });
        apiHandler.tryCompleteActions();
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$5 -> {
            KafkaRequestHandlerTest.$anonfun$testCallbackTryCompleteActions$3(tryCompleteActionCount, x$5);
            return BoxedUnit.UNIT;
        });
        handler.run();
        Assertions.assertEquals((int)1, (int)handledCount.elem);
        Assertions.assertEquals((int)1, (int)tryCompleteActionCount.elem);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testTopicStats(boolean systemRemoteStorageEnabled) {
        String topic = "topic";
        Properties props = TestUtils$.MODULE$.createDummyBrokerConfig();
        props.setProperty("remote.log.storage.system.enable", Boolean.toString(systemRemoteStorageEnabled));
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats(Optional.of(KafkaConfig$.MODULE$.fromProps(props)));
        brokerTopicStats.topicStats(topic);
        RemoteStorageMetrics.brokerTopicStatsMetrics().forEach(metric -> {
            if (systemRemoteStorageEnabled) {
                Assertions.assertTrue((boolean)brokerTopicStats.topicStats(topic).metricMap().contains((Object)metric.getName()));
                return;
            }
            Assertions.assertFalse((boolean)brokerTopicStats.topicStats(topic).metricMap().contains((Object)metric.getName()));
        });
    }

    public RequestChannel.Request makeRequest(Time time, RequestChannel.Metrics metrics) {
        RequestHeader requestHeader = (RequestHeader)Mockito.mock(RequestHeader.class);
        Mockito.when((Object)requestHeader.apiKey()).thenReturn((Object)ApiKeys.API_VERSIONS);
        Mockito.when((Object)BoxesRunTime.boxToShort((short)requestHeader.apiVersion())).thenReturn((Object)BoxesRunTime.boxToShort((short)((short)0)));
        RequestContext context = new RequestContext(requestHeader, "0", (InetAddress)Mockito.mock(InetAddress.class), new KafkaPrincipal("", ""), new ListenerName(""), SecurityProtocol.PLAINTEXT, (ClientInformation)Mockito.mock(ClientInformation.class), false);
        return new RequestChannel.Request(0, context, time.nanoseconds(), (MemoryPool)Mockito.mock(MemoryPool.class), ByteBuffer.allocate(0), metrics, (Option)None$.MODULE$);
    }

    private static final void callback$1(int ms, MockTime time$1, KafkaRequestHandler handler$1) {
        time$1.sleep((long)ms);
        handler$1.stop();
    }

    public static final /* synthetic */ void $anonfun$testCallbackTiming$1(MockTime time$1, RequestChannel.Request request$1, KafkaRequestHandler handler$1, InvocationOnMock x$1) {
        time$1.sleep(2L);
        KafkaRequestHandler$.MODULE$.wrap((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> KafkaRequestHandlerTest.callback$1(x$2, time$1, handler$1)).apply$mcVI$sp(1);
        request$1.apiLocalCompleteTimeNanos_$eq(time$1.nanoseconds());
    }

    private static final void callback$2(int x, KafkaRequestHandler handler$2) {
        handler$2.stop();
    }

    public static final /* synthetic */ void $anonfun$testCallbackTryCompleteActions$1(IntRef handledCount$1, KafkaRequestHandler handler$2, InvocationOnMock x$3) {
        ++handledCount$1.elem;
        KafkaRequestHandler$.MODULE$.wrap((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> KafkaRequestHandlerTest.callback$2(x$4, handler$2)).apply$mcVI$sp(1);
    }

    public static final /* synthetic */ void $anonfun$testCallbackTryCompleteActions$3(IntRef tryCompleteActionCount$1, InvocationOnMock x$5) {
        ++tryCompleteActionCount$1.elem;
    }
}

