/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.Properties;
import java.util.regex.Pattern;
import kafka.log.LocalLog;
import kafka.log.LocalLog$;
import kafka.log.LocalLogTest;
import kafka.log.LocalLogTest$KeyValue$;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.LogSegments;
import kafka.log.LogTestUtils$;
import kafka.log.LogTruncation;
import kafka.log.SegmentDeletionReason;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011=c\u0001B6m\u0001EDQ\u0001\u001f\u0001\u0005\u0002eD\u0011\u0002 \u0001A\u0002\u0003\u0007I\u0011A?\t\u0017\u0005%\u0001\u00011AA\u0002\u0013\u0005\u00111\u0002\u0005\u000b\u0003/\u0001\u0001\u0019!A!B\u0013q\b\"CA\r\u0001\t\u0007I\u0011AA\u000e\u0011!\ti\u0003\u0001Q\u0001\n\u0005u\u0001\"CA\u0018\u0001\t\u0007I\u0011AA\u000e\u0011!\t\t\u0004\u0001Q\u0001\n\u0005u\u0001\"CA\u001a\u0001\t\u0007I\u0011AA\u001b\u0011!\ti\u0005\u0001Q\u0001\n\u0005]\u0002\"CA(\u0001\t\u0007I\u0011AA)\u0011!\t)\u0007\u0001Q\u0001\n\u0005M\u0003\"CA4\u0001\t\u0007I\u0011AA5\u0011!\tI\b\u0001Q\u0001\n\u0005-\u0004\u0002C7\u0001\u0005\u0004%\t!a\u001f\t\u0011\u0005\r\u0005\u0001)A\u0005\u0003{Bq!!\"\u0001\t\u0003\t9\tC\u0004\u0002 \u0002!\t!a\"\u0007\r\u0005%\u0006\u0001QAV\u0011)\tYm\u0005BK\u0002\u0013\u0005\u0011Q\u001a\u0005\u000b\u0003?\u001c\"\u0011#Q\u0001\n\u0005=\u0007BCAq'\tU\r\u0011\"\u0001\u0002N\"Q\u00111]\n\u0003\u0012\u0003\u0006I!a4\t\ra\u001cB\u0011AAs\u0011\u001d\tyo\u0005C\u0001\u0003cD\u0011Ba\u0004\u0014#\u0003%\tA!\u0005\t\u0013\t\u001d2#!A\u0005\u0002\t%\u0002\"\u0003B\u0018'E\u0005I\u0011\u0001B\u0019\u0011%\u0011)dEI\u0001\n\u0003\u0011\t\u0004C\u0005\u00038M\t\t\u0011\"\u0011\u0003:!I!QI\n\u0002\u0002\u0013\u0005!q\t\u0005\n\u0005\u001f\u001a\u0012\u0011!C\u0001\u0005#B\u0011Ba\u0017\u0014\u0003\u0003%\tE!\u0018\t\u0013\t-4#!A\u0005\u0002\t5\u0004\"\u0003B<'\u0005\u0005I\u0011\tB=\u0011%\u0011ihEA\u0001\n\u0003\u0012y\bC\u0005\u0003\u0002N\t\t\u0011\"\u0011\u0003\u0004\"I!QQ\n\u0002\u0002\u0013\u0005#qQ\u0004\b\u0005\u0017\u0003\u0001\u0012\u0001BG\r\u001d\tI\u000b\u0001E\u0001\u0005\u001fCa\u0001\u001f\u0015\u0005\u0002\tU\u0005b\u0002BLQ\u0011\u0005!\u0011\u0014\u0005\n\u0005GC\u0013\u0011!CA\u0005KC\u0011Ba+)\u0003\u0003%\tI!,\t\u000f\t}\u0006\u0001\"\u0003\u0003B\"9!q\u001a\u0001\u0005\n\tE\u0007b\u0002Bm\u0001\u0011%!1\u001c\u0005\n\u0005K\u0004\u0011\u0013!C\u0005\u0005OD\u0011Ba;\u0001#\u0003%IA!\u0005\t\u000f\t5\b\u0001\"\u0003\u0003p\"I1q\u0003\u0001\u0012\u0002\u0013%!q\u001d\u0005\n\u00073\u0001\u0011\u0013!C\u0005\u0005#A\u0011ba\u0007\u0001#\u0003%Ia!\b\t\u0013\r\u0005\u0002!%A\u0005\n\r\r\u0002\"CB\u0014\u0001E\u0005I\u0011BB\u0015\u0011%\u0019i\u0003AI\u0001\n\u0013\u0019\u0019\u0003C\u0004\u00040\u0001!\t!a\"\t\u000f\re\u0002\u0001\"\u0001\u0002\b\"91Q\b\u0001\u0005\u0002\u0005\u001d\u0005bBB!\u0001\u0011\u0005\u0011q\u0011\u0005\b\u0007\u000b\u0002A\u0011AAD\u0011\u001d\u0019I\u0005\u0001C\u0001\u0003\u000fCqa!\u0014\u0001\t\u0003\t9\tC\u0004\u0004R\u0001!\t!a\"\t\u000f\rU\u0003\u0001\"\u0001\u0002\b\"91\u0011\f\u0001\u0005\u0002\u0005\u001d\u0005bBB/\u0001\u0011\u0005\u0011q\u0011\u0005\b\u0007C\u0002A\u0011AAD\u0011\u001d\u0019)\u0007\u0001C\u0001\u0003\u000fCqa!\u001b\u0001\t\u0013\u0019Y\u0007C\u0004\u0004r\u0001!\t!a\"\t\u000f\rU\u0004\u0001\"\u0001\u0002\b\"91\u0011\u0010\u0001\u0005\n\rm\u0004bBB@\u0001\u0011\u0005\u0011q\u0011\u0005\b\u0007\u0007\u0003A\u0011AAD\u0011\u001d\u00199\t\u0001C\u0001\u0003\u000fCqaa#\u0001\t\u0003\t9\tC\u0004\u0004\u0010\u0002!\t!a\"\t\u000f\rM\u0005\u0001\"\u0001\u0002\b\"91q\u0013\u0001\u0005\u0002\u0005\u001d\u0005bBBN\u0001\u0011\u0005\u0011q\u0011\u0005\b\u0007?\u0003A\u0011BBQ\u0011\u001d\u0019Y\u000b\u0001C\u0001\u0003\u000fCqaa,\u0001\t\u0003\t9\tC\u0004\u00044\u0002!\t!a\"\t\u000f\r]\u0006\u0001\"\u0001\u0002\b\"911\u0018\u0001\u0005\u0002\u0005\u001d\u0005bBB`\u0001\u0011\u0005\u0011q\u0011\u0005\b\u0007\u0007\u0004A\u0011AAD\u0011\u001d\u00199\r\u0001C\u0001\u0003\u000fCqaa3\u0001\t\u0003\t9\tC\u0004\u0004P\u0002!\t!a\"\t\u000f\rM\u0007\u0001\"\u0001\u0002\b\"91q\u001b\u0001\u0005\u0002\u0005\u001d\u0005bBBn\u0001\u0011\u0005\u0011q\u0011\u0005\b\u0007?\u0004A\u0011AAD\u0011\u001d\u0019\u0019\u000f\u0001C\u0001\u0003\u000fCqaa:\u0001\t\u0013\u0019I\u000fC\u0005\u0005(\u0001\t\n\u0011\"\u0003\u0005*!IAQ\u0006\u0001\u0012\u0002\u0013%Aq\u0006\u0005\n\tg\u0001\u0011\u0013!C\u0005\u0005#A\u0011\u0002\"\u000e\u0001#\u0003%Ia!\u000b\t\u0013\u0011]\u0002!%A\u0005\n\u0011e\u0002\"\u0003C\u001f\u0001E\u0005I\u0011\u0002C \u0011%!\u0019\u0005AI\u0001\n\u0013!)\u0005C\u0005\u0005J\u0001\t\n\u0011\"\u0003\u0005L\taAj\\2bY2{w\rV3ti*\u0011QN\\\u0001\u0004Y><'\"A8\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u001d\t\u0003gZl\u0011\u0001\u001e\u0006\u0002k\u0006)1oY1mC&\u0011q\u000f\u001e\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Q\bCA>\u0001\u001b\u0005a\u0017AB2p]\u001aLw-F\u0001\u007f!\ry\u0018QA\u0007\u0003\u0003\u0003Q1!a\u0001o\u0003\u0019\u0019XM\u001d<fe&!\u0011qAA\u0001\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0015\r|gNZ5h?\u0012*\u0017\u000f\u0006\u0003\u0002\u000e\u0005M\u0001cA:\u0002\u0010%\u0019\u0011\u0011\u0003;\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003+\u0019\u0011\u0011!a\u0001}\u0006\u0019\u0001\u0010J\u0019\u0002\u000f\r|gNZ5hA\u00051A/\u001c9ESJ,\"!!\b\u0011\t\u0005}\u0011\u0011F\u0007\u0003\u0003CQA!a\t\u0002&\u0005\u0011\u0011n\u001c\u0006\u0003\u0003O\tAA[1wC&!\u00111FA\u0011\u0005\u00111\u0015\u000e\\3\u0002\u000fQl\u0007\u000fR5sA\u00051An\\4ESJ\fq\u0001\\8h\t&\u0014\b%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0005\u0005]\u0002\u0003BA\u001d\u0003\u0013j!!a\u000f\u000b\t\u0005u\u0012qH\u0001\u0007G>lWn\u001c8\u000b\u0007=\f\tE\u0003\u0003\u0002D\u0005\u0015\u0013AB1qC\u000eDWM\u0003\u0002\u0002H\u0005\u0019qN]4\n\t\u0005-\u00131\b\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013\u0001\u00067pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G.\u0006\u0002\u0002TA!\u0011QKA1\u001b\t\t9FC\u0002n\u00033RA!a\u0017\u0002^\u0005I\u0011N\u001c;fe:\fGn\u001d\u0006\u0005\u0003?\ny$A\u0004ti>\u0014\u0018mZ3\n\t\u0005\r\u0014q\u000b\u0002\u0015\u0019><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0002+1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3mA\u0005AQn\\2l)&lW-\u0006\u0002\u0002lA!\u0011QNA;\u001b\t\tyG\u0003\u0003\u0002r\u0005M\u0014\u0001B;uS2TA!a\u0001\u0002@%!\u0011qOA8\u0005!iunY6US6,\u0017!C7pG.$\u0016.\\3!+\t\ti\bE\u0002|\u0003\u007fJ1!!!m\u0005!aunY1m\u0019><\u0017\u0001\u00027pO\u0002\nQa]3u+B$\"!!\u0004)\u0007E\tY\t\u0005\u0003\u0002\u000e\u0006mUBAAH\u0015\u0011\t\t*a%\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\u0016\u0006]\u0015a\u00026va&$XM\u001d\u0006\u0005\u00033\u000b)%A\u0003kk:LG/\u0003\u0003\u0002\u001e\u0006=%A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eK\u0002\u0013\u0003G\u0003B!!$\u0002&&!\u0011qUAH\u0005%\te\r^3s\u000b\u0006\u001c\u0007N\u0001\u0005LKf4\u0016\r\\;f'\u0019\u0019\"/!,\u00024B\u00191/a,\n\u0007\u0005EFOA\u0004Qe>$Wo\u0019;\u0011\t\u0005U\u0016Q\u0019\b\u0005\u0003o\u000b\tM\u0004\u0003\u0002:\u0006}VBAA^\u0015\r\ti\f]\u0001\u0007yI|w\u000e\u001e \n\u0003UL1!a1u\u0003\u001d\u0001\u0018mY6bO\u0016LA!a2\u0002J\na1+\u001a:jC2L'0\u00192mK*\u0019\u00111\u0019;\u0002\u0007-,\u00170\u0006\u0002\u0002PB!\u0011\u0011[Am\u001d\u0011\t\u0019.!6\u0011\u0007\u0005eF/C\u0002\u0002XR\fa\u0001\u0015:fI\u00164\u0017\u0002BAn\u0003;\u0014aa\u0015;sS:<'bAAli\u0006!1.Z=!\u0003\u00151\u0018\r\\;f\u0003\u00191\u0018\r\\;fAQ1\u0011q]Av\u0003[\u00042!!;\u0014\u001b\u0005\u0001\u0001bBAf1\u0001\u0007\u0011q\u001a\u0005\b\u0003CD\u0002\u0019AAh\u0003!!xNU3d_J$G\u0003BAz\u0003\u007f\u0004B!!>\u0002|6\u0011\u0011q\u001f\u0006\u0005\u0003s\fY$\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003{\f9P\u0001\u0007TS6\u0004H.\u001a*fG>\u0014H\rC\u0005\u0003\u0002e\u0001J\u00111\u0001\u0003\u0004\u0005IA/[7fgR\fW\u000e\u001d\t\u0006g\n\u0015!\u0011B\u0005\u0004\u0005\u000f!(\u0001\u0003\u001fcs:\fW.\u001a \u0011\u0007M\u0014Y!C\u0002\u0003\u000eQ\u0014A\u0001T8oO\u0006\u0011Bo\u001c*fG>\u0014H\r\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011\u0019B\u000b\u0003\u0003\n\tU1F\u0001B\f!\u0011\u0011IBa\t\u000e\u0005\tm!\u0002\u0002B\u000f\u0005?\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u0005B/\u0001\u0006b]:|G/\u0019;j_:LAA!\n\u0003\u001c\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\t\r|\u0007/\u001f\u000b\u0007\u0003O\u0014YC!\f\t\u0013\u0005-7\u0004%AA\u0002\u0005=\u0007\"CAq7A\u0005\t\u0019AAh\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa\r+\t\u0005='QC\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!1\b\t\u0005\u0005{\u0011\u0019%\u0004\u0002\u0003@)!!\u0011IA\u0013\u0003\u0011a\u0017M\\4\n\t\u0005m'qH\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005\u0013\u00022a\u001dB&\u0013\r\u0011i\u0005\u001e\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005'\u0012I\u0006E\u0002t\u0005+J1Aa\u0016u\u0005\r\te.\u001f\u0005\n\u0003+\u0001\u0013\u0011!a\u0001\u0005\u0013\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005?\u0002bA!\u0019\u0003h\tMSB\u0001B2\u0015\r\u0011)\u0007^\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B5\u0005G\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!q\u000eB;!\r\u0019(\u0011O\u0005\u0004\u0005g\"(a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003+\u0011\u0013\u0011!a\u0001\u0005'\n!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!1\bB>\u0011%\t)bIA\u0001\u0002\u0004\u0011I%\u0001\u0005iCND7i\u001c3f)\t\u0011I%\u0001\u0005u_N#(/\u001b8h)\t\u0011Y$\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005_\u0012I\tC\u0005\u0002\u0016\u0019\n\t\u00111\u0001\u0003T\u0005A1*Z=WC2,X\rE\u0002\u0002j\"\u001aB\u0001\u000b:\u0003\u0012B!\u0011q\u0004BJ\u0013\u0011\t9-!\t\u0015\u0005\t5\u0015A\u00034s_6\u0014VmY8sIR!\u0011q\u001dBN\u0011\u001d\tIP\u000ba\u0001\u0005;\u0003B!!>\u0003 &!!\u0011UA|\u0005\u0019\u0011VmY8sI\u0006)\u0011\r\u001d9msR1\u0011q\u001dBT\u0005SCq!a3,\u0001\u0004\ty\rC\u0004\u0002b.\u0002\r!a4\u0002\u000fUt\u0017\r\u001d9msR!!q\u0016B^!\u0015\u0019(\u0011\u0017B[\u0013\r\u0011\u0019\f\u001e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000fM\u00149,a4\u0002P&\u0019!\u0011\u0018;\u0003\rQ+\b\u000f\\33\u0011%\u0011i\fLA\u0001\u0002\u0004\t9/A\u0002yIA\nAb\u001b<t)>\u0014VmY8sIN$BAa1\u0003JB1\u0011Q\u0017Bc\u0003gLAAa2\u0002J\nA\u0011\n^3sC\ndW\rC\u0004\u0003L6\u0002\rA!4\u0002\u0013-,\u0017PV1mk\u0016\u001c\bCBA[\u0005\u000b\f9/\u0001\u0007sK\u000e|'\u000fZ:U_.38\u000f\u0006\u0003\u0003N\nM\u0007b\u0002Bk]\u0001\u0007!q[\u0001\be\u0016\u001cwN\u001d3t!\u0019\t)L!2\u0003\u001e\u0006i\u0011\r\u001d9f]\u0012\u0014VmY8sIN$\u0002\"!\u0004\u0003^\n}'\u0011\u001d\u0005\b\u0005+|\u0003\u0019\u0001Bb\u0011!iw\u0006%AA\u0002\u0005u\u0004\"\u0003Br_A\u0005\t\u0019\u0001B\u0005\u00035Ig.\u001b;jC2|eMZ:fi\u00069\u0012\r\u001d9f]\u0012\u0014VmY8sIN$C-\u001a4bk2$HEM\u000b\u0003\u0005STC!! \u0003\u0016\u00059\u0012\r\u001d9f]\u0012\u0014VmY8sIN$C-\u001a4bk2$HeM\u0001\fe\u0016\fGMU3d_J$7\u000f\u0006\b\u0003r\n](\u0011 B\u007f\u0007\u0007\u00199aa\u0005\u0011\t\u0005U#1_\u0005\u0005\u0005k\f9FA\u0007GKR\u001c\u0007\u000eR1uC&sgm\u001c\u0005\t[J\u0002\n\u00111\u0001\u0002~!I!1 \u001a\u0011\u0002\u0003\u0007!\u0011B\u0001\fgR\f'\u000f^(gMN,G\u000fC\u0005\u0003\u0000J\u0002J\u00111\u0001\u0004\u0002\u0005IQ.\u0019=MK:<G\u000f\u001b\t\u0006g\n\u0015!\u0011\n\u0005\n\u0007\u000b\u0011\u0004\u0013!a\u0001\u0005_\nQ\"\\5o\u001f:,W*Z:tC\u001e,\u0007\"CB\u0005eA%\t\u0019AB\u0006\u0003Ei\u0017\r_(gMN,G/T3uC\u0012\fG/\u0019\t\u0006g\n\u00151Q\u0002\t\u0005\u0003+\u001ay!\u0003\u0003\u0004\u0012\u0005]#!\u0005'pO>3gm]3u\u001b\u0016$\u0018\rZ1uC\"I1Q\u0003\u001a\u0011\u0002\u0003\u0007!qN\u0001\u0013S:\u001cG.\u001e3f\u0003\n|'\u000f^3e)bt7/A\u000bsK\u0006$'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0002+I,\u0017\r\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005)\"/Z1e%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\u001aTCAB\u0010U\u0011\u0011IE!\u0006\u0002+I,\u0017\r\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u00111Q\u0005\u0016\u0005\u0005_\u0012)\"A\u000bsK\u0006$'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\r-\"\u0006BB\u0007\u0005+\tQC]3bIJ+7m\u001c:eg\u0012\"WMZ1vYR$c'\u0001\u000fuKN$Hj\\4EK2,G/Z*fO6,g\u000e^:Tk\u000e\u001cWm]:)\u0007e\u001a\u0019\u0004\u0005\u0003\u0002\u000e\u000eU\u0012\u0002BB\u001c\u0003\u001f\u0013A\u0001V3ti\u0006QB/Z:u%>dG.R7qif\f5\r^5wKN+w-\\3oi\"\u001a!ha\r\u0002mQ,7\u000f\u001e'pO\u0012+G.\u001a;f\t&\u00148+^2dKN\u001cx\u000b[3o\u000b6\u0004H/_!oI\u001a\u000b\u0017\u000e\\;sK^CWM\u001c(p]\u0016k\u0007\u000f^=)\u0007m\u001a\u0019$\u0001\tuKN$X\u000b\u001d3bi\u0016\u001cuN\u001c4jO\"\u001aAha\r\u00021Q,7\u000f\u001e'pO\u0012K'OU3oC6,Gk\u001c(fo\u0012K'\u000fK\u0002>\u0007g\tQ\u0004^3ti2{w\rR5s%\u0016t\u0017-\\3U_\u0016C\u0018n\u001d;j]\u001e$\u0015N\u001d\u0015\u0004}\rM\u0012\u0001\u0004;fgRdun\u001a$mkND\u0007fA \u00044\u0005iA/Z:u\u0019><\u0017\t\u001d9f]\u0012D3\u0001QB\u001a\u0003M!Xm\u001d;M_\u001e\u001cEn\\:f'V\u001c7-Z:tQ\r\t51G\u0001\u0017i\u0016\u001cH\u000fT8h\u00072|7/Z%eK6\u0004x\u000e^3oi\"\u001a!ia\r\u0002WQ,7\u000f\u001e'pO\u000ecwn]3GC&dWO]3XQ\u0016t\u0017J\\'f[>\u0014\u0018PQ;gM\u0016\u00148\t\\8tK\u0012D3aQB\u001a\u0003Q!Xm\u001d;M_\u001e\u001cEn\\:f\u0011\u0006tG\r\\3sg\"\u001aAia\r\u0002=Q,7\u000f\u001e'pO\u000ecwn]3IC:$G.\u001a:t\u0013\u0012,W\u000e]8uK:$\bfA#\u00044\u0005YB/Z:u%\u0016lwN^3B]\u0012$U\r\\3uKN+w-\\3oiN$B!!\u0004\u0004n!91q\u000e$A\u0002\t=\u0014aC1ts:\u001cG)\u001a7fi\u0016\fq\u0004^3tiJ+Wn\u001c<f\u0003:$G)\u001a7fi\u0016\u001cVmZ7f]R\u001c8+\u001f8dQ\r951G\u0001!i\u0016\u001cHOU3n_Z,\u0017I\u001c3EK2,G/Z*fO6,g\u000e^:Bgft7\rK\u0002I\u0007g\ta\u0003^3ti\u0012+G.\u001a;f'\u0016<W.\u001a8u\r&dWm\u001d\u000b\u0005\u0003\u001b\u0019i\bC\u0004\u0004p%\u0003\rAa\u001c\u00025Q,7\u000f\u001e#fY\u0016$XmU3h[\u0016tGOR5mKN\u001c\u0016P\\2)\u0007)\u001b\u0019$A\u000euKN$H)\u001a7fi\u0016\u001cVmZ7f]R4\u0015\u000e\\3t\u0003NLhn\u0019\u0015\u0004\u0017\u000eM\u0012a\u0007;fgR$U\r\\3uC\ndWmU3h[\u0016tGo\u001d$jYR,'\u000fK\u0002M\u0007g\ta\u0004^3ti\u0012+G.\u001a;bE2,7+Z4nK:$8/\u0013;fe\u0006$\u0018n\u001c8)\u00075\u001b\u0019$\u0001\u000euKN$8I]3bi\u0016\fe\u000e\u001a#fY\u0016$XmU3h[\u0016tG\u000fK\u0002O\u0007g\t1\u0004^3tiR\u0013XO\\2bi\u00164U\u000f\u001c7z\u0003:$7\u000b^1si\u0006#\bfA(\u00044\u0005qA/Z:u)J,hnY1uKR{\u0007f\u0001)\u00044\u0005IB/Z:u\u001d>t\u0017i\u0019;jm\u0016\u001cVmZ7f]R\u001chI]8nQ\r\t61G\u0001\u0013i>\u0004\u0018n\u0019)beRLG/[8o\u001d\u0006lW\r\u0006\u0004\u0002P\u000e\r6q\u0015\u0005\b\u0007K\u0013\u0006\u0019AAh\u0003\u0015!x\u000e]5d\u0011\u001d\u0019IK\u0015a\u0001\u0003\u001f\f\u0011\u0002]1si&$\u0018n\u001c8\u00027Q,7\u000f\u001e)beN,Gk\u001c9jGB\u000b'\u000f^5uS>tg*Y7fQ\r\u001961G\u00015i\u0016\u001cH\u000fU1sg\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:t\u0015-\\3XSRD\u0007+\u001a:j_\u00124uN\u001d#fY\u0016$X\r\u001a+pa&\u001c\u0007f\u0001+\u00044\u00059C/Z:u!\u0006\u00148/\u001a+pa&\u001c\u0007+\u0019:uSRLwN\u001c(b[\u00164uN]#naRLh*Y7fQ\r)61G\u0001#i\u0016\u001cH\u000fU1sg\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:t\u0015-\\3G_JtU\u000f\u001c7)\u0007Y\u001b\u0019$\u0001\u0018uKN$\b+\u0019:tKR{\u0007/[2QCJ$\u0018\u000e^5p]:\u000bW.\u001a$pe6K7o]5oON+\u0007/\u0019:bi>\u0014\bfA,\u00044\u0005QC/Z:u!\u0006\u00148/\u001a+pa&\u001c\u0007+\u0019:uSRLwN\u001c(b[\u00164uN]'jgNLgn\u001a+pa&\u001c\u0007f\u0001-\u00044\u0005qC/Z:u!\u0006\u00148/\u001a+pa&\u001c\u0007+\u0019:uSRLwN\u001c(b[\u00164uN]'jgNLgn\u001a)beRLG/[8oQ\rI61G\u0001/i\u0016\u001cH\u000fU1sg\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:t\u0015-\\3G_JLeN^1mS\u0012\u0004\u0016M\u001d;ji&|g\u000eK\u0002[\u0007g\t\u0001\u0007^3tiB\u000b'o]3U_BL7\rU1si&$\u0018n\u001c8OC6,gi\u001c:Fq&\u001cH/\u001b8h\u0013:4\u0018\r\\5e\t&\u0014\bfA.\u00044\u0005!B/Z:u\u0019><G)\u001a7fi\u0016$\u0015N\u001d(b[\u0016D3\u0001XB\u001a\u0003I!Xm\u001d;PM\u001a\u001cX\r\u001e$s_64\u0015\u000e\\3)\u0007u\u001b\u0019$\u0001\u0011uKN$(k\u001c7m'\u0016<W.\u001a8u)\"\fG/\u00117sK\u0006$\u00170\u0012=jgR\u001c\bf\u00010\u00044\u0005AB/Z:u\u001d\u0016<8+Z4nK:$8/\u00114uKJ\u0014v\u000e\u001c7)\u0007}\u001b\u0019$A\u0016uKN$(k\u001c7m'\u0016<W.\u001a8u\u000bJ\u0014xN],iK:tU\r\u001f;PM\u001a\u001cX\r^%t\u00132dWmZ1mQ\r\u000171G\u0001\u001bi\u0016\u001cHO\u00127vg\"Lgn\u001a(p]\u0016C\u0018n\u001d;f]R$\u0015N\u001d\u0015\u0004C\u000eM\u0012aH2sK\u0006$X\rT8dC2dunZ,ji\"\f5\r^5wKN+w-\\3oiR!\u0012QPBv\u0007_\u001c9\u0010\"\u0001\u0005\u0006\u0011%A1\u0003C\u0012\tKA\u0011b!<c!\u0003\u0005\r!!\b\u0002\u0007\u0011L'\u000f\u0003\u0004}E\u0002\u00071\u0011\u001f\t\u0005\u0003+\u001a\u00190\u0003\u0003\u0004v\u0006]#!\u0003'pO\u000e{gNZ5h\u0011%\u0019IP\u0019I\u0001\u0002\u0004\u0019Y0\u0001\u0005tK\u001elWM\u001c;t!\rY8Q`\u0005\u0004\u0007\u007fd'a\u0003'pON+w-\\3oiND\u0011\u0002b\u0001c!\u0003\u0005\rA!\u0003\u0002\u001bI,7m\u001c<fef\u0004v.\u001b8u\u0011%!9A\u0019I\u0001\u0002\u0004\u0019i!\u0001\noKb$xJ\u001a4tKRlU\r^1eCR\f\u0007\"\u0003C\u0006EB\u0005\t\u0019\u0001C\u0007\u0003%\u00198\r[3ek2,'\u000f\u0005\u0003\u0002n\u0011=\u0011\u0002\u0002C\t\u0003_\u0012\u0011bU2iK\u0012,H.\u001a:\t\u0013\u0011U!\r%AA\u0002\u0011]\u0011\u0001\u0002;j[\u0016\u0004B\u0001\"\u0007\u0005 5\u0011A1\u0004\u0006\u0005\t;\tY$A\u0003vi&d7/\u0003\u0003\u0005\"\u0011m!\u0001\u0002+j[\u0016D\u0011\"a\rc!\u0003\u0005\r!a\u000e\t\u0013\u0005=#\r%AA\u0002\u0005M\u0013!K2sK\u0006$X\rT8dC2dunZ,ji\"\f5\r^5wKN+w-\\3oi\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0005,)\"\u0011Q\u0004B\u000b\u0003%\u001a'/Z1uK2{7-\u00197M_\u001e<\u0016\u000e\u001e5BGRLg/Z*fO6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\u0011A\u0011\u0007\u0016\u0005\u0007w\u0014)\"A\u0015de\u0016\fG/\u001a'pG\u0006dGj\\4XSRD\u0017i\u0019;jm\u0016\u001cVmZ7f]R$C-\u001a4bk2$H\u0005N\u0001*GJ,\u0017\r^3M_\u000e\fG\u000eT8h/&$\b.Q2uSZ,7+Z4nK:$H\u0005Z3gCVdG\u000fJ\u001b\u0002S\r\u0014X-\u0019;f\u0019>\u001c\u0017\r\u001c'pO^KG\u000f[!di&4XmU3h[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t!YD\u000b\u0003\u0005\u000e\tU\u0011!K2sK\u0006$X\rT8dC2dunZ,ji\"\f5\r^5wKN+w-\\3oi\u0012\"WMZ1vYR$s'\u0006\u0002\u0005B)\"Aq\u0003B\u000b\u0003%\u001a'/Z1uK2{7-\u00197M_\u001e<\u0016\u000e\u001e5BGRLg/Z*fO6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%qU\u0011Aq\t\u0016\u0005\u0003o\u0011)\"A\u0015de\u0016\fG/\u001a'pG\u0006dGj\\4XSRD\u0017i\u0019;jm\u0016\u001cVmZ7f]R$C-\u001a4bk2$H%O\u000b\u0003\t\u001bRC!a\u0015\u0003\u0016\u0001")
public class LocalLogTest {
    private volatile LocalLogTest$KeyValue$ KeyValue$module;
    private KafkaConfig config;
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final TopicPartition topicPartition = new TopicPartition("test_topic", 1);
    private final LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
    private final MockTime mockTime = new MockTime();
    private final LocalLog log;

    public LocalLogTest$KeyValue$ KeyValue() {
        if (this.KeyValue$module == null) {
            this.KeyValue$lzycompute$1();
        }
        return this.KeyValue$module;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public LocalLog log() {
        return this.log;
    }

    @BeforeEach
    public void setUp() {
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var20_8 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var21_11 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var22_14 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "127.0.0.1:1", x$4, x$5, -1, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
    }

    @AfterEach
    public void tearDown() {
        try {
            this.log().close();
        }
        catch (KafkaStorageException kafkaStorageException) {}
        Utils.delete((File)this.tmpDir());
    }

    private Iterable<SimpleRecord> kvsToRecords(Iterable<KeyValue> keyValues) {
        return (Iterable)keyValues.map((Function1 & Serializable)kv -> kv.toRecord((Function0<Object>)(JFunction0.mcJ.sp & Serializable)() -> kv.toRecord$default$1()));
    }

    private Iterable<KeyValue> recordsToKvs(Iterable<Record> records) {
        return (Iterable)records.map((Function1 & Serializable)r -> this.KeyValue().fromRecord((Record)r));
    }

    /*
     * WARNING - void declaration
     */
    private void appendRecords(Iterable<SimpleRecord> records, LocalLog log, long initialOffset) {
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])records.toList().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        boolean bl = false;
        CompressionType withRecords_compressionType = CompressionType.NONE;
        Object var5_6 = null;
        simpleRecordArray = null;
        log.append(initialOffset + (long)records.size() - 1L, ((SimpleRecord)records.head()).timestamp(), initialOffset, MemoryRecords.withRecords((byte)2, (long)initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records));
    }

    private LocalLog appendRecords$default$2() {
        return this.log();
    }

    private long appendRecords$default$3() {
        return 0L;
    }

    private FetchDataInfo readRecords(LocalLog log, long startOffset, Function0<Object> maxLength, boolean minOneMessage, Function0<LogOffsetMetadata> maxOffsetMetadata, boolean includeAbortedTxns) {
        return log.read(startOffset, maxLength.apply$mcI$sp(), minOneMessage, (LogOffsetMetadata)maxOffsetMetadata.apply(), includeAbortedTxns);
    }

    private LocalLog readRecords$default$1() {
        return this.log();
    }

    private long readRecords$default$2() {
        return 0L;
    }

    private int readRecords$default$3() {
        return this.log().segments().activeSegment().size();
    }

    private boolean readRecords$default$4() {
        return false;
    }

    private LogOffsetMetadata readRecords$default$5() {
        return this.log().logEndOffsetMetadata();
    }

    private boolean readRecords$default$6() {
        return false;
    }

    @Test
    public void testLogDeleteSegmentsSuccess() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.log(), 0L);
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertFalse((boolean)ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())));
        List segmentsBeforeDelete = (List)Nil$.MODULE$.$plus$plus((IterableOnce)this.log().segments().values());
        Iterable deletedSegments = this.log().deleteAllSegments();
        Assertions.assertTrue((boolean)this.log().segments().isEmpty());
        Assertions.assertEquals((Object)segmentsBeforeDelete, (Object)deletedSegments);
        Assertions.assertThrows(KafkaStorageException.class, () -> this.log().checkIfMemoryMappedBufferClosed());
        Assertions.assertTrue((boolean)this.logDir().exists());
    }

    @Test
    public void testRollEmptyActiveSegment() {
        LogSegment oldActiveSegment = this.log().segments().activeSegment();
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertNotEquals((Object)oldActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertFalse((boolean)ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())));
        Assertions.assertTrue((boolean)oldActiveSegment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
    }

    @Test
    public void testLogDeleteDirSuccessWhenEmptyAndFailureWhenNonEmpty() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.log(), 0L);
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertFalse((boolean)ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())));
        Assertions.assertThrows(IllegalStateException.class, () -> this.log().deleteEmptyDir());
        Assertions.assertTrue((boolean)this.logDir().exists());
        this.log().deleteAllSegments();
        this.log().deleteEmptyDir();
        Assertions.assertFalse((boolean)this.logDir().exists());
    }

    @Test
    public void testUpdateConfig() {
        LogConfig oldConfig = this.log().config();
        Assertions.assertEquals((Object)oldConfig, (Object)this.log().config());
        int x$1 = oldConfig.segmentSize + 1;
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -1L;
        long x$5 = 0L;
        String x$6 = "delete";
        int x$7 = 0x10000C;
        int x$8 = 4096;
        int x$9 = 0xA00000;
        long x$10 = 60000L;
        boolean x$11 = false;
        LogConfig newConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11);
        this.log().updateConfig(newConfig);
        Assertions.assertEquals((Object)newConfig, (Object)this.log().config());
    }

    @Test
    public void testLogDirRenameToNewDir() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.log(), 0L);
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        File newLogDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        Assertions.assertTrue((boolean)this.log().renameDir(newLogDir.getName()));
        Assertions.assertFalse((boolean)this.logDir().exists());
        Assertions.assertTrue((boolean)newLogDir.exists());
        Assertions.assertEquals((Object)newLogDir, (Object)this.log().dir());
        Assertions.assertEquals((Object)newLogDir.getParent(), (Object)this.log().parentDir());
        Assertions.assertEquals((Object)newLogDir.getParent(), (Object)this.log().dir().getParent());
        this.log().segments().values().foreach((Function1 & Serializable)segment -> {
            LocalLogTest.$anonfun$testLogDirRenameToNewDir$1(newLogDir, segment);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
    }

    @Test
    public void testLogDirRenameToExistingDir() {
        Assertions.assertFalse((boolean)this.log().renameDir(this.log().dir().getName()));
    }

    @Test
    public void testLogFlush() {
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)this.mockTime().milliseconds(), (long)this.log().lastFlushTime());
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.log(), 0L);
        this.mockTime().sleep(1L);
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        this.log().flush(newSegment.baseOffset());
        this.log().markFlushed(newSegment.baseOffset());
        Assertions.assertEquals((long)1L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)this.mockTime().milliseconds(), (long)this.log().lastFlushTime());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogAppend() {
        void readRecords_includeAbortedTxns;
        void readRecords_minOneMessage;
        void readRecords_startOffset;
        LocalLog x$2 = this.log();
        long x$3 = 0L;
        boolean x$4 = false;
        boolean x$6 = false;
        FetchDataInfo fetchDataInfoBeforeAppend = x$2.read(x$3, 1, x$4, this.readRecords$default$5(), x$6);
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfoBeforeAppend.records.records()).asScala().isEmpty());
        this.mockTime().sleep(1L);
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        boolean bl = false;
        boolean bl2 = false;
        long l = 0L;
        LocalLog readRecords_log = this.log();
        Object var9_10 = null;
        FetchDataInfo fetchDataInfo = readRecords_log.read((long)readRecords_startOffset, this.readRecords$default$3(), (boolean)readRecords_minOneMessage, this.readRecords$default$5(), (boolean)readRecords_includeAbortedTxns);
        Assertions.assertEquals((long)2L, (long)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala().size());
        Assertions.assertEquals((Object)keyValues, this.recordsToKvs((Iterable<Record>)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala()));
    }

    @Test
    public void testLogCloseSuccess() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        this.log().close();
        Assertions.assertThrows(ClosedChannelException.class, () -> LocalLogTest.$anonfun$testLogCloseSuccess$1(this, (Seq)keyValues));
    }

    @Test
    public void testLogCloseIdempotent() {
        this.log().close();
        this.log().close();
    }

    @Test
    public void testLogCloseFailureWhenInMemoryBufferClosed() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        this.log().closeHandlers();
        Assertions.assertThrows(KafkaStorageException.class, () -> this.log().close());
    }

    @Test
    public void testLogCloseHandlers() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        this.log().closeHandlers();
        Assertions.assertThrows(ClosedChannelException.class, () -> LocalLogTest.$anonfun$testLogCloseHandlers$1(this, (Seq)keyValues));
    }

    @Test
    public void testLogCloseHandlersIdempotent() {
        this.log().closeHandlers();
        this.log().closeHandlers();
    }

    private void testRemoveAndDeleteSegments(boolean asyncDelete) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testRemoveAndDeleteSegments$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        public class Kafka_log_LocalLogTest$TestDeletionReason$1
        implements SegmentDeletionReason {
            private Iterable<LogSegment> _deletedSegments;

            private Iterable<LogSegment> _deletedSegments() {
                return this._deletedSegments;
            }

            private void _deletedSegments_$eq(Iterable<LogSegment> x$1) {
                this._deletedSegments = x$1;
            }

            public void logReason(List<LogSegment> toDelete) {
                this._deletedSegments_$eq((Iterable<LogSegment>)((Iterable)Nil$.MODULE$.$plus$plus(toDelete)));
            }

            public Iterable<LogSegment> deletedSegments() {
                return this._deletedSegments();
            }

            public Kafka_log_LocalLogTest$TestDeletionReason$1(LocalLogTest $outer) {
                this._deletedSegments = Nil$.MODULE$;
            }
        }
        Kafka_log_LocalLogTest$TestDeletionReason$1 reason = new Kafka_log_LocalLogTest$TestDeletionReason$1(null);
        List toDelete = (List)Nil$.MODULE$.$plus$plus((IterableOnce)this.log().segments().values());
        this.log().removeAndDeleteSegments((Iterable)toDelete, asyncDelete, (SegmentDeletionReason)reason);
        if (asyncDelete) {
            this.mockTime().sleep(this.log().config().fileDeleteDelayMs + 1L);
        }
        Assertions.assertTrue((boolean)this.log().segments().isEmpty());
        Assertions.assertEquals((Object)toDelete, reason.deletedSegments());
        toDelete.foreach((Function1 & Serializable)segment -> {
            LocalLogTest.$anonfun$testRemoveAndDeleteSegments$2(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testRemoveAndDeleteSegmentsSync() {
        this.testRemoveAndDeleteSegments(false);
    }

    @Test
    public void testRemoveAndDeleteSegmentsAsync() {
        this.testRemoveAndDeleteSegments(true);
    }

    private void testDeleteSegmentFiles(boolean asyncDelete) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testDeleteSegmentFiles$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        List toDelete = (List)Nil$.MODULE$.$plus$plus((IterableOnce)this.log().segments().values());
        LocalLog$.MODULE$.deleteSegmentFiles((scala.collection.immutable.Iterable)toDelete, asyncDelete, this.log().dir(), this.log().topicPartition(), this.log().config(), this.log().scheduler(), this.log().logDirFailureChannel(), "");
        if (asyncDelete) {
            toDelete.foreach((Function1 & Serializable)segment -> {
                LocalLogTest.$anonfun$testDeleteSegmentFiles$2(segment);
                return BoxedUnit.UNIT;
            });
            this.mockTime().sleep(this.log().config().fileDeleteDelayMs + 1L);
        }
        toDelete.foreach((Function1 & Serializable)segment -> {
            LocalLogTest.$anonfun$testDeleteSegmentFiles$3(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDeleteSegmentFilesSync() {
        this.testDeleteSegmentFiles(false);
    }

    @Test
    public void testDeleteSegmentFilesAsync() {
        this.testDeleteSegmentFiles(true);
    }

    @Test
    public void testDeletableSegmentsFilter() {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testDeletableSegmentsFilter$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((int)10, (int)this.log().segments().numberOfSegments());
        Iterable deletable = this.log().deletableSegments((Function2 & Serializable)(segment, x$2) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$2(segment, x$2)));
        List expected = ((IterableOnceOps)this.log().segments().nonActiveLogSegmentsFrom(0L).filter((Function1 & Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$3(segment)))).toList();
        Assertions.assertEquals((int)6, (int)expected.length());
        Assertions.assertEquals((Object)expected, (Object)deletable.toList());
        Iterable deletable2 = this.log().deletableSegments((Function2 & Serializable)(x$3, x$4) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$4(x$3, x$4)));
        List expected2 = this.log().segments().nonActiveLogSegmentsFrom(0L).toList();
        Assertions.assertEquals((int)9, (int)expected2.length());
        Assertions.assertEquals((Object)expected2, (Object)deletable2.toList());
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$42 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        LocalLog x$62 = this.log();
        this.appendRecords((Iterable<SimpleRecord>)x$42, x$62, 9L);
        Iterable deletable3 = this.log().deletableSegments((Function2 & Serializable)(x$5, x$6) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$5(x$5, x$6)));
        List expected3 = this.log().segments().values().toList();
        Assertions.assertEquals((int)10, (int)expected3.length());
        Assertions.assertEquals((Object)expected3, (Object)deletable3.toList());
    }

    @Test
    public void testDeletableSegmentsIteration() {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testDeletableSegmentsIteration$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        IntRef offset2 = IntRef.create((int)0);
        Iterable deletableSegments = this.log().deletableSegments((Function2 & Serializable)(segment, nextSegmentOpt) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsIteration$2(this, offset2, segment, nextSegmentOpt)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        Assertions.assertEquals((Object)this.log().segments().nonActiveLogSegmentsFrom(0L).toSeq(), (Object)deletableSegments.toSeq());
    }

    @Test
    public void testCreateAndDeleteSegment() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.log(), 0L);
        long newOffset = this.log().segments().activeSegment().baseOffset() + 1L;
        LogSegment oldActiveSegment = this.log().segments().activeSegment();
        LogSegment newActiveSegment = this.log().createAndDeleteSegment(newOffset, this.log().segments().activeSegment(), true, (SegmentDeletionReason)new LogTruncation(this.log()));
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((Object)newActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertNotEquals((Object)oldActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertTrue((boolean)oldActiveSegment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
        Assertions.assertEquals((long)newOffset, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)newOffset, (long)this.log().logEndOffset());
        LocalLog x$2 = this.log();
        boolean x$4 = false;
        boolean x$6 = false;
        FetchDataInfo fetchDataInfo = x$2.read(newOffset, this.readRecords$default$3(), x$4, this.readRecords$default$5(), x$6);
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala().isEmpty());
    }

    @Test
    public void testTruncateFullyAndStartAt() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 7).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testTruncateFullyAndStartAt$1(this, record, BoxesRunTime.unboxToInt((Object)offset)));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(8), 12).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)offset -> {
            SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
            .colon.colon x$4 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
            long x$5 = offset;
            LocalLog x$6 = this.log();
            this.appendRecords((Iterable<SimpleRecord>)x$4, x$6, x$5);
        });
        Assertions.assertEquals((int)5, (int)this.log().segments().numberOfSegments());
        Assertions.assertNotEquals((long)10L, (long)this.log().segments().activeSegment().baseOffset());
        List expected = (List)Nil$.MODULE$.$plus$plus((IterableOnce)this.log().segments().values());
        Iterable deleted = this.log().truncateFullyAndStartAt(10L);
        Assertions.assertEquals((Object)expected, (Object)deleted);
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)10L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)10L, (long)this.log().logEndOffset());
        LocalLog x$8 = this.log();
        boolean x$10 = false;
        boolean x$12 = false;
        long readRecords_startOffset = 10L;
        FetchDataInfo fetchDataInfo = x$8.read(readRecords_startOffset, this.readRecords$default$3(), x$10, this.readRecords$default$5(), x$12);
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala().isEmpty());
    }

    @Test
    public void testTruncateTo() {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 11).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testTruncateTo$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((int)5, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)12L, (long)this.log().logEndOffset());
        List expected = (List)Nil$.MODULE$.$plus$plus((IterableOnce)this.log().segments().values(9L, this.log().logEndOffset() + 1L));
        Iterable deleted = this.log().truncateTo(7L);
        Assertions.assertEquals((Object)expected, (Object)deleted);
        Assertions.assertEquals((int)3, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)6L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)7L, (long)this.log().logEndOffset());
        LocalLog x$5 = this.log();
        boolean x$7 = false;
        boolean x$9 = false;
        long readRecords_startOffset = 6L;
        FetchDataInfo fetchDataInfo = x$5.read(readRecords_startOffset, this.readRecords$default$3(), x$7, this.readRecords$default$5(), x$9);
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala().size());
        Assertions.assertEquals((Object)new .colon.colon((Object)new KeyValue(this, "", "a"), (List)Nil$.MODULE$), this.recordsToKvs((Iterable<Record>)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala()));
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$10 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        LocalLog x$12 = this.log();
        this.appendRecords((Iterable<SimpleRecord>)x$10, x$12, 7L);
        Assertions.assertEquals((long)8L, (long)this.log().logEndOffset());
    }

    @Test
    public void testNonActiveSegmentsFrom() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).foreach((Function1 & Serializable)i -> LocalLogTest.$anonfun$testNonActiveSegmentsFrom$1(this, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((long)5L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5), (Object)this.nonActiveBaseOffsetsFrom$1(0L));
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)this.nonActiveBaseOffsetsFrom$1(5L));
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(2), 5), (Object)this.nonActiveBaseOffsetsFrom$1(2L));
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)this.nonActiveBaseOffsetsFrom$1(6L));
    }

    private String topicPartitionName(String topic, String partition) {
        return new StringBuilder(1).append(topic).append("-").append(partition).toString();
    }

    @Test
    public void testParseTopicPartitionName() {
        String topic = "test_topic";
        String partition = "143";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
        Assertions.assertEquals((Object)topic, (Object)topicPartition.topic());
        Assertions.assertEquals((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partition)), (int)topicPartition.partition());
    }

    @Test
    public void testParseTopicPartitionNameWithPeriodForDeletedTopic() {
        String topic = "foo.bar-testtopic";
        String partition = "42";
        File dir = new File(this.logDir(), LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(topic, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partition)))));
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
        Assertions.assertEquals((Object)topic, (Object)topicPartition.topic(), (String)"Unexpected topic name parsed");
        Assertions.assertEquals((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partition)), (int)topicPartition.partition(), (String)"Unexpected partition number parsed");
    }

    @Test
    public void testParseTopicPartitionNameForEmptyName() {
        File dir = new File("");
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForNull() {
        Assertions.assertThrows(KafkaException.class, () -> LocalLogTest.$anonfun$testParseTopicPartitionNameForNull$1(null), () -> LocalLogTest.$anonfun$testParseTopicPartitionNameForNull$2(null));
    }

    @Test
    public void testParseTopicPartitionNameForMissingSeparator() {
        String topic = "test_topic";
        String partition = "1999";
        File dir = new File(this.logDir(), new StringBuilder(0).append(topic).append(partition).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(topic).append(partition).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForMissingTopic() {
        String topic = "";
        String partition = "1999";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(topic, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partition)))));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForMissingPartition() {
        String topic = "test_topic";
        String partition = "";
        File dir = new File(new StringBuilder(0).append(this.logDir().getPath()).append(this.topicPartitionName(topic, partition)).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(this.topicPartitionName(topic, partition)).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForInvalidPartition() {
        String topic = "test_topic";
        String partition = "1999a";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(topic).append(partition).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForExistingInvalidDir() {
        File dir1 = new File(new StringBuilder(14).append(this.logDir().getPath()).append("/non_kafka_dir").toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir1), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir1.getCanonicalPath()).toString());
        File dir2 = new File(new StringBuilder(21).append(this.logDir().getPath()).append("/non_kafka_dir-delete").toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir2), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir2.getCanonicalPath()).toString());
    }

    @Test
    public void testLogDeleteDirName() {
        String name1 = LocalLog$.MODULE$.logDeleteDirName(new TopicPartition("foo", 3));
        Assertions.assertTrue((name1.length() <= 255 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Pattern.compile("foo-3\\.[0-9a-z]{32}-delete").matcher(name1).matches());
        Assertions.assertTrue((boolean)LocalLog$.MODULE$.DeleteDirPattern().matcher(name1).matches());
        Assertions.assertFalse((boolean)LocalLog$.MODULE$.FutureDirPattern().matcher(name1).matches());
        String name2 = LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(new StringBuilder(1).append("n").append(String.join((CharSequence)"", Collections.nCopies(248, "o"))).toString(), 5));
        Assertions.assertEquals((int)255, (int)name2.length());
        Assertions.assertTrue((boolean)Pattern.compile("n[o]{212}-5\\.[0-9a-z]{32}-delete").matcher(name2).matches());
        Assertions.assertTrue((boolean)LocalLog$.MODULE$.DeleteDirPattern().matcher(name2).matches());
        Assertions.assertFalse((boolean)LocalLog$.MODULE$.FutureDirPattern().matcher(name2).matches());
    }

    @Test
    public void testOffsetFromFile() {
        long offset = 23423423L;
        File logFile_dir = this.tmpDir();
        Object var6_2 = null;
        File logFile = LogFileUtils.logFile((File)logFile_dir, (long)offset, (String)"");
        Assertions.assertEquals((long)offset, (Long)LogFileUtils.offsetFromFile((File)logFile));
        File offsetIndexFile_dir = this.tmpDir();
        Object var7_4 = null;
        File offsetIndexFile = LogFileUtils.offsetIndexFile((File)offsetIndexFile_dir, (long)offset, (String)"");
        Assertions.assertEquals((long)offset, (Long)LogFileUtils.offsetFromFile((File)offsetIndexFile));
        File timeIndexFile_dir = this.tmpDir();
        Object var8_6 = null;
        File timeIndexFile = LogFileUtils.timeIndexFile((File)timeIndexFile_dir, (long)offset, (String)"");
        Assertions.assertEquals((long)offset, (Long)LogFileUtils.offsetFromFile((File)timeIndexFile));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRollSegmentThatAlreadyExists() {
        void readRecords_includeAbortedTxns;
        void readRecords_minOneMessage;
        void readRecords_startOffset;
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        this.log().roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Expect 1 segment after roll() empty segment with base offset.");
        .colon.colon keyValues1 = new .colon.colon((Object)new KeyValue(this, "k1", "v1"), (List)Nil$.MODULE$);
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues1), this.log(), 0L);
        Assertions.assertEquals((long)0L, (long)this.log().segments().activeSegment().baseOffset());
        .colon.colon keyValues2 = new .colon.colon((Object)new KeyValue(this, "k2", "v2"), (List)Nil$.MODULE$);
        List x$1 = keyValues2.map((Function1 & Serializable)x$8 -> x$8.toRecord((Function0<Object>)(JFunction0.mcJ.sp & Serializable)() -> this.mockTime().milliseconds() + 10L));
        LocalLog x$3 = this.log();
        this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, 1L);
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset(), (String)"Expect two records in the log");
        boolean bl = false;
        boolean bl2 = false;
        long l = 0L;
        LocalLog readRecords_log = this.log();
        Object var6_8 = null;
        FetchDataInfo readResult = readRecords_log.read((long)readRecords_startOffset, this.readRecords$default$3(), (boolean)readRecords_minOneMessage, this.readRecords$default$5(), (boolean)readRecords_includeAbortedTxns);
        Assertions.assertEquals((long)2L, (long)CollectionConverters$.MODULE$.IterableHasAsScala(readResult.records.records()).asScala().size());
        Assertions.assertEquals((Object)keyValues1.$plus$plus((IterableOnce)keyValues2), this.recordsToKvs((Iterable<Record>)CollectionConverters$.MODULE$.IterableHasAsScala(readResult.records.records()).asScala()));
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)2L, (long)this.log().segments().activeSegment().baseOffset(), (String)"Expect base offset of active segment to be LEO");
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments(), (String)"Expect two segments.");
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
    }

    @Test
    public void testNewSegmentsAfterRoll() {
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)0L, (long)newSegment.baseOffset());
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)0L, (long)this.log().logEndOffset());
        KeyValue qual$1 = new KeyValue(this, "k1", "v1");
        JFunction0.mcJ.sp & Serializable x$1 = (JFunction0.mcJ.sp & Serializable)() -> qual$1.toRecord$default$1();
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)qual$1.toRecord((Function0<Object>)x$1), (List)Nil$.MODULE$), this.log(), 0L);
        LogSegment newSegment2 = this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)1L, (long)newSegment2.baseOffset());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)1L, (long)this.log().logEndOffset());
        KeyValue qual$2 = new KeyValue(this, "k2", "v2");
        JFunction0.mcJ.sp & Serializable x$2 = (JFunction0.mcJ.sp & Serializable)() -> qual$2.toRecord$default$1();
        .colon.colon x$3 = new .colon.colon((Object)qual$2.toRecord((Function0<Object>)x$2), (List)Nil$.MODULE$);
        LocalLog x$5 = this.log();
        this.appendRecords((Iterable<SimpleRecord>)x$3, x$5, 1L);
        LogSegment newSegment3 = this.log().roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)));
        Assertions.assertEquals((long)2L, (long)newSegment3.baseOffset());
        Assertions.assertEquals((int)3, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
    }

    @Test
    public void testRollSegmentErrorWhenNextOffsetIsIllegal() {
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "k1", "v1"), (List)new .colon.colon((Object)new KeyValue(this, "k2", "v2"), (List)new .colon.colon((Object)new KeyValue(this, "k3", "v3"), (List)Nil$.MODULE$)));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        Assertions.assertEquals((long)0L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)3L, (long)this.log().logEndOffset(), (String)"Expect two records in the log");
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)3L, (long)this.log().segments().activeSegment().baseOffset());
        this.log().updateLogEndOffset(1L);
        Assertions.assertThrows(KafkaException.class, () -> this.log().roll(this.log().roll$default$1()));
    }

    @Test
    public void testFlushingNonExistentDir() {
        LocalLog spyLog = (LocalLog)Mockito.spy((Object)this.log());
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.log(), 0L);
        this.mockTime().sleep(1L);
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        ((LocalLog)Mockito.doReturn((Object)new File("__NON_EXISTENT__"), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)spyLog)).dir();
        Assertions.assertDoesNotThrow(() -> spyLog.flush(newSegment.baseOffset()));
    }

    private LocalLog createLocalLogWithActiveSegment(File dir, LogConfig config, LogSegments segments, long recoveryPoint, LogOffsetMetadata nextOffsetMetadata, Scheduler scheduler, Time time, TopicPartition topicPartition, LogDirFailureChannel logDirFailureChannel) {
        int x$5 = config.initFileSize();
        boolean x$6 = config.preallocate;
        boolean x$7 = false;
        String x$8 = "";
        segments.add(LogSegment$.MODULE$.open(dir, 0L, config, time, x$7, x$5, x$6, x$8));
        return new LocalLog(dir, config, segments, recoveryPoint, nextOffsetMetadata, scheduler, time, topicPartition, logDirFailureChannel);
    }

    private File createLocalLogWithActiveSegment$default$1() {
        return this.logDir();
    }

    private LogSegments createLocalLogWithActiveSegment$default$3() {
        return new LogSegments(this.topicPartition());
    }

    private long createLocalLogWithActiveSegment$default$4() {
        return 0L;
    }

    private LogOffsetMetadata createLocalLogWithActiveSegment$default$5() {
        return new LogOffsetMetadata(0L, 0L, 0);
    }

    private Scheduler createLocalLogWithActiveSegment$default$6() {
        return this.mockTime().scheduler;
    }

    private Time createLocalLogWithActiveSegment$default$7() {
        return this.mockTime();
    }

    private TopicPartition createLocalLogWithActiveSegment$default$8() {
        return this.topicPartition();
    }

    private LogDirFailureChannel createLocalLogWithActiveSegment$default$9() {
        return this.logDirFailureChannel();
    }

    private final void KeyValue$lzycompute$1() {
        synchronized (this) {
            if (this.KeyValue$module == null) {
                this.KeyValue$module = new LocalLogTest$KeyValue$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testLogDirRenameToNewDir$1(File newLogDir$1, LogSegment segment) {
        Assertions.assertEquals((Object)newLogDir$1.getPath(), (Object)segment.log().file().getParentFile().getPath());
    }

    public static final /* synthetic */ int $anonfun$testLogAppend$1() {
        return 1;
    }

    public static final /* synthetic */ void $anonfun$testLogCloseSuccess$1(LocalLogTest $this, Seq keyValues$1) {
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues$1);
        LocalLog x$3 = $this.log();
        $this.appendRecords(x$1, x$3, 2L);
    }

    public static final /* synthetic */ void $anonfun$testLogCloseHandlers$1(LocalLogTest $this, Seq keyValues$2) {
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues$2);
        LocalLog x$3 = $this.log();
        $this.appendRecords(x$1, x$3, 2L);
    }

    public static final /* synthetic */ LogSegment $anonfun$testRemoveAndDeleteSegments$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.log();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ void $anonfun$testRemoveAndDeleteSegments$2(LogSegment segment) {
        Assertions.assertTrue((boolean)segment.deleted());
    }

    public static final /* synthetic */ LogSegment $anonfun$testDeleteSegmentFiles$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.log();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ void $anonfun$testDeleteSegmentFiles$2(LogSegment segment) {
        Assertions.assertFalse((boolean)segment.deleted());
        Assertions.assertTrue((boolean)segment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
    }

    public static final /* synthetic */ void $anonfun$testDeleteSegmentFiles$3(LogSegment segment) {
        Assertions.assertTrue((boolean)segment.deleted());
    }

    public static final /* synthetic */ LogSegment $anonfun$testDeletableSegmentsFilter$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.log();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$2(LogSegment segment, Option x$2) {
        return segment.baseOffset() <= 5L;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$3(LogSegment segment) {
        return segment.baseOffset() <= 5L;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$4(LogSegment x$3, Option x$4) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$5(LogSegment x$5, Option x$6) {
        return true;
    }

    public static final /* synthetic */ LogSegment $anonfun$testDeletableSegmentsIteration$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.log();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsIteration$2(LocalLogTest $this, IntRef offset$1, LogSegment segment, Option nextSegmentOpt) {
        Assertions.assertEquals((long)offset$1.elem, (long)segment.baseOffset());
        Option floorSegmentOpt = $this.log().segments().floorSegment((long)offset$1.elem);
        Assertions.assertTrue((boolean)floorSegmentOpt.isDefined());
        Assertions.assertEquals((Object)floorSegmentOpt.get(), (Object)segment);
        if ((long)offset$1.elem == $this.log().logEndOffset()) {
            Assertions.assertFalse((boolean)nextSegmentOpt.isDefined());
        } else {
            Assertions.assertTrue((boolean)nextSegmentOpt.isDefined());
            Option higherSegmentOpt = $this.log().segments().higherSegment(segment.baseOffset());
            Assertions.assertTrue((boolean)higherSegmentOpt.isDefined());
            Assertions.assertEquals((long)(segment.baseOffset() + 1L), (long)((LogSegment)higherSegmentOpt.get()).baseOffset());
            Assertions.assertEquals((Object)higherSegmentOpt.get(), (Object)nextSegmentOpt.get());
        }
        ++offset$1.elem;
        return true;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateFullyAndStartAt$1(LocalLogTest $this, SimpleRecord record$1, int offset) {
        .colon.colon x$1 = new .colon.colon((Object)record$1, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.log();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        if (offset % 2 != 0) {
            return $this.log().roll($this.log().roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateTo$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.log();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        if (offset % 3 == 2) {
            return $this.log().roll($this.log().roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ LogSegment $anonfun$testNonActiveSegmentsFrom$1(LocalLogTest $this, int i) {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue($this, Integer.toString(i), Integer.toString(i)), (List)Nil$.MODULE$);
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues);
        long x$2 = i;
        LocalLog x$3 = $this.log();
        $this.appendRecords(x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    private final Seq nonActiveBaseOffsetsFrom$1(long startOffset) {
        return ((IterableOnceOps)this.log().segments().nonActiveLogSegmentsFrom(startOffset).map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.baseOffset()))).toSeq();
    }

    public static final /* synthetic */ void $anonfun$testParseTopicPartitionNameForNull$1(File dir$2) {
        LocalLog$.MODULE$.parseTopicPartitionName(dir$2);
    }

    public static final /* synthetic */ String $anonfun$testParseTopicPartitionNameForNull$2(File dir$2) {
        return new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir$2).toString();
    }

    public LocalLogTest() {
        LogConfig x$1 = LogTestUtils$.MODULE$.createLogConfig(604800000L, 0x40000000, 604800000L, -1L, 0L, "delete", 0x10000C, 4096, 0xA00000, 60000L, false);
        File x$2 = this.logDir();
        LogSegments x$3 = this.createLocalLogWithActiveSegment$default$3();
        long x$4 = 0L;
        LogOffsetMetadata x$5 = this.createLocalLogWithActiveSegment$default$5();
        Scheduler x$6 = this.createLocalLogWithActiveSegment$default$6();
        MockTime x$7 = this.mockTime();
        TopicPartition x$8 = this.topicPartition();
        LogDirFailureChannel x$9 = this.logDirFailureChannel();
        this.log = this.createLocalLogWithActiveSegment(x$2, x$1, x$3, x$4, x$5, x$6, (Time)x$7, x$8, x$9);
    }

    public class KeyValue
    implements Product,
    Serializable {
        private final String key;
        private final String value;
        public final /* synthetic */ LocalLogTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        public SimpleRecord toRecord(Function0<Object> timestamp) {
            return new SimpleRecord(timestamp.apply$mcJ$sp(), this.key().getBytes(), this.value().getBytes());
        }

        public long toRecord$default$1() {
            return this.kafka$log$LocalLogTest$KeyValue$$$outer().mockTime().milliseconds();
        }

        public KeyValue copy(String key, String value) {
            return new KeyValue(this.kafka$log$LocalLogTest$KeyValue$$$outer(), key, value);
        }

        public String copy$default$1() {
            return this.key();
        }

        public String copy$default$2() {
            return this.value();
        }

        public String productPrefix() {
            return "KeyValue";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.key();
                }
                case 1: {
                    return this.value();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof KeyValue;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "key";
                }
                case 1: {
                    return "value";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof KeyValue && ((KeyValue)x$1).kafka$log$LocalLogTest$KeyValue$$$outer() == this.kafka$log$LocalLogTest$KeyValue$$$outer())) break block3;
                    KeyValue keyValue = (KeyValue)x$1;
                    String string = this.key();
                    String string2 = keyValue.key();
                    if (string != null ? !string.equals(string2) : string2 != null) break block3;
                    String string3 = this.value();
                    String string4 = keyValue.value();
                    if ((string3 != null ? !string3.equals(string4) : string4 != null) || !keyValue.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ LocalLogTest kafka$log$LocalLogTest$KeyValue$$$outer() {
            return this.$outer;
        }

        public KeyValue(LocalLogTest $outer, String key, String value) {
            this.key = key;
            this.value = value;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

