/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.Stream;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import kafka.server.KRaftCachedControllerId;
import kafka.server.MetadataCache;
import kafka.server.MetadataCacheTest$;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.MetadataSnapshot;
import kafka.server.metadata.ZkMetadataCache;
import kafka.server.metadata.ZkMetadataCache$;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.AnyRefMap;
import scala.collection.mutable.AnyRefMap$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.LongMap;
import scala.collection.mutable.LongMap$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

/*
 * Exception performing whole class analysis ignored.
 */
@ScalaSignature(bytes="\u0006\u0005\tmr!\u0002\u000f\u001e\u0011\u0003\u0011c!\u0002\u0013\u001e\u0011\u0003)\u0003\"\u0002\u0017\u0002\t\u0003i\u0003\"\u0002\u0018\u0002\t\u0003y\u0003\"B\u001f\u0002\t\u0003y\u0003\"\u0002 \u0002\t\u0003yd\u0001\u0002\u0013\u001e\u0001QCQ\u0001\f\u0004\u0005\u0002UCqa\u0016\u0004C\u0002\u0013\u0005\u0001\f\u0003\u0004]\r\u0001\u0006I!\u0017\u0005\u0006;\u001a!\tA\u0018\u0005\u0006k\u001a!\tA\u001e\u0005\u0006w\u001a!\t\u0001 \u0005\b\u0003\u00071A\u0011AA\u0003\u0011\u001d\tyA\u0002C\u0005\u0003#Aq!!#\u0007\t\u0003\tY\tC\u0004\u0002\u0016\u001a!\t!a&\t\u000f\u0005\u0005f\u0001\"\u0001\u0002$\"9\u0011Q\u0016\u0004\u0005\u0002\u0005=\u0006bBA]\r\u0011\u0005\u00111\u0018\u0005\b\u0003\u000f4A\u0011AAe\u0011\u001d\tIN\u0002C\u0001\u0003\u0013Dq!!8\u0007\t\u0003\tI\rC\u0004\u0002b\u001a!\t!!3\t\u000f\u0005\u0015h\u0001\"\u0001\u0002h\"9\u0011\u0011\u001f\u0004\u0005\u0002\u0005M\bb\u0002B\u001a\r\u0011\u0005\u0011\u0011\u001a\u0005\b\u0005o1A\u0011AAe\u0003EiU\r^1eCR\f7)Y2iKR+7\u000f\u001e\u0006\u0003=}\taa]3sm\u0016\u0014(\"\u0001\u0011\u0002\u000b-\fgm[1\u0004\u0001A\u00111%A\u0007\u0002;\t\tR*\u001a;bI\u0006$\u0018mQ1dQ\u0016$Vm\u001d;\u0014\u0005\u00051\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002E\u0005y!p[\"bG\",\u0007K]8wS\u0012,'\u000fF\u00011!\r\t\u0004HO\u0007\u0002e)\u00111\u0007N\u0001\u0007gR\u0014X-Y7\u000b\u0005U2\u0014\u0001B;uS2T\u0011aN\u0001\u0005U\u00064\u0018-\u0003\u0002:e\t11\u000b\u001e:fC6\u0004\"aI\u001e\n\u0005qj\"!D'fi\u0006$\u0017\r^1DC\u000eDW-A\u0007dC\u000eDW\r\u0015:pm&$WM]\u0001\fkB$\u0017\r^3DC\u000eDW\rF\u0002A\u0007\u0016\u0003\"aJ!\n\u0005\tC#\u0001B+oSRDQ\u0001R\u0003A\u0002i\nQaY1dQ\u0016DQAR\u0003A\u0002\u001d\u000bqA]3rk\u0016\u001cH\u000f\u0005\u0002I%6\t\u0011J\u0003\u0002K\u0017\u0006A!/Z9vKN$8O\u0003\u0002M\u001b\u000611m\\7n_:T!\u0001\t(\u000b\u0005=\u0003\u0016AB1qC\u000eDWMC\u0001R\u0003\ry'oZ\u0005\u0003'&\u0013Q#\u00169eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cHo\u0005\u0002\u0007MQ\ta\u000b\u0005\u0002$\r\u0005Y!M]8lKJ,\u0005o\\2i+\u0005I\u0006CA\u0014[\u0013\tY\u0006F\u0001\u0003M_:<\u0017\u0001\u00042s_.,'/\u00129pG\"\u0004\u0013!I4fiR{\u0007/[2NKR\fG-\u0019;b\u001d>tW\t_5ti&tw\rV8qS\u000e\u001cHC\u0001!`\u0011\u0015!%\u00021\u0001;Q\u0011Q\u0011-\u001c8\u0011\u0005\t\\W\"A2\u000b\u0005\u0011,\u0017\u0001\u00039s_ZLG-\u001a:\u000b\u0005\u0019<\u0017A\u00029be\u0006l7O\u0003\u0002iS\u00069!.\u001e9ji\u0016\u0014(B\u00016Q\u0003\u0015QWO\\5u\u0013\ta7M\u0001\u0007NKRDw\u000eZ*pkJ\u001cW-A\u0003wC2,X\rL\u0001pC\u0005i\u0004F\u0001\u0006r!\t\u00118/D\u0001f\u0013\t!XMA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\f\u0001cZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1\u0015\u0005\u0001;\b\"\u0002#\f\u0001\u0004Q\u0004\u0006B\u0006b[fd\u0013a\u001c\u0015\u0003\u0017E\f1fZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u001d>$\u0018I^1jY\u0006\u0014G.\u001a\u000b\u0003\u0001vDQ\u0001\u0012\u0007A\u0002iBC\u0001D1n\u007f2\nq\u000e\u000b\u0002\rc\u0006)t-\u001a;U_BL7-T3uC\u0012\fG/\u0019)beRLG/[8o\u0019&\u001cH/\u001a8fe:{G/\u0011<bS2\f'\r\\3P]2+\u0017\rZ3s)\r\u0001\u0015q\u0001\u0005\u0006\t6\u0001\rA\u000f\u0015\u0006\u001b\u0005l\u00171\u0002\u0017\u0002_\"\u0012Q\"]\u00019m\u0016\u0014\u0018NZ=U_BL7-T3uC\u0012\fG/\u0019)beRLG/[8o\u0019\u0016\fG-\u001a:Pe\u0016sG\r]8j]Rtu\u000e^!wC&d\u0017M\u00197f)=\u0001\u00151CA\u000b\u0003?\tY&a\u001b\u0002p\u0005}\u0004\"\u0002#\u000f\u0001\u0004Q\u0004bBA\f\u001d\u0001\u0007\u0011\u0011D\u0001\u0016[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3Ce>\\WM]%e!\r9\u00131D\u0005\u0004\u0003;A#aA%oi\"9\u0011\u0011\u0005\bA\u0002\u0005\r\u0012a\u00022s_.,'o\u001d\t\u0007\u0003K\tY#a\f\u000e\u0005\u0005\u001d\"bAA\u0015Q\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u00055\u0012q\u0005\u0002\u0004'\u0016\f\b\u0003BA\u0019\u0003+rA!a\r\u0002P9!\u0011QGA&\u001d\u0011\t9$!\u0013\u000f\t\u0005e\u0012q\t\b\u0005\u0003w\t)E\u0004\u0003\u0002>\u0005\rSBAA \u0015\r\t\t%I\u0001\u0007yI|w\u000e\u001e \n\u0003EK!a\u0014)\n\u0005\u0001r\u0015B\u0001'N\u0013\r\tieS\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\t\t&a\u0015\u00023U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u0012\u000bG/\u0019\u0006\u0004\u0003\u001bZ\u0015\u0002BA,\u00033\u0012A#\u00169eCR,W*\u001a;bI\u0006$\u0018M\u0011:pW\u0016\u0014(\u0002BA)\u0003'Bq!!\u0018\u000f\u0001\u0004\ty&\u0001\u0007mSN$XM\\3s\u001d\u0006lW\r\u0005\u0003\u0002b\u0005\u001dTBAA2\u0015\r\t)gS\u0001\b]\u0016$xo\u001c:l\u0013\u0011\tI'a\u0019\u0003\u00191K7\u000f^3oKJt\u0015-\\3\t\u000f\u00055d\u00021\u0001\u0002\u001a\u00051A.Z1eKJDq!!\u001d\u000f\u0001\u0004\t\u0019(A\u0007fqB,7\r^3e\u000bJ\u0014xN\u001d\t\u0005\u0003k\nY(\u0004\u0002\u0002x)\u0019\u0011\u0011P&\u0002\u0011A\u0014x\u000e^8d_2LA!! \u0002x\t1QI\u001d:peNDq!!!\u000f\u0001\u0004\t\u0019)A\rfeJ|'/\u00168bm\u0006LG.\u00192mK2K7\u000f^3oKJ\u001c\bcA\u0014\u0002\u0006&\u0019\u0011q\u0011\u0015\u0003\u000f\t{w\u000e\\3b]\u0006\u0019s-\u001a;U_BL7-T3uC\u0012\fG/\u0019*fa2L7-\u0019(pi\u00063\u0018-\u001b7bE2,Gc\u0001!\u0002\u000e\")Ai\u0004a\u0001u!*q\"Y7\u0002\u00122\nq\u000e\u000b\u0002\u0010c\u0006yr-\u001a;U_BL7-T3uC\u0012\fG/Y%te:{G/\u0011<bS2\f'\r\\3\u0015\u0007\u0001\u000bI\nC\u0003E!\u0001\u0007!\bK\u0003\u0011C6\fi\nL\u0001pQ\t\u0001\u0012/\u0001\u0019hKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uC^KG\u000f\u001b(p]N+\b\u000f]8si\u0016$7+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\u000b\u0004\u0001\u0006\u0015\u0006\"\u0002#\u0012\u0001\u0004Q\u0004&B\tb[\u0006%F&A8)\u0005E\t\u0018AL4fi\u0006c\u0017N^3Ce>\\WM]:TQ>,H\u000e\u001a(pi\n+W*\u001e;bi\u0016$')_+qI\u0006$XmQ1dQ\u0016$2\u0001QAY\u0011\u0015!%\u00031\u0001;Q\u0015\u0011\u0012-\\A[Y\u0005y\u0007F\u0001\nr\u0003%\"Xm\u001d;HKR\u001cE.^:uKJlU\r^1eCR\fw+\u001b;i\u001f\u001a4G.\u001b8f%\u0016\u0004H.[2bgR\u0019\u0001)!0\t\u000b\u0011\u001b\u0002\u0019\u0001\u001e)\u000bM\tW.!1-\u0005\u0005\r\u0017%\u0001\u0018)\u0005M\t\u0018A\u0005;fgRL5O\u0011:pW\u0016\u0014h)\u001a8dK\u0012$\u0012\u0001\u0011\u0015\u0004)\u00055\u0007\u0003BAh\u0003+l!!!5\u000b\u0007\u0005Mw-A\u0002ba&LA!a6\u0002R\n!A+Z:u\u0003\r\"Xm\u001d;HKR\fE.\u001b<f\u0005J|7.\u001a:t/&$\bN\u0011:pW\u0016\u0014h)\u001a8dK\u0012D3!FAg\u0003\u0001\"Xm\u001d;Jg\n\u0013xn[3s\u0013:\u001cuN\u001c;s_2dW\rZ*ikR$wn\u001e8)\u0007Y\ti-\u0001\fuKN$x)\u001a;MSZ,'I]8lKJ,\u0005o\\2iQ\r9\u0012QZ\u0001\u0015i\u0016\u001cHoR3u!\u0006\u0014H/\u001b;j_:LeNZ8\u0015\u0007\u0001\u000bI\u000fC\u0003E1\u0001\u0007!\bK\u0003\u0019C6\fi\u000fL\u0001pQ\tA\u0012/A\u000etKR,\b/\u00138ji&\fG.\u00118e\rVdG.T3uC\u0012\fG/\u0019\u000b\u0003\u0003k\u00042bJA|\u0003w\u0014I\"a?\u00032%\u0019\u0011\u0011 \u0015\u0003\rQ+\b\u000f\\35!!\tiP!\u0002\u0003\f\tEa\u0002BA\u0000\u0005\u0003\u00012!!\u0010)\u0013\r\u0011\u0019\u0001K\u0001\u0007!J,G-\u001a4\n\t\t\u001d!\u0011\u0002\u0002\u0004\u001b\u0006\u0004(b\u0001B\u0002QA!\u0011Q B\u0007\u0013\u0011\u0011yA!\u0003\u0003\rM#(/\u001b8h!\u0011\u0011\u0019B!\u0006\u000e\u0003-K1Aa\u0006L\u0005\u0011)V/\u001b3\u0011\u0011\tm!\u0011\u0005B\u0006\u0005Ki!A!\b\u000b\t\t}\u0011qE\u0001\b[V$\u0018M\u00197f\u0013\u0011\u0011\u0019C!\b\u0003\u0013\u0005s\u0017PU3g\u001b\u0006\u0004\bC\u0002B\u000e\u0005O\u0011Y#\u0003\u0003\u0003*\tu!a\u0002'p]\u001el\u0015\r\u001d\t\u0005\u0003c\u0011i#\u0003\u0003\u00030\u0005e#\u0001H+qI\u0006$X-T3uC\u0012\fG/\u0019)beRLG/[8o'R\fG/\u001a\t\u0007\u0003K\tYCa\u000b\u0002oQ,7\u000f^'bs\n,\u0017J\u001c6fGR$U\r\\3uK\u0012\u0004\u0016M\u001d;ji&|gn\u001d$s_64U\u000f\u001c7NKR\fG-\u0019;b%\u0016\fX/Z:uQ\rQ\u0012QZ\u00011i\u0016\u001cH\u000fS1oI2,g)\u001e7m+B$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u\u0013:T6.T5he\u0006$\u0018n\u001c8)\u0007m\ti\r")
public class MetadataCacheTest {
    private final long brokerEpoch;

    public static void updateCache(MetadataCache cache, UpdateMetadataRequest request) {
        MetadataCacheTest$.MODULE$.updateCache(cache, request);
    }

    public static Stream<MetadataCache> cacheProvider() {
        return MetadataCacheTest$.MODULE$.cacheProvider();
    }

    public static Stream<MetadataCache> zkCacheProvider() {
        return MetadataCacheTest$.MODULE$.zkCacheProvider();
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataNonExistingTopics(MetadataCache cache) {
        String topic = "topic";
        Assertions.assertTrue((boolean)cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4()).isEmpty());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadata(MetadataCache cache) {
        String topic0 = "topic-0";
        String topic1 = "topic-1";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        IndexedSeq brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)brokerId -> MetadataCacheTest.$anonfun$getTopicMetadata$1(BoxesRunTime.unboxToInt((Object)brokerId)));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic0).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(0).setLeaderEpoch(0).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3))).setZkVersion(zkVersion).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3))), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic0).setPartitionIndex(1).setControllerEpoch(controllerEpoch).setLeader(1).setLeaderEpoch(1).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0))).setZkVersion(zkVersion).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(4))), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic1).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(2).setLeaderEpoch(2).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1))).setZkVersion(zkVersion).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3))), (List)Nil$.MODULE$)));
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        topicIds.put(topic0, Uuid.randomUuid());
        topicIds.put(topic1, Uuid.randomUuid());
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), topicIds).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        new .colon.colon((Object)SecurityProtocol.PLAINTEXT, (List)new .colon.colon((Object)SecurityProtocol.SSL, (List)Nil$.MODULE$)).foreach(arg_0 -> MetadataCacheTest.$anonfun$getTopicMetadata$2$adapted(cache, topicIds, (Seq)partitionStates, topic0, topic1, arg_0));
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataPartitionLeaderNotAvailable(MetadataCache cache) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int metadataCacheBrokerId = 0;
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, true);
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataPartitionListenerNotAvailableOnLeader(MetadataCache cache) {
        ListenerName plaintextListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        ListenerName sslListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL);
        .colon.colon broker0Endpoints = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(plaintextListenerName.value()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setListener(sslListenerName.value()), (List)Nil$.MODULE$));
        .colon.colon broker1Endpoints = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host1").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(plaintextListenerName.value()), (List)Nil$.MODULE$);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)broker0Endpoints).asJava()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(1).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)broker1Endpoints).asJava()), (List)Nil$.MODULE$));
        int metadataCacheBrokerId = 0;
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, sslListenerName, 1, Errors.LISTENER_NOT_FOUND, true);
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, sslListenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
    }

    private void verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(MetadataCache cache, int metadataCacheBrokerId, Seq<UpdateMetadataRequestData.UpdateMetadataBroker> brokers, ListenerName listenerName, int leader, Errors expectedError, boolean errorUnavailableListeners) {
        String topic = "topic";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        int leaderEpoch = 1;
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0))).setZkVersion(zkVersion).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0))), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava(brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        scala.collection.immutable.Set x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}));
        boolean x$4 = cache.getTopicMetadata$default$3();
        Seq topicMetadatas = cache.getTopicMetadata((Set)x$1, listenerName, x$4, errorUnavailableListeners);
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)expectedError.code(), (short)partitionMetadata.errorCode());
        Assertions.assertFalse((boolean)partitionMetadata.isrNodes().isEmpty());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicaNodes()).asScala());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataReplicaNotAvailable(MetadataCache cache) {
        String topic = "topic";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(zkVersion).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, false, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.isrNodes()).asScala().toSet());
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, true, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatasWithError.size());
        MetadataResponseData.MetadataResponseTopic topicMetadataWithError = (MetadataResponseData.MetadataResponseTopic)topicMetadatasWithError.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadataWithError.errorCode());
        java.util.List partitionMetadatasWithError = topicMetadataWithError.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatasWithError.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadataWithError = (MetadataResponseData.MetadataResponsePartition)partitionMetadatasWithError.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadataWithError.partitionIndex());
        Assertions.assertEquals((short)Errors.REPLICA_NOT_AVAILABLE.code(), (short)partitionMetadataWithError.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.isrNodes()).asScala().toSet());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataIsrNotAvailable(MetadataCache cache) {
        String topic = "topic";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("rack1").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(zkVersion).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, false, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.isrNodes()).asScala().toSet());
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, true, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatasWithError.size());
        MetadataResponseData.MetadataResponseTopic topicMetadataWithError = (MetadataResponseData.MetadataResponseTopic)topicMetadatasWithError.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadataWithError.errorCode());
        java.util.List partitionMetadatasWithError = topicMetadataWithError.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatasWithError.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadataWithError = (MetadataResponseData.MetadataResponsePartition)partitionMetadatasWithError.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadataWithError.partitionIndex());
        Assertions.assertEquals((short)Errors.REPLICA_NOT_AVAILABLE.code(), (short)partitionMetadataWithError.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.isrNodes()).asScala().toSet());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataWithNonSupportedSecurityProtocol(MetadataCache cache) {
        String topic = "topic";
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int controllerEpoch = 1;
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Seq topicMetadata = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadata.size());
        Assertions.assertEquals((int)1, (int)((MetadataResponseData.MetadataResponseTopic)topicMetadata.head()).partitions().size());
        Assertions.assertEquals((int)-1, (int)((MetadataResponseData.MetadataResponsePartition)((MetadataResponseData.MetadataResponseTopic)topicMetadata.head()).partitions().get(0)).leaderId());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getAliveBrokersShouldNotBeMutatedByUpdateCache(MetadataCache cache) {
        String topic = "topic";
        Range.Inclusive initialBrokerIds = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2);
        this.updateCache$1((Seq)initialBrokerIds, topic, cache);
        Iterable aliveBrokersFromCache = cache.getAliveBrokers();
        this.updateCache$1((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3), topic, cache);
        Assertions.assertEquals((Object)initialBrokerIds.toSet(), (Object)((IterableOnceOps)aliveBrokersFromCache.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id))).toSet());
    }

    @ParameterizedTest
    @MethodSource(value={"zkCacheProvider"})
    public void testGetClusterMetadataWithOfflineReplicas(MetadataCache cache) {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("r").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(1).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava()), (List)Nil$.MODULE$));
        int controllerEpoch = 1;
        int leader = 1;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        java.util.List<Integer> offline = Arrays.asList(Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(topicPartition.partition()).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas).setOfflineReplicas(offline), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Node expectedNode0 = new Node(0, "foo", 9092, "r");
        Node expectedNode1 = new Node(1, "", -1);
        Cluster cluster = cache.getClusterMetadata("clusterId", listenerName);
        Assertions.assertEquals((Object)expectedNode0, (Object)cluster.nodeById(0));
        Assertions.assertNull((Object)cluster.nodeById(1));
        Assertions.assertEquals((Object)expectedNode1, (Object)cluster.leaderFor(topicPartition));
        PartitionInfo partitionInfo = cluster.partition(topicPartition);
        Assertions.assertEquals((Object)expectedNode1, (Object)partitionInfo.leader());
        Assertions.assertEquals((Object)new .colon.colon((Object)expectedNode0, (List)new .colon.colon((Object)expectedNode1, (List)Nil$.MODULE$)), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.replicas())));
        Assertions.assertEquals((Object)new .colon.colon((Object)expectedNode0, (List)new .colon.colon((Object)expectedNode1, (List)Nil$.MODULE$)), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.inSyncReplicas())));
        Assertions.assertEquals((Object)new .colon.colon((Object)expectedNode1, (List)Nil$.MODULE$), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.offlineReplicas())));
    }

    @Test
    public void testIsBrokerFenced() {
        int kRaftMetadataCache_brokerId = 0;
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(kRaftMetadataCache_brokerId);
        MetadataDelta delta = new MetadataDelta.Builder().build();
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setFenced(false));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertFalse((boolean)metadataCache.isBrokerFenced(0));
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(0).setFenced((byte)1));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertTrue((boolean)metadataCache.isBrokerFenced(0));
    }

    @Test
    public void testGetAliveBrokersWithBrokerFenced() {
        int kRaftMetadataCache_brokerId = 0;
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(kRaftMetadataCache_brokerId);
        String listenerName = "listener";
        RegisterBrokerRecord.BrokerEndpointCollection endpoints = new RegisterBrokerRecord.BrokerEndpointCollection();
        endpoints.add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setName(listenerName).setHost("foo").setPort(123).setSecurityProtocol((short)0));
        MetadataDelta delta = new MetadataDelta.Builder().build();
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setFenced(false).setEndPoints(endpoints));
        delta.replay(new RegisterBrokerRecord().setBrokerId(1).setFenced(false).setEndPoints(endpoints));
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(1).setFenced((byte)1));
        MetadataImage metadataImage = delta.apply(MetadataProvenance.EMPTY);
        metadataCache.setImage(metadataImage);
        Assertions.assertFalse((boolean)metadataCache.isBrokerFenced(0));
        Assertions.assertTrue((boolean)metadataCache.isBrokerFenced(1));
        scala.collection.immutable.Set aliveBrokers = ((IterableOnceOps)metadataCache.getAliveBrokers().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id))).toSet();
        metadataImage.cluster().brokers().forEach((brokerId, registration) -> {
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((!registration.fenced() ? 1 : 0) != 0), (Object)BoxesRunTime.boxToBoolean((boolean)aliveBrokers.contains((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(brokerId)))));
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)aliveBrokers.contains((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(brokerId)))), (Object)BoxesRunTime.boxToBoolean((boolean)metadataCache.getAliveBrokerNode(Predef$.MODULE$.Integer2int(brokerId), new ListenerName(listenerName)).isDefined()));
        });
    }

    @Test
    public void testIsBrokerInControlledShutdown() {
        int kRaftMetadataCache_brokerId = 0;
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(kRaftMetadataCache_brokerId);
        MetadataDelta delta = new MetadataDelta.Builder().build();
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setInControlledShutdown(false));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertFalse((boolean)metadataCache.isBrokerShuttingDown(0));
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(0).setInControlledShutdown((byte)1));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertTrue((boolean)metadataCache.isBrokerShuttingDown(0));
    }

    @Test
    public void testGetLiveBrokerEpoch() {
        int kRaftMetadataCache_brokerId = 0;
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(kRaftMetadataCache_brokerId);
        MetadataDelta delta = new MetadataDelta.Builder().build();
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(100L).setFenced(false));
        delta.replay(new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(101L).setFenced(true));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertEquals((long)100L, (long)BoxesRunTime.unboxToLong((Object)metadataCache.getAliveBrokerEpoch(0).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)));
        Assertions.assertEquals((long)-1L, (long)BoxesRunTime.unboxToLong((Object)metadataCache.getAliveBrokerEpoch(1).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)));
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void testGetPartitionInfo(MetadataCache cache) {
        String topic = "topic";
        int partitionIndex = 0;
        int controllerEpoch = 1;
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(0));
        int zkVersion = 3;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(4));
        java.util.List<Integer> offlineReplicas = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(partitionIndex).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(zkVersion).setReplicas(replicas).setOfflineReplicas(offlineReplicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        int controllerId = 2;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("rack1").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), Collections.emptyMap(), false, AbstractControlRequest.Type.UNKNOWN).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)cache.getPartitionInfo(topic, partitionIndex).get();
        Assertions.assertEquals((Object)topic, (Object)partitionState.topicName());
        Assertions.assertEquals((int)partitionIndex, (int)partitionState.partitionIndex());
        if (cache instanceof ZkMetadataCache) {
            Assertions.assertEquals((int)controllerEpoch, (int)partitionState.controllerEpoch());
        } else {
            Assertions.assertEquals((int)-1, (int)partitionState.controllerEpoch());
        }
        Assertions.assertEquals((int)leader, (int)partitionState.leader());
        Assertions.assertEquals((int)leaderEpoch, (int)partitionState.leaderEpoch());
        Assertions.assertEquals(isr, (Object)partitionState.isr());
        Assertions.assertEquals((int)zkVersion, (int)partitionState.zkVersion());
        Assertions.assertEquals(replicas, (Object)partitionState.replicas());
        if (cache instanceof ZkMetadataCache) {
            Assertions.assertEquals(offlineReplicas, (Object)partitionState.offlineReplicas());
            return;
        }
    }

    public Tuple4<scala.collection.immutable.Map<String, Uuid>, AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>, scala.collection.immutable.Map<String, Uuid>, Seq<UpdateMetadataRequestData.UpdateMetadataPartitionState>> setupInitialAndFullMetadata() {
        AnyRefMap initialTopicStates = AnyRefMap$.MODULE$.empty();
        MetadataCacheTest.addTopic$1("test-topic-1", 3, initialTopicStates);
        MetadataCacheTest.addTopic$1("test-topic-2", 3, initialTopicStates);
        scala.collection.immutable.Map initialTopicIds = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test-topic-1"), (Object)Uuid.fromString((String)"IQ2F1tpCRoSbjfq4zBJwpg")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test-topic-2"), (Object)Uuid.fromString((String)"4N8_J-q7SdWHPFkos275pQ"))}));
        scala.collection.immutable.Map newTopicIds = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"different-topic"), (Object)Uuid.fromString((String)"DraFMNOJQOC5maTb1vtZ8Q"))}));
        .colon.colon newPartitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName("different-topic").setPartitionIndex(0).setControllerEpoch(42).setLeader(0).setLeaderEpoch(10).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))).setZkVersion(1).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))), (List)Nil$.MODULE$);
        return new Tuple4((Object)initialTopicIds, (Object)initialTopicStates, (Object)newTopicIds, (Object)newPartitionStates);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaybeInjectDeletedPartitionsFromFullMetadataRequest() {
        void var4_4;
        void var2_2;
        void var3_3;
        Tuple4<scala.collection.immutable.Map<String, Uuid>, AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>, scala.collection.immutable.Map<String, Uuid>, Seq<UpdateMetadataRequestData.UpdateMetadataPartitionState>> tuple4 = this.setupInitialAndFullMetadata();
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Map initialTopicIds = (scala.collection.immutable.Map)tuple4._1();
        AnyRefMap initialTopicStates = (AnyRefMap)tuple4._2();
        scala.collection.immutable.Map newTopicIds = (scala.collection.immutable.Map)tuple4._3();
        MetadataSnapshot initialSnapshot = new MetadataSnapshot((AnyRefMap)var3_3, (scala.collection.immutable.Map)var2_2, (Option)new Some((Object)new KRaftCachedControllerId(3000)), LongMap$.MODULE$.empty(), LongMap$.MODULE$.empty());
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(8, 1, 42, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava(), true, AbstractControlRequest.Type.FULL).build();
        Assertions.assertEquals((Object)new .colon.colon((Object)Uuid.fromString((String)"IQ2F1tpCRoSbjfq4zBJwpg"), (List)new .colon.colon((Object)Uuid.fromString((String)"4N8_J-q7SdWHPFkos275pQ"), (List)Nil$.MODULE$)), (Object)ZkMetadataCache$.MODULE$.maybeInjectDeletedPartitionsFromFullMetadataRequest(initialSnapshot, 42, updateMetadataRequest.topicStates()));
        AnyRefMap verifyTopicStates$1_finalTopicStates = AnyRefMap$.MODULE$.empty();
        updateMetadataRequest.topicStates().forEach(topicState -> {
            verifyTopicStates$1_finalTopicStates.put((Object)topicState.topicName(), (Object)LongMap$.MODULE$.empty());
            topicState.partitionStates().forEach(partitionState -> ((LongMap)verifyTopicStates$1_finalTopicStates.apply((Object)topicState.topicName())).put((long)partitionState.partitionIndex(), partitionState));
        });
        MetadataCacheTest.$anonfun$testMaybeInjectDeletedPartitionsFromFullMetadataRequest$3(verifyTopicStates$1_finalTopicStates);
        Object var10_7 = null;
        .colon.colon oneTopicPartitionState = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName("different-topic").setPartitionIndex(0).setControllerEpoch(42).setLeader(0).setLeaderEpoch(10).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))).setZkVersion(1).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))), (List)Nil$.MODULE$);
        updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(8, 1, 42, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)oneTopicPartitionState).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)var4_4).asJava(), true, AbstractControlRequest.Type.FULL).build();
        Assertions.assertEquals((Object)new .colon.colon((Object)Uuid.fromString((String)"IQ2F1tpCRoSbjfq4zBJwpg"), (List)new .colon.colon((Object)Uuid.fromString((String)"4N8_J-q7SdWHPFkos275pQ"), (List)Nil$.MODULE$)), (Object)ZkMetadataCache$.MODULE$.maybeInjectDeletedPartitionsFromFullMetadataRequest(initialSnapshot, 42, updateMetadataRequest.topicStates()));
        AnyRefMap verifyTopicStates$1_finalTopicStates2 = AnyRefMap$.MODULE$.empty();
        updateMetadataRequest.topicStates().forEach(topicState -> {
            verifyTopicStates$1_finalTopicStates.put((Object)topicState.topicName(), (Object)LongMap$.MODULE$.empty());
            topicState.partitionStates().forEach(partitionState -> ((LongMap)verifyTopicStates$1_finalTopicStates.apply((Object)topicState.topicName())).put((long)partitionState.partitionIndex(), partitionState));
        });
        MetadataCacheTest.$anonfun$testMaybeInjectDeletedPartitionsFromFullMetadataRequest$6(verifyTopicStates$1_finalTopicStates2);
        Object var11_9 = null;
        scala.collection.immutable.Seq allTopicStates = (scala.collection.immutable.Seq)((IterableOnceOps)var3_3.flatMap((Function1 & Serializable)x$11 -> ((MapOps)x$11._2()).values())).toSeq().$plus$plus((IterableOnce)oneTopicPartitionState);
        scala.collection.immutable.Map allTopicIds = (scala.collection.immutable.Map)var2_2.$plus$plus((IterableOnce)var4_4);
        updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(8, 1, 42, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)allTopicStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)allTopicIds).asJava(), true, AbstractControlRequest.Type.FULL).build();
        Assertions.assertEquals((Object)Seq$.MODULE$.empty(), (Object)ZkMetadataCache$.MODULE$.maybeInjectDeletedPartitionsFromFullMetadataRequest(initialSnapshot, 42, updateMetadataRequest.topicStates()));
        AnyRefMap verifyTopicStates$1_finalTopicStates3 = AnyRefMap$.MODULE$.empty();
        updateMetadataRequest.topicStates().forEach(topicState -> {
            verifyTopicStates$1_finalTopicStates.put((Object)topicState.topicName(), (Object)LongMap$.MODULE$.empty());
            topicState.partitionStates().forEach(partitionState -> ((LongMap)verifyTopicStates$1_finalTopicStates.apply((Object)topicState.topicName())).put((long)partitionState.partitionIndex(), partitionState));
        });
        MetadataCacheTest.$anonfun$testMaybeInjectDeletedPartitionsFromFullMetadataRequest$10(verifyTopicStates$1_finalTopicStates3);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHandleFullUpdateMetadataRequestInZkMigration() {
        void var2_2;
        void var3_3;
        void var4_4;
        void var5_5;
        Tuple4<scala.collection.immutable.Map<String, Uuid>, AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>, scala.collection.immutable.Map<String, Uuid>, Seq<UpdateMetadataRequestData.UpdateMetadataPartitionState>> tuple4 = this.setupInitialAndFullMetadata();
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Map initialTopicIds = (scala.collection.immutable.Map)tuple4._1();
        AnyRefMap initialTopicStates = (AnyRefMap)tuple4._2();
        scala.collection.immutable.Map newTopicIds = (scala.collection.immutable.Map)tuple4._3();
        Seq newPartitionStates = (Seq)tuple4._4();
        UpdateMetadataRequest updateMetadataRequest = MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$1(this, (Seq)var5_5, (scala.collection.immutable.Map)var4_4);
        updateMetadataRequest.data().setIsKRaftController(true);
        updateMetadataRequest.data().setType(AbstractControlRequest.Type.FULL.toByte());
        boolean verifyMetadataCache$1_zkMigrationEnabled = false;
        MetadataVersion verifyMetadataCache$1_x$2 = MetadataVersion.latest();
        BrokerFeatures verifyMetadataCache$1_x$4 = BrokerFeatures$.MODULE$.createEmpty();
        Seq verifyMetadataCache$1_x$5 = (Seq)Seq$.MODULE$.empty();
        int verifyMetadataCache$1_zkMetadataCache_brokerId = 1;
        ZkMetadataCache verifyMetadataCache$1_cache = new ZkMetadataCache(verifyMetadataCache$1_zkMetadataCache_brokerId, verifyMetadataCache$1_x$2, verifyMetadataCache$1_x$4, verifyMetadataCache$1_x$5, verifyMetadataCache$1_zkMigrationEnabled);
        verifyMetadataCache$1_cache.updateMetadata(1, (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(8, 1, 42, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)var3_3.flatMap((Function1 & Serializable)x$15 -> ((MapOps)x$15._2()).values())).toList()).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)var2_2).asJava()).build());
        verifyMetadataCache$1_cache.updateMetadata(1, updateMetadataRequest);
        MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$3(verifyMetadataCache$1_cache);
        Object var8_12 = null;
        Object var9_8 = null;
        Object var10_9 = null;
        Object var11_10 = null;
        updateMetadataRequest = MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$1(this, (Seq)var5_5, (scala.collection.immutable.Map)var4_4);
        boolean verifyMetadataCache$1_zkMigrationEnabled2 = true;
        MetadataVersion verifyMetadataCache$1_x$22 = MetadataVersion.latest();
        BrokerFeatures verifyMetadataCache$1_x$42 = BrokerFeatures$.MODULE$.createEmpty();
        Seq verifyMetadataCache$1_x$52 = (Seq)Seq$.MODULE$.empty();
        int verifyMetadataCache$1_zkMetadataCache_brokerId2 = 1;
        ZkMetadataCache verifyMetadataCache$1_cache2 = new ZkMetadataCache(verifyMetadataCache$1_zkMetadataCache_brokerId2, verifyMetadataCache$1_x$22, verifyMetadataCache$1_x$42, verifyMetadataCache$1_x$52, verifyMetadataCache$1_zkMigrationEnabled2);
        verifyMetadataCache$1_cache2.updateMetadata(1, (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(8, 1, 42, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)var3_3.flatMap((Function1 & Serializable)x$15 -> ((MapOps)x$15._2()).values())).toList()).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)var2_2).asJava()).build());
        verifyMetadataCache$1_cache2.updateMetadata(1, updateMetadataRequest);
        MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$4(verifyMetadataCache$1_cache2);
        Object var14_18 = null;
        Object var15_14 = null;
        Object var16_15 = null;
        Object var17_16 = null;
        updateMetadataRequest = MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$1(this, (Seq)var5_5, (scala.collection.immutable.Map)var4_4);
        updateMetadataRequest.data().setIsKRaftController(false);
        boolean verifyMetadataCache$1_zkMigrationEnabled3 = true;
        MetadataVersion verifyMetadataCache$1_x$23 = MetadataVersion.latest();
        BrokerFeatures verifyMetadataCache$1_x$43 = BrokerFeatures$.MODULE$.createEmpty();
        Seq verifyMetadataCache$1_x$53 = (Seq)Seq$.MODULE$.empty();
        int verifyMetadataCache$1_zkMetadataCache_brokerId3 = 1;
        ZkMetadataCache verifyMetadataCache$1_cache3 = new ZkMetadataCache(verifyMetadataCache$1_zkMetadataCache_brokerId3, verifyMetadataCache$1_x$23, verifyMetadataCache$1_x$43, verifyMetadataCache$1_x$53, verifyMetadataCache$1_zkMigrationEnabled3);
        verifyMetadataCache$1_cache3.updateMetadata(1, (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(8, 1, 42, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)var3_3.flatMap((Function1 & Serializable)x$15 -> ((MapOps)x$15._2()).values())).toList()).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)var2_2).asJava()).build());
        verifyMetadataCache$1_cache3.updateMetadata(1, updateMetadataRequest);
        MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$5(verifyMetadataCache$1_cache3);
        Object var20_24 = null;
        Object var21_20 = null;
        Object var22_21 = null;
        Object var23_22 = null;
        updateMetadataRequest = MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$1(this, (Seq)var5_5, (scala.collection.immutable.Map)var4_4);
        updateMetadataRequest.data().setType(AbstractControlRequest.Type.INCREMENTAL.toByte());
        boolean verifyMetadataCache$1_zkMigrationEnabled4 = true;
        MetadataVersion verifyMetadataCache$1_x$24 = MetadataVersion.latest();
        BrokerFeatures verifyMetadataCache$1_x$44 = BrokerFeatures$.MODULE$.createEmpty();
        Seq verifyMetadataCache$1_x$54 = (Seq)Seq$.MODULE$.empty();
        int verifyMetadataCache$1_zkMetadataCache_brokerId4 = 1;
        ZkMetadataCache verifyMetadataCache$1_cache4 = new ZkMetadataCache(verifyMetadataCache$1_zkMetadataCache_brokerId4, verifyMetadataCache$1_x$24, verifyMetadataCache$1_x$44, verifyMetadataCache$1_x$54, verifyMetadataCache$1_zkMigrationEnabled4);
        verifyMetadataCache$1_cache4.updateMetadata(1, (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(8, 1, 42, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)var3_3.flatMap((Function1 & Serializable)x$15 -> ((MapOps)x$15._2()).values())).toList()).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)var2_2).asJava()).build());
        verifyMetadataCache$1_cache4.updateMetadata(1, updateMetadataRequest);
        MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$6(verifyMetadataCache$1_cache4);
        Object var26_30 = null;
        Object var27_26 = null;
        Object var28_27 = null;
        Object var29_28 = null;
        updateMetadataRequest = MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$1(this, (Seq)var5_5, (scala.collection.immutable.Map)var4_4);
        updateMetadataRequest.data().setType(AbstractControlRequest.Type.UNKNOWN.toByte());
        boolean verifyMetadataCache$1_zkMigrationEnabled5 = true;
        MetadataVersion verifyMetadataCache$1_x$25 = MetadataVersion.latest();
        BrokerFeatures verifyMetadataCache$1_x$45 = BrokerFeatures$.MODULE$.createEmpty();
        Seq verifyMetadataCache$1_x$55 = (Seq)Seq$.MODULE$.empty();
        int verifyMetadataCache$1_zkMetadataCache_brokerId5 = 1;
        ZkMetadataCache verifyMetadataCache$1_cache5 = new ZkMetadataCache(verifyMetadataCache$1_zkMetadataCache_brokerId5, verifyMetadataCache$1_x$25, verifyMetadataCache$1_x$45, verifyMetadataCache$1_x$55, verifyMetadataCache$1_zkMigrationEnabled5);
        verifyMetadataCache$1_cache5.updateMetadata(1, (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(8, 1, 42, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)var3_3.flatMap((Function1 & Serializable)x$15 -> ((MapOps)x$15._2()).values())).toList()).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)var2_2).asJava()).build());
        verifyMetadataCache$1_cache5.updateMetadata(1, updateMetadataRequest);
        MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$7(verifyMetadataCache$1_cache5);
    }

    private static final Seq endpoints$2(int brokerId) {
        String host = new StringBuilder(4).append("foo-").append(brokerId).toString();
        return new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(host).setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT).value()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(host).setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL).value()), (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$getTopicMetadata$1(int brokerId) {
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava(MetadataCacheTest.endpoints$2(brokerId)).asJava()).setRack("rack1");
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$3(String topic$2, UpdateMetadataRequestData.UpdateMetadataPartitionState ps) {
        String string = ps.topicName();
        return !(string != null ? !string.equals(topic$2) : topic$2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$6(int partitionId$1, UpdateMetadataRequestData.UpdateMetadataPartitionState x$3) {
        return x$3.partitionIndex() == partitionId$1;
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadata$5(Seq topicPartitionStates$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)x0$1._1();
            int partitionId = x0$1._2$mcI$sp();
            Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
            Assertions.assertEquals((int)partitionId, (int)partitionMetadata.partitionIndex());
            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)topicPartitionStates$1.find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$getTopicMetadata$6(partitionId, x$3))).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(45).append("Unable to find partition state for partition ").append(partitionId).toString()));
            Assertions.assertEquals((int)partitionState.leader(), (int)partitionMetadata.leaderId());
            Assertions.assertEquals((int)partitionState.leaderEpoch(), (int)partitionMetadata.leaderEpoch());
            Assertions.assertEquals((Object)partitionState.isr(), (Object)partitionMetadata.isrNodes());
            Assertions.assertEquals((Object)partitionState.replicas(), (Object)partitionMetadata.replicaNodes());
            return;
        }
        throw new MatchError(null);
    }

    private static final void checkTopicMetadata$1(String topic, MetadataCache cache$1, ListenerName listenerName$1, HashMap topicIds$1, Seq partitionStates$1) {
        Seq topicMetadatas = cache$1.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName$1, cache$1.getTopicMetadata$default$3(), cache$1.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        Assertions.assertEquals((Object)topic, (Object)topicMetadata.name());
        Assertions.assertEquals(topicIds$1.get(topic), (Object)topicMetadata.topicId());
        Seq topicPartitionStates = (Seq)partitionStates$1.filter((Function1 & Serializable)ps -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$getTopicMetadata$3(topic, ps)));
        Buffer partitionMetadatas = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(topicMetadata.partitions()).asScala().sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.partitionIndex()), (Ordering)Ordering.Int$.MODULE$);
        Assertions.assertEquals((int)topicPartitionStates.size(), (int)partitionMetadatas.size(), (String)new StringBuilder(37).append("Unexpected partition count for topic ").append(topic).toString());
        ((IterableOnceOps)partitionMetadatas.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            MetadataCacheTest.$anonfun$getTopicMetadata$5(topicPartitionStates, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadata$2(MetadataCache cache$1, HashMap topicIds$1, Seq partitionStates$1, String topic0$1, String topic1$1, SecurityProtocol securityProtocol) {
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        MetadataCacheTest.checkTopicMetadata$1(topic0$1, cache$1, listenerName, topicIds$1, partitionStates$1);
        MetadataCacheTest.checkTopicMetadata$1(topic1$1, cache$1, listenerName, topicIds$1, partitionStates$1);
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$getAliveBrokersShouldNotBeMutatedByUpdateCache$1(int brokerId) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setRack("").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).value()), (List)Nil$.MODULE$)).asJava());
    }

    private final void updateCache$1(Seq brokerIds, String topic$3, MetadataCache cache$2) {
        Seq brokers = (Seq)brokerIds.map((Function1 & Serializable)brokerId -> MetadataCacheTest.$anonfun$getAliveBrokersShouldNotBeMutatedByUpdateCache$1(BoxesRunTime.unboxToInt((Object)brokerId)));
        int controllerEpoch = 1;
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic$3).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava(brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache$2, updateMetadataRequest);
    }

    public static final /* synthetic */ Option $anonfun$setupInitialAndFullMetadata$1(LongMap partitionMap$1, String name$1, int i) {
        return partitionMap$1.put((long)i, (Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(name$1).setPartitionIndex(i).setControllerEpoch(2).setLeader(0).setLeaderEpoch(10).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1))).setZkVersion(10).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))));
    }

    private static final void addTopic$1(String name, int partitions, AnyRefMap topicStates) {
        LongMap partitionMap = LongMap$.MODULE$.empty();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), partitions).foreach((Function1 & Serializable)i -> MetadataCacheTest.$anonfun$setupInitialAndFullMetadata$1(partitionMap, name, BoxesRunTime.unboxToInt((Object)i)));
        topicStates.put((Object)name, (Object)partitionMap);
    }

    private static final void verifyTopicStates$1(UpdateMetadataRequest updateMetadataRequest, Function1 verifier) {
        AnyRefMap finalTopicStates = AnyRefMap$.MODULE$.empty();
        updateMetadataRequest.topicStates().forEach(topicState -> {
            verifyTopicStates$1_finalTopicStates.put((Object)topicState.topicName(), (Object)LongMap$.MODULE$.empty());
            topicState.partitionStates().forEach(partitionState -> ((LongMap)verifyTopicStates$1_finalTopicStates.apply((Object)topicState.topicName())).put((long)partitionState.partitionIndex(), partitionState));
        });
        verifier.apply((Object)finalTopicStates);
    }

    public static final /* synthetic */ boolean $anonfun$testMaybeInjectDeletedPartitionsFromFullMetadataRequest$4(UpdateMetadataRequestData.UpdateMetadataPartitionState x$7) {
        return x$7.leader() == -2;
    }

    public static final /* synthetic */ boolean $anonfun$testMaybeInjectDeletedPartitionsFromFullMetadataRequest$5(UpdateMetadataRequestData.UpdateMetadataPartitionState x$8) {
        return x$8.leader() == -2;
    }

    public static final /* synthetic */ void $anonfun$testMaybeInjectDeletedPartitionsFromFullMetadataRequest$3(AnyRefMap topicStates) {
        Assertions.assertEquals((int)2, (int)topicStates.size());
        Assertions.assertEquals((int)3, (int)((MapOps)topicStates.apply((Object)"test-topic-1")).values().toSeq().count((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$testMaybeInjectDeletedPartitionsFromFullMetadataRequest$4(x$7))));
        Assertions.assertEquals((int)3, (int)((MapOps)topicStates.apply((Object)"test-topic-2")).values().toSeq().count((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$testMaybeInjectDeletedPartitionsFromFullMetadataRequest$5(x$8))));
    }

    public static final /* synthetic */ boolean $anonfun$testMaybeInjectDeletedPartitionsFromFullMetadataRequest$7(UpdateMetadataRequestData.UpdateMetadataPartitionState x$9) {
        return x$9.leader() == -2;
    }

    public static final /* synthetic */ boolean $anonfun$testMaybeInjectDeletedPartitionsFromFullMetadataRequest$8(UpdateMetadataRequestData.UpdateMetadataPartitionState x$10) {
        return x$10.leader() == -2;
    }

    public static final /* synthetic */ void $anonfun$testMaybeInjectDeletedPartitionsFromFullMetadataRequest$6(AnyRefMap topicStates) {
        Assertions.assertEquals((int)3, (int)topicStates.size());
        Assertions.assertEquals((int)3, (int)((MapOps)topicStates.apply((Object)"test-topic-1")).values().toSeq().count((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$testMaybeInjectDeletedPartitionsFromFullMetadataRequest$7(x$9))));
        Assertions.assertEquals((int)3, (int)((MapOps)topicStates.apply((Object)"test-topic-2")).values().toSeq().count((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$testMaybeInjectDeletedPartitionsFromFullMetadataRequest$8(x$10))));
    }

    public static final /* synthetic */ boolean $anonfun$testMaybeInjectDeletedPartitionsFromFullMetadataRequest$11(UpdateMetadataRequestData.UpdateMetadataPartitionState x$12) {
        return x$12.leader() == -2;
    }

    public static final /* synthetic */ boolean $anonfun$testMaybeInjectDeletedPartitionsFromFullMetadataRequest$12(UpdateMetadataRequestData.UpdateMetadataPartitionState x$13) {
        return x$13.leader() == -2;
    }

    public static final /* synthetic */ void $anonfun$testMaybeInjectDeletedPartitionsFromFullMetadataRequest$10(AnyRefMap topicStates) {
        Assertions.assertEquals((int)3, (int)topicStates.size());
        Assertions.assertEquals((int)0, (int)((MapOps)topicStates.apply((Object)"test-topic-1")).values().toSeq().count((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$testMaybeInjectDeletedPartitionsFromFullMetadataRequest$11(x$12))));
        Assertions.assertEquals((int)0, (int)((MapOps)topicStates.apply((Object)"test-topic-2")).values().toSeq().count((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$testMaybeInjectDeletedPartitionsFromFullMetadataRequest$12(x$13))));
    }

    public static final /* synthetic */ UpdateMetadataRequest $anonfun$testHandleFullUpdateMetadataRequestInZkMigration$1(MetadataCacheTest $this, Seq newPartitionStates$1, scala.collection.immutable.Map newTopicIds$1) {
        return (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(8, 1, 42, $this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava(newPartitionStates$1).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)newTopicIds$1).asJava(), true, AbstractControlRequest.Type.FULL).build();
    }

    private final void verifyMetadataCache$1(UpdateMetadataRequest updateMetadataRequest, boolean zkMigrationEnabled, Function1 verifier, AnyRefMap initialTopicStates$1, scala.collection.immutable.Map initialTopicIds$1) {
        MetadataVersion x$2 = MetadataVersion.latest();
        BrokerFeatures x$4 = BrokerFeatures$.MODULE$.createEmpty();
        Seq x$5 = (Seq)Seq$.MODULE$.empty();
        int zkMetadataCache_brokerId = 1;
        ZkMetadataCache cache = new ZkMetadataCache(zkMetadataCache_brokerId, x$2, x$4, x$5, zkMigrationEnabled);
        cache.updateMetadata(1, (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(8, 1, 42, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)initialTopicStates$1.flatMap((Function1 & Serializable)x$15 -> ((MapOps)x$15._2()).values())).toList()).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)initialTopicIds$1).asJava()).build());
        cache.updateMetadata(1, updateMetadataRequest);
        verifier.apply((Object)cache);
    }

    private static final boolean verifyMetadataCache$default$2$1() {
        return true;
    }

    public static final /* synthetic */ void $anonfun$testHandleFullUpdateMetadataRequestInZkMigration$3(ZkMetadataCache cache) {
        Assertions.assertEquals((int)3, (int)cache.getAllTopics().size());
        Assertions.assertTrue((boolean)cache.contains("test-topic-1"));
        Assertions.assertTrue((boolean)cache.contains("test-topic-1"));
    }

    public static final /* synthetic */ void $anonfun$testHandleFullUpdateMetadataRequestInZkMigration$4(ZkMetadataCache cache) {
        Assertions.assertEquals((int)1, (int)cache.getAllTopics().size());
        Assertions.assertFalse((boolean)cache.contains("test-topic-1"));
        Assertions.assertFalse((boolean)cache.contains("test-topic-1"));
    }

    public static final /* synthetic */ void $anonfun$testHandleFullUpdateMetadataRequestInZkMigration$5(ZkMetadataCache cache) {
        Assertions.assertEquals((int)3, (int)cache.getAllTopics().size());
        Assertions.assertTrue((boolean)cache.contains("test-topic-1"));
        Assertions.assertTrue((boolean)cache.contains("test-topic-1"));
    }

    public static final /* synthetic */ void $anonfun$testHandleFullUpdateMetadataRequestInZkMigration$6(ZkMetadataCache cache) {
        Assertions.assertEquals((int)3, (int)cache.getAllTopics().size());
        Assertions.assertTrue((boolean)cache.contains("test-topic-1"));
        Assertions.assertTrue((boolean)cache.contains("test-topic-1"));
    }

    public static final /* synthetic */ void $anonfun$testHandleFullUpdateMetadataRequestInZkMigration$7(ZkMetadataCache cache) {
        Assertions.assertEquals((int)3, (int)cache.getAllTopics().size());
        Assertions.assertTrue((boolean)cache.contains("test-topic-1"));
        Assertions.assertTrue((boolean)cache.contains("test-topic-1"));
    }

    public MetadataCacheTest() {
        this.brokerEpoch = 0L;
    }

    public static final /* synthetic */ Object $anonfun$getTopicMetadata$2$adapted(MetadataCache cache$1, HashMap topicIds$1, Seq partitionStates$1, String topic0$1, String topic1$1, SecurityProtocol securityProtocol) {
        MetadataCacheTest.$anonfun$getTopicMetadata$2(cache$1, topicIds$1, partitionStates$1, topic0$1, topic1$1, securityProtocol);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testMaybeInjectDeletedPartitionsFromFullMetadataRequest$3$adapted(AnyRefMap topicStates) {
        MetadataCacheTest.$anonfun$testMaybeInjectDeletedPartitionsFromFullMetadataRequest$3(topicStates);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testMaybeInjectDeletedPartitionsFromFullMetadataRequest$6$adapted(AnyRefMap topicStates) {
        MetadataCacheTest.$anonfun$testMaybeInjectDeletedPartitionsFromFullMetadataRequest$6(topicStates);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testMaybeInjectDeletedPartitionsFromFullMetadataRequest$10$adapted(AnyRefMap topicStates) {
        MetadataCacheTest.$anonfun$testMaybeInjectDeletedPartitionsFromFullMetadataRequest$10(topicStates);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testHandleFullUpdateMetadataRequestInZkMigration$3$adapted(ZkMetadataCache cache) {
        MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$3(cache);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testHandleFullUpdateMetadataRequestInZkMigration$4$adapted(ZkMetadataCache cache) {
        MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$4(cache);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testHandleFullUpdateMetadataRequestInZkMigration$5$adapted(ZkMetadataCache cache) {
        MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$5(cache);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testHandleFullUpdateMetadataRequestInZkMigration$6$adapted(ZkMetadataCache cache) {
        MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$6(cache);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testHandleFullUpdateMetadataRequestInZkMigration$7$adapted(ZkMetadataCache cache) {
        MetadataCacheTest.$anonfun$testHandleFullUpdateMetadataRequestInZkMigration$7(cache);
        return BoxedUnit.UNIT;
    }
}

