/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005E4Aa\u0002\u0005\u0001\u001b!)!\u0003\u0001C\u0001'!)Q\u0003\u0001C\u0001-!)!\u0006\u0001C\u0001-!)A\u0006\u0001C\u0005[!)a\u000b\u0001C\u0005/\")!\u000e\u0001C\u0005W\n\u0001sJ\u001a4tKR\u001chi\u001c:MK\u0006$WM]#q_\u000eD'+Z9vKN$H+Z:u\u0015\tI!\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0017\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u000f!\ty\u0001#D\u0001\t\u0013\t\t\u0002BA\bCCN,'+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\tA\u0003\u0005\u0002\u0010\u0001\u0005\u0019C/Z:u\u001f\u001a47/\u001a;t\r>\u0014H*Z1eKJ,\u0005o\\2i\u000bJ\u0014xN]\"pI\u0016\u001cH#A\f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005y\u0001\"a\b\u0015\u000e\u0003\u0001R!!\t\u0012\u0002\u0007\u0005\u0004\u0018N\u0003\u0002$I\u00059!.\u001e9ji\u0016\u0014(BA\u0013'\u0003\u0015QWO\\5u\u0015\u00059\u0013aA8sO&\u0011\u0011\u0006\t\u0002\u0005)\u0016\u001cH/\u0001\u000euKN$8)\u001e:sK:$X\t]8dQZ\u000bG.\u001b3bi&|g\u000e\u000b\u0002\u0004=\u0005\tsN\u001a4tKR4uN\u001d'fC\u0012,'\u000fV8qS\u000e\u001cu\u000e\u001c7fGRLwN\u001c$peR!a&S(U!\tycI\u0004\u00021\u0007:\u0011\u0011\u0007\u0011\b\u0003eur!aM\u001e\u000f\u0005QJdBA\u001b9\u001b\u00051$BA\u001c\r\u0003\u0019a$o\\8u}%\tq%\u0003\u0002;M\u00051\u0011\r]1dQ\u0016L!a\u0003\u001f\u000b\u0005i2\u0013B\u0001 @\u0003\u0019\u0019w.\\7p]*\u00111\u0002P\u0005\u0003\u0003\n\u000bq!\\3tg\u0006<WM\u0003\u0002?\u007f%\u0011A)R\u0001 \u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195SKF,Xm\u001d;ECR\f'BA!C\u0013\t9\u0005J\u0001\u0010PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s)>\u0004\u0018nY\"pY2,7\r^5p]*\u0011A)\u0012\u0005\u0006\u0015\u0012\u0001\raS\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\taU*D\u0001C\u0013\tq%I\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000bA#\u0001\u0019A)\u0002\u00171,\u0017\rZ3s\u000bB|7\r\u001b\t\u00031IK!aU\r\u0003\u0007%sG\u000fC\u0003V\t\u0001\u0007\u0011+\u0001\ndkJ\u0014XM\u001c;MK\u0006$WM]#q_\u000eD\u0017aE1tg\u0016\u0014HOU3ta>t7/Z#se>\u0014H\u0003B\fYA\nDQ!W\u0003A\u0002i\u000bQ!\u001a:s_J\u0004\"a\u00170\u000e\u0003qS!!\u0018\"\u0002\u0011A\u0014x\u000e^8d_2L!a\u0018/\u0003\r\u0015\u0013(o\u001c:t\u0011\u0015\tW\u00011\u0001R\u0003!\u0011'o\\6fe&#\u0007\"B2\u0006\u0001\u0004!\u0017a\u0002:fcV,7\u000f\u001e\t\u0003K\"l\u0011A\u001a\u0006\u0003O\n\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u0003S\u001a\u0014Ad\u00144gg\u0016$8OR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NU3rk\u0016\u001cH/A\u0006tK:$'+Z9vKN$Hc\u00017paB\u0011Q-\\\u0005\u0003]\u001a\u0014Qd\u00144gg\u0016$8OR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NU3ta>t7/\u001a\u0005\u0006C\u001a\u0001\r!\u0015\u0005\u0006G\u001a\u0001\r\u0001\u001a")
public class OffsetsForLeaderEpochRequestTest
extends BaseRequestTest {
    @Test
    public void testOffsetsForLeaderEpochErrorCodes() {
        String topic = "topic";
        TopicPartition partition = new TopicPartition(topic, 0);
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection epochs = this.offsetForLeaderTopicCollectionFor(partition, 0, -1);
        OffsetsForLeaderEpochRequest request = (OffsetsForLeaderEpochRequest)OffsetsForLeaderEpochRequest.Builder.forFollower((short)ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(), (OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection)epochs, (int)1).build();
        int randomBrokerId = ((KafkaServer)this.servers().head()).config().brokerId();
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, request);
        Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 2, (Seq<KafkaBroker>)this.servers(), new Properties());
        Set replicas = this.zkClient().getReplicasForPartition(partition).toSet();
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition.partition())));
        int follower = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)(JFunction1.mcZI.sp & Serializable)x$1 -> x$1 != leader).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.servers().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)OffsetsForLeaderEpochRequestTest.$anonfun$testOffsetsForLeaderEpochErrorCodes$2(x$2)))).find((Function1)(JFunction1.mcZI.sp & Serializable)x$3 -> !replicas.contains((Object)BoxesRunTime.boxToInteger((int)x$3))).get());
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, follower, request);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, request);
    }

    @Test
    public void testCurrentEpochValidation() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaBroker>)this.servers(), new Properties()).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.servers(), topicPartition, firstLeaderId, 15000L);
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaBroker>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaBroker>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NOT_LEADER_OR_FOLLOWER, followerId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NOT_LEADER_OR_FOLLOWER, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
    }

    private OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection offsetForLeaderTopicCollectionFor(TopicPartition topicPartition, int leaderEpoch, int currentLeaderEpoch) {
        return new OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setTopic(topicPartition.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(topicPartition.partition()).setLeaderEpoch(leaderEpoch).setCurrentLeaderEpoch(currentLeaderEpoch), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$).iterator()).asJava());
    }

    private void assertResponseError(Errors error, int brokerId, OffsetsForLeaderEpochRequest request) {
        OffsetsForLeaderEpochResponse response = this.sendRequest(brokerId, request);
        Assertions.assertEquals((int)request.data().topics().size(), (int)response.data().topics().size());
        CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)response.data().topics()).asScala().foreach((Function1 & Serializable)offsetForLeaderTopic -> {
            OffsetsForLeaderEpochRequestTest.$anonfun$assertResponseError$1(request, error, offsetForLeaderTopic);
            return BoxedUnit.UNIT;
        });
    }

    private OffsetsForLeaderEpochResponse sendRequest(int brokerId, OffsetsForLeaderEpochRequest request) {
        return (OffsetsForLeaderEpochResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(brokerId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(OffsetsForLeaderEpochResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    public static final /* synthetic */ int $anonfun$testOffsetsForLeaderEpochErrorCodes$2(KafkaServer x$2) {
        return x$2.config().brokerId();
    }

    private final void assertResponseErrorForEpoch$1(Errors error, int brokerId, Optional currentLeaderEpoch, TopicPartition topicPartition$1) {
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection epochs = this.offsetForLeaderTopicCollectionFor(topicPartition$1, 0, Predef$.MODULE$.Integer2int(currentLeaderEpoch.orElse(Predef$.MODULE$.int2Integer(-1))));
        OffsetsForLeaderEpochRequest request = (OffsetsForLeaderEpochRequest)OffsetsForLeaderEpochRequest.Builder.forFollower((short)ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(), (OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection)epochs, (int)1).build();
        this.assertResponseError(error, brokerId, request);
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$2(Errors error$1, OffsetForLeaderEpochResponseData.EpochEndOffset offsetForLeaderPartition) {
        Assertions.assertEquals((short)error$1.code(), (short)offsetForLeaderPartition.errorCode());
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$1(OffsetsForLeaderEpochRequest request$1, Errors error$1, OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult offsetForLeaderTopic) {
        Assertions.assertEquals((int)request$1.data().topics().find(offsetForLeaderTopic.topic()).partitions().size(), (int)offsetForLeaderTopic.partitions().size());
        CollectionConverters$.MODULE$.ListHasAsScala(offsetForLeaderTopic.partitions()).asScala().foreach((Function1 & Serializable)offsetForLeaderPartition -> {
            OffsetsForLeaderEpochRequestTest.$anonfun$assertResponseError$2(error$1, offsetForLeaderPartition);
            return BoxedUnit.UNIT;
        });
    }
}

