/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.server;

import kafka.network.SocketServer;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.IntegrationTestUtils$;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.RaftClusterInvocationContext;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.$less$colon$less$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Timeout(value=120L)
@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(clusterType=Type.KRAFT)
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u0005Ea\u0001B\u0004\t\u0001=A\u0001B\u0006\u0001\u0003\u0002\u0003\u0006Ia\u0006\u0005\u0006=\u0001!\ta\b\u0005\u0006G\u0001!\t\u0001\n\u0005\u0006_\u0001!\t\u0001\n\u0005\u0006g\u0001!I\u0001\u000e\u0005\u0006\u001d\u0002!Ia\u0014\u0002\u001f\u00032dwnY1uKB\u0013x\u000eZ;dKJLEm\u001d*fcV,7\u000f\u001e+fgRT!!\u0003\u0006\u0002\rM,'O^3s\u0015\tYA\"A\u0003lC\u001a\\\u0017MC\u0001\u000e\u0003\u0011)h.\u001b;\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0002\u000f\rdWo\u001d;feB\u0011\u0001\u0004H\u0007\u00023)\u0011!dG\u0001\u0005i\u0016\u001cHOC\u0001\f\u0013\ti\u0012DA\bDYV\u001cH/\u001a:J]N$\u0018M\\2f\u0003\u0019a\u0014N\\5u}Q\u0011\u0001E\t\t\u0003C\u0001i\u0011\u0001\u0003\u0005\u0006-\t\u0001\raF\u0001(i\u0016\u001cH/\u00117m_\u000e\fG/\u001a)s_\u0012,8-\u001a:t\u0013\u0012\u001cVM\u001c;U_\u000e{g\u000e\u001e:pY2,'\u000fF\u0001&!\t\tb%\u0003\u0002(%\t!QK\\5uQ\t\u0019\u0011\u0006\u0005\u0002+[5\t1F\u0003\u0002-3\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u00059Z#aC\"mkN$XM\u001d+fgR\f!\u0006^3ti\u0006cGn\\2bi\u0016\u0004&o\u001c3vG\u0016\u00148/\u00133TK:$Hk\u001c(p]\u000e{g\u000e\u001e:pY2,'\u000f\u000b\u0003\u0005SE\u0012\u0014aC2p]R\u0014x\u000e\u001c7feNl\u0012aA\u0001\"g\u0016tG-\u00118e%\u0016\u001cW-\u001b<f\u00032dwnY1uKB\u0013x\u000eZ;dKJLEm\u001d\u000b\u0004k\tK\u0005C\u0001\u001cA\u001b\u00059$B\u0001\u001d:\u0003!\u0011X-];fgR\u001c(B\u0001\u001e<\u0003\u0019\u0019w.\\7p]*\u00111\u0002\u0010\u0006\u0003{y\na!\u00199bG\",'\"A \u0002\u0007=\u0014x-\u0003\u0002Bo\tY\u0012\t\u001c7pG\u0006$X\r\u0015:pIV\u001cWM]%egJ+7\u000f]8og\u0016DQaQ\u0003A\u0002\u0011\u000bAb]8ve\u000e,'I]8lKJ\u0004\"!R$\u000e\u0003\u0019S!!C\u000e\n\u0005!3%\u0001\u0004\"s_.,'oU3sm\u0016\u0014\b\"\u0002&\u0006\u0001\u0004Y\u0015\u0001E2p]R\u0014x\u000e\u001c7feN+'O^3s!\t)E*\u0003\u0002N\r\n\u00012i\u001c8ue>dG.\u001a:TKJ4XM]\u0001\u0012G>tg.Z2u\u0003:$'+Z2fSZ,GcA\u001bQ1\")\u0011K\u0002a\u0001%\u000612m\u001c8ue>dG.\u001a:T_\u000e\\W\r^*feZ,'\u000f\u0005\u0002T-6\tAK\u0003\u0002V7\u00059a.\u001a;x_J\\\u0017BA,U\u00051\u0019vnY6fiN+'O^3s\u0011\u0015If\u00011\u0001[\u0003\u001d\u0011X-];fgR\u0004\"AN.\n\u0005q;$AG!mY>\u001c\u0017\r^3Qe>$WoY3s\u0013\u0012\u001c(+Z9vKN$\b\u0006\u0002\u0001_Q&\u0004\"a\u00184\u000e\u0003\u0001T!!\u00192\u0002\u0007\u0005\u0004\u0018N\u0003\u0002dI\u00069!.\u001e9ji\u0016\u0014(BA3?\u0003\u0015QWO\\5u\u0013\t9\u0007MA\u0002UC\u001e\fQA^1mk\u0016\f\u0013A[\u0001\fS:$Xm\u001a:bi&|g\u000e\u000b\u0003\u0001Y>\u0004\bC\u0001\u0016n\u0013\tq7FA\nDYV\u001cH/\u001a:UKN$H)\u001a4bk2$8/A\u0006dYV\u001cH/\u001a:UsB,G%A9\n\u0005I\u001c\u0018!B&S\u0003\u001a#&B\u0001;,\u0003\u0011!\u0016\u0010]3)\t\u00011\b\u000e \t\u0003ojl\u0011\u0001\u001f\u0006\u0003s\u0002\f\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\u0005mD(AC#yi\u0016tGmV5uQ2\nQpI\u0001\u007f!\ry\u00181A\u0007\u0003\u0003\u0003Q!!Z\r\n\t\u0005\u0015\u0011\u0011\u0001\u0002\u0016\u00072,8\u000f^3s)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8tQ\u0019\u0001\u0011\u0011\u00025\u0002\u0010A\u0019q,a\u0003\n\u0007\u00055\u0001MA\u0004US6,w.\u001e;\u001f\u0003a\u0004")
public class AllocateProducerIdsRequestTest {
    private final ClusterInstance cluster;

    @ClusterTest
    public void testAllocateProducersIdSentToController() {
        RaftClusterInvocationContext.RaftClusterInstance raftCluster = (RaftClusterInvocationContext.RaftClusterInstance)this.cluster;
        BrokerServer sourceBroker = raftCluster.brokers().findFirst().get();
        int controllerId = sourceBroker.raftManager().leaderAndEpoch().leaderId().getAsInt();
        ControllerServer controllerServer = raftCluster.controllers().filter(x$1 -> x$1.config().nodeId() == controllerId).findFirst().get();
        AllocateProducerIdsResponse allocateResponse = this.sendAndReceiveAllocateProducerIds(sourceBroker, controllerServer);
        Assertions.assertEquals((Object)Errors.NONE, (Object)allocateResponse.error());
        Assertions.assertEquals((int)1000, (int)allocateResponse.data().producerIdLen());
        Assertions.assertTrue((allocateResponse.data().producerIdStart() >= 0L ? 1 : 0) != 0);
    }

    @ClusterTest(controllers=3)
    public void testAllocateProducersIdSentToNonController() {
        RaftClusterInvocationContext.RaftClusterInstance raftCluster = (RaftClusterInvocationContext.RaftClusterInstance)this.cluster;
        BrokerServer sourceBroker = raftCluster.brokers().findFirst().get();
        int controllerId = sourceBroker.raftManager().leaderAndEpoch().leaderId().getAsInt();
        ControllerServer controllerServer = raftCluster.controllers().filter(x$2 -> x$2.config().nodeId() != controllerId).findFirst().get();
        AllocateProducerIdsResponse allocateResponse = this.sendAndReceiveAllocateProducerIds(sourceBroker, controllerServer);
        Assertions.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)Errors.forCode((short)allocateResponse.data().errorCode()));
    }

    private AllocateProducerIdsResponse sendAndReceiveAllocateProducerIds(BrokerServer sourceBroker, ControllerServer controllerServer) {
        AllocateProducerIdsRequest allocateRequest = (AllocateProducerIdsRequest)new AllocateProducerIdsRequest.Builder(new AllocateProducerIdsRequestData().setBrokerId(sourceBroker.config().brokerId()).setBrokerEpoch(sourceBroker.lifecycleManager().brokerEpoch())).build();
        return this.connectAndReceive(controllerServer.socketServer(), allocateRequest);
    }

    private AllocateProducerIdsResponse connectAndReceive(SocketServer controllerSocketServer, AllocateProducerIdsRequest request) {
        return (AllocateProducerIdsResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, controllerSocketServer, this.cluster.controllerListenerName().get(), ClassTag$.MODULE$.apply(AllocateProducerIdsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    public AllocateProducerIdsRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }
}

