/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import kafka.log.UnifiedLog;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class LogManagerTest$ {
    public static final LogManagerTest$ MODULE$ = new LogManagerTest$();

    public UnifiedLog mockLog(TopicIdPartition topicIdPartition) {
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)log.topicId()).thenReturn((Object)new Some((Object)topicIdPartition.topicId()));
        Mockito.when((Object)log.topicPartition()).thenReturn((Object)topicIdPartition.topicPartition());
        return log;
    }

    public TopicImage topicImage(Map<TopicIdPartition, Seq<Object>> partitions) {
        ObjectRef topicName = ObjectRef.create(null);
        ObjectRef topicId = ObjectRef.create(null);
        partitions.keySet().foreach((Function1 & Serializable)partition -> {
            LogManagerTest$.$anonfun$topicImage$1(topicId, topicName, partition);
            return BoxedUnit.UNIT;
        });
        if ((Uuid)topicId.elem == null) {
            throw new IllegalArgumentException("Invalid empty partitions map.");
        }
        Map partitionRegistrations = (Map)partitions.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicIdPartition partition = (TopicIdPartition)x0$1._1();
                Seq replicas = (Seq)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition.partition())), (Object)new PartitionRegistration.Builder().setReplicas((int[])replicas.toArray((ClassTag)ClassTag$.MODULE$.Int())).setIsr((int[])replicas.toArray((ClassTag)ClassTag$.MODULE$.Int())).setLeader(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)replicas.head()))).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Predef$.MODULE$.int2Integer(0)).setPartitionEpoch(Predef$.MODULE$.int2Integer(0)).build());
            }
            throw new MatchError(null);
        });
        return new TopicImage((String)topicName.elem, (Uuid)topicId.elem, CollectionConverters$.MODULE$.MapHasAsJava(partitionRegistrations).asJava());
    }

    public TopicsImage topicsImage(Seq<TopicImage> topics) {
        ObjectRef retval = ObjectRef.create((Object)TopicsImage.EMPTY);
        topics.foreach((Function1 & Serializable)t -> {
            retval.elem = ((TopicsImage)retval.elem).including(t);
            return BoxedUnit.UNIT;
        });
        return (TopicsImage)retval.elem;
    }

    public LeaderAndIsrRequest createLeaderAndIsrRequestForStrayDetection(Iterable<TopicIdPartition> partitions, Iterable<Object> leaders) {
        Iterator nextLeaderIter = leaders.iterator();
        LeaderAndIsrRequestData data = new LeaderAndIsrRequestData().setControllerId(1000).setIsKRaftController(true).setType(AbstractControlRequest.Type.FULL.toByte());
        LinkedHashMap topics = new LinkedHashMap();
        partitions.foreach((Function1 & Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest$.$anonfun$createLeaderAndIsrRequestForStrayDetection$1(topics, nextLeaderIter, partition)));
        data.topicStates().addAll(topics.values());
        return new LeaderAndIsrRequest(data, (short)7);
    }

    public Iterable<Object> createLeaderAndIsrRequestForStrayDetection$default$2() {
        return Nil$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$topicImage$1(ObjectRef topicId$1, ObjectRef topicName$3, TopicIdPartition partition) {
        if ((Uuid)topicId$1.elem == null) {
            topicId$1.elem = partition.topicId();
        } else if (!((Uuid)topicId$1.elem).equals((Object)partition.topicId())) {
            throw new IllegalArgumentException("partition topic IDs did not match");
        }
        if ((String)topicName$3.elem == null) {
            topicName$3.elem = partition.topic();
            return;
        }
        if (!((String)topicName$3.elem).equals(partition.topic())) {
            throw new IllegalArgumentException("partition topic names did not match");
        }
    }

    private static final int nextLeader$1(Iterator nextLeaderIter$1) {
        if (nextLeaderIter$1.hasNext()) {
            return BoxesRunTime.unboxToInt((Object)nextLeaderIter$1.next());
        }
        return 3;
    }

    public static final /* synthetic */ boolean $anonfun$createLeaderAndIsrRequestForStrayDetection$1(LinkedHashMap topics$1, Iterator nextLeaderIter$1, TopicIdPartition partition) {
        return topics$1.computeIfAbsent(partition.topic(), x$40 -> new LeaderAndIsrRequestData.LeaderAndIsrTopicState().setTopicId(partition.topicId()).setTopicName(partition.topic())).partitionStates().add(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(partition.topic()).setPartitionIndex(partition.partition()).setControllerEpoch(123).setLeader(LogManagerTest$.nextLeader$1(nextLeaderIter$1)).setLeaderEpoch(456).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5))).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value()));
    }

    private LogManagerTest$() {
    }
}

