/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import kafka.server.BrokerTopicMetrics;
import kafka.server.BrokerTopicStats;
import kafka.server.BrokerTopicStats$;
import kafka.server.RequestLocal$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.UnsupportedCompressionTypeException;
import org.apache.kafka.common.errors.UnsupportedForMessageFormatException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.PrimitiveRef;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.LogValidator;
import org.apache.kafka.storage.internals.log.RecordValidationException;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r-g\u0001\u0002/^\u0001\tDQ!\u001b\u0001\u0005\u0002)Dq!\u001c\u0001C\u0002\u0013\u0005a\u000e\u0003\u0004}\u0001\u0001\u0006Ia\u001c\u0005\b{\u0002\u0011\r\u0011\"\u0001\u007f\u0011\u001d\t9\u0001\u0001Q\u0001\n}D\u0011\"!\u0003\u0001\u0005\u0004%\t!a\u0003\t\u0011\u0005U\u0002\u0001)A\u0005\u0003\u001bA\u0011\"a\u000e\u0001\u0005\u0004%\t!!\u000f\t\u0011\u0005U\u0003\u0001)A\u0005\u0003wAq!a\u0016\u0001\t\u0003\tI\u0006C\u0004\u0002x\u0001!\t!!\u0017\t\u000f\u0005m\u0004\u0001\"\u0001\u0002Z!9\u0011q\u0010\u0001\u0005\u0002\u0005e\u0003bBAB\u0001\u0011%\u0011Q\u0011\u0005\b\u0003K\u0003A\u0011BAT\u0011\u001d\ty\u000b\u0001C\u0005\u0003cCq!a0\u0001\t\u0013\t\t\rC\u0004\u0002z\u0002!\t!!\u0017\t\u000f\u0005u\b\u0001\"\u0001\u0002Z!9!\u0011\u0001\u0001\u0005\n\t\r\u0001b\u0002B\u0004\u0001\u0011\u0005\u0011\u0011\f\u0005\b\u0005\u0017\u0001A\u0011\u0002B\u0007\u0011\u001d\u0011\u0019\u0002\u0001C\u0001\u00033BqAa\u0006\u0001\t\u0003\tI\u0006C\u0004\u0003\u001c\u0001!IA!\b\t\u000f\t\u0005\u0002\u0001\"\u0001\u0002Z!9!Q\u0005\u0001\u0005\n\t\u001d\u0002b\u0002B\u001c\u0001\u0011%!\u0011\b\u0005\b\u0005\u007f\u0001A\u0011AA-\u0011\u001d\u0011\u0019\u0005\u0001C\u0001\u00033BqAa\u0012\u0001\t\u0013\u0011I\u0005C\u0004\u0003N\u0001!\t!!\u0017\t\u000f\tE\u0003\u0001\"\u0001\u0002Z!9!Q\u000b\u0001\u0005\n\t]\u0003b\u0002B.\u0001\u0011\u0005\u0011\u0011\f\u0005\b\u0005?\u0002A\u0011AA-\u0011\u001d\u0011\u0019\u0007\u0001C\u0005\u0005KBqAa\u001b\u0001\t\u0003\tI\u0006C\u0004\u0003p\u0001!\t!!\u0017\t\u000f\tM\u0004\u0001\"\u0001\u0002Z!9!q\u000f\u0001\u0005\n\te\u0004b\u0002B?\u0001\u0011\u0005\u0011\u0011\f\u0005\b\u0005\u0003\u0003A\u0011AA-\u0011\u001d\u0011)\t\u0001C\u0001\u00033BqA!#\u0001\t\u0003\tI\u0006C\u0004\u0003\u000e\u0002!\t!!\u0017\t\u000f\tE\u0005\u0001\"\u0001\u0002Z!9!Q\u0013\u0001\u0005\u0002\u0005e\u0003b\u0002BM\u0001\u0011\u0005\u0011\u0011\f\u0005\b\u0005;\u0003A\u0011AA-\u0011\u001d\u0011\t\u000b\u0001C\u0001\u00033BqA!*\u0001\t\u0003\tI\u0006C\u0004\u0003*\u0002!\t!!\u0017\t\u000f\t5\u0006\u0001\"\u0001\u0002Z!9!\u0011\u0017\u0001\u0005\u0002\u0005e\u0003b\u0002B[\u0001\u0011\u0005\u0011\u0011\f\u0005\b\u0005s\u0003A\u0011AA-\u0011\u001d\u0011i\f\u0001C\u0001\u00033BqA!1\u0001\t\u0003\tI\u0006C\u0004\u0003F\u0002!\t!!\u0017\t\u000f\t%\u0007\u0001\"\u0001\u0002Z!9!Q\u001a\u0001\u0005\u0002\u0005e\u0003b\u0002Bi\u0001\u0011\u0005\u0011\u0011\f\u0005\b\u0005+\u0004A\u0011AA-\u0011\u001d\u0011I\u000e\u0001C\u0001\u00033BqA!8\u0001\t\u0003\tI\u0006C\u0004\u0003b\u0002!\t!!\u0017\t\u000f\t\u0015\b\u0001\"\u0001\u0002Z!9!\u0011\u001e\u0001\u0005\u0002\u0005e\u0003b\u0002Bw\u0001\u0011\u0005\u0011\u0011\f\u0005\b\u0005c\u0004A\u0011AA-\u0011\u001d\u0011)\u0010\u0001C\u0001\u00033BqA!?\u0001\t\u0003\tI\u0006C\u0004\u0003~\u0002!\t!!\u0017\t\u000f\r\u0005\u0001\u0001\"\u0001\u0002Z!91Q\u0001\u0001\u0005\u0002\u0005e\u0003bBB\u0005\u0001\u0011\u0005\u0011\u0011\f\u0005\b\u0007\u001b\u0001A\u0011AA-\u0011\u001d\u0019\t\u0002\u0001C\u0005\u0007'Aqa!\b\u0001\t\u0013\u0019y\u0002C\u0005\u00044\u0001\t\n\u0011\"\u0003\u00046!911\n\u0001\u0005\n\r5\u0003\"CB+\u0001E\u0005I\u0011BB\u001b\u0011%\u00199\u0006AI\u0001\n\u0013\u0019I\u0006C\u0004\u0004^\u0001!Iaa\u0018\t\u000f\r\u001d\u0004\u0001\"\u0001\u0004j!91\u0011\u000f\u0001\u0005\n\rM\u0004bBB@\u0001\u0011%1\u0011\u0011\u0005\b\u0007\u001b\u0003A\u0011ABH\u0011\u001d\u0019y\n\u0001C\u0001\u0007CCqa!,\u0001\t\u0003\u0019yK\u0001\tM_\u001e4\u0016\r\\5eCR|'\u000fV3ti*\u0011alX\u0001\u0004Y><'\"\u00011\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0019\t\u0003I\u001el\u0011!\u001a\u0006\u0002M\u0006)1oY1mC&\u0011\u0001.\u001a\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Y\u0007C\u00017\u0001\u001b\u0005i\u0016\u0001\u0002;j[\u0016,\u0012a\u001c\t\u0003ajl\u0011!\u001d\u0006\u0003eN\fQ!\u001e;jYNT!\u0001^;\u0002\r\r|W.\\8o\u0015\t\u0001gO\u0003\u0002xq\u00061\u0011\r]1dQ\u0016T\u0011!_\u0001\u0004_J<\u0017BA>r\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\tq\u0010\u0005\u0003\u0002\u0002\u0005\rQ\"A:\n\u0007\u0005\u00151O\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\nQ\"\\3ue&\u001c7oS3z'\u0016$XCAA\u0007!\u0019\ty!!\u0007\u0002\u001e5\u0011\u0011\u0011\u0003\u0006\u0005\u0003'\t)\"A\u0004nkR\f'\r\\3\u000b\u0007\u0005]Q-\u0001\u0006d_2dWm\u0019;j_:LA!a\u0007\u0002\u0012\t\u00191+\u001a;\u0011\t\u0005}\u0011\u0011G\u0007\u0003\u0003CQA!a\t\u0002&\u0005!1m\u001c:f\u0015\u0011\t9#!\u000b\u0002\u000f5,GO]5dg*!\u00111FA\u0017\u0003\u0019I\u0018-\\7fe*\u0011\u0011qF\u0001\u0004G>l\u0017\u0002BA\u001a\u0003C\u0011!\"T3ue&\u001cg*Y7f\u00039iW\r\u001e:jGN\\U-_*fi\u0002\nq\"\\3ue&\u001c7OU3d_J$WM]\u000b\u0003\u0003w\u0001B!!\u0010\u0002P9!\u0011qHA&\u001b\t\t\tEC\u0002_\u0003\u0007RA!!\u0012\u0002H\u0005I\u0011N\u001c;fe:\fGn\u001d\u0006\u0004\u0003\u0013*\u0018aB:u_J\fw-Z\u0005\u0005\u0003\u001b\n\t%\u0001\u0007M_\u001e4\u0016\r\\5eCR|'/\u0003\u0003\u0002R\u0005M#aD'fiJL7m\u001d*fG>\u0014H-\u001a:\u000b\t\u00055\u0013\u0011I\u0001\u0011[\u0016$(/[2t%\u0016\u001cwN\u001d3fe\u0002\n\u0001\u0003^3ti>sG._(oK\n\u000bGo\u00195\u0015\u0005\u0005m\u0003c\u00013\u0002^%\u0019\u0011qL3\u0003\tUs\u0017\u000e\u001e\u0015\u0004\u0015\u0005\r\u0004\u0003BA3\u0003gj!!a\u001a\u000b\t\u0005%\u00141N\u0001\u0004CBL'\u0002BA7\u0003_\nqA[;qSR,'OC\u0002\u0002ra\fQA[;oSRLA!!\u001e\u0002h\t!A+Z:u\u0003M!Xm\u001d;BY2|w/T;mi&\u0014\u0015\r^2iQ\rY\u00111M\u00015i\u0016\u001cHOV1mS\u0012\fG/[8o\u001f\u001a\u0014\u0015\r^2iKN<\u0016\u000e\u001e5O_:\u001cV-];f]RL\u0017\r\\%o]\u0016\u0014xJ\u001a4tKR\u001c\bf\u0001\u0007\u0002d\u0005\tB/Z:u\u001b&\u001cX*\u0019;dQ6\u000bw-[2)\u00075\t\u0019'A\tdQ\u0016\u001c7n\u00148ms>sWMQ1uG\"$\u0002\"a\u0017\u0002\b\u0006E\u0015\u0011\u0015\u0005\b\u0003\u0013s\u0001\u0019AAF\u0003\u0015i\u0017mZ5d!\r!\u0017QR\u0005\u0004\u0003\u001f+'\u0001\u0002\"zi\u0016Dq!a%\u000f\u0001\u0004\t)*A\u000bt_V\u00148-Z\"p[B\u0014Xm]:j_:$\u0016\u0010]3\u0011\t\u0005]\u0015QT\u0007\u0003\u00033S1!a't\u0003\u0019\u0011XmY8sI&!\u0011qTAM\u0005=\u0019u.\u001c9sKN\u001c\u0018n\u001c8UsB,\u0007bBAR\u001d\u0001\u0007\u0011QS\u0001\u0016i\u0006\u0014x-\u001a;D_6\u0004(/Z:tS>tG+\u001f9f\u0003Q\u0019\u0007.Z2l\u00032dwn^'vYRL')\u0019;dQRA\u00111LAU\u0003W\u000bi\u000bC\u0004\u0002\n>\u0001\r!a#\t\u000f\u0005Mu\u00021\u0001\u0002\u0016\"9\u00111U\bA\u0002\u0005U\u0015AE2iK\u000e\\W*[:nCR\u001c\u0007.T1hS\u000e$\u0002\"a\u0017\u00024\u0006]\u00161\u0018\u0005\b\u0003k\u0003\u0002\u0019AAF\u0003)\u0011\u0017\r^2i\u001b\u0006<\u0017n\u0019\u0005\b\u0003s\u0003\u0002\u0019AAF\u0003-\u0011XmY8sI6\u000bw-[2\t\u000f\u0005u\u0006\u00031\u0001\u0002\u0016\u0006y1m\\7qe\u0016\u001c8/[8o)f\u0004X-\u0001\twC2LG-\u0019;f\u001b\u0016\u001c8/Y4fgRQ\u00111YAu\u0003g\f)0a>\u0011\t\u0005\u0015\u0017Q\u001d\b\u0005\u0003\u000f\fYE\u0004\u0003\u0002J\u0006\rh\u0002BAf\u0003CtA!!4\u0002`:!\u0011qZAo\u001d\u0011\t\t.a7\u000f\t\u0005M\u0017\u0011\\\u0007\u0003\u0003+T1!a6b\u0003\u0019a$o\\8u}%\t\u00110\u0003\u0002xq&\u0011\u0001M^\u0005\u0004\u0003\u0013*\u0018\u0002BA#\u0003\u000fJ1AXA\"\u0013\u0011\t9/a\u0015\u0003!Y\u000bG.\u001b3bi&|gNU3tk2$\bbBAv#\u0001\u0007\u0011Q^\u0001\be\u0016\u001cwN\u001d3t!\u0011\t9*a<\n\t\u0005E\u0018\u0011\u0014\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u000f\u0005%\u0015\u00031\u0001\u0002\f\"9\u00111S\tA\u0002\u0005U\u0005bBAR#\u0001\u0007\u0011QS\u0001!i\u0016\u001cH\u000fT8h\u0003B\u0004XM\u001c3US6,gj\u001c8D_6\u0004(/Z:tK\u00124\u0016\u0007K\u0002\u0013\u0003G\n\u0001\u0005^3ti2{w-\u00119qK:$G+[7f\u001d>t7i\\7qe\u0016\u001c8/\u001a3We!\u001a1#a\u0019\u0002?\rDWmY6M_\u001e\f\u0005\u000f]3oIRKW.\u001a(p]\u000e{W\u000e\u001d:fgN,G\r\u0006\u0003\u0002\\\t\u0015\u0001bBAE)\u0001\u0007\u00111R\u0001%i\u0016\u001cH\u000fT8h\u0003B\u0004XM\u001c3US6,w+\u001b;i%\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8Wc!\u001aQ#a\u0019\u0002G\rDWmY6M_\u001e\f\u0005\u000f]3oIRKW.Z,ji\"\u0014VmY8naJ,7o]5p]R!\u00111\fB\b\u0011\u001d\u0011\tB\u0006a\u0001\u0003\u0017\u000b1\u0002^1sO\u0016$X*Y4jG\u0006!C/Z:u\u0019><\u0017\t\u001d9f]\u0012$\u0016.\\3XSRD'+Z2p[B\u0014Xm]:j_:4&\u0007K\u0002\u0018\u0003G\nq\u0005^3ti2{w-\u00119qK:$G+[7f/&$\bn\\;u%\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8Wc!\u001a\u0001$a\u0019\u0002M\rDWmY6M_\u001e\f\u0005\u000f]3oIRKW.Z,ji\"|W\u000f\u001e*fG>l\u0007O]3tg&|g\u000e\u0006\u0003\u0002\\\t}\u0001bBAE3\u0001\u0007\u00111R\u0001%i\u0016\u001cH/\u00138wC2LGm\u00144gg\u0016$(+\u00198hK\u0006sGMU3d_J$7i\\;oi\"\u001a!$a\u0019\u0002A\u0005\u001c8/\u001a:u\u0013:4\u0018\r\\5e\u0005\u0006$8\r[\"pk:$xJ^3se&$Wm\u001d\u000b\u0007\u00037\u0012ICa\r\t\u000f\t-2\u00041\u0001\u0003.\u0005yA.Y:u\u001f\u001a47/\u001a;EK2$\u0018\rE\u0002e\u0005_I1A!\rf\u0005\rIe\u000e\u001e\u0005\b\u0005kY\u0002\u0019\u0001B\u0017\u0003\u0015\u0019w.\u001e8u\u0003\u00152\u0018\r\\5eCR,'+Z2pe\u0012\u0014\u0015\r^2i/&$\bnQ8v]R|e/\u001a:sS\u0012,7\u000f\u0006\u0004\u0002\\\tm\"Q\b\u0005\b\u0005Wa\u0002\u0019\u0001B\u0017\u0011\u001d\u0011)\u0004\ba\u0001\u0005[\tq\u0005^3ti2{w-\u00119qK:$G+[7f/&$\bn\\;u%\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8We!\u001aQ$a\u0019\u0002'Q,7\u000f\u001e(p]\u000e{W\u000e\u001d:fgN,GMV\u0019)\u0007y\t\u0019'\u0001\ndQ\u0016\u001c7NT8o\u0007>l\u0007O]3tg\u0016$G\u0003BA.\u0005\u0017Bq!!# \u0001\u0004\tY)A\nuKN$hj\u001c8D_6\u0004(/Z:tK\u00124&\u0007K\u0002!\u0003G\n1\u0003^3tiJ+7m\\7qe\u0016\u001c8/[8o-FB3!IA2\u0003I\u0019\u0007.Z2l%\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8\u0015\t\u0005m#\u0011\f\u0005\b\u0003\u0013\u0013\u0003\u0019AAF\u0003M!Xm\u001d;SK\u000e|W\u000e\u001d:fgNLwN\u001c,3Q\r\u0019\u00131M\u0001!i\u0016\u001cHo\u0011:fCR,G+[7f+B\u001cuN\u001c<feNLwN\u001c,1)>4\u0016\u0007K\u0002%\u0003G\n\u0011e\u00195fG.\u001c%/Z1uKRKW.Z+q\u0007>tg/\u001a:tS>tgI]8n-B\"B!a\u0017\u0003h!9!\u0011N\u0013A\u0002\u0005-\u0015a\u0002;p\u001b\u0006<\u0017nY\u0001!i\u0016\u001cHo\u0011:fCR,G+[7f+B\u001cuN\u001c<feNLwN\u001c,1)>4&\u0007K\u0002'\u0003G\n\u0001\u0005^3ti\u000e\u0013X-\u0019;f)&lW-\u00169D_:4XM]:j_:4\u0016\u0007V8We!\u001aq%a\u0019\u0002!Q,7\u000f^\"p[B\u0014Xm]:fIZ\u000b\u0004f\u0001\u0015\u0002d\u0005y1\r[3dW\u000e{W\u000e\u001d:fgN,G\r\u0006\u0003\u0002\\\tm\u0004bBAES\u0001\u0007\u00111R\u0001\u0011i\u0016\u001cHoQ8naJ,7o]3e-JB3AKA2\u0003\u0011\"Xm\u001d;J]Z\fG.\u001b3De\u0016\fG/\u001a+j[\u0016tuN\\\"p[B\u0014Xm]:fIZ\u000b\u0004fA\u0016\u0002d\u0005!C/Z:u\u0013:4\u0018\r\\5e\u0007J,\u0017\r^3US6,gj\u001c8D_6\u0004(/Z:tK\u00124&\u0007K\u0002-\u0003G\n\u0011\u0005^3ti&sg/\u00197jI\u000e\u0013X-\u0019;f)&lWmQ8naJ,7o]3e-FB3!LA2\u0003\u0005\"Xm\u001d;J]Z\fG.\u001b3De\u0016\fG/\u001a+j[\u0016\u001cu.\u001c9sKN\u001cX\r\u001a,3Q\rq\u00131M\u0001*i\u0016\u001cH/\u00112t_2,H/Z(gMN,G/Q:tS\u001etW.\u001a8u\u001d>t7i\\7qe\u0016\u001c8/\u001a3)\u0007=\n\u0019'\u0001\u0014uKN$\u0018IY:pYV$Xm\u00144gg\u0016$\u0018i]:jO:lWM\u001c;D_6\u0004(/Z:tK\u0012D3\u0001MA2\u0003-\"Xm\u001d;SK2\fG/\u001b<f\u001f\u001a47/\u001a;BgNLwM\\7f]RtuN\\\"p[B\u0014Xm]:fIZ\u000b\u0004fA\u0019\u0002d\u0005YC/Z:u%\u0016d\u0017\r^5wK>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$hj\u001c8D_6\u0004(/Z:tK\u00124&\u0007K\u00023\u0003G\n\u0001\u0006^3tiJ+G.\u0019;jm\u0016|eMZ:fi\u0006\u001b8/[4o[\u0016tGoQ8naJ,7o]3e-FB3aMA2\u0003!\"Xm\u001d;SK2\fG/\u001b<f\u001f\u001a47/\u001a;BgNLwM\\7f]R\u001cu.\u001c9sKN\u001cX\r\u001a,3Q\r!\u00141M\u00019i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'/\u00169D_:4XM]:j_:4\u0006\u0007V8Wc9{gnQ8naJ,7o]3eQ\r)\u00141M\u00019i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'/\u00169D_:4XM]:j_:4\u0006\u0007V8We9{gnQ8naJ,7o]3eQ\r1\u00141M\u00016i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'/\u00169D_:4XM]:j_:4\u0006\u0007V8Wc\r{W\u000e\u001d:fgN,G\rK\u00028\u0003G\nQ\u0007^3ti>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001a;feV\u00038i\u001c8wKJ\u001c\u0018n\u001c8WaQ{gKM\"p[B\u0014Xm]:fI\"\u001a\u0001(a\u0019\u0002OQ,7\u000f^\"p]R\u0014x\u000e\u001c*fG>\u0014Hm\u001d(pi\u0006cGn\\<fI\u001a\u0013x.\\\"mS\u0016tGo\u001d\u0015\u0004s\u0005\r\u0014a\b;fgR\u001cuN\u001c;s_2\u0014VmY8sINtu\u000e^\"p[B\u0014Xm]:fI\"\u001a!(a\u0019\u0002uQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM\u001d#po:\u001cuN\u001c<feNLwN\u001c,2)>4\u0006GT8o\u0007>l\u0007O]3tg\u0016$\u0007fA\u001e\u0002d\u00059D/Z:u\u001f\u001a47/\u001a;BgNLwM\\7f]R\fe\r^3s\t><hnQ8om\u0016\u00148/[8o-F\"vN\u0016\u0019D_6\u0004(/Z:tK\u0012D3\u0001PA2\u0003a\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:Va\u000e{gN^3sg&|gNV\u0019U_Z\u0013dj\u001c8D_6\u0004(/Z:tK\u0012D3!PA2\u0003U\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:Va\u000e{gN^3sg&|gNV\u0019U_Z\u00134i\\7qe\u0016\u001c8/\u001a3)\u0007y\n\u0019'\u0001\u001euKN$xJ\u001a4tKR\f5o]5h]6,g\u000e^!gi\u0016\u0014Hi\\<o\u0007>tg/\u001a:tS>tgK\r+p-FruN\\\"p[B\u0014Xm]:fI\"\u001aq(a\u0019\u0002oQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM\u001d#po:\u001cuN\u001c<feNLwN\u001c,3)>4\u0016gQ8naJ,7o]3eQ\r\u0001\u00151M\u00015i\u0016\u001cH\u000fR8x]\u000e{gN^3sg&|gn\u00144Ue\u0006t7/Y2uS>t\u0017\r\u001c*fG>\u0014Hm\u001d(piB+'/\\5ui\u0016$\u0007fA!\u0002d\u0005\tD/Z:u\t><hnQ8om\u0016\u00148/[8o\u001f\u001aLE-Z7q_R,g\u000e\u001e*fG>\u0014Hm\u001d(piB+'/\\5ui\u0016$\u0007f\u0001\"\u0002d\u0005QD/Z:u\u001f\u001a47/\u001a;BgNLwM\\7f]R\fe\r^3s\t><hnQ8om\u0016\u00148/[8o-J\"vN\u0016\u0019O_:\u001cu.\u001c9sKN\u001cX\r\u001a\u0015\u0004\u0007\u0006\r\u0014a\u000e;fgR|eMZ:fi\u0006\u001b8/[4o[\u0016tG/\u00114uKJ$un\u001e8D_:4XM]:j_:4&\u0007V8Wa\r{W\u000e\u001d:fgN,G\rK\u0002E\u0003G\n!\u0007^3ti:{g.\u00138de\u0016\f7/\u001b8h\u001f\u001a47/\u001a;SK\u000e|'\u000f\u001a\"bi\u000eD\u0007*Y:NKR\u0014\u0018nY:M_\u001e<W\r\u001a\u0015\u0004\u000b\u0006\r\u0014a\u000b;fgR\u001cu.\u001c9sKN\u001cX\r\u001a\"bi\u000eDw+\u001b;i_V$(+Z2pe\u0012\u001chj\u001c;BY2|w/\u001a3)\u0007\u0019\u000b\u0019'A\u0016uKN$(l\u0015;e\u0007>l\u0007O]3tg\u0016$w+\u001b;i+:\fg/Y5mC\ndW-\u0013\"Q-\u0016\u00148/[8oQ\r9\u00151M\u0001.i\u0016\u001cH/\u00168d_6\u0004(/Z:tK\u0012\u0014\u0015\r^2i/&$\bn\\;u%\u0016\u001cwN\u001d3t\u001d>$\u0018\t\u001c7po\u0016$\u0007f\u0001%\u0002d\u0005iC/Z:u%\u0016\u001cw.\u001c9sKN\u001cX\r\u001a\"bi\u000eDw+\u001b;i_V$(+Z2pe\u0012\u001chj\u001c;BY2|w/\u001a3)\u0007%\u000b\u0019'\u0001\u0016uKN$\u0018J\u001c<bY&$G+[7fgR\fW\u000e]#yG\u0016\u0004H/[8o\u0011\u0006\u001c()\u0019;dQ&sG-\u001a=)\u0007)\u000b\u0019'A\u0014uKN$\u0018J\u001c<bY&$'+Z2pe\u0012,\u0005pY3qi&|g\u000eS1t\u0005\u0006$8\r[%oI\u0016D\bfA&\u0002d\u0005qC/Z:u\u0005\u0006$8\r[,ji\"LeN^1mS\u0012\u0014VmY8sIN\fe\u000eZ%om\u0006d\u0017\u000e\u001a+j[\u0016\u001cH/Y7qQ\ra\u00151M\u0001&i\u0016\u001cHOU3d_J$w+\u001b;i!\u0006\u001cH\u000fV5nKN$\u0018-\u001c9JgJ+'.Z2uK\u0012D3!TA2\u0003\u001d\"Xm\u001d;SK\u000e|'\u000fZ,ji\"4U\u000f^;sKRKW.Z:uC6\u0004\u0018j\u001d*fU\u0016\u001cG/\u001a3)\u00079\u000b\u0019'A\u0011uKN$()\u0019;dQ^KG\u000f[8viJ+7m\u001c:eg:{G/\u00117m_^,G\r\u0006\u0004\u0002\\\rU1\u0011\u0004\u0005\b\u0007/y\u0005\u0019AAK\u0003E\u0019x.\u001e:dK\u000e{W\u000e\u001d:fgNLwN\u001c\u0005\b\u00077y\u0005\u0019AAK\u0003E!\u0018M]4fi\u000e{W\u000e\u001d:fgNLwN\\\u0001\u000eGJ,\u0017\r^3SK\u000e|'\u000fZ:\u0015\u0011\u000558\u0011EB\u0013\u0007_Aqaa\tQ\u0001\u0004\tY)\u0001\u0006nC\u001eL7MV1mk\u0016D\u0011ba\nQ!\u0003\u0005\ra!\u000b\u0002\u0013QLW.Z:uC6\u0004\bc\u00013\u0004,%\u00191QF3\u0003\t1{gn\u001a\u0005\b\u0007c\u0001\u0006\u0019AAK\u0003\u0015\u0019w\u000eZ3d\u0003]\u0019'/Z1uKJ+7m\u001c:eg\u0012\"WMZ1vYR$#'\u0006\u0002\u00048)\"1\u0011FB\u001dW\t\u0019Y\u0004\u0005\u0003\u0004>\r\u001dSBAB \u0015\u0011\u0019\tea\u0011\u0002\u0013Ut7\r[3dW\u0016$'bAB#K\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r%3q\b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001I2sK\u0006$XMT8o\u0013:\u001c'/Z1tS:<wJ\u001a4tKR\u0014VmY8sIN$\u0002\"!<\u0004P\rE31\u000b\u0005\b\u0007G\u0011\u0006\u0019AAF\u0011%\u00199C\u0015I\u0001\u0002\u0004\u0019I\u0003C\u0005\u00042I\u0003\n\u00111\u0001\u0002\u0016\u0006Q3M]3bi\u0016tuN\\%oGJ,\u0017m]5oO>3gm]3u%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\u0012\u0014AK2sK\u0006$XMT8o\u0013:\u001c'/Z1tS:<wJ\u001a4tKR\u0014VmY8sIN$C-\u001a4bk2$HeM\u000b\u0003\u00077RC!!&\u0004:\u000592M]3bi\u0016$vo\u001c\"bi\u000eDW\r\u001a*fG>\u0014Hm\u001d\u000b\t\u0003[\u001c\tga\u0019\u0004f!911E+A\u0002\u0005-\u0005bBB\u0014+\u0002\u00071\u0011\u0006\u0005\b\u0007c)\u0006\u0019AAK\u00031\u0019\u0007.Z2l\u001f\u001a47/\u001a;t)\u0019\tYfa\u001b\u0004n!9\u00111\u001e,A\u0002\u00055\bbBB8-\u0002\u00071\u0011F\u0001\u000bE\u0006\u001cXm\u00144gg\u0016$\u0018\u0001\n:fG>\u0014Hm],ji\"tuN\\*fcV,g\u000e^5bY&sg.\u001a:PM\u001a\u001cX\r^:\u0015\u0011\u000558QOB<\u0007wBqaa\tX\u0001\u0004\tY\tC\u0004\u0004z]\u0003\r!!&\u0002\u0017\r|W\u000e\u001d:fgNLwN\u001c\u0005\b\u0007{:\u0006\u0019\u0001B\u0017\u0003)qW/\u001c*fG>\u0014Hm]\u0001\u001de\u0016\u001cwN\u001d3t/&$\b.\u00138wC2LG-\u00138oKJl\u0015mZ5d)!\tioa!\u0004\b\u000e-\u0005bBBC1\u0002\u0007\u00111R\u0001\u0010E\u0006$8\r['bO&\u001cg+\u00197vK\"91\u0011\u0012-A\u0002\u0005-\u0015\u0001\u0005:fG>\u0014H-T1hS\u000e4\u0016\r\\;f\u0011\u001d\u0019\t\u0004\u0017a\u0001\u0003+\u000bq#\\1zE\u0016\u001c\u0005.Z2l\u0005\u0006\u001cX\rV5nKN$\u0018-\u001c9\u0015\r\u0005m3\u0011SBK\u0011\u001d\u0019\u0019*\u0017a\u0001\u0007S\t\u0001\"\u001a=qK\u000e$X\r\u001a\u0005\b\u0007/K\u0006\u0019ABM\u0003\u0015\u0011\u0017\r^2i!\u0011\t9ja'\n\t\ru\u0015\u0011\u0014\u0002\f%\u0016\u001cwN\u001d3CCR\u001c\u0007.A\u000bwC2LG-\u0019;f\u0019><\u0017\t\u001d9f]\u0012$\u0016.\\3\u0015\u0011\u0005m31UBT\u0007WCqa!*[\u0001\u0004\u0019I#A\u000bfqB,7\r^3e\u0019><\u0017\t\u001d9f]\u0012$\u0016.\\3\t\u000f\r%&\f1\u0001\u0004*\u0005)R\r\u001f9fGR,GMQ1tKRKW.Z:uC6\u0004\bbBBL5\u0002\u00071\u0011T\u0001\u001cm\u0016\u0014\u0018NZ=SK\u000e|'\u000fZ\"p]Z,'o]5p]N#\u0018\r^:\u0015\u0015\u0005m3\u0011WB^\u0007\u007f\u001b\t\rC\u0004\u00044n\u0003\ra!.\u0002\u000bM$\u0018\r^:\u0011\t\u0005]5qW\u0005\u0005\u0007s\u000bIJA\u000bSK\u000e|'\u000fZ\"p]Z,'o]5p]N#\u0018\r^:\t\u000f\ru6\f1\u0001\u0003.\u0005\u0019b.^7D_:4XM\u001d;fIJ+7m\u001c:eg\"9\u00111^.A\u0002\u00055\bbBBb7\u0002\u00071QY\u0001\u000bG>l\u0007O]3tg\u0016$\u0007c\u00013\u0004H&\u00191\u0011Z3\u0003\u000f\t{w\u000e\\3b]\u0002")
public class LogValidatorTest {
    private final Time time = Time.SYSTEM;
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final Set<MetricName> metricsKeySet = CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala();
    private final LogValidator.MetricsRecorder metricsRecorder;

    public Time time() {
        return this.time;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Set<MetricName> metricsKeySet() {
        return this.metricsKeySet;
    }

    public LogValidator.MetricsRecorder metricsRecorder() {
        return this.metricsRecorder;
    }

    @Test
    public void testOnlyOneBatch() {
        this.checkOnlyOneBatch((byte)0, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)1, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)2, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)0, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)1, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.NONE, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.NONE, CompressionType.GZIP);
    }

    @Test
    public void testAllowMultiBatch() {
        this.checkAllowMultiBatch((byte)0, CompressionType.NONE, CompressionType.NONE);
        this.checkAllowMultiBatch((byte)1, CompressionType.NONE, CompressionType.NONE);
        this.checkAllowMultiBatch((byte)0, CompressionType.NONE, CompressionType.GZIP);
        this.checkAllowMultiBatch((byte)1, CompressionType.NONE, CompressionType.GZIP);
    }

    @Test
    public void testValidationOfBatchesWithNonSequentialInnerOffsets() {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])RecordVersion.values()), (Function1 & Serializable)version -> {
            this.testMessageValidation$1(version.value);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testMisMatchMagic() {
        this.checkMismatchMagic((byte)0, (byte)1, CompressionType.GZIP);
        this.checkMismatchMagic((byte)1, (byte)0, CompressionType.GZIP);
    }

    private void checkOnlyOneBatch(byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        Assertions.assertThrows(InvalidRecordException.class, () -> this.validateMessages(this.createTwoBatchedRecords(magic, 0L, sourceCompressionType), magic, sourceCompressionType, targetCompressionType));
    }

    private void checkAllowMultiBatch(byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        this.validateMessages(this.createTwoBatchedRecords(magic, 0L, sourceCompressionType), magic, sourceCompressionType, targetCompressionType);
    }

    private void checkMismatchMagic(byte batchMagic, byte recordMagic, CompressionType compressionType) {
        Assertions.assertThrows(RecordValidationException.class, () -> this.validateMessages(this.recordsWithInvalidInnerMagic(batchMagic, recordMagic, compressionType), batchMagic, compressionType, compressionType));
        Assertions.assertEquals((int)this.metricsKeySet().count((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogValidatorTest.$anonfun$checkMismatchMagic$2(x$2))), (int)1);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMagicNumberRecordsPerSec())) > 0L ? 1 : 0) != 0);
    }

    private LogValidator.ValidationResult validateMessages(MemoryRecords records, byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        MockTime mockTime = new MockTime(0L, 0L);
        return new LogValidator(records, this.topicPartition(), (Time)mockTime, sourceCompressionType, targetCompressionType, false, magic, TimestampType.CREATE_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.IBP_2_3_IV1).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
    }

    @Test
    public void testLogAppendTimeNonCompressedV1() {
        this.checkLogAppendTimeNonCompressed((byte)1);
    }

    @Test
    public void testLogAppendTimeNonCompressedV2() {
        this.checkLogAppendTimeNonCompressed((byte)2);
    }

    private void checkLogAppendTimeNonCompressed(byte magic) {
        MockTime mockTime = new MockTime();
        MemoryRecords records = this.createRecords(magic, 1234L, CompressionType.NONE);
        PrimitiveRef.LongRef offsetCounter = PrimitiveRef.ofLong((long)0L);
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), (Time)mockTime, CompressionType.NONE, CompressionType.NONE, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(offsetCounter, this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        Assertions.assertEquals((long)offsetCounter.value, (long)CollectionConverters$.MODULE$.IterableHasAsScala(records.records()).asScala().size());
        MemoryRecords validatedRecords = validatedResults.validatedRecords;
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.IterableHasAsScala(records.records()).asScala().size(), (int)CollectionConverters$.MODULE$.IterableHasAsScala(validatedRecords.records()).asScala().size(), (String)"message set size should not change");
        long now = mockTime.milliseconds();
        validatedRecords.batches().forEach(batch -> this.validateLogAppendTime(now, 1234L, (RecordBatch)batch));
        Assertions.assertEquals((long)now, (long)validatedResults.maxTimestampMs, (String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString());
        Assertions.assertFalse((boolean)validatedResults.messageSizeMaybeChanged, (String)"Message size should not have been changed");
        int expectedMaxTimestampOffset = magic >= 2 ? 2 : 0;
        Assertions.assertEquals((long)expectedMaxTimestampOffset, (long)validatedResults.shallowOffsetOfMaxTimestampMs, (String)new StringBuilder(38).append("The offset of max timestamp should be ").append(expectedMaxTimestampOffset).toString());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats, 0, records, false);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV1() {
        this.checkLogAppendTimeWithRecompression((byte)1);
    }

    private void checkLogAppendTimeWithRecompression(byte targetMagic) {
        MockTime mockTime = new MockTime();
        long x$3 = -1L;
        MemoryRecords records = this.createRecords((byte)0, x$3, CompressionType.GZIP);
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), (Time)mockTime, CompressionType.GZIP, CompressionType.GZIP, false, targetMagic, TimestampType.LOG_APPEND_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        MemoryRecords validatedRecords = validatedResults.validatedRecords;
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.IterableHasAsScala(records.records()).asScala().size(), (int)CollectionConverters$.MODULE$.IterableHasAsScala(validatedRecords.records()).asScala().size(), (String)"message set size should not change");
        long now = mockTime.milliseconds();
        validatedRecords.batches().forEach(batch -> this.validateLogAppendTime(now, -1L, (RecordBatch)batch));
        Assertions.assertTrue((boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid(), (String)"MessageSet should still valid");
        Assertions.assertEquals((long)now, (long)validatedResults.maxTimestampMs, (String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString());
        Assertions.assertEquals((long)(CollectionConverters$.MODULE$.IterableHasAsScala(records.records()).asScala().size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestampMs, (String)new StringBuilder(38).append("The offset of max timestamp should be ").append(CollectionConverters$.MODULE$.IterableHasAsScala(records.records()).asScala().size() - 1).toString());
        Assertions.assertTrue((boolean)validatedResults.messageSizeMaybeChanged, (String)"Message size may have been changed");
        RecordConversionStats stats = validatedResults.recordConversionStats;
        this.verifyRecordConversionStats(stats, 3, records, true);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV2() {
        this.checkLogAppendTimeWithRecompression((byte)2);
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV1() {
        this.checkLogAppendTimeWithoutRecompression((byte)1);
    }

    private void checkLogAppendTimeWithoutRecompression(byte magic) {
        MockTime mockTime = new MockTime();
        MemoryRecords records = this.createRecords(magic, 1234L, CompressionType.GZIP);
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), (Time)mockTime, CompressionType.GZIP, CompressionType.GZIP, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        MemoryRecords validatedRecords = validatedResults.validatedRecords;
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.IterableHasAsScala(records.records()).asScala().size(), (int)CollectionConverters$.MODULE$.IterableHasAsScala(validatedRecords.records()).asScala().size(), (String)"message set size should not change");
        long now = mockTime.milliseconds();
        validatedRecords.batches().forEach(batch -> this.validateLogAppendTime(now, 1234L, (RecordBatch)batch));
        Assertions.assertTrue((boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid(), (String)"MessageSet should still valid");
        Assertions.assertEquals((long)now, (long)validatedResults.maxTimestampMs, (String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString());
        Assertions.assertEquals((long)(CollectionConverters$.MODULE$.IterableHasAsScala(records.records()).asScala().size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestampMs, (String)new StringBuilder(38).append("The offset of max timestamp should be ").append(CollectionConverters$.MODULE$.IterableHasAsScala(records.records()).asScala().size() - 1).toString());
        Assertions.assertFalse((boolean)validatedResults.messageSizeMaybeChanged, (String)"Message size should not have been changed");
        this.verifyRecordConversionStats(validatedResults.recordConversionStats, 0, records, true);
    }

    @Test
    public void testInvalidOffsetRangeAndRecordCount() {
        this.validateRecordBatchWithCountOverrides(2, 3);
        this.assertInvalidBatchCountOverrides(0, 3);
        this.assertInvalidBatchCountOverrides(15, 3);
        this.assertInvalidBatchCountOverrides(-3, 3);
        this.assertInvalidBatchCountOverrides(2, -3);
        this.assertInvalidBatchCountOverrides(2, 6);
        this.assertInvalidBatchCountOverrides(2, 0);
        this.assertInvalidBatchCountOverrides(-3, -2);
        this.assertInvalidBatchCountOverrides(5, 6);
        this.assertInvalidBatchCountOverrides(1, 2);
    }

    private void assertInvalidBatchCountOverrides(int lastOffsetDelta, int count) {
        Assertions.assertThrows(InvalidRecordException.class, () -> this.validateRecordBatchWithCountOverrides(lastOffsetDelta, count));
    }

    private void validateRecordBatchWithCountOverrides(int lastOffsetDelta, int count) {
        MemoryRecords records = this.createRecords((byte)2, 1234L, CompressionType.NONE);
        records.buffer().putInt(57, count);
        records.buffer().putInt(23, lastOffsetDelta);
        new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, CompressionType.GZIP, false, 2, TimestampType.LOG_APPEND_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV2() {
        this.checkLogAppendTimeWithoutRecompression((byte)2);
    }

    @Test
    public void testNonCompressedV1() {
        this.checkNonCompressed((byte)1);
    }

    /*
     * WARNING - void declaration
     */
    private void checkNonCompressed(byte magic) {
        void var5_8;
        int n;
        boolean bl;
        int n2;
        short s;
        long l;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        if (magic >= 2) {
            l = 1324L;
            s = (short)10;
            n2 = 984;
            bl = true;
            n = 40;
        } else {
            l = -1L;
            s = -1;
            n2 = -1;
            bl = false;
            n = -1;
        }
        int n3 = n;
        boolean bl2 = bl;
        int n4 = n2;
        short s2 = s;
        long producerId = l;
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)var5_8, (short)s2, (int)n4, (int)n3, (boolean)bl2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
        PrimitiveRef.LongRef offsetCounter = PrimitiveRef.ofLong((long)0L);
        LogValidator.ValidationResult validatingResults = new LogValidator(records, this.topicPartition(), this.time(), CompressionType.NONE, CompressionType.NONE, false, magic, TimestampType.CREATE_TIME, 1000L, 1000L, n3, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(offsetCounter, this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        MemoryRecords validatedRecords = validatingResults.validatedRecords;
        IntRef i = IntRef.create((int)0);
        CollectionConverters$.MODULE$.IterableHasAsScala(validatedRecords.batches()).asScala().foreach(arg_0 -> LogValidatorTest.$anonfun$checkNonCompressed$1$adapted(this, timestampSeq, s2, (long)var5_8, n4, bl2, n3, i, arg_0));
        Assertions.assertEquals((long)i.elem, (long)offsetCounter.value);
        Assertions.assertEquals((long)(now + 1L), (long)validatingResults.maxTimestampMs, (String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString());
        Assertions.assertEquals((long)1L, (long)validatingResults.shallowOffsetOfMaxTimestampMs, (String)"Offset of max timestamp should be 1");
        Assertions.assertFalse((boolean)validatingResults.messageSizeMaybeChanged, (String)"Message size should not have been changed");
        this.verifyRecordConversionStats(validatingResults.recordConversionStats, 0, records, false);
    }

    @Test
    public void testNonCompressedV2() {
        this.checkNonCompressed((byte)2);
    }

    @Test
    public void testRecompressionV1() {
        this.checkRecompression((byte)1);
    }

    /*
     * WARNING - void declaration
     */
    private void checkRecompression(byte magic) {
        void var5_8;
        int n;
        boolean bl;
        int n2;
        short s;
        long l;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        if (magic >= 2) {
            l = 1324L;
            s = (short)10;
            n2 = 984;
            bl = true;
            n = 40;
        } else {
            l = -1L;
            s = -1;
            n2 = -1;
            bl = false;
            n = -1;
        }
        int n3 = n;
        boolean bl2 = bl;
        int n4 = n2;
        short s2 = s;
        long producerId = l;
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)var5_8, (short)s2, (int)n4, (int)n3, (boolean)bl2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
        LogValidator.ValidationResult validatingResults = new LogValidator(records, this.topicPartition(), this.time(), CompressionType.NONE, CompressionType.GZIP, false, magic, TimestampType.CREATE_TIME, 1000L, 1000L, n3, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        MemoryRecords validatedRecords = validatingResults.validatedRecords;
        IntRef i = IntRef.create((int)0);
        CollectionConverters$.MODULE$.IterableHasAsScala(validatedRecords.batches()).asScala().foreach(arg_0 -> LogValidatorTest.$anonfun$checkRecompression$1$adapted(this, timestampSeq, s2, (long)var5_8, n4, n3, i, arg_0));
        Assertions.assertEquals((long)(now + 1L), (long)validatingResults.maxTimestampMs, (String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString());
        Assertions.assertEquals((long)2L, (long)validatingResults.shallowOffsetOfMaxTimestampMs, (String)"Offset of max timestamp should be 2");
        Assertions.assertTrue((boolean)validatingResults.messageSizeMaybeChanged, (String)"Message size should have been changed");
        this.verifyRecordConversionStats(validatingResults.recordConversionStats, 3, records, true);
    }

    @Test
    public void testRecompressionV2() {
        this.checkRecompression((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV1() {
        this.checkCreateTimeUpConversionFromV0((byte)1);
    }

    private void checkCreateTimeUpConversionFromV0(byte toMagic) {
        long x$3 = -1L;
        MemoryRecords records = this.createRecords((byte)0, x$3, CompressionType.GZIP);
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, CompressionType.GZIP, false, toMagic, TimestampType.CREATE_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        MemoryRecords validatedRecords = validatedResults.validatedRecords;
        CollectionConverters$.MODULE$.IterableHasAsScala(validatedRecords.batches()).asScala().foreach((Function1 & Serializable)batch -> {
            LogValidatorTest.$anonfun$checkCreateTimeUpConversionFromV0$1(this, batch);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)validatedResults.maxTimestampMs, (long)-1L, (String)new StringBuilder(36).append("Max timestamp should be ").append(-1L).toString());
        Assertions.assertEquals((long)(CollectionConverters$.MODULE$.IterableHasAsScala(validatedRecords.records()).asScala().size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestampMs, (String)new StringBuilder(34).append("Offset of max timestamp should be ").append(CollectionConverters$.MODULE$.IterableHasAsScala(validatedRecords.records()).asScala().size() - 1).toString());
        Assertions.assertTrue((boolean)validatedResults.messageSizeMaybeChanged, (String)"Message size should have been changed");
        this.verifyRecordConversionStats(validatedResults.recordConversionStats, 3, records, true);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV2() {
        this.checkCreateTimeUpConversionFromV0((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV1ToV2() {
        long timestamp = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, timestamp, CompressionType.GZIP);
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, CompressionType.GZIP, false, 2, TimestampType.CREATE_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        MemoryRecords validatedRecords = validatedResults.validatedRecords;
        CollectionConverters$.MODULE$.IterableHasAsScala(validatedRecords.batches()).asScala().foreach((Function1 & Serializable)batch -> {
            LogValidatorTest.$anonfun$testCreateTimeUpConversionV1ToV2$1(this, timestamp, batch);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)timestamp, (long)validatedResults.maxTimestampMs);
        Assertions.assertEquals((long)(CollectionConverters$.MODULE$.IterableHasAsScala(validatedRecords.records()).asScala().size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestampMs, (String)new StringBuilder(34).append("Offset of max timestamp should be ").append(CollectionConverters$.MODULE$.IterableHasAsScala(validatedRecords.records()).asScala().size() - 1).toString());
        Assertions.assertTrue((boolean)validatedResults.messageSizeMaybeChanged, (String)"Message size should have been changed");
        this.verifyRecordConversionStats(validatedResults.recordConversionStats, 3, records, true);
    }

    @Test
    public void testCompressedV1() {
        this.checkCompressed((byte)1);
    }

    /*
     * WARNING - void declaration
     */
    private void checkCompressed(byte magic) {
        void var5_8;
        int n;
        boolean bl;
        int n2;
        short s;
        long l;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        if (magic >= 2) {
            l = 1324L;
            s = (short)10;
            n2 = 984;
            bl = true;
            n = 40;
        } else {
            l = -1L;
            s = -1;
            n2 = -1;
            bl = false;
            n = -1;
        }
        int n3 = n;
        boolean bl2 = bl;
        int n4 = n2;
        short s2 = s;
        long producerId = l;
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)var5_8, (short)s2, (int)n4, (int)n3, (boolean)bl2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, CompressionType.GZIP, false, magic, TimestampType.CREATE_TIME, 1000L, 1000L, n3, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        MemoryRecords validatedRecords = validatedResults.validatedRecords;
        IntRef i = IntRef.create((int)0);
        CollectionConverters$.MODULE$.IterableHasAsScala(validatedRecords.batches()).asScala().foreach(arg_0 -> LogValidatorTest.$anonfun$checkCompressed$1$adapted(this, timestampSeq, s2, (long)var5_8, n4, n3, i, arg_0));
        Assertions.assertEquals((long)(now + 1L), (long)validatedResults.maxTimestampMs, (String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString());
        Assertions.assertEquals((long)(CollectionConverters$.MODULE$.IterableHasAsScala(validatedRecords.records()).asScala().size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestampMs, (String)new StringBuilder(34).append("Offset of max timestamp should be ").append(CollectionConverters$.MODULE$.IterableHasAsScala(validatedRecords.records()).asScala().size() - 1).toString());
        Assertions.assertFalse((boolean)validatedResults.messageSizeMaybeChanged, (String)"Message size should not have been changed");
        this.verifyRecordConversionStats(validatedResults.recordConversionStats, 0, records, true);
    }

    @Test
    public void testCompressedV2() {
        this.checkCompressed((byte)2);
    }

    @Test
    public void testInvalidCreateTimeNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now - 1001L, CompressionType.NONE);
        Assertions.assertThrows(RecordValidationException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.NONE, CompressionType.NONE, false, 1, TimestampType.CREATE_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
    }

    @Test
    public void testInvalidCreateTimeNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now - 1001L, CompressionType.NONE);
        Assertions.assertThrows(RecordValidationException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.NONE, CompressionType.NONE, false, 2, TimestampType.CREATE_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
    }

    @Test
    public void testInvalidCreateTimeCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now - 1001L, CompressionType.GZIP);
        Assertions.assertThrows(RecordValidationException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, CompressionType.GZIP, false, 1, TimestampType.CREATE_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
    }

    @Test
    public void testInvalidCreateTimeCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now - 1001L, CompressionType.GZIP);
        Assertions.assertThrows(RecordValidationException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, CompressionType.GZIP, false, 1, TimestampType.CREATE_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
    }

    @Test
    public void testAbsoluteOffsetAssignmentNonCompressed() {
        long x$3 = -1L;
        MemoryRecords records = this.createRecords((byte)0, x$3, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.NONE, (CompressionType)CompressionType.NONE, (boolean)false, (byte)0, (TimestampType)TimestampType.CREATE_TIME, (long)1000L, (long)1000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    @Test
    public void testAbsoluteOffsetAssignmentCompressed() {
        long x$3 = -1L;
        MemoryRecords records = this.createRecords((byte)0, x$3, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.GZIP, (CompressionType)CompressionType.GZIP, (boolean)false, (byte)0, (TimestampType)TimestampType.CREATE_TIME, (long)1000L, (long)1000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords messageWithOffset = new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.NONE, (CompressionType)CompressionType.NONE, (boolean)false, (byte)1, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords;
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords messageWithOffset = new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.NONE, (CompressionType)CompressionType.NONE, (boolean)false, (byte)2, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords;
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords compressedMessagesWithOffset = new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.GZIP, (CompressionType)CompressionType.GZIP, (boolean)false, (byte)1, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords;
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords compressedMessagesWithOffset = new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.GZIP, (CompressionType)CompressionType.GZIP, (boolean)false, (byte)2, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords;
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1NonCompressed() {
        long x$3 = -1L;
        MemoryRecords records = this.createRecords((byte)0, x$3, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), this.time(), CompressionType.NONE, CompressionType.NONE, false, 1, TimestampType.LOG_APPEND_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)offset), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        this.checkOffsets(validatedResults.validatedRecords, offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats, 3, records, false);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2NonCompressed() {
        long x$3 = -1L;
        MemoryRecords records = this.createRecords((byte)0, x$3, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), this.time(), CompressionType.NONE, CompressionType.NONE, false, 2, TimestampType.LOG_APPEND_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)offset), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        this.checkOffsets(validatedResults.validatedRecords, offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats, 3, records, false);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1Compressed() {
        long x$3 = -1L;
        MemoryRecords records = this.createRecords((byte)0, x$3, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, CompressionType.GZIP, false, 1, TimestampType.LOG_APPEND_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)offset), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        this.checkOffsets(validatedResults.validatedRecords, offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats, 3, records, true);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2Compressed() {
        long x$3 = -1L;
        MemoryRecords records = this.createRecords((byte)0, x$3, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, CompressionType.GZIP, false, 2, TimestampType.LOG_APPEND_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)offset), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        this.checkOffsets(validatedResults.validatedRecords, offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats, 3, records, true);
    }

    @Test
    public void testControlRecordsNotAllowedFromClients() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        Assertions.assertThrows(InvalidRecordException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.NONE, CompressionType.NONE, false, 2, TimestampType.CREATE_TIME, 5000L, 5000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)offset), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
    }

    @Test
    public void testControlRecordsNotCompressed() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        List batches = TestUtils.toList((Iterable)new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.NONE, (CompressionType)CompressionType.SNAPPY, (boolean)false, (byte)2, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.COORDINATOR, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords.batches());
        Assertions.assertEquals((int)1, (int)batches.size());
        Assertions.assertFalse((boolean)((MutableRecordBatch)batches.get(0)).isCompressed());
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.NONE, (CompressionType)CompressionType.NONE, (boolean)false, (byte)0, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.GZIP);
        this.checkOffsets(records, 0L);
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.GZIP, (CompressionType)CompressionType.GZIP, (boolean)false, (byte)0, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2NonCompressed() {
        long x$3 = -1L;
        MemoryRecords records = this.createRecords((byte)1, x$3, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.NONE, (CompressionType)CompressionType.NONE, (boolean)false, (byte)2, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)1000L, (long)1000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2Compressed() {
        long x$3 = -1L;
        MemoryRecords records = this.createRecords((byte)1, x$3, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.GZIP, (CompressionType)CompressionType.GZIP, (boolean)false, (byte)2, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)1000L, (long)1000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.NONE, (CompressionType)CompressionType.NONE, (boolean)false, (byte)1, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.GZIP);
        this.checkOffsets(records, 0L);
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.GZIP, (CompressionType)CompressionType.GZIP, (boolean)false, (byte)1, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDownConversionOfTransactionalRecordsNotPermitted() {
        void withTransactionalRecords_records;
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())};
        CompressionType withTransactionalRecords_compressionType = CompressionType.NONE;
        Object var7_6 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)sequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records);
        Assertions.assertThrows(UnsupportedForMessageFormatException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, CompressionType.GZIP, false, 1, TimestampType.CREATE_TIME, 5000L, 5000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)offset), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDownConversionOfIdempotentRecordsNotPermitted() {
        void withIdempotentRecords_records;
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())};
        CompressionType withIdempotentRecords_compressionType = CompressionType.NONE;
        Object var7_6 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)sequence, (int)-1, (boolean)false, (SimpleRecord[])withIdempotentRecords_records);
        Assertions.assertThrows(UnsupportedForMessageFormatException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, CompressionType.GZIP, false, 1, TimestampType.CREATE_TIME, 5000L, 5000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)offset), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.NONE, (CompressionType)CompressionType.NONE, (boolean)false, (byte)0, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.GZIP);
        this.checkOffsets(records, 0L);
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.GZIP, (CompressionType)CompressionType.GZIP, (boolean)false, (byte)0, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    @Test
    public void testNonIncreasingOffsetRecordBatchHasMetricsLogged() {
        MemoryRecords records = this.createNonIncreasingOffsetRecords((byte)2, -1L, CompressionType.NONE);
        ((MutableRecordBatch)CollectionConverters$.MODULE$.IterableHasAsScala(records.batches()).asScala().head()).setLastOffset(2L);
        Assertions.assertThrows(InvalidRecordException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, CompressionType.GZIP, false, 0, TimestampType.CREATE_TIME, 5000L, 5000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
        Assertions.assertEquals((int)this.metricsKeySet().count((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LogValidatorTest.$anonfun$testNonIncreasingOffsetRecordBatchHasMetricsLogged$2(x$9))), (int)1);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(String.valueOf(BrokerTopicStats$.MODULE$.InvalidOffsetOrSequenceRecordsPerSec())) > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testCompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed(CompressionType.GZIP, CompressionType.GZIP);
    }

    @Test
    public void testZStdCompressedWithUnavailableIBPVersion() {
        MemoryRecords records = this.createRecords((byte)2, 1234L, CompressionType.NONE);
        Assertions.assertThrows(UnsupportedCompressionTypeException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.NONE, CompressionType.ZSTD, false, 2, TimestampType.LOG_APPEND_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.IBP_2_0_IV1).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
    }

    @Test
    public void testUncompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed(CompressionType.NONE, CompressionType.NONE);
    }

    @Test
    public void testRecompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed(CompressionType.NONE, CompressionType.GZIP);
    }

    @Test
    public void testInvalidTimestampExceptionHasBatchIndex() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now - 1001L, CompressionType.GZIP);
        RecordValidationException e = (RecordValidationException)Assertions.assertThrows(RecordValidationException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, CompressionType.GZIP, false, 1, TimestampType.CREATE_TIME, 1000L, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
        Assertions.assertTrue((boolean)(e.invalidException() instanceof InvalidTimestampException));
        Assertions.assertFalse((boolean)e.recordErrors().isEmpty());
        Assertions.assertEquals((int)e.recordErrors().size(), (int)3);
    }

    @Test
    public void testInvalidRecordExceptionHasBatchIndex() {
        RecordValidationException e = (RecordValidationException)Assertions.assertThrows(RecordValidationException.class, () -> this.validateMessages(this.recordsWithInvalidInnerMagic((byte)0, (byte)1, CompressionType.GZIP), (byte)0, CompressionType.GZIP, CompressionType.GZIP));
        Assertions.assertTrue((boolean)(e.invalidException() instanceof InvalidRecordException));
        Assertions.assertFalse((boolean)e.recordErrors().isEmpty());
        Assertions.assertEquals((int)e.recordErrors().size(), (int)20);
        CollectionConverters$.MODULE$.ListHasAsScala(e.recordErrors()).asScala().foreach((Function1 & Serializable)x$10 -> {
            LogValidatorTest.$anonfun$testInvalidRecordExceptionHasBatchIndex$2(x$10);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testBatchWithInvalidRecordsAndInvalidTimestamp() {
        IndexedSeq records = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)id -> LogValidatorTest.$anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$1(BoxesRunTime.unboxToInt((Object)id)));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)1, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        IntRef offset = IntRef.create((int)0);
        byte[] create_value = "timestamp".getBytes();
        Object var6_4 = null;
        builder.appendUncheckedWithOffset(Int$.MODULE$.int2long(offset.elem), LegacyRecord.create((byte)1, (long)1200L, null, (byte[])create_value, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME));
        records.foreach((Function1 & Serializable)record -> {
            LogValidatorTest.$anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$2(offset, builder, record);
            return BoxedUnit.UNIT;
        });
        MemoryRecords invalidOffsetTimestampRecords = builder.build();
        RecordValidationException e = (RecordValidationException)Assertions.assertThrows(RecordValidationException.class, () -> this.validateMessages(invalidOffsetTimestampRecords, (byte)0, CompressionType.GZIP, CompressionType.GZIP));
        Assertions.assertTrue((boolean)(e.invalidException() instanceof InvalidTimestampException));
        Assertions.assertFalse((boolean)e.recordErrors().isEmpty());
        Assertions.assertEquals((int)6, (int)e.recordErrors().size());
    }

    @Test
    public void testRecordWithPastTimestampIsRejected() {
        long timestampBeforeMaxConfig = 86400000L;
        long timestampAfterMaxConfig = 3600000L;
        long fiveMinutesBeforeThreshold = System.currentTimeMillis() - timestampBeforeMaxConfig - 300000L;
        MemoryRecords records = this.createRecords((byte)2, fiveMinutesBeforeThreshold, CompressionType.GZIP);
        RecordValidationException e = (RecordValidationException)Assertions.assertThrows(RecordValidationException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, CompressionType.GZIP, false, 2, TimestampType.CREATE_TIME, timestampBeforeMaxConfig, timestampAfterMaxConfig, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
        Assertions.assertTrue((boolean)(e.invalidException() instanceof InvalidTimestampException));
        Assertions.assertFalse((boolean)e.recordErrors().isEmpty());
        Assertions.assertEquals((int)e.recordErrors().size(), (int)3);
    }

    @Test
    public void testRecordWithFutureTimestampIsRejected() {
        long timestampBeforeMaxConfig = 86400000L;
        long timestampAfterMaxConfig = 3600000L;
        long fiveMinutesAfterThreshold = System.currentTimeMillis() + timestampAfterMaxConfig + 300000L;
        MemoryRecords records = this.createRecords((byte)2, fiveMinutesAfterThreshold, CompressionType.GZIP);
        RecordValidationException e = (RecordValidationException)Assertions.assertThrows(RecordValidationException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, CompressionType.GZIP, false, 2, TimestampType.CREATE_TIME, timestampBeforeMaxConfig, timestampAfterMaxConfig, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
        Assertions.assertTrue((boolean)(e.invalidException() instanceof InvalidTimestampException));
        Assertions.assertFalse((boolean)e.recordErrors().isEmpty());
        Assertions.assertEquals((int)e.recordErrors().size(), (int)3);
    }

    /*
     * WARNING - void declaration
     */
    private void testBatchWithoutRecordsNotAllowed(CompressionType sourceCompression, CompressionType targetCompression) {
        void writeEmptyHeader_isControlRecord;
        void var4_8;
        void writeEmptyHeader_timestamp;
        void writeEmptyHeader_timestampType;
        void writeEmptyHeader_baseOffset;
        void writeEmptyHeader_lastOffset;
        int offset = 1234567;
        int n = 40;
        boolean bl = true;
        int n2 = 984;
        short s = (short)10;
        long producerId = 1324L;
        ByteBuffer buffer = ByteBuffer.allocate(61);
        boolean bl2 = false;
        long l = System.currentTimeMillis();
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long l2 = 5L;
        long l3 = 0L;
        byte writeEmptyHeader_magic = 2;
        int writeEmptyHeader_offsetDelta = (int)(writeEmptyHeader_lastOffset - writeEmptyHeader_baseOffset);
        DefaultRecordBatch.writeHeader((ByteBuffer)buffer, (long)writeEmptyHeader_baseOffset, (int)writeEmptyHeader_offsetDelta, (int)61, (byte)writeEmptyHeader_magic, (CompressionType)CompressionType.NONE, (TimestampType)writeEmptyHeader_timestampType, (long)-1L, (long)writeEmptyHeader_timestamp, (long)var4_8, (short)s, (int)n2, (boolean)bl, (boolean)writeEmptyHeader_isControlRecord, (boolean)false, (int)n, (int)0);
        timestampType = null;
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        Assertions.assertThrows(InvalidRecordException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), sourceCompression, targetCompression, false, 2, TimestampType.CREATE_TIME, 5000L, 5000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)offset), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
    }

    private MemoryRecords createRecords(byte magicValue, long timestamp, CompressionType codec) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(512), (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(1L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    private long createRecords$default$2() {
        return -1L;
    }

    private MemoryRecords createNonIncreasingOffsetRecords(byte magicValue, long timestamp, CompressionType codec) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(512), (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(3L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    private long createNonIncreasingOffsetRecords$default$2() {
        return -1L;
    }

    private CompressionType createNonIncreasingOffsetRecords$default$3() {
        return CompressionType.NONE;
    }

    private MemoryRecords createTwoBatchedRecords(byte magicValue, long timestamp, CompressionType codec) {
        ByteBuffer buf = ByteBuffer.allocate(2048);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(10L, "1".getBytes(), "a".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)1L);
        builder.append(11L, "2".getBytes(), "b".getBytes());
        builder.append(12L, "3".getBytes(), "c".getBytes());
        builder.close();
        buf.flip();
        return MemoryRecords.readableRecords((ByteBuffer)buf.slice());
    }

    public void checkOffsets(MemoryRecords records, long baseOffset) {
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.IterableHasAsScala(records.records()).asScala().nonEmpty(), (String)"Message set should not be empty");
        LongRef offset = LongRef.create((long)baseOffset);
        CollectionConverters$.MODULE$.IterableHasAsScala(records.records()).asScala().foreach((Function1 & Serializable)entry -> {
            LogValidatorTest.$anonfun$checkOffsets$1(offset, entry);
            return BoxedUnit.UNIT;
        });
    }

    private MemoryRecords recordsWithNonSequentialInnerOffsets(byte magicValue, CompressionType compression, int numRecords) {
        IndexedSeq records = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)id -> LogValidatorTest.$anonfun$recordsWithNonSequentialInnerOffsets$1(BoxesRunTime.unboxToInt((Object)id)));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)magicValue, (CompressionType)compression, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        records.foreach((Function1 & Serializable)record -> {
            builder.appendUncheckedWithOffset(0L, record);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    private MemoryRecords recordsWithInvalidInnerMagic(byte batchMagicValue, byte recordMagicValue, CompressionType codec) {
        IndexedSeq records = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).map((Function1 & Serializable)id -> LogValidatorTest.$anonfun$recordsWithInvalidInnerMagic$1(recordMagicValue, BoxesRunTime.unboxToInt((Object)id)));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(scala.math.package$.MODULE$.min(scala.math.package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)((IterableOnceOps)records.map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.sizeInBytes()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024), 65536)), (byte)batchMagicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        IntRef offset = IntRef.create((int)1234567);
        records.foreach((Function1 & Serializable)record -> {
            LogValidatorTest.$anonfun$recordsWithInvalidInnerMagic$3(builder, offset, record);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    public void maybeCheckBaseTimestamp(long expected, RecordBatch batch) {
        if (batch instanceof DefaultRecordBatch) {
            DefaultRecordBatch defaultRecordBatch = (DefaultRecordBatch)batch;
            Assertions.assertEquals((long)expected, (long)defaultRecordBatch.baseTimestamp(), (String)new StringBuilder(35).append("Unexpected base timestamp of batch ").append(batch).toString());
            return;
        }
    }

    public void validateLogAppendTime(long expectedLogAppendTime, long expectedBaseTimestamp, RecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        TimestampType timestampType = batch.timestampType();
        TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
        Assertions.assertTrue((!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null) ? 1 : 0) != 0);
        Assertions.assertEquals((long)expectedLogAppendTime, (long)batch.maxTimestamp(), (String)new StringBuilder(34).append("Unexpected max timestamp of batch ").append(batch).toString());
        this.maybeCheckBaseTimestamp(expectedBaseTimestamp, batch);
        CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
            LogValidatorTest.$anonfun$validateLogAppendTime$1(expectedLogAppendTime, record);
            return BoxedUnit.UNIT;
        });
    }

    public void verifyRecordConversionStats(RecordConversionStats stats, int numConvertedRecords, MemoryRecords records, boolean compressed) {
        Assertions.assertNotNull((Object)stats, (String)"Records processing info is null");
        Assertions.assertEquals((int)numConvertedRecords, (int)stats.numRecordsConverted());
        if (numConvertedRecords > 0) {
            Assertions.assertTrue((stats.conversionTimeNanos() >= 0L ? 1 : 0) != 0, (String)new StringBuilder(29).append("Conversion time not recorded ").append(stats).toString());
            Assertions.assertTrue((stats.conversionTimeNanos() <= TimeUnit.MINUTES.toNanos(1L) ? 1 : 0) != 0, (String)new StringBuilder(26).append("Conversion time not valid ").append(stats).toString());
        }
        int originalSize = records.sizeInBytes();
        long tempBytes = stats.temporaryMemoryBytes();
        if (numConvertedRecords > 0 && compressed) {
            Assertions.assertTrue((tempBytes > (long)originalSize ? 1 : 0) != 0, (String)new StringBuilder(35).append("Temp bytes too small, orig=").append(originalSize).append(" actual=").append(tempBytes).toString());
            return;
        }
        if (numConvertedRecords > 0 || compressed) {
            Assertions.assertTrue((tempBytes > 0L ? 1 : 0) != 0, (String)"Temp bytes not updated");
            return;
        }
        Assertions.assertEquals((long)0L, (long)tempBytes);
    }

    private final void testMessageValidation$1(byte magicValue) {
        int numRecords = 20;
        MemoryRecords invalidRecords = this.recordsWithNonSequentialInnerOffsets(magicValue, CompressionType.GZIP, numRecords);
        if (magicValue >= 2) {
            Assertions.assertThrows(InvalidRecordException.class, () -> this.validateMessages(invalidRecords, magicValue, CompressionType.GZIP, CompressionType.GZIP));
            return;
        }
        LogValidator.ValidationResult result = this.validateMessages(invalidRecords, magicValue, CompressionType.GZIP, CompressionType.GZIP);
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords), (Object)CollectionConverters$.MODULE$.IterableHasAsScala(result.validatedRecords.records()).asScala().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.offset())));
    }

    public static final /* synthetic */ boolean $anonfun$checkMismatchMagic$2(MetricName x$2) {
        return x$2.getMBeanName().endsWith(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMagicNumberRecordsPerSec()));
    }

    public static final /* synthetic */ void $anonfun$checkNonCompressed$3(Seq timestampSeq$1, IntRef i$1, Record record) {
        record.ensureValid();
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$1.apply(i$1.elem)), (long)record.timestamp());
        ++i$1.elem;
    }

    public static final /* synthetic */ void $anonfun$checkNonCompressed$1(LogValidatorTest $this, Seq timestampSeq$1, short producerEpoch$1, long producerId$1, int baseSequence$1, boolean isTransactional$1, int partitionLeaderEpoch$1, IntRef i$1, MutableRecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        Assertions.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$1.apply(0)), (RecordBatch)batch);
        Assertions.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.timestamp()))).max((Ordering)Ordering.Long$.MODULE$)));
        Assertions.assertEquals((short)producerEpoch$1, (short)batch.producerEpoch());
        Assertions.assertEquals((long)producerId$1, (long)batch.producerId());
        Assertions.assertEquals((int)baseSequence$1, (int)batch.baseSequence());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)isTransactional$1), (Object)BoxesRunTime.boxToBoolean((boolean)batch.isTransactional()));
        Assertions.assertEquals((int)partitionLeaderEpoch$1, (int)batch.partitionLeaderEpoch());
        CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
            LogValidatorTest.$anonfun$checkNonCompressed$3(timestampSeq$1, i$1, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$checkRecompression$3(Seq timestampSeq$2, IntRef i$2, Record record) {
        record.ensureValid();
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$2.apply(i$2.elem)), (long)record.timestamp());
        ++i$2.elem;
    }

    public static final /* synthetic */ void $anonfun$checkRecompression$1(LogValidatorTest $this, Seq timestampSeq$2, short producerEpoch$2, long producerId$2, int baseSequence$2, int partitionLeaderEpoch$2, IntRef i$2, MutableRecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        Assertions.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$2.apply(0)), (RecordBatch)batch);
        Assertions.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.timestamp()))).max((Ordering)Ordering.Long$.MODULE$)));
        Assertions.assertEquals((short)producerEpoch$2, (short)batch.producerEpoch());
        Assertions.assertEquals((long)producerId$2, (long)batch.producerId());
        Assertions.assertEquals((int)baseSequence$2, (int)batch.baseSequence());
        Assertions.assertEquals((int)partitionLeaderEpoch$2, (int)batch.partitionLeaderEpoch());
        CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
            LogValidatorTest.$anonfun$checkRecompression$3(timestampSeq$2, i$2, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$checkCreateTimeUpConversionFromV0$1(LogValidatorTest $this, MutableRecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        $this.maybeCheckBaseTimestamp(-1L, (RecordBatch)batch);
        Assertions.assertEquals((long)-1L, (long)batch.maxTimestamp());
        Assertions.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
        Assertions.assertEquals((short)-1, (short)batch.producerEpoch());
        Assertions.assertEquals((long)-1L, (long)batch.producerId());
        Assertions.assertEquals((int)-1, (int)batch.baseSequence());
    }

    public static final /* synthetic */ void $anonfun$testCreateTimeUpConversionV1ToV2$1(LogValidatorTest $this, long timestamp$1, MutableRecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        $this.maybeCheckBaseTimestamp(timestamp$1, (RecordBatch)batch);
        Assertions.assertEquals((long)timestamp$1, (long)batch.maxTimestamp());
        Assertions.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
        Assertions.assertEquals((short)-1, (short)batch.producerEpoch());
        Assertions.assertEquals((long)-1L, (long)batch.producerId());
        Assertions.assertEquals((int)-1, (int)batch.baseSequence());
    }

    public static final /* synthetic */ void $anonfun$checkCompressed$3(Seq timestampSeq$3, IntRef i$3, Record record) {
        record.ensureValid();
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$3.apply(i$3.elem)), (long)record.timestamp());
        ++i$3.elem;
    }

    public static final /* synthetic */ void $anonfun$checkCompressed$1(LogValidatorTest $this, Seq timestampSeq$3, short producerEpoch$3, long producerId$3, int baseSequence$3, int partitionLeaderEpoch$3, IntRef i$3, MutableRecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        Assertions.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$3.apply(0)), (RecordBatch)batch);
        Assertions.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.timestamp()))).max((Ordering)Ordering.Long$.MODULE$)));
        Assertions.assertEquals((short)producerEpoch$3, (short)batch.producerEpoch());
        Assertions.assertEquals((long)producerId$3, (long)batch.producerId());
        Assertions.assertEquals((int)baseSequence$3, (int)batch.baseSequence());
        Assertions.assertEquals((int)partitionLeaderEpoch$3, (int)batch.partitionLeaderEpoch());
        CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
            LogValidatorTest.$anonfun$checkCompressed$3(timestampSeq$3, i$3, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testNonIncreasingOffsetRecordBatchHasMetricsLogged$2(MetricName x$9) {
        return x$9.getMBeanName().endsWith(String.valueOf(BrokerTopicStats$.MODULE$.InvalidOffsetOrSequenceRecordsPerSec()));
    }

    public static final /* synthetic */ void $anonfun$testInvalidRecordExceptionHasBatchIndex$2(ProduceResponse.RecordError x$10) {
        Assertions.assertNotNull((Object)x$10);
    }

    public static final /* synthetic */ LegacyRecord $anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$1(int id) {
        byte[] create_value = Integer.toString(id).getBytes();
        return LegacyRecord.create((byte)0, (long)0L, null, (byte[])create_value, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME);
    }

    public static final /* synthetic */ void $anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$2(IntRef offset$4, MemoryRecordsBuilder builder$1, LegacyRecord record) {
        offset$4.elem += 30;
        builder$1.appendUncheckedWithOffset(Int$.MODULE$.int2long(offset$4.elem), record);
    }

    public static final /* synthetic */ void $anonfun$checkOffsets$1(LongRef offset$6, Record entry) {
        Assertions.assertEquals((long)offset$6.elem, (long)entry.offset(), (String)"Unexpected offset in message set iterator");
        ++offset$6.elem;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$recordsWithNonSequentialInnerOffsets$1(int id) {
        return new SimpleRecord(Integer.toString(id).getBytes());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ LegacyRecord $anonfun$recordsWithInvalidInnerMagic$1(byte recordMagicValue$1, int id) {
        void create_value;
        void create_key;
        byte[] byArray = Integer.toString(id).getBytes();
        byte[] byArray2 = Integer.toString(id).getBytes();
        long create_timestamp = -1L;
        return LegacyRecord.create((byte)recordMagicValue$1, (long)create_timestamp, (byte[])create_key, (byte[])create_value, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME);
    }

    public static final /* synthetic */ void $anonfun$recordsWithInvalidInnerMagic$3(MemoryRecordsBuilder builder$3, IntRef offset$7, LegacyRecord record) {
        builder$3.appendUncheckedWithOffset(Int$.MODULE$.int2long(offset$7.elem), record);
        ++offset$7.elem;
    }

    public static final /* synthetic */ void $anonfun$validateLogAppendTime$1(long expectedLogAppendTime$1, Record record) {
        record.ensureValid();
        Assertions.assertEquals((long)expectedLogAppendTime$1, (long)record.timestamp(), (String)new StringBuilder(31).append("Unexpected timestamp of record ").append(record).toString());
    }

    public LogValidatorTest() {
        BrokerTopicMetrics newValidatorMetricsRecorder_allTopicsStats = new BrokerTopicStats(Optional.empty()).allTopicsStats();
        this.metricsRecorder = new /* Unavailable Anonymous Inner Class!! */;
    }

    public static final /* synthetic */ Object $anonfun$checkNonCompressed$1$adapted(LogValidatorTest $this, Seq timestampSeq$1, short producerEpoch$1, long producerId$1, int baseSequence$1, boolean isTransactional$1, int partitionLeaderEpoch$1, IntRef i$1, MutableRecordBatch batch) {
        LogValidatorTest.$anonfun$checkNonCompressed$1($this, timestampSeq$1, producerEpoch$1, producerId$1, baseSequence$1, isTransactional$1, partitionLeaderEpoch$1, i$1, batch);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$checkRecompression$1$adapted(LogValidatorTest $this, Seq timestampSeq$2, short producerEpoch$2, long producerId$2, int baseSequence$2, int partitionLeaderEpoch$2, IntRef i$2, MutableRecordBatch batch) {
        LogValidatorTest.$anonfun$checkRecompression$1($this, timestampSeq$2, producerEpoch$2, producerId$2, baseSequence$2, partitionLeaderEpoch$2, i$2, batch);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$checkCompressed$1$adapted(LogValidatorTest $this, Seq timestampSeq$3, short producerEpoch$3, long producerId$3, int baseSequence$3, int partitionLeaderEpoch$3, IntRef i$3, MutableRecordBatch batch) {
        LogValidatorTest.$anonfun$checkCompressed$1($this, timestampSeq$3, producerEpoch$3, producerId$3, baseSequence$3, partitionLeaderEpoch$3, i$3, batch);
        return BoxedUnit.UNIT;
    }
}

