/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.cluster.Broker;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import kafka.zk.FeatureZNode;
import kafka.zk.FeatureZNode$;
import kafka.zk.FeatureZNodeStatus;
import kafka.zk.ZkVersion$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.FeatureMetadata;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.FinalizedVersionRange;
import org.apache.kafka.clients.admin.UpdateFeaturesOptions;
import org.apache.kafka.clients.admin.UpdateFeaturesResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.feature.BaseVersionRange;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.message.UpdateFeaturesRequestData;
import org.apache.kafka.common.message.UpdateFeaturesResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.UpdateFeaturesRequest;
import org.apache.kafka.common.requests.UpdateFeaturesResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\t}a\u0001\u0002\u000f\u001e\u0001\tBQa\n\u0001\u0005\u0002!BQA\u000b\u0001\u0005B-BQA\r\u0001\u0005BMBQ!\u0011\u0001\u0005\n\tCQa\u0015\u0001\u0005\nQCQA\u001a\u0001\u0005\n\u001dDQA\u001d\u0001\u0005\nMDQ!\u001e\u0001\u0005\nYDQ\u0001\u001f\u0001\u0005\neDq!!\u0001\u0001\t\u0013\t\u0019\u0001C\u0004\u0002\u001c\u0001!I!!\b\t\u000f\u0005\u001d\u0002\u0001\"\u0003\u0002*!9\u00111\n\u0001\u0005\n\u00055\u0003bBAR\u0001\u0011%\u0011Q\u0015\u0005\b\u0003\u0007\u0004A\u0011AAc\u0011\u001d\ti\u000e\u0001C\u0001\u0003\u000bDq!!9\u0001\t\u0003\t)\rC\u0004\u0002f\u0002!\t!!2\t\u000f\u0005%\b\u0001\"\u0001\u0002F\"9\u0011Q\u001e\u0001\u0005\u0002\u0005\u0015\u0007bBAy\u0001\u0011%\u00111\u001f\u0005\b\u0005\u000f\u0001A\u0011AAc\u0011\u001d\u0011Y\u0001\u0001C\u0001\u0003\u000bDqAa\u0004\u0001\t\u0003\t)\rC\u0004\u0003\u0014\u0001!\t!!2\t\u000f\t]\u0001\u0001\"\u0001\u0002F\"9!1\u0004\u0001\u0005\u0002\u0005\u0015'AE+qI\u0006$XMR3biV\u0014Xm\u001d+fgRT!AH\u0010\u0002\rM,'O^3s\u0015\u0005\u0001\u0013!B6bM.\f7\u0001A\n\u0003\u0001\r\u0002\"\u0001J\u0013\u000e\u0003uI!AJ\u000f\u0003\u001f\t\u000b7/\u001a*fcV,7\u000f\u001e+fgR\fa\u0001P5oSRtD#A\u0015\u0011\u0005\u0011\u0002\u0011a\u00032s_.,'oQ8v]R,\u0012\u0001\f\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0004\u0013:$\u0018a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\t!t\u0007\u0005\u0002.k%\u0011aG\f\u0002\u0005+:LG\u000fC\u00039\u0007\u0001\u0007\u0011(A\u0003qe>\u00048\u000f\u0005\u0002;\u007f5\t1H\u0003\u0002={\u0005!Q\u000f^5m\u0015\u0005q\u0014\u0001\u00026bm\u0006L!\u0001Q\u001e\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\reK\u001a\fW\u000f\u001c;TkB\u0004xN\u001d;fI\u001a+\u0017\r^;sKN$\u0012a\u0011\t\u0004\t:\u0003V\"A#\u000b\u0005\u0019;\u0015a\u00024fCR,(/\u001a\u0006\u0003\u0011&\u000baaY8n[>t'B\u0001\u0011K\u0015\tYE*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0006\u0019qN]4\n\u0005=+%\u0001\u0003$fCR,(/Z:\u0011\u0005\u0011\u000b\u0016B\u0001*F\u0005U\u0019V\u000f\u001d9peR,GMV3sg&|gNU1oO\u0016\f\u0001\u0004Z3gCVdGOR5oC2L'0\u001a3GK\u0006$XO]3t)\u0005)\u0006\u0003\u0002,^A\u000et!aV.\u0011\u0005asS\"A-\u000b\u0005i\u000b\u0013A\u0002\u001fs_>$h(\u0003\u0002]]\u00051\u0001K]3eK\u001aL!AX0\u0003\u00075\u000b\u0007O\u0003\u0002]]A\u0011a+Y\u0005\u0003E~\u0013aa\u0015;sS:<\u0007CA\u0017e\u0013\t)gFA\u0003TQ>\u0014H/A\fva\u0012\fG/Z*vaB|'\u000f^3e\r\u0016\fG/\u001e:fgR\u0019A\u0007\u001b6\t\u000b%4\u0001\u0019A\"\u0002\u0011\u0019,\u0017\r^;sKNDQa\u001b\u0004A\u00021\fQ\u0002^1sO\u0016$8+\u001a:wKJ\u001c\bc\u0001,n_&\u0011an\u0018\u0002\u0004'\u0016$\bC\u0001\u0013q\u0013\t\tXDA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\u0018aI;qI\u0006$XmU;qa>\u0014H/\u001a3GK\u0006$XO]3t\u0013:\fE\u000e\u001c\"s_.,'o\u001d\u000b\u0003iQDQ![\u0004A\u0002\r\u000b!#\u001e9eCR,g)Z1ukJ,'LT8eKR\u0011Af\u001e\u0005\u0006S\"\u0001\r!V\u0001\u0010O\u0016$h)Z1ukJ,'LT8eKR\t!\u0010\u0005\u0002|}6\tAP\u0003\u0002~?\u0005\u0011!p[\u0005\u0003\u007fr\u0014ABR3biV\u0014XM\u0017(pI\u0016\f\u0011CZ5oC2L'0\u001a3GK\u0006$XO]3t)\r)\u0016Q\u0001\u0005\u0007S*\u0001\r!a\u0002\u0011\ri\nI\u0001YA\u0006\u0013\tq6\b\u0005\u0003\u0002\u000e\u0005]QBAA\b\u0015\u0011\t\t\"a\u0005\u0002\u000b\u0005$W.\u001b8\u000b\u0007\u0005U\u0011*A\u0004dY&,g\u000e^:\n\t\u0005e\u0011q\u0002\u0002\u0016\r&t\u0017\r\\5{K\u00124VM]:j_:\u0014\u0016M\\4f\u0003E\u0019X\u000f\u001d9peR,GMR3biV\u0014Xm\u001d\u000b\u0004\u0007\u0006}\u0001BB5\f\u0001\u0004\t\t\u0003\u0005\u0004;\u0003\u0013\u0001\u00171\u0005\t\u0005\u0003\u001b\t)#C\u0002S\u0003\u001f\tQb\u00195fG.4U-\u0019;ve\u0016\u001cHc\u0003\u001b\u0002,\u0005U\u0012\u0011HA\u001f\u0003\u000fBq!!\f\r\u0001\u0004\ty#\u0001\u0004dY&,g\u000e\u001e\t\u0005\u0003\u001b\t\t$\u0003\u0003\u00024\u0005=!!B!e[&t\u0007BBA\u001c\u0019\u0001\u0007!0\u0001\u0007fqB,7\r^3e\u001d>$W\r\u0003\u0004\u0002<1\u0001\r!V\u0001\u001aKb\u0004Xm\u0019;fI\u001aKg.\u00197ju\u0016$g)Z1ukJ,7\u000fC\u0004\u0002@1\u0001\r!!\u0011\u0002=\u0015D\b/Z2uK\u00124\u0015N\\1mSj,GMR3biV\u0014Xm]#q_\u000eD\u0007cA\u0017\u0002D%\u0019\u0011Q\t\u0018\u0003\t1{gn\u001a\u0005\u0007\u0003\u0013b\u0001\u0019A\"\u00023\u0015D\b/Z2uK\u0012\u001cV\u000f\u001d9peR,GMR3biV\u0014Xm]\u0001\u000fG\",7m[#yG\u0016\u0004H/[8o+\u0011\ty%a\u001a\u0015\r\u0005E\u0013QQAH)\r!\u00141\u000b\u0005\b\u0003+j\u00019AA,\u0003\r!\u0018m\u001a\t\u0007\u00033\ny&a\u0019\u000e\u0005\u0005m#bAA/]\u00059!/\u001a4mK\u000e$\u0018\u0002BA1\u00037\u0012\u0001b\u00117bgN$\u0016m\u001a\t\u0005\u0003K\n9\u0007\u0004\u0001\u0005\u000f\u0005%TB1\u0001\u0002l\tiQ\t_2faRLwN\u001c+za\u0016\fB!!\u001c\u0002tA\u0019Q&a\u001c\n\u0007\u0005EdFA\u0004O_RD\u0017N\\4\u0011\t\u0005U\u0014q\u0010\b\u0005\u0003o\nYHD\u0002Y\u0003sJ\u0011aL\u0005\u0004\u0003{r\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u0003\u000b\u0019IA\u0005UQJ|w/\u00192mK*\u0019\u0011Q\u0010\u0018\t\u000f\u0005\u001dU\u00021\u0001\u0002\n\u00061!/Z:vYR\u0004B!!\u0004\u0002\f&!\u0011QRA\b\u0005Q)\u0006\u000fZ1uK\u001a+\u0017\r^;sKN\u0014Vm];mi\"9\u0011\u0011S\u0007A\u0002\u0005M\u0015a\u00074fCR,(/Z#yG\u0016\u0004H/[8o\u001bN<\u0007+\u0019;uKJt7\u000fE\u0003W;\u0002\f)\n\u0005\u0003\u0002\u0018\u0006}UBAAM\u0015\u0011\tY*!(\u0002\u00115\fGo\u00195j]\u001eT!\u0001\u0010\u0018\n\t\u0005\u0005\u0016\u0011\u0014\u0002\u0006%\u0016<W\r_\u0001\u001di\u0016\u001cHoV5uQ&sg/\u00197jI\u001a+\u0017\r^;sKV\u0003H-\u0019;f+\u0011\t9+!-\u0015\u0011\u0005%\u00161WA[\u0003\u007f#2\u0001NAV\u0011\u001d\t)F\u0004a\u0002\u0003[\u0003b!!\u0017\u0002`\u0005=\u0006\u0003BA3\u0003c#q!!\u001b\u000f\u0005\u0004\tY\u0007C\u0003G\u001d\u0001\u0007\u0001\rC\u0004\u00028:\u0001\r!!/\u0002\u001b%tg/\u00197jIV\u0003H-\u0019;f!\u0011\ti!a/\n\t\u0005u\u0016q\u0002\u0002\u000e\r\u0016\fG/\u001e:f+B$\u0017\r^3\t\u000f\u0005\u0005g\u00021\u0001\u0002\u0016\u0006\u0019R\r_2faRLwN\\'tOB\u000bG\u000f^3s]\u0006!C/Z:u'\"|W\u000f\u001c3GC&d'+Z9vKN$\u0018J\u001a(pi\u000e{g\u000e\u001e:pY2,'\u000fF\u00015Q\ry\u0011\u0011\u001a\t\u0005\u0003\u0017\fI.\u0004\u0002\u0002N*!\u0011qZAi\u0003\r\t\u0007/\u001b\u0006\u0005\u0003'\f).A\u0004kkBLG/\u001a:\u000b\u0007\u0005]G*A\u0003kk:LG/\u0003\u0003\u0002\\\u00065'\u0001\u0002+fgR\fQ\b^3tiNCw.\u001e7e\r\u0006LGNU3rk\u0016\u001cHo\u00165f]\u0012{wO\\4sC\u0012,g\t\\1h\u0013Ntu\u000e^*fi\u0012+(/\u001b8h\t><hn\u001a:bI\u0016D3\u0001EAe\u0003\u0005#Xm\u001d;TQ>,H\u000e\u001a$bS2\u0014V-];fgR<\u0006.\u001a8E_^twM]1eKR{\u0007*[4iKJ4VM]:j_:dUM^3m\u0013N\fE\u000f^3naR,G\rK\u0002\u0012\u0003\u0013\fA\t^3tiNCw.\u001e7e\r\u0006LGNU3rk\u0016\u001cH/\u00138TKJ4XM],iK:$un\u001e8he\u0006$WM\u00127bO&\u001bhj\u001c;TKR$UO]5oO\u0012+G.\u001a;j_:D3AEAe\u0003]\"Xm\u001d;TQ>,H\u000e\u001a$bS2\u0014V-];fgR$UO]5oO\u0012+G.\u001a;j_:|eMT8o\u000bbL7\u000f^5oO\u001a+\u0017\r^;sK\"\u001a1#!3\u0002iQ,7\u000f^*i_VdGMR1jYJ+\u0017/^3ti^CWM\\+qOJ\fG-\u001b8h)>\u001c\u0016-\\3WKJ\u001c\u0018n\u001c8MKZ,G\u000eK\u0002\u0015\u0003\u0013\fq\b^3tiNCw.\u001e7e\r\u0006LGNU3rk\u0016\u001cH\u000fR;sS:<'I]8lKJl\u0015\r\u001f,feNLwN\u001c'fm\u0016d\u0017J\\2p[B\fG/\u001b2jY&$\u0018\u0010F\u00045\u0003k\fI0!@\t\r\u0005]X\u00031\u0001a\u0003-1W-\u0019;ve\u0016t\u0015-\\3\t\r\u0005mX\u00031\u0001Q\u0003U\u0019X\u000f\u001d9peR,GMV3sg&|gNU1oO\u0016Dq!a@\u0016\u0001\u0004\u0011\t!\u0001\u000fj]&$\u0018.\u00197GS:\fG.\u001b>fIZ+'o]5p]J\u000bgnZ3\u0011\t5\u0012\u0019aY\u0005\u0004\u0005\u000bq#AB(qi&|g.\u0001.uKN$8\u000b[8vY\u00124\u0015-\u001b7SKF,Xm\u001d;EkJLgn\u001a\"s_.,'/T1y-\u0016\u00148/[8o\u0019\u00164X\r\\%oG>l\u0007/\u0019;jE&d\u0017\u000e^=G_J,\u00050[:uS:<g)\u001b8bY&TX\r\u001a$fCR,(/\u001a\u0015\u0004-\u0005%\u0017!\u0018;fgR\u001c\u0006n\\;mI\u001a\u000b\u0017\u000e\u001c*fcV,7\u000f\u001e#ve&twM\u0011:pW\u0016\u0014X*\u0019=WKJ\u001c\u0018n\u001c8MKZ,G.\u00138d_6\u0004\u0018\r^5cS2LG/_,ji\"tu.\u0012=jgRLgn\u001a$j]\u0006d\u0017N_3e\r\u0016\fG/\u001e:fQ\r9\u0012\u0011Z\u0001?i\u0016\u001cHoU;dG\u0016\u001c8OZ;m\r\u0016\fG/\u001e:f+B<'/\u00193f\u0003:$w+\u001b;i\u001d>,\u00050[:uS:<g)\u001b8bY&TX\r\u001a$fCR,(/Z:)\u0007a\tI-\u0001\u0015uKN$8+^2dKN\u001ch-\u001e7GK\u0006$XO]3Va\u001e\u0014\u0018\rZ3B]\u0012$un\u001e8he\u0006$W\rK\u0002\u001a\u0003\u0013\fa\b^3tiB\u000b'\u000f^5bYN+8mY3tg\u0012+(/\u001b8h-\u0006d\u0017\u000e\u001a$fCR,(/Z+qOJ\fG-Z!oI&sg/\u00197jI\u0012{wO\\4sC\u0012,\u0007f\u0001\u000e\u0002J\u0006qD/Z:u!\u0006\u0014H/[1m'V\u001c7-Z:t\tV\u0014\u0018N\\4J]Z\fG.\u001b3GK\u0006$XO]3Va\u001e\u0014\u0018\rZ3B]\u00124\u0016\r\\5e\t><hn\u001a:bI\u0016D3aGAe\u0001")
public class UpdateFeaturesTest
extends BaseRequestTest {
    @Override
    public int brokerCount() {
        return 3;
    }

    @Override
    public void brokerPropertyOverrides(Properties props) {
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), MetadataVersion.IBP_2_7_IV0.toString());
    }

    private Features<SupportedVersionRange> defaultSupportedFeatures() {
        Map.Entry[] entryArray = new Map.Entry[1];
        SupportedVersionRange mkEntry_v = new SupportedVersionRange(1, 3);
        String mkEntry_k = "feature_1";
        Object var1_2 = null;
        Object var2_1 = null;
        entryArray[0] = new AbstractMap.SimpleEntry<String, SupportedVersionRange>(mkEntry_k, mkEntry_v);
        return Features.supportedFeatures((java.util.Map)Utils.mkMap((Map.Entry[])entryArray));
    }

    private scala.collection.immutable.Map<String, Object> defaultFinalizedFeatures() {
        Map.Entry[] entryArray = new Map.Entry[1];
        Short mkEntry_v = BoxesRunTime.boxToShort((short)((short)2));
        String mkEntry_k = "feature_1";
        Object var1_2 = null;
        Object var2_1 = null;
        entryArray[0] = new AbstractMap.SimpleEntry<String, Short>(mkEntry_k, mkEntry_v);
        return CollectionConverters$.MODULE$.MapHasAsScala(Utils.mkMap((Map.Entry[])entryArray)).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    /*
     * WARNING - void declaration
     */
    private void updateSupportedFeatures(Features<SupportedVersionRange> features, Set<KafkaServer> targetServers) {
        targetServers.foreach((Function1 & Serializable)s -> {
            UpdateFeaturesTest.$anonfun$updateSupportedFeatures$1(features, s);
            return BoxedUnit.UNIT;
        });
        Set brokerIds = (Set)targetServers.map((Function1 & Serializable)s -> BoxesRunTime.boxToInteger((int)UpdateFeaturesTest.$anonfun$updateSupportedFeatures$2(s)));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!UpdateFeaturesTest.$anonfun$updateSupportedFeatures$3(this, brokerIds, features)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Controller did not get broker updates");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void updateSupportedFeaturesInAllBrokers(Features<SupportedVersionRange> features) {
        this.updateSupportedFeatures(features, (Set<KafkaServer>)((Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)).$plus$plus(this.servers())));
    }

    private int updateFeatureZNode(scala.collection.immutable.Map<String, Object> features) {
        KafkaServer server = (KafkaServer)this.serverForId(0).get();
        FeatureZNode newNode = FeatureZNode$.MODULE$.apply(MetadataVersion.IBP_2_7_IV0, (FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, features);
        int newVersion = server.zkClient().updateFeatureZNode(newNode);
        this.servers().foreach((Function1 & Serializable)s -> {
            UpdateFeaturesTest.$anonfun$updateFeatureZNode$1(newVersion, s);
            return BoxedUnit.UNIT;
        });
        return newVersion;
    }

    /*
     * WARNING - void declaration
     */
    private FeatureZNode getFeatureZNode() {
        void var2_2;
        Tuple2 tuple2 = ((KafkaServer)this.serverForId(0).get()).zkClient().getDataAndVersion("/feature");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeBytes = (Option)tuple2._1();
        Assertions.assertNotEquals((int)tuple2._2$mcI$sp(), (int)ZkVersion$.MODULE$.UnknownVersion());
        return FeatureZNode$.MODULE$.decode((byte[])var2_2.get());
    }

    private scala.collection.immutable.Map<String, Object> finalizedFeatures(java.util.Map<String, FinalizedVersionRange> features) {
        return CollectionConverters$.MODULE$.MapHasAsScala(features).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String name = (String)x0$1._1();
                FinalizedVersionRange versionRange = (FinalizedVersionRange)x0$1._2();
                return new Tuple2((Object)name, (Object)BoxesRunTime.boxToShort((short)versionRange.maxVersionLevel()));
            }
            throw new MatchError(null);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Features<SupportedVersionRange> supportedFeatures(java.util.Map<String, org.apache.kafka.clients.admin.SupportedVersionRange> features) {
        return Features.supportedFeatures((java.util.Map)CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(features).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String name = (String)x0$1._1();
                org.apache.kafka.clients.admin.SupportedVersionRange versionRange = (org.apache.kafka.clients.admin.SupportedVersionRange)x0$1._2();
                return new Tuple2((Object)name, (Object)new SupportedVersionRange(versionRange.minVersion(), versionRange.maxVersion()));
            }
            throw new MatchError(null);
        })).asJava());
    }

    private void checkFeatures(Admin client, FeatureZNode expectedNode, scala.collection.immutable.Map<String, Object> expectedFinalizedFeatures, long expectedFinalizedFeaturesEpoch, Features<SupportedVersionRange> expectedSupportedFeatures) {
        Assertions.assertEquals((Object)expectedNode, (Object)this.getFeatureZNode());
        FeatureMetadata featureMetadata = (FeatureMetadata)client.describeFeatures().featureMetadata().get();
        Assertions.assertEquals(expectedFinalizedFeatures, this.finalizedFeatures(featureMetadata.finalizedFeatures()));
        Assertions.assertEquals(expectedSupportedFeatures, this.supportedFeatures(featureMetadata.supportedFeatures()));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)expectedFinalizedFeaturesEpoch)), (Object)featureMetadata.finalizedFeaturesEpoch());
    }

    private <ExceptionType extends Throwable> void checkException(UpdateFeaturesResult result, scala.collection.immutable.Map<String, Regex> featureExceptionMsgPatterns, ClassTag<ExceptionType> tag) {
        featureExceptionMsgPatterns.foreach((Function1 & Serializable)x0$1 -> {
            UpdateFeaturesTest.$anonfun$checkException$1(result, tag, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private <ExceptionType extends Throwable> void testWithInvalidFeatureUpdate(String feature, FeatureUpdate invalidUpdate, Regex exceptionMsgPattern, ClassTag<ExceptionType> tag) {
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        this.updateSupportedFeaturesInAllBrokers(this.defaultSupportedFeatures());
        int versionBefore = this.updateFeatureZNode(this.defaultFinalizedFeatures());
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        FeatureZNode nodeBefore = this.getFeatureZNode();
        UpdateFeaturesResult result = adminClient.updateFeatures(Utils.mkMap((Map.Entry[])new Map.Entry[]{new AbstractMap.SimpleEntry<String, FeatureUpdate>(feature, invalidUpdate)}), new UpdateFeaturesOptions());
        this.checkException(result, (scala.collection.immutable.Map<String, Regex>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)feature), (Object)exceptionMsgPattern)}))), tag);
        this.checkFeatures(adminClient, nodeBefore, this.defaultFinalizedFeatures(), versionBefore, this.defaultSupportedFeatures());
    }

    @Test
    public void testShouldFailRequestIfNotController() {
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        this.updateSupportedFeaturesInAllBrokers(this.defaultSupportedFeatures());
        int versionBefore = this.updateFeatureZNode(this.defaultFinalizedFeatures());
        FeatureZNode nodeBefore = this.getFeatureZNode();
        UpdateFeaturesRequestData.FeatureUpdateKeyCollection validUpdates = new UpdateFeaturesRequestData.FeatureUpdateKeyCollection();
        UpdateFeaturesRequestData.FeatureUpdateKey validUpdate = new UpdateFeaturesRequestData.FeatureUpdateKey();
        validUpdate.setFeature("feature_1");
        validUpdate.setMaxVersionLevel(((SupportedVersionRange)this.defaultSupportedFeatures().get("feature_1")).max());
        validUpdate.setAllowDowngrade(false);
        validUpdates.add((ImplicitLinkedHashCollection.Element)validUpdate);
        UpdateFeaturesResponse response = (UpdateFeaturesResponse)this.connectAndReceive(new UpdateFeaturesRequest.Builder(new UpdateFeaturesRequestData().setFeatureUpdates(validUpdates)).build(), this.notControllerSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(UpdateFeaturesResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)Errors.forCode((short)response.data().errorCode()));
        Assertions.assertNotNull((Object)response.data().errorMessage());
        Assertions.assertEquals((int)0, (int)response.data().results().size());
        this.checkFeatures(this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2()), nodeBefore, this.defaultFinalizedFeatures(), versionBefore, this.defaultSupportedFeatures());
    }

    @Test
    public void testShouldFailRequestWhenDowngradeFlagIsNotSetDuringDowngrade() {
        short targetMaxVersionLevel = (short)(BoxesRunTime.unboxToShort((Object)this.defaultFinalizedFeatures().apply((Object)"feature_1")) - 1);
        this.testWithInvalidFeatureUpdate("feature_1", new FeatureUpdate(targetMaxVersionLevel, FeatureUpdate.UpgradeType.UPGRADE), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*Can not downgrade finalized feature.*")), ClassTag$.MODULE$.apply(InvalidRequestException.class));
    }

    @Test
    public void testShouldFailRequestWhenDowngradeToHigherVersionLevelIsAttempted() {
        short targetMaxVersionLevel = (short)(BoxesRunTime.unboxToShort((Object)this.defaultFinalizedFeatures().apply((Object)"feature_1")) + 1);
        this.testWithInvalidFeatureUpdate("feature_1", new FeatureUpdate(targetMaxVersionLevel, FeatureUpdate.UpgradeType.SAFE_DOWNGRADE), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*When the downgradeType is set to SAFE in the request, the provided versionLevel:3.*existing versionLevel:2.*")), ClassTag$.MODULE$.apply(InvalidRequestException.class));
    }

    @Test
    public void testShouldFailRequestInServerWhenDowngradeFlagIsNotSetDuringDeletion() {
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        this.updateSupportedFeaturesInAllBrokers(this.defaultSupportedFeatures());
        int versionBefore = this.updateFeatureZNode(this.defaultFinalizedFeatures());
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        FeatureZNode nodeBefore = this.getFeatureZNode();
        UpdateFeaturesRequestData.FeatureUpdateKeyCollection invalidUpdates = new UpdateFeaturesRequestData.FeatureUpdateKeyCollection();
        UpdateFeaturesRequestData.FeatureUpdateKey invalidUpdate = new UpdateFeaturesRequestData.FeatureUpdateKey();
        invalidUpdate.setFeature("feature_1");
        invalidUpdate.setMaxVersionLevel((short)0);
        invalidUpdate.setAllowDowngrade(false);
        invalidUpdates.add((ImplicitLinkedHashCollection.Element)invalidUpdate);
        new UpdateFeaturesRequestData().setFeatureUpdates(invalidUpdates);
        UpdateFeaturesResponse response = (UpdateFeaturesResponse)this.connectAndReceive(new UpdateFeaturesRequest.Builder(new UpdateFeaturesRequestData().setFeatureUpdates(invalidUpdates)).build(), this.controllerSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(UpdateFeaturesResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((int)1, (int)response.data().results().size());
        UpdateFeaturesResponseData.UpdatableFeatureResult result = (UpdateFeaturesResponseData.UpdatableFeatureResult)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)response.data().results()).asScala().head();
        Assertions.assertEquals((Object)"feature_1", (Object)result.feature());
        Assertions.assertEquals((Object)Errors.INVALID_REQUEST, (Object)Errors.forCode((short)result.errorCode()));
        Assertions.assertNotNull((Object)result.errorMessage());
        Assertions.assertFalse((boolean)result.errorMessage().isEmpty());
        Assertions.assertTrue((boolean)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*Can not provide versionLevel: 0 less than 1.*")).findFirstIn((CharSequence)result.errorMessage()).isDefined(), (String)result.errorMessage());
        this.checkFeatures(adminClient, nodeBefore, this.defaultFinalizedFeatures(), versionBefore, this.defaultSupportedFeatures());
    }

    @Test
    public void testShouldFailRequestDuringDeletionOfNonExistingFeature() {
        this.testWithInvalidFeatureUpdate("feature_non_existing", new FeatureUpdate((short)3, FeatureUpdate.UpgradeType.SAFE_DOWNGRADE), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*Could not apply finalized feature update because the provided feature is not supported.*")), ClassTag$.MODULE$.apply(InvalidRequestException.class));
    }

    @Test
    public void testShouldFailRequestWhenUpgradingToSameVersionLevel() {
        short targetMaxVersionLevel = BoxesRunTime.unboxToShort((Object)this.defaultFinalizedFeatures().apply((Object)"feature_1"));
        this.testWithInvalidFeatureUpdate("feature_1", new FeatureUpdate(targetMaxVersionLevel, FeatureUpdate.UpgradeType.UPGRADE), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*Can not upgrade a finalized feature.*to the same value.*")), ClassTag$.MODULE$.apply(InvalidRequestException.class));
    }

    /*
     * WARNING - void declaration
     */
    private void testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibility(String featureName, SupportedVersionRange supportedVersionRange, Option<Object> initialFinalizedVersionRange) {
        void mkEntry_v;
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        KafkaServer controller = (KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UpdateFeaturesTest.$anonfun$testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibility$1(server)))).head();
        Buffer nonControllerServers = (Buffer)this.servers().filter((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UpdateFeaturesTest.$anonfun$testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibility$2(server)));
        Set brokersWithVersionIncompatibility = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{(KafkaServer)nonControllerServers.head()}));
        Set versionCompatibleBrokers = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{(KafkaServer)nonControllerServers.apply(1), controller}));
        Features supportedFeatures = Features.supportedFeatures((java.util.Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{new AbstractMap.SimpleEntry<String, SupportedVersionRange>(featureName, supportedVersionRange)}));
        this.updateSupportedFeatures((Features<SupportedVersionRange>)supportedFeatures, (Set<KafkaServer>)versionCompatibleBrokers);
        short unsupportedMaxVersion = (short)(supportedVersionRange.max() - 1);
        Map.Entry[] entryArray = new Map.Entry[1];
        SupportedVersionRange supportedVersionRange2 = new SupportedVersionRange(supportedVersionRange.min(), unsupportedMaxVersion);
        String mkEntry_k = "feature_1";
        Object var17_11 = null;
        supportedVersionRange2 = null;
        entryArray[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k, mkEntry_v);
        Features supportedFeaturesWithVersionIncompatibility = Features.supportedFeatures((java.util.Map)Utils.mkMap((Map.Entry[])entryArray));
        this.updateSupportedFeatures((Features<SupportedVersionRange>)supportedFeaturesWithVersionIncompatibility, (Set<KafkaServer>)brokersWithVersionIncompatibility);
        scala.collection.immutable.Map initialFinalizedFeatures = (scala.collection.immutable.Map)initialFinalizedVersionRange.map((Function1 & Serializable)versionRange -> UpdateFeaturesTest.$anonfun$testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibility$3(featureName, BoxesRunTime.unboxToShort((Object)versionRange))).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
        int versionBefore = this.updateFeatureZNode((scala.collection.immutable.Map<String, Object>)initialFinalizedFeatures);
        FeatureUpdate invalidUpdate = new FeatureUpdate(supportedVersionRange.max(), FeatureUpdate.UpgradeType.UPGRADE);
        FeatureZNode nodeBefore = this.getFeatureZNode();
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Map.Entry[] entryArray2 = new Map.Entry[1];
        String mkEntry_k2 = "feature_1";
        Object var19_18 = null;
        entryArray2[0] = new AbstractMap.SimpleEntry<String, FeatureUpdate>(mkEntry_k2, invalidUpdate);
        UpdateFeaturesResult result = adminClient.updateFeatures(Utils.mkMap((Map.Entry[])entryArray2), new UpdateFeaturesOptions());
        this.checkException(result, (scala.collection.immutable.Map<String, Regex>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*brokers.*incompatible.*")))}))), ClassTag$.MODULE$.apply(InvalidRequestException.class));
        this.checkFeatures(adminClient, nodeBefore, (scala.collection.immutable.Map<String, Object>)initialFinalizedFeatures, versionBefore, (Features<SupportedVersionRange>)supportedFeatures);
    }

    @Test
    public void testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibilityForExistingFinalizedFeature() {
        String feature = "feature_1";
        this.testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibility(feature, (SupportedVersionRange)this.defaultSupportedFeatures().get(feature), (Option<Object>)new Some(this.defaultFinalizedFeatures().apply((Object)feature)));
    }

    @Test
    public void testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibilityWithNoExistingFinalizedFeature() {
        String feature = "feature_1";
        this.testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibility(feature, (SupportedVersionRange)this.defaultSupportedFeatures().get(feature), (Option<Object>)Option$.MODULE$.empty());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSuccessfulFeatureUpgradeAndWithNoExistingFinalizedFeatures() {
        void mkEntry_v;
        void mkEntry_v2;
        void mkEntry_v3;
        void mkEntry_v4;
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        Map.Entry[] entryArray = new Map.Entry[2];
        SupportedVersionRange supportedVersionRange = new SupportedVersionRange(1, 3);
        String mkEntry_k = "feature_1";
        Object var7_2 = null;
        supportedVersionRange = null;
        entryArray[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k, mkEntry_v4);
        SupportedVersionRange supportedVersionRange2 = new SupportedVersionRange(2, 5);
        String mkEntry_k2 = "feature_2";
        Object var9_4 = null;
        supportedVersionRange2 = null;
        entryArray[1] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k2, mkEntry_v3);
        Features supportedFeatures = Features.supportedFeatures((java.util.Map)Utils.mkMap((Map.Entry[])entryArray));
        this.updateSupportedFeaturesInAllBrokers((Features<SupportedVersionRange>)supportedFeatures);
        int versionBefore = this.updateFeatureZNode((scala.collection.immutable.Map<String, Object>)Predef$.MODULE$.Map().empty());
        Map.Entry[] entryArray2 = new Map.Entry[2];
        Short s = BoxesRunTime.boxToShort((short)((short)3));
        String mkEntry_k3 = "feature_1";
        Object var11_8 = null;
        s = null;
        entryArray2[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k3, mkEntry_v2);
        Short s2 = BoxesRunTime.boxToShort((short)((short)3));
        String mkEntry_k4 = "feature_2";
        Object var13_10 = null;
        s2 = null;
        entryArray2[1] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k4, mkEntry_v);
        scala.collection.immutable.Map targetFinalizedFeatures = CollectionConverters$.MODULE$.MapHasAsScala(Utils.mkMap((Map.Entry[])entryArray2)).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        FeatureUpdate update1 = new FeatureUpdate(BoxesRunTime.unboxToShort((Object)targetFinalizedFeatures.apply((Object)"feature_1")), FeatureUpdate.UpgradeType.UPGRADE);
        FeatureUpdate update2 = new FeatureUpdate(BoxesRunTime.unboxToShort((Object)targetFinalizedFeatures.apply((Object)"feature_2")), FeatureUpdate.UpgradeType.UPGRADE);
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Map.Entry[] entryArray3 = new Map.Entry[2];
        String mkEntry_k5 = "feature_1";
        Object var15_15 = null;
        entryArray3[0] = new AbstractMap.SimpleEntry<String, FeatureUpdate>(mkEntry_k5, update1);
        String mkEntry_k6 = "feature_2";
        Object var16_16 = null;
        entryArray3[1] = new AbstractMap.SimpleEntry<String, FeatureUpdate>(mkEntry_k6, update2);
        adminClient.updateFeatures(Utils.mkMap((Map.Entry[])entryArray3), new UpdateFeaturesOptions()).all().get();
        this.checkFeatures(adminClient, FeatureZNode$.MODULE$.apply(MetadataVersion.IBP_2_7_IV0, (FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, (Map)targetFinalizedFeatures), (scala.collection.immutable.Map<String, Object>)targetFinalizedFeatures, versionBefore + 1, (Features<SupportedVersionRange>)supportedFeatures);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSuccessfulFeatureUpgradeAndDowngrade() {
        void mkEntry_v;
        void mkEntry_v2;
        void mkEntry_v3;
        void mkEntry_v4;
        void mkEntry_v5;
        void mkEntry_v6;
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        Map.Entry[] entryArray = new Map.Entry[2];
        SupportedVersionRange supportedVersionRange = new SupportedVersionRange(1, 3);
        String mkEntry_k = "feature_1";
        Object var8_2 = null;
        supportedVersionRange = null;
        entryArray[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k, mkEntry_v6);
        SupportedVersionRange supportedVersionRange2 = new SupportedVersionRange(2, 5);
        String mkEntry_k2 = "feature_2";
        Object var10_4 = null;
        supportedVersionRange2 = null;
        entryArray[1] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k2, mkEntry_v5);
        Features supportedFeatures = Features.supportedFeatures((java.util.Map)Utils.mkMap((Map.Entry[])entryArray));
        this.updateSupportedFeaturesInAllBrokers((Features<SupportedVersionRange>)supportedFeatures);
        Map.Entry[] entryArray2 = new Map.Entry[2];
        Short s = BoxesRunTime.boxToShort((short)((short)2));
        String mkEntry_k3 = "feature_1";
        Object var12_7 = null;
        s = null;
        entryArray2[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k3, mkEntry_v4);
        Short s2 = BoxesRunTime.boxToShort((short)((short)4));
        String mkEntry_k4 = "feature_2";
        Object var14_9 = null;
        s2 = null;
        entryArray2[1] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k4, mkEntry_v3);
        scala.collection.immutable.Map initialFinalizedFeatures = CollectionConverters$.MODULE$.MapHasAsScala(Utils.mkMap((Map.Entry[])entryArray2)).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        int versionBefore = this.updateFeatureZNode((scala.collection.immutable.Map<String, Object>)initialFinalizedFeatures);
        Map.Entry[] entryArray3 = new Map.Entry[2];
        Short s3 = BoxesRunTime.boxToShort((short)((short)3));
        String mkEntry_k5 = "feature_1";
        Object var16_13 = null;
        s3 = null;
        entryArray3[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k5, mkEntry_v2);
        Short s4 = BoxesRunTime.boxToShort((short)((short)3));
        String mkEntry_k6 = "feature_2";
        Object var18_15 = null;
        s4 = null;
        entryArray3[1] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k6, mkEntry_v);
        scala.collection.immutable.Map targetFinalizedFeatures = CollectionConverters$.MODULE$.MapHasAsScala(Utils.mkMap((Map.Entry[])entryArray3)).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        FeatureUpdate update1 = new FeatureUpdate(BoxesRunTime.unboxToShort((Object)targetFinalizedFeatures.apply((Object)"feature_1")), FeatureUpdate.UpgradeType.UPGRADE);
        FeatureUpdate update2 = new FeatureUpdate(BoxesRunTime.unboxToShort((Object)targetFinalizedFeatures.apply((Object)"feature_2")), FeatureUpdate.UpgradeType.SAFE_DOWNGRADE);
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Map.Entry[] entryArray4 = new Map.Entry[2];
        String mkEntry_k7 = "feature_1";
        Object var20_20 = null;
        entryArray4[0] = new AbstractMap.SimpleEntry<String, FeatureUpdate>(mkEntry_k7, update1);
        String mkEntry_k8 = "feature_2";
        Object var21_21 = null;
        entryArray4[1] = new AbstractMap.SimpleEntry<String, FeatureUpdate>(mkEntry_k8, update2);
        adminClient.updateFeatures(Utils.mkMap((Map.Entry[])entryArray4), new UpdateFeaturesOptions()).all().get();
        this.checkFeatures(adminClient, FeatureZNode$.MODULE$.apply(MetadataVersion.IBP_2_7_IV0, (FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, (Map)targetFinalizedFeatures), (scala.collection.immutable.Map<String, Object>)targetFinalizedFeatures, versionBefore + 1, (Features<SupportedVersionRange>)supportedFeatures);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartialSuccessDuringValidFeatureUpgradeAndInvalidDowngrade() {
        void mkEntry_v;
        void mkEntry_v2;
        void mkEntry_v3;
        void mkEntry_v4;
        void mkEntry_v5;
        void mkEntry_v6;
        void mkEntry_v7;
        void mkEntry_v8;
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        Map.Entry[] entryArray = new Map.Entry[2];
        SupportedVersionRange supportedVersionRange = new SupportedVersionRange(1, 3);
        String mkEntry_k = "feature_1";
        Object var10_2 = null;
        supportedVersionRange = null;
        entryArray[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k, mkEntry_v8);
        SupportedVersionRange supportedVersionRange2 = new SupportedVersionRange(2, 5);
        String mkEntry_k2 = "feature_2";
        Object var12_4 = null;
        supportedVersionRange2 = null;
        entryArray[1] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k2, mkEntry_v7);
        Features supportedFeatures = Features.supportedFeatures((java.util.Map)Utils.mkMap((Map.Entry[])entryArray));
        this.updateSupportedFeaturesInAllBrokers((Features<SupportedVersionRange>)supportedFeatures);
        Map.Entry[] entryArray2 = new Map.Entry[2];
        Short s = BoxesRunTime.boxToShort((short)((short)2));
        String mkEntry_k3 = "feature_1";
        Object var14_7 = null;
        s = null;
        entryArray2[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k3, mkEntry_v6);
        Short s2 = BoxesRunTime.boxToShort((short)((short)4));
        String mkEntry_k4 = "feature_2";
        Object var16_9 = null;
        s2 = null;
        entryArray2[1] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k4, mkEntry_v5);
        scala.collection.immutable.Map initialFinalizedFeatures = CollectionConverters$.MODULE$.MapHasAsScala(Utils.mkMap((Map.Entry[])entryArray2)).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        int versionBefore = this.updateFeatureZNode((scala.collection.immutable.Map<String, Object>)initialFinalizedFeatures);
        Map.Entry[] entryArray3 = new Map.Entry[2];
        Short s3 = BoxesRunTime.boxToShort((short)((short)3));
        String mkEntry_k5 = "feature_1";
        Object var18_13 = null;
        s3 = null;
        entryArray3[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k5, mkEntry_v4);
        Short s4 = BoxesRunTime.boxToShort((short)((short)3));
        String mkEntry_k6 = "feature_2";
        Object var20_15 = null;
        s4 = null;
        entryArray3[1] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k6, mkEntry_v3);
        scala.collection.immutable.Map targetFinalizedFeatures = CollectionConverters$.MODULE$.MapHasAsScala(Utils.mkMap((Map.Entry[])entryArray3)).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        FeatureUpdate validUpdate = new FeatureUpdate(BoxesRunTime.unboxToShort((Object)targetFinalizedFeatures.apply((Object)"feature_1")), FeatureUpdate.UpgradeType.UPGRADE);
        FeatureUpdate invalidUpdate = new FeatureUpdate(BoxesRunTime.unboxToShort((Object)targetFinalizedFeatures.apply((Object)"feature_2")), FeatureUpdate.UpgradeType.UPGRADE);
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Map.Entry[] entryArray4 = new Map.Entry[2];
        String mkEntry_k7 = "feature_1";
        Object var22_20 = null;
        entryArray4[0] = new AbstractMap.SimpleEntry<String, FeatureUpdate>(mkEntry_k7, validUpdate);
        String mkEntry_k8 = "feature_2";
        Object var23_21 = null;
        entryArray4[1] = new AbstractMap.SimpleEntry<String, FeatureUpdate>(mkEntry_k8, invalidUpdate);
        UpdateFeaturesResult result = adminClient.updateFeatures(Utils.mkMap((Map.Entry[])entryArray4), new UpdateFeaturesOptions());
        ((KafkaFuture)result.values().get("feature_1")).get();
        this.checkException(result, (scala.collection.immutable.Map<String, Regex>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_2"), (Object)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*Can not downgrade finalized feature.*")))}))), ClassTag$.MODULE$.apply(InvalidRequestException.class));
        Map.Entry[] entryArray5 = new Map.Entry[2];
        Object object = targetFinalizedFeatures.apply((Object)"feature_1");
        String mkEntry_k9 = "feature_1";
        Object var24_24 = null;
        object = null;
        entryArray5[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k9, mkEntry_v2);
        Object object2 = initialFinalizedFeatures.apply((Object)"feature_2");
        String mkEntry_k10 = "feature_2";
        Object var26_26 = null;
        object2 = null;
        entryArray5[1] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k10, mkEntry_v);
        scala.collection.immutable.Map expectedFeatures = CollectionConverters$.MODULE$.MapHasAsScala(Utils.mkMap((Map.Entry[])entryArray5)).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.checkFeatures(adminClient, FeatureZNode$.MODULE$.apply(MetadataVersion.IBP_3_2_IV0, (FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, (Map)expectedFeatures), (scala.collection.immutable.Map<String, Object>)expectedFeatures, versionBefore + 1, (Features<SupportedVersionRange>)supportedFeatures);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartialSuccessDuringInvalidFeatureUpgradeAndValidDowngrade() {
        void mkEntry_v;
        void mkEntry_v2;
        void mkEntry_v3;
        void mkEntry_v4;
        void mkEntry_v5;
        void mkEntry_v6;
        void mkEntry_v7;
        void mkEntry_v8;
        void mkEntry_v9;
        void mkEntry_v10;
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        KafkaServer controller = (KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UpdateFeaturesTest.$anonfun$testPartialSuccessDuringInvalidFeatureUpgradeAndValidDowngrade$1(server)))).head();
        Buffer nonControllerServers = (Buffer)this.servers().filter((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UpdateFeaturesTest.$anonfun$testPartialSuccessDuringInvalidFeatureUpgradeAndValidDowngrade$2(server)));
        Set brokersWithVersionIncompatibility = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{(KafkaServer)nonControllerServers.head()}));
        Set versionCompatibleBrokers = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{(KafkaServer)nonControllerServers.apply(1), controller}));
        Map.Entry[] entryArray = new Map.Entry[2];
        SupportedVersionRange supportedVersionRange = new SupportedVersionRange(1, 3);
        String mkEntry_k = "feature_1";
        Object var15_6 = null;
        supportedVersionRange = null;
        entryArray[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k, mkEntry_v10);
        SupportedVersionRange supportedVersionRange2 = new SupportedVersionRange(2, 5);
        String mkEntry_k2 = "feature_2";
        Object var17_8 = null;
        supportedVersionRange2 = null;
        entryArray[1] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k2, mkEntry_v9);
        Features supportedFeatures = Features.supportedFeatures((java.util.Map)Utils.mkMap((Map.Entry[])entryArray));
        this.updateSupportedFeatures((Features<SupportedVersionRange>)supportedFeatures, (Set<KafkaServer>)versionCompatibleBrokers);
        Map.Entry[] entryArray2 = new Map.Entry[2];
        SupportedVersionRange supportedVersionRange3 = new SupportedVersionRange(1, 2);
        String mkEntry_k3 = "feature_1";
        Object var19_11 = null;
        supportedVersionRange3 = null;
        entryArray2[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k3, mkEntry_v8);
        BaseVersionRange baseVersionRange = supportedFeatures.get("feature_2");
        String mkEntry_k4 = "feature_2";
        Object var21_13 = null;
        baseVersionRange = null;
        entryArray2[1] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k4, mkEntry_v7);
        Features supportedFeaturesWithVersionIncompatibility = Features.supportedFeatures((java.util.Map)Utils.mkMap((Map.Entry[])entryArray2));
        this.updateSupportedFeatures((Features<SupportedVersionRange>)supportedFeaturesWithVersionIncompatibility, (Set<KafkaServer>)brokersWithVersionIncompatibility);
        Map.Entry[] entryArray3 = new Map.Entry[2];
        Short s = BoxesRunTime.boxToShort((short)((short)2));
        String mkEntry_k5 = "feature_1";
        Object var23_16 = null;
        s = null;
        entryArray3[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k5, mkEntry_v6);
        Short s2 = BoxesRunTime.boxToShort((short)((short)4));
        String mkEntry_k6 = "feature_2";
        Object var25_18 = null;
        s2 = null;
        entryArray3[1] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k6, mkEntry_v5);
        scala.collection.immutable.Map initialFinalizedFeatures = CollectionConverters$.MODULE$.MapHasAsScala(Utils.mkMap((Map.Entry[])entryArray3)).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        int versionBefore = this.updateFeatureZNode((scala.collection.immutable.Map<String, Object>)initialFinalizedFeatures);
        Map.Entry[] entryArray4 = new Map.Entry[2];
        Short s3 = BoxesRunTime.boxToShort((short)((short)3));
        String mkEntry_k7 = "feature_1";
        Object var27_22 = null;
        s3 = null;
        entryArray4[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k7, mkEntry_v4);
        Short s4 = BoxesRunTime.boxToShort((short)((short)3));
        String mkEntry_k8 = "feature_2";
        Object var29_24 = null;
        s4 = null;
        entryArray4[1] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k8, mkEntry_v3);
        scala.collection.immutable.Map targetFinalizedFeatures = CollectionConverters$.MODULE$.MapHasAsScala(Utils.mkMap((Map.Entry[])entryArray4)).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        FeatureUpdate invalidUpdate = new FeatureUpdate(BoxesRunTime.unboxToShort((Object)targetFinalizedFeatures.apply((Object)"feature_1")), FeatureUpdate.UpgradeType.UPGRADE);
        FeatureUpdate validUpdate = new FeatureUpdate(BoxesRunTime.unboxToShort((Object)targetFinalizedFeatures.apply((Object)"feature_2")), FeatureUpdate.UpgradeType.SAFE_DOWNGRADE);
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Map.Entry[] entryArray5 = new Map.Entry[2];
        String mkEntry_k9 = "feature_1";
        Object var31_29 = null;
        entryArray5[0] = new AbstractMap.SimpleEntry<String, FeatureUpdate>(mkEntry_k9, invalidUpdate);
        String mkEntry_k10 = "feature_2";
        Object var32_30 = null;
        entryArray5[1] = new AbstractMap.SimpleEntry<String, FeatureUpdate>(mkEntry_k10, validUpdate);
        UpdateFeaturesResult result = adminClient.updateFeatures(Utils.mkMap((Map.Entry[])entryArray5), new UpdateFeaturesOptions());
        ((KafkaFuture)result.values().get("feature_2")).get();
        this.checkException(result, (scala.collection.immutable.Map<String, Regex>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*brokers.*incompatible.*")))}))), ClassTag$.MODULE$.apply(InvalidRequestException.class));
        Map.Entry[] entryArray6 = new Map.Entry[2];
        Object object = initialFinalizedFeatures.apply((Object)"feature_1");
        String mkEntry_k11 = "feature_1";
        Object var33_33 = null;
        object = null;
        entryArray6[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k11, mkEntry_v2);
        Object object2 = targetFinalizedFeatures.apply((Object)"feature_2");
        String mkEntry_k12 = "feature_2";
        Object var35_35 = null;
        object2 = null;
        entryArray6[1] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k12, mkEntry_v);
        scala.collection.immutable.Map expectedFeatures = CollectionConverters$.MODULE$.MapHasAsScala(Utils.mkMap((Map.Entry[])entryArray6)).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.checkFeatures(adminClient, FeatureZNode$.MODULE$.apply(MetadataVersion.IBP_3_2_IV0, (FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, (Map)expectedFeatures), (scala.collection.immutable.Map<String, Object>)expectedFeatures, versionBefore + 1, (Features<SupportedVersionRange>)supportedFeatures);
    }

    public static final /* synthetic */ void $anonfun$updateSupportedFeatures$1(Features features$1, KafkaServer s) {
        s.brokerFeatures().setSupportedFeatures(features$1);
        s.zkClient().updateBrokerInfo(s.createBrokerInfo());
    }

    public static final /* synthetic */ int $anonfun$updateSupportedFeatures$2(KafkaServer s) {
        return s.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$updateSupportedFeatures$6(Features features$1, Broker b) {
        return b.features().equals((Object)features$1);
    }

    public static final /* synthetic */ boolean $anonfun$updateSupportedFeatures$4(Set brokerIds$1, Features features$1, KafkaServer s) {
        if (s.kafkaController().isActive()) {
            return ((IterableOnceOps)s.kafkaController().controllerContext().liveOrShuttingDownBrokers().filter((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)brokerIds$1.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))))).forall((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)UpdateFeaturesTest.$anonfun$updateSupportedFeatures$6(features$1, b)));
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$updateSupportedFeatures$3(UpdateFeaturesTest $this, Set brokerIds$1, Features features$1) {
        return $this.servers().exists((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)UpdateFeaturesTest.$anonfun$updateSupportedFeatures$4(brokerIds$1, features$1, s)));
    }

    public static final /* synthetic */ String $anonfun$updateSupportedFeatures$7() {
        return "Controller did not get broker updates";
    }

    public static final /* synthetic */ void $anonfun$updateFeatureZNode$1(int newVersion$1, KafkaServer s) {
        s.metadataCache().waitUntilFeatureEpochOrThrow((long)newVersion$1, (long)s.config().zkConnectionTimeoutMs());
    }

    public static final /* synthetic */ void $anonfun$checkException$1(UpdateFeaturesResult result$1, ClassTag tag$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String feature = (String)x0$1._1();
            Regex exceptionMsgPattern = (Regex)x0$1._2();
            Throwable cause = ((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)result$1.values().get(feature)).get())).getCause();
            Assertions.assertNotNull((Object)cause);
            Assertions.assertEquals(cause.getClass(), (Object)tag$1.runtimeClass());
            Assertions.assertTrue((boolean)exceptionMsgPattern.findFirstIn((CharSequence)cause.getMessage()).isDefined(), (String)new StringBuilder(35).append("Received unexpected error message: ").append(cause.getMessage()).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibility$1(KafkaServer server) {
        return server.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibility$2(KafkaServer server) {
        return !server.kafkaController().isActive();
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibility$3(String featureName$1, short versionRange) {
        Map.Entry[] entryArray = new Map.Entry[1];
        Short mkEntry_v = BoxesRunTime.boxToShort((short)versionRange);
        Object var2_2 = null;
        entryArray[0] = new AbstractMap.SimpleEntry<String, Short>(featureName$1, mkEntry_v);
        return CollectionConverters$.MODULE$.MapHasAsScala(Utils.mkMap((Map.Entry[])entryArray)).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ boolean $anonfun$testPartialSuccessDuringInvalidFeatureUpgradeAndValidDowngrade$1(KafkaServer server) {
        return server.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testPartialSuccessDuringInvalidFeatureUpgradeAndValidDowngrade$2(KafkaServer server) {
        return !server.kafkaController().isActive();
    }
}

