/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk.migration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.function.BiConsumer;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig$;
import kafka.server.ZkAdminManager$;
import kafka.utils.CoreUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.ZkMigrationClient;
import kafka.zk.migration.ZkMigrationTestHarness;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.metadata.ClientQuotaRecord;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.image.ClientQuotasDelta;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.metadata.migration.KRaftMigrationZkWriter;
import org.apache.kafka.metadata.migration.MigrationClient;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.util.MockRandom;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005%b\u0001B\u0007\u000f\u0001UAQA\u0007\u0001\u0005\u0002mAQ!\b\u0001\u0005\u0002yAQ\u0001\u0010\u0001\u0005\u0002uBQ\u0001\u0014\u0001\u0005\u0002uBQA\u0014\u0001\u0005\u0002uBQ\u0001\u0015\u0001\u0005\nECa!!\u0005\u0001\t\u0003i\u0004BBA\u000b\u0001\u0011\u0005Q\b\u0003\u0004\u0002\u001a\u0001!\t!\u0010\u0005\u0007\u0003;\u0001A\u0011A\u001f\t\r\u0005\u0005\u0002\u0001\"\u0001>\u0011\u0019\t)\u0003\u0001C\u0001{\tY\"l[\"p]\u001aLw-T5he\u0006$\u0018n\u001c8DY&,g\u000e\u001e+fgRT!a\u0004\t\u0002\u00135LwM]1uS>t'BA\t\u0013\u0003\tQ8NC\u0001\u0014\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]AR\"\u0001\b\n\u0005eq!A\u0006.l\u001b&<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005a\u0002CA\f\u0001\u00031\u0011\u0018M\u001c3p[\n+hMZ3s)\ry\u0002f\u000e\t\u0004A\r*S\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u00012\u0013BA\u0014\"\u0005\u0011\u0011\u0015\u0010^3\t\u000b%\u0012\u0001\u0019\u0001\u0016\u0002\rI\fg\u000eZ8n!\tYS'D\u0001-\u0015\tic&\u0001\u0003vi&d'BA\u00181\u0003\u0019\u0019XM\u001d<fe*\u00111#\r\u0006\u0003eM\na!\u00199bG\",'\"\u0001\u001b\u0002\u0007=\u0014x-\u0003\u00027Y\tQQj\\2l%\u0006tGm\\7\t\u000ba\u0012\u0001\u0019A\u001d\u0002\r1,gn\u001a;i!\t\u0001#(\u0003\u0002<C\t\u0019\u0011J\u001c;\u00025Q,7\u000f^'jOJ\fG/[8o\u0005J|7.\u001a:D_:4\u0017nZ:\u0015\u0003y\u0002\"\u0001I \n\u0005\u0001\u000b#\u0001B+oSRD#a\u0001\"\u0011\u0005\rSU\"\u0001#\u000b\u0005\u00153\u0015aA1qS*\u0011q\tS\u0001\bUV\u0004\u0018\u000e^3s\u0015\tI5'A\u0003kk:LG/\u0003\u0002L\t\n!A+Z:u\u0003]!Xm\u001d;NS\u001e\u0014\u0018\r^3DY&,g\u000e^)v_R\f7\u000f\u000b\u0002\u0005\u0005\u0006iB/Z:u/JLG/Z#ySN$\u0018N\\4DY&,g\u000e^)v_R\f7\u000f\u000b\u0002\u0006\u0005\u0006IrO]5uK\u000ec\u0017.\u001a8u#V|G/Y!oIZ+'/\u001b4z))\u0011\u0016l\u00183gs\u0006%\u0011Q\u0002\t\u0003'^k\u0011\u0001\u0016\u0006\u0003\u001fUS!A\u0016\u0019\u0002\u00115,G/\u00193bi\u0006L!\u0001\u0017+\u00035i[W*[4sCRLwN\u001c'fC\u0012,'o\u001d5jaN#\u0018\r^3\t\u000bi3\u0001\u0019A.\u0002\u001f5LwM]1uS>t7\t\\5f]R\u0004\"\u0001X/\u000e\u0003AI!A\u0018\t\u0003#i[W*[4sCRLwN\\\"mS\u0016tG\u000fC\u0003a\r\u0001\u0007\u0011-A\u0007bI6LgNW6DY&,g\u000e\u001e\t\u00039\nL!a\u0019\t\u0003\u001b\u0005#W.\u001b8[W\u000ec\u0017.\u001a8u\u0011\u0015)g\u00011\u0001S\u00039i\u0017n\u001a:bi&|gn\u0015;bi\u0016DQa\u001a\u0004A\u0002!\fa!\u001a8uSRL\b\u0003B5m]:l\u0011A\u001b\u0006\u0003W\u0006\n!bY8mY\u0016\u001cG/[8o\u0013\ti'NA\u0002NCB\u0004\"a\u001c<\u000f\u0005A$\bCA9\"\u001b\u0005\u0011(BA:\u0015\u0003\u0019a$o\\8u}%\u0011Q/I\u0001\u0007!J,G-\u001a4\n\u0005]D(AB*ue&twM\u0003\u0002vC!)!P\u0002a\u0001w\u00061\u0011/^8uCN\u0004B!\u001b7oyB\u0019Q0!\u0002\u000e\u0003yT1a`A\u0001\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\r\u0011\u0001\u00026bm\u0006L1!a\u0002\u007f\u0005\u0019!u.\u001e2mK\"1\u00111\u0002\u0004A\u00029\fAB_6F]RLG/\u001f+za\u0016Da!a\u0004\u0007\u0001\u0004q\u0017\u0001\u0004>l\u000b:$\u0018\u000e^=OC6,\u0017\u0001\u0007;fgR<&/\u001b;f\u001d\u0016<8\t\\5f]R\fVo\u001c;bg\"\u0012qAQ\u0001\u0019i\u0016\u001cHo\u0016:ji\u0016tUm\u001e+pa&\u001c7i\u001c8gS\u001e\u001c\bF\u0001\u0005C\u0003u!Xm\u001d;Xe&$X-\u0012=jgRLgn\u001a+pa&\u001c7i\u001c8gS\u001e\u001c\bFA\u0005C\u0003%!Xm\u001d;TGJ\fW\u000e\u000b\u0002\u000b\u0005\u0006\u0011C/Z:u'\u000e\u0014\u0018-\\!oIF+x\u000e^1DQ\u0006tw-Z:J]Ns\u0017\r]:i_RD#a\u0003\"\u0002)Q,7\u000f\u001e#fY\u0016<\u0017\r^5p]R{7.\u001a8tQ\ta!\t")
public class ZkConfigMigrationClientTest
extends ZkMigrationTestHarness {
    public byte[] randomBuffer(MockRandom random, int length) {
        byte[] buf = new byte[length];
        random.nextBytes(buf);
        return buf;
    }

    @Test
    public void testMigrationBrokerConfigs() {
        ArrayList brokers = new ArrayList();
        ArrayList batches = new ArrayList();
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "1");
        props.put(KafkaConfig$.MODULE$.SslKeystorePasswordProp(), this.encoder().encode(new Password(this.SECRET())));
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Broker(), "1", props);
        Properties defaultProps = new Properties();
        defaultProps.put(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "3");
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Broker(), "<default>", defaultProps);
        this.migrationClient().migrateBrokerConfigs(batch -> batches.add(batch), brokerId -> brokers.add(brokerId));
        Assertions.assertEquals((int)1, (int)brokers.size());
        Assertions.assertEquals((int)2, (int)batches.size());
        Assertions.assertEquals((int)2, (int)((java.util.List)batches.get(0)).size());
        Assertions.assertEquals((int)1, (int)((java.util.List)batches.get(1)).size());
        ((Iterable)batches.get(0)).forEach(record -> {
            ConfigRecord message = (ConfigRecord)record.message();
            String name = message.name();
            String value = message.value();
            Assertions.assertTrue((boolean)props.containsKey(name));
            String string = name;
            String string2 = KafkaConfig$.MODULE$.SslKeystorePasswordProp();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Assertions.assertEquals((Object)this.SECRET(), (Object)value);
                return;
            }
            Assertions.assertEquals((Object)props.getProperty(name), (Object)value);
        });
        ConfigRecord record2 = (ConfigRecord)((ApiMessageAndVersion)((java.util.List)batches.get(1)).get(0)).message();
        Assertions.assertEquals((byte)ConfigResource.Type.BROKER.id(), (byte)record2.resourceType());
        Assertions.assertEquals((Object)"", (Object)record2.resourceName());
        Assertions.assertEquals((Object)KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), (Object)record2.name());
        Assertions.assertEquals((Object)"3", (Object)record2.value());
        HashMap<String, String> newProps = new HashMap<String, String>();
        newProps.put(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "2");
        newProps.put(KafkaConfig$.MODULE$.SslKeystorePasswordProp(), this.NEW_SECRET());
        this.migrationState_$eq(this.migrationClient().configClient().writeConfigs(new ConfigResource(ConfigResource.Type.BROKER, "1"), newProps, this.migrationState()));
        Properties actualPropsInZk = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Broker(), "1");
        Assertions.assertEquals((int)2, (int)actualPropsInZk.size());
        actualPropsInZk.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(x0$1, x1$1) -> {
            Object object = x0$1;
            String string = KafkaConfig$.MODULE$.SslKeystorePasswordProp();
            if (!(object != null ? !object.equals(string) : string != null)) {
                Assertions.assertEquals((Object)this.NEW_SECRET(), (Object)this.encoder().decode(x1$1.toString()).value());
                return;
            }
            Assertions.assertEquals(newProps.get(x0$1), (Object)x1$1);
        }));
        this.migrationState_$eq(this.migrationClient().configClient().deleteConfigs(new ConfigResource(ConfigResource.Type.BROKER, "1"), this.migrationState()));
        Assertions.assertEquals((int)0, (int)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Broker(), "1").size());
    }

    @Test
    public void testMigrateClientQuotas() {
        Properties props = new Properties();
        props.put("producer_byte_rate", "100000");
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = ConfigType$.MODULE$.User();
        boolean x$4 = qual$1.changeConfigs$default$4();
        qual$1.changeConfigs(x$1, "<default>", props, x$4);
        AdminZkClient qual$2 = this.adminZkClient();
        String x$5 = ConfigType$.MODULE$.User();
        boolean x$8 = qual$2.changeConfigs$default$4();
        qual$2.changeConfigs(x$5, "user1", props, x$8);
        AdminZkClient qual$3 = this.adminZkClient();
        String x$9 = ConfigType$.MODULE$.User();
        boolean x$12 = qual$3.changeConfigs$default$4();
        qual$3.changeConfigs(x$9, "user1/clients/clientA", props, x$12);
        AdminZkClient qual$4 = this.adminZkClient();
        String x$13 = ConfigType$.MODULE$.User();
        boolean x$16 = qual$4.changeConfigs$default$4();
        qual$4.changeConfigs(x$13, "<default>/clients/<default>", props, x$16);
        AdminZkClient qual$5 = this.adminZkClient();
        String x$17 = ConfigType$.MODULE$.User();
        boolean x$20 = qual$5.changeConfigs$default$4();
        qual$5.changeConfigs(x$17, "<default>/clients/clientA", props, x$20);
        AdminZkClient qual$6 = this.adminZkClient();
        String x$21 = ConfigType$.MODULE$.Client();
        boolean x$24 = qual$6.changeConfigs$default$4();
        qual$6.changeConfigs(x$21, "<default>", props, x$24);
        AdminZkClient qual$7 = this.adminZkClient();
        String x$25 = ConfigType$.MODULE$.Client();
        boolean x$28 = qual$7.changeConfigs$default$4();
        qual$7.changeConfigs(x$25, "clientB", props, x$28);
        props.remove("producer_byte_rate");
        props.put("connection_creation_rate", "10");
        AdminZkClient qual$8 = this.adminZkClient();
        String x$29 = ConfigType$.MODULE$.Ip();
        boolean x$32 = qual$8.changeConfigs$default$4();
        qual$8.changeConfigs(x$29, "1.1.1.1", props, x$32);
        AdminZkClient qual$9 = this.adminZkClient();
        String x$33 = ConfigType$.MODULE$.Ip();
        boolean x$36 = qual$9.changeConfigs$default$4();
        qual$9.changeConfigs(x$33, "<default>", props, x$36);
        ArrayList batches = new ArrayList();
        this.migrationClient().migrateClientQuotas(batch -> batches.add(batch));
        Assertions.assertEquals((int)9, (int)batches.size());
        ClientQuotasDelta delta = new ClientQuotasDelta(ClientQuotasImage.EMPTY);
        RecordTestUtils.replayAllBatches((Object)delta, batches);
        ClientQuotasImage image = delta.apply();
        Assertions.assertEquals(new HashSet<ClientQuotaEntity>(Arrays.asList(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), null)}))).asJava()), new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))).asJava()), new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"clientA")}))).asJava()), new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), null)}))).asJava()), new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"clientA")}))).asJava()), new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), null)}))).asJava()), new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"clientB")}))).asJava()), new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"1.1.1.1")}))).asJava()), new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), null)}))).asJava()))), image.entities().keySet());
    }

    @Test
    public void testWriteExistingClientQuotas() {
        Properties props = new Properties();
        props.put("producer_byte_rate", "100000");
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = ConfigType$.MODULE$.User();
        boolean x$4 = qual$1.changeConfigs$default$4();
        qual$1.changeConfigs(x$1, "user1", props, x$4);
        AdminZkClient qual$2 = this.adminZkClient();
        String x$5 = ConfigType$.MODULE$.User();
        boolean x$8 = qual$2.changeConfigs$default$4();
        qual$2.changeConfigs(x$5, "user1/clients/clientA", props, x$8);
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.writeClientQuotaAndVerify(this.migrationClient(), this.adminZkClient(), this.migrationState(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))), (Map<String, Double>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)Predef$.MODULE$.double2Double(20000.0))}))), ConfigType$.MODULE$.User(), "user1"));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.writeClientQuotaAndVerify(this.migrationClient(), this.adminZkClient(), this.migrationState(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))), (Map<String, Double>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)Predef$.MODULE$.double2Double(10000.0))}))), ConfigType$.MODULE$.User(), "user1"));
        Assertions.assertEquals((int)2, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.writeClientQuotaAndVerify(this.migrationClient(), this.adminZkClient(), this.migrationState(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))), (Map<String, Double>)((Map)Map$.MODULE$.empty()), ConfigType$.MODULE$.User(), "user1"));
        Assertions.assertEquals((int)3, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.writeClientQuotaAndVerify(this.migrationClient(), this.adminZkClient(), this.migrationState(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))), (Map<String, Double>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)Predef$.MODULE$.double2Double(100.0))}))), ConfigType$.MODULE$.User(), "user1"));
        Assertions.assertEquals((int)4, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.writeClientQuotaAndVerify(this.migrationClient(), this.adminZkClient(), this.migrationState(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), null)}))), (Map<String, Double>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)Predef$.MODULE$.double2Double(200.0))}))), ConfigType$.MODULE$.User(), "<default>"));
        Assertions.assertEquals((int)5, (int)this.migrationState().migrationZkVersion());
    }

    private ZkMigrationLeadershipState writeClientQuotaAndVerify(ZkMigrationClient migrationClient, AdminZkClient adminZkClient, ZkMigrationLeadershipState migrationState, Map<String, String> entity, Map<String, Double> quotas, String zkEntityType, String zkEntityName) {
        ZkMigrationLeadershipState nextMigrationState = migrationClient.configClient().writeClientQuotas(CollectionConverters$.MODULE$.MapHasAsJava(entity).asJava(), CollectionConverters$.MODULE$.MapHasAsJava(quotas).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.empty()).asJava(), migrationState);
        Map newProps = ZkAdminManager$.MODULE$.clientQuotaPropsToDoubleMap((Map)CollectionConverters$.MODULE$.PropertiesHasAsScala(adminZkClient.fetchEntityConfig(zkEntityType, zkEntityName)).asScala());
        Assertions.assertEquals(quotas, (Object)newProps);
        return nextMigrationState;
    }

    @Test
    public void testWriteNewClientQuotas() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.writeClientQuotaAndVerify(this.migrationClient(), this.adminZkClient(), this.migrationState(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user2")}))), (Map<String, Double>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)Predef$.MODULE$.double2Double(20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)Predef$.MODULE$.double2Double(100.0))}))), ConfigType$.MODULE$.User(), "user2"));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.writeClientQuotaAndVerify(this.migrationClient(), this.adminZkClient(), this.migrationState(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"clientA")}))), (Map<String, Double>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)Predef$.MODULE$.double2Double(10000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)Predef$.MODULE$.double2Double(200.0))}))), ConfigType$.MODULE$.User(), "user2/clients/clientA"));
        Assertions.assertEquals((int)2, (int)this.migrationState().migrationZkVersion());
    }

    @Test
    public void testWriteNewTopicConfigs() {
        this.migrationState_$eq(this.migrationClient().configClient().writeConfigs(new ConfigResource(ConfigResource.Type.TOPIC, "test"), Collections.singletonMap("segment.ms", "100000"), this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        Properties newProps = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), "test");
        Assertions.assertEquals((int)1, (int)newProps.size());
        Assertions.assertEquals((Object)"100000", (Object)newProps.getProperty("segment.ms"));
    }

    @Test
    public void testWriteExistingTopicConfigs() {
        Properties props = new Properties();
        props.put("flush.ms", "60000");
        props.put("retention.ms", "300000");
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), "test", props);
        this.migrationState_$eq(this.migrationClient().configClient().writeConfigs(new ConfigResource(ConfigResource.Type.TOPIC, "test"), Collections.singletonMap("segment.ms", "100000"), this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        Properties newProps = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), "test");
        Assertions.assertEquals((int)1, (int)newProps.size());
        Assertions.assertEquals((Object)"100000", (Object)newProps.getProperty("segment.ms"));
    }

    @Test
    public void testScram() {
        MockRandom random = new MockRandom();
        ScramCredential scramCredential = new ScramCredential(this.randomBuffer(random, 1024), this.randomBuffer(random, 1024), this.randomBuffer(random, 1024), 4096);
        Properties props = new Properties();
        props.put("SCRAM-SHA-256", ScramCredentialUtils.credentialToString((ScramCredential)scramCredential));
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = ConfigType$.MODULE$.User();
        boolean x$4 = qual$1.changeConfigs$default$4();
        qual$1.changeConfigs(x$1, "alice", props, x$4);
        ArrayList brokers = new ArrayList();
        ArrayList batches = new ArrayList();
        this.migrationClient().readAllMetadata(batch -> batches.add(batch), brokerId -> brokers.add(brokerId));
        Assertions.assertEquals((int)0, (int)brokers.size());
        Assertions.assertEquals((int)1, (int)batches.size());
        Assertions.assertEquals((int)1, (int)((java.util.List)batches.get(0)).size());
    }

    @Test
    public void testScramAndQuotaChangesInSnapshot() {
        MockRandom random = new MockRandom();
        Properties props = new Properties();
        props.put("producer_byte_rate", "100000");
        AdminZkClient qual$1 = this.adminZkClient();
        String x$12 = ConfigType$.MODULE$.User();
        boolean x$4 = qual$1.changeConfigs$default$4();
        qual$1.changeConfigs(x$12, "user1", props, x$4);
        ScramCredential aliceScramCredential = new ScramCredential(this.randomBuffer(random, 1024), this.randomBuffer(random, 1024), this.randomBuffer(random, 1024), 4096);
        Properties alicePropsInit = new Properties();
        alicePropsInit.put("SCRAM-SHA-256", ScramCredentialUtils.credentialToString((ScramCredential)aliceScramCredential));
        AdminZkClient qual$2 = this.adminZkClient();
        String x$5 = ConfigType$.MODULE$.User();
        boolean x$8 = qual$2.changeConfigs$default$4();
        qual$2.changeConfigs(x$5, "alice", alicePropsInit, x$8);
        MetadataDelta delta = new MetadataDelta(MetadataImage.EMPTY);
        ClientQuotaRecord.EntityData entityData = new ClientQuotaRecord.EntityData().setEntityType("user").setEntityName("user2");
        ClientQuotaRecord clientQuotaRecord = new ClientQuotaRecord().setEntity(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)entityData, (List)Nil$.MODULE$)).asJava()).setKey("request_percentage").setValue(58.58).setRemove(false);
        delta.replay(clientQuotaRecord);
        UserScramCredentialRecord scramCredentialRecord = new UserScramCredentialRecord().setName("george").setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setSalt(this.randomBuffer(random, 1024)).setStoredKey(this.randomBuffer(random, 1024)).setServerKey(this.randomBuffer(random, 1024)).setIterations(8192);
        delta.replay(scramCredentialRecord);
        MetadataImage image = delta.apply(MetadataProvenance.EMPTY);
        new KRaftMigrationZkWriter((MigrationClient)this.migrationClient(), x$1 -> Assertions.fail((String)x$1)).handleSnapshot(image, (x$2, x$3, operation) -> this.migrationState_$eq(operation.apply(this.migrationState())));
        Properties user1Props = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.User(), "user1");
        Assertions.assertEquals((int)0, (int)user1Props.size());
        Properties user2Props = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.User(), "user2");
        Assertions.assertEquals((int)1, (int)user2Props.size());
        Properties georgeProps = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.User(), "george");
        Assertions.assertEquals((int)1, (int)georgeProps.size());
        Properties aliceProps = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.User(), "alice");
        Assertions.assertEquals((int)0, (int)aliceProps.size());
    }

    @Test
    public void testDelegationTokens() {
        String uuid = CoreUtils$.MODULE$.generateUuidAsBase64();
        KafkaPrincipal owner = SecurityUtils.parseKafkaPrincipal((String)"User:alice");
        TokenInformation tokenInfo = new TokenInformation(uuid, owner, owner, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)owner, (List)Nil$.MODULE$)).asJava(), 0L, 100L, 1000L);
        byte[] hmac = new byte[]{(byte)1, (byte)2, (byte)3, (byte)4};
        DelegationToken token = new DelegationToken(tokenInfo, hmac);
        this.zkClient().createDelegationTokenPaths();
        this.zkClient().setOrCreateDelegationToken(token);
        ArrayList brokers = new ArrayList();
        ArrayList batches = new ArrayList();
        this.migrationClient().readAllMetadata(batch -> batches.add(batch), brokerId -> brokers.add(brokerId));
        Assertions.assertEquals((int)0, (int)brokers.size());
        Assertions.assertEquals((int)1, (int)batches.size());
        Assertions.assertEquals((int)1, (int)((java.util.List)batches.get(0)).size());
    }
}

