/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsr;
import kafka.cluster.AlterPartitionListener;
import kafka.cluster.CommittedPartitionState;
import kafka.cluster.DelayedOperations;
import kafka.cluster.Partition;
import kafka.cluster.PendingShrinkIsr;
import kafka.log.LocalLog;
import kafka.log.LogLoader;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.server.AlterPartitionManager;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.MetadataCache;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.FetchParams;
import org.apache.kafka.storage.internals.log.LoadedLogOffsets;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.LogReadInfo;
import org.apache.kafka.storage.internals.log.LogSegments;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.VerificationGuard;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\t\rh\u0001\u0002\u001b6\u0001iBQa\u0012\u0001\u0005\u0002!Cqa\u0013\u0001C\u0002\u0013\u0005A\n\u0003\u0004Q\u0001\u0001\u0006I!\u0014\u0005\b#\u0002\u0011\r\u0011\"\u0001M\u0011\u0019\u0011\u0006\u0001)A\u0005\u001b\"91\u000b\u0001b\u0001\n\u0003a\u0005B\u0002+\u0001A\u0003%Q\nC\u0004V\u0001\t\u0007I\u0011\u0001,\t\r\u0011\u0004\u0001\u0015!\u0003X\u0011\u001d)\u0007A1A\u0005\u0002\u0019Daa\u001c\u0001!\u0002\u00139\u0007b\u00029\u0001\u0005\u0004%\tA\u001a\u0005\u0007c\u0002\u0001\u000b\u0011B4\t\u000fI\u0004!\u0019!C\u0001g\"11\u0010\u0001Q\u0001\nQDq\u0001 \u0001C\u0002\u0013\u0005Q\u0010C\u0004\u0002\u0004\u0001\u0001\u000b\u0011\u0002@\t\u0011\u0005\u0015\u0001A1A\u0005\u0002uDq!a\u0002\u0001A\u0003%a\u0010C\u0006\u0002\n\u0001\u0001\r\u00111A\u0005\u0002\u0005-\u0001bCA\r\u0001\u0001\u0007\t\u0019!C\u0001\u00037A1\"a\n\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u000e!Y\u0011\u0011\u0006\u0001A\u0002\u0003\u0007I\u0011AA\u0016\u0011-\t\u0019\u0004\u0001a\u0001\u0002\u0004%\t!!\u000e\t\u0017\u0005e\u0002\u00011A\u0001B\u0003&\u0011Q\u0006\u0005\n\u0003w\u0001!\u0019!C\u0005\u0003{A\u0001\"a\u0013\u0001A\u0003%\u0011q\b\u0005\b\u0003\u001b\u0002A\u0011AA(\u0011\u001d\t9\u0007\u0001C\u0001\u0003\u001fBq!!\u001d\u0001\t\u0003\ty\u0005C\u0004\u0002|\u0001!\t!a\u0014\t\u000f\u0005}\u0004\u0001\"\u0001\u0002P!9\u00111\u0011\u0001\u0005\u0002\u0005=\u0003bBAD\u0001\u0011%\u0011q\n\u0005\b\u0003\u0013\u0003A\u0011BA(\u0011\u001d\tY\t\u0001C\u0005\u0003\u001bCq!!2\u0001\t\u0013\t9\rC\u0004\u0002^\u0002!I!a8\t\u000f\t\u0015\u0001\u0001\"\u0003\u0003\b!9!1\u0002\u0001\u0005\n\t5\u0001b\u0002B\u0019\u0001\u0011%!1\u0007\u0005\b\u0005s\u0001A\u0011\u0002B\u001e\r\u0019\u00119\u0005\u0001\u0003\u0003J!Q\u00111C\u0016\u0003\u0002\u0003\u0006IAa\u0013\t\u0015\tE3F!A!\u0002\u0013\ty\u0010\u0003\u0006\u0003T-\u0012\t\u0011)A\u0005\u0005+B!Ba\u0017,\u0005\u0003\u0005\u000b\u0011\u0002B/\u00111\u00119h\u000bB\u0001B\u0003%!\u0011\u0010BB\u0011!a8F!A!\u0002\u0013q\bBB$,\t\u0003\u0011)\tC\u0004\u0003\u0018.\"\tE!'\u0003#A\u000b'\u000f^5uS>tGj\\2l)\u0016\u001cHO\u0003\u00027o\u000591\r\\;ti\u0016\u0014(\"\u0001\u001d\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001aO!\u0011\u0005qzT\"A\u001f\u000b\u0003y\nQa]2bY\u0006L!\u0001Q\u001f\u0003\r\u0005s\u0017PU3g!\t\u0011U)D\u0001D\u0015\t!u'A\u0003vi&d7/\u0003\u0002G\u0007\n9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001J!\tQ\u0005!D\u00016\u0003IqW/\u001c*fa2L7-\u0019$fi\u000eDWM]:\u0016\u00035\u0003\"\u0001\u0010(\n\u0005=k$aA%oi\u0006\u0019b.^7SKBd\u0017nY1GKR\u001c\u0007.\u001a:tA\u0005aa.^7Qe>$WoY3sg\u0006ia.^7Qe>$WoY3sg\u0002\nQC\\;n%\u0016\u001cwN\u001d3t!\u0016\u0014\bK]8ek\u000e,'/\u0001\fok6\u0014VmY8sIN\u0004VM\u001d)s_\u0012,8-\u001a:!\u0003!iwnY6US6,W#A,\u0011\u0005a\u0013W\"A-\u000b\u0005i[\u0016\u0001B;uS2T!\u0001X/\u0002\rM,'O^3s\u0015\tAdL\u0003\u0002`A\u00061\u0011\r]1dQ\u0016T\u0011!Y\u0001\u0004_J<\u0017BA2Z\u0005!iunY6US6,\u0017!C7pG.$\u0016.\\3!\u0003\u0019!X\u000e\u001d#jeV\tq\r\u0005\u0002i[6\t\u0011N\u0003\u0002kW\u0006\u0011\u0011n\u001c\u0006\u0002Y\u0006!!.\u0019<b\u0013\tq\u0017N\u0001\u0003GS2,\u0017a\u0002;na\u0012K'\u000fI\u0001\u0007Y><G)\u001b:\u0002\u000f1|w\rR5sA\u0005yQ\r_3dkR|'oU3sm&\u001cW-F\u0001u!\t)\u00180D\u0001w\u0015\t9\b0\u0001\u0006d_:\u001cWO\u001d:f]RT!AW6\n\u0005i4(aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002!\u0015DXmY;u_J\u001cVM\u001d<jG\u0016\u0004\u0013aD1qa\u0016tGmU3nCBDwN]3\u0016\u0003y\u0004\"!^@\n\u0007\u0005\u0005aOA\u0005TK6\f\u0007\u000f[8sK\u0006\u0001\u0012\r\u001d9f]\u0012\u001cV-\\1qQ>\u0014X\rI\u0001\u0013g\"\u0014\u0018N\\6JgJ\u001cV-\\1qQ>\u0014X-A\ntQJLgn[%teN+W.\u00199i_J,\u0007%\u0001\u0006m_\u001el\u0015M\\1hKJ,\"!!\u0004\u0011\t\u0005=\u0011QC\u0007\u0003\u0003#Q1!a\u00058\u0003\rawnZ\u0005\u0005\u0003/\t\tB\u0001\u0006M_\u001el\u0015M\\1hKJ\fa\u0002\\8h\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002\u001e\u0005\r\u0002c\u0001\u001f\u0002 %\u0019\u0011\u0011E\u001f\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003K)\u0012\u0011!a\u0001\u0003\u001b\t1\u0001\u001f\u00132\u0003-awnZ'b]\u0006<WM\u001d\u0011\u0002\u0013A\f'\u000f^5uS>tWCAA\u0017!\rQ\u0015qF\u0005\u0004\u0003c)$!\u0003)beRLG/[8o\u00035\u0001\u0018M\u001d;ji&|gn\u0018\u0013fcR!\u0011QDA\u001c\u0011%\t)\u0003GA\u0001\u0002\u0004\ti#\u0001\u0006qCJ$\u0018\u000e^5p]\u0002\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0006\u0002\u0002@A!\u0011\u0011IA$\u001b\t\t\u0019EC\u0002\u0002Fu\u000baaY8n[>t\u0017\u0002BA%\u0003\u0007\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bu_BL7\rU1si&$\u0018n\u001c8!\u0003\u0015\u0019X\r^+q)\t\ti\u0002K\u0002\u001d\u0003'\u0002B!!\u0016\u0002d5\u0011\u0011q\u000b\u0006\u0005\u00033\nY&A\u0002ba&TA!!\u0018\u0002`\u00059!.\u001e9ji\u0016\u0014(bAA1A\u0006)!.\u001e8ji&!\u0011QMA,\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u001aQ$a\u001b\u0011\t\u0005U\u0013QN\u0005\u0005\u0003_\n9FA\u0005BMR,'/R1dQ\u0006!C/Z:u\u001d>dunY6D_:$XM\u001c;j_:<\u0016\u000e\u001e5pkRL5O]+qI\u0006$X\rK\u0002\u001f\u0003k\u0002B!!\u0016\u0002x%!\u0011\u0011PA,\u0005\u0011!Vm\u001d;\u0002iQ,7\u000f^!qa\u0016tGMU3qY&\u001c\u0017MR3uG\"<\u0016\u000e\u001e5TG\",G-\u001e7fe\u000eCWmY6G_J\u001c\u0006N]5oW&\u001b(\u000fK\u0002 \u0003k\n1\u0005^3ti\u0006\u0003\b/\u001a8e%\u0016\u0004H.[2b\r\u0016$8\r[,ji\",\u0006\u000fZ1uK&\u001b(\u000fK\u0002!\u0003k\n\u0001\u0006^3ti\u001e+GOU3qY&\u001c\u0017mV5uQV\u0003H-\u0019;f\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001c3JgJD3!IA;\u0003\u0019\u001awN\\2veJ,g\u000e\u001e)s_\u0012,8-\u001a$fi\u000eDw+\u001b;i%\u0016\fG\rT8dW>sG._\u0001$G>t7-\u001e:sK:$\bK]8ek\u000e,g)\u001a;dQ^KG\u000f[,sSR,Gj\\2l\u0003=\u00198\r[3ek2,\u0017\t\u001d9f]\u0012\u001cHCAAH!\u0019\t\t*!)\u0002(:!\u00111SAO\u001d\u0011\t)*a'\u000e\u0005\u0005]%bAAMs\u00051AH]8pizJ\u0011AP\u0005\u0004\u0003?k\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003G\u000b)KA\u0002TKFT1!a(>a\u0011\tI+a-\u0011\u000bU\fY+a,\n\u0007\u00055fO\u0001\u0004GkR,(/\u001a\t\u0005\u0003c\u000b\u0019\f\u0004\u0001\u0005\u0017\u0005UF%!A\u0001\u0002\u000b\u0005\u0011q\u0017\u0002\u0004?\u0012\n\u0014\u0003BA]\u0003\u007f\u00032\u0001PA^\u0013\r\ti,\u0010\u0002\b\u001d>$\b.\u001b8h!\ra\u0014\u0011Y\u0005\u0004\u0003\u0007l$aA!os\u000692o\u00195fIVdWMR8mY><XM\u001d$fi\u000eDWm\u001d\u000b\u0007\u0003\u0013\f).!7\u0011\r\u0005E\u0015\u0011UAfa\u0011\ti-!5\u0011\u000bU\fY+a4\u0011\t\u0005E\u0016\u0011\u001b\u0003\f\u0003',\u0013\u0011!A\u0001\u0006\u0003\t9LA\u0002`IIBa!a6&\u0001\u0004i\u0015a\u00037fC\u0012,'/\u00129pG\"Da!a7&\u0001\u0004i\u0015A\u00038v[J+7m\u001c:eg\u0006\t2o\u00195fIVdWm\u00155sS:\\\u0017j\u001d:\u0015\r\u0005\u0005\u00181^A~a\u0011\t\u0019/a:\u0011\u000bU\fY+!:\u0011\t\u0005E\u0016q\u001d\u0003\f\u0003S4\u0013\u0011!A\u0001\u0006\u0003\t9LA\u0002`IMBq!!<'\u0001\u0004\ty/\u0001\u0006bGRLg/\u001a$mC\u001e\u0004B!!=\u0002x6\u0011\u00111\u001f\u0006\u0004\u0003k4\u0018AB1u_6L7-\u0003\u0003\u0002z\u0006M(!D!u_6L7MQ8pY\u0016\fg\u000eC\u0004\u0002~\u001a\u0002\r!a@\u0002\u001f5|7m\u001b+j[\u0016\u001cF.Z3q\u001bN\u00042\u0001\u0010B\u0001\u0013\r\u0011\u0019!\u0010\u0002\u0005\u0019>tw-A\ftKR,\b\u000fU1si&$\u0018n\u001c8XSRDWj\\2lgR!\u0011Q\u0006B\u0005\u0011\u001d\tIa\na\u0001\u0003\u001b\t1c\u0019:fCR,Gj\\4Qe>\u0004XM\u001d;jKN$BAa\u0004\u0003\u0018A!!\u0011\u0003B\n\u001b\u0005A\u0018b\u0001B\u000bq\nQ\u0001K]8qKJ$\u0018.Z:\t\u000f\te\u0001\u00061\u0001\u0003\u001c\u0005IqN^3se&$Wm\u001d\t\t\u0005;\u0011)Ca\u000b\u0003,9!!q\u0004B\u0011!\r\t)*P\u0005\u0004\u0005Gi\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0003(\t%\"aA'ba*\u0019!1E\u001f\u0011\t\tu!QF\u0005\u0005\u0005_\u0011IC\u0001\u0004TiJLgnZ\u0001\u0007CB\u0004XM\u001c3\u0015\r\u0005u!Q\u0007B\u001c\u0011\u001d\tI#\u000ba\u0001\u0003[Aa!a7*\u0001\u0004i\u0015!\u00044fi\u000eDgi\u001c7m_^,'\u000f\u0006\u0006\u0002\u001e\tu\"q\bB\"\u0005\u000bBq!!\u000b+\u0001\u0004\ti\u0003\u0003\u0004\u0003B)\u0002\r!T\u0001\u000bM>dGn\\<fe&#\u0007BBAlU\u0001\u0007Q\n\u0003\u0004\u0002\\*\u0002\r!\u0014\u0002\b'2|w\u000fT8h'\rY#1\n\t\u0005\u0003\u001f\u0011i%\u0003\u0003\u0003P\u0005E!AC+oS\u001aLW\r\u001a'pO\u0006qAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$\u0018\u0001\u00037pG\u0006dGj\\4\u0011\t\u0005=!qK\u0005\u0005\u00053\n\tB\u0001\u0005M_\u000e\fG\u000eT8h\u0003AaW-\u00193fe\u0016\u0003xn\u00195DC\u000eDW\rE\u0003=\u0005?\u0012\u0019'C\u0002\u0003bu\u0012aa\u00149uS>t\u0007\u0003\u0002B3\u0005gj!Aa\u001a\u000b\t\t%$1N\u0001\u0006KB|7\r\u001b\u0006\u0005\u0005[\u0012y'A\u0005j]R,'O\\1mg*\u0019!\u0011O/\u0002\u000fM$xN]1hK&!!Q\u000fB4\u0005QaU-\u00193fe\u0016\u0003xn\u00195GS2,7)Y2iK\u0006!\u0002O]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\u0004BAa\u001f\u0003\u00005\u0011!Q\u0010\u0006\u0005\u0003'\u0011Y'\u0003\u0003\u0003\u0002\nu$\u0001\u0006)s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'/\u0003\u0003\u0003x\t5CC\u0004BD\u0005\u0017\u0013iIa$\u0003\u0012\nM%Q\u0013\t\u0004\u0005\u0013[S\"\u0001\u0001\t\u000f\u0005M!\u00071\u0001\u0003L!9!\u0011\u000b\u001aA\u0002\u0005}\bb\u0002B*e\u0001\u0007!Q\u000b\u0005\b\u00057\u0012\u0004\u0019\u0001B/\u0011\u001d\u00119H\ra\u0001\u0005sBQ\u0001 \u001aA\u0002y\fa\"\u00199qK:$\u0017i\u001d'fC\u0012,'\u000f\u0006\b\u0003\u001c\n\u0005&\u0011\u0017BZ\u0005{\u0013YM!7\u0011\t\tm$QT\u0005\u0005\u0005?\u0013iHA\u0007M_\u001e\f\u0005\u000f]3oI&sgm\u001c\u0005\b\u0005G\u001b\u0004\u0019\u0001BS\u0003\u001d\u0011XmY8sIN\u0004BAa*\u0003.6\u0011!\u0011\u0016\u0006\u0005\u0005W\u000b\u0019%\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0005_\u0013IKA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\u0007\u0003/\u001c\u0004\u0019A'\t\u0013\tU6\u0007%AA\u0002\t]\u0016AB8sS\u001eLg\u000e\u0005\u0003\u0003|\te\u0016\u0002\u0002B^\u0005{\u0012A\"\u00119qK:$wJ]5hS:D\u0011Ba04!\u0003\u0005\rA!1\u00025%tG/\u001a:Ce>\\WM\u001d)s_R|7m\u001c7WKJ\u001c\u0018n\u001c8\u0011\t\t\r'qY\u0007\u0003\u0005\u000bT1!!\u0012\\\u0013\u0011\u0011IM!2\u0003\u001f5+G/\u00193bi\u00064VM]:j_:D\u0011B!44!\u0003\u0005\rAa4\u0002\u0019I,\u0017/^3ti2{7-\u00197\u0011\t\tE'Q[\u0007\u0003\u0005'T!\u0001X\u001c\n\t\t]'1\u001b\u0002\r%\u0016\fX/Z:u\u0019>\u001c\u0017\r\u001c\u0005\n\u00057\u001c\u0004\u0013!a\u0001\u0005;\f\u0011C^3sS\u001aL7-\u0019;j_:<U/\u0019:e!\u0011\u0011YHa8\n\t\t\u0005(Q\u0010\u0002\u0012-\u0016\u0014\u0018NZ5dCRLwN\\$vCJ$\u0007")
public class PartitionLockTest
implements Logging {
    private final int numReplicaFetchers;
    private final int numProducers;
    private final int numRecordsPerProducer;
    private final MockTime mockTime = new MockTime();
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final ExecutorService executorService = Executors.newFixedThreadPool(this.numReplicaFetchers() + this.numProducers() + 1);
    private final Semaphore appendSemaphore = new Semaphore(0);
    private final Semaphore shrinkIsrSemaphore = new Semaphore(0);
    private LogManager logManager;
    private Partition partition;
    private final TopicPartition kafka$cluster$PartitionLockTest$$topicPartition = new TopicPartition("test-topic", 0);
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int numReplicaFetchers() {
        return this.numReplicaFetchers;
    }

    public int numProducers() {
        return this.numProducers;
    }

    public int numRecordsPerProducer() {
        return this.numRecordsPerProducer;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public Semaphore appendSemaphore() {
        return this.appendSemaphore;
    }

    public Semaphore shrinkIsrSemaphore() {
        return this.shrinkIsrSemaphore;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public TopicPartition kafka$cluster$PartitionLockTest$$topicPartition() {
        return this.kafka$cluster$PartitionLockTest$$topicPartition;
    }

    @BeforeEach
    public void setUp() {
        LogConfig logConfig = new LogConfig((Map)new Properties());
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.kafka$cluster$PartitionLockTest$$topicPartition().topic(), this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty()));
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$), logConfig, configRepository, new CleanerConfig(false), this.mockTime(), MetadataVersion.latestTesting(), 4, false, (Option<UnifiedLog>)None$.MODULE$, false));
        this.partition_$eq(this.setupPartitionWithMocks(this.logManager()));
    }

    @AfterEach
    public void tearDown() {
        this.executorService().shutdownNow();
        this.logManager().liveLogDirs().foreach((Function1 & Serializable)x$1 -> {
            PartitionLockTest.$anonfun$tearDown$1(x$1);
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testNoLockContentionWithoutIsrUpdate() {
        this.concurrentProduceFetchWithReadLockOnly();
    }

    @Test
    public void testAppendReplicaFetchWithSchedulerCheckForShrinkIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        Future<?> future = this.scheduleShrinkIsr(active, 0L);
        this.concurrentProduceFetchWithReadLockOnly();
        active.set(false);
        future.get(15L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAppendReplicaFetchWithUpdateIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        Future<?> future = this.scheduleShrinkIsr(active, 10000L);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PartitionLockTest.$anonfun$testAppendReplicaFetchWithUpdateIsr$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"shrinkIsr not invoked");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.concurrentProduceFetchWithWriteLock();
        active.set(false);
        future.get(15L, TimeUnit.SECONDS);
    }

    @Test
    public void testGetReplicaWithUpdateAssignmentAndIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        int replicaToCheck = 3;
        java.util.List firstReplicaSet = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(3), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(4), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(5), (List)Nil$.MODULE$)))).asJava();
        java.util.List secondReplicaSet = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(3), (List)Nil$.MODULE$)))).asJava();
        OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
        Partition qual$1 = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$1 = PartitionLockTest.partitionState$1(secondReplicaSet);
        None$ x$3 = None$.MODULE$;
        Option x$4 = qual$1.makeLeader$default$4();
        qual$1.makeLeader(x$1, offsetCheckpoints, (Option)x$3, x$4);
        Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)new StringBuilder(31).append("Expected replica ").append(replicaToCheck).append(" to be defined").toString());
        Future<?> future = this.executorService().submit(() -> {
            int i = 0;
            while (active.get()) {
                java.util.List replicas = i % 2 == 0 ? firstReplicaSet : secondReplicaSet;
                Partition qual$2 = this.partition();
                LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$5 = PartitionLockTest.partitionState$1(replicas);
                None$ x$7 = None$.MODULE$;
                Option x$8 = qual$2.makeLeader$default$4();
                qual$2.makeLeader(x$5, offsetCheckpoints, (Option)x$7, x$8);
                ++i;
                Thread.sleep(1L);
            }
        });
        Deadline deadline = new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds().fromNow();
        while (deadline.hasTimeLeft()) {
            Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)new StringBuilder(31).append("Expected replica ").append(replicaToCheck).append(" to be defined").toString());
        }
        active.set(false);
        future.get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)new StringBuilder(31).append("Expected replica ").append(replicaToCheck).append(" to be defined").toString());
    }

    private void concurrentProduceFetchWithReadLockOnly() {
        int leaderEpoch = this.partition().getLeaderEpoch();
        scala.collection.immutable.Seq<Future<?>> appendFutures = this.scheduleAppends();
        scala.collection.immutable.Seq<Future<?>> stateUpdateFutures = this.scheduleFollowerFetches(leaderEpoch, this.numProducers() * this.numRecordsPerProducer() - 1);
        this.appendSemaphore().release(this.numProducers() * this.numRecordsPerProducer() - 1);
        stateUpdateFutures.foreach((Function1 & Serializable)x$3 -> x$3.get(15L, TimeUnit.SECONDS));
        this.appendSemaphore().release(1);
        this.scheduleFollowerFetches(leaderEpoch, 1).foreach((Function1 & Serializable)x$4 -> x$4.get(15L, TimeUnit.SECONDS));
        appendFutures.foreach((Function1 & Serializable)x$5 -> x$5.get(15L, TimeUnit.SECONDS));
    }

    private void concurrentProduceFetchWithWriteLock() {
        int leaderEpoch = this.partition().getLeaderEpoch();
        scala.collection.immutable.Seq<Future<?>> appendFutures = this.scheduleAppends();
        scala.collection.immutable.Seq<Future<?>> stateUpdateFutures = this.scheduleFollowerFetches(leaderEpoch, this.numProducers() * this.numRecordsPerProducer());
        Assertions.assertFalse((boolean)stateUpdateFutures.exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isDone())));
        this.appendSemaphore().release(this.numProducers() * this.numRecordsPerProducer());
        Assertions.assertFalse((boolean)appendFutures.exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isDone())));
        this.shrinkIsrSemaphore().release();
        stateUpdateFutures.foreach((Function1 & Serializable)x$8 -> x$8.get(15L, TimeUnit.SECONDS));
        appendFutures.foreach((Function1 & Serializable)x$9 -> x$9.get(15L, TimeUnit.SECONDS));
    }

    private scala.collection.immutable.Seq<Future<?>> scheduleAppends() {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numProducers()).map((Function1 & Serializable)x$10 -> PartitionLockTest.$anonfun$scheduleAppends$1(this, BoxesRunTime.unboxToInt((Object)x$10)));
    }

    private scala.collection.immutable.Seq<Future<?>> scheduleFollowerFetches(int leaderEpoch, int numRecords) {
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.numReplicaFetchers()).map((Function1 & Serializable)index -> PartitionLockTest.$anonfun$scheduleFollowerFetches$1(this, leaderEpoch, numRecords, BoxesRunTime.unboxToInt((Object)index)));
    }

    private Future<?> scheduleShrinkIsr(AtomicBoolean activeFlag, long mockTimeSleepMs) {
        return this.executorService().submit(() -> {
            while (activeFlag.get()) {
                if (mockTimeSleepMs > 0L) {
                    this.mockTime().sleep(mockTimeSleepMs);
                }
                this.partition().maybeShrinkIsr();
                Thread.sleep(1L);
            }
        });
    }

    private Partition setupPartitionWithMocks(LogManager logManager) {
        int leaderEpoch = 1;
        int brokerId = 0;
        AlterPartitionListener isrChangeListener = (AlterPartitionListener)Mockito.mock(AlterPartitionListener.class);
        DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
        MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
        AlterPartitionManager alterIsrManager = (AlterPartitionManager)Mockito.mock(AlterPartitionManager.class);
        logManager.startup((Set)Predef$.MODULE$.Set().empty());
        Partition partition = new Partition(this, brokerId, isrChangeListener, delayedOperations, metadataCache, logManager, alterIsrManager){
            private final /* synthetic */ PartitionLockTest $outer;

            public PendingShrinkIsr prepareIsrShrink(CommittedPartitionState currentState, scala.collection.immutable.Set<Object> outOfSyncReplicaIds) {
                PendingShrinkIsr pendingShrinkIsr;
                this.$outer.shrinkIsrSemaphore().acquire();
                try {
                    pendingShrinkIsr = super.prepareIsrShrink(currentState, outOfSyncReplicaIds);
                }
                finally {
                    this.$outer.shrinkIsrSemaphore().release();
                }
                return pendingShrinkIsr;
            }

            public UnifiedLog createLog(boolean isNew, boolean isFutureReplica, OffsetCheckpoints offsetCheckpoints, Option<Uuid> topicId, Option<Uuid> targetLogDirectoryId) {
                UnifiedLog log = super.createLog(isNew, isFutureReplica, offsetCheckpoints, (Option)None$.MODULE$, (Option)None$.MODULE$);
                LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(1);
                LogSegments segments = new LogSegments(log.topicPartition());
                Option leaderEpochCache = UnifiedLog$.MODULE$.maybeCreateLeaderEpochCache(log.dir(), log.topicPartition(), logDirFailureChannel, log.config().recordVersion(), "");
                int maxTransactionTimeout = 300000;
                ProducerStateManagerConfig producerStateManagerConfig = new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs(), false);
                ProducerStateManager producerStateManager = new ProducerStateManager(log.topicPartition(), log.dir(), maxTransactionTimeout, producerStateManagerConfig, (Time)this.$outer.mockTime());
                LoadedLogOffsets offsets = new LogLoader(log.dir(), log.topicPartition(), log.config(), (Scheduler)this.$outer.mockTime().scheduler, (Time)this.$outer.mockTime(), logDirFailureChannel, true, segments, 0L, 0L, OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(leaderEpochCache)), producerStateManager, new ConcurrentHashMap<K, V>(), false).load();
                LocalLog localLog = new LocalLog(log.dir(), log.config(), segments, offsets.recoveryPoint, offsets.nextOffsetMetadata, (Scheduler)this.$outer.mockTime().scheduler, (Time)this.$outer.mockTime(), log.topicPartition(), logDirFailureChannel);
                return new SlowLog(this.$outer, log, offsets.logStartOffset, localLog, (Option<LeaderEpochFileCache>)leaderEpochCache, producerStateManager, this.$outer.appendSemaphore());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.kafka$cluster$PartitionLockTest$$topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), MetadataVersion.latestTesting(), brokerId$1, (Function0)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final long apply() {
                        return 1L;
                    }

                    public final long apply$mcJ$sp() {
                        return 1L;
                    }
                }, (Time)$outer.mockTime(), isrChangeListener$1, delayedOperations$1, metadataCache$1, logManager$1, alterIsrManager$1);
            }
        };
        TopicIdPartition topicIdPartition = new TopicIdPartition((Uuid)partition.topicId().getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID), this.kafka$cluster$PartitionLockTest$$topicPartition());
        Mockito.when((Object)offsetCheckpoints.fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.kafka$cluster$PartitionLockTest$$topicPartition()))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)alterIsrManager.submit((TopicIdPartition)ArgumentMatchers.eq((Object)topicIdPartition), (LeaderAndIsr)ArgumentMatchers.any(), ArgumentMatchers.anyInt())).thenReturn(new CompletableFuture());
        partition.createLogIfNotExists(false, false, offsetCheckpoints, (Option)None$.MODULE$, partition.createLogIfNotExists$default$5());
        int controllerEpoch = 0;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), this.numReplicaFetchers()).map((Function1 & Serializable)i -> PartitionLockTest.$anonfun$setupPartitionWithMocks$2(brokerId, BoxesRunTime.unboxToInt((Object)i))).toList()).asJava();
        Assertions.assertTrue((boolean)partition.makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(brokerId).setLeaderEpoch(leaderEpoch).setIsr(replicas).setPartitionEpoch(1).setReplicas(replicas).setIsNew(true), offsetCheckpoints, (Option)None$.MODULE$, partition.makeLeader$default$4()), (String)"Expected become leader transition to succeed");
        return partition;
    }

    private Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(512));
        logProps.put("segment.index.bytes", Predef$.MODULE$.int2Integer(1000));
        logProps.put("retention.ms", Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return logProps.put(k, v);
            }
            throw new MatchError(null);
        });
        return logProps;
    }

    private void append(Partition partition, int numRecords) {
        RequestLocal requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable)x$11 -> PartitionLockTest.$anonfun$append$1(partition, requestLocal, BoxesRunTime.unboxToInt((Object)x$11)));
    }

    private void fetchFollower(Partition partition, int followerId, int leaderEpoch, int numRecords) {
        long logStartOffset = 0L;
        long fetchOffset = 0L;
        Optional<Object> lastFetchedEpoch = Optional.empty();
        int maxBytes = 1;
        while (fetchOffset < (long)numRecords) {
            FetchParams fetchParams = new FetchParams(ApiKeys.FETCH.latestVersion(), followerId, 1L, 0L, 1, maxBytes, FetchIsolation.LOG_END, Optional.empty());
            FetchRequest.PartitionData fetchPartitionData = new FetchRequest.PartitionData(Uuid.ZERO_UUID, fetchOffset, logStartOffset, maxBytes, Optional.of(BoxesRunTime.boxToInteger((int)leaderEpoch)), lastFetchedEpoch);
            LogReadInfo logReadInfo = partition.fetchRecords(fetchParams, fetchPartitionData, this.mockTime().milliseconds(), maxBytes, true, true);
            Assertions.assertTrue((!logReadInfo.divergingEpoch.isPresent() ? 1 : 0) != 0);
            Iterable batches = CollectionConverters$.MODULE$.IterableHasAsScala(logReadInfo.fetchedData.records.batches()).asScala();
            if (!batches.nonEmpty()) continue;
            Assertions.assertEquals((int)1, (int)batches.size());
            RecordBatch batch = (RecordBatch)batches.head();
            lastFetchedEpoch = Optional.of(BoxesRunTime.boxToInteger((int)batch.partitionLeaderEpoch()));
            fetchOffset = batch.lastOffset() + 1L;
        }
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$testAppendReplicaFetchWithUpdateIsr$1(PartitionLockTest $this) {
        return $this.shrinkIsrSemaphore().hasQueuedThreads();
    }

    public static final /* synthetic */ String $anonfun$testAppendReplicaFetchWithUpdateIsr$2() {
        return "shrinkIsr not invoked";
    }

    private static final LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState$1(java.util.List replicas) {
        return new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(1).setLeader(Predef$.MODULE$.Integer2int((Integer)replicas.get(0))).setLeaderEpoch(1).setIsr(replicas).setPartitionEpoch(1).setReplicas(replicas).setIsNew(true);
    }

    public static final /* synthetic */ Future $anonfun$scheduleAppends$1(PartitionLockTest $this, int x$10) {
        return $this.executorService().submit(() -> {
            try {
                $this.append($this.partition(), $this.numRecordsPerProducer());
                return;
            }
            catch (Throwable e) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> "Exception during append", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                throw e;
            }
        });
    }

    public static final /* synthetic */ Future $anonfun$scheduleFollowerFetches$1(PartitionLockTest $this, int leaderEpoch$1, int numRecords$1, int index) {
        return $this.executorService().submit(() -> {
            try {
                $this.fetchFollower($this.partition(), index, leaderEpoch$1, numRecords$1);
                return;
            }
            catch (Throwable e) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> "Exception during updateFollowerFetchState", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                throw e;
            }
        });
    }

    public static final /* synthetic */ Integer $anonfun$setupPartitionWithMocks$2(int brokerId$1, int i) {
        return brokerId$1 + i;
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$append$1(Partition partition$1, RequestLocal requestLocal$1, int x$11) {
        MemoryRecords batch = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1);
        return partition$1.appendRecordsToLeader(batch, AppendOrigin.CLIENT, 0, requestLocal$1, partition$1.appendRecordsToLeader$default$5());
    }

    public PartitionLockTest() {
        this.numReplicaFetchers = 2;
        this.numProducers = 3;
        this.numRecordsPerProducer = 5;
    }

    private class SlowLog
    extends UnifiedLog {
        private final Semaphore appendSemaphore;
        public final /* synthetic */ PartitionLockTest $outer;

        public LogAppendInfo appendAsLeader(MemoryRecords records, int leaderEpoch, AppendOrigin origin, MetadataVersion interBrokerProtocolVersion, RequestLocal requestLocal, VerificationGuard verificationGuard) {
            LogAppendInfo appendInfo = super.appendAsLeader(records, leaderEpoch, origin, interBrokerProtocolVersion, requestLocal, verificationGuard);
            this.appendSemaphore.acquire();
            return appendInfo;
        }

        public /* synthetic */ PartitionLockTest kafka$cluster$PartitionLockTest$SlowLog$$$outer() {
            return this.$outer;
        }

        public SlowLog(PartitionLockTest $outer, UnifiedLog log, long logStartOffset, LocalLog localLog, Option<LeaderEpochFileCache> leaderEpochCache, ProducerStateManager producerStateManager, Semaphore appendSemaphore) {
            this.appendSemaphore = appendSemaphore;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(logStartOffset, localLog, new BrokerTopicStats(Optional.empty()), log.producerIdExpirationCheckIntervalMs(), leaderEpochCache, producerStateManager, (Option)None$.MODULE$, true, false, LogOffsetsListener.NO_OP_OFFSETS_LISTENER);
        }
    }
}

