/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.BaseRequestTest;
import kafka.utils.NotNothing$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.DeleteRecordsRequestData;
import org.apache.kafka.common.message.DeleteRecordsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DeleteRecordsRequest;
import org.apache.kafka.common.requests.DeleteRecordsResponse;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0005\u0005mc\u0001B\b\u0011\u0001UAQA\u0007\u0001\u0005\u0002mAq!\b\u0001C\u0002\u0013%a\u0004\u0003\u0004&\u0001\u0001\u0006Ia\b\u0005\bM\u0001\u0011\r\u0011\"\u0003\u001f\u0011\u00199\u0003\u0001)A\u0005?!)\u0001\u0006\u0001C\u0001S!)q\u000b\u0001C\u00011\")Q\f\u0001C\u0001=\")1\r\u0001C\u0005I\")\u0011\u000f\u0001C\u0005e\")Q\u0010\u0001C\u0005}\"1Q\u0010\u0001C\u0005\u0003\u0013Aq!!\u0005\u0001\t\u0013\t\u0019\u0002C\u0004\u0002L\u0001!I!!\u0014\u00031\u0011+G.\u001a;f%\u0016\u001cwN\u001d3t%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002\u0012%\u000511/\u001a:wKJT\u0011aE\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001815\t\u0001#\u0003\u0002\u001a!\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u00029A\u0011q\u0003A\u0001\u000b)&kUiT+U?6\u001bV#A\u0010\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\u0007%sG/A\u0006U\u00136+u*\u0016+`\u001bN\u0003\u0013aH'F'N\u000bu)R*`!J{E)V\"F\t~\u0003VIU0Q\u0003J#\u0016\nV%P\u001d\u0006\u0001S*R*T\u0003\u001e+5k\u0018)S\u001f\u0012+6)\u0012#`!\u0016\u0013v\fU!S)&#\u0016j\u0014(!\u0003i!Xm\u001d;EK2,G/\u001a*fG>\u0014Hm\u001d%baBL8)Y:f)\tQS\u0006\u0005\u0002!W%\u0011A&\t\u0002\u0005+:LG\u000fC\u0003/\r\u0001\u0007q&\u0001\u0004rk>\u0014X/\u001c\t\u0003a]r!!M\u001b\u0011\u0005I\nS\"A\u001a\u000b\u0005Q\"\u0012A\u0002\u001fs_>$h(\u0003\u00027C\u00051\u0001K]3eK\u001aL!\u0001O\u001d\u0003\rM#(/\u001b8h\u0015\t1\u0014\u0005\u000b\u0003\u0007w\u001dC\u0005C\u0001\u001fF\u001b\u0005i$B\u0001 @\u0003\u0019\u0001\u0018M]1ng*\u0011\u0001)Q\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u00115)A\u0003kk:LGOC\u0001E\u0003\ry'oZ\u0005\u0003\rv\u0012\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0003%\u000b!e\u001f3jgBd\u0017-\u001f(b[\u0016lhf_1sOVlWM\u001c;t/&$\bNT1nKNl\b\u0006\u0002\u0004L#J\u0003\"\u0001T(\u000e\u00035S!AT\u001f\u0002\u0011A\u0014xN^5eKJL!\u0001U'\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\t\u0019V+I\u0001U\u0003\tQ8.I\u0001W\u0003\u0015Y'/\u00194u\u00035\"Xm\u001d;FeJ|'o\u00165f]\u0012+G.\u001a;j]\u001e\u0014VmY8sIN<\u0016\u000e\u001e5J]Z\fG.\u001b3PM\u001a\u001cX\r\u001e\u000b\u0003UeCQAL\u0004A\u0002=BCaB\u001eH\u0011\"\"qaS)]Y\t\u0019V+\u0001\u0017uKN$XI\u001d:pe^CWM\u001c#fY\u0016$\u0018N\\4SK\u000e|'\u000fZ:XSRD\u0017J\u001c<bY&$Gk\u001c9jGR\u0011!f\u0018\u0005\u0006]!\u0001\ra\f\u0015\u0005\u0011m:\u0005\n\u000b\u0003\t\u0017F\u0013GFA*V\u0003e\u0019'/Z1uKR{\u0007/[2B]\u0012\u001cVM\u001c3SK\u000e|'\u000fZ:\u0016\u0003\u0015\u0004B\u0001\t4i?%\u0011q-\t\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005%|W\"\u00016\u000b\u0005-d\u0017AB2p[6|gN\u0003\u0002\u0014[*\u0011anQ\u0001\u0007CB\f7\r[3\n\u0005AT'A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001,GJ,\u0017\r^3EK2,G/\u001a*fG>\u0014Hm\u001d*fcV,7\u000f\u001e$peR{\u0007/[2QCJ$\u0018\u000e^5p]R\u00191/_>\u0011\u0005Q<X\"A;\u000b\u0005YT\u0017\u0001\u0003:fcV,7\u000f^:\n\u0005a,(\u0001\u0006#fY\u0016$XMU3d_J$7OU3rk\u0016\u001cH\u000fC\u0003{\u0015\u0001\u0007\u0001.\u0001\bu_BL7\rU1si&$\u0018n\u001c8\t\u000bqT\u0001\u0019A\u0010\u0002\u001d=4gm]3u)>$U\r\\3uK\u0006A2/\u001a8e\t\u0016dW\r^3SK\u000e|'\u000fZ:SKF,Xm\u001d;\u0015\u0007}\f)\u0001E\u0002u\u0003\u0003I1!a\u0001v\u0005U!U\r\\3uKJ+7m\u001c:egJ+7\u000f]8og\u0016Da!a\u0002\f\u0001\u0004\u0019\u0018a\u0002:fcV,7\u000f\u001e\u000b\u0006\u007f\u0006-\u0011Q\u0002\u0005\u0007\u0003\u000fa\u0001\u0019A:\t\r\u0005=A\u00021\u0001 \u0003!aW-\u00193fe&#\u0017a\u00039s_\u0012,8-\u001a#bi\u0006$b!!\u0006\u00022\u0005\u001d\u0003CBA\f\u0003;\t\t#\u0004\u0002\u0002\u001a)\u0019\u00111D\u0011\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002 \u0005e!aA*fcB!\u00111EA\u0017\u001b\t\t)C\u0003\u0003\u0002(\u0005%\u0012\u0001\u00039s_\u0012,8-\u001a:\u000b\u0007\u0005-B.A\u0004dY&,g\u000e^:\n\t\u0005=\u0012Q\u0005\u0002\u000f%\u0016\u001cwN\u001d3NKR\fG-\u0019;b\u0011\u001d\t\u0019$\u0004a\u0001\u0003k\tq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\t\u0006\u0003o\t\t\u0005\u001b\b\u0005\u0003s\tiDD\u00023\u0003wI\u0011AI\u0005\u0004\u0003\u007f\t\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u0007\n)E\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\ty$\t\u0005\u0007\u0003\u0013j\u0001\u0019A\u0010\u0002/9,X.T3tg\u0006<Wm\u001d)feB\u000b'\u000f^5uS>t\u0017A\b<bY&$\u0017\r^3M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;G_J$v\u000e]5d)\u0015Q\u0013qJA)\u0011\u0015Qh\u00021\u0001i\u0011\u001d\t\u0019F\u0004a\u0001\u0003+\n1#\u001a=qK\u000e$X\rZ*uCJ$xJ\u001a4tKR\u00042\u0001IA,\u0013\r\tI&\t\u0002\u0005\u0019>tw\r")
public class DeleteRecordsRequestTest
extends BaseRequestTest {
    private final int TIMEOUT_MS;
    private final int MESSAGES_PRODUCED_PER_PARTITION;

    private int TIMEOUT_MS() {
        return this.TIMEOUT_MS;
    }

    private int MESSAGES_PRODUCED_PER_PARTITION() {
        return this.MESSAGES_PRODUCED_PER_PARTITION;
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteRecordsHappyCase(String quorum) {
        void var4_4;
        void var3_3;
        block3: {
            Tuple2<TopicPartition, Object> tuple2;
            block2: {
                tuple2 = this.createTopicAndSendRecords();
                if (tuple2 == null) break block2;
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                int leaderId = tuple2._2$mcI$sp();
                if (topicPartition != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        int offsetToDelete = Math.max(this.MESSAGES_PRODUCED_PER_PARTITION() - 8, 0);
        DeleteRecordsRequest request = this.createDeleteRecordsRequestForTopicPartition((TopicPartition)var3_3, offsetToDelete);
        DeleteRecordsResponseData.DeleteRecordsPartitionResult partitionResult = this.sendDeleteRecordsRequest(request, (int)var4_4).data().topics().find(var3_3.topic()).partitions().find(var3_3.partition());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionResult.errorCode(), (String)new StringBuilder(32).append("Unexpected error code received: ").append(Errors.forCode((short)partitionResult.errorCode()).name()).toString());
        Assertions.assertEquals((long)offsetToDelete, (long)partitionResult.lowWatermark(), (String)new StringBuilder(34).append("Unexpected lowWatermark received: ").append(partitionResult.lowWatermark()).toString());
        this.validateLogStartOffsetForTopic((TopicPartition)var3_3, offsetToDelete);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testErrorWhenDeletingRecordsWithInvalidOffset(String quorum) {
        void var4_4;
        void var3_3;
        block3: {
            Tuple2<TopicPartition, Object> tuple2;
            block2: {
                tuple2 = this.createTopicAndSendRecords();
                if (tuple2 == null) break block2;
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                int leaderId = tuple2._2$mcI$sp();
                if (topicPartition != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        int offsetToDelete = this.MESSAGES_PRODUCED_PER_PARTITION() + 5;
        DeleteRecordsRequest request = this.createDeleteRecordsRequestForTopicPartition((TopicPartition)var3_3, offsetToDelete);
        DeleteRecordsResponseData.DeleteRecordsPartitionResult partitionResult = this.sendDeleteRecordsRequest(request, (int)var4_4).data().topics().find(var3_3.topic()).partitions().find(var3_3.partition());
        Assertions.assertEquals((short)Errors.OFFSET_OUT_OF_RANGE.code(), (short)partitionResult.errorCode(), (String)new StringBuilder(32).append("Unexpected error code received: ").append(Errors.forCode((short)partitionResult.errorCode()).name()).toString());
        Assertions.assertEquals((long)-1L, (long)partitionResult.lowWatermark());
        this.validateLogStartOffsetForTopic((TopicPartition)var3_3, 0L);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testErrorWhenDeletingRecordsWithInvalidTopic(String quorum) {
        TopicPartition invalidTopicPartition = new TopicPartition("invalid-topic", 0);
        int offsetToDelete = 1;
        DeleteRecordsRequest request = this.createDeleteRecordsRequestForTopicPartition(invalidTopicPartition, offsetToDelete);
        DeleteRecordsResponseData.DeleteRecordsPartitionResult partitionResult = this.sendDeleteRecordsRequest(request).data().topics().find(invalidTopicPartition.topic()).partitions().find(invalidTopicPartition.partition());
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)partitionResult.errorCode(), (String)new StringBuilder(32).append("Unexpected error code received: ").append(Errors.forCode((short)partitionResult.errorCode()).name()).toString());
        Assertions.assertEquals((long)-1L, (long)partitionResult.lowWatermark());
    }

    private Tuple2<TopicPartition, Object> createTopicAndSendRecords() {
        String topic1 = "topic-1";
        TopicPartition topicPartition = new TopicPartition(topic1, 0);
        Map<Object, Object> partitionToLeader = this.createTopic(topic1, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        Assertions.assertTrue((boolean)partitionToLeader.contains((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())), (String)"Topic creation did not succeed.");
        this.produceData((Iterable<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), this.MESSAGES_PRODUCED_PER_PARTITION());
        return new Tuple2((Object)topicPartition, partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
    }

    private DeleteRecordsRequest createDeleteRecordsRequestForTopicPartition(TopicPartition topicPartition, int offsetToDelete) {
        DeleteRecordsRequestData requestData = new DeleteRecordsRequestData().setTopics(Collections.singletonList(new DeleteRecordsRequestData.DeleteRecordsTopic().setName(topicPartition.topic()).setPartitions(Collections.singletonList(new DeleteRecordsRequestData.DeleteRecordsPartition().setOffset((long)offsetToDelete).setPartitionIndex(topicPartition.partition()))))).setTimeoutMs(this.TIMEOUT_MS());
        return (DeleteRecordsRequest)new DeleteRecordsRequest.Builder(requestData).build();
    }

    private DeleteRecordsResponse sendDeleteRecordsRequest(DeleteRecordsRequest request) {
        return (DeleteRecordsResponse)this.connectAndReceive((AbstractRequest)request, this.anySocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DeleteRecordsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private DeleteRecordsResponse sendDeleteRecordsRequest(DeleteRecordsRequest request, int leaderId) {
        return (DeleteRecordsResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DeleteRecordsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private Seq<RecordMetadata> produceData(Iterable<TopicPartition> topicPartitions, int numMessagesPerPartition) {
        KafkaProducer producer = this.createProducer(new StringSerializer(), new StringSerializer(), this.createProducer$default$3());
        scala.collection.immutable.Seq sendfutureList = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)topicPartitions.toSeq().flatMap((Function1 & Serializable)tp -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessagesPerPartition).map((Function1 & Serializable)messageIndex -> DeleteRecordsRequestTest.$anonfun$produceData$2(tp, BoxesRunTime.unboxToInt((Object)messageIndex))))).map((Function1 & Serializable)x$1 -> producer.send(x$1));
        producer.flush();
        scala.collection.immutable.Seq recordMetadataList = (scala.collection.immutable.Seq)sendfutureList.map((Function1 & Serializable)x$3 -> (RecordMetadata)x$3.get(10L, TimeUnit.SECONDS));
        recordMetadataList.foreach((Function1 & Serializable)recordMetadata -> {
            DeleteRecordsRequestTest.$anonfun$produceData$5(recordMetadata);
            return BoxedUnit.UNIT;
        });
        return recordMetadataList;
    }

    private void validateLogStartOffsetForTopic(TopicPartition topicPartition, long expectedStartOffset) {
        Option logForTopicPartition = ((IterableOps)this.brokers().flatMap((Function1 & Serializable)x$4 -> {
            LogManager qual$1 = x$4.replicaManager().logManager();
            boolean x$2 = qual$1.getLog$default$2();
            return qual$1.getLog(topicPartition, x$2);
        })).headOption();
        Assertions.assertTrue((boolean)logForTopicPartition.isDefined());
        Assertions.assertEquals((long)expectedStartOffset, (long)((UnifiedLog)logForTopicPartition.get()).logStartOffset());
    }

    public static final /* synthetic */ ProducerRecord $anonfun$produceData$2(TopicPartition tp$1, int messageIndex) {
        String suffix = new StringBuilder(1).append(tp$1).append("-").append(messageIndex).toString();
        return new ProducerRecord(tp$1.topic(), Predef$.MODULE$.int2Integer(tp$1.partition()), (Object)new StringBuilder(4).append("key ").append(suffix).toString(), (Object)new StringBuilder(6).append("value ").append(suffix).toString());
    }

    public static final /* synthetic */ void $anonfun$produceData$5(RecordMetadata recordMetadata) {
        Assertions.assertTrue((recordMetadata.offset() >= 0L ? 1 : 0) != 0, (String)new StringBuilder(15).append("Invalid offset ").append(recordMetadata).toString());
    }

    public DeleteRecordsRequestTest() {
        this.TIMEOUT_MS = 1000;
        this.MESSAGES_PRODUCED_PER_PARTITION = 10;
    }
}

