/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.cluster.EndPoint;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.network.SocketServer;
import kafka.server.BadAuthorizer;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.DummyClientQuotaCallback;
import kafka.server.DummyClientQuotaCallback$;
import kafka.server.FakeConfigurableAuthorizer;
import kafka.server.FakeConfigurableAuthorizer$;
import kafka.server.HostedPartition;
import kafka.server.IntegrationTestUtils$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.testkit.BrokerNode;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import kafka.utils.Logging;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeMetadataQuorumOptions;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.QuorumInfo;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.UpdateFeaturesOptions;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.DescribeClusterRequestData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeClusterRequest;
import org.apache.kafka.common.requests.DescribeClusterResponse;
import org.apache.kafka.controller.QuorumController;
import org.apache.kafka.controller.QuorumControllerIntegrationTestUtils;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@Timeout(value=120L)
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\r%d\u0001\u0002\u001b6\u0001iBQ!\u0011\u0001\u0005\u0002\tCq!\u0012\u0001C\u0002\u0013\u0005a\t\u0003\u0004P\u0001\u0001\u0006Ia\u0012\u0005\b!\u0002\u0011\r\u0011\"\u0001G\u0011\u0019\t\u0006\u0001)A\u0005\u000f\")!\u000b\u0001C\u0001'\")!\r\u0001C\u0001'\")A\r\u0001C\u0001'\")a\r\u0001C\u0001'\")\u0001\u000e\u0001C\u0001'\")!\u000e\u0001C\u0001'\")A\u000e\u0001C\u0001'\")a\u000e\u0001C\u0001'\")\u0001\u000f\u0001C\u0001'\")!\u000f\u0001C\u0001'\")A\u000f\u0001C\u0005k\"I\u0011Q\t\u0001\u0012\u0002\u0013%\u0011q\t\u0005\b\u0003;\u0002A\u0011BA0\u0011\u001d\t\t\u000b\u0001C\u0005\u0003GCq!a2\u0001\t\u0013\tI\rC\u0004\u0002X\u0002!I!!7\t\r\u0005%\b\u0001\"\u0001T\u0011\u001d\ti\u000f\u0001C\u0005\u0003_DqAa\u0003\u0001\t\u0013\u0011i\u0001C\u0004\u0003.\u0001!IAa\f\t\u000f\t5\u0003\u0001\"\u0003\u0003P!9!q\u000f\u0001\u0005\n\te\u0004\"\u0003BI\u0001E\u0005I\u0011\u0002BJ\u0011\u0019\u00119\n\u0001C\u0001'\"1!1\u0014\u0001\u0005\u0002MCqAa(\u0001\t\u0003\u0011\t\u000b\u0003\u0004\u00034\u0002!\ta\u0015\u0005\b\u0005o\u0003A\u0011\u0002B]\u0011\u001d\u0011i\r\u0001C\u0005\u0005\u001fDqA!6\u0001\t\u0013\u00119\u000e\u0003\u0004\u0003^\u0002!\ta\u0015\u0005\b\u0005C\u0004A\u0011\u0001Br\u0011\u0019\u00119\u000f\u0001C\u0001'\"1!1\u001e\u0001\u0005\u0002MCaAa<\u0001\t\u0003\u0019\u0006B\u0002Bz\u0001\u0011\u00051\u000b\u0003\u0004\u0003x\u0002!\ta\u0015\u0005\u0007\u0005w\u0004A\u0011A*\t\u000f\t}\b\u0001\"\u0001\u0004\u0002!911\u0006\u0001\u0005\u0002\r5\u0002BBB\u001d\u0001\u0011\u00051\u000b\u0003\u0004\u0004>\u0001!\ta\u0015\u0005\u0007\u0007\u0003\u0002A\u0011A*\t\r\r\u0015\u0003\u0001\"\u0001T\u0011\u0019\u0019I\u0005\u0001C\u0001'\"11Q\n\u0001\u0005\u0002M\u0013\u0001c\u0013*bMR\u001cE.^:uKJ$Vm\u001d;\u000b\u0005Y:\u0014AB:feZ,'OC\u00019\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u001e\u0011\u0005qzT\"A\u001f\u000b\u0003y\nQa]2bY\u0006L!\u0001Q\u001f\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1\t\u0005\u0002E\u00015\tQ'A\u0002m_\u001e,\u0012a\u0012\t\u0003\u00116k\u0011!\u0013\u0006\u0003\u0015.\u000bQa\u001d7gi)T\u0011\u0001T\u0001\u0004_J<\u0017B\u0001(J\u0005\u0019aunZ4fe\u0006!An\\4!\u0003\u0011awn\u001a\u001a\u0002\u000b1|wM\r\u0011\u00023Q,7\u000f^\"sK\u0006$Xm\u00117vgR,'/\u00118e\u00072|7/\u001a\u000b\u0002)B\u0011A(V\u0005\u0003-v\u0012A!\u00168ji\"\u0012a\u0001\u0017\t\u00033\u0002l\u0011A\u0017\u0006\u00037r\u000b1!\u00199j\u0015\tif,A\u0004kkBLG/\u001a:\u000b\u0005}[\u0015!\u00026v]&$\u0018BA1[\u0005\u0011!Vm\u001d;\u0002KQ,7\u000f^\"sK\u0006$Xm\u00117vgR,'/\u00118e%\u0016\u001cH/\u0019:u\u0005J|7.\u001a:O_\u0012,\u0007FA\u0004Y\u0003%\"Xm\u001d;De\u0016\fG/Z\"mkN$XM]!oIJ+7\u000f^1si\u000e{g\u000e\u001e:pY2,'OT8eK\"\u0012\u0001\u0002W\u00010i\u0016\u001cHo\u0011:fCR,7\t\\;ti\u0016\u0014\u0018I\u001c3XC&$hi\u001c:Ce>\\WM]%o%Vtg.\u001b8h'R\fG/\u001a\u0015\u0003\u0013a\u000b\u0011\u0006^3ti\u000e\u0013X-\u0019;f\u00072,8\u000f^3s\u0003:$7I]3bi\u0016d\u0015n\u001d;EK2,G/\u001a+pa&\u001c\u0007F\u0001\u0006Y\u0003\u001d\"Xm\u001d;De\u0016\fG/Z\"mkN$XM]!oI\u000e\u0013X-\u0019;f\u0003:$W*\u00198z)>\u0004\u0018nY:)\u0005-A\u0016\u0001\u0005;fgR\u001cE.[3oiF+x\u000e^1tQ\ta\u0001,A\u0014uKN$8I]3bi\u0016\u001cE.^:uKJ<\u0016\u000e\u001e5BIZ,'\u000f^5tK\u0012\u0004vN\u001d;[KJ|\u0007FA\u0007Y\u0003\r#Xm\u001d;De\u0016\fG/Z\"mkN$XM],ji\"\fEM^3si&\u001cX\r\u001a%pgR\fe\u000e\u001a)peR$\u0015N\u001a4fe\u0016tGO\u0012:p[N{7m[3u'\u0016\u0014h/\u001a:)\u00059A\u0016a\n;fgR\u001c%/Z1uK\u000ecWo\u001d;fe&sg/\u00197jI6+G/\u00193bi\u00064VM]:j_:D#a\u0004-\u0002/\u0011|wJ\\*uCJ$X\rZ&bM.\f7\t\\;ti\u0016\u0014Hc\u0002<\u0002\u0006\u0005=\u00111\u0003\u000b\u0003)^DQ\u0001\u001f\tA\u0002e\fa!Y2uS>t\u0007\u0003\u0002\u001f{yRK!a_\u001f\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA?\u0002\u00025\taP\u0003\u0002\u0000o\u00059A/Z:uW&$\u0018bAA\u0002}\n\u00192*\u00194lC\u000ecWo\u001d;feR+7\u000f^&ji\"I\u0011q\u0001\t\u0011\u0002\u0003\u0007\u0011\u0011B\u0001\u0013]Vl7i\u001c8ue>dG.\u001a:O_\u0012,7\u000fE\u0002=\u0003\u0017I1!!\u0004>\u0005\rIe\u000e\u001e\u0005\b\u0003#\u0001\u0002\u0019AA\u0005\u00039qW/\u001c\"s_.,'OT8eKNDq!!\u0006\u0011\u0001\u0004\t9\"A\fce>\\WM\u001d)s_B,'\u000f^=Pm\u0016\u0014(/\u001b3fgBIA(!\u0007\u0002\u001e\u0005\r\u0012\u0011F\u0005\u0004\u00037i$!\u0003$v]\u000e$\u0018n\u001c83!\ri\u0018qD\u0005\u0004\u0003Cq(\u0001\u0004+fgR\\\u0015\u000e\u001e(pI\u0016\u001c\bcA?\u0002&%\u0019\u0011q\u0005@\u0003\u0015\t\u0013xn[3s\u001d>$W\r\u0005\u0005\u0002,\u0005e\u0012qHA \u001d\u0011\ti#!\u000e\u0011\u0007\u0005=R(\u0004\u0002\u00022)\u0019\u00111G\u001d\u0002\rq\u0012xn\u001c;?\u0013\r\t9$P\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0012Q\b\u0002\u0004\u001b\u0006\u0004(bAA\u001c{A!\u00111FA!\u0013\u0011\t\u0019%!\u0010\u0003\rM#(/\u001b8h\u0003\u0005\"wn\u00148Ti\u0006\u0014H/\u001a3LC\u001a\\\u0017m\u00117vgR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\tIE\u000b\u0003\u0002\n\u0005-3FAA'!\u0011\ty%!\u0017\u000e\u0005\u0005E#\u0002BA*\u0003+\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]S(\u0001\u0006b]:|G/\u0019;j_:LA!a\u0017\u0002R\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002}M,g\u000e\u001a#fg\u000e\u0014\u0018NY3DYV\u001cH/\u001a:SKF,Xm\u001d;U_\n{WO\u001c3Q_J$XK\u001c;jY\u0006cGN\u0011:pW\u0016\u00148\u000f\u0015:pa\u0006<\u0017\r^3e)\u0019\t\t'! \u0002\u000eR!\u00111MA=!\u0011\t)'!\u001e\u000e\u0005\u0005\u001d$\u0002BA5\u0003W\n\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0005\u0003[\ny'\u0001\u0004d_6lwN\u001c\u0006\u0004q\u0005E$bAA:\u0017\u00061\u0011\r]1dQ\u0016LA!a\u001e\u0002h\t9B)Z:de&\u0014Wm\u00117vgR,'OU3ta>t7/\u001a\u0005\u0007\u0003w\u0012\u00029\u0001?\u0002\u000f\rdWo\u001d;fe\"9\u0011q\u0010\nA\u0002\u0005\u0005\u0015\u0001\u00047jgR,g.\u001a:OC6,\u0007\u0003BAB\u0003\u0013k!!!\"\u000b\t\u0005\u001d\u00151N\u0001\b]\u0016$xo\u001c:l\u0013\u0011\tY)!\"\u0003\u00191K7\u000f^3oKJt\u0015-\\3\t\u000f\u0005=%\u00031\u0001\u0002\u0012\u0006Aq/Y5u)&lW\r\u0005\u0003\u0002\u0014\u0006uUBAAK\u0015\u0011\t9*!'\u0002\u0011\u0011,(/\u0019;j_:T1!a'>\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003?\u000b)J\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\u0002+]\f\u0017\u000e\u001e$peJ+hN\\5oO\n\u0013xn[3sgR1\u0011QUAa\u0003\u000b$B!a*\u0002@B1\u0011\u0011VAZ\u0003ssA!a+\u00020:!\u0011qFAW\u0013\u0005q\u0014bAAY{\u00059\u0001/Y2lC\u001e,\u0017\u0002BA[\u0003o\u00131aU3r\u0015\r\t\t,\u0010\t\u0004\t\u0006m\u0016bAA_k\ta!I]8lKJ\u001cVM\u001d<fe\"1\u00111P\nA\u0004qDq!a1\u0014\u0001\u0004\tI!A\u0003d_VtG\u000fC\u0004\u0002\u0010N\u0001\r!!%\u0002wM,g\u000e\u001a#fg\u000e\u0014\u0018NY3DYV\u001cH/\u001a:SKF,Xm\u001d;U_\n{WO\u001c3Q_J$XK\u001c;jY\n\u0013xn[3sgB\u0013x\u000e]1hCR,G\r\u0006\u0006\u0002d\u0005-\u0017qZAi\u0003+Dq!!4\u0015\u0001\u0004\tI,A\u0006eKN$\u0018N\\1uS>t\u0007bBA@)\u0001\u0007\u0011\u0011\u0011\u0005\b\u0003'$\u0002\u0019AA\u0005\u0003M)\u0007\u0010]3di\u0016$'I]8lKJ\u001cu.\u001e8u\u0011\u001d\ty\t\u0006a\u0001\u0003#\u000bQe]3oI\u0012+7o\u0019:jE\u0016\u001cE.^:uKJ\u0014V-];fgR$vNQ8v]\u0012\u0004vN\u001d;\u0015\r\u0005\r\u00141\\At\u0011\u001d\ti-\u0006a\u0001\u0003;\u0004B!a8\u0002d6\u0011\u0011\u0011\u001d\u0006\u0004\u0003\u000f;\u0014\u0002BAs\u0003C\u0014AbU8dW\u0016$8+\u001a:wKJDq!a \u0016\u0001\u0004\t\t)A\u0014uKN$8I]3bi\u0016\u001cE.^:uKJ\fe\u000e\u001a)fe\u001a|'/\u001c*fCN\u001c\u0018n\u001a8nK:$\bF\u0001\fY\u0003M\u0019\u0007.Z2l%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s)\u0015!\u0016\u0011_Az\u0011\u0019\tYh\u0006a\u0001y\"9\u0011Q_\fA\u0002\u0005]\u0018aD3ya\u0016\u001cG/\u001a3I_N$\u0018N\\4\u0011\r\u0005%\u0016\u0011`A\u007f\u0013\u0011\tY0a.\u0003\t1K7\u000f\u001e\t\by\u0005}\u0018\u0011\u0002B\u0002\u0013\r\u0011\t!\u0010\u0002\u0007)V\u0004H.\u001a\u001a\u0011\r\u0005%\u0016\u0011 B\u0003!\ra$qA\u0005\u0004\u0005\u0013i$a\u0002\"p_2,\u0017M\\\u0001\u001ciJ\fgn\u001d7bi\u0016\u0004\u0016M\u001d;ji&|g.\u00138g_R{7+Z9\u0015\t\t=!1\u0003\t\u0007\u0003S\u000b\u0019L!\u0005\u0011\r\u0005%\u00161WA\u0005\u0011\u001d\u0011)\u0002\u0007a\u0001\u0005/\t!\u0002]1si&$\u0018n\u001c8t!\u0019\u0011IBa\t\u0003&5\u0011!1\u0004\u0006\u0005\u0005;\u0011y\"\u0001\u0003vi&d'B\u0001B\u0011\u0003\u0011Q\u0017M^1\n\t\u0005m(1\u0004\t\u0005\u0005O\u0011I#\u0004\u0002\u0002l%!!1FA6\u0005I!v\u000e]5d!\u0006\u0014H/\u001b;j_:LeNZ8\u0002']\f\u0017\u000e\u001e$peR{\u0007/[2MSN$\u0018N\\4\u0015\u000fQ\u0013\tDa\u0011\u0003J!9!1G\rA\u0002\tU\u0012!B1e[&t\u0007\u0003\u0002B\u001c\u0005\u007fi!A!\u000f\u000b\t\tM\"1\b\u0006\u0005\u0005{\ty'A\u0004dY&,g\u000e^:\n\t\t\u0005#\u0011\b\u0002\u0006\u0003\u0012l\u0017N\u001c\u0005\b\u0005\u000bJ\u0002\u0019\u0001B$\u0003=)\u0007\u0010]3di\u0016$\u0007K]3tK:$\bCBAU\u0003g\u000by\u0004C\u0004\u0003Le\u0001\rAa\u0012\u0002\u001d\u0015D\b/Z2uK\u0012\f%m]3oi\u0006\u0001\u0012N\\2sK6,g\u000e^1m\u00032$XM\u001d\u000b\u0007\u0005#\u0012IFa\u0017\u0011\r\u0005%\u00161\u0017B*!\u0011\t)G!\u0016\n\t\t]\u0013q\r\u0002\t\u0003BLWI\u001d:pe\"9!1\u0007\u000eA\u0002\tU\u0002b\u0002B/5\u0001\u0007!qL\u0001\bG\"\fgnZ3t!\u0019\tI+a-\u0003bA9A(a@\u0003d\t=\u0004\u0003\u0002B3\u0005Wj!Aa\u001a\u000b\t\t%\u00141N\u0001\u0007G>tg-[4\n\t\t5$q\r\u0002\u000f\u0007>tg-[4SKN|WO]2f!\u0019\tI+a-\u0003rA!!q\u0007B:\u0013\u0011\u0011)H!\u000f\u0003\u001b\u0005cG/\u001a:D_:4\u0017nZ(q\u0003=1\u0018\r\\5eCR,7i\u001c8gS\u001e\u001cH\u0003\u0003B>\u0005\u0003\u0013\u0019I!$\u0011\u0011\u0005-\u0012\u0011\bB2\u0005{\u0002\u0002B!\u0007\u0003\u0000\u0005}\u0012qH\u0005\u0005\u0003w\u0011Y\u0002C\u0004\u00034m\u0001\rA!\u000e\t\u000f\t\u00155\u00041\u0001\u0003\b\u0006AQ\r\u001f9fGR,G\r\u0005\u0005\u0002,\u0005e\"1\rBE!\u0019\tI+a-\u0003\fB9A(a@\u0002@\u0005}\u0002\"\u0003BH7A\u0005\t\u0019\u0001B\u0003\u0003))\u0007\u0010[1vgRLg/Z\u0001\u001am\u0006d\u0017\u000eZ1uK\u000e{gNZ5hg\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u0016*\"!QAA&\u0003m!Xm\u001d;J]\u000e\u0014X-\\3oi\u0006d\u0017\t\u001c;fe\u000e{gNZ5hg\"\u0012Q\u0004W\u0001\u001bi\u0016\u001cHoU3u\u0019><GG[\"p]\u001aLw-\u001e:bi&|gn\u001d\u0015\u0003=a\u000b1\u0002\\3hC\u000eL\u0018\t\u001c;feR1!\u0011\u000bBR\u0005KCqAa\r \u0001\u0004\u0011)\u0004C\u0004\u0003(~\u0001\rA!+\u0002\u0013I,7o\\;sG\u0016\u001c\b\u0003CA\u0016\u0003s\u0011\u0019Ga+\u0011\r\u0005%\u00161\u0017BW!\u0011\u00119Da,\n\t\tE&\u0011\b\u0002\f\u0007>tg-[4F]R\u0014\u00180\u0001\fuKN$H*Z4bGf\fE\u000e^3s\u0007>tg-[4tQ\t\u0001\u0003,\u0001\u0007dYV\u001cH/\u001a:J[\u0006<W\r\u0006\u0004\u0003<\n\u001d'\u0011\u001a\t\u0005\u0005{\u0013\u0019-\u0004\u0002\u0003@*!!\u0011YA8\u0003\u0015IW.Y4f\u0013\u0011\u0011)Ma0\u0003\u0019\rcWo\u001d;fe&k\u0017mZ3\t\r\u0005m\u0014\u00051\u0001}\u0011\u001d\u0011Y-\ta\u0001\u0003\u0013\t\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u0001\u0011EJ|7.\u001a:JgVsg-\u001a8dK\u0012$bA!\u0002\u0003R\nM\u0007b\u0002BaE\u0001\u0007!1\u0018\u0005\b\u0005\u0017\u0014\u0003\u0019AA\u0005\u00039\u0011'o\\6fe&\u001b\u0018IY:f]R$bA!\u0002\u0003Z\nm\u0007b\u0002BaG\u0001\u0007!1\u0018\u0005\b\u0005\u0017\u001c\u0003\u0019AA\u0005\u0003Q!Xm\u001d;V]J,w-[:uKJ\u0014%o\\6fe\"\u0012A\u0005W\u0001\u0012GJ,\u0017\r^3BI6Lgn\u00117jK:$H\u0003\u0002B\u001b\u0005KDa!a\u001f&\u0001\u0004a\u0018A\t;fgR$Um]2sS\n,\u0017+^8sk6\u0014V-];fgR$vN\u0011:pW\u0016\u00148\u000f\u000b\u0002'1\u0006IB/Z:u+B$\u0017\r^3NKR\fG-\u0019;b-\u0016\u00148/[8oQ\t9\u0003,A\u0011uKN$(+Z7pi\u0016dunZ'b]\u0006<WM]%ogR\fg\u000e^5bi&|g\u000e\u000b\u0002)1\u0006\tB/Z:u':\f\u0007o\u001d5pi\u000e{WO\u001c;)\u0005%B\u0016!\f;fgR\fU\u000f\u001e5pe&TXM\u001d$bS2,(/\u001a$pk:$\u0017J\\\"p]R\u0014x\u000e\u001c7feN#\u0018M\u001d;va\"\u0012!\u0006W\u0001(i\u0016\u001cHoU5oO2,7i\u001c8ue>dG.\u001a:TS:<G.\u001a\"s_.,'o\u00117vgR,'\u000f\u000b\u0002,1\u0006)C/Z:u%\u0016\u001cwN\u001c4jOV\u0014XmQ8oiJ|G\u000e\\3s\u00072LWM\u001c;Rk>$\u0018m\u001d\u000b\u0004)\u000e\r\u0001bBB\u0003Y\u0001\u0007!QA\u0001\u0013G>l'-\u001b8fI\u000e{g\u000e\u001e:pY2,'\u000fK\u0002-\u0007\u0013\u0001Baa\u0003\u0004\u00125\u00111Q\u0002\u0006\u0004\u0007\u001fa\u0016A\u00029be\u0006l7/\u0003\u0003\u0004\u0014\r5!!\u0005)be\u0006lW\r^3sSj,G\rV3ti\":Afa\u0006\u0004$\r\u0015\u0002\u0003BB\r\u0007?i!aa\u0007\u000b\t\ru1QB\u0001\taJ|g/\u001b3fe&!1\u0011EB\u000e\u0005-1\u0016\r\\;f'>,(oY3\u0002\u0011\t|w\u000e\\3b]NdCaa\n\u0004*e\t\u0001!G\u0001\u0002\u0003\r\"Xm\u001d;SK\u000e|gNZ5hkJ,7i\u001c8ue>dG.\u001a:BkRDwN]5{KJ$2\u0001VB\u0018\u0011\u001d\u0019\t$\fa\u0001\u0005\u000b\tAbY8nE&tW\rZ'pI\u0016D3!LB\u0005Q\u001di3qCB\u0012\u0007oaCaa\n\u0004*\u0005YB/Z:u\u001fZ,'\u000f\\=MCJ<Wm\u0011:fCR,Gk\u001c9jGND#A\f-\u0002-Q,7\u000f\u001e+j[\u0016$w*\u001e;IK\u0006\u0014HOY3biND#a\f-\u0002CQ,7\u000f\u001e*fO&\u001cH/\u001a:fI\u000e{g\u000e\u001e:pY2,'/\u00128ea>Lg\u000e^:)\u0005AB\u0016A\u0010;fgR$\u0015N]3diR{7i\u001c8ue>dG.\u001a:D_6lWO\\5dCRLwN\u001c$bS2\u001cxJ\\(mI\u0016\u0014X*\u001a;bI\u0006$\u0018MV3sg&|g\u000e\u000b\u000221\u0006AD/Z:u'R\f'\u000f^;q/&$\bNT8o\t\u00164\u0017-\u001e7u\u0017\u000e{g\u000e\u001e:pY2,'\u000fR=oC6L7mQ8oM&<WO]1uS>t\u0007F\u0001\u001aY\u00035\"Xm\u001d;U_BL7\rR3mKR,G-\u00118e%\u0016\u001c'/Z1uK\u0012<\u0006.\u001b7f\u0005J|7.\u001a:Jg\u0012{wO\u001c\u0015\u0003gaCs\u0001AB*\u00073\u001aY\u0006E\u0002Z\u0007+J1aa\u0016[\u0005\u001d!\u0016.\\3pkR\fQA^1mk\u0016t\u0012\u0001\u001f\u0015\b\u0001\r}3\u0011LB3!\rI6\u0011M\u0005\u0004\u0007GR&a\u0001+bO\u0006\u00121qM\u0001\fS:$Xm\u001a:bi&|g\u000e")
public class KRaftClusterTest {
    private final Logger log = LoggerFactory.getLogger(KRaftClusterTest.class);
    private final Logger log2 = LoggerFactory.getLogger((String)new StringBuilder(1).append(KRaftClusterTest.class.getCanonicalName()).append("2").toString());

    public Logger log() {
        return this.log;
    }

    public Logger log2() {
        return this.log2;
    }

    @Test
    public void testCreateClusterAndClose() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
        }
    }

    @Test
    public void testCreateClusterAndRestartBrokerNode() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            BrokerServer broker = cluster.brokers().values().iterator().next();
            broker.shutdown();
            broker.startup();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndRestartControllerNode() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            ControllerServer controller = (ControllerServer)CollectionConverters$.MODULE$.IteratorHasAsScala(cluster.controllers().values().iterator()).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testCreateClusterAndRestartControllerNode$1(x$1))).next();
            int port = controller.socketServer().boundPort(((EndPoint)controller.config().controllerListeners().head()).listenerName());
            controller.shutdown();
            java.util.Map config = controller.sharedServer().controllerConfig().props();
            ((HashMap)config).put(KafkaConfig$.MODULE$.ListenersProp(), new StringBuilder(23).append("CONTROLLER://localhost:").append(port).toString());
            controller.sharedServer().controllerConfig().updateCurrentConfig(new KafkaConfig(config));
            controller.sharedServer().metrics_$eq(new Metrics());
            controller.startup();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndRestartControllerNode$2(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timeout waiting for new controller election");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndWaitForBrokerInRunningState() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndWaitForBrokerInRunningState$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndWaitForBrokerInRunningState$3(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"RaftManager was not initialized.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Assertions.assertEquals((Object)cluster.nodes().clusterId().toString(), (Object)admin.describeCluster().clusterId().get());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndCreateListDeleteTopic() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(3).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateListDeleteTopic$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateListDeleteTopic$3(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"RaftManager was not initialized.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                java.util.List<NewTopic> newTopic = Collections.singletonList(new NewTopic("test-topic", 1, (short)3));
                admin.createTopics(newTopic).all().get();
                this.waitForTopicListing(admin, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"test-topic", (List)Nil$.MODULE$), (scala.collection.immutable.Seq<String>)Nil$.MODULE$);
                admin.deleteTopics(Collections.singletonList("test-topic")).all().get();
                this.waitForTopicListing(admin, (scala.collection.immutable.Seq<String>)Nil$.MODULE$, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"test-topic", (List)Nil$.MODULE$));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndCreateAndManyTopics() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(3).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateAndManyTopics$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateAndManyTopics$3(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"RaftManager was not initialized.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                ArrayList<NewTopic> newTopic = new ArrayList<NewTopic>();
                newTopic.add(new NewTopic("test-topic-1", 2, (short)3));
                newTopic.add(new NewTopic("test-topic-2", 2, (short)3));
                newTopic.add(new NewTopic("test-topic-3", 2, (short)3));
                admin.createTopics(newTopic).all().get();
                this.waitForTopicListing(admin, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"test-topic-1", (List)new .colon.colon((Object)"test-topic-2", (List)new .colon.colon((Object)"test-topic-3", (List)Nil$.MODULE$))), (scala.collection.immutable.Seq<String>)Nil$.MODULE$);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClientQuotas() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testClientQuotas$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Object var19_19;
                Tuple2 tuple2;
                ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"testkit")}))).asJava());
                ClientQuotaFilter clientQuotaFilter = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"testkit"), (List)Nil$.MODULE$)).asJava());
                java.util.Map describeResult = KRaftClusterTest.alterThenDescribe$1(entity, (scala.collection.immutable.Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("request_percentage", Predef$.MODULE$.double2Double(0.99)), (List)Nil$.MODULE$), clientQuotaFilter, 1, admin);
                Assertions.assertEquals((double)0.99, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("request_percentage")), (double)1.0E-6);
                describeResult = KRaftClusterTest.alterThenDescribe$1(entity, (scala.collection.immutable.Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("request_percentage", Predef$.MODULE$.double2Double(0.97)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(10000.0)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(10001.0)), (List)Nil$.MODULE$))), clientQuotaFilter, 3, admin);
                Assertions.assertEquals((double)0.97, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("request_percentage")), (double)1.0E-6);
                Assertions.assertEquals((double)10000.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("producer_byte_rate")), (double)1.0E-6);
                Assertions.assertEquals((double)10001.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("consumer_byte_rate")), (double)1.0E-6);
                describeResult = KRaftClusterTest.alterThenDescribe$1(entity, (scala.collection.immutable.Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("request_percentage", Predef$.MODULE$.double2Double(0.95)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", null), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", null), (List)Nil$.MODULE$))), clientQuotaFilter, 1, admin);
                Assertions.assertEquals((double)0.95, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("request_percentage")), (double)1.0E-6);
                KRaftClusterTest.alterThenDescribe$1(entity, (scala.collection.immutable.Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("request_percentage", null), (List)Nil$.MODULE$), clientQuotaFilter, 0, admin);
                describeResult = null;
                describeResult = KRaftClusterTest.alterThenDescribe$1(entity, (scala.collection.immutable.Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(9999.0)), (List)Nil$.MODULE$), clientQuotaFilter, 1, admin);
                Assertions.assertEquals((double)9999.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("producer_byte_rate")), (double)1.0E-6);
                ClientQuotaEntity entity2 = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"testkit"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"some-client")}))).asJava());
                clientQuotaFilter = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"testkit"), (List)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"client-id", (String)"some-client"), (List)Nil$.MODULE$))).asJava());
                describeResult = KRaftClusterTest.alterThenDescribe$1(entity2, (scala.collection.immutable.Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(9998.0)), (List)Nil$.MODULE$), clientQuotaFilter, 1, admin);
                Assertions.assertEquals((double)9998.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity2)).get("producer_byte_rate")), (double)1.0E-6);
                clientQuotaFilter = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"testkit"), (List)Nil$.MODULE$)).asJava());
                long l2 = 100L;
                long tryUntilNoAssertionError_waitTime = 15000L;
                long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
                while (true) {
                    void tryUntilNoAssertionError_pause;
                    Right right;
                    try {
                        java.util.Map $anonfun$testClientQuotas$5_results = (java.util.Map)admin.describeClientQuotas(clientQuotaFilter).entities().get();
                        Assertions.assertEquals((int)2, (int)$anonfun$testClientQuotas$5_results.size(), (String)"Broker did not see two client quotas");
                        Assertions.assertEquals((double)9999.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)$anonfun$testClientQuotas$5_results.get(entity)).get("producer_byte_rate")), (double)1.0E-6);
                        Assertions.assertEquals((double)9998.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)$anonfun$testClientQuotas$5_results.get(entity2)).get("producer_byte_rate")), (double)1.0E-6);
                        Object var25_17 = null;
                        BoxedUnit $anonfun$tryUntilNoAssertionError$1_res = BoxedUnit.UNIT;
                        right = scala.package$.MODULE$.Left().apply((Object)$anonfun$tryUntilNoAssertionError$1_res);
                    }
                    catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                        right = scala.package$.MODULE$.Right().apply((Object)$anonfun$tryUntilNoAssertionError$1_ae);
                    }
                    Object var23_14 = null;
                    Object var24_15 = null;
                    Right tryUntilNoAssertionError_computeUntilTrue_result = right;
                    if (((Either)tryUntilNoAssertionError_computeUntilTrue_result).isLeft()) {
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                        break;
                    }
                    if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + tryUntilNoAssertionError_waitTime) {
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                        break;
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(tryUntilNoAssertionError_waitTime), (long)tryUntilNoAssertionError_pause));
                }
                Object var22_13 = null;
                Tuple2 tuple22 = tuple2;
                if (tuple22 == null) {
                    throw new MatchError(null);
                }
                Either tryUntilNoAssertionError_either = (Either)tuple22._1();
                tuple22._2$mcZ$sp();
                if (!(var19_19 instanceof Left)) {
                    if (var19_19 instanceof Right) {
                        throw (AssertionError)((Right)var19_19).value();
                    }
                    throw new MatchError((Object)var19_19);
                }
                ((Left)var19_19).value();
                tuple22 = null;
                var19_19 = null;
            }
        }
    }

    @Test
    public void testCreateClusterWithAdvertisedPortZero() {
        Function2 & Serializable brokerPropertyOverrides = (Function2 & Serializable)(nodes, x$4) -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)KafkaConfig$.MODULE$.ListenersProp(), (Object)new StringBuilder(14).append(nodes.externalListenerName().value()).append("://localhost:0").toString()), new Tuple2((Object)KafkaConfig$.MODULE$.AdvertisedListenersProp(), (Object)new StringBuilder(14).append(nodes.externalListenerName().value()).append("://localhost:0").toString())}));
        int x$3 = 1;
        Function1 & Serializable x$42 = (Function1 & Serializable)cluster -> {
            KRaftClusterTest.$anonfun$testCreateClusterWithAdvertisedPortZero$2(this, cluster);
            return BoxedUnit.UNIT;
        };
        this.doOnStartedKafkaCluster(x$3, 3, (Function2<TestKitNodes, BrokerNode, scala.collection.immutable.Map<String, String>>)brokerPropertyOverrides, (Function1<KafkaClusterTestKit, BoxedUnit>)x$42);
    }

    @Test
    public void testCreateClusterWithAdvertisedHostAndPortDifferentFromSocketServer() {
        Function2 & Serializable brokerPropertyOverrides = (Function2 & Serializable)(nodes, broker) -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)KafkaConfig$.MODULE$.ListenersProp(), (Object)new StringBuilder(14).append(nodes.externalListenerName().value()).append("://localhost:0").toString()), new Tuple2((Object)KafkaConfig$.MODULE$.AdvertisedListenersProp(), (Object)new StringBuilder(20).append(nodes.externalListenerName().value()).append("://advertised-host-").append(broker.id()).append(":").append(broker.id() + 100).toString())}));
        int x$3 = 1;
        Function1 & Serializable x$4 = (Function1 & Serializable)cluster -> {
            KRaftClusterTest.$anonfun$testCreateClusterWithAdvertisedHostAndPortDifferentFromSocketServer$2(this, cluster);
            return BoxedUnit.UNIT;
        };
        this.doOnStartedKafkaCluster(x$3, 3, (Function2<TestKitNodes, BrokerNode, scala.collection.immutable.Map<String, String>>)brokerPropertyOverrides, (Function1<KafkaClusterTestKit, BoxedUnit>)x$4);
    }

    @Test
    public void testCreateClusterInvalidMetadataVersion() {
        Assertions.assertEquals((Object)"Bootstrap metadata versions before 3.3-IV0 are not supported. Can't load metadata from testkit", (Object)Assertions.assertThrows(RuntimeException.class, () -> new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_2_7_IV0).setNumBrokerNodes(1).setNumControllerNodes(1).build()).build()).getMessage());
    }

    private void doOnStartedKafkaCluster(int numControllerNodes, int numBrokerNodes, Function2<TestKitNodes, BrokerNode, scala.collection.immutable.Map<String, String>> brokerPropertyOverrides, Function1<KafkaClusterTestKit, BoxedUnit> action) {
        TestKitNodes nodes = new TestKitNodes.Builder().setNumControllerNodes(numControllerNodes).setNumBrokerNodes(numBrokerNodes).build();
        nodes.brokerNodes().values().forEach(broker -> broker.propertyOverrides().putAll(CollectionConverters$.MODULE$.MapHasAsJava((Map)brokerPropertyOverrides.apply((Object)nodes, broker)).asJava()));
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(nodes).build();){
            cluster.format();
            cluster.startup();
            action.apply((Object)cluster);
        }
    }

    private int doOnStartedKafkaCluster$default$1() {
        return 1;
    }

    private DescribeClusterResponse sendDescribeClusterRequestToBoundPortUntilAllBrokersPropagated(ListenerName listenerName, FiniteDuration waitTime, KafkaClusterTestKit cluster) {
        long startTime = System.currentTimeMillis();
        scala.collection.immutable.Seq<BrokerServer> runningBrokerServers = this.waitForRunningBrokers(1, waitTime, cluster);
        FiniteDuration remainingWaitTime = waitTime.$minus(scala.concurrent.duration.package$.MODULE$.pairLongToDuration(new Tuple2((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTime)), (Object)TimeUnit.MILLISECONDS)));
        return this.sendDescribeClusterRequestToBoundPortUntilBrokersPropagated((BrokerServer)runningBrokerServers.head(), listenerName, cluster.nodes().brokerNodes().size(), remainingWaitTime);
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Seq<BrokerServer> waitForRunningBrokers(int count, FiniteDuration waitTime, KafkaClusterTestKit cluster) {
        void var5_9;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = waitTime.toMillis();
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            scala.collection.immutable.Seq computeUntilTrue_result;
            if ((computeUntilTrue_result = KRaftClusterTest.getRunningBrokerServers$1(cluster)).nonEmpty()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var12_7 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Seq runningBrokerServers = (scala.collection.immutable.Seq)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp(), (String)new StringBuilder(82).append("After ").append(waitTime.toMillis()).append(" ms at least ").append(count).append(" broker(s) should be in RUNNING state, ").append("but only ").append(var5_9.size()).append(" broker(s) are.").toString());
        return var5_9;
    }

    /*
     * WARNING - void declaration
     */
    private DescribeClusterResponse sendDescribeClusterRequestToBoundPortUntilBrokersPropagated(BrokerServer destination, ListenerName listenerName, int expectedBrokerCount, FiniteDuration waitTime) {
        void var6_10;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = waitTime.toMillis();
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            DescribeClusterResponse computeUntilTrue_result;
            if (KRaftClusterTest.$anonfun$sendDescribeClusterRequestToBoundPortUntilBrokersPropagated$2(expectedBrokerCount, computeUntilTrue_result = this.sendDescribeClusterRequestToBoundPort(destination.socketServer(), listenerName))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var13_8 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        DescribeClusterResponse describeClusterResponse = (DescribeClusterResponse)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp(), (String)new StringBuilder(62).append("After ").append(waitTime.toMillis()).append(" ms Broker is only aware of ").append(var6_10.nodes().size()).append(" brokers, ").append("but ").append(expectedBrokerCount).append(" are expected.").toString());
        return var6_10;
    }

    private DescribeClusterResponse sendDescribeClusterRequestToBoundPort(SocketServer destination, ListenerName listenerName) {
        return (DescribeClusterResponse)IntegrationTestUtils$.MODULE$.connectAndReceive(new DescribeClusterRequest.Builder(new DescribeClusterRequestData()).build(), destination, listenerName, ClassTag$.MODULE$.apply(DescribeClusterResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndPerformReassignment() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                HashMap<Integer, java.util.List<Integer>> assignments = new HashMap<Integer, java.util.List<Integer>>();
                assignments.put(Predef$.MODULE$.int2Integer(0), Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)));
                assignments.put(Predef$.MODULE$.int2Integer(1), Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)));
                assignments.put(Predef$.MODULE$.int2Integer(2), Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(0)));
                assignments.put(Predef$.MODULE$.int2Integer(3), Arrays.asList(Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1)));
                admin.createTopics(Collections.singletonList(new NewTopic("foo", assignments))).all().get();
                this.waitForTopicListing(admin, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"foo", (List)Nil$.MODULE$), (scala.collection.immutable.Seq<String>)Nil$.MODULE$);
                Assertions.assertEquals(Collections.emptyMap(), (Object)admin.listPartitionReassignments().reassignments().get());
                HashMap<TopicPartition, Optional<NewPartitionReassignment>> reassignments = new HashMap<TopicPartition, Optional<NewPartitionReassignment>>();
                reassignments.put(new TopicPartition("foo", 0), Optional.of(new NewPartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)))));
                reassignments.put(new TopicPartition("foo", 1), Optional.of(new NewPartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)))));
                reassignments.put(new TopicPartition("foo", 2), Optional.of(new NewPartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)))));
                reassignments.put(new TopicPartition("foo", 3), Optional.of(new NewPartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)))));
                admin.alterPartitionReassignments(reassignments).all().get();
                long l = 100L;
                long waitUntilTrue_waitTimeMs = 15000L;
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!KRaftClusterTest.$anonfun$testCreateClusterAndPerformReassignment$1(admin)) {
                    void waitUntilTrue_pause;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)"The reassignment never completed.");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
                scala.collection.immutable.Seq<scala.collection.immutable.Seq<Object>> seq = Nil$.MODULE$;
                .colon.colon expectedMapping = new .colon.colon((Object)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 1, 0}))), (List)new .colon.colon((Object)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), (List)new .colon.colon((Object)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3}))), (List)new .colon.colon((Object)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 0, 1}))), (List)Nil$.MODULE$))));
                long l2 = 100L;
                long waitUntilTrue_waitTimeMs2 = 15000L;
                long waitUntilTrue_startTime2 = System.currentTimeMillis();
                while (true) {
                    void waitUntilTrue_pause;
                    boolean bl;
                    java.util.Map $anonfun$testCreateClusterAndPerformReassignment$3_topicInfoMap;
                    if (($anonfun$testCreateClusterAndPerformReassignment$3_topicInfoMap = (java.util.Map)admin.describeTopics(Collections.singleton("foo")).allTopicNames().get()).containsKey("foo")) {
                        seq = this.translatePartitionInfoToSeq(((TopicDescription)$anonfun$testCreateClusterAndPerformReassignment$3_topicInfoMap.get("foo")).partitions());
                        bl = expectedMapping.equals(seq);
                    } else {
                        bl = false;
                    }
                    Object var27_13 = null;
                    if (bl) break;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                        Assertions.fail((String)new StringBuilder(72).append("Timed out waiting for replica assignments for topic foo. ").append("Wanted: ").append(expectedMapping).append(". Got: ").append(seq).toString());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
                }
                long l3 = 60000L;
                TestUtils$ retry_this = TestUtils$.MODULE$;
                long l4 = 1L;
                long retry_startTime = System.currentTimeMillis();
                while (true) {
                    try {
                        this.checkReplicaManager(cluster, (List<Tuple2<Object, List<Object>>>)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, true, false, true}))), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, true, false, true}))), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, true, true, true}))), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, false, true, true}))), (List)Nil$.MODULE$)))));
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                            Object var26_20 = null;
                            retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(l4);
                        l4 += package$.MODULE$.min(l4, 1000L);
                        continue;
                    }
                    break;
                }
                Object var20_15 = null;
                Object var25_19 = null;
            }
        }
    }

    private void checkReplicaManager(KafkaClusterTestKit cluster, List<Tuple2<Object, List<Object>>> expectedHosting) {
        expectedHosting.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$checkReplicaManager$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$9 -> {
            KRaftClusterTest.$anonfun$checkReplicaManager$2(cluster, x$9);
            return BoxedUnit.UNIT;
        });
    }

    private scala.collection.immutable.Seq<scala.collection.immutable.Seq<Object>> translatePartitionInfoToSeq(java.util.List<TopicPartitionInfo> partitions) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitions).asScala().map((Function1 & Serializable)partition -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partition.replicas()).asScala().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.id()))).toSeq())).toSeq();
    }

    /*
     * WARNING - void declaration
     */
    private void waitForTopicListing(Admin admin, scala.collection.immutable.Seq<String> expectedPresent, scala.collection.immutable.Seq<String> expectedAbsent) {
        HashSet topicsNotFound = new HashSet();
        expectedPresent.foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)topicsNotFound.add(x$1)));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            ((Iterable)admin.listTopics().names().get()).forEach(name -> topicsNotFound$1.remove(name));
            scala.collection.mutable.Set set = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)admin.listTopics().names().get()).asScala().filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)expectedAbsent$1.contains((Object)x$11)));
            if (topicsNotFound.isEmpty() && set.isEmpty()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)new StringBuilder(49).append("Failed to find topic(s): ").append(CollectionConverters$.MODULE$.SetHasAsScala(topicsNotFound).asScala()).append(" and NOT find topic(s): ").append(set).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private scala.collection.immutable.Seq<ApiError> incrementalAlter(Admin admin, scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>> changes) {
        HashMap configs = new HashMap();
        changes.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                ConfigResource resource = (ConfigResource)x0$1._1();
                scala.collection.immutable.Seq ops = (scala.collection.immutable.Seq)x0$1._2();
                return configs.put(resource, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ops).asJava());
            }
            throw new MatchError(null);
        });
        java.util.Map values = admin.incrementalAlterConfigs(configs).values();
        return (scala.collection.immutable.Seq)changes.map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                ConfigResource resource = (ConfigResource)x0$2._1();
                try {
                    ((KafkaFuture)values.get(resource)).get();
                    return ApiError.NONE;
                }
                catch (ExecutionException executionException) {
                    return ApiError.fromThrowable((Throwable)executionException.getCause());
                }
                catch (Throwable throwable) {
                    return ApiError.fromThrowable((Throwable)throwable);
                }
            }
            throw new MatchError(null);
        });
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Map<ConfigResource, java.util.Map<String, String>> validateConfigs(Admin admin, scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>> expected, boolean exhaustive) {
        scala.collection.mutable.HashMap results = new scala.collection.mutable.HashMap();
        long l = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                KRaftClusterTest.$anonfun$validateConfigs$1(this, admin, expected, results, exhaustive);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var11_11 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var5_6 = null;
        Object var10_10 = null;
        return results.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private boolean validateConfigs$default$3() {
        return false;
    }

    @Test
    public void testIncrementalAlterConfigs() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)Nil$.MODULE$), this.incrementalAlter(admin, (scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.BROKER, ""), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("log.roll.ms", "1234567"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("max.connections.per.ip", "60"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, "")), (Object)new .colon.colon((Object)new Tuple2((Object)"log.roll.ms", (Object)"1234567"), (List)new .colon.colon((Object)new Tuple2((Object)"max.connections.per.ip", (Object)"60"), (List)Nil$.MODULE$)))}))), true);
                admin.createTopics(Arrays.asList(new NewTopic("foo", 2, (short)3), new NewTopic("bar", 2, (short)3))).all().get();
                TestUtils$.MODULE$.waitForAllPartitionsMetadata(CollectionConverters$.MODULE$.CollectionHasAsScala(cluster.brokers().values()).asScala().toSeq(), "foo", 2);
                TestUtils$.MODULE$.waitForAllPartitionsMetadata(CollectionConverters$.MODULE$.CollectionHasAsScala(cluster.brokers().values()).asScala().toSeq(), "bar", 2);
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "bar")), (Object)Nil$.MODULE$)}))), false);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)new .colon.colon((Object)new ApiError(Errors.INVALID_CONFIG, "Unknown topic config name: not.a.real.topic.config"), (List)new .colon.colon((Object)new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION, "The topic 'baz' does not exist."), (List)Nil$.MODULE$))), this.incrementalAlter(admin, (scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("segment.jitter.ms", "345"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.TOPIC, "bar"), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("not.a.real.topic.config", "789"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.TOPIC, "baz"), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("segment.jitter.ms", "678"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "foo")), (Object)new .colon.colon((Object)new Tuple2((Object)"segment.jitter.ms", (Object)"345"), (List)Nil$.MODULE$))}))), false);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)Nil$.MODULE$), this.incrementalAlter(admin, (scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.BROKER, "2"), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("max.connections.per.ip", "7"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, "2")), (Object)new .colon.colon((Object)new Tuple2((Object)"max.connections.per.ip", (Object)"7"), (List)Nil$.MODULE$))}))), false);
            }
        }
    }

    @Test
    public void testSetLog4jConfigurations() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                new .colon.colon((Object)this.log(), (List)new .colon.colon((Object)this.log2(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)x$12 -> {
                    x$12.debug("setting log4j");
                    return BoxedUnit.UNIT;
                });
                ConfigResource broker2 = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "2");
                ConfigResource broker3 = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "3");
                scala.collection.immutable.Map<ConfigResource, java.util.Map<String, String>> initialLog4j = this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker2), (Object)Nil$.MODULE$)}))), false);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)new .colon.colon((Object)new ApiError(Errors.INVALID_REQUEST, "APPEND operation is not allowed for the BROKER_LOGGER resource"), (List)Nil$.MODULE$)), this.incrementalAlter(admin, (scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)broker2, (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log().getName(), "TRACE"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log2().getName(), "TRACE"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)new Tuple2((Object)broker3, (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log().getName(), "TRACE"), AlterConfigOp.OpType.APPEND), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log2().getName(), "TRACE"), AlterConfigOp.OpType.APPEND), (List)Nil$.MODULE$))), (List)Nil$.MODULE$))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker2), (Object)new .colon.colon((Object)new Tuple2((Object)this.log().getName(), (Object)"TRACE"), (List)new .colon.colon((Object)new Tuple2((Object)this.log2().getName(), (Object)"TRACE"), (List)Nil$.MODULE$)))}))), false);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)new .colon.colon((Object)new ApiError(Errors.INVALID_REQUEST, "SUBTRACT operation is not allowed for the BROKER_LOGGER resource"), (List)Nil$.MODULE$)), this.incrementalAlter(admin, (scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)broker2, (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log().getName(), ""), AlterConfigOp.OpType.DELETE), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log2().getName(), ""), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)new Tuple2((Object)broker3, (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log().getName(), "TRACE"), AlterConfigOp.OpType.SUBTRACT), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log2().getName(), "TRACE"), AlterConfigOp.OpType.SUBTRACT), (List)Nil$.MODULE$))), (List)Nil$.MODULE$))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker2), (Object)new .colon.colon((Object)new Tuple2((Object)this.log().getName(), ((java.util.Map)initialLog4j.apply((Object)broker2)).get(this.log().getName())), (List)new .colon.colon((Object)new Tuple2((Object)this.log2().getName(), ((java.util.Map)initialLog4j.apply((Object)broker2)).get(this.log2().getName())), (List)Nil$.MODULE$)))}))), false);
            }
        }
    }

    public scala.collection.immutable.Seq<ApiError> legacyAlter(Admin admin, scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<ConfigEntry>> resources) {
        HashMap configs = new HashMap();
        resources.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                ConfigResource resource = (ConfigResource)x0$1._1();
                scala.collection.immutable.Seq entries = (scala.collection.immutable.Seq)x0$1._2();
                return configs.put(resource, new Config((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)entries).asJava()));
            }
            throw new MatchError(null);
        });
        java.util.Map values = admin.alterConfigs(configs).values();
        return ((IterableOnceOps)resources.map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                ConfigResource resource = (ConfigResource)x0$2._1();
                try {
                    ((KafkaFuture)values.get(resource)).get();
                    return ApiError.NONE;
                }
                catch (ExecutionException executionException) {
                    return ApiError.fromThrowable((Throwable)executionException.getCause());
                }
                catch (Throwable throwable) {
                    return ApiError.fromThrowable((Throwable)throwable);
                }
            }
            throw new MatchError(null);
        })).toSeq();
    }

    @Test
    public void testLegacyAlterConfigs() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                ConfigResource defaultBroker = new ConfigResource(ConfigResource.Type.BROKER, "");
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)Nil$.MODULE$), this.legacyAlter(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<ConfigEntry>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultBroker), (Object)new .colon.colon((Object)new ConfigEntry("log.roll.ms", "1234567"), (List)new .colon.colon((Object)new ConfigEntry("max.connections.per.ip", "6"), (List)Nil$.MODULE$)))})))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultBroker), (Object)new .colon.colon((Object)new Tuple2((Object)"log.roll.ms", (Object)"1234567"), (List)new .colon.colon((Object)new Tuple2((Object)"max.connections.per.ip", (Object)"6"), (List)Nil$.MODULE$)))}))), true);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)Nil$.MODULE$), this.legacyAlter(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<ConfigEntry>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultBroker), (Object)new .colon.colon((Object)new ConfigEntry("log.roll.ms", "1234567"), (List)Nil$.MODULE$))})))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultBroker), (Object)new .colon.colon((Object)new Tuple2((Object)"log.roll.ms", (Object)"1234567"), (List)Nil$.MODULE$))}))), true);
                admin.createTopics(Arrays.asList(new NewTopic("foo", 2, (short)3), new NewTopic("bar", 2, (short)3))).all().get();
                TestUtils$.MODULE$.waitForAllPartitionsMetadata(CollectionConverters$.MODULE$.CollectionHasAsScala(cluster.brokers().values()).asScala().toSeq(), "foo", 2);
                TestUtils$.MODULE$.waitForAllPartitionsMetadata(CollectionConverters$.MODULE$.CollectionHasAsScala(cluster.brokers().values()).asScala().toSeq(), "bar", 2);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)new .colon.colon((Object)new ApiError(Errors.INVALID_CONFIG, "Unknown topic config name: not.a.real.topic.config"), (List)new .colon.colon((Object)new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION, "The topic 'baz' does not exist."), (List)Nil$.MODULE$))), this.legacyAlter(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<ConfigEntry>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "foo")), (Object)new .colon.colon((Object)new ConfigEntry("segment.jitter.ms", "345"), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "bar")), (Object)new .colon.colon((Object)new ConfigEntry("not.a.real.topic.config", "789"), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "baz")), (Object)new .colon.colon((Object)new ConfigEntry("segment.jitter.ms", "678"), (List)Nil$.MODULE$))})))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "foo")), (Object)new .colon.colon((Object)new Tuple2((Object)"segment.jitter.ms", (Object)"345"), (List)Nil$.MODULE$))}))), false);
            }
        }
    }

    private ClusterImage clusterImage(KafkaClusterTestKit cluster, int brokerId) {
        return cluster.brokers().get(BoxesRunTime.boxToInteger((int)brokerId)).metadataCache().currentImage().cluster();
    }

    private boolean brokerIsUnfenced(ClusterImage image, int brokerId) {
        Option option = Option$.MODULE$.apply(image.brokers().get(BoxesRunTime.boxToInteger((int)brokerId)));
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            return !((BrokerRegistration)((Some)option).value()).fenced();
        }
        throw new MatchError((Object)option);
    }

    private boolean brokerIsAbsent(ClusterImage image, int brokerId) {
        return Option$.MODULE$.apply(image.brokers().get(BoxesRunTime.boxToInteger((int)brokerId))).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnregisterBroker() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!this.brokerIsUnfenced(this.clusterImage(cluster, 1), 0)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for broker 0 to be unfenced.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            cluster.brokers().get(BoxesRunTime.boxToInteger((int)0)).shutdown();
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testUnregisterBroker$3(this, cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"Timed out waiting for broker 0 to be fenced.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.unregisterBroker(0);
            }
            long l3 = 100L;
            long waitUntilTrue_waitTimeMs3 = 15000L;
            long waitUntilTrue_startTime3 = System.currentTimeMillis();
            while (!this.brokerIsAbsent(this.clusterImage(cluster, 1), 0)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                    Assertions.fail((String)"Timed out waiting for broker 0 to be fenced.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
            }
        }
    }

    public Admin createAdminClient(KafkaClusterTestKit cluster) {
        Properties props = cluster.clientProperties();
        props.put("client.id", this.getClass().getName());
        return Admin.create((Properties)props);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeQuorumRequestToBrokers() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                long l = 100L;
                long waitUntilTrue_waitTimeMs = 15000L;
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$2(cluster, i)) {
                    void waitUntilTrue_pause;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)"Broker Never started up");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
            });
            try (Admin admin = this.createAdminClient(cluster);){
                void var7_15;
                Tuple2 tuple2;
                void var5_9;
                Tuple2 tuple22;
                QuorumInfo quorumInfo = (QuorumInfo)admin.describeMetadataQuorum(new DescribeMetadataQuorumOptions()).quorumInfo().get();
                Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsScala(cluster.controllers()).asScala().keySet(), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(quorumInfo.voters()).asScala().map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.replicaId()))).toSet());
                Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.MapHasAsScala(cluster.controllers()).asScala().keySet().contains((Object)Predef$.MODULE$.int2Integer(quorumInfo.leaderId())), (String)new StringBuilder(35).append("Leader ID ").append(quorumInfo.leaderId()).append(" was not a controller ID.").toString());
                long l = 100L;
                long computeUntilTrue_waitTime = 15000L;
                long computeUntilTrue_startTime = System.currentTimeMillis();
                while (true) {
                    void computeUntilTrue_pause;
                    java.util.List computeUntilTrue_result;
                    if (KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$6(computeUntilTrue_result = KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$5(admin))) {
                        tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                        break;
                    }
                    if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                        tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                        break;
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
                }
                Object var16_7 = null;
                Tuple2 tuple23 = tuple22;
                if (tuple23 == null) {
                    throw new MatchError(null);
                }
                java.util.List voters = (java.util.List)tuple23._1();
                Assertions.assertTrue((boolean)tuple23._2$mcZ$sp(), (String)new StringBuilder(111).append("At least one voter did not return the expected state within timeout.").append("The responses gathered for all the voters: ").append(var5_9.toString()).toString());
                long l2 = 100L;
                long computeUntilTrue_waitTime2 = 15000L;
                long computeUntilTrue_startTime2 = System.currentTimeMillis();
                while (true) {
                    void computeUntilTrue_pause;
                    java.util.List computeUntilTrue_result;
                    if (KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$9(cluster, computeUntilTrue_result = KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$8(admin))) {
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                        break;
                    }
                    if (System.currentTimeMillis() > computeUntilTrue_startTime2 + computeUntilTrue_waitTime2) {
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                        break;
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime2), (long)computeUntilTrue_pause));
                }
                Object var23_13 = null;
                Tuple2 tuple24 = tuple2;
                if (tuple24 == null) {
                    throw new MatchError(null);
                }
                java.util.List observers = (java.util.List)tuple24._1();
                Assertions.assertTrue((boolean)tuple24._2$mcZ$sp(), (String)new StringBuilder(117).append("At least one observer did not return the expected state within timeout.").append("The responses gathered for all the observers: ").append(var7_15.toString()).toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUpdateMetadataVersion() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.MINIMUM_BOOTSTRAP_VERSION).setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.updateFeatures(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.version"), (Object)new FeatureUpdate(MetadataVersion.latestTesting().featureLevel(), FeatureUpdate.UpgradeType.UPGRADE))}))).asJava(), new UpdateFeaturesOptions());
            }
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testUpdateMetadataVersion$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for metadata version update.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
    }

    @Test
    public void testRemoteLogManagerInstantiation() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).setConfigProp("remote.log.storage.system.enable", Boolean.toString(true)).setConfigProp("remote.log.metadata.manager.class.name", "org.apache.kafka.server.log.remote.storage.NoOpRemoteLogMetadataManager").setConfigProp("remote.log.storage.manager.class.name", "org.apache.kafka.server.log.remote.storage.NoOpRemoteStorageManager").build();){
            cluster.format();
            cluster.startup();
            cluster.brokers().forEach((x$17, server) -> {
                Option option = server.remoteLogManagerOpt();
                if (option instanceof Some) {
                    return;
                }
                if (None$.MODULE$.equals(option)) {
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"RemoteLogManager should be initialized");
                    return;
                }
                throw new MatchError((Object)option);
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSnapshotCount() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp("metadata.log.max.snapshot.interval.ms", "500").setConfigProp("metadata.max.idle.interval.ms", "50").build();){
            cluster.format();
            cluster.startup();
            Path metaLog = FileSystems.getDefault().getPath(cluster.controllers().get(BoxesRunTime.boxToInteger((int)3000)).config().metadataLogDir(), "__cluster_metadata-0");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testSnapshotCount$2(metaLog)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Failed to see at least one snapshot");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Thread.sleep(5000L);
            long countAfterTenIntervals = KRaftClusterTest.snapshotCounter$1(metaLog);
            Assertions.assertTrue((countAfterTenIntervals > 1L ? 1 : 0) != 0, (String)new StringBuilder(48).append("Expected to see at least one more snapshot, saw ").append(countAfterTenIntervals).toString());
            Assertions.assertTrue((countAfterTenIntervals < 20L ? 1 : 0) != 0, (String)new StringBuilder(83).append("Did not expect to see more than twice as many snapshots as snapshot intervals, saw ").append(countAfterTenIntervals).toString());
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testSnapshotCount$4(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"Failed to see latestSnapshotGeneratedBytes > 0");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
        }
    }

    @Test
    public void testAuthorizerFailureFoundInControllerStartup() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumControllerNodes(3).build()).setConfigProp("authorizer.class.name", BadAuthorizer.class.getName()).build();){
            cluster.format();
            ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> cluster.startup());
            Assertions.assertEquals((Object)"java.lang.IllegalStateException: test authorizer exception", (Object)exception.getMessage());
            cluster.fatalFaultHandler().setIgnore(true);
        }
    }

    @Test
    public void testSingleControllerSingleBrokerCluster() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.MINIMUM_BOOTSTRAP_VERSION).setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testReconfigureControllerClientQuotas(boolean combinedController) {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setCombined(combinedController).setNumControllerNodes(1).build()).setConfigProp("client.quota.callback.class", DummyClientQuotaCallback.class.getName()).setConfigProp(DummyClientQuotaCallback$.MODULE$.dummyClientQuotaCallbackValueConfigKey(), "0").build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            KRaftClusterTest.assertConfigValue$1(0, cluster);
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Collections.singletonList(new AlterConfigOp(new ConfigEntry(DummyClientQuotaCallback$.MODULE$.dummyClientQuotaCallbackValueConfigKey(), "1"), AlterConfigOp.OpType.SET)))).all().get();
            }
            KRaftClusterTest.assertConfigValue$1(1, cluster);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testReconfigureControllerAuthorizer(boolean combinedMode) {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setCombined(combinedMode).setNumControllerNodes(1).build()).setConfigProp("authorizer.class.name", FakeConfigurableAuthorizer.class.getName()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            KRaftClusterTest.assertFoobarValue$1(0, cluster);
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Collections.singletonList(new AlterConfigOp(new ConfigEntry(FakeConfigurableAuthorizer$.MODULE$.foobarConfigKey(), "123"), AlterConfigOp.OpType.SET)))).all().get();
            }
            KRaftClusterTest.assertFoobarValue$1(123, cluster);
        }
    }

    @Test
    public void testOverlyLargeCreateTopics() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                ArrayList newTopics = new ArrayList();
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 10000).foreach((Function1)(JFunction1.mcZI.sp & Serializable)i -> newTopics.add(new NewTopic(new StringBuilder(3).append("foo").append(i).toString(), 100000, (short)1)));
                ExecutionException executionException = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> admin.createTopics((Collection)newTopics).all().get());
                Assertions.assertNotNull((Object)executionException.getCause());
                Assertions.assertEquals(PolicyViolationException.class, executionException.getCause().getClass());
                Assertions.assertEquals((Object)"Unable to perform excessively large batch operation.", (Object)executionException.getCause().getMessage());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTimedOutHeartbeats() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(3).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.BrokerHeartbeatIntervalMsProp(), Integer.toString(10)).setConfigProp(KafkaConfig$.MODULE$.BrokerSessionTimeoutMsProp(), Integer.toString(1000)).build();){
            cluster.format();
            cluster.startup();
            ControllerServer controller = cluster.controllers().values().iterator().next();
            controller.controller().waitForReadyBrokers(3).get();
            long l = 60000L;
            TestUtils$ retry_this = TestUtils$.MODULE$;
            long l2 = 1L;
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    KRaftClusterTest.$anonfun$testTimedOutHeartbeats$1(controller);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                        Object var10_9 = null;
                        retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(l2);
                    l2 += package$.MODULE$.min(l2, 1000L);
                    continue;
                }
                break;
            }
            Object var4_4 = null;
            Object var9_8 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRegisteredControllerEndpoints() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            long l = 60000L;
            TestUtils$ retry_this = TestUtils$.MODULE$;
            long l2 = 1L;
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    KRaftClusterTest.$anonfun$testRegisteredControllerEndpoints$1(cluster);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                        Object var9_8 = null;
                        retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(l2);
                    l2 += package$.MODULE$.min(l2, 1000L);
                    continue;
                }
                break;
            }
            Object var3_3 = null;
            Object var8_7 = null;
        }
    }

    @Test
    public void testDirectToControllerCommunicationFailsOnOlderMetadataVersion() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_6_IV2).setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            try (Admin admin = Admin.create((Properties)cluster.newClientPropertiesBuilder().setUsingBootstrapControllers(true).build());){
                ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> admin.describeCluster().clusterId().get(1L, TimeUnit.MINUTES));
                Assertions.assertNotNull((Object)exception.getCause());
                Assertions.assertEquals(UnsupportedVersionException.class, exception.getCause().getClass());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testStartupWithNonDefaultKControllerDynamicConfiguration() {
        java.util.List<ApiMessageAndVersion> bootstrapRecords = Arrays.asList(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(MetadataVersion.IBP_3_7_IV0.featureLevel()), (short)0), new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("").setName("num.io.threads").setValue("9"), (short)0));
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadata(BootstrapMetadata.fromRecords(bootstrapRecords, (String)"testRecords")).setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            ControllerServer controller = cluster.controllers().values().iterator().next();
            long l = 60000L;
            TestUtils$ retry_this = TestUtils$.MODULE$;
            long l2 = 1L;
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    KRaftClusterTest.$anonfun$testStartupWithNonDefaultKControllerDynamicConfiguration$1(controller);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                        Object var11_10 = null;
                        retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(l2);
                    l2 += package$.MODULE$.min(l2, 1000L);
                    continue;
                }
                break;
            }
            Object var5_5 = null;
            Object var10_9 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicDeletedAndRecreatedWhileBrokerIsDown() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_6_IV2).setNumBrokerNodes(3).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                BrokerServer broker0 = cluster.brokers().get(BoxesRunTime.boxToInteger((int)0));
                BrokerServer broker1 = cluster.brokers().get(BoxesRunTime.boxToInteger((int)1));
                TopicPartition foo0 = new TopicPartition("foo", 0);
                admin.createTopics(Arrays.asList(new NewTopic("foo", 3, (short)3))).all().get();
                long l = 60000L;
                TestUtils$ retry_this = TestUtils$.MODULE$;
                long l2 = 1L;
                long retry_startTime = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testTopicDeletedAndRecreatedWhileBrokerIsDown$1(broker0, foo0);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                            Object var29_12 = null;
                            retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(l2);
                        l2 += package$.MODULE$.min(l2, 1000L);
                        continue;
                    }
                    break;
                }
                Object var11_7 = null;
                Object var16_11 = null;
                broker0.shutdown();
                long l3 = 60000L;
                TestUtils$ retry_this2 = TestUtils$.MODULE$;
                long l4 = 1L;
                long retry_startTime2 = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testTopicDeletedAndRecreatedWhileBrokerIsDown$2(broker1);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this2.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                            Object var30_19 = null;
                            retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(l4);
                        l4 += package$.MODULE$.min(l4, 1000L);
                        continue;
                    }
                    break;
                }
                Object var17_14 = null;
                Object var22_18 = null;
                LogManager qual$2 = broker0.logManager();
                boolean x$4 = qual$2.getLog$default$2();
                File logDir = ((UnifiedLog)qual$2.getLog(foo0, x$4).get()).dir();
                Files.write(new File(logDir, "partition.metadata").toPath(), "version: 0\ntopic_id: AAAAAAAAAAAAA7SrBWaJ7g\n".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                broker0.startup();
                long l5 = 60000L;
                TestUtils$ retry_this3 = TestUtils$.MODULE$;
                long l6 = 1L;
                long retry_startTime3 = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testTopicDeletedAndRecreatedWhileBrokerIsDown$3(broker1);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this3.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l6).append(", and then retrying.").toString();
                            Object var31_29 = null;
                            retry_this3.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this3, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(l6);
                        l6 += package$.MODULE$.min(l6, 1000L);
                        continue;
                    }
                    break;
                }
                Object var23_24 = null;
                Object var28_28 = null;
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndRestartControllerNode$1(ControllerServer x$1) {
        return x$1.controller().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndRestartControllerNode$3(ControllerServer x$2) {
        return x$2.controller().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndRestartControllerNode$2(KafkaClusterTestKit cluster$1) {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(cluster$1.controllers().values().iterator()).asScala().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testCreateClusterAndRestartControllerNode$3(x$2)));
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndRestartControllerNode$4() {
        return "Timeout waiting for new controller election";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndWaitForBrokerInRunningState$1(KafkaClusterTestKit cluster$2) {
        BrokerState brokerState = cluster$2.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndWaitForBrokerInRunningState$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndWaitForBrokerInRunningState$3(KafkaClusterTestKit cluster$2) {
        return cluster$2.raftManagers().get(BoxesRunTime.boxToInteger((int)0)).client().leaderAndEpoch().leaderId().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndWaitForBrokerInRunningState$4() {
        return "RaftManager was not initialized.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateListDeleteTopic$1(KafkaClusterTestKit cluster$3) {
        BrokerState brokerState = cluster$3.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateListDeleteTopic$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateListDeleteTopic$3(KafkaClusterTestKit cluster$3) {
        return cluster$3.raftManagers().get(BoxesRunTime.boxToInteger((int)0)).client().leaderAndEpoch().leaderId().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateListDeleteTopic$4() {
        return "RaftManager was not initialized.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateAndManyTopics$1(KafkaClusterTestKit cluster$4) {
        BrokerState brokerState = cluster$4.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateAndManyTopics$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateAndManyTopics$3(KafkaClusterTestKit cluster$4) {
        return cluster$4.raftManagers().get(BoxesRunTime.boxToInteger((int)0)).client().leaderAndEpoch().leaderId().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateAndManyTopics$4() {
        return "RaftManager was not initialized.";
    }

    public static final /* synthetic */ boolean $anonfun$testClientQuotas$1(KafkaClusterTestKit cluster$5) {
        BrokerState brokerState = cluster$5.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testClientQuotas$2() {
        return "Broker never made it to RUNNING state.";
    }

    private static final java.util.Map describeOrFail$1(ClientQuotaFilter filter, Admin admin$1) {
        try {
            return (java.util.Map)admin$1.describeClientQuotas(filter).entities().get();
        }
        catch (Throwable t) {
            return (java.util.Map)Assertions.fail((String)"DescribeClientQuotas request failed", (Throwable)t);
        }
    }

    public static final /* synthetic */ java.util.Map $anonfun$testClientQuotas$3(ClientQuotaFilter filter$1, Admin admin$1) {
        return KRaftClusterTest.describeOrFail$1(filter$1, admin$1);
    }

    public static final /* synthetic */ boolean $anonfun$testClientQuotas$4(ClientQuotaEntity entity$1, int expectCount$1, java.util.Map results) {
        return results.getOrDefault(entity$1, Collections.emptyMap()).size() == expectCount$1;
    }

    /*
     * WARNING - void declaration
     */
    private static final java.util.Map alterThenDescribe$1(ClientQuotaEntity entity, scala.collection.immutable.Seq quotas, ClientQuotaFilter filter, int expectCount, Admin admin$1) {
        void var7_11;
        Tuple2 tuple2;
        try {
            admin$1.alterClientQuotas((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration(entity, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)quotas).asJava()), (List)Nil$.MODULE$)).asJava()).all().get();
        }
        catch (Throwable t) {
            Assertions.fail((String)"AlterClientQuotas request failed", (Throwable)t);
        }
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            java.util.Map computeUntilTrue_result;
            if (KRaftClusterTest.$anonfun$testClientQuotas$4(entity, expectCount, computeUntilTrue_result = KRaftClusterTest.describeOrFail$1(filter, admin$1))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var14_9 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        java.util.Map describeResult = (java.util.Map)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp(), (String)"Broker never saw new client quotas");
        return var7_11;
    }

    public static final /* synthetic */ void $anonfun$testClientQuotas$5(Admin admin$1, ObjectRef filter$2, ClientQuotaEntity entity$2, ClientQuotaEntity entity2$1) {
        java.util.Map results = (java.util.Map)admin$1.describeClientQuotas((ClientQuotaFilter)filter$2.elem).entities().get();
        Assertions.assertEquals((int)2, (int)results.size(), (String)"Broker did not see two client quotas");
        Assertions.assertEquals((double)9999.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)results.get(entity$2)).get("producer_byte_rate")), (double)1.0E-6);
        Assertions.assertEquals((double)9998.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)results.get(entity2$1)).get("producer_byte_rate")), (double)1.0E-6);
    }

    public static final /* synthetic */ void $anonfun$testCreateClusterWithAdvertisedPortZero$2(KRaftClusterTest $this, KafkaClusterTestKit cluster) {
        $this.sendDescribeClusterRequestToBoundPortUntilAllBrokersPropagated(cluster.nodes().externalListenerName(), scala.concurrent.duration.package$.MODULE$.pairLongToDuration(new Tuple2((Object)BoxesRunTime.boxToLong((long)15L), (Object)TimeUnit.SECONDS)), cluster).nodes().values().forEach(broker -> {
            Assertions.assertEquals((Object)"localhost", (Object)broker.host(), (String)"Did not advertise configured advertised host");
            Assertions.assertEquals((int)cluster.brokers().get(BoxesRunTime.boxToInteger((int)broker.id())).socketServer().boundPort(cluster.nodes().externalListenerName()), (int)broker.port(), (String)"Did not advertise bound socket port");
        });
    }

    public static final /* synthetic */ void $anonfun$testCreateClusterWithAdvertisedHostAndPortDifferentFromSocketServer$2(KRaftClusterTest $this, KafkaClusterTestKit cluster) {
        $this.sendDescribeClusterRequestToBoundPortUntilAllBrokersPropagated(cluster.nodes().externalListenerName(), scala.concurrent.duration.package$.MODULE$.pairLongToDuration(new Tuple2((Object)BoxesRunTime.boxToLong((long)15L), (Object)TimeUnit.SECONDS)), cluster).nodes().values().forEach(broker -> {
            Assertions.assertEquals((Object)new StringBuilder(16).append("advertised-host-").append(broker.id()).toString(), (Object)broker.host(), (String)"Did not advertise configured advertised host");
            Assertions.assertEquals((int)(broker.id() + 100), (int)broker.port(), (String)"Did not advertise configured advertised port");
        });
    }

    public static final /* synthetic */ boolean $anonfun$waitForRunningBrokers$1(BrokerServer brokerServer) {
        BrokerState brokerState = brokerServer.brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    private static final scala.collection.immutable.Seq getRunningBrokerServers$1(KafkaClusterTestKit cluster$7) {
        return (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.CollectionHasAsScala(cluster$7.brokers().values()).asScala().toSeq().filter((Function1 & Serializable)brokerServer -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$waitForRunningBrokers$1(brokerServer)));
    }

    public static final /* synthetic */ scala.collection.immutable.Seq $anonfun$waitForRunningBrokers$2(KafkaClusterTestKit cluster$7) {
        return KRaftClusterTest.getRunningBrokerServers$1(cluster$7);
    }

    public static final /* synthetic */ boolean $anonfun$sendDescribeClusterRequestToBoundPortUntilBrokersPropagated$2(int expectedBrokerCount$1, DescribeClusterResponse response) {
        return response.nodes().size() == expectedBrokerCount$1;
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndPerformReassignment$1(Admin admin$2) {
        return ((java.util.Map)admin$2.listPartitionReassignments().reassignments().get()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndPerformReassignment$2() {
        return "The reassignment never completed.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndPerformReassignment$3(KRaftClusterTest $this, Admin admin$2, ObjectRef currentMapping$1, scala.collection.immutable.Seq expectedMapping$1) {
        java.util.Map topicInfoMap = (java.util.Map)admin$2.describeTopics(Collections.singleton("foo")).allTopicNames().get();
        if (topicInfoMap.containsKey("foo")) {
            currentMapping$1.elem = $this.translatePartitionInfoToSeq(((TopicDescription)topicInfoMap.get("foo")).partitions());
            return expectedMapping$1.equals((Object)((scala.collection.immutable.Seq)currentMapping$1.elem));
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndPerformReassignment$4(scala.collection.immutable.Seq expectedMapping$1, ObjectRef currentMapping$1) {
        return new StringBuilder(72).append("Timed out waiting for replica assignments for topic foo. ").append("Wanted: ").append(expectedMapping$1).append(". Got: ").append((scala.collection.immutable.Seq)currentMapping$1.elem).toString();
    }

    public static final /* synthetic */ boolean $anonfun$checkReplicaManager$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$checkReplicaManager$3(Tuple2 check$ifrefutable$2) {
        return check$ifrefutable$2 != null;
    }

    public static final /* synthetic */ void $anonfun$checkReplicaManager$4(BrokerServer broker$1, Tuple2 x$8) {
        if (x$8 != null) {
            boolean isHosted = x$8._1$mcZ$sp();
            int partitionId = x$8._2$mcI$sp();
            TopicPartition topicPartition = new TopicPartition("foo", partitionId);
            if (isHosted) {
                Assertions.assertNotEquals((Object)HostedPartition.None$.MODULE$, (Object)broker$1.replicaManager().getPartition(topicPartition), (String)new StringBuilder(17).append("topicPartition = ").append(topicPartition).toString());
                return;
            }
            Assertions.assertEquals((Object)HostedPartition.None$.MODULE$, (Object)broker$1.replicaManager().getPartition(topicPartition), (String)new StringBuilder(17).append("topicPartition = ").append(topicPartition).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$checkReplicaManager$2(KafkaClusterTestKit cluster$9, Tuple2 x$9) {
        if (x$9 != null) {
            int brokerId = x$9._1$mcI$sp();
            List partitionsIsHosted = (List)x$9._2();
            BrokerServer broker = cluster$9.brokers().get(BoxesRunTime.boxToInteger((int)brokerId));
            ((IterableOps)partitionsIsHosted.zipWithIndex()).withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$checkReplicaManager$3(check$ifrefutable$2))).foreach((Function1 & Serializable)x$8 -> {
                KRaftClusterTest.$anonfun$checkReplicaManager$4(broker, x$8);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$waitForTopicListing$2(Admin admin$3, HashSet topicsNotFound$1, ObjectRef extraTopics$1, scala.collection.immutable.Seq expectedAbsent$1) {
        ((Iterable)admin$3.listTopics().names().get()).forEach(name -> topicsNotFound$1.remove(name));
        extraTopics$1.elem = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)admin$3.listTopics().names().get()).asScala().filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)expectedAbsent$1.contains((Object)x$11)));
        return topicsNotFound$1.isEmpty() && ((scala.collection.mutable.Set)extraTopics$1.elem).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$waitForTopicListing$5(HashSet topicsNotFound$1, ObjectRef extraTopics$1) {
        return new StringBuilder(49).append("Failed to find topic(s): ").append(CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)topicsNotFound$1).asScala()).append(" and NOT find topic(s): ").append((scala.collection.mutable.Set)extraTopics$1.elem).toString();
    }

    public static final /* synthetic */ void $anonfun$validateConfigs$1(KRaftClusterTest $this, Admin admin$4, scala.collection.immutable.Map expected$1, scala.collection.mutable.HashMap results$1, boolean exhaustive$1) {
        try {
            java.util.Map values = admin$4.describeConfigs((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)expected$1.keySet()).asJava()).values();
            results$1.clear();
            Assertions.assertEquals((Object)expected$1.keySet(), (Object)CollectionConverters$.MODULE$.SetHasAsScala(values.keySet()).asScala());
            expected$1.foreach((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    ConfigResource resource = (ConfigResource)x0$1._1();
                    scala.collection.immutable.Seq pairs = (scala.collection.immutable.Seq)x0$1._2();
                    Config config = (Config)((KafkaFuture)values.get(resource)).get();
                    TreeMap actual = new TreeMap();
                    TreeMap expected = new TreeMap();
                    config.entries().forEach(x0$2 -> {
                        actual.put(x0$2.name(), x0$2.value());
                        if (!exhaustive$1) {
                            expected.put(x0$2.name(), x0$2.value());
                            return;
                        }
                    });
                    pairs.foreach((Function1 & Serializable)x0$3 -> {
                        if (x0$3 != null) {
                            String k = (String)x0$3._1();
                            String v = (String)x0$3._2();
                            return expected.put(k, v);
                        }
                        throw new MatchError(null);
                    });
                    Assertions.assertEquals(expected, actual);
                    return results$1.put((Object)resource, actual);
                }
                throw new MatchError(null);
            });
            return;
        }
        catch (Throwable t) {
            $this.log().warn(new StringBuilder(27).append("Unable to describeConfigs(").append(CollectionConverters$.MODULE$.SetHasAsJava((Set)expected$1.keySet()).asJava()).append(")").toString(), t);
            throw t;
        }
    }

    public static final /* synthetic */ String $anonfun$testUnregisterBroker$2() {
        return "Timed out waiting for broker 0 to be unfenced.";
    }

    public static final /* synthetic */ boolean $anonfun$testUnregisterBroker$3(KRaftClusterTest $this, KafkaClusterTestKit cluster$10) {
        return !$this.brokerIsUnfenced($this.clusterImage(cluster$10, 1), 0);
    }

    public static final /* synthetic */ String $anonfun$testUnregisterBroker$4() {
        return "Timed out waiting for broker 0 to be fenced.";
    }

    public static final /* synthetic */ String $anonfun$testUnregisterBroker$6() {
        return "Timed out waiting for broker 0 to be fenced.";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumRequestToBrokers$2(KafkaClusterTestKit cluster$11, int i$1) {
        BrokerState brokerState = cluster$11.brokers().get(BoxesRunTime.boxToInteger((int)i$1)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testDescribeQuorumRequestToBrokers$3() {
        return "Broker Never started up";
    }

    public static final /* synthetic */ java.util.List $anonfun$testDescribeQuorumRequestToBrokers$5(Admin admin$5) {
        return ((QuorumInfo)admin$5.describeMetadataQuorum(new DescribeMetadataQuorumOptions()).quorumInfo().get()).voters();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumRequestToBrokers$6(java.util.List voters) {
        return voters.stream().allMatch(voter -> {
            if (voter.logEndOffset() > 0L) {
                OptionalLong optionalLong = voter.lastFetchTimestamp();
                OptionalLong optionalLong2 = OptionalLong.empty();
                if (optionalLong == null ? optionalLong2 != null : !((Object)optionalLong).equals(optionalLong2)) {
                    OptionalLong optionalLong3 = voter.lastCaughtUpTimestamp();
                    OptionalLong optionalLong4 = OptionalLong.empty();
                    if (optionalLong3 == null ? optionalLong4 != null : !((Object)optionalLong3).equals(optionalLong4)) {
                        return true;
                    }
                }
            }
            return false;
        });
    }

    public static final /* synthetic */ java.util.List $anonfun$testDescribeQuorumRequestToBrokers$8(Admin admin$5) {
        return ((QuorumInfo)admin$5.describeMetadataQuorum(new DescribeMetadataQuorumOptions()).quorumInfo().get()).observers();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumRequestToBrokers$9(KafkaClusterTestKit cluster$11, java.util.List observers) {
        Set set = CollectionConverters$.MODULE$.MapHasAsScala(cluster$11.brokers()).asScala().keySet();
        scala.collection.immutable.Set set2 = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(observers).asScala().map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.replicaId()))).toSet();
        return !(set != null ? !set.equals(set2) : set2 != null) && observers.stream().allMatch(observer -> {
            if (observer.logEndOffset() > 0L) {
                OptionalLong optionalLong = observer.lastFetchTimestamp();
                OptionalLong optionalLong2 = OptionalLong.empty();
                if (optionalLong == null ? optionalLong2 != null : !((Object)optionalLong).equals(optionalLong2)) {
                    OptionalLong optionalLong3 = observer.lastCaughtUpTimestamp();
                    OptionalLong optionalLong4 = OptionalLong.empty();
                    if (optionalLong3 == null ? optionalLong4 != null : !((Object)optionalLong3).equals(optionalLong4)) {
                        return true;
                    }
                }
            }
            return false;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testUpdateMetadataVersion$1(KafkaClusterTestKit cluster$12) {
        return cluster$12.brokers().get(BoxesRunTime.boxToInteger((int)1)).metadataCache().currentImage().features().metadataVersion().equals((Object)MetadataVersion.latestTesting());
    }

    public static final /* synthetic */ String $anonfun$testUpdateMetadataVersion$2() {
        return "Timed out waiting for metadata version update.";
    }

    private static final long snapshotCounter$1(Path path) {
        return path.toFile().listFiles((x$18, name) -> name.toLowerCase().endsWith("checkpoint")).length;
    }

    public static final /* synthetic */ boolean $anonfun$testSnapshotCount$2(Path metaLog$1) {
        return KRaftClusterTest.snapshotCounter$1(metaLog$1) > 0L;
    }

    public static final /* synthetic */ String $anonfun$testSnapshotCount$3() {
        return "Failed to see at least one snapshot";
    }

    public static final /* synthetic */ boolean $anonfun$testSnapshotCount$4(KafkaClusterTestKit cluster$13) {
        return cluster$13.controllers().values().iterator().next().sharedServer().snapshotEmitter().metrics().latestSnapshotGeneratedBytes() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testSnapshotCount$5() {
        return "Failed to see latestSnapshotGeneratedBytes > 0";
    }

    public static final /* synthetic */ void $anonfun$testReconfigureControllerClientQuotas$1(int expected$3, KafkaClusterTestKit cluster$15) {
        Assertions.assertEquals((int)expected$3, (int)((DummyClientQuotaCallback)cluster$15.controllers().values().iterator().next().quotaManagers().clientQuotaCallback().get()).value());
        Assertions.assertEquals((int)expected$3, (int)((DummyClientQuotaCallback)cluster$15.brokers().values().iterator().next().quotaManagers().clientQuotaCallback().get()).value());
    }

    private static final void assertConfigValue$1(int expected, KafkaClusterTestKit cluster$15) {
        long retry_maxWaitMs = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                KRaftClusterTest.$anonfun$testReconfigureControllerClientQuotas$1(expected, cluster$15);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var8_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testReconfigureControllerAuthorizer$1(int expected$4, KafkaClusterTestKit cluster$16) {
        Assertions.assertEquals((int)expected$4, (int)((FakeConfigurableAuthorizer)cluster$16.controllers().values().iterator().next().authorizer().get()).foobar().get());
        Assertions.assertEquals((int)expected$4, (int)((FakeConfigurableAuthorizer)cluster$16.brokers().values().iterator().next().authorizer().get()).foobar().get());
    }

    private static final void assertFoobarValue$1(int expected, KafkaClusterTestKit cluster$16) {
        long retry_maxWaitMs = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                KRaftClusterTest.$anonfun$testReconfigureControllerAuthorizer$1(expected, cluster$16);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var8_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testTimedOutHeartbeats$1(ControllerServer controller$1) {
        CountDownLatch latch = QuorumControllerIntegrationTestUtils.pause((QuorumController)((QuorumController)controller$1.controller()));
        Thread.sleep(1001L);
        latch.countDown();
        Assertions.assertEquals((int)0, (int)controller$1.sharedServer().controllerServerMetrics().fencedBrokerCount());
        Assertions.assertTrue((controller$1.quorumControllerMetrics().timedOutHeartbeats() > 0L ? 1 : 0) != 0, (String)"Expected timedOutHeartbeats to be greater than 0.");
    }

    public static final /* synthetic */ void $anonfun$testRegisteredControllerEndpoints$1(KafkaClusterTestKit cluster$17) {
        java.util.Map registeredControllers = cluster$17.controllers().values().iterator().next().registrationsPublisher().controllers();
        Assertions.assertEquals((int)3, (int)registeredControllers.size(), (String)"Expected 3 controller registrations");
        registeredControllers.values().forEach(registration -> {
            Assertions.assertNotNull(registration.listeners().get("CONTROLLER"));
            Assertions.assertNotEquals((int)0, (int)((Endpoint)registration.listeners().get("CONTROLLER")).port());
        });
    }

    public static final /* synthetic */ void $anonfun$testStartupWithNonDefaultKControllerDynamicConfiguration$1(ControllerServer controller$2) {
        Assertions.assertNotNull((Object)controller$2.controllerApisHandlerPool());
        Assertions.assertEquals((int)9, (int)controller$2.controllerApisHandlerPool().threadPoolSize().get());
    }

    public static final /* synthetic */ void $anonfun$testTopicDeletedAndRecreatedWhileBrokerIsDown$1(BrokerServer broker0$1, TopicPartition foo0$1) {
        LogManager qual$1 = broker0$1.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Assertions.assertTrue((boolean)qual$1.getLog(foo0$1, x$2).isDefined());
    }

    public static final /* synthetic */ void $anonfun$testTopicDeletedAndRecreatedWhileBrokerIsDown$2(BrokerServer broker1$1) {
        Option info = broker1$1.metadataCache().getPartitionInfo("foo", 0);
        Assertions.assertTrue((boolean)info.isDefined());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((UpdateMetadataRequestData.UpdateMetadataPartitionState)info.get()).isr()).asScala().toSet());
    }

    public static final /* synthetic */ void $anonfun$testTopicDeletedAndRecreatedWhileBrokerIsDown$3(BrokerServer broker1$1) {
        Option info = broker1$1.metadataCache().getPartitionInfo("foo", 0);
        Assertions.assertTrue((boolean)info.isDefined());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((UpdateMetadataRequestData.UpdateMetadataPartitionState)info.get()).isr()).asScala().toSet());
    }

    public static final /* synthetic */ Object $anonfun$waitForRunningBrokers$3$adapted(scala.collection.immutable.Seq x$5) {
        return BoxesRunTime.boxToBoolean((boolean)x$5.nonEmpty());
    }

    public static final /* synthetic */ Object $anonfun$sendDescribeClusterRequestToBoundPortUntilBrokersPropagated$2$adapted(int expectedBrokerCount$1, DescribeClusterResponse response) {
        return BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$sendDescribeClusterRequestToBoundPortUntilBrokersPropagated$2(expectedBrokerCount$1, response));
    }

    public static final /* synthetic */ Object $anonfun$testDescribeQuorumRequestToBrokers$6$adapted(java.util.List voters) {
        return BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$6(voters));
    }

    public static final /* synthetic */ Object $anonfun$testDescribeQuorumRequestToBrokers$9$adapted(KafkaClusterTestKit cluster$11, java.util.List observers) {
        return BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$9(cluster$11, observers));
    }

    public static final /* synthetic */ Object $anonfun$testClientQuotas$4$adapted(ClientQuotaEntity entity$1, int expectCount$1, java.util.Map results) {
        return BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testClientQuotas$4(entity$1, expectCount$1, results));
    }
}

