/*
 * Decompiled with CFR 0.152.
 */
package kafka.testkit;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kafka.testkit.TestKitNode;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.metadata.properties.MetaPropertiesVersion;

public class BrokerNode
implements TestKitNode {
    private final Uuid incarnationId;
    private final MetaPropertiesEnsemble initialMetaPropertiesEnsemble;
    private final boolean combined;
    private final Map<String, String> propertyOverrides;

    BrokerNode(Uuid incarnationId, MetaPropertiesEnsemble initialMetaPropertiesEnsemble, boolean combined, Map<String, String> propertyOverrides) {
        this.incarnationId = incarnationId;
        this.initialMetaPropertiesEnsemble = initialMetaPropertiesEnsemble;
        this.combined = combined;
        this.propertyOverrides = new HashMap<String, String>(propertyOverrides);
    }

    public Uuid incarnationId() {
        return this.incarnationId;
    }

    @Override
    public MetaPropertiesEnsemble initialMetaPropertiesEnsemble() {
        return this.initialMetaPropertiesEnsemble;
    }

    @Override
    public boolean combined() {
        return this.combined;
    }

    public List<String> logDataDirectories() {
        return new ArrayList<String>(this.initialMetaPropertiesEnsemble.logDirProps().keySet());
    }

    public Map<String, String> propertyOverrides() {
        return this.propertyOverrides;
    }

    public static class Builder {
        private int id = -1;
        private String baseDirectory = null;
        private Uuid clusterId = null;
        private Uuid incarnationId = null;
        private List<String> logDataDirectories = null;
        private String metadataDirectory = null;
        private Map<String, String> propertyOverrides = new HashMap<String, String>();

        public int id() {
            return this.id;
        }

        public Builder setId(int id) {
            this.id = id;
            return this;
        }

        public Builder setIncarnationId(Uuid incarnationId) {
            this.incarnationId = incarnationId;
            return this;
        }

        public Builder setMetadataDirectory(String metadataDirectory) {
            this.metadataDirectory = metadataDirectory;
            return this;
        }

        public Builder setLogDirectories(List<String> logDataDirectories) {
            this.logDataDirectories = logDataDirectories;
            return this;
        }

        public BrokerNode build(String baseDirectory, Uuid clusterId, boolean combined) {
            if (this.id == -1) {
                throw new RuntimeException("You must set the node id.");
            }
            if (this.incarnationId == null) {
                this.incarnationId = Uuid.randomUuid();
            }
            if (this.logDataDirectories == null) {
                this.logDataDirectories = combined ? Collections.singletonList(String.format("combined_%d", this.id)) : Collections.singletonList(String.format("broker_%d_data0", this.id));
            }
            ArrayList<String> absoluteLogDataDirectories = new ArrayList<String>();
            for (String logDir : this.logDataDirectories) {
                if (Paths.get(logDir, new String[0]).isAbsolute()) {
                    absoluteLogDataDirectories.add(logDir);
                    continue;
                }
                absoluteLogDataDirectories.add(new File(baseDirectory, logDir).getAbsolutePath());
            }
            this.logDataDirectories = absoluteLogDataDirectories;
            if (this.metadataDirectory == null) {
                this.metadataDirectory = this.logDataDirectories.get(0);
            } else if (!Paths.get(this.metadataDirectory, new String[0]).isAbsolute()) {
                this.metadataDirectory = new File(baseDirectory, this.metadataDirectory).getAbsolutePath();
            }
            MetaPropertiesEnsemble.Copier copier = new MetaPropertiesEnsemble.Copier(MetaPropertiesEnsemble.EMPTY);
            copier.setMetaLogDir(Optional.of(this.metadataDirectory));
            for (String logDir : this.logDataDirectories) {
                copier.setLogDirProps(logDir, new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId(clusterId.toString()).setNodeId(this.id).setDirectoryId(copier.generateValidDirectoryId()).build());
            }
            copier.setMetaLogDir(Optional.of(this.metadataDirectory));
            return new BrokerNode(this.incarnationId, copier.copy(), combined, this.propertyOverrides);
        }
    }
}

