/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import java.io.File;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import kafka.log.LogManager$;
import kafka.raft.KafkaRaftManager;
import kafka.raft.KafkaRaftManager$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer;
import kafka.tools.TestRaftServer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00055f\u0001\u0002\t\u0012\u0001YAQ!\b\u0001\u0005\u0002yAQ!\t\u0001\u0005\n\tBQ\u0001\u0015\u0001\u0005\nECQA\u001b\u0001\u0005\n-Dq!!\u0003\u0001\t\u0003\tY\u0001C\u0004\u0002P\u0001!\t!!\u0015\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l!9\u00111\u0010\u0001\u0005\u0002\u0005u\u0004bBAA\u0001\u0011\u0005\u00111\u0011\u0005\b\u0003#\u0003A\u0011AA6\u0011\u001d\t)\n\u0001C\u0001\u0003WBq!!'\u0001\t\u0003\tY\u0007C\u0004\u0002\u001e\u0002!\t!a\u001b\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002l!9\u0011Q\u0015\u0001\u0005\n\u0005\u001d&a\u0004*bMRl\u0015M\\1hKJ$Vm\u001d;\u000b\u0005I\u0019\u0012\u0001\u0002:bMRT\u0011\u0001F\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0003\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"\u0001\t\u0001\u000e\u0003E\tAc\u0019:fCR,'l\u001b\"s_.,'oQ8oM&<G#B\u0012*]MZ\u0005C\u0001\u0013(\u001b\u0005)#B\u0001\u0014\u0014\u0003\u0019\u0019XM\u001d<fe&\u0011\u0001&\n\u0002\f\u0017\u000647.Y\"p]\u001aLw\rC\u0003+\u0005\u0001\u00071&\u0001\tnS\u001e\u0014\u0018\r^5p]\u0016s\u0017M\u00197fIB\u0011\u0001\u0004L\u0005\u0003[e\u0011qAQ8pY\u0016\fg\u000eC\u00030\u0005\u0001\u0007\u0001'\u0001\u0004o_\u0012,\u0017\n\u001a\t\u00031EJ!AM\r\u0003\u0007%sG\u000fC\u00035\u0005\u0001\u0007Q'\u0001\u0004m_\u001e$\u0015N\u001d\t\u0004my\neBA\u001c=\u001d\tA4(D\u0001:\u0015\tQT#\u0001\u0004=e>|GOP\u0005\u00025%\u0011Q(G\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0004IA\u0002TKFT!!P\r\u0011\u0005\tKU\"A\"\u000b\u0005\u0011+\u0015\u0001\u00024jY\u0016T!AR$\u0002\u00079LwNC\u0001I\u0003\u0011Q\u0017M^1\n\u0005)\u001b%\u0001\u0002)bi\"DQ\u0001\u0014\u0002A\u00025\u000b1\"\\3uC\u0012\fG/\u0019#jeB\u0019\u0001DT!\n\u0005=K\"AB(qi&|g.\u0001\u0007de\u0016\fG/Z\"p]\u001aLw\rF\u0003$%\u001eD\u0017\u000eC\u0003T\u0007\u0001\u0007A+\u0001\u0007qe>\u001cWm]:S_2,7\u000fE\u0002V3rs!AV,\u0011\u0005aJ\u0012B\u0001-\u001a\u0003\u0019\u0001&/\u001a3fM&\u0011!l\u0017\u0002\u0004'\u0016$(B\u0001-\u001a!\tiFM\u0004\u0002_E:\u0011q,\u0019\b\u0003q\u0001L\u0011\u0001F\u0005\u0003MMI!aY\u0013\u0002\u001f-\u000bgm[1SC\u001a$8+\u001a:wKJL!!\u001a4\u0003\u0017A\u0013xnY3tgJ{G.\u001a\u0006\u0003G\u0016BQaL\u0002A\u0002ABQ\u0001N\u0002A\u00025CQ\u0001T\u0002A\u00025\u000b\u0011c\u0019:fCR,'+\u00194u\u001b\u0006t\u0017mZ3s)\u0011aW/!\u0002\u0011\u0007\u0001jw.\u0003\u0002o#\t\u00012*\u00194lCJ\u000bg\r^'b]\u0006<WM\u001d\t\u00041A\u0014\u0018BA9\u001a\u0005\u0015\t%O]1z!\tA2/\u0003\u0002u3\t!!)\u001f;f\u0011\u00151H\u00011\u0001x\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u00042\u0001_A\u0001\u001b\u0005I(B\u0001>|\u0003\u0019\u0019w.\\7p]*\u0011A\u0003 \u0006\u0003{z\fa!\u00199bG\",'\"A@\u0002\u0007=\u0014x-C\u0002\u0002\u0004e\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0002\b\u0011\u0001\raI\u0001\u0007G>tg-[4\u0002#Q,7\u000f\u001e(pI\u0016LE\r\u0015:fg\u0016tG\u000f\u0006\u0003\u0002\u000e\u0005M\u0001c\u0001\r\u0002\u0010%\u0019\u0011\u0011C\r\u0003\tUs\u0017\u000e\u001e\u0005\u0007'\u0016\u0001\r!!\u0006\u0011\u0007U\u000b9\"C\u0002\u0002\u001am\u0013aa\u0015;sS:<\u0007fA\u0003\u0002\u001eA!\u0011qDA\u0017\u001b\t\t\tC\u0003\u0003\u0002$\u0005\u0015\u0012A\u00029be\u0006l7O\u0003\u0003\u0002(\u0005%\u0012a\u00026va&$XM\u001d\u0006\u0004\u0003Wq\u0018!\u00026v]&$\u0018\u0002BA\u0018\u0003C\u0011\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:uQ\u001d)\u00111GA \u0003\u0003\u0002B!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0005\u0003s\t\t#\u0001\u0005qe>4\u0018\u000eZ3s\u0013\u0011\ti$a\u000e\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\u0019\t\u0019%a\u0012\u0002L\u0005\u0012\u0011QI\u0001\u0007EJ|7.\u001a:\"\u0005\u0005%\u0013AC2p]R\u0014x\u000e\u001c7fe\u0006\u0012\u0011QJ\u0001\u0012EJ|7.\u001a:-G>tGO]8mY\u0016\u0014\u0018\u0001\t;fgRdun\u001a#je2{7m[,iK:\u001cuN\u001c;s_2dWM](oYf$B!!\u0004\u0002T!9\u0011Q\u000b\u0004A\u0002\u0005U\u0011a\u00023jeRK\b/\u001a\u0015\u0004\r\u0005u\u0001f\u0002\u0004\u00024\u0005}\u00121\f\u0017\u0007\u0003;\n\t'!\u001a\"\u0005\u0005}\u0013!D7fi\u0006$\u0017\r^1._:d\u00170\t\u0002\u0002d\u0005AAn\\4._:d\u00170\t\u0002\u0002h\u0005!!m\u001c;i\u0003M\"Xm\u001d;M_\u001e$\u0015N\u001d'pG.<\u0006.\u001a8Ce>\\WM](oYf<\u0016\u000e\u001e5TKB\f'/\u0019;f\u001b\u0016$\u0018\rZ1uC\u0012K'\u000f\u0006\u0002\u0002\u000e!\u001aq!a\u001c\u0011\t\u0005E\u0014qO\u0007\u0003\u0003gRA!!\u001e\u0002&\u0005\u0019\u0011\r]5\n\t\u0005e\u00141\u000f\u0002\u0005)\u0016\u001cH/A\tde\u0016\fG/Z'fi\u0006$\u0017\r^1M_\u001e$B!!\u0004\u0002\u0000!1\u0011q\u0001\u0005A\u0002\r\n!#Y:tKJ$Hj\\4ESJ\u001cX\t_5tiRA\u0011QBAC\u0003\u0013\u000bi\t\u0003\u0004\u0002\b&\u0001\r!N\u0001\bY><G)\u001b:t\u0011\u0019\tY)\u0003a\u0001\u001b\u0006qQ.\u001a;bI\u0006$\u0018\rT8h\t&\u0014\bBBAH\u0013\u0001\u00071&A\tfqB,7\r^'fi\u0006$\u0017\r^1M_\u001e\fq\u0005^3ti6KwM]1uS:<'l\u001b\"s_.,'\u000fR3mKR,7/T3uC\u0012\fG/\u0019'pO\"\u001a!\"a\u001c\u0002aQ,7\u000f\u001e(p]6KwM]1uS:<'l\u001b\"s_.,'\u000fR8fg:{G\u000fR3mKR,W*\u001a;bI\u0006$\u0018\rT8hQ\rY\u0011qN\u0001)i\u0016\u001cHOW6Ce>\\WM\u001d#pKNtu\u000e\u001e#fY\u0016$XmU3qCJ\fG/\u001a'pO\u0012K'o\u001d\u0015\u0004\u0019\u0005=\u0014a\t;fgRT6N\u0011:pW\u0016\u0014Hi\\3t\u001d>$H)\u001a7fi\u0016\u001c\u0016-\\3M_\u001e$\u0015N\u001d\u0015\u0004\u001b\u0005=\u0014a\n;fgR\\%+\u00194u\u0005J|7.\u001a:E_\u0016\u001chj\u001c;EK2,G/Z'fi\u0006$\u0017\r^1M_\u001eD3ADA8\u0003)1\u0017\u000e\\3M_\u000e\\W\r\u001a\u000b\u0004W\u0005%\u0006BBAV\u001f\u0001\u0007\u0011)\u0001\u0003qCRD\u0007")
public class RaftManagerTest {
    private KafkaConfig createZkBrokerConfig(boolean migrationEnabled, int nodeId, Seq<Path> logDir, Option<Path> metadataDir) {
        Properties props = new Properties();
        logDir.foreach((Function1 & Serializable)value -> props.setProperty(KafkaConfig$.MODULE$.LogDirProp(), ((Object)value).toString()));
        if (migrationEnabled) {
            metadataDir.foreach((Function1 & Serializable)value -> props.setProperty(KafkaConfig$.MODULE$.MetadataLogDirProp(), ((Object)value).toString()));
            props.setProperty(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId).append("@localhost:9093").toString());
            props.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        }
        props.setProperty(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        props.setProperty(KafkaConfig$.MODULE$.BrokerIdProp(), Integer.toString(nodeId));
        return new KafkaConfig((Map)props);
    }

    private KafkaConfig createConfig(Set<KafkaRaftServer.ProcessRole> processRoles, int nodeId, Option<Path> logDir, Option<Path> metadataDir) {
        Properties props = new Properties();
        logDir.foreach((Function1 & Serializable)value -> props.setProperty(KafkaConfig$.MODULE$.LogDirProp(), ((Object)value).toString()));
        metadataDir.foreach((Function1 & Serializable)value -> props.setProperty(KafkaConfig$.MODULE$.MetadataLogDirProp(), ((Object)value).toString()));
        props.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), processRoles.mkString(","));
        props.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        props.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        if (processRoles.contains((Object)KafkaRaftServer.BrokerRole$.MODULE$)) {
            props.setProperty(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "PLAINTEXT");
            if (processRoles.contains((Object)KafkaRaftServer.ControllerRole$.MODULE$)) {
                props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://localhost:9092,SSL://localhost:9093");
                props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId).append("@localhost:9093").toString());
            } else {
                int voterId = nodeId + 1;
                props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(voterId).append("@localhost:9093").toString());
            }
        } else if (processRoles.contains((Object)KafkaRaftServer.ControllerRole$.MODULE$)) {
            props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), "SSL://localhost:9093");
            props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId).append("@localhost:9093").toString());
        }
        return new KafkaConfig((Map)props);
    }

    private KafkaRaftManager<byte[]> createRaftManager(TopicPartition topicPartition, KafkaConfig config) {
        Uuid topicId = new Uuid(0L, 2L);
        return new KafkaRaftManager(Uuid.randomUuid().toString(), config, (RecordSerde)new TestRaftServer.ByteArraySerde(), topicPartition, topicId, Time.SYSTEM, new Metrics(Time.SYSTEM), Option$.MODULE$.empty(), CompletableFuture.completedFuture(RaftConfig.parseVoterConnections((java.util.List)config.quorumVoters())), (FaultHandler)Mockito.mock(FaultHandler.class));
    }

    @ParameterizedTest
    @ValueSource(strings={"broker", "controller", "broker,controller"})
    public void testNodeIdPresent(String processRoles) {
        Set processRolesSet = Predef$.MODULE$.Set().empty();
        if (processRoles.contains("broker")) {
            processRolesSet = (Set)processRolesSet.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer.BrokerRole$[]{KafkaRaftServer.BrokerRole$.MODULE$})));
        }
        if (processRoles.contains("controller")) {
            processRolesSet = (Set)processRolesSet.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer.ControllerRole$[]{KafkaRaftServer.ControllerRole$.MODULE$})));
        }
        File logDir = TestUtils.tempDirectory(null, null);
        int nodeId = 1;
        KafkaRaftManager<byte[]> raftManager = this.createRaftManager(new TopicPartition("__raft_id_test", 0), this.createConfig((Set<KafkaRaftServer.ProcessRole>)processRolesSet, nodeId, (Option<Path>)new Some((Object)logDir.toPath()), (Option<Path>)None$.MODULE$));
        Assertions.assertEquals((int)nodeId, (int)raftManager.client().nodeId().getAsInt());
        raftManager.shutdown();
    }

    @ParameterizedTest
    @ValueSource(strings={"metadata-only", "log-only", "both"})
    public void testLogDirLockWhenControllerOnly(String dirType) {
        None$ logDir;
        None$ none$ = dirType.equals("metadata-only") ? None$.MODULE$ : (logDir = new Some((Object)TestUtils.tempDirectory(null, null).toPath()));
        None$ metadataDir = dirType.equals("log-only") ? None$.MODULE$ : new Some((Object)TestUtils.tempDirectory(null, null).toPath());
        int nodeId = 1;
        KafkaRaftManager<byte[]> raftManager = this.createRaftManager(new TopicPartition("__raft_id_test", 0), this.createConfig((Set<KafkaRaftServer.ProcessRole>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer.ProcessRole[]{KafkaRaftServer.ControllerRole$.MODULE$}))), nodeId, (Option<Path>)logDir, (Option<Path>)metadataDir));
        Path lockPath = ((Path)metadataDir.getOrElse(() -> RaftManagerTest.$anonfun$testLogDirLockWhenControllerOnly$1((Option)logDir))).resolve(LogManager$.MODULE$.LockFileName());
        Assertions.assertTrue((boolean)this.fileLocked(lockPath));
        raftManager.shutdown();
        Assertions.assertFalse((boolean)this.fileLocked(lockPath));
    }

    @Test
    public void testLogDirLockWhenBrokerOnlyWithSeparateMetadataDir() {
        Some logDir = new Some((Object)TestUtils.tempDirectory(null, null).toPath());
        Some metadataDir = new Some((Object)TestUtils.tempDirectory(null, null).toPath());
        int nodeId = 1;
        KafkaRaftManager<byte[]> raftManager = this.createRaftManager(new TopicPartition("__raft_id_test", 0), this.createConfig((Set<KafkaRaftServer.ProcessRole>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer.ProcessRole[]{KafkaRaftServer.BrokerRole$.MODULE$}))), nodeId, (Option<Path>)logDir, (Option<Path>)metadataDir));
        Path lockPath = ((Path)metadataDir.getOrElse((Function0 & Serializable)() -> (Path)logDir.get())).resolve(LogManager$.MODULE$.LockFileName());
        Assertions.assertTrue((boolean)this.fileLocked(lockPath));
        raftManager.shutdown();
        Assertions.assertFalse((boolean)this.fileLocked(lockPath));
    }

    public void createMetadataLog(KafkaConfig config) {
        this.createRaftManager(new TopicPartition("__cluster_metadata", 0), config).shutdown();
    }

    public void assertLogDirsExist(Seq<Path> logDirs, Option<Path> metadataLogDir, boolean expectMetadataLog) {
        Assertions.assertTrue((boolean)Files.exists((Path)metadataLogDir.get(), new LinkOption[0]));
        logDirs.foreach((Function1 & Serializable)logDir -> {
            RaftManagerTest.$anonfun$assertLogDirsExist$1(logDir);
            return BoxedUnit.UNIT;
        });
        if (expectMetadataLog) {
            Assertions.assertTrue((boolean)Files.exists(((Path)metadataLogDir.get()).resolve("__cluster_metadata-0"), new LinkOption[0]));
            return;
        }
        Assertions.assertFalse((boolean)Files.exists(((Path)metadataLogDir.get()).resolve("__cluster_metadata-0"), new LinkOption[0]));
    }

    @Test
    public void testMigratingZkBrokerDeletesMetadataLog() {
        .colon.colon logDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null).toPath(), (List)Nil$.MODULE$);
        Some metadataLogDir = new Some((Object)TestUtils.tempDirectory(null, null).toPath());
        int nodeId = 1;
        KafkaConfig config = this.createZkBrokerConfig(true, nodeId, (Seq<Path>)logDirs, (Option<Path>)metadataLogDir);
        this.createMetadataLog(config);
        KafkaRaftManager$.MODULE$.maybeDeleteMetadataLogDir(config);
        this.assertLogDirsExist((Seq<Path>)logDirs, (Option<Path>)metadataLogDir, false);
    }

    @Test
    public void testNonMigratingZkBrokerDoesNotDeleteMetadataLog() {
        .colon.colon logDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null).toPath(), (List)Nil$.MODULE$);
        Some metadataLogDir = new Some((Object)TestUtils.tempDirectory(null, null).toPath());
        int nodeId = 1;
        KafkaConfig config = this.createZkBrokerConfig(false, nodeId, (Seq<Path>)logDirs, (Option<Path>)metadataLogDir);
        Files.createDirectory(((Path)metadataLogDir.get()).resolve("__cluster_metadata-0"), new FileAttribute[0]);
        RuntimeException err = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> KafkaRaftManager$.MODULE$.maybeDeleteMetadataLogDir(config), (String)"Should have not deleted the metadata log");
        Assertions.assertEquals((Object)"Not deleting metadata log dir since migrations are not enabled.", (Object)err.getMessage());
        this.assertLogDirsExist((Seq<Path>)logDirs, (Option<Path>)metadataLogDir, true);
    }

    @Test
    public void testZkBrokerDoesNotDeleteSeparateLogDirs() {
        .colon.colon logDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null).toPath(), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null).toPath(), (List)Nil$.MODULE$));
        Some metadataLogDir = new Some((Object)TestUtils.tempDirectory(null, null).toPath());
        int nodeId = 1;
        KafkaConfig config = this.createZkBrokerConfig(true, nodeId, (Seq<Path>)logDirs, (Option<Path>)metadataLogDir);
        this.createMetadataLog(config);
        KafkaRaftManager$.MODULE$.maybeDeleteMetadataLogDir(config);
        this.assertLogDirsExist((Seq<Path>)logDirs, (Option<Path>)metadataLogDir, false);
    }

    @Test
    public void testZkBrokerDoesNotDeleteSameLogDir() {
        .colon.colon logDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null).toPath(), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null).toPath(), (List)Nil$.MODULE$));
        Option metadataLogDir = logDirs.headOption();
        int nodeId = 1;
        KafkaConfig config = this.createZkBrokerConfig(true, nodeId, (Seq<Path>)logDirs, (Option<Path>)metadataLogDir);
        this.createMetadataLog(config);
        KafkaRaftManager$.MODULE$.maybeDeleteMetadataLogDir(config);
        this.assertLogDirsExist((Seq<Path>)logDirs, (Option<Path>)metadataLogDir, false);
    }

    @Test
    public void testKRaftBrokerDoesNotDeleteMetadataLog() {
        Path logDir = TestUtils.tempDirectory(null, null).toPath();
        Some metadataLogDir = new Some((Object)TestUtils.tempDirectory(null, null).toPath());
        int nodeId = 1;
        KafkaConfig config = this.createConfig((Set<KafkaRaftServer.ProcessRole>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer.ProcessRole[]{KafkaRaftServer.BrokerRole$.MODULE$}))), nodeId, (Option<Path>)new Some((Object)logDir), (Option<Path>)metadataLogDir);
        this.createMetadataLog(config);
        Assertions.assertThrows(RuntimeException.class, () -> KafkaRaftManager$.MODULE$.maybeDeleteMetadataLogDir(config), (String)"Should not have deleted metadata log");
        this.assertLogDirsExist((Seq<Path>)new .colon.colon((Object)logDir, (List)Nil$.MODULE$), (Option<Path>)metadataLogDir, true);
    }

    private boolean fileLocked(Path path) {
        boolean bl;
        try (FileChannel resource_resource = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            bl = RaftManagerTest.$anonfun$fileLocked$1(resource_resource);
        }
        return bl;
    }

    public static final /* synthetic */ Path $anonfun$testLogDirLockWhenControllerOnly$1(Option logDir$1) {
        return (Path)logDir$1.get();
    }

    public static final /* synthetic */ void $anonfun$assertLogDirsExist$1(Path logDir) {
        Assertions.assertTrue((boolean)Files.exists(logDir, new LinkOption[0]), (String)"Should not delete log dir");
    }

    public static final /* synthetic */ boolean $anonfun$fileLocked$1(FileChannel channel) {
        try {
            Option$.MODULE$.apply((Object)channel.tryLock()).foreach((Function1 & Serializable)x$1 -> {
                x$1.close();
                return BoxedUnit.UNIT;
            });
            return false;
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            return true;
        }
    }

    public static final /* synthetic */ Object $anonfun$fileLocked$1$adapted(FileChannel channel) {
        return BoxesRunTime.boxToBoolean((boolean)RaftManagerTest.$anonfun$fileLocked$1(channel));
    }
}

