/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.server.GroupCoordinatorBaseRequestTest;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Timeout(value=120L)
@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(clusterType=Type.KRAFT, brokers=1)
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u0005Ma\u0001B\u0004\t\u00015A\u0001B\u0005\u0001\u0003\u0002\u0003\u0006Ia\u0005\u0005\u00063\u0001!\tA\u0007\u0005\u0006;\u0001!\tA\b\u0005\u0006\u0011\u0002!\tA\b\u0005\u0006\u0017\u0002!\tA\b\u0005\u0006/\u0002!I\u0001\u0017\u0002\u0018\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e*fcV,7\u000f\u001e+fgRT!!\u0003\u0006\u0002\rM,'O^3s\u0015\u0005Y\u0011!B6bM.\f7\u0001A\n\u0003\u00019\u0001\"a\u0004\t\u000e\u0003!I!!\u0005\u0005\u0003?\u001d\u0013x.\u001e9D_>\u0014H-\u001b8bi>\u0014()Y:f%\u0016\fX/Z:u)\u0016\u001cH/A\u0004dYV\u001cH/\u001a:\u0011\u0005Q9R\"A\u000b\u000b\u0005YQ\u0011\u0001\u0002;fgRL!\u0001G\u000b\u0003\u001f\rcWo\u001d;fe&s7\u000f^1oG\u0016\fa\u0001P5oSRtDCA\u000e\u001d!\ty\u0001\u0001C\u0003\u0013\u0005\u0001\u00071#\u0001\"uKN$xJ\u001a4tKR\u001cu.\\7ji^KG\u000f\u001b(fo\u000e{gn];nKJ<%o\\;q!J|Go\\2pY\u0006sGMT3x\u000fJ|W\u000f]\"p_J$\u0017N\\1u_J$\u0012a\b\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0005+:LG\u000f\u000b\u0003\u0004M1j\u0003CA\u0014+\u001b\u0005A#BA\u0015\u0016\u0003)\tgN\\8uCRLwN\\\u0005\u0003W!\u00121b\u00117vgR,'\u000fV3ti\u0006\u00012/\u001a:wKJ\u0004&o\u001c9feRLWm\u001d\u0017\u0006]aj\u0004)R\u0016\u0006_I\u001aTG\u000e\t\u0003OAJ!!\r\u0015\u0003+\rcWo\u001d;fe\u000e{gNZ5h!J|\u0007/\u001a:us\u0006\u00191.Z=\"\u0003Q\nAd\u001a:pkBt3m\\8sI&t\u0017\r^8s]9,wOL3oC\ndW-A\u0003wC2,X-I\u00018\u0003\u0011!(/^3,\u000b=\u0012\u0014(N\u001e\"\u0003i\nQe\u001a:pkBt3m\u001c8tk6,'OL7bq:\u001aXm]:j_:tC/[7f_V$h&\\:\"\u0003q\naA\u000e\u00191aA\u00024&B\u00183}UZ\u0014%A \u0002C\u001d\u0014x.\u001e9/G>t7/^7fe:\u001aXm]:j_:tC/[7f_V$h&\\:,\u000b=\u0012\u0014)N\"\"\u0003\t\u000bAd\u001c4gg\u0016$8O\f;pa&\u001cgF\\;n]A\f'\u000f^5uS>t7/I\u0001E\u0003\u0005\t4&B\u00183\rV\u001a\u0015%A$\u0002A=4gm]3ug:\"x\u000e]5d]I,\u0007\u000f\\5dCRLwN\u001c\u0018gC\u000e$xN]\u0001Ci\u0016\u001cHo\u00144gg\u0016$8i\\7nSR<\u0016\u000e\u001e5PY\u0012\u001cuN\\:v[\u0016\u0014xI]8vaB\u0013x\u000e^8d_2\fe\u000e\u001a(fo\u001e\u0013x.\u001e9D_>\u0014H-\u001b8bi>\u0014\b\u0006\u0002\u0003'Y)c3A\f!F\u0003\t#Xm\u001d;PM\u001a\u001cX\r^\"p[6LGoV5uQ>cGmQ8ogVlWM]$s_V\u0004\bK]8u_\u000e|G.\u00118e\u001f2$wI]8va\u000e{wN\u001d3j]\u0006$xN\u001d\u0015\u0007\u000b\u0019je\nL*\u0002\u0017\rdWo\u001d;feRK\b/\u001a\u0013\u0002\u001f&\u0011\u0001+U\u0001\u0004\u00032c%B\u0001*)\u0003\u0011!\u0016\u0010]3-\u0007Q\u0003UiK\u00030eM*T+I\u0001W\u0003\u00151\u0017\r\\:f\u0003A!Xm\u001d;PM\u001a\u001cX\r^\"p[6LG\u000f\u0006\u0002 3\")!L\u0002a\u00017\u0006qQo]3OK^\u0004&o\u001c;pG>d\u0007C\u0001\u0011]\u0013\ti\u0016EA\u0004C_>dW-\u00198)\t\u0001yVg\u001b\t\u0003A&l\u0011!\u0019\u0006\u0003E\u000e\f1!\u00199j\u0015\t!W-A\u0004kkBLG/\u001a:\u000b\u0005\u0019<\u0017!\u00026v]&$(\"\u00015\u0002\u0007=\u0014x-\u0003\u0002kC\n9A+[7f_V$h$\u0001=)\t\u0001iWg\u001d\t\u0003]Fl\u0011a\u001c\u0006\u0003a\u0006\f\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\u0005I|'AC#yi\u0016tGmV5uQ2\nAoI\u0001v!\t1\b0D\u0001x\u0015\t1W#\u0003\u0002zo\n)2\t\\;ti\u0016\u0014H+Z:u\u000bb$XM\\:j_:\u001c\b\u0006\u0003\u0001|\u001bz\f\u0019!!\u0002\u0011\u0005\u001db\u0018BA?)\u0005M\u0019E.^:uKJ$Vm\u001d;EK\u001a\fW\u000f\u001c;tI\u0005y\u0018bAA\u0001#\u0006)1JU!G)\u00069!M]8lKJ\u001cX$A\u0001)\r\u0001\tI!NA\b!\r\u0001\u00171B\u0005\u0004\u0003\u001b\t'a\u0001+bO\u0006\u0012\u0011\u0011C\u0001\fS:$Xm\u001a:bi&|g\u000e")
public class OffsetCommitRequestTest
extends GroupCoordinatorBaseRequestTest {
    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.new.enable", value="true"), @ClusterConfigProperty(key="group.consumer.max.session.timeout.ms", value="600000"), @ClusterConfigProperty(key="group.consumer.session.timeout.ms", value="600000"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")})
    public void testOffsetCommitWithNewConsumerGroupProtocolAndNewGroupCoordinator() {
        this.testOffsetCommit(true);
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.new.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")})
    public void testOffsetCommitWithOldConsumerGroupProtocolAndNewGroupCoordinator() {
        this.testOffsetCommit(false);
    }

    @ClusterTest(clusterType=Type.ALL, serverProperties={@ClusterConfigProperty(key="group.coordinator.new.enable", value="false"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")})
    public void testOffsetCommitWithOldConsumerGroupProtocolAndOldGroupCoordinator() {
        this.testOffsetCommit(false);
    }

    /*
     * WARNING - void declaration
     */
    private void testOffsetCommit(boolean useNewProtocol) {
        void var3_3;
        if (useNewProtocol && !this.isNewGroupCoordinatorEnabled()) {
            Assertions.fail((String)"Cannot use the new protocol with the old group coordinator.");
        }
        this.createOffsetsTopic();
        this.createTopic("foo", 3);
        Tuple2<String, Object> tuple2 = this.joinConsumerGroup("grp", useNewProtocol);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String memberId = (String)tuple2._1();
        int n = tuple2._2$mcI$sp();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), (int)ApiKeys.OFFSET_COMMIT.latestVersion(this.isUnstableApiEnabled())).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> OffsetCommitRequestTest.$anonfun$testOffsetCommit$1(this, (String)var3_3, n, useNewProtocol, arg_0)));
    }

    public static final /* synthetic */ void $anonfun$testOffsetCommit$1(OffsetCommitRequestTest $this, String memberId$1, int memberEpoch$1, boolean useNewProtocol$1, int version) {
        $this.commitOffset("grp", memberId$1, memberEpoch$1, "foo", 0, 100L, Errors.NONE, (short)version);
        $this.commitOffset("unknown", memberId$1, memberEpoch$1, "foo", 0, 100L, $this.isNewGroupCoordinatorEnabled() && version >= 9 ? Errors.GROUP_ID_NOT_FOUND : Errors.ILLEGAL_GENERATION, (short)version);
        $this.commitOffset("", memberId$1, memberEpoch$1, "foo", 0, 100L, $this.isNewGroupCoordinatorEnabled() && version >= 9 ? Errors.GROUP_ID_NOT_FOUND : Errors.ILLEGAL_GENERATION, (short)version);
        $this.commitOffset("grp", "", memberEpoch$1, "foo", 0, 100L, Errors.UNKNOWN_MEMBER_ID, (short)version);
        $this.commitOffset("grp", memberId$1, memberEpoch$1 + 1, "foo", 0, 100L, useNewProtocol$1 && version >= 9 ? Errors.STALE_MEMBER_EPOCH : (useNewProtocol$1 ? Errors.UNSUPPORTED_VERSION : Errors.ILLEGAL_GENERATION), (short)version);
        $this.commitOffset("other-grp", "", -1, "foo", 0, 100L, Errors.NONE, (short)version);
    }

    public OffsetCommitRequestTest(ClusterInstance cluster) {
        super(cluster);
    }
}

