/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.server;

import java.io.File;
import java.io.Serializable;
import java.net.Socket;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.server.BaseFetchRequestTest;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\rc\u0001B\n\u0015\u0001mAQA\t\u0001\u0005\u0002\rBqA\n\u0001C\u0002\u0013\u0005q\u0005\u0003\u0004/\u0001\u0001\u0006I\u0001\u000b\u0005\b_\u0001\u0011\r\u0011\"\u0001(\u0011\u0019\u0001\u0004\u0001)A\u0005Q!9\u0011\u0007\u0001b\u0001\n\u0003\u0011\u0004BB\u001e\u0001A\u0003%1\u0007C\u0004=\u0001\t\u0007I\u0011A\u0014\t\ru\u0002\u0001\u0015!\u0003)\u0011\u001dq\u0004A1A\u0005\u0002\u001dBaa\u0010\u0001!\u0002\u0013A\u0003\"\u0002!\u0001\t\u0003\t\u0005\"\u0002%\u0001\t\u0003J\u0005\"B*\u0001\t\u0003!\u0006bBA\u000b\u0001\u0011\u0005\u0011q\u0003\u0005\b\u0003C\u0001A\u0011AA\u0012\u0011\u001d\ti\u0003\u0001C\u0001\u0003_Aa!!\u0011\u0001\t\u00139#\u0001\t$fi\u000eDgI]8n\r>dGn\\<fe&sG/Z4sCRLwN\u001c+fgRT!!\u0006\f\u0002\rM,'O^3s\u0015\t9\u0002$A\u0003lC\u001a\\\u0017MC\u0001\u001a\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\u0004\u0001M\u0011\u0001\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0003+}Q\u0011aF\u0005\u0003Cy\u0011ACQ1tK\u001a+Go\u00195SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001%!\t)\u0003!D\u0001\u0015\u0003!qW/\u001c(pI\u0016\u001cX#\u0001\u0015\u0011\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0003\u0007%sG/A\u0005ok6tu\u000eZ3tA\u0005Aa.^7QCJ$8/A\u0005ok6\u0004\u0016M\u001d;tA\u0005)Ao\u001c9jGV\t1\u0007\u0005\u00025s5\tQG\u0003\u00027o\u0005!A.\u00198h\u0015\u0005A\u0014\u0001\u00026bm\u0006L!AO\u001b\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005qA.Z1eKJ\u0014%o\\6fe&#\u0017a\u00047fC\u0012,'O\u0011:pW\u0016\u0014\u0018\n\u001a\u0011\u0002!\u0019|G\u000e\\8xKJ\u0014%o\\6fe&#\u0017!\u00054pY2|w/\u001a:Ce>\\WM]%eA\u0005yqN^3se&$\u0017N\\4Qe>\u00048/F\u0001C!\t\u0019e)D\u0001E\u0015\t)u'\u0001\u0003vi&d\u0017BA$E\u0005)\u0001&o\u001c9feRLWm]\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\t!\nE\u0002L\u001dBk\u0011\u0001\u0014\u0006\u0003\u001b*\n!bY8mY\u0016\u001cG/[8o\u0013\tyEJA\u0002TKF\u0004\"!H)\n\u0005Is\"aC&bM.\f7i\u001c8gS\u001e\fq\u0006^3ti\u001a{G\u000e\\8xKJ\u001cu.\u001c9mKR,G)\u001a7bs\u0016$g)\u001a;dQ\u0016\u001cxJ\u001c*fa2L7-\u0019;j_:$\"!\u0016-\u0011\u0005%2\u0016BA,+\u0005\u0011)f.\u001b;\t\u000bes\u0001\u0019\u0001.\u0002\rE,xN];n!\tY&M\u0004\u0002]AB\u0011QLK\u0007\u0002=*\u0011qLG\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005T\u0013A\u0002)sK\u0012,g-\u0003\u0002;G*\u0011\u0011M\u000b\u0015\u0005\u001d\u0015\f(\u000f\u0005\u0002g_6\tqM\u0003\u0002iS\u00061\u0001/\u0019:b[NT!A[6\u0002\u000f),\b/\u001b;fe*\u0011A.\\\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002]\u0006\u0019qN]4\n\u0005A<'!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\u0005\u0019\u0018AI>eSN\u0004H.Y=OC6,WPL>be\u001e,X.\u001a8ug^KG\u000f\u001b(b[\u0016\u001cX\u0010\u000b\u0003\u000fknd\bC\u0001<z\u001b\u00059(B\u0001=h\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018B\u0001>x\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\u0012Qp`\u0011\u0002}\u0006\u0011!p[\u0011\u0003\u0003\u0003\tQa\u001b:bMRDsADA\u0003\u0003#\t\u0019\u0002\u0005\u0003\u0002\b\u00055QBAA\u0005\u0015\r\tY![\u0001\u0004CBL\u0017\u0002BA\b\u0003\u0013\u0011q\u0001V5nK>,H/A\u0003wC2,XMH\u0001\u0010\u0003e\"Xm\u001d;GKR\u001c\u0007N\u0012:p[2+\u0017\rZ3s/\"LG.\u001a)sK\u001a,'O]3e%\u0016\fGMU3qY&\u001c\u0017-S:V]\u00064\u0018-\u001b7bE2,GcA+\u0002\u001a!)\u0011l\u0004a\u00015\"\"q\"Z9sQ\u0015yQo_A\u0010Y\tix0A\u000fuKN$h)\u001a;dQ\u001a\u0013x.\u001c$pY2|w/\u001a:XSRD'k\u001c7m)\r)\u0016Q\u0005\u0005\u00063B\u0001\rA\u0017\u0015\u0005!\u0015\f(\u000fK\u0003\u0011kn\fY\u0003\f\u0002~\u007f\u0006QB/Z:u%\u0006\u001c7.Q<be\u0016\u0014\u0016M\\4f\u0003N\u001c\u0018n\u001a8peR\u0019Q+!\r\t\u000be\u000b\u0002\u0019\u0001.)\u0007E\t)\u0004\u0005\u0003\u0002\b\u0005]\u0012\u0002BA\u001d\u0003\u0013\u0011\u0001\u0002R5tC\ndW\r\u001a\u0015\u0005#\u0015\f(\u000fK\u0003\u0012kn\fy\u0004\f\u0002~\u007f\u0006\u0019r-\u001a;Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dC\u0002")
public class FetchFromFollowerIntegrationTest
extends BaseFetchRequestTest {
    private final int numNodes;
    private final int numParts;
    private final String topic;
    private final int leaderBrokerId;
    private final int followerBrokerId;

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public String topic() {
        return this.topic;
    }

    public int leaderBrokerId() {
        return this.leaderBrokerId;
    }

    public int followerBrokerId() {
        return this.followerBrokerId;
    }

    public Properties overridingProps() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.NumPartitionsProp(), Integer.toString(this.numParts()));
        props.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), Integer.toString(this.numNodes()));
        return props;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$12 = this.numNodes();
        String x$2 = this.zkConnectOrNull();
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        boolean x$11 = false;
        boolean x$122 = false;
        Map x$13 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        int x$14 = 1;
        boolean x$15 = false;
        int x$16 = 1;
        short x$17 = 1;
        int x$18 = 0;
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$12, x$2, false, x$5, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$122, (Map<Object, String>)x$13, x$14, x$15, x$16, x$17, x$18, true).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    @Timeout(value=15L)
    public void testFollowerCompleteDelayedFetchesOnReplication(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$22 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        scala.collection.immutable.Map x$5 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.leaderBrokerId(), this.followerBrokerId()})))}));
        int x$6 = 1;
        int x$7 = 1;
        Properties x$8 = new Properties();
        scala.collection.immutable.Map<Object, Object> partitionLeaders = TestUtils$.MODULE$.createTopicWithAdmin(admin, x$22, x$3, x$4, x$6, x$7, (Map<Object, Seq<Object>>)x$5, x$8);
        TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), new TopicPartition(this.topic(), 0), 15000L);
        Assertions.assertTrue((boolean)partitionLeaders.values().forall((Function1)(JFunction1.mcZI.sp & Serializable)x$2 -> x$2 == this.leaderBrokerId()));
        short version = ApiKeys.FETCH.latestVersion();
        TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
        scala.collection.immutable.Map offsetMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)0L))}));
        FetchRequest fetchRequest = this.createConsumerFetchRequest(1000, 1000, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)offsetMap, version, 20000, 1, this.createConsumerFetchRequest$default$8());
        try (Socket socket = this.connect(this.brokerSocketServer(this.followerBrokerId()), this.connect$default$2());){
            this.send((AbstractRequest)fetchRequest, socket, this.send$default$3(), this.send$default$4());
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 1, -1);
            FetchResponse response = (FetchResponse)this.receive(socket, ApiKeys.FETCH, version, ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
            Assertions.assertEquals((Object)Errors.NONE, (Object)response.error());
            Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.NONE), (Object)BoxesRunTime.boxToInteger((int)2))}))).asJava(), (Object)response.errorCounts());
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchFromLeaderWhilePreferredReadReplicaIsUnavailable(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        scala.collection.immutable.Map x$5 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.leaderBrokerId(), this.followerBrokerId()})))}));
        int x$6 = 1;
        int x$7 = 1;
        Properties x$8 = new Properties();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$6, x$7, (Map<Object, Seq<Object>>)x$5, x$8);
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 10, -1);
        Assertions.assertEquals((int)1, (int)this.getPreferredReplica());
        ((KafkaBroker)this.brokers().apply(this.followerBrokerId())).shutdown();
        TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!FetchFromFollowerIntegrationTest.$anonfun$testFetchFromLeaderWhilePreferredReadReplicaIsUnavailable$1(this, topicPartition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)FetchFromFollowerIntegrationTest.$anonfun$testFetchFromLeaderWhilePreferredReadReplicaIsUnavailable$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)-1, (int)this.getPreferredReplica());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchFromFollowerWithRoll(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        scala.collection.immutable.Map x$5 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.leaderBrokerId(), this.followerBrokerId()})))}));
        int x$6 = 1;
        int x$7 = 1;
        Properties x$8 = new Properties();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$6, x$7, (Map<Object, Seq<Object>>)x$5, x$8);
        Properties consumerProps = new Properties();
        consumerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        consumerProps.put("group.id", "test-group");
        consumerProps.put("auto.offset.reset", "earliest");
        consumerProps.put("client.rack", Integer.toString(this.followerBrokerId()));
        try (KafkaConsumer consumer = new KafkaConsumer(consumerProps, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());){
            consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!FetchFromFollowerIntegrationTest.$anonfun$testFetchFromFollowerWithRoll$1(this)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)FetchFromFollowerIntegrationTest.$anonfun$testFetchFromFollowerWithRoll$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 1, -1);
            TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, 15000L);
            ((KafkaBroker)this.brokers().apply(this.followerBrokerId())).shutdown();
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 1, -1);
            TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, 15000L);
            ((KafkaBroker)this.brokers().apply(this.followerBrokerId())).startup();
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!FetchFromFollowerIntegrationTest.$anonfun$testFetchFromFollowerWithRoll$3(this)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)FetchFromFollowerIntegrationTest.$anonfun$testFetchFromFollowerWithRoll$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 1, -1);
            TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, 15000L);
        }
    }

    @Disabled
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testRackAwareRangeAssignor(String quorum) {
        List partitionList = this.brokers().indices().toList();
        String topicWithAllPartitionsOnAllRacks = "topicWithAllPartitionsOnAllRacks";
        this.createTopic(topicWithAllPartitionsOnAllRacks, this.brokers().size(), this.brokers().size(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        String topicWithSingleRackPartitions = "topicWithSingleRackPartitions";
        this.createTopicWithAssignment(topicWithSingleRackPartitions, (Map<Object, Seq<Object>>)partitionList.map((Function1 & Serializable)i -> FetchFromFollowerIntegrationTest.$anonfun$testRackAwareRangeAssignor$1(this, BoxesRunTime.unboxToInt((Object)i))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), this.createTopicWithAssignment$default$3());
        this.consumerConfig().setProperty("partition.assignment.strategy", RangeAssignor.class.getName());
        Buffer consumers = (Buffer)this.brokers().map((Function1 & Serializable)server -> {
            this.consumerConfig().setProperty("auto.offset.reset", "earliest");
            this.consumerConfig().setProperty("client.rack", (String)server.config().rack().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            this.consumerConfig().setProperty("group.instance.id", new StringBuilder(9).append("instance-").append(server.config().brokerId()).toString());
            this.consumerConfig().setProperty("metadata.max.age.ms", "1000");
            return this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        });
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        ExecutorService executor = Executors.newFixedThreadPool(consumers.size());
        try {
            consumers.foreach((Function1 & Serializable)x$3 -> {
                x$3.subscribe(Collections.singleton(topicWithSingleRackPartitions));
                return BoxedUnit.UNIT;
            });
            FetchFromFollowerIntegrationTest.verifyAssignments$1(partitionList.reverse(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicWithSingleRackPartitions}), consumers, executor, producer);
            consumers.foreach((Function1 & Serializable)x$4 -> {
                x$4.subscribe(Collections.singleton(topicWithAllPartitionsOnAllRacks));
                return BoxedUnit.UNIT;
            });
            FetchFromFollowerIntegrationTest.verifyAssignments$1(partitionList, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicWithAllPartitionsOnAllRacks}), consumers, executor, producer);
            consumers.foreach((Function1 & Serializable)x$5 -> {
                x$5.subscribe((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicWithSingleRackPartitions, topicWithAllPartitionsOnAllRacks}))).asJava());
                return BoxedUnit.UNIT;
            });
            FetchFromFollowerIntegrationTest.verifyAssignments$1(partitionList.reverse(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicWithAllPartitionsOnAllRacks, topicWithSingleRackPartitions}), consumers, executor, producer);
            Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
            HashMap reassignments = new HashMap();
            partitionList.foreach((Function1 & Serializable)p -> FetchFromFollowerIntegrationTest.$anonfun$testRackAwareRangeAssignor$18(reassignments, topicWithSingleRackPartitions, BoxesRunTime.unboxToInt((Object)p)));
            admin.alterPartitionReassignments(reassignments).all().get(30L, TimeUnit.SECONDS);
            FetchFromFollowerIntegrationTest.verifyAssignments$1(partitionList, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicWithAllPartitionsOnAllRacks, topicWithSingleRackPartitions}), consumers, executor, producer);
        }
        finally {
            executor.shutdownNow();
        }
    }

    private int getPreferredReplica() {
        TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
        scala.collection.immutable.Map offsetMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)0L))}));
        FetchRequest request = this.createConsumerFetchRequest(1000, 1000, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)offsetMap, ApiKeys.FETCH.latestVersion(), 500, 1, Integer.toString(this.followerBrokerId()));
        FetchResponse response = (FetchResponse)this.connectAndReceive((AbstractRequest)request, ((KafkaBroker)this.brokers().apply(this.leaderBrokerId())).socketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.NONE), (Object)BoxesRunTime.boxToInteger((int)2))}))).asJava(), (Object)response.errorCounts());
        Assertions.assertEquals((int)1, (int)response.data().responses().size());
        FetchResponseData.FetchableTopicResponse topicResponse = (FetchResponseData.FetchableTopicResponse)response.data().responses().get(0);
        Assertions.assertEquals((int)1, (int)topicResponse.partitions().size());
        return ((FetchResponseData.PartitionData)topicResponse.partitions().get(0)).preferredReadReplica();
    }

    public static final /* synthetic */ boolean $anonfun$testFetchFromLeaderWhilePreferredReadReplicaIsUnavailable$1(FetchFromFollowerIntegrationTest $this, TopicPartition topicPartition$1) {
        return !((KafkaBroker)$this.brokers().apply($this.leaderBrokerId())).metadataCache().getPartitionReplicaEndpoints(topicPartition$1, $this.listenerName()).contains((Object)BoxesRunTime.boxToInteger((int)$this.followerBrokerId()));
    }

    public static final /* synthetic */ String $anonfun$testFetchFromLeaderWhilePreferredReadReplicaIsUnavailable$2() {
        return "follower is still reachable.";
    }

    public static final /* synthetic */ boolean $anonfun$testFetchFromFollowerWithRoll$1(FetchFromFollowerIntegrationTest $this) {
        return $this.getPreferredReplica() == 1;
    }

    public static final /* synthetic */ String $anonfun$testFetchFromFollowerWithRoll$2() {
        return "Preferred replica is not set";
    }

    public static final /* synthetic */ boolean $anonfun$testFetchFromFollowerWithRoll$3(FetchFromFollowerIntegrationTest $this) {
        return $this.getPreferredReplica() == 1;
    }

    public static final /* synthetic */ String $anonfun$testFetchFromFollowerWithRoll$4() {
        return "Preferred replica is not set";
    }

    public static final /* synthetic */ Tuple2 $anonfun$testRackAwareRangeAssignor$1(FetchFromFollowerIntegrationTest $this, int i) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.brokers().size() - i - 1})));
    }

    public static final /* synthetic */ scala.collection.immutable.Set $anonfun$testRackAwareRangeAssignor$3(scala.collection.immutable.Seq topics$1, int p) {
        return ((IterableOnceOps)topics$1.map((Function1 & Serializable)topic -> new TopicPartition(topic, p))).toSet();
    }

    public static final /* synthetic */ boolean $anonfun$testRackAwareRangeAssignor$7(Consumer consumer$1, scala.collection.immutable.Set expectedAssignment$1) {
        java.util.Set set = consumer$1.assignment();
        java.util.Set set2 = CollectionConverters$.MODULE$.SetHasAsJava((Set)expectedAssignment$1).asJava();
        return !(set != null ? !((Object)set).equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testRackAwareRangeAssignor$8(scala.collection.immutable.Set expectedAssignment$1, Consumer consumer$1) {
        return new StringBuilder(73).append("Timed out while awaiting expected assignment ").append(expectedAssignment$1).append(". The current assignment is ").append(consumer$1.assignment()).toString();
    }

    public static final /* synthetic */ void $anonfun$testRackAwareRangeAssignor$9(Future future) {
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt(future.get(30L, TimeUnit.SECONDS)));
    }

    public static final /* synthetic */ void $anonfun$testRackAwareRangeAssignor$13(List assignments$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            Future future = (Future)x0$3._1();
            int i = x0$3._2$mcI$sp();
            Seq records = (Seq)future.get(30L, TimeUnit.SECONDS);
            Assertions.assertEquals((Object)assignments$1.apply(i), (Object)((IterableOnceOps)records.map((Function1 & Serializable)r -> new TopicPartition(r.topic(), r.partition()))).toSet());
            return;
        }
        throw new MatchError(null);
    }

    private static final void verifyAssignments$1(List partitionOrder, scala.collection.immutable.Seq topics, Buffer consumers$1, ExecutorService executor$1, KafkaProducer producer$1) {
        List assignments = partitionOrder.map((Function1 & Serializable)p -> FetchFromFollowerIntegrationTest.$anonfun$testRackAwareRangeAssignor$3(topics, BoxesRunTime.unboxToInt((Object)p)));
        ((Buffer)((IterableOps)consumers$1.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Consumer consumer = (Consumer)x0$1._1();
                int i = x0$1._2$mcI$sp();
                return executor$1.submit(() -> {
                    scala.collection.immutable.Set expectedAssignment = (scala.collection.immutable.Set)assignments.apply(i);
                    long pollUntilTrue_waitTimeMs = 30000L;
                    long pollUntilTrue_waitUntilTrue_pause = 0L;
                    long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
                    while (true) {
                        consumer.poll(Duration.ofMillis(100L));
                        if (FetchFromFollowerIntegrationTest.$anonfun$testRackAwareRangeAssignor$7(consumer, expectedAssignment)) break;
                        if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                            Assertions.fail((String)FetchFromFollowerIntegrationTest.$anonfun$testRackAwareRangeAssignor$8(expectedAssignment, consumer));
                        }
                        Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(pollUntilTrue_waitTimeMs), pollUntilTrue_waitUntilTrue_pause));
                    }
                }, BoxesRunTime.boxToInteger((int)0));
            }
            throw new MatchError(null);
        })).foreach((Function1 & Serializable)future -> {
            FetchFromFollowerIntegrationTest.$anonfun$testRackAwareRangeAssignor$9(future);
            return BoxedUnit.UNIT;
        });
        ((List)assignments.flatten(Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable)tp -> producer$1.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), (Object)new StringBuilder(4).append("key-").append(tp).toString().getBytes(), (Object)new StringBuilder(6).append("value-").append(tp).toString().getBytes())));
        ((IterableOnceOps)((Buffer)((IterableOps)consumers$1.zipWithIndex()).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                Consumer consumer = (Consumer)x0$2._1();
                int i = x0$2._2$mcI$sp();
                return executor$1.submit(() -> TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, ((IterableOnceOps)assignments.apply(i)).size(), 30000L));
            }
            throw new MatchError(null);
        })).zipWithIndex()).foreach((Function1 & Serializable)x0$3 -> {
            FetchFromFollowerIntegrationTest.$anonfun$testRackAwareRangeAssignor$13(assignments, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Optional $anonfun$testRackAwareRangeAssignor$18(HashMap reassignments$1, String topicWithSingleRackPartitions$1, int p) {
        NewPartitionReassignment newAssignment = new NewPartitionReassignment(Collections.singletonList(Predef$.MODULE$.int2Integer(p)));
        return reassignments$1.put(new TopicPartition(topicWithSingleRackPartitions$1, p), Optional.of(newAssignment));
    }

    public FetchFromFollowerIntegrationTest() {
        this.numNodes = 2;
        this.numParts = 1;
        this.topic = "test-fetch-from-follower";
        this.leaderBrokerId = 0;
        this.followerBrokerId = 1;
    }
}

