/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import kafka.admin.MyRemoteLogMetadataManager;
import kafka.admin.MyRemoteLogMetadataManager$;
import kafka.admin.MyRemoteStorageManager;
import kafka.admin.MyRemoteStorageManager$;
import kafka.api.IntegrationTestHarness;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.log.remote.storage.NoOpRemoteLogMetadataManager;
import org.apache.kafka.server.log.remote.storage.NoOpRemoteStorageManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichLong$;
import scala.util.Random$;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\t=e\u0001\u0002\u0016,\u0001ABQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013\u0005A\b\u0003\u0004D\u0001\u0001\u0006I!\u0010\u0005\b\t\u0002\u0011\r\u0011\"\u0001=\u0011\u0019)\u0005\u0001)A\u0005{!Ia\t\u0001a\u0001\u0002\u0004%\ta\u0012\u0005\n'\u0002\u0001\r\u00111A\u0005\u0002QC\u0011B\u0017\u0001A\u0002\u0003\u0005\u000b\u0015\u0002%\t\u000fm\u0003\u0001\u0019!C\u00019\"9\u0001\r\u0001a\u0001\n\u0003\t\u0007BB2\u0001A\u0003&Q\fC\u0004e\u0001\u0001\u0007I\u0011A$\t\u000f\u0015\u0004\u0001\u0019!C\u0001M\"1\u0001\u000e\u0001Q!\n!Cq!\u001b\u0001A\u0002\u0013\u0005q\tC\u0004k\u0001\u0001\u0007I\u0011A6\t\r5\u0004\u0001\u0015)\u0003I\u0011\u0015q\u0007\u0001\"\u0015=\u0011\u0015y\u0007\u0001\"\u0015q\u0011\u001d\t\u0019\u0001\u0001C)\u0003\u000bAq!a\u0002\u0001\t\u0003\nI\u0001C\u0004\u0002.\u0001!\t!a\f\t\u000f\u0005\r\u0004\u0001\"\u0001\u0002f!9\u0011q\u000e\u0001\u0005\u0002\u0005E\u0004bBA>\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0003\u000f\u0003A\u0011AAE\u0011\u001d\t\u0019\n\u0001C\u0001\u0003+Cq!a(\u0001\t\u0003\t\t\u000bC\u0004\u0002,\u0002!\t!!,\t\u000f\u0005]\u0006\u0001\"\u0001\u0002:\"9\u00111\u0019\u0001\u0005\u0002\u0005\u0015\u0007bBAh\u0001\u0011\u0005\u0011\u0011\u001b\u0005\b\u00037\u0004A\u0011AAo\u0011\u001d\t9\u000f\u0001C\u0001\u0003SDq!a=\u0001\t\u0003\t)\u0010C\u0004\u0002\u0000\u0002!\tA!\u0001\t\u000f\t-\u0001\u0001\"\u0001\u0003\u000e!9!q\u0003\u0001\u0005\n\te\u0001\"\u0003B/\u0001E\u0005I\u0011\u0002B0\u0011\u001d\u0011)\b\u0001C\u0005\u0005oBqA! \u0001\t\u0013\u0011yHA\nSK6|G/\u001a+pa&\u001c7I];e)\u0016\u001cHO\u0003\u0002-[\u0005)\u0011\rZ7j]*\ta&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\u0004C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b.\u0003\r\t\u0007/[\u0005\u0003mM\u0012a#\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0002\"A\u000f\u0001\u000e\u0003-\nQB\\;n!\u0006\u0014H/\u001b;j_:\u001cX#A\u001f\u0011\u0005y\nU\"A \u000b\u0003\u0001\u000bQa]2bY\u0006L!AQ \u0003\u0007%sG/\u0001\bok6\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002)9,XNU3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\u0003UqW/\u001c*fa2L7-\u0019;j_:4\u0015m\u0019;pe\u0002\nQ\u0002^3tiR{\u0007/[2OC6,W#\u0001%\u0011\u0005%\u0003fB\u0001&O!\tYu(D\u0001M\u0015\tiu&\u0001\u0004=e>|GOP\u0005\u0003\u001f~\na\u0001\u0015:fI\u00164\u0017BA)S\u0005\u0019\u0019FO]5oO*\u0011qjP\u0001\u0012i\u0016\u001cH\u000fV8qS\u000et\u0015-\\3`I\u0015\fHCA+Y!\tqd+\u0003\u0002X\u007f\t!QK\\5u\u0011\u001dIv!!AA\u0002!\u000b1\u0001\u001f\u00132\u00039!Xm\u001d;U_BL7MT1nK\u0002\nqc]=t%\u0016lw\u000e^3Ti>\u0014\u0018mZ3F]\u0006\u0014G.\u001a3\u0016\u0003u\u0003\"A\u00100\n\u0005}{$a\u0002\"p_2,\u0017M\\\u0001\u001cgf\u001c(+Z7pi\u0016\u001cFo\u001c:bO\u0016,e.\u00192mK\u0012|F%Z9\u0015\u0005U\u0013\u0007bB-\u000b\u0003\u0003\u0005\r!X\u0001\u0019gf\u001c(+Z7pi\u0016\u001cFo\u001c:bO\u0016,e.\u00192mK\u0012\u0004\u0013aF:u_J\fw-Z'b]\u0006<WM]\"mCN\u001ch*Y7f\u0003m\u0019Ho\u001c:bO\u0016l\u0015M\\1hKJ\u001cE.Y:t\u001d\u0006lWm\u0018\u0013fcR\u0011Qk\u001a\u0005\b36\t\t\u00111\u0001I\u0003a\u0019Ho\u001c:bO\u0016l\u0015M\\1hKJ\u001cE.Y:t\u001d\u0006lW\rI\u0001\u0019[\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u000ec\u0017m]:OC6,\u0017\u0001H7fi\u0006$\u0017\r^1NC:\fw-\u001a:DY\u0006\u001c8OT1nK~#S-\u001d\u000b\u0003+2Dq!\u0017\t\u0002\u0002\u0003\u0007\u0001*A\rnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s\u00072\f7o\u001d(b[\u0016\u0004\u0013a\u00032s_.,'oQ8v]R\fQ\"\\8eS\u001aL8i\u001c8gS\u001e\u001cHCA+r\u0011\u0015\u00118\u00031\u0001t\u0003\u0015\u0001(o\u001c9t!\r!x/_\u0007\u0002k*\u0011aoP\u0001\u000bG>dG.Z2uS>t\u0017B\u0001=v\u0005\r\u0019V-\u001d\t\u0003u~l\u0011a\u001f\u0006\u0003yv\fA!\u001e;jY*\ta0\u0001\u0003kCZ\f\u0017bAA\u0001w\nQ\u0001K]8qKJ$\u0018.Z:\u0002--\u0014\u0018M\u001a;D_:$(o\u001c7mKJ\u001cuN\u001c4jON$\u0012a]\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0004+\u0006-\u0001bBA\u0007+\u0001\u0007\u0011qB\u0001\u0005S:4w\u000e\u0005\u0003\u0002\u0012\u0005\u0005RBAA\n\u0015\r!\u0014Q\u0003\u0006\u0005\u0003/\tI\"A\u0004kkBLG/\u001a:\u000b\t\u0005m\u0011QD\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u0003?\t1a\u001c:h\u0013\u0011\t\u0019#a\u0005\u0003\u0011Q+7\u000f^%oM>D3!FA\u0014!\u0011\t\t\"!\u000b\n\t\u0005-\u00121\u0003\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017a\u000b;fgR\u001c%/Z1uKJ+Wn\u001c;f)>\u0004\u0018nY,ji\"4\u0016\r\\5e%\u0016$XM\u001c;j_:$\u0016.\\3\u0015\u0007U\u000b\t\u0004\u0003\u0004\u00024Y\u0001\r\u0001S\u0001\u0007cV|'/^7)\u000fY\t9$a\u0011\u0002FA!\u0011\u0011HA \u001b\t\tYD\u0003\u0003\u0002>\u0005U\u0011A\u00029be\u0006l7/\u0003\u0003\u0002B\u0005m\"!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\t\t9%\u0001\u0012|I&\u001c\b\u000f\\1z\u001d\u0006lW- \u0018|CJ<W/\\3oiN<\u0016\u000e\u001e5OC6,7/ \u0015\b-\u0005-\u0013qKA-!\u0011\ti%a\u0015\u000e\u0005\u0005=#\u0002BA)\u0003w\t\u0001\u0002\u001d:pm&$WM]\u0005\u0005\u0003+\nyEA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0005\u00037\ny&\t\u0002\u0002^\u0005\u0011!p[\u0011\u0003\u0003C\nQa\u001b:bMR\f1\u0006^3ti\u000e\u0013X-\u0019;f%\u0016lw\u000e^3U_BL7mV5uQZ\u000bG.\u001b3SKR,g\u000e^5p]NK'0\u001a\u000b\u0004+\u0006\u001d\u0004BBA\u001a/\u0001\u0007\u0001\nK\u0004\u0018\u0003o\t\u0019%!\u0012)\u000f]\tY%a\u0016\u0002n1\"\u00111LA0\u0003Q\"Xm\u001d;De\u0016\fG/\u001a*f[>$X\rV8qS\u000e<\u0016\u000e\u001e5J]\",'/\u001b;fI2{7-\u00197SKR,g\u000e^5p]RKW.\u001a\u000b\u0004+\u0006M\u0004BBA\u001a1\u0001\u0007\u0001\nK\u0004\u0019\u0003o\t\u0019%!\u0012)\u000fa\tY%a\u0016\u0002z1\"\u00111LA0\u0003Q\"Xm\u001d;De\u0016\fG/\u001a*f[>$X\rV8qS\u000e<\u0016\u000e\u001e5J]\",'/\u001b;fI2{7-\u00197SKR,g\u000e^5p]NK'0\u001a\u000b\u0004+\u0006}\u0004BBA\u001a3\u0001\u0007\u0001\nK\u0004\u001a\u0003o\t\u0019%!\u0012)\u000fe\tY%a\u0016\u0002\u00062\"\u00111LA0\u00035\"Xm\u001d;De\u0016\fG/\u001a*f[>$X\rV8qS\u000e<\u0016\u000e\u001e5J]Z\fG.\u001b3SKR,g\u000e^5p]RKW.\u001a\u000b\u0004+\u0006-\u0005BBA\u001a5\u0001\u0007\u0001\nK\u0004\u001b\u0003o\t\u0019%!\u0012)\u000fi\tY%a\u0016\u0002\u00122\"\u00111LA0\u00035\"Xm\u001d;De\u0016\fG/\u001a*f[>$X\rV8qS\u000e<\u0016\u000e\u001e5J]Z\fG.\u001b3SKR,g\u000e^5p]NK'0\u001a\u000b\u0004+\u0006]\u0005BBA\u001a7\u0001\u0007\u0001\nK\u0004\u001c\u0003o\t\u0019%!\u0012)\u000fm\tY%a\u0016\u0002\u001e2\"\u00111LA0\u0003\u0001\"Xm\u001d;De\u0016\fG/Z\"p[B\f7\r^3e%\u0016lw\u000e^3Ti>\u0014\u0018mZ3\u0015\u0007U\u000b\u0019\u000b\u0003\u0004\u00024q\u0001\r\u0001\u0013\u0015\b9\u0005]\u00121IA#Q\u001da\u00121JA,\u0003ScC!a\u0017\u0002`\u00051C/Z:u\u000b:\f'\r\\3SK6|G/\u001a'pO>sW\t_5ti&tw\rV8qS\u000e$Vm\u001d;\u0015\u0007U\u000by\u000b\u0003\u0004\u00024u\u0001\r\u0001\u0013\u0015\b;\u0005]\u00121IA#Q\u001di\u00121JA,\u0003kcC!a\u0017\u0002`\u0005!D/Z:u\u000b:\f'\r\\3SK6|G/\u001a'pO^CWM\\*zgR,WNU3n_R,7\u000b^8sC\u001e,\u0017j\u001d#jg\u0006\u0014G.\u001a3\u0015\u0007U\u000bY\f\u0003\u0004\u00024y\u0001\r\u0001\u0013\u0015\b=\u0005]\u00121IA#Q\u001dq\u00121JA,\u0003\u0003dC!a\u0017\u0002`\u0005yC/Z:u+B$\u0017\r^3U_BL7mQ8oM&<w+\u001b;i-\u0006d\u0017\u000e\u001a*fi\u0016tG/[8o)&lW\rV3tiR\u0019Q+a2\t\r\u0005Mr\u00041\u0001IQ\u001dy\u0012qGA\"\u0003\u000bBsaHA&\u0003/\ni\r\f\u0003\u0002\\\u0005}\u0013a\f;fgR,\u0006\u000fZ1uKR{\u0007/[2D_:4\u0017nZ,ji\"4\u0016\r\\5e%\u0016$XM\u001c;j_:\u001c\u0016N_3UKN$HcA+\u0002T\"1\u00111\u0007\u0011A\u0002!Cs\u0001IA\u001c\u0003\u0007\n)\u0005K\u0004!\u0003\u0017\n9&!7-\t\u0005m\u0013qL\u00015i\u0016\u001cH/\u00169eCR,Gk\u001c9jG\u000e{gNZ5h/&$\b.\u00138iKJLG/\u001a3M_\u000e\fGNU3uK:$\u0018n\u001c8US6,GcA+\u0002`\"1\u00111G\u0011A\u0002!Cs!IA\u001c\u0003\u0007\n)\u0005K\u0004\"\u0003\u0017\n9&!:-\t\u0005m\u0013qL\u00015i\u0016\u001cH/\u00169eCR,Gk\u001c9jG\u000e{gNZ5h/&$\b.\u00138iKJLG/\u001a3M_\u000e\fGNU3uK:$\u0018n\u001c8TSj,GcA+\u0002l\"1\u00111\u0007\u0012A\u0002!CsAIA\u001c\u0003\u0007\n)\u0005K\u0004#\u0003\u0017\n9&!=-\t\u0005m\u0013qL\u0001\u0012i\u0016\u001cH\u000fV8qS\u000e$U\r\\3uS>tGcA+\u0002x\"1\u00111G\u0012A\u0002!CsaIA\u001c\u0003\u0007\n)\u0005K\u0004$\u0003\u0017\n9&!@-\t\u0005m\u0013qL\u0001@i\u0016\u001cHo\u00117vgR,'oV5eK\u0012K7/\u00192mK6,g\u000e^(g)&,'/\u001a3Ti>\u0014\u0018mZ3XSRDWI\\1cY\u0016$G+[3sK\u0012$v\u000e]5d)\r)&1\u0001\u0005\u0007\u0003g!\u0003\u0019\u0001%)\u000f\u0011\n9$a\u0011\u0002F!:A%a\u0013\u0002X\t%A\u0006BA.\u0003?\n1\n^3ti\u000ecWo\u001d;fe^KG\u000f[8viRKWM]3e'R|'/Y4f'R\f'\u000f^:Tk\u000e\u001cWm]:gk2d\u00170\u00134U_BL7mV5uQRKWM]5oO\u0012K7/\u00192mK\u0012$2!\u0016B\b\u0011\u0019\t\u0019$\na\u0001\u0011\":Q%a\u000e\u0002D\u0005\u0015\u0003fB\u0013\u0002L\u0005]#Q\u0003\u0017\u0005\u00037\ny&A\u000bbgN,'\u000f\u001e+ie><8/\u0012=dKB$\u0018n\u001c8\u0015\u0011\tm!Q\u0006B%\u00053\u0002BA!\b\u0003(9!!q\u0004B\u0012\u001d\rY%\u0011E\u0005\u0002\u0001&\u0019!QE \u0002\u000fA\f7m[1hK&!!\u0011\u0006B\u0016\u0005%!\u0006N]8xC\ndWMC\u0002\u0003&}BqAa\f'\u0001\u0004\u0011\t$A\u0007fq\u000e,\u0007\u000f^5p]RK\b/\u001a\u0019\u0005\u0005g\u0011i\u0004E\u0003J\u0005k\u0011I$C\u0002\u00038I\u0013Qa\u00117bgN\u0004BAa\u000f\u0003>1\u0001A\u0001\u0004B \u0005[\t\t\u0011!A\u0003\u0002\t\u0005#aA0%cE!!1\tB\u000e!\rq$QI\u0005\u0004\u0005\u000fz$a\u0002(pi\"Lgn\u001a\u0005\b\u0005\u00172\u0003\u0019\u0001B'\u0003))\u00070Z2vi\u0006\u0014G.\u001a\t\u0005\u0005\u001f\u0012)&\u0004\u0002\u0003R)!!1KA\n\u0003!1WO\\2uS>t\u0017\u0002\u0002B,\u0005#\u0012!\"\u0012=fGV$\u0018M\u00197f\u0011!\u0011YF\nI\u0001\u0002\u0004A\u0015aB7fgN\fw-Z\u0001 CN\u001cXM\u001d;UQJ|wo]#yG\u0016\u0004H/[8oI\u0011,g-Y;mi\u0012\u001aTC\u0001B1U\rA%1M\u0016\u0003\u0005K\u0002BAa\u001a\u0003r5\u0011!\u0011\u000e\u0006\u0005\u0005W\u0012i'A\u0005v]\u000eDWmY6fI*\u0019!qN \u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003t\t%$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Yb/\u001a:jMf\u0014V-\\8uK2{w\rV8qS\u000e\u001cuN\u001c4jON$2!\u0016B=\u0011\u0019\u0011Y\b\u000ba\u0001s\u0006YAo\u001c9jG\u000e{gNZ5h\u00035yg/\u001a:sS\u0012,\u0007K]8qgR\t\u0011\u0010K\u0004\u0001\u0005\u0007\u0013IIa#\u0011\t\u0005E!QQ\u0005\u0005\u0005\u000f\u000b\u0019BA\u0002UC\u001e\fQA^1mk\u0016\f#A!$\u0002\u0017%tG/Z4sCRLwN\u001c")
public class RemoteTopicCrudTest
extends IntegrationTestHarness {
    private final int numPartitions;
    private final int numReplicationFactor;
    private String testTopicName;
    private boolean sysRemoteStorageEnabled = true;
    private String storageManagerClassName = NoOpRemoteStorageManager.class.getName();
    private String metadataManagerClassName = NoOpRemoteLogMetadataManager.class.getName();

    public int numPartitions() {
        return this.numPartitions;
    }

    public int numReplicationFactor() {
        return this.numReplicationFactor;
    }

    public String testTopicName() {
        return this.testTopicName;
    }

    public void testTopicName_$eq(String x$1) {
        this.testTopicName = x$1;
    }

    public boolean sysRemoteStorageEnabled() {
        return this.sysRemoteStorageEnabled;
    }

    public void sysRemoteStorageEnabled_$eq(boolean x$1) {
        this.sysRemoteStorageEnabled = x$1;
    }

    public String storageManagerClassName() {
        return this.storageManagerClassName;
    }

    public void storageManagerClassName_$eq(String x$1) {
        this.storageManagerClassName = x$1;
    }

    public String metadataManagerClassName() {
        return this.metadataManagerClassName;
    }

    public void metadataManagerClassName_$eq(String x$1) {
        this.metadataManagerClassName = x$1;
    }

    @Override
    public int brokerCount() {
        return 2;
    }

    @Override
    public void modifyConfigs(Seq<Properties> props) {
        props.foreach((Function1 & Serializable)p -> {
            p.putAll((java.util.Map<?, ?>)this.overrideProps());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Seq<Properties> kraftControllerConfigs() {
        return new .colon.colon((Object)this.overrideProps(), (List)Nil$.MODULE$);
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo info) {
        if (((Method)info.getTestMethod().get()).getName().endsWith("SystemRemoteStorageIsDisabled")) {
            this.sysRemoteStorageEnabled_$eq(false);
        }
        if (((Method)info.getTestMethod().get()).getName().equals("testTopicDeletion")) {
            this.storageManagerClassName_$eq(MyRemoteStorageManager.class.getName());
            this.metadataManagerClassName_$eq(MyRemoteLogMetadataManager.class.getName());
        }
        super.setUp(info);
        this.testTopicName_$eq(new StringBuilder(1).append(((Method)info.getTestMethod().get()).getName()).append("-").append(Random$.MODULE$.alphanumeric().take(10).mkString()).toString());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateRemoteTopicWithValidRetentionTime(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.ms", "200");
        topicConfig.put("local.retention.ms", "100");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateRemoteTopicWithValidRetentionSize(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.bytes", "512");
        topicConfig.put("local.retention.bytes", "256");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateRemoteTopicWithInheritedLocalRetentionTime(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.ms", "1001");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateRemoteTopicWithInheritedLocalRetentionSize(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.bytes", "1025");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateRemoteTopicWithInvalidRetentionTime(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.ms", "200");
        this.assertThrowsException(InvalidConfigurationException.class, () -> {
            Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
            String x$2 = this.testTopicName();
            Buffer<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            int x$5 = this.numPartitions();
            int x$6 = this.numReplicationFactor();
            Map x$8 = (Map)Map$.MODULE$.empty();
            TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        }, "");
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateRemoteTopicWithInvalidRetentionSize(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.bytes", "512");
        this.assertThrowsException(InvalidConfigurationException.class, () -> {
            Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
            String x$2 = this.testTopicName();
            Buffer<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            int x$5 = this.numPartitions();
            int x$6 = this.numReplicationFactor();
            Map x$8 = (Map)Map$.MODULE$.empty();
            TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        }, "");
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateCompactedRemoteStorage(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("cleanup.policy", "compact");
        this.assertThrowsException(InvalidConfigurationException.class, () -> {
            Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
            String x$2 = this.testTopicName();
            Buffer<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            int x$5 = this.numPartitions();
            int x$6 = this.numReplicationFactor();
            Map x$8 = (Map)Map$.MODULE$.empty();
            TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        }, "");
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testEnableRemoteLogOnExistingTopicTest(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        HashMap<ConfigResource, Set<AlterConfigOp>> configs = new HashMap<ConfigResource, Set<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Collections.singleton(new AlterConfigOp(new ConfigEntry("remote.storage.enable", "true"), AlterConfigOp.OpType.SET)));
        admin.incrementalAlterConfigs(configs).all().get();
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testEnableRemoteLogWhenSystemRemoteStorageIsDisabled(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfigWithRemoteStorage = new Properties();
        topicConfigWithRemoteStorage.put("remote.storage.enable", "true");
        Assertions.assertTrue((boolean)this.assertThrowsException(InvalidConfigurationException.class, () -> {
            Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
            String x$2 = this.testTopicName();
            Buffer<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            int x$5 = this.numPartitions();
            int x$6 = this.numReplicationFactor();
            Map x$8 = (Map)Map$.MODULE$.empty();
            TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfigWithRemoteStorage);
        }, "").getMessage().contains("Tiered Storage functionality is disabled in the broker"));
        TestUtils$.MODULE$.createTopicWithAdmin(admin, this.testTopicName(), this.brokers(), this.controllerServers(), this.numPartitions(), this.numReplicationFactor(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        HashMap<ConfigResource, Set<AlterConfigOp>> configs = new HashMap<ConfigResource, Set<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Collections.singleton(new AlterConfigOp(new ConfigEntry("remote.storage.enable", "true"), AlterConfigOp.OpType.SET)));
        Assertions.assertTrue((boolean)this.assertThrowsException(InvalidConfigurationException.class, () -> admin.incrementalAlterConfigs((java.util.Map)configs).all().get(), "").getMessage().contains("Tiered Storage functionality is disabled in the broker"));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testUpdateTopicConfigWithValidRetentionTimeTest(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Arrays.asList(new AlterConfigOp(new ConfigEntry("retention.ms", "200"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("local.retention.ms", "100"), AlterConfigOp.OpType.SET)));
        admin.incrementalAlterConfigs(configs).all().get();
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testUpdateTopicConfigWithValidRetentionSizeTest(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Arrays.asList(new AlterConfigOp(new ConfigEntry("retention.bytes", "200"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("local.retention.bytes", "100"), AlterConfigOp.OpType.SET)));
        admin.incrementalAlterConfigs(configs).all().get();
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testUpdateTopicConfigWithInheritedLocalRetentionTime(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Arrays.asList(new AlterConfigOp(new ConfigEntry("retention.ms", "200"), AlterConfigOp.OpType.SET)));
        this.assertThrowsException(InvalidConfigurationException.class, () -> admin.incrementalAlterConfigs((java.util.Map)configs).all().get(), "");
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testUpdateTopicConfigWithInheritedLocalRetentionSize(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Arrays.asList(new AlterConfigOp(new ConfigEntry("retention.bytes", "512"), AlterConfigOp.OpType.SET)));
        this.assertThrowsException(InvalidConfigurationException.class, () -> admin.incrementalAlterConfigs((java.util.Map)configs).all().get(), "Invalid local retention size");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTopicDeletion(String quorum) {
        MyRemoteStorageManager$.MODULE$.deleteSegmentEventCounter().set(0);
        int numPartitions = 2;
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.ms", "200");
        topicConfig.put("local.retention.ms", "100");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$6 = this.brokerCount();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, numPartitions, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        TestUtils$.MODULE$.deleteTopicWithAdmin(this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2()), this.testTopicName(), this.brokers(), this.controllerServers());
        this.assertThrowsException(UnknownTopicOrPartitionException.class, () -> TestUtils$.MODULE$.describeTopic(this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2()), this.testTopicName()), "Topic should be deleted");
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!RemoteTopicCrudTest.$anonfun$testTopicDeletion$2(numPartitions)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Remote log segments should be deleted only once by the leader");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testClusterWideDisablementOfTieredStorageWithEnabledTieredTopic(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.setProperty("remote.storage.enable", "true");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.brokerCount();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        Properties tsDisabledProps = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnectOrNull(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).head();
        this.instanceConfigs_$eq((Seq<KafkaConfig>)new .colon.colon((Object)KafkaConfig$.MODULE$.fromProps(tsDisabledProps), (List)Nil$.MODULE$));
        if (this.isKRaftTest()) {
            boolean x$10 = this.recreateBrokers$default$1();
            this.recreateBrokers(x$10, true);
            Assertions.assertTrue((boolean)(this.faultHandler().firstException().getCause() instanceof ConfigException));
            this.faultHandler().setIgnore(true);
            return;
        }
        Assertions.assertThrows(ConfigException.class, () -> {
            boolean x$12 = this.recreateBrokers$default$1();
            this.recreateBrokers(x$12, true);
        });
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testClusterWithoutTieredStorageStartsSuccessfullyIfTopicWithTieringDisabled(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.setProperty("remote.storage.enable", Boolean.toString(false));
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.brokerCount();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        Properties tsDisabledProps = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnectOrNull(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).head();
        this.instanceConfigs_$eq((Seq<KafkaConfig>)new .colon.colon((Object)KafkaConfig$.MODULE$.fromProps(tsDisabledProps), (List)Nil$.MODULE$));
        boolean x$10 = this.recreateBrokers$default$1();
        this.recreateBrokers(x$10, true);
    }

    private Throwable assertThrowsException(Class<? extends Throwable> exceptionType, Executable executable, String message) {
        return Assertions.assertThrows(exceptionType, () -> {
            try {
                executable.execute();
                return;
            }
            catch (ExecutionException executionException) {
                throw executionException.getCause();
            }
        }, (String)message);
    }

    private String assertThrowsException$default$3() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private void verifyRemoteLogTopicConfigs(Properties topicConfig) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!RemoteTopicCrudTest.$anonfun$verifyRemoteLogTopicConfigs$1(this, topicConfig)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteTopicCrudTest.$anonfun$verifyRemoteLogTopicConfigs$3(topicConfig));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private Properties overrideProps() {
        Properties props = new Properties();
        props.put("remote.log.storage.system.enable", Boolean.toString(this.sysRemoteStorageEnabled()));
        props.put("remote.log.storage.manager.class.name", this.storageManagerClassName());
        props.put("remote.log.metadata.manager.class.name", this.metadataManagerClassName());
        props.put(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), "2000");
        props.put("log.local.retention.ms", "1000");
        props.put(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "2048");
        props.put("log.local.retention.bytes", "1024");
        return props;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletion$2(int numPartitions$1) {
        return numPartitions$1 * MyRemoteLogMetadataManager$.MODULE$.segmentCountPerPartition() == MyRemoteStorageManager$.MODULE$.deleteSegmentEventCounter().get();
    }

    public static final /* synthetic */ String $anonfun$testTopicDeletion$3() {
        return "Remote log segments should be deleted only once by the leader";
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemoteLogTopicConfigs$1(RemoteTopicCrudTest $this, Properties topicConfig$4) {
        Buffer logBuffer = (Buffer)$this.brokers().flatMap((Function1 & Serializable)x$2 -> {
            LogManager qual$1 = x$2.logManager();
            TopicPartition x$1 = new TopicPartition($this.testTopicName(), 0);
            boolean x$22 = qual$1.getLog$default$2();
            return qual$1.getLog(x$1, x$22);
        });
        boolean result = logBuffer.nonEmpty();
        if (result) {
            if (topicConfig$4.containsKey("remote.storage.enable")) {
                boolean bl = result = result && StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(topicConfig$4.getProperty("remote.storage.enable"))) == ((UnifiedLog)logBuffer.head()).config().remoteStorageEnable();
            }
            if (topicConfig$4.containsKey("local.retention.bytes")) {
                boolean bl = result = result && StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(topicConfig$4.getProperty("local.retention.bytes"))) == ((UnifiedLog)logBuffer.head()).config().localRetentionBytes();
            }
            if (topicConfig$4.containsKey("local.retention.ms")) {
                boolean bl = result = result && StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(topicConfig$4.getProperty("local.retention.ms"))) == ((UnifiedLog)logBuffer.head()).config().localRetentionMs();
            }
            if (topicConfig$4.containsKey("retention.ms")) {
                boolean bl = result = result && StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(topicConfig$4.getProperty("retention.ms"))) == ((UnifiedLog)logBuffer.head()).config().retentionMs;
            }
            if (topicConfig$4.containsKey("retention.bytes")) {
                result = result && StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(topicConfig$4.getProperty("retention.bytes"))) == ((UnifiedLog)logBuffer.head()).config().retentionSize;
            }
        }
        return result;
    }

    public static final /* synthetic */ String $anonfun$verifyRemoteLogTopicConfigs$3(Properties topicConfig$4) {
        return new StringBuilder(30).append("Failed to update topic config ").append(topicConfig$4).toString();
    }

    public RemoteTopicCrudTest() {
        this.numPartitions = 2;
        this.numReplicationFactor = 2;
    }
}

