/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kafka.api.BaseProducerSendTest;
import kafka.api.PlaintextProducerSendTest$;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.producer.BufferExhaustedException;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ue\u0001B\t\u0013\u0001]AQ\u0001\b\u0001\u0005\u0002uAQa\b\u0001\u0005\u0002\u0001BQ!\u0015\u0001\u0005\u0002ICQa\u0016\u0001\u0005\u0002aCQ!\u001f\u0001\u0005\u0002iDaa \u0001\u0005\u0002\u0005\u0005\u0001bBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003/\u0001A\u0011AA\r\u0011\u001d\tY\u0004\u0001C\u0001\u0003{Aq!a\u0013\u0001\t\u0003\ti\u0005C\u0004\u0002\\\u0001!\t!!\u0018\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u0002j\u001d9\u00111\u000f\n\t\u0002\u0005UdAB\t\u0013\u0011\u0003\t9\b\u0003\u0004\u001d\u001d\u0011\u0005\u0011q\u0010\u0005\b\u0003sqA\u0011AAA\u0005e\u0001F.Y5oi\u0016DH\u000f\u0015:pIV\u001cWM]*f]\u0012$Vm\u001d;\u000b\u0005M!\u0012aA1qS*\tQ#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0002CA\r\u001b\u001b\u0005\u0011\u0012BA\u000e\u0013\u0005Q\u0011\u0015m]3Qe>$WoY3s'\u0016tG\rV3ti\u00061A(\u001b8jiz\"\u0012A\b\t\u00033\u0001\t1\u0003^3ti^\u0013xN\\4TKJL\u0017\r\\5{KJ$\"!I\u0014\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\tUs\u0017\u000e\u001e\u0005\u0006Q\t\u0001\r!K\u0001\u0007cV|'/^7\u0011\u0005)\ndBA\u00160!\ta3%D\u0001.\u0015\tqc#\u0001\u0004=e>|GOP\u0005\u0003a\r\na\u0001\u0015:fI\u00164\u0017B\u0001\u001a4\u0005\u0019\u0019FO]5oO*\u0011\u0001g\t\u0015\u0005\u0005U\n%\t\u0005\u00027\u007f5\tqG\u0003\u00029s\u00051\u0001/\u0019:b[NT!AO\u001e\u0002\u000f),\b/\u001b;fe*\u0011A(P\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002}\u0005\u0019qN]4\n\u0005\u0001;$!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\u0005\u0019\u0015AI>eSN\u0004H.Y=OC6,WPL>be\u001e,X.\u001a8ug^KG\u000f\u001b(b[\u0016\u001cX\u0010\u000b\u0003\u0003\u000b.c\u0005C\u0001$J\u001b\u00059%B\u0001%8\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018B\u0001&H\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\u0012QjT\u0011\u0002\u001d\u0006\u0011!p[\u0011\u0002!\u0006)1N]1gi\u0006\tB/Z:u\u0005\u0006$8\r[*ju\u0016TVM]8\u0015\u0005\u0005\u001a\u0006\"\u0002\u0015\u0004\u0001\u0004I\u0003\u0006B\u00026\u0003\nCCaA#L-2\u0012QjT\u0001(i\u0016\u001cHOQ1uG\"\u001c\u0016N_3[KJ|gj\u001c)beRLG/[8o\u001d>\u0014VmY8sI.+\u0017\u0010\u0006\u0002\"3\")\u0001\u0006\u0002a\u0001S!BAa\u00171bE\u000etw\u000e\u0005\u0002]=6\tQL\u0003\u0002\u0014s%\u0011q,\u0018\u0002\b)&lWm\\;u\u0003\u00151\u0018\r\\;f=\u0005y\u0011\u0001B;oSR$\u0013\u0001Z\u0005\u0003K\u001a\fqaU#D\u001f:#5K\u0003\u0002hQ\u0006AA+[7f+:LGO\u0003\u0002jU\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005-d\u0017\u0001B;uS2T\u0011!\\\u0001\u0005U\u00064\u0018-\u0001\u0006uQJ,\u0017\rZ'pI\u0016$\u0013\u0001]\u0005\u0003cJ\fqbU#Q\u0003J\u000bE+R0U\u0011J+\u0015\t\u0012\u0006\u0003gR\f!\u0002\u00165sK\u0006$Wj\u001c3f\u0015\t)X,A\u0004US6,w.\u001e;)\t\u0011)\u0014I\u0011\u0015\u0005\t\u0015[\u0005\u0010\f\u0002N\u001f\u0006QC/Z:u'\u0016tGmQ8naJ,7o]3e\u001b\u0016\u001c8/Y4f/&$\b\u000eT8h\u0003B\u0004XM\u001c3US6,GCA\u0011|\u0011\u0015AS\u00011\u0001*Q\u0011)Q'\u0011\")\t\u0015)5J \u0017\u0003\u001b>\u000bQ\u0006^3tiN+g\u000e\u001a(p]\u000e{W\u000e\u001d:fgN,G-T3tg\u0006<WmV5uQ2{w-\u00119qK:$G+[7f)\r\t\u00131\u0001\u0005\u0006Q\u0019\u0001\r!\u000b\u0015\u0005\rU\n%\tK\u0003\u0007\u000b.\u000bI\u0001\f\u0002N\u001f\u0006\u0019B/Z:u\u0003V$xn\u0011:fCR,Gk\u001c9jGR\u0019\u0011%a\u0004\t\u000b!:\u0001\u0019A\u0015)\t\u001d)\u0014I\u0011\u0015\u0006\u000f\u0015[\u0015Q\u0003\u0017\u0003\u001b>\u000b!\u0006^3tiN+g\u000eZ,ji\"LeN^1mS\u0012\u0014UMZ8sK\u0006sG-\u00114uKJ$\u0016.\\3ti\u0006l\u0007\u000fF\u0004\"\u00037\ti\"!\t\t\u000b!B\u0001\u0019A\u0015\t\r\u0005}\u0001\u00021\u0001*\u0003YiWm]:bO\u0016$\u0016.\\3Ti\u0006l\u0007oQ8oM&<\u0007bBA\u0012\u0011\u0001\u0007\u0011QE\u0001\u0010e\u0016\u001cwN\u001d3US6,7\u000f^1naB\u0019!%a\n\n\u0007\u0005%2E\u0001\u0003M_:<\u0007\u0006\u0002\u00056\u0003\nCc\u0001CA\u0018A\u0006U\u0002c\u0001$\u00022%\u0019\u00111G$\u0003\u00195+G\u000f[8e'>,(oY3-\u0005\u0005]\u0012EAA\u001d\u0003\u0001\nXo\u001c:v[\u0006sG\rV5nKN$\u0018-\u001c9D_:4\u0017n\u001a)s_ZLG-\u001a:\u0002YQ,7\u000f\u001e,bY&$')\u001a4pe\u0016\fe\u000eZ!gi\u0016\u0014H+[7fgR\fW\u000e]:BiRC'/Z:i_2$GcB\u0011\u0002@\u0005\u0005\u00131\t\u0005\u0006Q%\u0001\r!\u000b\u0005\u0007\u0003?I\u0001\u0019A\u0015\t\u000f\u0005\r\u0012\u00021\u0001\u0002&!\u0012\u0011\"\u000e\u0015\u0007\u0013\u0005=\u0002-!\u0013-\u0005\u0005]\u0012\u0001\r;fgR4\u0016\r\\5e\u0005\u00164wN]3B]\u0012\fe\r^3s)&lWm\u001d;b[B\u001cx+\u001b;iS:$\u0006N]3tQ>dG\rF\u0004\"\u0003\u001f\n\t&a\u0015\t\u000b!R\u0001\u0019A\u0015\t\r\u0005}!\u00021\u0001*\u0011\u001d\t\u0019C\u0003a\u0001\u0003KA#AC\u001b)\r)\ty\u0003YA-Y\t\t9$A\fuKN$hj\u001c8CY>\u001c7.\u001b8h!J|G-^2feR\u0019\u0011%a\u0018\t\u000b!Z\u0001\u0019A\u0015)\t-)\u0014I\u0011\u0015\u0006\u0017\u0015[\u0015Q\r\u0017\u0003\u001b>\u000ba\u0006^3tiN+g\u000e\u001a*fG>\u0014HMQ1uG\"<\u0016\u000e\u001e5NCb\u0014V-];fgR\u001c\u0016N_3B]\u0012D\u0015n\u001a5feR\u0019\u0011%a\u001b\t\u000b!b\u0001\u0019A\u0015)\t1)\u0014I\u0011\u0015\u0006\u0019\u0015[\u0015\u0011\u000f\u0017\u0003\u001b>\u000b\u0011\u0004\u00157bS:$X\r\u001f;Qe>$WoY3s'\u0016tG\rV3tiB\u0011\u0011DD\n\u0004\u001d\u0005e\u0004c\u0001\u0012\u0002|%\u0019\u0011QP\u0012\u0003\r\u0005s\u0017PU3g)\t\t)(\u0006\u0002\u0002\u0004B1\u0011QQAF\u0003\u001fk!!a\"\u000b\u0007\u0005%%.\u0001\u0004tiJ,\u0017-\\\u0005\u0005\u0003\u001b\u000b9I\u0001\u0004TiJ,\u0017-\u001c\t\u0004\r\u0006E\u0015bAAJ\u000f\nI\u0011I]4v[\u0016tGo\u001d")
public class PlaintextProducerSendTest
extends BaseProducerSendTest {
    public static Stream<Arguments> quorumAndTimestampConfigProvider() {
        return PlaintextProducerSendTest$.MODULE$.quorumAndTimestampConfigProvider();
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testWrongSerializer(String quorum) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        producerProps.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        producerProps.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        KafkaProducer<byte[], byte[]> producer = this.registerProducer((KafkaProducer<byte[], byte[]>)new KafkaProducer(producerProps));
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        Assertions.assertThrows(SerializationException.class, () -> producer.send(record));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBatchSizeZero(String quorum) {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, 0, this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        this.sendAndVerify(producer, this.sendAndVerify$default$2(), this.sendAndVerify$default$3());
    }

    @Timeout(value=15L, unit=TimeUnit.SECONDS, threadMode=Timeout.ThreadMode.SEPARATE_THREAD)
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBatchSizeZeroNoPartitionNoRecordKey(String quorum) {
        int x$2 = this.createProducer$default$1();
        int x$3 = this.createProducer$default$2();
        String x$4 = this.createProducer$default$4();
        long x$5 = this.createProducer$default$5();
        long x$6 = this.createProducer$default$6();
        int numRecords = 10;
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(x$2, x$3, 0, x$4, x$5, x$6);){
            TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), this.topic(), this.brokers(), this.controllerServers(), 2, 1, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
            IndexedSeq futures = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numRecords).map((Function1 & Serializable)i -> PlaintextProducerSendTest.$anonfun$testBatchSizeZeroNoPartitionNoRecordKey$1(this, producer, BoxesRunTime.unboxToInt((Object)i)));
            producer.flush();
            int lastOffset = BoxesRunTime.unboxToInt((Object)futures.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(offset, future) -> BoxesRunTime.boxToInteger((int)PlaintextProducerSendTest.$anonfun$testBatchSizeZeroNoPartitionNoRecordKey$2(this, BoxesRunTime.unboxToInt((Object)offset), future))));
            Assertions.assertEquals((int)numRecords, (int)lastOffset);
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSendCompressedMessageWithLogAppendTime(String quorum) {
        int x$4 = this.createProducer$default$3();
        long x$5 = this.createProducer$default$5();
        long x$6 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, x$4, "gzip", x$5, x$6);
        this.sendAndVerifyTimestamp(producer, TimestampType.LOG_APPEND_TIME);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSendNonCompressedMessageWithLogAppendTime(String quorum) {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        this.sendAndVerifyTimestamp(producer, TimestampType.LOG_APPEND_TIME);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAutoCreateTopic(String quorum) {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            ProducerRecord record = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
            Assertions.assertEquals((long)0L, (long)((RecordMetadata)producer.send(record).get()).offset(), (String)"Should have offset 0");
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic(), 0, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @MethodSource(value={"quorumAndTimestampConfigProvider"})
    public void testSendWithInvalidBeforeAndAfterTimestamp(String quorum, String messageTimeStampConfig, long recordTimestamp) {
        Properties topicProps = new Properties();
        long oneMinuteInMs = 3600000L;
        topicProps.setProperty(messageTimeStampConfig, Long.toString(oneMinuteInMs));
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, 1, 2, (Map<Object, Seq<Object>>)x$8, topicProps);
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())).get()).getCause() instanceof InvalidTimestampException));
        }
        int x$10 = this.createProducer$default$1();
        int x$11 = this.createProducer$default$2();
        int x$12 = this.createProducer$default$3();
        long x$13 = this.createProducer$default$5();
        long x$14 = this.createProducer$default$6();
        try (KafkaProducer<byte[], byte[]> compressedProducer = this.createProducer(x$10, x$11, x$12, "gzip", x$13, x$14);){
            Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> compressedProducer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())).get()).getCause() instanceof InvalidTimestampException));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"quorumAndTimestampConfigProvider"})
    public void testValidBeforeAndAfterTimestampsAtThreshold(String quorum, String messageTimeStampConfig, long recordTimestamp) {
        Properties topicProps = new Properties();
        topicProps.setProperty(messageTimeStampConfig, Long.toString(recordTimestamp));
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, 1, 2, (Map<Object, Seq<Object>>)x$8, topicProps);
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        Assertions.assertDoesNotThrow(() -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())));
        producer.close();
        int x$10 = this.createProducer$default$1();
        int x$11 = this.createProducer$default$2();
        int x$12 = this.createProducer$default$3();
        long x$13 = this.createProducer$default$5();
        long x$14 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> compressedProducer = this.createProducer(x$10, x$11, x$12, "gzip", x$13, x$14);
        Assertions.assertDoesNotThrow(() -> compressedProducer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())));
        compressedProducer.close();
    }

    @ParameterizedTest
    @MethodSource(value={"quorumAndTimestampConfigProvider"})
    public void testValidBeforeAndAfterTimestampsWithinThreshold(String quorum, String messageTimeStampConfig, long recordTimestamp) {
        Properties topicProps = new Properties();
        long tenMinutesInMs = 36000000L;
        topicProps.setProperty(messageTimeStampConfig, Long.toString(tenMinutesInMs));
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, 1, 2, (Map<Object, Seq<Object>>)x$8, topicProps);
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        Assertions.assertDoesNotThrow(() -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())));
        producer.close();
        int x$10 = this.createProducer$default$1();
        int x$11 = this.createProducer$default$2();
        int x$12 = this.createProducer$default$3();
        long x$13 = this.createProducer$default$5();
        long x$14 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> compressedProducer = this.createProducer(x$10, x$11, x$12, "gzip", x$13, x$14);
        Assertions.assertDoesNotThrow(() -> compressedProducer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())));
        compressedProducer.close();
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testNonBlockingProducer(String quorum) {
        int x$2 = this.createProducer$default$1();
        int x$3 = this.createProducer$default$2();
        int x$4 = this.createProducer$default$3();
        String x$5 = this.createProducer$default$4();
        long x$6 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$2, x$3, x$4, x$5, 0L, x$6);
        PlaintextProducerSendTest.verifyMetadataNotAvailable$1(this.send$1(producer));
        Future future = this.sendUntilQueued$1(producer);
        this.verifySendSuccess$1(future);
        int x$11 = this.createProducer$default$2();
        String x$12 = this.createProducer$default$4();
        KafkaProducer<byte[], byte[]> producer2 = this.createProducer(15000, x$11, 1100, x$12, 0L, 1500L);
        Future future2 = this.sendUntilQueued$1(producer2);
        PlaintextProducerSendTest.verifyBufferExhausted$1(this.send$1(producer2));
        this.verifySendSuccess$1(future2);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSendRecordBatchWithMaxRequestSizeAndHigher(String quorum) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        KafkaProducer<byte[], byte[]> producer = this.registerProducer((KafkaProducer<byte[], byte[]>)new KafkaProducer(producerProps, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer()));
        int keyLengthSize = 1;
        int headerLengthSize = 1;
        int valueLengthSize = 3;
        int overhead = 94 + keyLengthSize + headerLengthSize + valueLengthSize;
        int valueSize = 0x10000C - overhead;
        ProducerRecord record0 = new ProducerRecord(this.topic(), (Object)new byte[0], (Object)new byte[valueSize]);
        Assertions.assertEquals((int)((byte[])record0.value()).length, (int)((RecordMetadata)producer.send(record0).get()).serializedValueSize());
        ProducerRecord record1 = new ProducerRecord(this.topic(), (Object)new byte[0], (Object)new byte[valueSize + 1]);
        Assertions.assertEquals(RecordTooLargeException.class, Assertions.assertThrows(ExecutionException.class, () -> producer.send(record1).get()).getCause().getClass());
    }

    public static final /* synthetic */ Future $anonfun$testBatchSizeZeroNoPartitionNoRecordKey$1(PlaintextProducerSendTest $this, KafkaProducer producer$2, int i) {
        ProducerRecord record = new ProducerRecord($this.topic(), null, (Object)new StringBuilder(5).append("value").append(i).toString().getBytes(StandardCharsets.UTF_8));
        return producer$2.send(record);
    }

    public static final /* synthetic */ int $anonfun$testBatchSizeZeroNoPartitionNoRecordKey$2(PlaintextProducerSendTest $this, int offset, Future future) {
        RecordMetadata recordMetadata = (RecordMetadata)future.get();
        Assertions.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
        return offset + 1;
    }

    private final Future send$1(KafkaProducer producer) {
        return producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)new byte[1000]));
    }

    public static final /* synthetic */ boolean $anonfun$testNonBlockingProducer$2(Future future) {
        if (future.isDone()) {
            try {
                future.get();
                return true;
            }
            catch (ExecutionException executionException) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final Future sendUntilQueued$1(KafkaProducer producer) {
        void var3_7;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            Future computeUntilTrue_result;
            if (PlaintextProducerSendTest.$anonfun$testNonBlockingProducer$2(computeUntilTrue_result = this.send$1(producer))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var10_5 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Future future = (Future)tuple22._1();
        return var3_7;
    }

    private final void verifySendSuccess$1(Future future) {
        RecordMetadata recordMetadata = (RecordMetadata)future.get(30L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)this.topic(), (Object)recordMetadata.topic());
        Assertions.assertEquals((int)0, (int)recordMetadata.partition());
        Assertions.assertTrue((recordMetadata.offset() >= 0L ? 1 : 0) != 0, (String)new StringBuilder(15).append("Invalid offset ").append(recordMetadata).toString());
    }

    private static final void verifyMetadataNotAvailable$1(Future future) {
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals(TimeoutException.class, Assertions.assertThrows(ExecutionException.class, () -> future.get()).getCause().getClass());
    }

    private static final void verifyBufferExhausted$1(Future future) {
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals(BufferExhaustedException.class, Assertions.assertThrows(ExecutionException.class, () -> future.get()).getCause().getClass());
    }

    public static final /* synthetic */ Object $anonfun$testNonBlockingProducer$2$adapted(Future future) {
        return BoxesRunTime.boxToBoolean((boolean)PlaintextProducerSendTest.$anonfun$testNonBlockingProducer$2(future));
    }
}

