/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.cluster.AbstractPartitionTest$;
import kafka.cluster.AlterPartitionListener;
import kafka.cluster.DelayedOperations;
import kafka.cluster.Partition;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.AlterPartitionManager;
import kafka.server.Defaults$;
import kafka.server.MetadataCache;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tUs!\u0002\u001c8\u0011\u0003ad!\u0002 8\u0011\u0003y\u0004\"\u0002$\u0002\t\u00039\u0005b\u0002%\u0002\u0005\u0004%\t!\u0013\u0005\u0007\u001b\u0006\u0001\u000b\u0011\u0002&\u0007\ty:\u0004A\u0014\u0005\u0006\r\u0016!\ta\u0014\u0005\b\u0011\u0016\u0011\r\u0011\"\u0001J\u0011\u0019iU\u0001)A\u0005\u0015\"9\u0011+\u0002b\u0001\n\u0003I\u0005B\u0002*\u0006A\u0003%!\nC\u0004T\u000b\t\u0007I\u0011\u0001+\t\r\u0001,\u0001\u0015!\u0003V\u0011\u001d\tWA1A\u0005\u0002\tDaa[\u0003!\u0002\u0013\u0019\u0007\"\u00037\u0006\u0001\u0004\u0005\r\u0011\"\u0001n\u0011%1X\u00011AA\u0002\u0013\u0005q\u000fC\u0005~\u000b\u0001\u0007\t\u0011)Q\u0005]\"Ia0\u0002a\u0001\u0002\u0004%\t!\u001c\u0005\u000b\u007f\u0016\u0001\r\u00111A\u0005\u0002\u0005\u0005\u0001BCA\u0003\u000b\u0001\u0007\t\u0011)Q\u0005]\"Q\u0011qA\u0003A\u0002\u0003\u0007I\u0011A7\t\u0017\u0005%Q\u00011AA\u0002\u0013\u0005\u00111\u0002\u0005\u000b\u0003\u001f)\u0001\u0019!A!B\u0013q\u0007bCA\t\u000b\u0001\u0007\t\u0019!C\u0001\u0003'A1\"!\t\u0006\u0001\u0004\u0005\r\u0011\"\u0001\u0002$!Y\u0011qE\u0003A\u0002\u0003\u0005\u000b\u0015BA\u000b\u0011-\tI#\u0002a\u0001\u0002\u0004%\t!a\u000b\t\u0017\u00055S\u00011AA\u0002\u0013\u0005\u0011q\n\u0005\f\u0003'*\u0001\u0019!A!B\u0013\ti\u0003C\u0006\u0002V\u0015\u0001\r\u00111A\u0005\u0002\u0005]\u0003bCA0\u000b\u0001\u0007\t\u0019!C\u0001\u0003CB1\"!\u001a\u0006\u0001\u0004\u0005\t\u0015)\u0003\u0002Z!Y\u0011qM\u0003A\u0002\u0003\u0007I\u0011AA5\u0011-\ti(\u0002a\u0001\u0002\u0004%\t!a \t\u0017\u0005\rU\u00011A\u0001B\u0003&\u00111\u000e\u0005\f\u0003\u000b+\u0001\u0019!a\u0001\n\u0003\t9\tC\u0006\u0002\u0018\u0016\u0001\r\u00111A\u0005\u0002\u0005e\u0005bCAO\u000b\u0001\u0007\t\u0011)Q\u0005\u0003\u0013C\u0011\"a(\u0006\u0005\u0004%\t!!)\t\u0011\u0005%V\u0001)A\u0005\u0003GC\u0011\"a+\u0006\u0005\u0004%\t!!,\t\u0011\u0005]V\u0001)A\u0005\u0003_C\u0011\"!/\u0006\u0005\u0004%\t!a/\t\u0011\u0005%W\u0001)A\u0005\u0003{C1\"a3\u0006\u0001\u0004\u0005\r\u0011\"\u0001\u0002N\"Y\u0011Q[\u0003A\u0002\u0003\u0007I\u0011AAl\u0011-\tY.\u0002a\u0001\u0002\u0003\u0006K!a4\t\u000f\u0005uW\u0001\"\u0001\u0002`\"9\u0011q_\u0003\u0005\u0012\u0005e\bb\u0002B\u0003\u000b\u0011\u0005!q\u0001\u0005\b\u0005[)A\u0011AAp\u0011\u001d\u00119$\u0002C\t\u0005sAqA!\u0013\u0006\t\u0003\u0011Y%A\u000bBEN$(/Y2u!\u0006\u0014H/\u001b;j_:$Vm\u001d;\u000b\u0005aJ\u0014aB2mkN$XM\u001d\u0006\u0002u\u0005)1.\u00194lC\u000e\u0001\u0001CA\u001f\u0002\u001b\u00059$!F!cgR\u0014\u0018m\u0019;QCJ$\u0018\u000e^5p]R+7\u000f^\n\u0003\u0003\u0001\u0003\"!\u0011#\u000e\u0003\tS\u0011aQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000b\n\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001=\u0003!\u0011'o\\6fe&#W#\u0001&\u0011\u0005\u0005[\u0015B\u0001'C\u0005\rIe\u000e^\u0001\nEJ|7.\u001a:JI\u0002\u001a\"!\u0002!\u0015\u0003A\u0003\"!P\u0003\u0002\u001fI,Wn\u001c;f%\u0016\u0004H.[2b\u0013\u0012\f\u0001C]3n_R,'+\u001a9mS\u000e\f\u0017\n\u001a\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\tQ\u000b\u0005\u0002W=6\tqK\u0003\u0002Y3\u000611m\\7n_:T!A\u000f.\u000b\u0005mc\u0016AB1qC\u000eDWMC\u0001^\u0003\ry'oZ\u0005\u0003?^\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bu_BL7\rU1si&$\u0018n\u001c8!\u0003\u0011!\u0018.\\3\u0016\u0003\r\u0004\"\u0001Z5\u000e\u0003\u0015T!AZ4\u0002\tU$\u0018\u000e\u001c\u0006\u0003Qf\u000baa]3sm\u0016\u0014\u0018B\u00016f\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013A\u0002;na\u0012K'/F\u0001o!\tyG/D\u0001q\u0015\t\t(/\u0001\u0002j_*\t1/\u0001\u0003kCZ\f\u0017BA;q\u0005\u00111\u0015\u000e\\3\u0002\u0015Ql\u0007\u000fR5s?\u0012*\u0017\u000f\u0006\u0002ywB\u0011\u0011)_\u0005\u0003u\n\u0013A!\u00168ji\"9A\u0010EA\u0001\u0002\u0004q\u0017a\u0001=%c\u00059A/\u001c9ESJ\u0004\u0013a\u00027pO\u0012K'/M\u0001\fY><G)\u001b:2?\u0012*\u0017\u000fF\u0002y\u0003\u0007Aq\u0001`\n\u0002\u0002\u0003\u0007a.\u0001\u0005m_\u001e$\u0015N]\u0019!\u0003\u001dawn\u001a#jeJ\n1\u0002\\8h\t&\u0014(g\u0018\u0013fcR\u0019\u00010!\u0004\t\u000fq4\u0012\u0011!a\u0001]\u0006AAn\\4ESJ\u0014\u0004%\u0001\u0006m_\u001el\u0015M\\1hKJ,\"!!\u0006\u0011\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007:\u0003\rawnZ\u0005\u0005\u0003?\tIB\u0001\u0006M_\u001el\u0015M\\1hKJ\fa\u0002\\8h\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000fF\u0002y\u0003KA\u0001\u0002`\r\u0002\u0002\u0003\u0007\u0011QC\u0001\fY><W*\u00198bO\u0016\u0014\b%A\u000bbYR,'\u000fU1si&$\u0018n\u001c8NC:\fw-\u001a:\u0016\u0005\u00055\u0002\u0003BA\u0018\u0003\u000frA!!\r\u0002B9!\u00111GA\u001f\u001d\u0011\t)$a\u000f\u000e\u0005\u0005]\"bAA\u001dw\u00051AH]8pizJ\u0011AO\u0005\u0004\u0003\u007fI\u0014!B;uS2\u001c\u0018\u0002BA\"\u0003\u000b\n\u0011\u0002V3tiV#\u0018\u000e\\:\u000b\u0007\u0005}\u0012(\u0003\u0003\u0002J\u0005-#!G'pG.\fE\u000e^3s!\u0006\u0014H/\u001b;j_:l\u0015M\\1hKJTA!a\u0011\u0002F\u0005I\u0012\r\u001c;feB\u000b'\u000f^5uS>tW*\u00198bO\u0016\u0014x\fJ3r)\rA\u0018\u0011\u000b\u0005\tyr\t\t\u00111\u0001\u0002.\u00051\u0012\r\u001c;feB\u000b'\u000f^5uS>tW*\u00198bO\u0016\u0014\b%\u0001\fbYR,'\u000fU1si&$\u0018n\u001c8MSN$XM\\3s+\t\tI\u0006\u0005\u0003\u00020\u0005m\u0013\u0002BA/\u0003\u0017\u0012!$T8dW\u0006cG/\u001a:QCJ$\u0018\u000e^5p]2K7\u000f^3oKJ\f!$\u00197uKJ\u0004\u0016M\u001d;ji&|g\u000eT5ti\u0016tWM]0%KF$2\u0001_A2\u0011!ax$!AA\u0002\u0005e\u0013aF1mi\u0016\u0014\b+\u0019:uSRLwN\u001c'jgR,g.\u001a:!\u0003%awnZ\"p]\u001aLw-\u0006\u0002\u0002lA!\u0011QNA=\u001b\t\tyG\u0003\u0003\u0002\u001c\u0005E$\u0002BA:\u0003k\n\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0007\u0005]\u0014,A\u0004ti>\u0014\u0018mZ3\n\t\u0005m\u0014q\u000e\u0002\n\u0019><7i\u001c8gS\u001e\fQ\u0002\\8h\u0007>tg-[4`I\u0015\fHc\u0001=\u0002\u0002\"AAPIA\u0001\u0002\u0004\tY'\u0001\u0006m_\u001e\u001cuN\u001c4jO\u0002\n\u0001cY8oM&<'+\u001a9pg&$xN]=\u0016\u0005\u0005%\u0005\u0003BAF\u0003'k!!!$\u000b\t\u0005=\u0015\u0011S\u0001\t[\u0016$\u0018\rZ1uC*\u0011\u0001.O\u0005\u0005\u0003+\u000biI\u0001\u000bN_\u000e\\7i\u001c8gS\u001e\u0014V\r]8tSR|'/_\u0001\u0015G>tg-[4SKB|7/\u001b;pef|F%Z9\u0015\u0007a\fY\n\u0003\u0005}K\u0005\u0005\t\u0019AAE\u0003E\u0019wN\u001c4jOJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0012I\u0016d\u0017-_3e\u001fB,'/\u0019;j_:\u001cXCAAR!\ri\u0014QU\u0005\u0004\u0003O;$!\u0005#fY\u0006LX\rZ(qKJ\fG/[8og\u0006\u0011B-\u001a7bs\u0016$w\n]3sCRLwN\\:!\u00035iW\r^1eCR\f7)Y2iKV\u0011\u0011q\u0016\t\u0005\u0003c\u000b\u0019,\u0004\u0002\u0002\u0012&!\u0011QWAI\u00055iU\r^1eCR\f7)Y2iK\u0006qQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004\u0013!E8gMN,Go\u00115fG.\u0004x.\u001b8ugV\u0011\u0011Q\u0018\t\u0005\u0003\u007f\u000b)-\u0004\u0002\u0002B*!\u00111YAI\u0003-\u0019\u0007.Z2la>Lg\u000e^:\n\t\u0005\u001d\u0017\u0011\u0019\u0002\u0012\u001f\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]R\u001c\u0018AE8gMN,Go\u00115fG.\u0004x.\u001b8ug\u0002\n\u0011\u0002]1si&$\u0018n\u001c8\u0016\u0005\u0005=\u0007cA\u001f\u0002R&\u0019\u00111[\u001c\u0003\u0013A\u000b'\u000f^5uS>t\u0017!\u00049beRLG/[8o?\u0012*\u0017\u000fF\u0002y\u00033D\u0001\u0002 \u0018\u0002\u0002\u0003\u0007\u0011qZ\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0013!B:fiV\u0004H#\u0001=)\u0007A\n\u0019\u000f\u0005\u0003\u0002f\u0006MXBAAt\u0015\u0011\tI/a;\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002n\u0006=\u0018a\u00026va&$XM\u001d\u0006\u0004\u0003cd\u0016!\u00026v]&$\u0018\u0002BA{\u0003O\u0014!BQ3g_J,W)Y2i\u0003iIg\u000e^3s\u0005J|7.\u001a:Qe>$xnY8m-\u0016\u00148/[8o+\t\tY\u0010\u0005\u0003\u0002~\n\u0005QBAA\u0000\u0015\tAv-\u0003\u0003\u0003\u0004\u0005}(aD'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u0002'\r\u0014X-\u0019;f\u0019><\u0007K]8qKJ$\u0018.Z:\u0015\t\t%!1\u0003\t\u0005\u0005\u0017\u0011y!\u0004\u0002\u0003\u000e)\u0011aM]\u0005\u0005\u0005#\u0011iA\u0001\u0006Qe>\u0004XM\u001d;jKNDqA!\u00063\u0001\u0004\u00119\"A\u0005pm\u0016\u0014(/\u001b3fgBA!\u0011\u0004B\u0011\u0005O\u00119C\u0004\u0003\u0003\u001c\tu\u0001cAA\u001b\u0005&\u0019!q\u0004\"\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011\u0019C!\n\u0003\u00075\u000b\u0007OC\u0002\u0003 \t\u0003BA!\u0007\u0003*%!!1\u0006B\u0013\u0005\u0019\u0019FO]5oO\u0006AA/Z1s\t><h\u000eK\u00024\u0005c\u0001B!!:\u00034%!!QGAt\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\ftKR,\b\u000fU1si&$\u0018n\u001c8XSRDWj\\2lgR1\u0011q\u001aB\u001e\u0005\u007fAaA!\u00105\u0001\u0004Q\u0015a\u00037fC\u0012,'/\u00129pG\"DqA!\u00115\u0001\u0004\u0011\u0019%\u0001\u0005jg2+\u0017\rZ3s!\r\t%QI\u0005\u0004\u0005\u000f\u0012%a\u0002\"p_2,\u0017M\\\u0001\u0013I\u00164\u0017-\u001e7u\u0005J|7.\u001a:Fa>\u001c\u0007\u000e\u0006\u0003\u0003N\tM\u0003cA!\u0003P%\u0019!\u0011\u000b\"\u0003\t1{gn\u001a\u0005\u0006\u0011V\u0002\rA\u0013")
public class AbstractPartitionTest {
    private final int brokerId = AbstractPartitionTest$.MODULE$.brokerId();
    private final int remoteReplicaId = this.brokerId() + 1;
    private final TopicPartition topicPartition = new TopicPartition("test-topic", 0);
    private final MockTime time = new MockTime();
    private File tmpDir;
    private File logDir1;
    private File logDir2;
    private LogManager logManager;
    private TestUtils.MockAlterPartitionManager alterPartitionManager;
    private TestUtils.MockAlterPartitionListener alterPartitionListener;
    private LogConfig logConfig;
    private MockConfigRepository configRepository;
    private final DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
    private Partition partition;

    public int brokerId() {
        return this.brokerId;
    }

    public int remoteReplicaId() {
        return this.remoteReplicaId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public MockTime time() {
        return this.time;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir1() {
        return this.logDir1;
    }

    public void logDir1_$eq(File x$1) {
        this.logDir1 = x$1;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public void logDir2_$eq(File x$1) {
        this.logDir2 = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public TestUtils.MockAlterPartitionManager alterPartitionManager() {
        return this.alterPartitionManager;
    }

    public void alterPartitionManager_$eq(TestUtils.MockAlterPartitionManager x$1) {
        this.alterPartitionManager = x$1;
    }

    public TestUtils.MockAlterPartitionListener alterPartitionListener() {
        return this.alterPartitionListener;
    }

    public void alterPartitionListener_$eq(TestUtils.MockAlterPartitionListener x$1) {
        this.alterPartitionListener = x$1;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public void logConfig_$eq(LogConfig x$1) {
        this.logConfig = x$1;
    }

    public MockConfigRepository configRepository() {
        return this.configRepository;
    }

    public void configRepository_$eq(MockConfigRepository x$1) {
        this.configRepository = x$1;
    }

    public DelayedOperations delayedOperations() {
        return this.delayedOperations;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public OffsetCheckpoints offsetCheckpoints() {
        return this.offsetCheckpoints;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    @BeforeEach
    public void setup() {
        TestUtils$.MODULE$.clearYammerMetrics();
        Properties logProps = this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        this.logConfig_$eq(new LogConfig((Map)logProps));
        this.configRepository_$eq(MockConfigRepository$.MODULE$.forTopic(this.topicPartition().topic(), logProps));
        this.tmpDir_$eq(TestUtils.tempDirectory(null, null));
        this.logDir1_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        this.logDir2_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        .colon.colon x$1 = new .colon.colon((Object)this.logDir1(), (List)new .colon.colon((Object)this.logDir2(), (List)Nil$.MODULE$));
        LogConfig x$2 = this.logConfig();
        MockConfigRepository x$3 = this.configRepository();
        CleanerConfig x$4 = new CleanerConfig(false);
        MockTime x$5 = this.time();
        MetadataVersion x$6 = this.interBrokerProtocolVersion();
        int x$8 = 4;
        None$ x$9 = None$.MODULE$;
        boolean x$10 = false;
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)x$1, x$2, x$3, x$4, x$5, x$6, x$8, true, (Option<UnifiedLog>)x$9, x$10));
        LogManager qual$1 = this.logManager();
        scala.collection.immutable.Set x$11 = Predef$.MODULE$.Set().empty();
        Function1 x$12 = qual$1.startup$default$2();
        qual$1.startup((Set)x$11, x$12);
        this.alterPartitionManager_$eq(new TestUtils.MockAlterPartitionManager());
        this.alterPartitionListener_$eq(new TestUtils.MockAlterPartitionListener());
        this.partition_$eq(new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), this.interBrokerProtocolVersion(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> this.defaultBrokerEpoch(this.brokerId()), (Time)this.time(), (AlterPartitionListener)this.alterPartitionListener(), this.delayedOperations(), this.metadataCache(), this.logManager(), (AlterPartitionManager)this.alterPartitionManager(), (Option)None$.MODULE$));
        Mockito.when((Object)this.offsetCheckpoints().fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()))).thenReturn((Object)None$.MODULE$);
    }

    public MetadataVersion interBrokerProtocolVersion() {
        return MetadataVersion.latestTesting();
    }

    public Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(512));
        logProps.put("segment.index.bytes", Predef$.MODULE$.int2Integer(1000));
        logProps.put("retention.ms", Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return logProps.put(k, v);
            }
            throw new MatchError(null);
        });
        return logProps;
    }

    @AfterEach
    public void tearDown() {
        if (this.tmpDir().exists()) {
            LogManager qual$1 = this.logManager();
            long x$1 = qual$1.shutdown$default$1();
            qual$1.shutdown(x$1);
            Utils.delete((File)this.tmpDir());
            TestUtils$.MODULE$.clearYammerMetrics();
            return;
        }
    }

    public Partition setupPartitionWithMocks(int leaderEpoch, boolean isLeader) {
        Partition qual$1 = this.partition();
        OffsetCheckpoints x$3 = this.offsetCheckpoints();
        None$ x$4 = None$.MODULE$;
        Option x$5 = qual$1.createLogIfNotExists$default$5();
        qual$1.createLogIfNotExists(false, false, x$3, (Option)x$4, x$5);
        int controllerEpoch = 0;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava();
        if (isLeader) {
            Partition qual$2 = this.partition();
            LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$6 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setPartitionEpoch(1).setReplicas(replicas).setIsNew(true);
            OffsetCheckpoints x$7 = this.offsetCheckpoints();
            None$ x$8 = None$.MODULE$;
            Option x$9 = qual$2.makeLeader$default$4();
            Assertions.assertTrue((boolean)qual$2.makeLeader(x$6, x$7, (Option)x$8, x$9), (String)"Expected become leader transition to succeed");
            Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch());
        } else {
            Partition qual$3 = this.partition();
            LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$10 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.remoteReplicaId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setPartitionEpoch(1).setReplicas(replicas).setIsNew(true);
            OffsetCheckpoints x$11 = this.offsetCheckpoints();
            None$ x$12 = None$.MODULE$;
            Option x$13 = qual$3.makeFollower$default$4();
            Assertions.assertTrue((boolean)qual$3.makeFollower(x$10, x$11, (Option)x$12, x$13), (String)"Expected become follower transition to succeed");
            Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch());
            Assertions.assertEquals((Object)None$.MODULE$, (Object)this.partition().leaderLogIfLocal());
        }
        return this.partition();
    }

    public long defaultBrokerEpoch(int brokerId) {
        return (long)brokerId + 1000L;
    }
}

