/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import java.util.OptionalLong;
import kafka.log.LogTestUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpointFile;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.BatchMetadata;
import org.apache.kafka.storage.internals.log.EpochEntry;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegmentOffsetOverflowException;
import org.apache.kafka.storage.internals.log.ProducerStateEntry;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.RollParams;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t]g\u0001\u0002\u00180\u0001QBQa\u000f\u0001\u0005\u0002qBqa\u0010\u0001C\u0002\u0013%\u0001\t\u0003\u0004M\u0001\u0001\u0006I!\u0011\u0005\b\u001b\u0002\u0011\r\u0011\"\u0003O\u0011\u0019\u0001\u0007\u0001)A\u0005\u001f\"I\u0011\r\u0001a\u0001\u0002\u0004%IA\u0019\u0005\nW\u0002\u0001\r\u00111A\u0005\n1D\u0011B\u001d\u0001A\u0002\u0003\u0005\u000b\u0015B2\t\u000bM\u0004A\u0011\u0001;\t\u0013\u0005=\u0001!%A\u0005\u0002\u0005E\u0001\"CA\u0014\u0001E\u0005I\u0011AA\u0015\u0011\u001d\ti\u0003\u0001C\u0001\u0003_Aq!!\u0018\u0001\t\u0003\ty\u0006C\u0004\u0002x\u0001!\t!a\u0018\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002\u0004\"9\u0011\u0011\u001a\u0001\u0005\u0002\u0005}\u0003bBAj\u0001\u0011\u0005\u0011q\f\u0005\b\u0003/\u0004A\u0011AA0\u0011\u001d\tY\u000e\u0001C\u0001\u0003?Bq!a8\u0001\t\u0003\t\t\u000fC\u0004\u0003\u0006\u0001!\t!a\u0018\t\u000f\t%\u0001\u0001\"\u0001\u0002`!9!Q\u0002\u0001\u0005\u0002\u0005}\u0003b\u0002B\t\u0001\u0011\u0005\u0011q\f\u0005\b\u0005+\u0001A\u0011AA0\u0011\u001d\u0011I\u0002\u0001C\u0001\u0003?BqA!\b\u0001\t\u0003\ty\u0006C\u0004\u0003\"\u0001!\t!a\u0018\t\u000f\t\u0015\u0002\u0001\"\u0001\u0002`!9!\u0011\u0006\u0001\u0005\u0002\u0005}\u0003b\u0002B\u0017\u0001\u0011%!q\u0006\u0005\n\u0005/\u0002\u0011\u0013!C\u0005\u0003#A\u0011B!\u0017\u0001#\u0003%I!!\u0005\t\u0013\tm\u0003!%A\u0005\n\tu\u0003b\u0002B1\u0001\u0011\u0005\u0011q\f\u0005\b\u0005K\u0002A\u0011AA0\u0011\u0019\u0019\b\u0001\"\u0003\u0003j!9!\u0011\u0010\u0001\u0005\u0002\u0005}\u0003b\u0002B?\u0001\u0011\u0005\u0011q\f\u0005\b\u0005\u0003\u0003A\u0011AA0\u0011\u001d\u0011)\t\u0001C\u0001\u0003?BqA!#\u0001\t\u0003\ty\u0006C\u0004\u0003\u000e\u0002!IAa$\t\u000f\t]\u0005\u0001\"\u0003\u0003\u001a\"9!q\u0019\u0001\u0005\n\t%'A\u0004'pON+w-\\3oiR+7\u000f\u001e\u0006\u0003aE\n1\u0001\\8h\u0015\u0005\u0011\u0014!B6bM.\f7\u0001A\n\u0003\u0001U\u0002\"AN\u001d\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001>!\tq\u0004!D\u00010\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\u0012!\u0011\t\u0003\u0005*k\u0011a\u0011\u0006\u0003\t\u0016\u000baaY8n[>t'B\u0001\u001aG\u0015\t9\u0005*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0006\u0019qN]4\n\u0005-\u001b%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA\u0005A1/Z4nK:$8/F\u0001P!\r\u0001VkV\u0007\u0002#*\u0011!kU\u0001\b[V$\u0018M\u00197f\u0015\t!v'\u0001\u0006d_2dWm\u0019;j_:L!AV)\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u00031zk\u0011!\u0017\u0006\u0003aiS!a\u0017/\u0002\u0013%tG/\u001a:oC2\u001c(BA/F\u0003\u001d\u0019Ho\u001c:bO\u0016L!aX-\u0003\u00151{wmU3h[\u0016tG/A\u0005tK\u001elWM\u001c;tA\u00051An\\4ESJ,\u0012a\u0019\t\u0003I&l\u0011!\u001a\u0006\u0003M\u001e\f!![8\u000b\u0003!\fAA[1wC&\u0011!.\u001a\u0002\u0005\r&dW-\u0001\u0006m_\u001e$\u0015N]0%KF$\"!\u001c9\u0011\u0005Yr\u0017BA88\u0005\u0011)f.\u001b;\t\u000fE<\u0011\u0011!a\u0001G\u0006\u0019\u0001\u0010J\u0019\u0002\u000f1|w\rR5sA\u0005i1M]3bi\u0016\u001cVmZ7f]R$BaV;{\u007f\")a/\u0003a\u0001o\u00061qN\u001a4tKR\u0004\"A\u000e=\n\u0005e<$\u0001\u0002'p]\u001eDqa_\u0005\u0011\u0002\u0003\u0007A0\u0001\nj]\u0012,\u00070\u00138uKJ4\u0018\r\u001c\"zi\u0016\u001c\bC\u0001\u001c~\u0013\tqxGA\u0002J]RD\u0011\"!\u0001\n!\u0003\u0005\r!a\u0001\u0002\tQLW.\u001a\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011B\"\u0002\u000bU$\u0018\u000e\\:\n\t\u00055\u0011q\u0001\u0002\u0005)&lW-A\fde\u0016\fG/Z*fO6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u0003\u0016\u0004y\u0006U1FAA\f!\u0011\tI\"a\t\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005r'\u0001\u0006b]:|G/\u0019;j_:LA!!\n\u0002\u001c\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002/\r\u0014X-\u0019;f'\u0016<W.\u001a8uI\u0011,g-Y;mi\u0012\u001aTCAA\u0016U\u0011\t\u0019!!\u0006\u0002\u000fI,7m\u001c:egR1\u0011\u0011GA\u001f\u0003\u007f\u0001B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003o\u0019\u0015A\u0002:fG>\u0014H-\u0003\u0003\u0002<\u0005U\"!D'f[>\u0014\u0018PU3d_J$7\u000fC\u0003w\u0019\u0001\u0007q\u000fC\u0004\u0002.1\u0001\r!!\u0011\u0011\u000bY\n\u0019%a\u0012\n\u0007\u0005\u0015sG\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002B!!\u0013\u0002X9!\u00111JA*!\r\tieN\u0007\u0003\u0003\u001fR1!!\u00154\u0003\u0019a$o\\8u}%\u0019\u0011QK\u001c\u0002\rA\u0013X\rZ3g\u0013\u0011\tI&a\u0017\u0003\rM#(/\u001b8h\u0015\r\t)fN\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002[\"\u001aQ\"a\u0019\u0011\t\u0005\u0015\u00141O\u0007\u0003\u0003ORA!!\u001b\u0002l\u0005\u0019\u0011\r]5\u000b\t\u00055\u0014qN\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t\t\bS\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003k\n9G\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012|wO\u001c\u0015\u0004\u001d\u0005m\u0004\u0003BA3\u0003{JA!a \u0002h\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001/i\u0016\u001cH/\u00119qK:$gi\u001c:M_\u001e\u001cVmZ7f]R|eMZ:fi>3XM\u001d4m_^,\u0005pY3qi&|g\u000eF\u0003n\u0003\u000b\u000bI\t\u0003\u0004\u0002\b>\u0001\ra^\u0001\u000bE\u0006\u001cXm\u00144gg\u0016$\bBBAF\u001f\u0001\u0007q/A\u0007mCJ<Wm\u001d;PM\u001a\u001cX\r\u001e\u0015\u0004\u001f\u0005=\u0005\u0003BAI\u0003/k!!a%\u000b\t\u0005U\u00151N\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u0005e\u00151\u0013\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\bfB\b\u0002\u001e\u0006%\u00161\u0016\t\u0005\u0003?\u000b)+\u0004\u0002\u0002\"*!\u00111UAJ\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018\u0002BAT\u0003C\u0013\u0011bQ:w'>,(oY3\u0002\u000bY\fG.^3-\u001d\u00055\u0016\u0011WA[\u0003s\u000bi,!1\u0002F\u0006\u0012\u0011qV\u0001\u000fa1\u0002SFM\u00195oQB4G\u000e\u001b9C\t\t\u0019,A\u00071Y\u0001\u0012\u0014\u0007N\u001c5qM2D\u0007O\u0011\u0003\u0003o\u000bA!\r\u0017!a\u0005\u0012\u00111X\u0001\bcA\u0002D\u0006I\u00191C\t\ty,A\u00073cQ:D\u0007O\u001a7iab\u0003\u0005M\u0011\u0003\u0003\u0007\fa\"\f\u001a2i]\"\u0004h\r\u001c5q1\u0002\u0003'\t\u0002\u0002H\u0006)\"'\r\u001b8ia\u001ad\u0007\u000e\u001d-iIJD'\u000f\u001c8ee2\u0014A\u0006;fgR\u0014V-\u00193P]\u0016k\u0007\u000f^=TK\u001elWM\u001c;)\u0007A\ti\r\u0005\u0003\u0002f\u0005=\u0017\u0002BAi\u0003O\u0012A\u0001V3ti\u0006IB/Z:u%\u0016\fGMQ3g_J,g)\u001b:ti>3gm]3uQ\r\t\u0012QZ\u0001\u0012i\u0016\u001cHOU3bI\u00063G/\u001a:MCN$\bf\u0001\n\u0002N\u0006yA/Z:u%\u0016\fGM\u0012:p[\u001e\u000b\u0007\u000fK\u0002\u0014\u0003\u001b\f\u0011\u0004^3tiJ+\u0017\rZ,iK:tu.T1y!>\u001c\u0018\u000e^5p]R\u0019Q.a9\t\u000f\u0005\u0015H\u00031\u0001\u0002h\u0006iQ.\u001b8P]\u0016lUm]:bO\u0016\u00042ANAu\u0013\r\tYo\u000e\u0002\b\u0005>|G.Z1oQ\u001d!\u0012qRAx\u0003c\fAA\\1nK\u0006\u0012\u00111_\u0001.i\u0016\u001cHOU3bI^CWM\u001c(p\u001b\u0006D\bk\\:ji&|g\u000eI7j]>sW-T3tg\u0006<W\rI\u001f!wBj\bf\u0002\u000b\u0002x\u0006u\u0018q \t\u0005\u0003?\u000bI0\u0003\u0003\u0002|\u0006\u0005&a\u0003,bYV,7k\\;sG\u0016\f\u0001BY8pY\u0016\fgn\u001d\u0017\u0005\u0005\u0003\u0011\u0019!G\u0001\u00023\u0005\u0001\u0011\u0001\u0004;fgR$&/\u001e8dCR,\u0007fA\u000b\u0002N\u0006AB/Z:u)J,hnY1uK\u0016k\u0007\u000f^=TK\u001elWM\u001c;)\u0007Y\ti-\u0001\u001cuKN$(+\u001a7pC\u0012d\u0015M]4fgR$\u0016.\\3ti\u0006l\u0007/\u00118e\u001d\u0016DHo\u00144gg\u0016$\u0018I\u001a;feR\u0013XO\\2bi&|g\u000eK\u0002\u0018\u0003\u001b\f\u0001\u0003^3tiR\u0013XO\\2bi\u00164U\u000f\u001c7)\u0007a\ti-A\ruKN$h)\u001b8e\u001f\u001a47/\u001a;CsRKW.Z:uC6\u0004\bfA\r\u0002N\u0006IB/Z:u\u001d\u0016DHo\u00144gg\u0016$8)\u00197dk2\fG/[8oQ\rQ\u0012QZ\u0001\u0017i\u0016\u001cHo\u00115b]\u001e,g)\u001b7f'V4g-\u001b=fg\"\u001a1$!4\u0002;Q,7\u000f\u001e*fG>4XM]=GSb,7oQ8seV\u0004H/\u00138eKbD3\u0001HAg\u0003m!Xm\u001d;SK\u000e|g/\u001a:Ue\u0006t7/Y2uS>t\u0017J\u001c3fq\"\u001aQ$!4\u0002=Q,7\u000f\u001e*fG>4XM]=SK\n,\u0018\u000e\u001c3t\u000bB|7\r[\"bG\",\u0007f\u0001\u0010\u0002N\u0006iQM\u001c3Uq:\u0014VmY8sIN$\u0002#!\r\u00032\tm\"q\bB%\u0005\u0017\u0012yEa\u0015\t\u000f\tMr\u00041\u0001\u00036\u0005\t2m\u001c8ue>d'+Z2pe\u0012$\u0016\u0010]3\u0011\t\u0005M\"qG\u0005\u0005\u0005s\t)DA\tD_:$(o\u001c7SK\u000e|'\u000f\u001a+za\u0016DaA!\u0010 \u0001\u00049\u0018A\u00039s_\u0012,8-\u001a:JI\"9!\u0011I\u0010A\u0002\t\r\u0013!\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007\u000eE\u00027\u0005\u000bJ1Aa\u00128\u0005\u0015\u0019\u0006n\u001c:u\u0011\u00151x\u00041\u0001x\u0011!\u0011ie\bI\u0001\u0002\u0004a\u0018\u0001\u00069beRLG/[8o\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000e\u0003\u0005\u0003R}\u0001\n\u00111\u0001}\u0003A\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007\u000e\u0003\u0005\u0003V}\u0001\n\u00111\u0001x\u0003%!\u0018.\\3ti\u0006l\u0007/A\ff]\u0012$\u0006P\u001c*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%k\u00059RM\u001c3Uq:\u0014VmY8sIN$C-\u001a4bk2$HEN\u0001\u0018K:$G\u000b\u001f8SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uI]*\"Aa\u0018+\u0007]\f)\"A\u0011uKN$(+Z2pm\u0016\u0014\u0018PR5yKN\u001cuN\u001d:vaR$\u0016.\\3J]\u0012,\u0007\u0010K\u0002$\u0003\u001b\fa\u0004^3tiJ+7m\u001c<fef<\u0016\u000e\u001e5D_J\u0014X\u000f\u001d;NKN\u001c\u0018mZ3)\u0007\u0011\ni\rF\u0005X\u0005W\u0012iG!\u001d\u0003v!1\u0011qQ\u0013A\u0002]DqAa\u001c&\u0001\u0004\t9/A\tgS2,\u0017\t\u001c:fC\u0012LX\t_5tiNDaAa\u001d&\u0001\u0004a\u0018\u0001D5oSR4\u0015\u000e\\3TSj,\u0007b\u0002B<K\u0001\u0007\u0011q]\u0001\faJ,\u0017\r\u001c7pG\u0006$X-A\u0014uKN$8I]3bi\u0016<\u0016\u000e\u001e5J]&$h)\u001b7f'&TX-\u00119qK:$W*Z:tC\u001e,\u0007f\u0001\u0014\u0002N\u00069C/Z:u\u0007J,\u0017\r^3XSRD\u0017J\\5u\r&dWmU5{K\u000ecW-\u0019:TQV$Hm\\<oQ\r9\u0013QZ\u0001/g\"|W\u000f\u001c3UeVt7-\u0019;f\u000bZ,g.\u00134PM\u001a\u001cX\r\u001e)pS:$8\u000fV8B\u000f\u0006\u0004\u0018J\u001c+iK2{w\rK\u0002)\u0003\u001b\f!\u0003^3ti\u0006\u0003\b/\u001a8e\rJ|WNR5mK\"\u001a\u0011&!4\u00025Q,7\u000f^$fi\u001aK'o\u001d;CCR\u001c\u0007\u000eV5nKN$\u0018-\u001c9)\u0007)\ni-A\foK^\u0004&o\u001c3vG\u0016\u00148\u000b^1uK6\u000bg.Y4feR\u0011!\u0011\u0013\t\u00041\nM\u0015b\u0001BK3\n!\u0002K]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\f1b\u00195fG.,\u0015/^1mgV!!1\u0014BY)\u0015i'Q\u0014Bb\u0011\u001d\u0011y\n\fa\u0001\u0005C\u000b!a]\u0019\u0011\r\t\r&\u0011\u0016BW\u001b\t\u0011)KC\u0002\u0003(\u001e\fA!\u001e;jY&!!1\u0016BS\u0005!IE/\u001a:bi>\u0014\b\u0003\u0002BX\u0005cc\u0001\u0001B\u0004\u000342\u0012\rA!.\u0003\u0003Q\u000bBAa.\u0003>B\u0019aG!/\n\u0007\tmvGA\u0004O_RD\u0017N\\4\u0011\u0007Y\u0012y,C\u0002\u0003B^\u00121!\u00118z\u0011\u001d\u0011)\r\fa\u0001\u0005C\u000b!a\u001d\u001a\u0002']\u0014\u0018\u000e^3O_:\u001cXM\\:f)>4\u0015\u000e\\3\u0015\u000f5\u0014YMa4\u0003T\"1!QZ\u0017A\u0002\r\f\u0001BZ5mK:\u000bW.\u001a\u0005\u0007\u0005#l\u0003\u0019A<\u0002\u0011A|7/\u001b;j_:DaA!6.\u0001\u0004a\u0018\u0001B:ju\u0016\u0004")
public class LogSegmentTest {
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final ArrayBuffer<LogSegment> segments = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private File logDir;

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private ArrayBuffer<LogSegment> segments() {
        return this.segments;
    }

    private File logDir() {
        return this.logDir;
    }

    private void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogSegment createSegment(long offset, int indexIntervalBytes, Time time) {
        LogSegment seg = LogTestUtils$.MODULE$.createSegment(offset, this.logDir(), indexIntervalBytes, time);
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    /*
     * WARNING - void declaration
     */
    public MemoryRecords records(long offset, Seq<String> records) {
        void withRecords_records;
        void withRecords_timestampType;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])((IterableOnceOps)records.map((Function1 & Serializable)s -> new SimpleRecord(offset * 10L, s.getBytes()))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        TimestampType timestampType = TimestampType.CREATE_TIME;
        NoCompression withRecords_compression = Compression.NONE;
        return MemoryRecords.withRecords((byte)1, (long)offset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    @BeforeEach
    public void setup() {
        this.logDir_$eq(TestUtils.tempDirectory(null, null));
    }

    @AfterEach
    public void teardown() {
        this.segments().foreach((Function1 & Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir());
    }

    @ParameterizedTest
    @CsvSource(value={"0, -2147483648", "0, 2147483648", "1, 0", "100, 10", "2147483648, 0", "-2147483648, 0", "2147483648,4294967296"})
    public void testAppendForLogSegmentOffsetOverflowException(long baseOffset, long largestOffset) {
        LogSegment seg = this.createSegment(baseOffset, this.createSegment$default$2(), this.createSegment$default$3());
        long currentTime = Time.SYSTEM.milliseconds();
        MemoryRecords memoryRecords = this.records(0L, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
        Assertions.assertThrows(LogSegmentOffsetOverflowException.class, () -> seg.append(largestOffset, currentTime, largestOffset, memoryRecords));
    }

    @Test
    public void testReadOnEmptySegment() {
        Assertions.assertNull((Object)this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3()).read(40L, 300), (String)"Read beyond the last offset in the segment should be null");
    }

    @Test
    public void testReadBeforeFirstOffset() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "little", "bee"}));
        seg.append(53L, -1L, -1L, ms);
        Records read = seg.read((long)41L, (int)300).records;
        this.checkEquals(ms.records().iterator(), read.records().iterator());
    }

    @Test
    public void testReadAfterLast() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        Assertions.assertNull((Object)seg.read(52L, 200), (String)"Read beyond the last offset in the segment should give null");
    }

    @Test
    public void testReadFromGap() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        FetchDataInfo read = seg.read(55L, 200);
        this.checkEquals(ms2.records().iterator(), read.records.records().iterator());
    }

    @ParameterizedTest(name="testReadWhenNoMaxPosition minOneMessage = {0}")
    @ValueSource(booleans={true, false})
    public void testReadWhenNoMaxPosition(boolean minOneMessage) {
        Optional maxPosition = Optional.empty();
        int maxSize = 1;
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        FetchDataInfo read = seg.read(48L, maxSize, maxPosition, minOneMessage);
        Assertions.assertEquals((Object)new LogOffsetMetadata(48L, 40L, 0), (Object)read.fetchOffsetMetadata);
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.IteratorHasAsScala(read.records.records().iterator()).asScala().isEmpty());
        read = seg.read(50L, maxSize, maxPosition, minOneMessage);
        Assertions.assertEquals((Object)new LogOffsetMetadata(50L, 40L, 0), (Object)read.fetchOffsetMetadata);
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.IteratorHasAsScala(read.records.records().iterator()).asScala().isEmpty());
        read = seg.read(51L, maxSize, maxPosition, minOneMessage);
        Assertions.assertEquals((Object)new LogOffsetMetadata(51L, 40L, 39), (Object)read.fetchOffsetMetadata);
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.IteratorHasAsScala(read.records.records().iterator()).asScala().isEmpty());
        read = seg.read(52L, maxSize, maxPosition, minOneMessage);
        Assertions.assertNull((Object)read);
        read = seg.read(53L, maxSize, maxPosition, minOneMessage);
        Assertions.assertNull((Object)read);
    }

    @Test
    public void testTruncate() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        IntRef offset = IntRef.create((int)40);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 30).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {
            MemoryRecords ms1 = this.records(offset$2.elem, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
            seg.append((long)offset$2.elem, -1L, -1L, ms1);
            MemoryRecords ms2 = this.records(offset$2.elem + 1, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
            seg.append((long)(offset$2.elem + 1), -1L, -1L, ms2);
            FetchDataInfo read = seg.read((long)offset$2.elem, 10000);
            Assertions.assertEquals((Object)new .colon.colon((Object)((Record)ms1.records().iterator().next()), (List)new .colon.colon((Object)((Record)ms2.records().iterator().next()), (List)Nil$.MODULE$)), (Object)CollectionConverters$.MODULE$.IterableHasAsScala(read.records.records()).asScala().toList());
            seg.truncateTo((long)(offset$2.elem + 1));
            FetchDataInfo read2 = seg.read((long)offset$2.elem, 10000);
            Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(read2.records.records()).asScala().size());
            this.checkEquals(ms1.records().iterator(), read2.records.records().iterator());
            ++offset$2.elem;
        });
    }

    @Test
    public void testTruncateEmptySegment() {
        int maxSegmentMs = 300000;
        MockTime time = new MockTime();
        int x$3 = this.createSegment$default$2();
        LogSegment seg = this.createSegment(0L, x$3, (Time)time);
        seg.timeIndex();
        seg.offsetIndex();
        seg.close();
        int x$6 = this.createSegment$default$2();
        LogSegment reopened = this.createSegment(0L, x$6, (Time)time);
        Assertions.assertEquals((int)0, (int)seg.timeIndex().sizeInBytes());
        Assertions.assertEquals((int)0, (int)seg.offsetIndex().sizeInBytes());
        time.sleep(500L);
        reopened.truncateTo(57L);
        Assertions.assertEquals((long)0L, (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L));
        Assertions.assertFalse((boolean)reopened.timeIndex().isFull());
        Assertions.assertFalse((boolean)reopened.offsetIndex().isFull());
        RollParams rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, 100L, 1024, time.milliseconds());
        Assertions.assertFalse((boolean)reopened.shouldRoll(rollParams));
        time.sleep((long)(maxSegmentMs + 1));
        Assertions.assertEquals((long)(maxSegmentMs + 1), (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L));
        rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, 100L, 1024, time.milliseconds());
        Assertions.assertFalse((boolean)reopened.shouldRoll(rollParams));
        rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, 2147483847L, 1024, time.milliseconds());
        Assertions.assertTrue((boolean)reopened.shouldRoll(rollParams));
    }

    @Test
    public void testReloadLargestTimestampAndNextOffsetAfterTruncation() {
        int numMessages = 30;
        LogSegment seg = this.createSegment(40L, 2 * this.records(0L, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})).sizeInBytes() - 1, this.createSegment$default$3());
        IntRef offset = IntRef.create((int)40);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {
            seg.append((long)offset$3.elem, (long)offset$3.elem, (long)offset$3.elem, this.records(offset$3.elem, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})));
            ++offset$3.elem;
        });
        Assertions.assertEquals((long)offset.elem, (long)seg.readNextOffset());
        int expectedNumEntries = numMessages / 2 - 1;
        Assertions.assertEquals((int)expectedNumEntries, (int)seg.timeIndex().entries(), (String)new StringBuilder(25).append("Should have ").append(expectedNumEntries).append(" time indexes").toString());
        seg.truncateTo(41L);
        Assertions.assertEquals((int)0, (int)seg.timeIndex().entries(), (String)"Should have 0 time indexes");
        Assertions.assertEquals((long)400L, (long)seg.largestTimestamp(), (String)"Largest timestamp should be 400");
        Assertions.assertEquals((long)41L, (long)seg.readNextOffset());
    }

    @Test
    public void testTruncateFull() {
        MockTime time = new MockTime();
        int x$3 = this.createSegment$default$2();
        LogSegment seg = this.createSegment(40L, x$3, (Time)time);
        seg.append(41L, -1L, -1L, this.records(40L, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
        time.sleep(500L);
        Assertions.assertEquals((long)500L, (long)seg.timeWaitedForRoll(time.milliseconds(), -1L));
        seg.truncateTo(0L);
        Assertions.assertEquals((long)0L, (long)seg.timeWaitedForRoll(time.milliseconds(), -1L));
        Assertions.assertFalse((boolean)seg.timeIndex().isFull());
        Assertions.assertFalse((boolean)seg.offsetIndex().isFull());
        Assertions.assertNull((Object)seg.read(0L, 1024), (String)"Segment should be empty.");
        seg.append(41L, -1L, -1L, this.records(40L, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
    }

    @Test
    public void testFindOffsetByTimestamp() {
        int messageSize = this.records(0L, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"msg00"})).sizeInBytes();
        LogSegment seg = this.createSegment(40L, messageSize * 2 - 1, this.createSegment$default$3());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(40), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> seg.append((long)i, (long)(i * 10), (long)i, this.records(i, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(3).append("msg").append(i).toString()}))));
        Assertions.assertEquals((long)490L, (long)seg.largestTimestamp());
        Assertions.assertEquals((long)42L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)420L, (long)0L).get()).offset);
        Assertions.assertEquals((long)43L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)421L, (long)0L).get()).offset);
        Assertions.assertEquals((long)43L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)430L, (long)0L).get()).offset);
        Assertions.assertEquals((long)44L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)431L, (long)0L).get()).offset);
        Assertions.assertEquals(Optional.empty(), (Object)seg.findOffsetByTimestamp(491L, 0L));
        Assertions.assertEquals((long)41L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)401L, (long)0L).get()).offset);
        Assertions.assertEquals((long)40L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)399L, (long)0L).get()).offset);
    }

    @Test
    public void testNextOffsetCalculation() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        Assertions.assertEquals((long)40L, (long)seg.readNextOffset());
        seg.append(52L, -1L, -1L, this.records(50L, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "you"})));
        Assertions.assertEquals((long)53L, (long)seg.readNextOffset());
    }

    @Test
    public void testChangeFileSuffixes() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        File logFile = seg.log().file();
        File indexFile = seg.offsetIndexFile();
        File timeIndexFile = seg.timeIndexFile();
        Assertions.assertFalse((boolean)seg.offsetIndexFile().exists());
        Assertions.assertFalse((boolean)seg.timeIndexFile().exists());
        seg.changeFileSuffixes("", ".deleted");
        Assertions.assertFalse((boolean)seg.offsetIndexFile().exists());
        Assertions.assertFalse((boolean)seg.timeIndexFile().exists());
        Assertions.assertEquals((Object)new StringBuilder(8).append(logFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.log().file().getAbsolutePath());
        Assertions.assertEquals((Object)new StringBuilder(8).append(indexFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.offsetIndexFile().getAbsolutePath());
        Assertions.assertEquals((Object)new StringBuilder(8).append(timeIndexFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.timeIndexFile().getAbsolutePath());
        Assertions.assertTrue((boolean)seg.log().file().exists());
        seg.offsetIndex();
        Assertions.assertTrue((boolean)seg.offsetIndexFile().exists());
        seg.timeIndex();
        Assertions.assertTrue((boolean)seg.timeIndexFile().exists());
    }

    @Test
    public void testRecoveryFixesCorruptIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> seg.append((long)i, -1L, -1L, this.records(i, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Integer.toString(i)}))));
        File indexFile = seg.offsetIndexFile();
        this.writeNonsenseToFile(indexFile, 5L, (int)indexFile.length());
        seg.recover(this.newProducerStateManager(), Optional.empty());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Iterable records = seg$5.read((long)((long)i), (int)1, Optional.of(Predef$.MODULE$.long2Long((long)((long)seg$5.size()))), (boolean)true).records.records();
            Assertions.assertEquals((long)i, (long)((Record)records.iterator().next()).offset());
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoverTransactionIndex() {
        void withRecords_records;
        void withRecords_compression;
        void withTransactionalRecords_records;
        void withTransactionalRecords_compression;
        void withTransactionalRecords_records2;
        void withTransactionalRecords_compression2;
        LogSegment segment = this.createSegment(100L, this.createSegment$default$2(), this.createSegment$default$3());
        short producerEpoch = (short)0;
        int partitionLeaderEpoch = 15;
        int sequence = 100;
        long pid1 = 5L;
        long pid2 = 10L;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        NoCompression noCompression = Compression.NONE;
        long withTransactionalRecords_initialOffset = 100L;
        noCompression = null;
        simpleRecordArray = null;
        segment.append(101L, -1L, 100L, MemoryRecords.withRecords((byte)2, (long)withTransactionalRecords_initialOffset, (Compression)withTransactionalRecords_compression2, (TimestampType)TimestampType.CREATE_TIME, (long)pid1, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (boolean)true, (SimpleRecord[])withTransactionalRecords_records2));
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        NoCompression noCompression2 = Compression.NONE;
        long withTransactionalRecords_initialOffset2 = 102L;
        noCompression2 = null;
        simpleRecordArray2 = null;
        segment.append(103L, -1L, 102L, MemoryRecords.withRecords((byte)2, (long)withTransactionalRecords_initialOffset2, (Compression)withTransactionalRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)pid2, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (boolean)true, (SimpleRecord[])withTransactionalRecords_records));
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        NoCompression noCompression3 = Compression.NONE;
        long withRecords_initialOffset = 104L;
        noCompression3 = null;
        simpleRecordArray3 = null;
        segment.append(105L, -1L, 104L, MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records));
        segment.append(106L, -1L, 106L, this.endTxnRecords(ControlRecordType.ABORT, pid2, producerEpoch, 106L, 0, 0, -1L));
        segment.append(107L, -1L, 107L, this.endTxnRecords(ControlRecordType.COMMIT, pid1, producerEpoch, 107L, 0, 0, -1L));
        ProducerStateManager stateManager = this.newProducerStateManager();
        segment.recover(stateManager, Optional.empty());
        Assertions.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        java.util.List abortedTxns = segment.txnIndex().allAbortedTxns();
        Assertions.assertEquals((int)1, (int)abortedTxns.size());
        AbortedTxn abortedTxn = (AbortedTxn)abortedTxns.get(0);
        Assertions.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assertions.assertEquals((long)102L, (long)abortedTxn.firstOffset());
        Assertions.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assertions.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
        stateManager = this.newProducerStateManager();
        stateManager.loadProducerEntry(new ProducerStateEntry(pid2, producerEpoch, 0, -1L, OptionalLong.of(75L), Optional.of(new BatchMetadata(10, 10L, 5, -1L))));
        segment.recover(stateManager, Optional.empty());
        Assertions.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        abortedTxns = segment.txnIndex().allAbortedTxns();
        Assertions.assertEquals((int)1, (int)abortedTxns.size());
        abortedTxn = (AbortedTxn)abortedTxns.get(0);
        Assertions.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assertions.assertEquals((long)75L, (long)abortedTxn.firstOffset());
        Assertions.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assertions.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryRebuildsEpochCache() {
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        void withRecords_compression;
        void withRecords_records2;
        void withRecords_partitionLeaderEpoch2;
        void withRecords_compression2;
        void withRecords_records3;
        void withRecords_partitionLeaderEpoch3;
        void withRecords_compression3;
        void withRecords_records4;
        void withRecords_partitionLeaderEpoch4;
        void withRecords_compression4;
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        LeaderEpochCheckpointFile checkpoint = new LeaderEpochCheckpointFile(TestUtils.tempFile((String)"kafka", (String)".tmp"), new LogDirFailureChannel(1));
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.topicPartition(), checkpoint, (Scheduler)new MockScheduler((Time)new MockTime()));
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        boolean bl = false;
        NoCompression noCompression = Compression.NONE;
        long withRecords_initialOffset = 104L;
        noCompression = null;
        simpleRecordArray = null;
        seg.append(105L, -1L, 104L, MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (Compression)withRecords_compression4, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch4, (boolean)false, (SimpleRecord[])withRecords_records4));
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        boolean bl2 = true;
        NoCompression noCompression2 = Compression.NONE;
        long withRecords_initialOffset2 = 106L;
        noCompression2 = null;
        simpleRecordArray2 = null;
        seg.append(107L, -1L, 106L, MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset2, (Compression)withRecords_compression3, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch3, (boolean)false, (SimpleRecord[])withRecords_records3));
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        boolean bl3 = true;
        NoCompression noCompression3 = Compression.NONE;
        long withRecords_initialOffset3 = 108L;
        noCompression3 = null;
        simpleRecordArray3 = null;
        seg.append(109L, -1L, 108L, MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset3, (Compression)withRecords_compression2, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withRecords_records2));
        SimpleRecord[] simpleRecordArray4 = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        int n = 2;
        NoCompression noCompression4 = Compression.NONE;
        long withRecords_initialOffset4 = 110L;
        noCompression4 = null;
        simpleRecordArray4 = null;
        seg.append(111L, -1L, 110L, MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset4, (Compression)withRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records));
        seg.recover(this.newProducerStateManager(), Optional.of(cache));
        Assertions.assertEquals(Arrays.asList(new EpochEntry(0, 104L), new EpochEntry(1, 106L), new EpochEntry(2, 110L)), (Object)cache.epochEntries());
    }

    private MemoryRecords endTxnRecords(ControlRecordType controlRecordType, long producerId, short producerEpoch, long offset, int partitionLeaderEpoch, int coordinatorEpoch, long timestamp) {
        EndTransactionMarker marker = new EndTransactionMarker(controlRecordType, coordinatorEpoch);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)partitionLeaderEpoch, (long)producerId, (short)producerEpoch, (EndTransactionMarker)marker);
    }

    private int endTxnRecords$default$5() {
        return 0;
    }

    private int endTxnRecords$default$6() {
        return 0;
    }

    private long endTxnRecords$default$7() {
        return -1L;
    }

    @Test
    public void testRecoveryFixesCorruptTimeIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> seg.append((long)i, (long)(i * 10), (long)i, this.records(i, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Integer.toString(i)}))));
        File timeIndexFile = seg.timeIndexFile();
        this.writeNonsenseToFile(timeIndexFile, 5L, (int)timeIndexFile.length());
        seg.recover(this.newProducerStateManager(), Optional.empty());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Assertions.assertEquals((long)i, (long)((FileRecords.TimestampAndOffset)seg$6.findOffsetByTimestamp((long)((long)(i * 10)), (long)0L).get()).offset);
            if (i < 99) {
                Assertions.assertEquals((long)(i + 1), (long)((FileRecords.TimestampAndOffset)seg$6.findOffsetByTimestamp((long)((long)(i * 10 + 1)), (long)0L).get()).offset);
                return;
            }
        });
    }

    @Test
    public void testRecoveryWithCorruptMessage() {
        int messagesAppended = 20;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> {
            LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), messagesAppended).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> seg.append((long)i, -1L, -1L, this.records(i, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Integer.toString(i)}))));
            int offsetToBeginCorruption = TestUtils$.MODULE$.random().nextInt(messagesAppended);
            int position = seg.log().searchForOffsetWithSize((long)((long)offsetToBeginCorruption), (int)0).position + TestUtils$.MODULE$.random().nextInt(15);
            this.writeNonsenseToFile(seg.log().file(), position, (int)(seg.log().file().length() - (long)position));
            seg.recover(this.newProducerStateManager(), Optional.empty());
            Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), offsetToBeginCorruption).toList(), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(seg.log().batches()).asScala().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.lastOffset()))).toList(), (String)"Should have truncated off bad messages.");
            seg.deleteIfExists();
        });
    }

    private LogSegment createSegment(long baseOffset, boolean fileAlreadyExists, int initFileSize, boolean preallocate) {
        File tempDir = TestUtils.tempDirectory(null, null);
        LogConfig logConfig = new LogConfig(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index.interval.bytes"), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.index.bytes"), (Object)BoxesRunTime.boxToInteger((int)1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.jitter.ms"), (Object)BoxesRunTime.boxToInteger((int)0))}))).asJava());
        LogSegment seg = LogSegment.open((File)tempDir, (long)baseOffset, (LogConfig)logConfig, (Time)Time.SYSTEM, (boolean)fileAlreadyExists, (int)initFileSize, (boolean)preallocate, (String)"");
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public int createSegment$default$2() {
        return 10;
    }

    public Time createSegment$default$3() {
        return Time.SYSTEM;
    }

    @Test
    public void testCreateWithInitFileSizeAppendMessage() {
        LogSegment seg = this.createSegment(40L, false, 0x20000000, true);
        MemoryRecords ms = this.records(50L, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        FetchDataInfo read = seg.read(55L, 200);
        this.checkEquals(ms2.records().iterator(), read.records.records().iterator());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateWithInitFileSizeClearShutdown() {
        void open_preallocate;
        void open_initFileSize;
        void open_time;
        File tempDir = TestUtils.tempDirectory(null, null);
        LogConfig logConfig = new LogConfig(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index.interval.bytes"), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.index.bytes"), (Object)BoxesRunTime.boxToInteger((int)1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.jitter.ms"), (Object)BoxesRunTime.boxToInteger((int)0))}))).asJava());
        boolean bl = true;
        int n = 0x20000000;
        Time time = Time.SYSTEM;
        long open_baseOffset = 40L;
        time = null;
        LogSegment seg = LogSegment.open((File)tempDir, (long)open_baseOffset, (LogConfig)logConfig, (Time)open_time, (boolean)false, (int)open_initFileSize, (boolean)open_preallocate, (String)"");
        MemoryRecords ms = this.records(50L, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        FetchDataInfo read = seg.read(55L, 200);
        this.checkEquals(ms2.records().iterator(), read.records.records().iterator());
        int oldSize = seg.log().sizeInBytes();
        long oldPosition = seg.log().channel().position();
        long oldFileSize = seg.log().file().length();
        Assertions.assertEquals((long)0x20000000L, (long)oldFileSize);
        seg.close();
        Assertions.assertEquals((long)oldSize, (long)seg.log().file().length());
        LogSegment segReopen = LogSegment.open((File)tempDir, (long)40L, (LogConfig)logConfig, (Time)Time.SYSTEM, (boolean)true, (int)0x20000000, (boolean)true, (String)"");
        this.segments().$plus$eq((Object)segReopen);
        FetchDataInfo readAgain = segReopen.read(55L, 200);
        this.checkEquals(ms2.records().iterator(), readAgain.records.records().iterator());
        int size = segReopen.log().sizeInBytes();
        long position = segReopen.log().channel().position();
        long fileSize = segReopen.log().file().length();
        Assertions.assertEquals((long)oldPosition, (long)position);
        Assertions.assertEquals((int)oldSize, (int)size);
        Assertions.assertEquals((long)size, (long)fileSize);
    }

    @Test
    public void shouldTruncateEvenIfOffsetPointsToAGapInTheLog() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        int offset = 40;
        MemoryRecords ms1 = LogSegmentTest.records$1(offset, "first message");
        seg.append((long)offset, -1L, -1L, ms1);
        MemoryRecords ms2 = LogSegmentTest.records$1(offset + 3, "message after gap");
        seg.append((long)(offset + 3), -1L, -1L, ms2);
        seg.truncateTo((long)(offset + 1));
        FetchDataInfo log = seg.read((long)offset, 10000);
        Assertions.assertEquals((long)offset, (long)((RecordBatch)log.records.batches().iterator().next()).baseOffset());
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(log.records.batches()).asScala().size());
    }

    @Test
    public void testAppendFromFile() {
        File tempDir = TestUtils.tempDirectory(null, null);
        long logFile_offset = 0L;
        File open_file = LogFileUtils.logFile((File)tempDir, (long)logFile_offset, (String)"");
        boolean open_mutable = true;
        Object var11_3 = null;
        FileRecords fileRecords = FileRecords.open((File)open_file, (boolean)open_mutable, (boolean)false, (int)0, (boolean)false);
        fileRecords.append(LogSegmentTest.records$2(0L, 1024));
        fileRecords.append(LogSegmentTest.records$2(500L, 0x100001));
        int sizeBeforeOverflow = fileRecords.sizeInBytes();
        fileRecords.append(LogSegmentTest.records$2(0x80000004L, 1024));
        int sizeAfterOverflow = fileRecords.sizeInBytes();
        LogSegment segment = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        int bytesAppended = segment.appendFromFile(fileRecords, 0);
        Assertions.assertEquals((int)sizeBeforeOverflow, (int)bytesAppended);
        Assertions.assertEquals((int)sizeBeforeOverflow, (int)segment.size());
        LogSegment overflowSegment = this.createSegment(Integer.MAX_VALUE, this.createSegment$default$2(), this.createSegment$default$3());
        int overflowBytesAppended = overflowSegment.appendFromFile(fileRecords, sizeBeforeOverflow);
        Assertions.assertEquals((int)(sizeAfterOverflow - sizeBeforeOverflow), (int)overflowBytesAppended);
        Assertions.assertEquals((int)overflowBytesAppended, (int)overflowSegment.size());
        Utils.delete((File)tempDir);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetFirstBatchTimestamp() {
        void withRecords_records;
        void withRecords_compression;
        LogSegment segment = this.createSegment(1L, this.createSegment$default$2(), this.createSegment$default$3());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)segment.getFirstBatchTimestamp());
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("one".getBytes())};
        NoCompression noCompression = Compression.NONE;
        long withRecords_initialOffset = 1L;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        Object var6_5 = null;
        noCompression = null;
        simpleRecordArray = null;
        segment.append(1L, 1000L, 1L, MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records));
        Assertions.assertEquals((long)1000L, (long)segment.getFirstBatchTimestamp());
        segment.close();
    }

    private ProducerStateManager newProducerStateManager() {
        return new ProducerStateManager(this.topicPartition(), this.logDir(), 300000, new ProducerStateManagerConfig(86400000, false), (Time)new MockTime());
    }

    private <T> void checkEquals(Iterator<T> s1, Iterator<T> s2) {
        while (s1.hasNext() && s2.hasNext()) {
            Assertions.assertEquals(s1.next(), s2.next());
        }
        Assertions.assertFalse((boolean)s1.hasNext(), (String)"Iterators have uneven length--first has more");
        Assertions.assertFalse((boolean)s2.hasNext(), (String)"Iterators have uneven length--second has more");
    }

    private void writeNonsenseToFile(File fileName, long position, int size) {
        try (RandomAccessFile file = new RandomAccessFile(fileName, "rw");){
            file.seek(position);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), size).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$7 -> file.writeByte(TestUtils$.MODULE$.random().nextInt(255)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final MemoryRecords records$1(long offset, String record) {
        void withRecords_records;
        void withRecords_timestampType;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(offset * 1000L, record.getBytes())};
        TimestampType timestampType = TimestampType.CREATE_TIME;
        NoCompression withRecords_compression = Compression.NONE;
        return MemoryRecords.withRecords((byte)2, (long)offset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    /*
     * WARNING - void declaration
     */
    private static final MemoryRecords records$2(long offset, int size) {
        void withRecords_records;
        void withRecords_timestampType;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(new byte[size])};
        TimestampType timestampType = TimestampType.CREATE_TIME;
        NoCompression withRecords_compression = Compression.NONE;
        return MemoryRecords.withRecords((byte)2, (long)offset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }
}

