/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.stream.Stream;
import kafka.api.AbstractConsumerTest;
import kafka.api.BaseConsumerTest$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@Timeout(value=600L)
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005f\u0001\u0002\u000b\u0016\u0001iAQa\b\u0001\u0005\u0002\u0001BQA\t\u0001\u0005\u0002\rBQA\u0018\u0001\u0005\u0002}CQa\u001a\u0001\u0005\u0002!DQA\u001c\u0001\u0005\u0002=DQ!\u001e\u0001\u0005\u0002YDQ\u0001 \u0001\u0005\u0002uDq!a\u0002\u0001\t\u0003\tI\u0001C\u0004\u0002\u0016\u0001!\t!a\u0006\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0002bBA \u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003\u001b\u0002A\u0011AA(\u0011\u001d\tY\u0006\u0001C\u0001\u0003;:q!a\u001e\u0016\u0011\u0003\tIH\u0002\u0004\u0015+!\u0005\u00111\u0010\u0005\u0007?A!\t!a!\t\ru\u0003B\u0011AAC\u0011\u00191\u0007\u0003\"\u0001\u0002\u0006\nI\u0002\u000b\\1j]R,\u0007\u0010^\"p]N,X.\u001a:Q_2dG+Z:u\u0015\t1r#A\u0002ba&T\u0011\u0001G\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\u0004\u0005\u0002\u001d;5\tQ#\u0003\u0002\u001f+\t!\u0012IY:ue\u0006\u001cGoQ8ogVlWM\u001d+fgR\fa\u0001P5oSRtD#A\u0011\u0011\u0005q\u0001\u0011!\n;fgR$U\r\u001d:fG\u0006$X\r\u001a)pY2\u0014En\\2lg\u001a{'/Q:tS\u001etW.\u001a8u)\r!#f\u000e\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0005+:LG\u000fC\u0003,\u0005\u0001\u0007A&\u0001\u0004rk>\u0014X/\u001c\t\u0003[Qr!A\f\u001a\u0011\u0005=2S\"\u0001\u0019\u000b\u0005EJ\u0012A\u0002\u001fs_>$h(\u0003\u00024M\u00051\u0001K]3eK\u001aL!!\u000e\u001c\u0003\rM#(/\u001b8h\u0015\t\u0019d\u0005C\u00039\u0005\u0001\u0007A&A\u0007he>,\b\u000f\u0015:pi>\u001cw\u000e\u001c\u0015\u0007\u0005ijd\bQ!\u0011\u0005\u0015Z\u0014B\u0001\u001f'\u0005)!W\r\u001d:fG\u0006$X\rZ\u0001\b[\u0016\u001c8/Y4fC\u0005y\u0014!\t9pY2DC)\u001e:bi&|g.\u000b\u0011jg\u0002\"\b.\u001a\u0011sKBd\u0017mY3nK:$\u0018!B:j]\u000e,\u0017%\u0001\"\u0002\u0007Ir\u0003\u0007\u000b\u0003\u0003\tB\u000b\u0006CA#O\u001b\u00051%BA$I\u0003\u0019\u0001\u0018M]1ng*\u0011\u0011JS\u0001\bUV\u0004\u0018\u000e^3s\u0015\tYE*A\u0003kk:LGOC\u0001N\u0003\ry'oZ\u0005\u0003\u001f\u001a\u0013\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0003I\u000b!f\u001f3jgBd\u0017-\u001f(b[\u0016lh&];peVlWh\u001f\u0019~]\u001d\u0014x.\u001e9Qe>$xnY8m{m\fT\u0010\u000b\u0003\u0003)j[\u0006CA+Y\u001b\u00051&BA,G\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018BA-W\u00051iU\r\u001e5pIN{WO]2f\u0003\u00151\u0018\r\\;fY\u0005a\u0016%A/\u0002\u007f\u001d,G\u000fV3tiF+xN];n\u0003:$wI]8vaB\u0013x\u000e^8d_2\u0004\u0016M]1nKR,'o]\"mCN\u001c\u0018nY$s_V\u0004\bK]8u_\u000e|Gn\u00148ms\u0006\u0011B/Z:u\u001b\u0006D\bk\u001c7m%\u0016\u001cwN\u001d3t)\r!\u0003-\u0019\u0005\u0006W\r\u0001\r\u0001\f\u0005\u0006q\r\u0001\r\u0001\f\u0015\u0005\u0007\u0011\u0003\u0016\u000b\u000b\u0003\u0004)j#G&A3\"\u0003\u0019\f!fZ3u)\u0016\u001cH/U;peVl\u0017I\u001c3He>,\b\u000f\u0015:pi>\u001cw\u000e\u001c)be\u0006lW\r^3sg\u0006cG.A\u000buKN$X*\u0019=Q_2d\u0017J\u001c;feZ\fG.T:\u0015\u0007\u0011J'\u000eC\u0003,\t\u0001\u0007A\u0006C\u00039\t\u0001\u0007A\u0006\u000b\u0003\u0005\tB\u000b\u0006\u0006\u0002\u0003U56d\u0013!Z\u0001'i\u0016\u001cH/T1y!>dG.\u00138uKJ4\u0018\r\\'t\t\u0016d\u0017-_%o%\u00164xnY1uS>tGc\u0001\u0013qc\")1&\u0002a\u0001Y!)\u0001(\u0002a\u0001Y!\"Q\u0001\u0012)RQ\u0011)AK\u0017;-\u0003\u0015\fa\u0005^3ti6\u000b\u0007\u0010U8mY&sG/\u001a:wC2l5\u000fR3mCfLe.Q:tS\u001etW.\u001a8u)\r!s\u000f\u001f\u0005\u0006W\u0019\u0001\r\u0001\f\u0005\u0006q\u0019\u0001\r\u0001\f\u0015\u0005\r\u0011\u0003\u0016\u000b\u000b\u0003\u0007)j[H&A3\u0002WQ,7\u000f^'bqB{G\u000e\\%oi\u0016\u0014h/\u00197NgNCwN\u001d;feRC\u0017M\u001c)pY2$\u0016.\\3pkR$2\u0001\n@\u0000\u0011\u0015Ys\u00011\u0001-\u0011\u0015At\u00011\u0001-Q\u00119A\tU))\u000b\u001d!&,!\u0002-\u0003\u0015\fa\u0005^3tiB+'\u000fU1si&$\u0018n\u001c8MK\u0006$w+\u001b;i\u001b\u0006D\bk\u001c7m%\u0016\u001cwN\u001d3t)\u0015!\u00131BA\u0007\u0011\u0015Y\u0003\u00021\u0001-\u0011\u0015A\u0004\u00021\u0001-Q\u0011AA\tU))\u000b!!&,a\u0005-\u0003\u0015\fQ\u0005^3tiB+'\u000fU1si&$\u0018n\u001c8MC\u001e<\u0016\u000e\u001e5NCb\u0004v\u000e\u001c7SK\u000e|'\u000fZ:\u0015\u000b\u0011\nI\"a\u0007\t\u000b-J\u0001\u0019\u0001\u0017\t\u000baJ\u0001\u0019\u0001\u0017)\t%!\u0005+\u0015\u0015\u0006\u0013QS\u0016\u0011\u0005\u0017\u0002K\u0006aC/Z:u\u001bVdG/[\"p]N,X.\u001a:TKN\u001c\u0018n\u001c8US6,w.\u001e;P]N#x\u000e\u001d)pY2Lgn\u001a\u000b\u0006I\u0005\u001d\u0012\u0011\u0006\u0005\u0006W)\u0001\r\u0001\f\u0005\u0006q)\u0001\r\u0001\f\u0015\u0005\u0015\u0011\u0003\u0016\u000bK\u0003\u000b)j\u000by\u0003L\u0001f\u0003\u0019\"Xm\u001d;Nk2$\u0018nQ8ogVlWM]*fgNLwN\u001c+j[\u0016|W\u000f^(o\u00072|7/\u001a\u000b\u0006I\u0005U\u0012q\u0007\u0005\u0006W-\u0001\r\u0001\f\u0005\u0006q-\u0001\r\u0001\f\u0015\u0005\u0017\u0011\u0003\u0016\u000bK\u0003\f)j\u000bi\u0004L\u0001f\u0003=\"Xm\u001d;Q_2dWI^3oiV\fG\u000e\\=SKR,(O\\:SK\u000e|'\u000fZ:XSRD',\u001a:p)&lWm\\;u)\u0015!\u00131IA#\u0011\u0015YC\u00021\u0001-\u0011\u0015AD\u00021\u0001-Q\u0011aA\tU))\u000b1!&,a\u0013-\u0003\u0015\f1\u0006^3ti:{wJ\u001a4tKR4uN\u001d)beRLG/[8o\u000bb\u001cW\r\u001d;j_:|e\u000eU8mYj+'o\u001c\u000b\u0006I\u0005E\u00131\u000b\u0005\u0006W5\u0001\r\u0001\f\u0005\u0006q5\u0001\r\u0001\f\u0015\u0005\u001b\u0011\u0003\u0016\u000bK\u0003\u000e)j\u000bI\u0006L\u0001f\u0003\t\u0012XO\\'vYRL7i\u001c8tk6,'oU3tg&|g\u000eV5nK>,H\u000fV3tiR\u0019A%a\u0018\t\u000f\u0005\u0005d\u00021\u0001\u0002d\u0005i1\r\\8tK\u000e{gn];nKJ\u00042!JA3\u0013\r\t9G\n\u0002\b\u0005>|G.Z1oQ\u0019\u0001\u00111\u000e.\u0002vA!\u0011QNA9\u001b\t\tyG\u0003\u0002\u0017\u0011&!\u00111OA8\u0005\u001d!\u0016.\\3pkRt\"A\u0001-\u00023Ac\u0017-\u001b8uKb$8i\u001c8tk6,'\u000fU8mYR+7\u000f\u001e\t\u00039A\u00192\u0001EA?!\r)\u0013qP\u0005\u0004\u0003\u00033#AB!osJ+g\r\u0006\u0002\u0002zU\u0011\u0011q\u0011\t\u0007\u0003\u0013\u000b9*a'\u000e\u0005\u0005-%\u0002BAG\u0003\u001f\u000baa\u001d;sK\u0006l'\u0002BAI\u0003'\u000bA!\u001e;jY*\u0011\u0011QS\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001a\u0006-%AB*ue\u0016\fW\u000eE\u0002V\u0003;K1!a(W\u0005%\t%oZ;nK:$8\u000f")
public class PlaintextConsumerPollTest
extends AbstractConsumerTest {
    public static Stream<Arguments> getTestQuorumAndGroupProtocolParametersAll() {
        return BaseConsumerTest$.MODULE$.getTestQuorumAndGroupProtocolParametersAll();
    }

    public static Stream<Arguments> getTestQuorumAndGroupProtocolParametersClassicGroupProtocolOnly() {
        return BaseConsumerTest$.MODULE$.getTestQuorumAndGroupProtocolParametersClassicGroupProtocolOnly();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersClassicGroupProtocolOnly"})
    public void testDeprecatedPollBlocksForAssignment(String quorum, String groupProtocol) {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        consumer.poll(0L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(consumer.assignment()).asScala());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testMaxPollRecords(String quorum, String groupProtocol) {
        int maxPollRecords = 2;
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        this.consumerConfig().setProperty("max.poll.records", Integer.toString(maxPollRecords));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        int x$6 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$7 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$8 = this.consumeAndVerifyRecords$default$7();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$6, startingTimestamp, x$7, x$8, maxPollRecords);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testMaxPollIntervalMs(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(1000));
        this.consumerConfig().setProperty("heartbeat.interval.ms", Integer.toString(500));
        this.consumerConfig().setProperty("session.timeout.ms", Integer.toString(2000));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener(this);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned());
        Assertions.assertEquals((int)0, (int)listener.callsToRevoked());
        Thread.sleep(3000L);
        this.awaitRebalance(consumer, listener);
        Assertions.assertEquals((int)2, (int)listener.callsToAssigned());
        Assertions.assertEquals((int)1, (int)listener.callsToRevoked());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testMaxPollIntervalMsDelayInRevocation(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(5000));
        this.consumerConfig().setProperty("heartbeat.interval.ms", Integer.toString(500));
        this.consumerConfig().setProperty("session.timeout.ms", Integer.toString(1000));
        this.consumerConfig().setProperty("enable.auto.commit", Boolean.toString(false));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        BooleanRef commitCompleted = BooleanRef.create((boolean)false);
        LongRef committedPosition = LongRef.create((long)-1L);
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener(this, committedPosition, consumer, commitCompleted){
            private final /* synthetic */ PlaintextConsumerPollTest $outer;
            private final LongRef committedPosition$1;
            private final Consumer consumer$1;
            private final BooleanRef commitCompleted$1;

            public void onPartitionsLost(Collection<TopicPartition> partitions) {
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                if (!partitions.isEmpty() && partitions.contains(this.$outer.tp())) {
                    Utils.sleep((long)1500L);
                    this.committedPosition$1.elem = this.consumer$1.position(this.$outer.tp());
                    this.consumer$1.commitSync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.tp()), (Object)new OffsetAndMetadata(this.committedPosition$1.elem))}))).asJava());
                    this.commitCompleted$1.elem = true;
                }
                super.onPartitionsRevoked(partitions);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.committedPosition$1 = committedPosition$1;
                this.consumer$1 = consumer$1;
                this.commitCompleted$1 = commitCompleted$1;
                super($outer);
            }
        };
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"otherTopic", (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        Assertions.assertEquals((long)0L, (long)committedPosition.elem);
        Assertions.assertTrue((boolean)commitCompleted.elem);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testMaxPollIntervalMsDelayInAssignment(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(5000));
        this.consumerConfig().setProperty("heartbeat.interval.ms", Integer.toString(500));
        this.consumerConfig().setProperty("session.timeout.ms", Integer.toString(1000));
        this.consumerConfig().setProperty("enable.auto.commit", Boolean.toString(false));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener(this){

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                Utils.sleep((long)1500L);
                super.onPartitionsAssigned(partitions);
            }
        };
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        this.ensureNoRebalance(consumer, listener);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testMaxPollIntervalMsShorterThanPollTimeout(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(1000));
        this.consumerConfig().setProperty("heartbeat.interval.ms", Integer.toString(500));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener(this);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        int callsToAssignedAfterFirstRebalance = listener.callsToAssigned();
        consumer.poll(Duration.ofMillis(2000L));
        consumer.poll(Duration.ofMillis(500L));
        consumer.poll(Duration.ofMillis(500L));
        Assertions.assertEquals((int)callsToAssignedAfterFirstRebalance, (int)listener.callsToAssigned());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPerPartitionLeadWithMaxPollRecords(String quorum, String groupProtocol) {
        int numMessages = 1000;
        int maxPollRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadWithMaxPollRecords");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadWithMaxPollRecords");
        this.consumerConfig().setProperty("max.poll.records", Integer.toString(maxPollRecords));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.awaitNonEmptyRecords(consumer, this.tp(), this.awaitNonEmptyRecords$default$3());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLeadWithMaxPollRecords");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric lead = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags));
        Assertions.assertEquals((double)maxPollRecords, (double)BoxesRunTime.unboxToDouble((Object)lead.metricValue()), (String)new StringBuilder(19).append("The lead should be ").append(maxPollRecords).toString());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPerPartitionLagWithMaxPollRecords(String quorum, String groupProtocol) {
        int numMessages = 1000;
        int maxPollRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagWithMaxPollRecords");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagWithMaxPollRecords");
        this.consumerConfig().setProperty("max.poll.records", Integer.toString(maxPollRecords));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        ConsumerRecords records = this.awaitNonEmptyRecords(consumer, this.tp(), this.awaitNonEmptyRecords$default$3());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagWithMaxPollRecords");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric lag = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags));
        Assertions.assertEquals((double)(numMessages - records.count()), (double)BoxesRunTime.unboxToDouble((Object)lag.metricValue()), (double)this.epsilon(), (String)new StringBuilder(18).append("The lag should be ").append(numMessages - records.count()).toString());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testMultiConsumerSessionTimeoutOnStopPolling(String quorum, String groupProtocol) {
        this.runMultiConsumerSessionTimeoutTest(false);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testMultiConsumerSessionTimeoutOnClose(String quorum, String groupProtocol) {
        this.runMultiConsumerSessionTimeoutTest(true);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPollEventuallyReturnsRecordsWithZeroTimeout(String quorum, String groupProtocol) {
        int numMessages = 100;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        ConsumerRecords records = this.awaitNonEmptyRecords(consumer, this.tp(), 0L);
        Assertions.assertEquals((int)numMessages, (int)records.count());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testNoOffsetForPartitionExceptionOnPollZero(String quorum, String groupProtocol) {
        void var13_16;
        Tuple2 tuple2;
        this.consumerConfig().setProperty("auto.offset.reset", "none");
        Properties x$1 = this.consumerConfig();
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, x$1, x$4);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        long l = 100L;
        long tryUntilNoAssertionError_waitTime = 15000L;
        long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void tryUntilNoAssertionError_pause;
            Right right;
            try {
                NoOffsetForPartitionException $anonfun$tryUntilNoAssertionError$1_res = PlaintextConsumerPollTest.$anonfun$testNoOffsetForPartitionExceptionOnPollZero$1(consumer);
                right = new Left((Object)$anonfun$tryUntilNoAssertionError$1_res);
            }
            catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                right = new Right((Object)$anonfun$tryUntilNoAssertionError$1_ae);
            }
            Object var17_12 = null;
            Object var18_13 = null;
            Right tryUntilNoAssertionError_computeUntilTrue_result = right;
            if (((Either)tryUntilNoAssertionError_computeUntilTrue_result).isLeft()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + tryUntilNoAssertionError_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(tryUntilNoAssertionError_waitTime), (long)tryUntilNoAssertionError_pause));
        }
        Object var16_11 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Either tryUntilNoAssertionError_either = (Either)tuple22._1();
        if (var13_16 instanceof Left) {
            ((Left)var13_16).value();
            return;
        }
        if (var13_16 instanceof Right) {
            throw (AssertionError)((Right)var13_16).value();
        }
        throw new MatchError((Object)var13_16);
    }

    public void runMultiConsumerSessionTimeoutTest(boolean closeConsumer) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, 100, this.tp2(), this.sendRecords$default$4());
        String topic1 = "topic1";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)((SetOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(producer, topic1, 6, 100));
        Buffer consumerPollers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        consumerPollers.$plus$eq((Object)this.subscribeConsumerAndStartPolling(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()), (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)), this.subscribeConsumerAndStartPolling$default$3()));
        consumerPollers.$plus$eq((Object)this.subscribeConsumerAndStartPolling(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()), (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)), this.subscribeConsumerAndStartPolling$default$3()));
        Consumer timeoutConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.ConsumerAssignmentPoller timeoutPoller = this.subscribeConsumerAndStartPolling(timeoutConsumer, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)), this.subscribeConsumerAndStartPolling$default$3());
        consumerPollers.$plus$eq((Object)timeoutPoller);
        this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4(), this.validateGroupAssignment$default$5());
        timeoutPoller.shutdown();
        consumerPollers.$minus$eq((Object)timeoutPoller);
        if (closeConsumer) {
            timeoutConsumer.close();
        }
        this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, (Option<String>)new Some((Object)new StringBuilder(68).append("Did not get valid assignment for partitions ").append(CollectionConverters$.MODULE$.SetHasAsJava((Set)subscriptions).asJava()).append(" after one consumer left").toString()), 3L * this.groupMaxSessionTimeoutMs(), this.validateGroupAssignment$default$5());
        consumerPollers.foreach((Function1 & Serializable)poller -> {
            poller.shutdown();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ NoOffsetForPartitionException $anonfun$testNoOffsetForPartitionExceptionOnPollZero$1(Consumer consumer$2) {
        return (NoOffsetForPartitionException)Assertions.assertThrows(NoOffsetForPartitionException.class, () -> consumer$2.poll(Duration.ZERO));
    }
}

