/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.time.Duration;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import kafka.api.AbstractConsumerTest;
import kafka.api.BaseConsumerTest$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@Timeout(value=600L)
@ScalaSignature(bytes="\u0006\u0005\u0005\u001db\u0001B\u0007\u000f\u0001MAQ\u0001\u0007\u0001\u0005\u0002eAQa\u0007\u0001\u0005\u0002qAQ!\u0014\u0001\u0005\u00029CQ\u0001\u0016\u0001\u0005\u0002UCQa\u0017\u0001\u0005\u0002qCQA\u0019\u0001\u0005\u0002\rDQ!\u001b\u0001\u0005\u0002)DQ\u0001\u001d\u0001\u0005\u0002E<QA \b\t\u0002}4a!\u0004\b\t\u0002\u0005\u0005\u0001B\u0002\r\u000b\t\u0003\tI\u0001\u0003\u0004M\u0015\u0011\u0005\u00111\u0002\u0002\"!2\f\u0017N\u001c;fqR\u001cuN\\:v[\u0016\u00148+\u001e2tGJL\u0007\u000f^5p]R+7\u000f\u001e\u0006\u0003\u001fA\t1!\u00199j\u0015\u0005\t\u0012!B6bM.\f7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\f\u000e\u00039I!a\u0006\b\u0003)\u0005\u00137\u000f\u001e:bGR\u001cuN\\:v[\u0016\u0014H+Z:u\u0003\u0019a\u0014N\\5u}Q\t!\u0004\u0005\u0002\u0016\u0001\u00059B/Z:u!\u0006$H/\u001a:o'V\u00147o\u0019:jaRLwN\u001c\u000b\u0004;\r\u0002\u0004C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"\u0001B+oSRDQ\u0001\n\u0002A\u0002\u0015\na!];peVl\u0007C\u0001\u0014.\u001d\t93\u0006\u0005\u0002)?5\t\u0011F\u0003\u0002+%\u00051AH]8pizJ!\u0001L\u0010\u0002\rA\u0013X\rZ3g\u0013\tqsF\u0001\u0004TiJLgn\u001a\u0006\u0003Y}AQ!\r\u0002A\u0002\u0015\nQb\u001a:pkB\u0004&o\u001c;pG>d\u0007\u0006\u0002\u00024\u007f\u0001\u0003\"\u0001N\u001f\u000e\u0003UR!AN\u001c\u0002\rA\f'/Y7t\u0015\tA\u0014(A\u0004kkBLG/\u001a:\u000b\u0005iZ\u0014!\u00026v]&$(\"\u0001\u001f\u0002\u0007=\u0014x-\u0003\u0002?k\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0002\u0003\u0006Q3\u0010Z5ta2\f\u0017PT1nKvt\u0013/^8sk6l4\u0010M?/OJ|W\u000f\u001d)s_R|7m\u001c7>wFj\b\u0006\u0002\u0002D\u0013*\u0003\"\u0001R$\u000e\u0003\u0015S!AR\u001b\u0002\u0011A\u0014xN^5eKJL!\u0001S#\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u0003-\u000b\u0013\u0001T\u0001+O\u0016$H+Z:u#V|'/^7B]\u0012<%o\\;q!J|Go\\2pYB\u000b'/Y7fi\u0016\u00148/\u00117m\u0003\u0005\"Xm\u001d;Tk\n\u001cX-];f]R\u0004\u0016\r\u001e;fe:\u001cVOY:de&\u0004H/[8o)\rir\n\u0015\u0005\u0006I\r\u0001\r!\n\u0005\u0006c\r\u0001\r!\n\u0015\u0005\u0007Mz\u0004\t\u000b\u0003\u0004\u0007&\u001bF&A&\u00023Q,7\u000f\u001e)biR,'O\\+ogV\u00147o\u0019:jaRLwN\u001c\u000b\u0004;Y;\u0006\"\u0002\u0013\u0005\u0001\u0004)\u0003\"B\u0019\u0005\u0001\u0004)\u0003\u0006\u0002\u00034\u007f\u0001CC\u0001B\"J52\n1*A\u0010uKN$X\t\u001f9b]\u0012Lgn\u001a+pa&\u001c7+\u001e2tGJL\u0007\u000f^5p]N$2!H/_\u0011\u0015!S\u00011\u0001&\u0011\u0015\tT\u00011\u0001&Q\u0011)1g\u0010!)\t\u0015\u0019\u0015*\u0019\u0017\u0002\u0017\u0006yB/Z:u'\"\u0014\u0018N\\6j]\u001e$v\u000e]5d'V\u00147o\u0019:jaRLwN\\:\u0015\u0007u!W\rC\u0003%\r\u0001\u0007Q\u0005C\u00032\r\u0001\u0007Q\u0005\u000b\u0003\u0007g}\u0002\u0005\u0006\u0002\u0004D\u0013\"d\u0013aS\u0001\u0015i\u0016\u001cH/\u00168tk\n\u001c8M]5cKR{\u0007/[2\u0015\u0007uYG\u000eC\u0003%\u000f\u0001\u0007Q\u0005C\u00032\u000f\u0001\u0007Q\u0005\u000b\u0003\bg}\u0002\u0005\u0006B\u0004D\u0013>d\u0013aS\u0001\u001ai\u0016\u001cHoU;cg\u000e\u0014\u0018NY3J]Z\fG.\u001b3U_BL7\rF\u0002\u001eeNDQ\u0001\n\u0005A\u0002\u0015BQ!\r\u0005A\u0002\u0015BC\u0001C\u001a@\u0001\"\"\u0001bQ%wY\u0005Y\u0005\u0006\u0002\u0001y\u0013v\u0004\"!_>\u000e\u0003iT!aD\u001c\n\u0005qT(a\u0002+j[\u0016|W\u000f\u001e\u0010\u0003\u0005a\u000b\u0011\u0005\u00157bS:$X\r\u001f;D_:\u001cX/\\3s'V\u00147o\u0019:jaRLwN\u001c+fgR\u0004\"!\u0006\u0006\u0014\u0007)\t\u0019\u0001E\u0002\u001f\u0003\u000bI1!a\u0002 \u0005\u0019\te.\u001f*fMR\tq0\u0006\u0002\u0002\u000eA1\u0011qBA\u000f\u0003Ci!!!\u0005\u000b\t\u0005M\u0011QC\u0001\u0007gR\u0014X-Y7\u000b\t\u0005]\u0011\u0011D\u0001\u0005kRLGN\u0003\u0002\u0002\u001c\u0005!!.\u0019<b\u0013\u0011\ty\"!\u0005\u0003\rM#(/Z1n!\r!\u00151E\u0005\u0004\u0003K)%!C!sOVlWM\u001c;t\u0001")
public class PlaintextConsumerSubscriptionTest
extends AbstractConsumerTest {
    public static Stream<Arguments> getTestQuorumAndGroupProtocolParametersAll() {
        return BaseConsumerTest$.MODULE$.getTestQuorumAndGroupProtocolParametersAll();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPatternSubscription(String quorum, String groupProtocol) {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        String topic1 = "tblablac";
        this.createTopic(topic1, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 1), this.sendRecords$default$4());
        String topic2 = "tblablak";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.sendRecords(producer, 1000, new TopicPartition(topic2, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic2, 1), this.sendRecords$default$4());
        String topic3 = "tblab1";
        this.createTopic(topic3, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.sendRecords(producer, 1000, new TopicPartition(topic3, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic3, 1), this.sendRecords$default$4());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        Pattern pattern = Pattern.compile("t.*c");
        consumer.subscribe(pattern, (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener(this));
        Set assignment = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}));
        this.awaitAssignment(consumer, (Set<TopicPartition>)assignment);
        String topic4 = "tsomec";
        this.createTopic(topic4, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.sendRecords(producer, 1000, new TopicPartition(topic4, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic4, 1), this.sendRecords$default$4());
        assignment = (Set)assignment.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic4, 0), new TopicPartition(topic4, 1)})));
        this.awaitAssignment(consumer, (Set<TopicPartition>)assignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testSubsequentPatternSubscription(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("metadata.max.age.ms", "30000");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        String fooTopic = "foo";
        this.createTopic(fooTopic, 1, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.sendRecords(producer, 1000, new TopicPartition(fooTopic, 0), this.sendRecords$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        Pattern pattern1 = Pattern.compile(".*o.*");
        consumer.subscribe(pattern1, (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener(this));
        Set assignment = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(fooTopic, 0)}));
        this.awaitAssignment(consumer, (Set<TopicPartition>)assignment);
        String barTopic = "bar";
        this.createTopic(barTopic, 1, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.sendRecords(producer, 1000, new TopicPartition(barTopic, 0), this.sendRecords$default$4());
        Pattern pattern2 = Pattern.compile("...");
        consumer.subscribe(pattern2, (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener(this));
        assignment = (Set)assignment.$minus$minus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)})));
        assignment = (Set)assignment.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(barTopic, 0)})));
        this.awaitAssignment(consumer, (Set<TopicPartition>)assignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPatternUnsubscription(String quorum, String groupProtocol) {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        String topic1 = "tblablac";
        this.createTopic(topic1, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 1), this.sendRecords$default$4());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.subscribe(Pattern.compile("t.*c"), (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener(this));
        Set assignment = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}));
        this.awaitAssignment(consumer, (Set<TopicPartition>)assignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testExpandingTopicSubscriptions(String quorum, String groupProtocol) {
        String otherTopic = "other";
        Set initialAssignment = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.awaitAssignment(consumer, (Set<TopicPartition>)initialAssignment);
        this.createTopic(otherTopic, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        Set expandedAssignment = (Set)initialAssignment.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)})));
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)otherTopic, (List)Nil$.MODULE$))).asJava());
        this.awaitAssignment(consumer, (Set<TopicPartition>)expandedAssignment);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testShrinkingTopicSubscriptions(String quorum, String groupProtocol) {
        String otherTopic = "other";
        this.createTopic(otherTopic, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        Set initialAssignment = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)}));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)otherTopic, (List)Nil$.MODULE$))).asJava());
        this.awaitAssignment(consumer, (Set<TopicPartition>)initialAssignment);
        Set shrunkenAssignment = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.awaitAssignment(consumer, (Set<TopicPartition>)shrunkenAssignment);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testUnsubscribeTopic(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("session.timeout.ms", "100");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "30");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener(this);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Nil$.MODULE$).asJava());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testSubscribeInvalidTopic(String quorum, String groupProtocol) {
        String invalidTopicName = "topic abc";
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)invalidTopicName, (List)Nil$.MODULE$)).asJava());
        Object var12_5 = null;
        long x$4 = 100L;
        long waitUntilTrue_waitTimeMs = 5000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            try {
                consumer.poll(Duration.ofMillis(500L));
            }
            catch (InvalidTopicException invalidTopicException) {
            }
            catch (Throwable $anonfun$testSubscribeInvalidTopic$1_e) {
                Assertions.fail((String)new StringBuilder(57).append("An InvalidTopicException should be thrown. But ").append($anonfun$testSubscribeInvalidTopic$1_e.getClass()).append(" is thrown").toString());
            }
            Object var11_10 = null;
            if ((InvalidTopicException)var12_5 != null) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"An InvalidTopicException should be thrown.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), x$4));
        }
        Assertions.assertEquals((Object)new StringBuilder(18).append("Invalid topics: [").append(invalidTopicName).append("]").toString(), (Object)((InvalidTopicException)var12_5).getMessage());
    }

    public static final /* synthetic */ boolean $anonfun$testSubscribeInvalidTopic$1(Consumer consumer$1, ObjectRef exception$1) {
        try {
            consumer$1.poll(Duration.ofMillis(500L));
        }
        catch (InvalidTopicException e) {
            exception$1.elem = e;
        }
        catch (Throwable e) {
            Assertions.fail((String)new StringBuilder(57).append("An InvalidTopicException should be thrown. But ").append(e.getClass()).append(" is thrown").toString());
        }
        return (InvalidTopicException)((Object)exception$1.elem) != null;
    }

    public static final /* synthetic */ String $anonfun$testSubscribeInvalidTopic$2() {
        return "An InvalidTopicException should be thrown.";
    }
}

