/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import kafka.server.ControllerConfigurationValidator;
import kafka.server.KafkaConfig;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005]4A\u0001F\u000b\u00015!)\u0011\u0005\u0001C\u0001E!9Q\u0005\u0001b\u0001\n\u00031\u0003B\u0002\u0016\u0001A\u0003%q\u0005C\u0004,\u0001\t\u0007I\u0011\u0001\u0017\t\rA\u0002\u0001\u0015!\u0003.\u0011\u0015\t\u0004\u0001\"\u00013\u0011\u0015\u0019\u0005\u0001\"\u00013\u0011\u0015)\u0005\u0001\"\u00013\u0011\u00159\u0005\u0001\"\u00013\u0011\u0015I\u0005\u0001\"\u00013\u0011\u0015Y\u0005\u0001\"\u00013\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u0015I\u0007\u0001\"\u00013\u0011\u0015Y\u0007\u0001\"\u00013\u0011\u0015i\u0007\u0001\"\u00013\u0011\u0015y\u0007\u0001\"\u00013\u0011\u0015\t\b\u0001\"\u00013\u0011\u0015\u0019\b\u0001\"\u00013\u0011\u0015)\b\u0001\"\u00013\u0005\u0011\u001auN\u001c;s_2dWM]\"p]\u001aLw-\u001e:bi&|gNV1mS\u0012\fGo\u001c:UKN$(B\u0001\f\u0018\u0003\u0019\u0019XM\u001d<fe*\t\u0001$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Y\u0002C\u0001\u000f \u001b\u0005i\"\"\u0001\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001j\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002GA\u0011A\u0005A\u0007\u0002+\u000511m\u001c8gS\u001e,\u0012a\n\t\u0003I!J!!K\u000b\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\bG>tg-[4!\u0003%1\u0018\r\\5eCR|'/F\u0001.!\t!c&\u0003\u00020+\t\u00013i\u001c8ue>dG.\u001a:D_:4\u0017nZ;sCRLwN\u001c,bY&$\u0017\r^8s\u0003)1\u0018\r\\5eCR|'\u000fI\u0001#i\u0016\u001cH\u000fR3gCVdG\u000fV8qS\u000e\u0014Vm]8ve\u000e,\u0017j\u001d*fU\u0016\u001cG/\u001a3\u0015\u0003M\u0002\"\u0001\b\u001b\n\u0005Uj\"\u0001B+oSRD#AB\u001c\u0011\u0005a\nU\"A\u001d\u000b\u0005iZ\u0014aA1qS*\u0011A(P\u0001\bUV\u0004\u0018\u000e^3s\u0015\tqt(A\u0003kk:LGOC\u0001A\u0003\ry'oZ\u0005\u0003\u0005f\u0012A\u0001V3ti\u0006aB/Z:u\u0013:4\u0018\r\\5e)>\u0004\u0018n\u0019(b[\u0016\u0014VM[3di\u0016$\u0007FA\u00048\u0003]!Xm\u001d;V].twn\u001e8SKN|WO]2f)f\u0004X\r\u000b\u0002\to\u0005AB/Z:u\u001dVdG\u000eV8qS\u000e\u001cuN\u001c4jOZ\u000bG.^3)\u0005%9\u0014\u0001\u0006;fgR4\u0016\r\\5e)>\u0004\u0018nY\"p]\u001aLw\r\u000b\u0002\u000bo\u00051B/Z:u\u0013:4\u0018\r\\5e)>\u0004\u0018nY\"p]\u001aLw\r\u000b\u0002\fo\u0005)C/Z:u\t&\u001c\u0018M\u00197j]\u001e\u0014V-\\8uKN#xN]1hKR{\u0007/[2D_:4\u0017n\u001a\u000b\u0003g=CQ\u0001\u0015\u0007A\u0002E\u000bqc^1t%\u0016lw\u000e^3Ti>\u0014\u0018mZ3F]\u0006\u0014G.\u001a3\u0011\u0005q\u0011\u0016BA*\u001e\u0005\u001d\u0011un\u001c7fC:DC\u0001D+\\9B\u0011a+W\u0007\u0002/*\u0011\u0001lO\u0001\u0007a\u0006\u0014\u0018-\\:\n\u0005i;&!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\u0005i\u0016a\u0012;fgR$\u0015n]1cY&twMU3n_R,7\u000b^8sC\u001e,Gk\u001c9jG\u000e{gNZ5hA]LG\u000f\u001b\u0011xCN\u0014V-\\8uKN#xN]1hK\u0016s\u0017M\u00197fIj\u00023\u0010M?)\t1yVM\u001a\t\u0003A\u000el\u0011!\u0019\u0006\u0003E^\u000b\u0001\u0002\u001d:pm&$WM]\u0005\u0003I\u0006\u00141BV1mk\u0016\u001cv.\u001e:dK\u0006A!m\\8mK\u0006t7\u000f\f\u0002hQf\t\u0011!G\u0001\u0001\u0003]!Xm\u001d;J]Z\fG.\u001b3Ce>\\WM]#oi&$\u0018\u0010\u000b\u0002\u000eo\u0005YB/Z:u\u0013:4\u0018\r\\5e\u001d\u0016<\u0017\r^5wK\n\u0013xn[3s\u0013\u0012D#AD\u001c\u00029Q,7\u000f\u001e,bY&$7\t\\5f]RlU\r\u001e:jGN\u001cuN\u001c4jO\"\u0012qbN\u0001/i\u0016\u001cH/\u00138wC2LGmU;cg\u000e\u0014\u0018\u000e\u001d;j_:t\u0015-\\3DY&,g\u000e^'fiJL7m]\"p]\u001aLw\r\u000b\u0002\u0011o\u00051C/Z:u\u0013:4\u0018\r\\5e\u0013:$XM\u001d<bY\u000ec\u0017.\u001a8u\u001b\u0016$(/[2t\u0007>tg-[4)\u0005E9\u0014A\n;fgR,f\u000eZ3gS:,GmQ8oM&<7\t\\5f]RlU\r\u001e:jGN\u001cuN\u001c4jO\"\u0012!cN\u0001$i\u0016\u001cH/\u00138wC2LG-T1uG\"\u001cE.[3oi6+GO]5dg\u000e{gNZ5hQ\t\u0019r\u0007")
public class ControllerConfigurationValidatorTest {
    private final KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createDummyBrokerConfig());
    private final ControllerConfigurationValidator validator = new ControllerConfigurationValidator(this.config());

    public KafkaConfig config() {
        return this.config;
    }

    public ControllerConfigurationValidator validator() {
        return this.validator;
    }

    @Test
    public void testDefaultTopicResourceIsRejected() {
        Assertions.assertEquals((Object)"Default topic resources are not allowed.", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, ""), Collections.emptyMap(), Collections.emptyMap())).getMessage());
    }

    @Test
    public void testInvalidTopicNameRejected() {
        Assertions.assertEquals((Object)"Topic name is invalid: '(<-invalid->)' contains one or more characters other than ASCII alphanumerics, '.', '_' and '-'", (Object)Assertions.assertThrows(InvalidTopicException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "(<-invalid->)"), Collections.emptyMap(), Collections.emptyMap())).getMessage());
    }

    @Test
    public void testUnknownResourceType() {
        Assertions.assertEquals((Object)"Unknown resource type BROKER_LOGGER", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "foo"), Collections.emptyMap(), Collections.emptyMap())).getMessage());
    }

    @Test
    public void testNullTopicConfigValue() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "10");
        config.put("segment.bytes", null);
        config.put("segment.ms", null);
        Assertions.assertEquals((Object)"Null value not supported for topic configs: segment.bytes,segment.ms", (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (Map)config, Collections.emptyMap())).getMessage());
    }

    @Test
    public void testValidTopicConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        config.put("segment.bytes", "67108864");
        this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), config, Collections.emptyMap());
    }

    @Test
    public void testInvalidTopicConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        config.put("segment.bytes", "67108864");
        config.put("foobar", "abc");
        Assertions.assertEquals((Object)"Unknown topic config name: foobar", (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (Map)config, Collections.emptyMap())).getMessage());
    }

    @ParameterizedTest(name="testDisablingRemoteStorageTopicConfig with wasRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testDisablingRemoteStorageTopicConfig(boolean wasRemoteStorageEnabled) {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("remote.storage.enable", "false");
        if (wasRemoteStorageEnabled) {
            Assertions.assertEquals((Object)"It is invalid to disable remote storage without deleting remote data. If you want to keep the remote data and turn to read only, please set `remote.storage.enable=true,remote.log.copy.disable=true`. If you want to disable remote storage and delete all remote data, please set `remote.storage.enable=false,remote.log.delete.on.disable=true`.", (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (Map)config, Collections.singletonMap("remote.storage.enable", "true"))).getMessage());
            return;
        }
        this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), config, Collections.emptyMap());
        this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), config, Collections.singletonMap("remote.storage.enable", "false"));
    }

    @Test
    public void testInvalidBrokerEntity() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        Assertions.assertEquals((Object)"Unable to parse broker name as a base 10 number.", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.BROKER, "blah"), (Map)config, Collections.emptyMap())).getMessage());
    }

    @Test
    public void testInvalidNegativeBrokerId() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        Assertions.assertEquals((Object)"Invalid negative broker ID.", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.BROKER, "-1"), (Map)config, Collections.emptyMap())).getMessage());
    }

    @Test
    public void testValidClientMetricsConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("interval.ms", "2000");
        config.put("metrics", "org.apache.kafka.client.producer.partition.queue.,org.apache.kafka.client.producer.partition.latency");
        config.put("match", "client_instance_id=b69cc35a-7a54-4790-aa69-cc2bd4ee4538,client_id=1,client_software_name=apache-kafka-java,client_software_version=2.8.0-SNAPSHOT,client_source_address=127.0.0.1,client_source_port=1234");
        this.validator().validate(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "subscription-1"), config, Collections.emptyMap());
    }

    @Test
    public void testInvalidSubscriptionNameClientMetricsConfig() {
        TreeMap config = new TreeMap();
        Assertions.assertEquals((Object)"Subscription name can't be empty", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, ""), (Map)config, Collections.emptyMap())).getMessage());
    }

    @Test
    public void testInvalidIntervalClientMetricsConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("interval.ms", "10");
        Assertions.assertEquals((Object)"Invalid value 10 for interval.ms, interval must be between 100 and 3600000 (1 hour)", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "subscription-1"), (Map)config, Collections.emptyMap())).getMessage());
        config.put("interval.ms", "3600001");
        Assertions.assertEquals((Object)"Invalid value 3600001 for interval.ms, interval must be between 100 and 3600000 (1 hour)", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "subscription-1"), (Map)config, Collections.emptyMap())).getMessage());
    }

    @Test
    public void testUndefinedConfigClientMetricsConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("random", "10");
        Assertions.assertEquals((Object)"Unknown client metrics configuration: random", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "subscription-1"), (Map)config, Collections.emptyMap())).getMessage());
    }

    @Test
    public void testInvalidMatchClientMetricsConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("match", "10");
        Assertions.assertEquals((Object)"Illegal client matching pattern: 10", (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "subscription-1"), (Map)config, Collections.emptyMap())).getMessage());
    }
}

