/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Meter;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.BrokerFeatures$;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.Fetching$;
import kafka.server.InitialFetchState;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LeaderEndPoint;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory;
import kafka.server.RemoteLeaderEndPoint;
import kafka.server.ReplicaAlterLogDirsManager;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicaState;
import kafka.server.ReplicationQuotaManager;
import kafka.server.Truncating$;
import kafka.server.epoch.util.MockBlockingSender;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordValidationStats;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\rub\u0001\u0002\u001e<\u0001\u0001CQa\u0012\u0001\u0005\u0002!Cqa\u0013\u0001C\u0002\u0013%A\n\u0003\u0004Y\u0001\u0001\u0006I!\u0014\u0005\b3\u0002\u0011\r\u0011\"\u0003M\u0011\u0019Q\u0006\u0001)A\u0005\u001b\"91\f\u0001b\u0001\n\u0013a\u0005B\u0002/\u0001A\u0003%Q\nC\u0004^\u0001\t\u0007I\u0011\u00020\t\r\t\u0004\u0001\u0015!\u0003`\u0011\u001d\u0019\u0007A1A\u0005\nyCa\u0001\u001a\u0001!\u0002\u0013y\u0006bB3\u0001\u0005\u0004%IA\u001a\u0005\u0007k\u0002\u0001\u000b\u0011B4\t\u000fY\u0004!\u0019!C\u0005o\"1a\u0010\u0001Q\u0001\naD\u0001b \u0001C\u0002\u0013%\u0011\u0011\u0001\u0005\t\u0003\u0013\u0001\u0001\u0015!\u0003\u0002\u0004!I\u00111\u0002\u0001C\u0002\u0013%\u0011Q\u0002\u0005\t\u0003_\u0001\u0001\u0015!\u0003\u0002\u0010!I\u0011\u0011\u0007\u0001C\u0002\u0013%\u00111\u0007\u0005\t\u0003\u0003\u0002\u0001\u0015!\u0003\u00026!I\u00111\t\u0001A\u0002\u0013%\u0011Q\t\u0005\n\u0003'\u0002\u0001\u0019!C\u0005\u0003+B\u0001\"!\u0019\u0001A\u0003&\u0011q\t\u0005\b\u0003G\u0002A\u0011BA3\u0011%\tY\tAI\u0001\n\u0013\ti\tC\u0004\u0002$\u0002!\t!!*\t\u000f\u0005u\u0006\u0001\"\u0003\u0002@\"9!Q\u0002\u0001\u0005\u0002\u0005\u0015\u0006b\u0002B\f\u0001\u0011\u0005\u0011Q\u0015\u0005\b\u00057\u0001A\u0011\u0001B\u000f\u0011\u001d\u0011Y\u0004\u0001C\u0001\u0003KCqAa\u0010\u0001\t\u0003\t)\u000bC\u0004\u0003D\u0001!\t!!*\t\u000f\t\u001d\u0003\u0001\"\u0003\u0003J!I!q\f\u0001\u0012\u0002\u0013%\u0011Q\u0012\u0005\b\u0005C\u0002A\u0011AAS\u0011\u001d\u0011)\u0007\u0001C\u0001\u0003KCqA!\u001b\u0001\t\u0003\t)\u000bC\u0004\u0003n\u0001!\t!!*\t\u000f\tE\u0004\u0001\"\u0001\u0002&\"9!Q\u000f\u0001\u0005\u0002\u0005\u0015\u0006b\u0002B=\u0001\u0011\u0005\u0011Q\u0015\u0005\b\u0005{\u0002A\u0011AAS\u0011\u001d\u0011\t\t\u0001C\u0001\u0003KCqA!\"\u0001\t\u0003\t)\u000bC\u0004\u0003\n\u0002!\t!!*\t\u000f\t5\u0005\u0001\"\u0001\u0002&\"9!\u0011\u0013\u0001\u0005\u0002\u0005\u0015\u0006b\u0002BK\u0001\u0011\u0005\u0011Q\u0015\u0005\b\u00053\u0003A\u0011AAS\u0011\u001d\u0011i\n\u0001C\u0001\u0005?CqA!3\u0001\t\u0013\u0011Y\rC\u0004\u0003J\u0002!IA!?\t\u000f\rE\u0001\u0001\"\u0003\u0004\u0014!91\u0011\u0004\u0001\u0005\u0002\rm\u0001bBB\u001d\u0001\u0011%11\b\u0002\u0019%\u0016\u0004H.[2b\r\u0016$8\r[3s)\"\u0014X-\u00193UKN$(B\u0001\u001f>\u0003\u0019\u0019XM\u001d<fe*\ta(A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\u0005C\u0001\"F\u001b\u0005\u0019%\"\u0001#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001b%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0013B\u0011!\nA\u0007\u0002w\u0005!A/\r91+\u0005i\u0005C\u0001(W\u001b\u0005y%B\u0001)R\u0003\u0019\u0019w.\\7p]*\u0011aH\u0015\u0006\u0003'R\u000ba!\u00199bG\",'\"A+\u0002\u0007=\u0014x-\u0003\u0002X\u001f\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017!\u0002;2aB\u0002\u0013\u0001\u0002;2aF\nQ\u0001^\u0019qc\u0001\nA\u0001\u001e\u001aqc\u0005)AO\r92A\u0005AAo\u001c9jG&#\u0017'F\u0001`!\tq\u0005-\u0003\u0002b\u001f\n!Q+^5e\u0003%!x\u000e]5d\u0013\u0012\f\u0004%\u0001\u0005u_BL7-\u001333\u0003%!x\u000e]5d\u0013\u0012\u0014\u0004%\u0001\u0005u_BL7-\u00133t+\u00059\u0007\u0003\u00025l[~k\u0011!\u001b\u0006\u0003U\u000e\u000b!bY8mY\u0016\u001cG/[8o\u0013\ta\u0017NA\u0002NCB\u0004\"A\\:\u000e\u0003=T!\u0001]9\u0002\t1\fgn\u001a\u0006\u0002e\u0006!!.\u0019<b\u0013\t!xN\u0001\u0004TiJLgnZ\u0001\ni>\u0004\u0018nY%eg\u0002\naB\u0019:pW\u0016\u0014XI\u001c3Q_&tG/F\u0001y!\tIH0D\u0001{\u0015\tYX(A\u0004dYV\u001cH/\u001a:\n\u0005uT(A\u0004\"s_.,'/\u00128e!>Lg\u000e^\u0001\u0010EJ|7.\u001a:F]\u0012\u0004v.\u001b8uA\u0005\u0001b-Y5mK\u0012\u0004\u0016M\u001d;ji&|gn]\u000b\u0003\u0003\u0007\u00012ASA\u0003\u0013\r\t9a\u000f\u0002\u0011\r\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\f\u0011CZ1jY\u0016$\u0007+\u0019:uSRLwN\\:!\u0003=\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016\u001cXCAA\b!\u0019\t\t\"a\u0006\u0002\u001c5\u0011\u00111\u0003\u0006\u0004\u0003+\t\u0018\u0001B;uS2LA!!\u0007\u0002\u0014\t!A*[:u!\u0011\ti\"!\u000b\u000f\t\u0005}\u0011QE\u0007\u0003\u0003CQ1!a\tP\u0003\u001diWm]:bO\u0016LA!a\n\u0002\"\u0005IR\u000b\u001d3bi\u0016lU\r^1eCR\f'+Z9vKN$H)\u0019;b\u0013\u0011\tY#!\f\u00039U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCB\u000b'\u000f^5uS>t7\u000b^1uK*!\u0011qEA\u0011\u0003A\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016\u001c\b%A\u000bva\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;\u0016\u0005\u0005U\u0002\u0003BA\u001c\u0003{i!!!\u000f\u000b\u0007\u0005mr*\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\ty$!\u000f\u0003+U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u00061R\u000f\u001d3bi\u0016lU\r^1eCR\f'+Z9vKN$\b%A\u0007nKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u000b\u0003\u0003\u000f\u0002B!!\u0013\u0002P5\u0011\u00111\n\u0006\u0004\u0003\u001bZ\u0014\u0001C7fi\u0006$\u0017\r^1\n\t\u0005E\u00131\n\u0002\u00105.lU\r^1eCR\f7)Y2iK\u0006\tR.\u001a;bI\u0006$\u0018mQ1dQ\u0016|F%Z9\u0015\t\u0005]\u0013Q\f\t\u0004\u0005\u0006e\u0013bAA.\u0007\n!QK\\5u\u0011%\tyfFA\u0001\u0002\u0004\t9%A\u0002yIE\na\"\\3uC\u0012\fG/Y\"bG\",\u0007%A\tj]&$\u0018.\u00197GKR\u001c\u0007n\u0015;bi\u0016$\u0002\"a\u001a\u0002n\u0005]\u0014\u0011\u0011\t\u0004\u0015\u0006%\u0014bAA6w\t\t\u0012J\\5uS\u0006dg)\u001a;dQN#\u0018\r^3\t\u000f\u0005=\u0014\u00041\u0001\u0002r\u00059Ao\u001c9jG&#\u0007\u0003\u0002\"\u0002t}K1!!\u001eD\u0005\u0019y\u0005\u000f^5p]\"9\u0011\u0011P\rA\u0002\u0005m\u0014a\u00034fi\u000eDwJ\u001a4tKR\u00042AQA?\u0013\r\tyh\u0011\u0002\u0005\u0019>tw\rC\u0005\u0002\u0004f\u0001\n\u00111\u0001\u0002\u0006\u0006YA.Z1eKJ,\u0005o\\2i!\r\u0011\u0015qQ\u0005\u0004\u0003\u0013\u001b%aA%oi\u0006Y\u0012N\\5uS\u0006dg)\u001a;dQN#\u0018\r^3%I\u00164\u0017-\u001e7uIM*\"!a$+\t\u0005\u0015\u0015\u0011S\u0016\u0003\u0003'\u0003B!!&\u0002 6\u0011\u0011q\u0013\u0006\u0005\u00033\u000bY*A\u0005v]\u000eDWmY6fI*\u0019\u0011QT\"\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\"\u0006]%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u000691\r\\3b]V\u0004HCAA,Q\rY\u0012\u0011\u0016\t\u0005\u0003W\u000bI,\u0004\u0002\u0002.*!\u0011qVAY\u0003\r\t\u0007/\u001b\u0006\u0005\u0003g\u000b),A\u0004kkBLG/\u001a:\u000b\u0007\u0005]F+A\u0003kk:LG/\u0003\u0003\u0002<\u00065&!C!gi\u0016\u0014X)Y2i\u0003i\u0019'/Z1uKJ+\u0007\u000f\\5dC\u001a+Go\u00195feRC'/Z1e)A\t\t-a2\u0002`\u0006\r\u0018Q^Ax\u0003s\u0014\u0019\u0001E\u0002K\u0003\u0007L1!!2<\u0005Q\u0011V\r\u001d7jG\u00064U\r^2iKJ$\u0006N]3bI\"9\u0011\u0011\u001a\u000fA\u0002\u0005-\u0017\u0001\u00028b[\u0016\u0004B!!4\u0002\\:!\u0011qZAl!\r\t\tnQ\u0007\u0003\u0003'T1!!6@\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\\\"\u0002\rA\u0013X\rZ3g\u0013\r!\u0018Q\u001c\u0006\u0004\u00033\u001c\u0005bBAq9\u0001\u0007\u0011QQ\u0001\nM\u0016$8\r[3s\u0013\u0012Dq!!:\u001d\u0001\u0004\t9/\u0001\u0007ce>\\WM]\"p]\u001aLw\rE\u0002K\u0003SL1!a;<\u0005-Y\u0015MZ6b\u0007>tg-[4\t\r}d\u0002\u0019AA\u0002\u0011\u001d\t\t\u0010\ba\u0001\u0003g\f!B]3qY&\u001c\u0017-T4s!\rQ\u0015Q_\u0005\u0004\u0003o\\$A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\b\u0003wd\u0002\u0019AA\u007f\u0003\u0015\tXo\u001c;b!\rQ\u0015q`\u0005\u0004\u0005\u0003Y$\u0001\u0004*fa2L7-Y)v_R\f\u0007b\u0002B\u00039\u0001\u0007!qA\u0001\u001bY\u0016\fG-\u001a:F]\u0012\u0004x.\u001b8u\u00052|7m[5oON+g\u000e\u001a\t\u0004\u0015\n%\u0011b\u0001B\u0006w\ta!\t\\8dW&twmU3oI\u0006A3\u000f[8vY\u0012\u001cVM\u001c3MCR,7\u000f\u001e*fcV,7\u000f\u001e,feNLwN\\:Cs\u0012+g-Y;mi\"\u001aQD!\u0005\u0011\t\u0005-&1C\u0005\u0005\u0005+\tiK\u0001\u0003UKN$\u0018A\u0010;fgR4U\r^2i\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NU3rk\u0016\u001cH/\u00134MCN$X\t]8dQ\u0012+g-\u001b8fI\u001a{'oU8nKB\u000b'\u000f^5uS>t7\u000fK\u0002\u001f\u0005#\tQ#Y:tKJ$\b+\u0019:uSRLwN\\*uCR,7\u000f\u0006\u0006\u0002X\t}!\u0011\u0006B\u001a\u0005oAqA!\t \u0001\u0004\u0011\u0019#A\u0004gKR\u001c\u0007.\u001a:\u0011\u0007)\u0013)#C\u0002\u0003(m\u0012Q#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG\rC\u0004\u0003,}\u0001\rA!\f\u0002+MDw.\u001e7e\u0005\u0016\u0014V-\u00193z\r>\u0014h)\u001a;dQB\u0019!Ia\f\n\u0007\tE2IA\u0004C_>dW-\u00198\t\u000f\tUr\u00041\u0001\u0003.\u0005)2\u000f[8vY\u0012\u0014U\r\u0016:v]\u000e\fG/\u001b8h\u0019><\u0007b\u0002B\u001d?\u0001\u0007!QF\u0001\u0010g\"|W\u000f\u001c3CK\u0012+G.Y=fI\u0006)3\u000f[8vY\u0012D\u0015M\u001c3mK\u0016C8-\u001a9uS>tgI]8n\u00052|7m[5oON+g\u000e\u001a\u0015\u0004A\tE\u0011aQ:i_VdGMR3uG\"dU-\u00193fe\u0016\u0003xn\u00195P]\u001aK'o\u001d;GKR\u001c\u0007n\u00148ms&3G*Z1eKJ,\u0005o\\2i\u0017:|wO\u001c+p\u0005>$\b.\u00132qeYB3!\tB\t\u0003a\u001a\bn\\;mI:{GOR3uG\"dU-\u00193fe\u0016\u0003xn\u00195P]\u001aK'o\u001d;GKR\u001c\u0007nV5uQR\u0013XO\\2bi\u0016|eNR3uG\"D3A\tB\t\u0003\t2XM]5gs\u001a+Go\u00195MK\u0006$WM]#q_\u000eDwJ\u001c$jeN$h)\u001a;dQR1\u0011q\u000bB&\u00057BqA!\u0014$\u0001\u0004\u0011y%A\u0002jEB\u0004BA!\u0015\u0003X5\u0011!1\u000b\u0006\u0004!\nU#B\u0001\u001fR\u0013\u0011\u0011IFa\u0015\u0003\u001f5+G/\u00193bi\u00064VM]:j_:D\u0011B!\u0018$!\u0003\u0005\r!!\"\u0002\u001f\u0015\u0004xn\u00195GKR\u001c\u0007nQ8v]R\fAF^3sS\u001aLh)\u001a;dQ2+\u0017\rZ3s\u000bB|7\r[(o\r&\u00148\u000f\u001e$fi\u000eDG\u0005Z3gCVdG\u000f\n\u001a\u0002iMDw.\u001e7e)J,hnY1uKR{wJ\u001a4tKR\u001c\u0006/Z2jM&,G-\u00138Fa>\u001c\u0007n\u00144gg\u0016$(+Z:q_:\u001cX\rK\u0002&\u0005#\tQj\u001d5pk2$GK];oG\u0006$X\rV8PM\u001a\u001cX\r^*qK\u000eLg-[3e\u0013:,\u0005o\\2i\u001f\u001a47/\u001a;SKN\u0004xN\\:f\u0013\u001a4u\u000e\u001c7po\u0016\u0014\b*Y:O_6{'/Z#q_\u000eD7\u000fK\u0002'\u0005#\t!j\u001d5pk2$g)\u001a;dQ2+\u0017\rZ3s\u000bB|7\r[*fG>tG\rV5nK&3G*Z1eKJ\u0014V\r\u001d7jKN<\u0016\u000e\u001e5Fa>\u001c\u0007NT8u\u0017:|wO\u001c+p\r>dGn\\<fe\"\u001aqE!\u0005\u0002\u0003NDw.\u001e7e)J,hnY1uK&3G*Z1eKJ\u0014V\r\u001d7jKN<\u0016\u000e\u001e5ESZ,'oZ5oO\u0016\u0003xn\u00195O_R\\en\\<o)>4u\u000e\u001c7po\u0016\u0014\bf\u0001\u0015\u0003\u0012\u0005iC/Z:u)J,hnY1uK>sg)\u001a;dQ\u0012{Wm\u001d(piV\u0003H-\u0019;f\u0011&<\u0007nV1uKJl\u0017M]6)\u0007%\u0012\t\"A\u000fuKN$H*Y4JgV\u0003H-\u0019;fI^CWM\u001c(p%\u0016\u001cwN\u001d3tQ\rQ#\u0011C\u00014g\"|W\u000f\u001c3Vg\u0016dU-\u00193fe\u0016sGm\u00144gg\u0016$\u0018JZ%oi\u0016\u0014(I]8lKJ4VM]:j_:\u0014U\r\\8xeAB3a\u000bB\t\u0003\u0001\u001b\bn\\;mIR\u0013XO\\2bi\u0016$v.\u00138ji&\fGNR3uG\"|eMZ:fi&3G*Z1eKJ\u0014V\r^;s]N,f\u000eZ3gS:,Gm\u00144gg\u0016$\bf\u0001\u0017\u0003\u0012\u0005\t4\u000f[8vY\u0012\u0004v\u000e\u001c7J]\u0012,g-\u001b8ji\u0016d\u00170\u00134MK\u0006$WM\u001d*fiV\u0014hn]!os\u0016C8-\u001a9uS>t\u0007fA\u0017\u0003\u0012\u0005Y3\u000f[8vY\u0012luN^3QCJ$\u0018\u000e^5p]N|U\u000f^(g)J,hnY1uS:<Gj\\4Ti\u0006$X\rK\u0002/\u0005#\t\u0001h\u001d5pk2$g)\u001b7uKJ\u0004\u0016M\u001d;ji&|gn]'bI\u0016dU-\u00193fe\u0012+(/\u001b8h\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NU3rk\u0016\u001cH\u000fK\u00020\u0005#\t\u0001j\u001d5pk2$7)\u0019;dQ\u0016C8-\u001a9uS>tgI]8n\u00052|7m[5oON+g\u000eZ,iK:\u001c\u0006.\u001e;uS:<Gi\\<o%\u0016\u0004H.[2b\r\u0016$8\r[3s)\"\u0014X-\u00193)\u0007A\u0012\t\"\u0001\u0014tQ>,H\u000eZ+qI\u0006$XMU3bgNLwM\\7f]R\u0014\u0015\u0010^3t\u0013:lU\r\u001e:jGND3!\rB\t\u0003\u0019\u001b\bn\\;mI:{G/\u00169eCR,'+Z1tg&<g.\\3oi\nKH/Z:J]6+GO]5dg^CWM\u001c(p%\u0016\f7o]5h]6,g\u000e^:J]B\u0013xn\u001a:fgND3A\rB\t\u00039!Xm\u001d;Ck&dGMR3uG\"D3a\rB\t\u00039\"Xm\u001d;M_\u000e\fGNR3uG\"\u001cu.\u001c9mKRLwN\\%g\u0011&<\u0007nV1uKJl\u0017M]6Va\u0012\fG/\u001a3\u0015\t\u0005]#\u0011\u0015\u0005\b\u0005G#\u0004\u0019\u0001B\u0017\u0003QA\u0017n\u001a5XCR,'/\\1sWV\u0003H-\u0019;fI\"\u001aAGa*\u0011\t\t%&qV\u0007\u0003\u0005WSAA!,\u00022\u00061\u0001/\u0019:b[NLAA!-\u0003,\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;)\u000fQ\u0012)L!1\u0003DB!!q\u0017B_\u001b\t\u0011IL\u0003\u0003\u0003<\n-\u0016\u0001\u00039s_ZLG-\u001a:\n\t\t}&\u0011\u0018\u0002\f-\u0006dW/Z*pkJ\u001cW-\u0001\u0005c_>dW-\u00198tY\u0011\u0011)Ma2\u001a\u0003\u0005I\u0012\u0001A\u0001\"]\u0016<xJ\u001a4tKR4uN\u001d'fC\u0012,'\u000fU1si&$\u0018n\u001c8SKN,H\u000e\u001e\u000b\t\u0005\u001b\u0014yOa=\u0003vB!!q\u001aBu\u001d\u0011\u0011\tN!:\u000f\t\tM'1\u001d\b\u0005\u0005+\u0014\tO\u0004\u0003\u0003X\n}g\u0002\u0002Bm\u0005;tA!!5\u0003\\&\tQ+\u0003\u0002T)&\u0011aHU\u0005\u0003!FK1!a\tP\u0013\u0011\u00119/!\t\u0002A=3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0005\u0005W\u0014iO\u0001\bFa>\u001c\u0007.\u00128e\u001f\u001a47/\u001a;\u000b\t\t\u001d\u0018\u0011\u0005\u0005\u0007\u0005c,\u0004\u0019A'\u0002\u0005Q\u0004\bbBABk\u0001\u0007\u0011Q\u0011\u0005\b\u0005o,\u0004\u0019AA>\u0003%)g\u000eZ(gMN,G\u000f\u0006\u0006\u0003N\nm(Q`B\u0007\u0007\u001fAaA!=7\u0001\u0004i\u0005b\u0002B\u0000m\u0001\u00071\u0011A\u0001\u0006KJ\u0014xN\u001d\t\u0005\u0007\u0007\u0019I!\u0004\u0002\u0004\u0006)\u00191qA(\u0002\u0011A\u0014x\u000e^8d_2LAaa\u0003\u0004\u0006\t1QI\u001d:peNDq!a!7\u0001\u0004\t)\tC\u0004\u0003xZ\u0002\r!a\u001f\u0002=\u0005\u001c8/\u001a:u!J|7-Z:t!\u0006\u0014H/\u001b;j_:$\u0015\r^1XQ\u0016tG\u0003BA,\u0007+Aqaa\u00068\u0001\u0004\u0011i#A\u0007jgJ+\u0017m]:jO:LgnZ\u0001\u0005gR,(\r\u0006\u0005\u0002X\ru1qEB\u0016\u0011\u001d\u0019y\u0002\u000fa\u0001\u0007C\t\u0011\u0002]1si&$\u0018n\u001c8\u0011\u0007e\u001c\u0019#C\u0002\u0004&i\u0014\u0011\u0002U1si&$\u0018n\u001c8\t\u000f\r%\u0002\b1\u0001\u0002t\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bbBB\u0017q\u0001\u00071qF\u0001\u0004Y><\u0007\u0003BB\u0019\u0007ki!aa\r\u000b\u0007\r5R(\u0003\u0003\u00048\rM\"AC+oS\u001aLW\r\u001a'pO\u0006a2.\u00194lC\u000e{gNZ5h\u001d>$&/\u001e8dCR,wJ\u001c$fi\u000eDWCAAt\u0001")
public class ReplicaFetcherThreadTest {
    private final TopicPartition t1p0 = new TopicPartition("topic1", 0);
    private final TopicPartition t1p1 = new TopicPartition("topic1", 1);
    private final TopicPartition t2p1 = new TopicPartition("topic2", 1);
    private final Uuid topicId1 = Uuid.randomUuid();
    private final Uuid topicId2 = Uuid.randomUuid();
    private final Map<String, Uuid> topicIds = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic1"), (Object)this.topicId1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic2"), (Object)this.topicId2())}));
    private final BrokerEndPoint brokerEndPoint = new BrokerEndPoint(0, "localhost", 1000);
    private final FailedPartitions kafka$server$ReplicaFetcherThreadTest$$failedPartitions = new FailedPartitions();
    private final java.util.List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName("topic1").setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName("topic2").setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0), (List)Nil$.MODULE$))).asJava();
    private final UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), 0, 0, 0L, this.partitionStates(), Collections.emptyList(), CollectionConverters$.MODULE$.MapHasAsJava(this.topicIds()).asJava()).build();
    private ZkMetadataCache metadataCache = new ZkMetadataCache(0, MetadataVersion.latestTesting(), BrokerFeatures$.MODULE$.createEmpty(), false);

    private TopicPartition t1p0() {
        return this.t1p0;
    }

    private TopicPartition t1p1() {
        return this.t1p1;
    }

    private TopicPartition t2p1() {
        return this.t2p1;
    }

    private Uuid topicId1() {
        return this.topicId1;
    }

    private Uuid topicId2() {
        return this.topicId2;
    }

    private Map<String, Uuid> topicIds() {
        return this.topicIds;
    }

    private BrokerEndPoint brokerEndPoint() {
        return this.brokerEndPoint;
    }

    public FailedPartitions kafka$server$ReplicaFetcherThreadTest$$failedPartitions() {
        return this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions;
    }

    private java.util.List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates() {
        return this.partitionStates;
    }

    private UpdateMetadataRequest updateMetadataRequest() {
        return this.updateMetadataRequest;
    }

    private ZkMetadataCache metadataCache() {
        return this.metadataCache;
    }

    private void metadataCache_$eq(ZkMetadataCache x$1) {
        this.metadataCache = x$1;
    }

    private InitialFetchState initialFetchState(Option<Uuid> topicId, long fetchOffset, int leaderEpoch) {
        BrokerEndPoint x$2 = new BrokerEndPoint(0, "localhost", 9092);
        return new InitialFetchState(topicId, x$2, leaderEpoch, fetchOffset);
    }

    private int initialFetchState$default$3() {
        return 1;
    }

    @AfterEach
    public void cleanup() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    private ReplicaFetcherThread createReplicaFetcherThread(String name, int fetcherId, KafkaConfig brokerConfig, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicaQuota quota, BlockingSend leaderEndpointBlockingSend) {
        LogContext logContext = new LogContext(new StringBuilder(51).append("[ReplicaFetcher replicaId=").append(brokerConfig.brokerId()).append(", leaderId=").append(leaderEndpointBlockingSend.brokerEndPoint().id()).append(", fetcherId=").append(fetcherId).append("] ").toString());
        FetchSessionHandler fetchSessionHandler = new FetchSessionHandler(logContext, leaderEndpointBlockingSend.brokerEndPoint().id());
        RemoteLeaderEndPoint leader = new RemoteLeaderEndPoint(logContext.logPrefix(), leaderEndpointBlockingSend, fetchSessionHandler, brokerConfig, replicaMgr, quota, (Function0 & Serializable)() -> brokerConfig.interBrokerProtocolVersion(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L);
        return new ReplicaFetcherThread(name, (LeaderEndPoint)leader, brokerConfig, failedPartitions, replicaMgr, quota, logContext.logPrefix(), (Function0 & Serializable)() -> brokerConfig.interBrokerProtocolVersion());
    }

    @Test
    public void shouldSendLatestRequestVersionsByDefault() {
        MetadataVersion testingVersion = MetadataVersion.latestTesting();
        Assertions.assertEquals((short)ApiKeys.FETCH.latestVersion(true), (short)testingVersion.fetchRequestVersion());
        Assertions.assertEquals((short)ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(true), (short)testingVersion.offsetForLeaderEpochRequestVersion());
        Assertions.assertEquals((short)ApiKeys.LIST_OFFSETS.latestVersion(true), (short)testingVersion.listOffsetRequestVersion());
    }

    @Test
    public void testFetchLeaderEpochRequestIfLastEpochDefinedForSomePartitions() {
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 5;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(0L, leaderEpoch)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map offsets = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), leaderEpoch, 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), leaderEpoch, 1L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsets, this.brokerEndPoint(), Time.SYSTEM);
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, (ReplicaQuota)quota, mockNetwork);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId2()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId2()), 0L, 1))})));
        this.assertPartitionStates((AbstractFetcherThread)thread, false, true, false);
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        this.assertPartitionStates((AbstractFetcherThread)thread, true, false, false);
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)2, (int)mockNetwork.fetchCount());
        this.assertPartitionStates((AbstractFetcherThread)thread, true, false, false);
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)3, (int)mockNetwork.fetchCount());
        this.assertPartitionStates((AbstractFetcherThread)thread, true, false, false);
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)3))).truncateTo(ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean());
    }

    public void assertPartitionStates(AbstractFetcherThread fetcher, boolean shouldBeReadyForFetch, boolean shouldBeTruncatingLog, boolean shouldBeDelayed) {
        new .colon.colon((Object)this.t1p0(), (List)new .colon.colon((Object)this.t1p1(), (List)new .colon.colon((Object)this.t2p1(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$assertPartitionStates$1(fetcher, shouldBeReadyForFetch, shouldBeTruncatingLog, shouldBeDelayed, tp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void shouldHandleExceptionFromBlockingSend() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        Mockito.when((Object)mockBlockingSend.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        Mockito.when((Object)mockBlockingSend.sendRequest((AbstractRequest.Builder)ArgumentMatchers.any())).thenThrow(new Throwable[]{new NullPointerException()});
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Map result = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, null, mockBlockingSend).leader().fetchEpochEndOffsets((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p0().partition()).setLeaderEpoch(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p1().partition()).setLeaderEpoch(0))})));
        Assertions.assertEquals((Object)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), Errors.UNKNOWN_SERVER_ERROR, -1, -1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), Errors.UNKNOWN_SERVER_ERROR, -1, -1L))}))), (Object)result, (String)"results from leader epoch request should have undefined offset");
        ((BlockingSend)Mockito.verify((Object)mockBlockingSend)).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any());
    }

    @Test
    public void shouldFetchLeaderEpochOnFirstFetchOnlyIfLeaderEpochKnownToBothIbp26() {
        this.verifyFetchLeaderEpochOnFirstFetch(MetadataVersion.IBP_2_6_IV0, 1);
    }

    @Test
    public void shouldNotFetchLeaderEpochOnFirstFetchWithTruncateOnFetch() {
        this.verifyFetchLeaderEpochOnFirstFetch(MetadataVersion.latestTesting(), 0);
    }

    private void verifyFetchLeaderEpochOnFirstFetch(MetadataVersion ibp, int epochFetchCount) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.setProperty("inter.broker.protocol.version", ibp.version());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.metadataCache_$eq(new ZkMetadataCache(0, ibp, BrokerFeatures$.MODULE$.createEmpty(), false));
        this.metadataCache().updateMetadata(0, this.updateMetadataRequest());
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 5;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(0L, leaderEpoch)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map offsets = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), leaderEpoch, 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), leaderEpoch, 1L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsets, this.brokerEndPoint(), Time.SYSTEM);
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, mockNetwork);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        thread.doWork();
        Assertions.assertEquals((int)epochFetchCount, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        thread.doWork();
        Assertions.assertEquals((int)epochFetchCount, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)2, (int)mockNetwork.fetchCount());
        thread.doWork();
        Assertions.assertEquals((int)epochFetchCount, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)3, (int)mockNetwork.fetchCount());
    }

    private int verifyFetchLeaderEpochOnFirstFetch$default$2() {
        return 1;
    }

    @Test
    public void shouldTruncateToOffsetSpecifiedInEpochOffsetResponse() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 5;
        int initialLEO = 200;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)((long)initialLEO - 1L)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)initialLEO, leaderEpoch)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLEO)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map offsetsReply = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), leaderEpoch, 156L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t2p1(), leaderEpoch, 172L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsetsReply, this.brokerEndPoint(), Time.SYSTEM);
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, (ReplicaQuota)quota, mockNetwork);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId2()), 0L, 1))})));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)156)), (String)new StringBuilder(58).append("Expected ").append(this.t1p0()).append(" to truncate to offset 156 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)172)), (String)new StringBuilder(58).append("Expected ").append(this.t2p1()).append(" to truncate to offset 172 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
    }

    @Test
    public void shouldTruncateToOffsetSpecifiedInEpochOffsetResponseIfFollowerHasNoMoreEpochs() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpochAtFollower = 5;
        int leaderEpochAtLeader = 4;
        int initialLEO = 200;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)((long)initialLEO - 3L)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpochAtFollower)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpochAtLeader)).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLEO)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map offsetsReply = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), leaderEpochAtLeader, 156L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t2p1(), leaderEpochAtLeader, 202L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsetsReply, this.brokerEndPoint(), Time.SYSTEM);
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, (ReplicaQuota)quota, mockNetwork);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId2()), 0L, 1))})));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)156)), (String)new StringBuilder(58).append("Expected ").append(this.t1p0()).append(" to truncate to offset 156 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)initialLEO)), (String)new StringBuilder(55).append("Expected ").append(this.t2p1()).append(" to truncate to offset ").append(initialLEO).append(" (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
    }

    @Test
    public void shouldFetchLeaderEpochSecondTimeIfLeaderRepliesWithEpochNotKnownToFollower() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int initialLEO = 200;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)((long)initialLEO - 2L)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)log.endOffsetForEpoch(4)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(120L, 3)));
        Mockito.when((Object)log.endOffsetForEpoch(3)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(120L, 3)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLEO)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map offsets = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), 4, 155L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), 4, 143L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsets, this.brokerEndPoint(), Time.SYSTEM);
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, (ReplicaQuota)quota, mockNetwork);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)0, (int)mockNetwork.fetchCount());
        java.util.Map nextOffsets = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), 3, 101L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), 3, 102L))}))).asJava();
        mockNetwork.setOffsetsForNextResponse(nextOffsets);
        thread.doWork();
        Assertions.assertEquals((int)2, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        Assertions.assertTrue((mockNetwork.lastUsedOffsetForLeaderEpochVersion() >= 3 ? 1 : 0) != 0, (String)"OffsetsForLeaderEpochRequest version.");
        thread.doWork();
        Assertions.assertEquals((int)2, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)2, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)4))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)102)), (String)new StringBuilder(58).append("Expected ").append(this.t1p1()).append(" to truncate to offset 102 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)101)), (String)new StringBuilder(58).append("Expected ").append(this.t1p0()).append(" to truncate to offset 101 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
    }

    @Test
    public void shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int initialLEO = 200;
        ObjectRef latestLogEpoch = ObjectRef.create((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)115L));
        Mockito.when((Object)log.latestEpoch()).thenAnswer(x$1 -> (Option)latestLogEpoch$1.elem);
        Mockito.when((Object)log.endOffsetForEpoch(4)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(149L, 4)));
        Mockito.when((Object)log.endOffsetForEpoch(3)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(129L, 2)));
        Mockito.when((Object)log.endOffsetForEpoch(2)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(119L, 1)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLEO)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        MockBlockingSender mockNetwork = new MockBlockingSender(Collections.emptyMap(), this.brokerEndPoint(), Time.SYSTEM);
        LogContext logContext = new LogContext(new StringBuilder(52).append("[ReplicaFetcher replicaId=").append(config.brokerId()).append(", leaderId=").append(this.brokerEndPoint().id()).append(", fetcherId=0] ").toString());
        FetchSessionHandler fetchSessionHandler = new FetchSessionHandler(logContext, this.brokerEndPoint().id());
        RemoteLeaderEndPoint leader = new RemoteLeaderEndPoint(logContext.logPrefix(), (BlockingSend)mockNetwork, fetchSessionHandler, config, replicaManager, (ReplicaQuota)quota, (Function0 & Serializable)() -> config.interBrokerProtocolVersion(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L);
        ReplicaFetcherThread thread = new ReplicaFetcherThread(this, leader, config, replicaManager, quota, logContext){

            public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
                return None$.MODULE$;
            }
        };
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), initialLEO, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), initialLEO, 1))})));
        scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.t1p0(), this.t1p1()}));
        thread.doWork();
        Assertions.assertEquals((int)0, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        partitions.foreach((Function1 & Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$4(thread, tp);
            return BoxedUnit.UNIT;
        });
        mockNetwork.setFetchPartitionDataForNextResponse((Map<TopicPartition, FetchResponseData.PartitionData>)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p0().partition(), new FetchResponseData.EpochEndOffset().setEpoch(4).setEndOffset(140L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p1().partition(), new FetchResponseData.EpochEndOffset().setEpoch(4).setEndOffset(141L)))}))));
        mockNetwork.setIdsForNextResponse(this.topicIds());
        latestLogEpoch.elem = new Some((Object)BoxesRunTime.boxToInteger((int)4));
        thread.doWork();
        Assertions.assertEquals((int)0, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)2, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)140)), (String)new StringBuilder(58).append("Expected ").append(this.t1p0()).append(" to truncate to offset 140 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)141)), (String)new StringBuilder(58).append("Expected ").append(this.t1p1()).append(" to truncate to offset 141 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        partitions.foreach((Function1 & Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$5(thread, tp);
            return BoxedUnit.UNIT;
        });
        mockNetwork.setFetchPartitionDataForNextResponse((Map<TopicPartition, FetchResponseData.PartitionData>)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p0().partition(), new FetchResponseData.EpochEndOffset().setEpoch(3).setEndOffset(130L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p1().partition(), new FetchResponseData.EpochEndOffset().setEpoch(3).setEndOffset(131L)))}))));
        mockNetwork.setIdsForNextResponse(this.topicIds());
        thread.doWork();
        Assertions.assertEquals((int)0, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)3, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)4))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)129)), (String)new StringBuilder(57).append("Expected to truncate to offset 129 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        partitions.foreach((Function1 & Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$6(thread, tp);
            return BoxedUnit.UNIT;
        });
        mockNetwork.setFetchPartitionDataForNextResponse((Map<TopicPartition, FetchResponseData.PartitionData>)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p0().partition(), new FetchResponseData.EpochEndOffset().setEpoch(2).setEndOffset(120L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p1().partition(), new FetchResponseData.EpochEndOffset().setEpoch(2).setEndOffset(121L)))}))));
        mockNetwork.setIdsForNextResponse(this.topicIds());
        latestLogEpoch.elem = None$.MODULE$;
        thread.doWork();
        Assertions.assertEquals((int)0, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)4, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)6))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)119)), (String)new StringBuilder(57).append("Expected to truncate to offset 119 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        partitions.foreach((Function1 & Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$7(thread, tp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testTruncateOnFetchDoesNotUpdateHighWatermark() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        int logEndOffset = 150;
        int highWatermark = 130;
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(highWatermark)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)log.endOffsetForEpoch(4)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(149L, 4)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(logEndOffset)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.localLogOrException(this.t1p0())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)partition.appendRecordsToFollowerOrFutureReplica((MemoryRecords)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()))).thenReturn((Object)None$.MODULE$);
        LogContext logContext = new LogContext(new StringBuilder(52).append("[ReplicaFetcher replicaId=").append(config.brokerId()).append(", leaderId=").append(this.brokerEndPoint().id()).append(", fetcherId=0] ").toString());
        MockBlockingSender mockNetwork = new MockBlockingSender(Collections.emptyMap(), this.brokerEndPoint(), Time.SYSTEM);
        RemoteLeaderEndPoint leader = new RemoteLeaderEndPoint(logContext.logPrefix(), (BlockingSend)mockNetwork, new FetchSessionHandler(logContext, this.brokerEndPoint().id()), config, replicaManager, (ReplicaQuota)quota, (Function0 & Serializable)() -> config.interBrokerProtocolVersion(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L);
        ReplicaFetcherThread thread = new ReplicaFetcherThread("fetcher-thread", (LeaderEndPoint)leader, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, (ReplicaQuota)quota, logContext.logPrefix(), (Function0 & Serializable)() -> config.interBrokerProtocolVersion());
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), logEndOffset, 1))})));
        mockNetwork.setFetchPartitionDataForNextResponse((Map<TopicPartition, FetchResponseData.PartitionData>)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new FetchResponseData.PartitionData().setPartitionIndex(this.t1p0().partition()).setLastStableOffset(0L).setLogStartOffset(0L).setHighWatermark(160L).setDivergingEpoch(new FetchResponseData.EpochEndOffset().setEpoch(4).setEndOffset(140L)))}))));
        mockNetwork.setIdsForNextResponse(this.topicIds());
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)1))).truncateTo(140L, false);
        ((UnifiedLog)Mockito.verify((Object)log, (VerificationMode)Mockito.times((int)0))).maybeUpdateHighWatermark(ArgumentMatchers.anyLong());
    }

    @Test
    public void testLagIsUpdatedWhenNoRecords() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int lastFetchedEpoch = 2;
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)lastFetchedEpoch)));
        Mockito.when((Object)log.endOffsetForEpoch(0)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(0L, 0)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)log.maybeUpdateHighWatermark(0L)).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.localLogOrException(this.t1p0())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)partition.appendRecordsToFollowerOrFutureReplica((MemoryRecords)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()))).thenReturn((Object)new Some((Object)new LogAppendInfo(-1L, 0L, OptionalInt.empty(), -1L, -1L, -1L, -1L, RecordValidationStats.EMPTY, CompressionType.NONE, -1, -1L)));
        LogContext logContext = new LogContext(new StringBuilder(52).append("[ReplicaFetcher replicaId=").append(config.brokerId()).append(", leaderId=").append(this.brokerEndPoint().id()).append(", fetcherId=0] ").toString());
        MockBlockingSender mockNetwork = new MockBlockingSender(Collections.emptyMap(), this.brokerEndPoint(), Time.SYSTEM);
        RemoteLeaderEndPoint leader = new RemoteLeaderEndPoint(logContext.logPrefix(), (BlockingSend)mockNetwork, new FetchSessionHandler(logContext, this.brokerEndPoint().id()), config, replicaManager, (ReplicaQuota)quota, (Function0 & Serializable)() -> config.interBrokerProtocolVersion(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L);
        ReplicaFetcherThread thread = new ReplicaFetcherThread("fetcher-thread", (LeaderEndPoint)leader, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, (ReplicaQuota)quota, logContext.logPrefix(), (Function0 & Serializable)() -> config.interBrokerProtocolVersion());
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()).flatMap((Function1 & Serializable)x$2 -> x$2.lag()));
        mockNetwork.setFetchPartitionDataForNextResponse((Map<TopicPartition, FetchResponseData.PartitionData>)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new FetchResponseData.PartitionData().setPartitionIndex(this.t1p0().partition()).setLastStableOffset(0L).setLogStartOffset(0L).setHighWatermark(0L).setRecords((BaseRecords)MemoryRecords.EMPTY))}))));
        mockNetwork.setIdsForNextResponse(this.topicIds());
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)thread.fetchState(this.t1p0()).flatMap((Function1 & Serializable)x$3 -> x$3.lag()));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)lastFetchedEpoch)), (Object)thread.fetchState(this.t1p0()).flatMap((Function1 & Serializable)x$4 -> x$4.lastFetchedEpoch()));
    }

    @Test
    public void shouldUseLeaderEndOffsetIfInterBrokerVersionBelow20() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put("inter.broker.protocol.version", "0.11.0");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int initialLEO = 200;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)((long)initialLEO - 2L)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)log.endOffsetForEpoch(4)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(120L, 3)));
        Mockito.when((Object)log.endOffsetForEpoch(3)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(120L, 3)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLEO)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map offsets = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), -1, 155L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), -1, 143L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsets, this.brokerEndPoint(), Time.SYSTEM);
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, (ReplicaQuota)quota, mockNetwork);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        Assertions.assertEquals((int)0, (int)mockNetwork.lastUsedOffsetForLeaderEpochVersion(), (String)"OffsetsForLeaderEpochRequest version.");
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)2, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)155)), (String)new StringBuilder(58).append("Expected ").append(this.t1p0()).append(" to truncate to offset 155 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)143)), (String)new StringBuilder(58).append("Expected ").append(this.t1p1()).append(" to truncate to offset 143 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
    }

    @Test
    public void shouldTruncateToInitialFetchOffsetIfLeaderReturnsUndefinedOffset() {
        ArgumentCaptor truncated = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int initialFetchOffset = 100;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialFetchOffset)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map offsetsReply = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), -1, -1L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsetsReply, this.brokerEndPoint(), Time.SYSTEM);
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, (ReplicaQuota)quota, mockNetwork);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), initialFetchOffset, 1))})));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition)).truncateTo(BoxesRunTime.unboxToLong((Object)truncated.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertEquals((long)initialFetchOffset, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()));
    }

    @Test
    public void shouldPollIndefinitelyIfLeaderReturnsAnyException() {
        ArgumentCaptor truncated = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 5;
        int highWaterMark = 100;
        int initialLeo = 300;
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(highWaterMark)));
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)initialLeo, leaderEpoch)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLeo)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map offsetsReply = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), Errors.NOT_LEADER_OR_FOLLOWER, -1, -1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), Errors.UNKNOWN_SERVER_ERROR, -1, -1L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsetsReply, this.brokerEndPoint(), Time.SYSTEM);
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, (ReplicaQuota)quota, mockNetwork);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> thread.doWork());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.never())).truncateTo(ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean());
        offsetsReply.put(this.t1p0(), this.newOffsetForLeaderPartitionResult(this.t1p0(), leaderEpoch, 156L));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition)).truncateTo(BoxesRunTime.unboxToLong((Object)truncated.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertEquals((long)156L, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()));
    }

    @Test
    public void shouldMovePartitionsOutOfTruncatingLogState() {
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 4;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(0L, leaderEpoch)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        this.stub(partition, replicaManager, log);
        java.util.Map offsetsReply = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), leaderEpoch, 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), leaderEpoch, 1L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsetsReply, this.brokerEndPoint(), Time.SYSTEM);
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, (ReplicaQuota)quota, mockNetwork);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Truncating$.MODULE$), (Object)thread.fetchState(this.t1p0()).map((Function1 & Serializable)x$6 -> x$6.state()));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Truncating$.MODULE$), (Object)thread.fetchState(this.t1p1()).map((Function1 & Serializable)x$7 -> x$7.state()));
        thread.doWork();
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)thread.fetchState(this.t1p0()).map((Function1 & Serializable)x$8 -> x$8.state()));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)thread.fetchState(this.t1p1()).map((Function1 & Serializable)x$9 -> x$9.state()));
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(0L, false);
    }

    @Test
    public void shouldFilterPartitionsMadeLeaderDuringLeaderEpochRequest() {
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        int initialLEO = 100;
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)((long)initialLEO - 2L)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)log.endOffsetForEpoch(5)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)initialLEO, 5)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLEO)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        this.stub(partition, replicaManager, log);
        java.util.Map offsetsReply = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), 5, 52L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), 5, 49L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsetsReply, this.brokerEndPoint(), Time.SYSTEM);
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, (ReplicaQuota)quota, mockNetwork);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        TopicPartition partitionThatBecameLeader = this.t1p0();
        mockNetwork.setEpochRequestCallback((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> thread.removePartitions((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionThatBecameLeader}))));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition)).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertEquals((long)49L, (long)BoxesRunTime.unboxToLong((Object)truncateToCapture.getValue()));
    }

    @Test
    public void shouldCatchExceptionFromBlockingSendWhenShuttingDownReplicaFetcherThread() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        Mockito.when((Object)mockBlockingSend.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        mockBlockingSend.initiateClose();
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new IllegalArgumentException()});
        mockBlockingSend.close();
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new IllegalStateException()});
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, null, mockBlockingSend);
        thread.start();
        thread.initiateShutdown();
        thread.awaitShutdown();
        ((BlockingSend)Mockito.verify((Object)mockBlockingSend)).initiateClose();
        ((BlockingSend)Mockito.verify((Object)mockBlockingSend)).close();
    }

    @Test
    public void shouldUpdateReassignmentBytesInMetrics() {
        this.assertProcessPartitionDataWhen(true);
    }

    @Test
    public void shouldNotUpdateReassignmentBytesInMetricsWhenNoReassignmentsInProgress() {
        this.assertProcessPartitionDataWhen(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBuildFetch() {
        void var25_25;
        void var17_17;
        TopicIdPartition tid1p0 = new TopicIdPartition(this.topicId1(), this.t1p0());
        TopicIdPartition tid1p1 = new TopicIdPartition(this.topicId1(), this.t1p1());
        TopicIdPartition tid2p1 = new TopicIdPartition(this.topicId2(), this.t2p1());
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        ReplicaQuota replicaQuota = (ReplicaQuota)Mockito.mock(ReplicaQuota.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)mockBlockingSend.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaQuota.isThrottled((TopicPartition)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        LogContext logContext = new LogContext(new StringBuilder(52).append("[ReplicaFetcher replicaId=").append(config.brokerId()).append(", leaderId=").append(this.brokerEndPoint().id()).append(", fetcherId=0] ").toString());
        FetchSessionHandler fetchSessionHandler = new FetchSessionHandler(logContext, this.brokerEndPoint().id());
        RemoteLeaderEndPoint leader = new RemoteLeaderEndPoint(logContext.logPrefix(), mockBlockingSend, fetchSessionHandler, config, replicaManager, replicaQuota, (Function0 & Serializable)() -> config.interBrokerProtocolVersion(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L);
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", (LeaderEndPoint)leader, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, replicaQuota, logContext.logPrefix(), (Function0 & Serializable)() -> config.interBrokerProtocolVersion());
        int leaderEpoch = 1;
        Map partitionMap = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId1()), 150L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId1()), 155L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId2()), 160L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$))}));
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions = thread.leader().buildFetch(partitionMap);
        if (resultWithPartitions == null) {
            throw new MatchError(null);
        }
        Option fetchRequestOpt = (Option)resultWithPartitions.result();
        Assertions.assertTrue((boolean)var17_17.isDefined());
        FetchRequest.Builder fetchRequestBuilder = ((AbstractFetcherThread.ReplicaFetch)var17_17.get()).fetchRequest();
        Map partitionDataMap = (Map)partitionMap.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                PartitionFetchState state = (PartitionFetchState)x0$1._2();
                return new Tuple2((Object)tp, (Object)new FetchRequest.PartitionData((Uuid)state.topicId().get(), state.fetchOffset(), 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(state.currentLeaderEpoch())), Optional.empty()));
            }
            throw new MatchError(null);
        });
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava(partitionDataMap).asJava(), (Object)fetchRequestBuilder.fetchData());
        Assertions.assertEquals((int)0, (int)fetchRequestBuilder.replaced().size());
        Assertions.assertEquals((int)0, (int)fetchRequestBuilder.removed().size());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> responseData = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        responseData.put(tid1p0, new FetchResponseData.PartitionData());
        responseData.put(tid1p1, new FetchResponseData.PartitionData());
        responseData.put(tid2p1, new FetchResponseData.PartitionData());
        FetchResponse fetchResponse = FetchResponse.of((Errors)Errors.NONE, (int)0, (int)123, responseData);
        leader.fetchSessionHandler().handleResponse(fetchResponse, ApiKeys.FETCH.latestVersion());
        Uuid newTopicId = Uuid.randomUuid();
        Map partitionMap2 = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId1()), 155L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)new PartitionFetchState((Option)new Some((Object)newTopicId), 160L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$))}));
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions2 = thread.leader().buildFetch(partitionMap2);
        if (resultWithPartitions2 == null) {
            throw new MatchError(null);
        }
        Option fetchRequestOpt2 = (Option)resultWithPartitions2.result();
        Map partitionDataMap2 = (Map)((MapOps)partitionMap2.drop(1)).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                TopicPartition tp = (TopicPartition)x0$2._1();
                PartitionFetchState state = (PartitionFetchState)x0$2._2();
                return new Tuple2((Object)tp, (Object)new FetchRequest.PartitionData((Uuid)state.topicId().get(), state.fetchOffset(), 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(state.currentLeaderEpoch())), Optional.empty()));
            }
            throw new MatchError(null);
        });
        Assertions.assertTrue((boolean)var25_25.isDefined());
        FetchRequest.Builder fetchRequestBuilder2 = ((AbstractFetcherThread.ReplicaFetch)var25_25.get()).fetchRequest();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava(partitionDataMap2).asJava(), (Object)fetchRequestBuilder2.fetchData());
        Assertions.assertEquals(Collections.singletonList(tid2p1), (Object)fetchRequestBuilder2.replaced());
        Assertions.assertEquals(Collections.singletonList(tid1p0), (Object)fetchRequestBuilder2.removed());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testLocalFetchCompletionIfHighWatermarkUpdated(boolean highWatermarkUpdated) {
        void withRecords_records;
        void withRecords_timestampType;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        long highWatermarkReceivedFromLeader = 100L;
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        Mockito.when((Object)mockBlockingSend.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        None$ maybeNewHighWatermark = highWatermarkUpdated ? new Some((Object)BoxesRunTime.boxToLong((long)highWatermarkReceivedFromLeader)) : None$.MODULE$;
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)log.maybeUpdateHighWatermark(highWatermarkReceivedFromLeader)).thenReturn((Object)maybeNewHighWatermark);
        Some appendInfo = new Some(Mockito.mock(LogAppendInfo.class));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)partition.appendRecordsToFollowerOrFutureReplica((MemoryRecords)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()))).thenReturn((Object)appendInfo);
        Buffer completeDelayedFetchRequestsArgument = (Buffer)Buffer$.MODULE$.empty();
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getPartitionOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)partition);
        replicaManager.completeDelayedFetchRequests((Seq)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> (Buffer)completeDelayedFetchRequestsArgument.$plus$plus$eq((IterableOnce)((scala.collection.immutable.Seq)invocation.getArguments()[0])));
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats(false);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn((Object)brokerTopicStats);
        ReplicaQuota replicaQuota = (ReplicaQuota)Mockito.mock(ReplicaQuota.class);
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("replica-fetcher", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, replicaQuota, mockBlockingSend);
        TopicPartition tp0 = new TopicPartition("testTopic", 0);
        TopicPartition tp1 = new TopicPartition("testTopic", 1);
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(1000L, "foo".getBytes(StandardCharsets.UTF_8))};
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var20_18 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        FetchResponseData.PartitionData partitionData = new FetchResponseData.PartitionData().setRecords((BaseRecords)records).setHighWatermark(highWatermarkReceivedFromLeader);
        thread.processPartitionData(tp0, 0L, partitionData.setPartitionIndex(0));
        thread.processPartitionData(tp1, 0L, partitionData.setPartitionIndex(1));
        ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)0))).completeDelayedFetchRequests((Seq)ArgumentMatchers.any());
        thread.doWork();
        if (highWatermarkUpdated) {
            Assertions.assertEquals((Object)new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)Nil$.MODULE$)), (Object)completeDelayedFetchRequestsArgument);
            ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)1))).completeDelayedFetchRequests((Seq)ArgumentMatchers.any());
        } else {
            ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)0))).completeDelayedFetchRequests((Seq)ArgumentMatchers.any());
        }
        Assertions.assertEquals((Object)Buffer$.MODULE$.empty(), (Object)thread.partitionsWithNewHighWatermark());
    }

    private OffsetForLeaderEpochResponseData.EpochEndOffset newOffsetForLeaderPartitionResult(TopicPartition tp, int leaderEpoch, long endOffset) {
        return this.newOffsetForLeaderPartitionResult(tp, Errors.NONE, leaderEpoch, endOffset);
    }

    private OffsetForLeaderEpochResponseData.EpochEndOffset newOffsetForLeaderPartitionResult(TopicPartition tp, Errors error, int leaderEpoch, long endOffset) {
        return new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(error.code()).setLeaderEpoch(leaderEpoch).setEndOffset(endOffset);
    }

    /*
     * WARNING - void declaration
     */
    private void assertProcessPartitionDataWhen(boolean isReassigning) {
        void withRecords_records;
        void withRecords_timestampType;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        Mockito.when((Object)mockBlockingSend.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(1000L, "foo".getBytes(StandardCharsets.UTF_8))};
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var13_7 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        Mockito.when((Object)log.maybeUpdateHighWatermark(0L)).thenReturn((Object)None$.MODULE$);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isReassigning())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)isReassigning));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isAddingLocalReplica())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)isReassigning));
        Mockito.when((Object)partition.appendRecordsToFollowerOrFutureReplica(records, false)).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getPartitionOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)partition);
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats(false);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn((Object)brokerTopicStats);
        ReplicaQuota replicaQuota = (ReplicaQuota)Mockito.mock(ReplicaQuota.class);
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, replicaQuota, mockBlockingSend);
        FetchResponseData.PartitionData partitionData = new FetchResponseData.PartitionData().setPartitionIndex(this.t1p0().partition()).setLastStableOffset(0L).setLogStartOffset(0L).setRecords((BaseRecords)records);
        thread.processPartitionData(this.t1p0(), 0L, partitionData);
        if (isReassigning) {
            Assertions.assertEquals((long)records.sizeInBytes(), (long)((Meter)brokerTopicStats.allTopicsStats().reassignmentBytesInPerSec().get()).count());
        } else {
            Assertions.assertEquals((long)0L, (long)((Meter)brokerTopicStats.allTopicsStats().reassignmentBytesInPerSec().get()).count());
        }
        Assertions.assertEquals((long)records.sizeInBytes(), (long)((Meter)brokerTopicStats.allTopicsStats().replicationBytesInRate().get()).count());
    }

    public void stub(Partition partition, ReplicaManager replicaManager, UnifiedLog log) {
        Mockito.when((Object)replicaManager.localLogOrException(this.t1p0())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.localLogOrException(this.t1p1())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p1())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.localLogOrException(this.t2p1())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t2p1())).thenReturn((Object)partition);
    }

    private KafkaConfig kafkaConfigNoTruncateOnFetch() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.setProperty("inter.broker.protocol.version", MetadataVersion.IBP_2_6_IV0.version());
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    public static final /* synthetic */ void $anonfun$assertPartitionStates$1(AbstractFetcherThread fetcher$1, boolean shouldBeReadyForFetch$1, boolean shouldBeTruncatingLog$1, boolean shouldBeDelayed$1, TopicPartition tp) {
        Assertions.assertTrue((boolean)fetcher$1.fetchState(tp).isDefined());
        PartitionFetchState fetchState = (PartitionFetchState)fetcher$1.fetchState(tp).get();
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)shouldBeReadyForFetch$1), (Object)BoxesRunTime.boxToBoolean((boolean)fetchState.isReadyForFetch()), (String)new StringBuilder(39).append("Partition ").append(tp).append(" should").append((Object)(!shouldBeReadyForFetch$1 ? " NOT" : "")).append(" be ready for fetching").toString());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)shouldBeTruncatingLog$1), (Object)BoxesRunTime.boxToBoolean((boolean)fetchState.isTruncating()), (String)new StringBuilder(39).append("Partition ").append(tp).append(" should").append((Object)(!shouldBeTruncatingLog$1 ? " NOT" : "")).append(" be truncating its log").toString());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)shouldBeDelayed$1), (Object)BoxesRunTime.boxToBoolean((boolean)fetchState.isDelayed()), (String)new StringBuilder(28).append("Partition ").append(tp).append(" should").append((Object)(!shouldBeDelayed$1 ? " NOT" : "")).append(" be delayed").toString());
    }

    public static final /* synthetic */ void $anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$4(ReplicaFetcherThread thread$1, TopicPartition tp) {
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)thread$1.fetchState(tp).get()).state());
    }

    private static final FetchResponseData.PartitionData partitionData$1(int partition, FetchResponseData.EpochEndOffset divergingEpoch) {
        return new FetchResponseData.PartitionData().setPartitionIndex(partition).setLastStableOffset(0L).setLogStartOffset(0L).setDivergingEpoch(divergingEpoch);
    }

    public static final /* synthetic */ void $anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$5(ReplicaFetcherThread thread$1, TopicPartition tp) {
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)thread$1.fetchState(tp).get()).state());
    }

    public static final /* synthetic */ void $anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$6(ReplicaFetcherThread thread$1, TopicPartition tp) {
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)thread$1.fetchState(tp).get()).state());
    }

    public static final /* synthetic */ void $anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$7(ReplicaFetcherThread thread$1, TopicPartition tp) {
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)thread$1.fetchState(tp).get()).state());
    }

    public ReplicaFetcherThreadTest() {
        this.metadataCache().updateMetadata(0, this.updateMetadataRequest());
    }
}

