/*
 * Decompiled with CFR 0.152.
 */
package kafka.testkit;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import kafka.testkit.BrokerNode;
import kafka.testkit.ControllerNode;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.test.TestUtils;

public class TestKitNodes {
    public static final int CONTROLLER_ID_OFFSET = 3000;
    public static final int BROKER_ID_OFFSET = 0;
    private final String baseDirectory;
    private final String clusterId;
    private final BootstrapMetadata bootstrapMetadata;
    private final SortedMap<Integer, ControllerNode> controllerNodes;
    private final SortedMap<Integer, BrokerNode> brokerNodes;

    private TestKitNodes(String baseDirectory, String clusterId, BootstrapMetadata bootstrapMetadata, SortedMap<Integer, ControllerNode> controllerNodes, SortedMap<Integer, BrokerNode> brokerNodes) {
        this.baseDirectory = Objects.requireNonNull(baseDirectory);
        this.clusterId = Objects.requireNonNull(clusterId);
        this.bootstrapMetadata = Objects.requireNonNull(bootstrapMetadata);
        this.controllerNodes = Collections.unmodifiableSortedMap(new TreeMap<Integer, ControllerNode>(Objects.requireNonNull(controllerNodes)));
        this.brokerNodes = Collections.unmodifiableSortedMap(new TreeMap<Integer, BrokerNode>(Objects.requireNonNull(brokerNodes)));
    }

    public boolean isCombined(int node) {
        return this.controllerNodes.containsKey(node) && this.brokerNodes.containsKey(node);
    }

    public String baseDirectory() {
        return this.baseDirectory;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public SortedMap<Integer, ControllerNode> controllerNodes() {
        return this.controllerNodes;
    }

    public BootstrapMetadata bootstrapMetadata() {
        return this.bootstrapMetadata;
    }

    public SortedMap<Integer, BrokerNode> brokerNodes() {
        return this.brokerNodes;
    }

    public ListenerName interBrokerListenerName() {
        return new ListenerName("EXTERNAL");
    }

    public ListenerName externalListenerName() {
        return new ListenerName("EXTERNAL");
    }

    public ListenerName controllerListenerName() {
        return new ListenerName("CONTROLLER");
    }

    public static class Builder {
        private boolean combined;
        private String clusterId;
        private int numControllerNodes;
        private int numBrokerNodes;
        private int numDisksPerBroker = 1;
        private Map<Integer, Map<String, String>> perServerProperties = Collections.emptyMap();
        private BootstrapMetadata bootstrapMetadata = BootstrapMetadata.fromVersion((MetadataVersion)MetadataVersion.latestTesting(), (String)"testkit");

        public Builder setClusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder setBootstrapMetadataVersion(MetadataVersion metadataVersion) {
            this.bootstrapMetadata = BootstrapMetadata.fromVersion((MetadataVersion)metadataVersion, (String)"testkit");
            return this;
        }

        public Builder setBootstrapMetadata(BootstrapMetadata bootstrapMetadata) {
            this.bootstrapMetadata = bootstrapMetadata;
            return this;
        }

        public Builder setCombined(boolean combined) {
            this.combined = combined;
            return this;
        }

        public Builder setNumControllerNodes(int numControllerNodes) {
            this.numControllerNodes = numControllerNodes;
            return this;
        }

        public Builder setNumBrokerNodes(int numBrokerNodes) {
            this.numBrokerNodes = numBrokerNodes;
            return this;
        }

        public Builder setNumDisksPerBroker(int numDisksPerBroker) {
            this.numDisksPerBroker = numDisksPerBroker;
            return this;
        }

        public Builder setPerServerProperties(Map<Integer, Map<String, String>> perServerProperties) {
            this.perServerProperties = Collections.unmodifiableMap(perServerProperties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Collections.unmodifiableMap(new HashMap((Map)e.getValue())))));
            return this;
        }

        public TestKitNodes build() {
            if (this.numControllerNodes < 0) {
                throw new IllegalArgumentException("Invalid negative value for numControllerNodes");
            }
            if (this.numBrokerNodes < 0) {
                throw new IllegalArgumentException("Invalid negative value for numBrokerNodes");
            }
            if (this.numDisksPerBroker <= 0) {
                throw new IllegalArgumentException("Invalid value for numDisksPerBroker");
            }
            String baseDirectory = TestUtils.tempDirectory().getAbsolutePath();
            if (this.clusterId == null) {
                this.clusterId = Uuid.randomUuid().toString();
            }
            int controllerId = this.combined ? 0 : 3000;
            List controllerNodeIds = IntStream.range(controllerId, controllerId + this.numControllerNodes).boxed().collect(Collectors.toList());
            List brokerNodeIds = IntStream.range(0, 0 + this.numBrokerNodes).boxed().collect(Collectors.toList());
            String unknownIds = this.perServerProperties.keySet().stream().filter(id -> !controllerNodeIds.contains(id)).filter(id -> !brokerNodeIds.contains(id)).map(Object::toString).collect(Collectors.joining(", "));
            if (!unknownIds.isEmpty()) {
                throw new IllegalArgumentException(String.format("Unknown server id %s in perServerProperties, the existent server ids are %s", unknownIds, Stream.concat(brokerNodeIds.stream(), controllerNodeIds.stream()).map(Object::toString).collect(Collectors.joining(", "))));
            }
            TreeMap<Integer, ControllerNode> controllerNodes = new TreeMap<Integer, ControllerNode>();
            Iterator iterator = controllerNodeIds.iterator();
            while (iterator.hasNext()) {
                int id2 = (Integer)iterator.next();
                ControllerNode controllerNode = ControllerNode.builder().setId(id2).setBaseDirectory(baseDirectory).setClusterId(this.clusterId).setCombined(brokerNodeIds.contains(id2)).setPropertyOverrides(this.perServerProperties.getOrDefault(id2, Collections.emptyMap())).build();
                controllerNodes.put(id2, controllerNode);
            }
            TreeMap<Integer, BrokerNode> brokerNodes = new TreeMap<Integer, BrokerNode>();
            Iterator iterator2 = brokerNodeIds.iterator();
            while (iterator2.hasNext()) {
                int id3 = (Integer)iterator2.next();
                BrokerNode brokerNode = BrokerNode.builder().setId(id3).setNumLogDirectories(this.numDisksPerBroker).setBaseDirectory(baseDirectory).setClusterId(this.clusterId).setCombined(controllerNodeIds.contains(id3)).setPropertyOverrides(this.perServerProperties.getOrDefault(id3, Collections.emptyMap())).build();
                brokerNodes.put(id3, brokerNode);
            }
            return new TestKitNodes(baseDirectory, this.clusterId, this.bootstrapMetadata, controllerNodes, brokerNodes);
        }
    }
}

