/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.server;

import java.io.Serializable;
import java.util.Collections;
import kafka.server.ForwardingManagerMetrics;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005Q2Aa\u0002\u0005\u0003\u001f!)a\u0003\u0001C\u0001/!)!\u0004\u0001C\u00017!)A\u0006\u0001C\u00017!)a\u0006\u0001C\u00017!)\u0001\u0007\u0001C\u00017!)!\u0007\u0001C\u00017\tabi\u001c:xCJ$\u0017N\\4NC:\fw-\u001a:NKR\u0014\u0018nY:UKN$(BA\u0005\u000b\u0003\u0019\u0019XM\u001d<fe*\u00111\u0002D\u0001\u0006W\u000647.\u0019\u0006\u0002\u001b\u0005!QO\\5u\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0004\u0005\u0002\u001a\u00015\t\u0001\"\u0001\tuKN$X*\u001a;sS\u000e\u001ch*Y7fgR\tA\u0004\u0005\u0002\u0012;%\u0011aD\u0005\u0002\u0005+:LG\u000f\u000b\u0002\u0003AA\u0011\u0011EK\u0007\u0002E)\u00111\u0005J\u0001\u0004CBL'BA\u0013'\u0003\u001dQW\u000f]5uKJT!a\n\u0015\u0002\u000b),h.\u001b;\u000b\u0003%\n1a\u001c:h\u0013\tY#E\u0001\u0003UKN$\u0018a\u0004;fgR\fV/Z;f)&lW-T:)\u0005\r\u0001\u0013a\u0004;fgR\fV/Z;f\u0019\u0016tw\r\u001e5)\u0005\u0011\u0001\u0013\u0001\u0005;fgR\u0014V-\\8uKRKW.Z'tQ\t)\u0001%A\u0007uKN$H+[7f_V$Xj\u001d\u0015\u0003\r\u0001\u0002")
public final class ForwardingManagerMetricsTest {
    @Test
    public void testMetricsNames() {
        Metrics metrics = new Metrics();
        String expectedGroup = "ForwardingManager";
        Set expectedMetrics = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MetricName[]{new MetricName("QueueTimeMs.p99", expectedGroup, "", Collections.emptyMap()), new MetricName("QueueTimeMs.p999", expectedGroup, "", Collections.emptyMap()), new MetricName("QueueLength", expectedGroup, "", Collections.emptyMap()), new MetricName("RemoteTimeMs.p99", expectedGroup, "", Collections.emptyMap()), new MetricName("RemoteTimeMs.p999", expectedGroup, "", Collections.emptyMap())}));
        Map metricsMap = (Map)CollectionConverters$.MODULE$.MapHasAsScala(metrics.metrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ForwardingManagerMetricsTest.$anonfun$testMetricsNames$1(expectedGroup, x0$1)));
        Assertions.assertEquals((int)0, (int)metricsMap.size());
        long apply_timeoutMs = 1000L;
        new ForwardingManagerMetrics(metrics, apply_timeoutMs);
        metricsMap = (Map)CollectionConverters$.MODULE$.MapHasAsScala(metrics.metrics()).asScala().filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ForwardingManagerMetricsTest.$anonfun$testMetricsNames$2(expectedGroup, x0$2)));
        Assertions.assertEquals((int)metricsMap.size(), (int)expectedMetrics.size());
        metricsMap.foreach((Function1 & Serializable)x0$3 -> {
            ForwardingManagerMetricsTest.$anonfun$testMetricsNames$3(expectedMetrics, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testQueueTimeMs() {
        Metrics metrics = new Metrics();
        long apply_timeoutMs = 1000L;
        ForwardingManagerMetrics forwardingManagerMetrics = new ForwardingManagerMetrics(metrics, apply_timeoutMs);
        KafkaMetric queueTimeMsP99 = (KafkaMetric)metrics.metrics().get(forwardingManagerMetrics.queueTimeMsHist().latencyP99Name());
        KafkaMetric queueTimeMsP999 = (KafkaMetric)metrics.metrics().get(forwardingManagerMetrics.queueTimeMsHist().latencyP999Name());
        Assertions.assertEquals((double)Double.NaN, (double)BoxesRunTime.unboxToDouble((Object)queueTimeMsP99.metricValue()));
        Assertions.assertEquals((double)Double.NaN, (double)BoxesRunTime.unboxToDouble((Object)queueTimeMsP999.metricValue()));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 999).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> forwardingManagerMetrics.queueTimeMsHist().record((long)i));
        Assertions.assertEquals((double)990.0, (double)BoxesRunTime.unboxToDouble((Object)queueTimeMsP99.metricValue()));
        Assertions.assertEquals((double)999.0, (double)BoxesRunTime.unboxToDouble((Object)queueTimeMsP999.metricValue()));
    }

    @Test
    public void testQueueLength() {
        Metrics metrics = new Metrics();
        long apply_timeoutMs = 1000L;
        ForwardingManagerMetrics forwardingManagerMetrics = new ForwardingManagerMetrics(metrics, apply_timeoutMs);
        KafkaMetric queueLength = (KafkaMetric)metrics.metrics().get(forwardingManagerMetrics.queueLengthName());
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)queueLength.metricValue()));
        forwardingManagerMetrics.queueLength().getAndIncrement();
        Assertions.assertEquals((int)1, (int)BoxesRunTime.unboxToInt((Object)queueLength.metricValue()));
    }

    @Test
    public void testRemoteTimeMs() {
        Metrics metrics = new Metrics();
        long apply_timeoutMs = 1000L;
        ForwardingManagerMetrics forwardingManagerMetrics = new ForwardingManagerMetrics(metrics, apply_timeoutMs);
        KafkaMetric remoteTimeMsP99 = (KafkaMetric)metrics.metrics().get(forwardingManagerMetrics.remoteTimeMsHist().latencyP99Name());
        KafkaMetric remoteTimeMsP999 = (KafkaMetric)metrics.metrics().get(forwardingManagerMetrics.remoteTimeMsHist().latencyP999Name());
        Assertions.assertEquals((double)Double.NaN, (double)BoxesRunTime.unboxToDouble((Object)remoteTimeMsP99.metricValue()));
        Assertions.assertEquals((double)Double.NaN, (double)BoxesRunTime.unboxToDouble((Object)remoteTimeMsP999.metricValue()));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 999).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> forwardingManagerMetrics.remoteTimeMsHist().record((long)i));
        Assertions.assertEquals((double)990.0, (double)BoxesRunTime.unboxToDouble((Object)remoteTimeMsP99.metricValue()));
        Assertions.assertEquals((double)999.0, (double)BoxesRunTime.unboxToDouble((Object)remoteTimeMsP999.metricValue()));
    }

    @Test
    public void testTimeoutMs() {
        Metrics metrics = new Metrics();
        int timeoutMs = 500;
        long apply_timeoutMs = timeoutMs;
        ForwardingManagerMetrics forwardingManagerMetrics = new ForwardingManagerMetrics(metrics, apply_timeoutMs);
        KafkaMetric queueTimeMsP99 = (KafkaMetric)metrics.metrics().get(forwardingManagerMetrics.queueTimeMsHist().latencyP99Name());
        KafkaMetric queueTimeMsP999 = (KafkaMetric)metrics.metrics().get(forwardingManagerMetrics.queueTimeMsHist().latencyP999Name());
        Assertions.assertEquals((double)Double.NaN, (double)BoxesRunTime.unboxToDouble((Object)queueTimeMsP99.metricValue()));
        Assertions.assertEquals((double)Double.NaN, (double)BoxesRunTime.unboxToDouble((Object)queueTimeMsP999.metricValue()));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 99).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> forwardingManagerMetrics.queueTimeMsHist().record((long)i));
        forwardingManagerMetrics.queueTimeMsHist().record(1000L);
        Assertions.assertEquals((double)99.0, (double)BoxesRunTime.unboxToDouble((Object)queueTimeMsP99.metricValue()));
        Assertions.assertEquals((double)((double)timeoutMs * 0.999), (double)BoxesRunTime.unboxToDouble((Object)queueTimeMsP999.metricValue()));
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsNames$1(String expectedGroup$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String string = ((MetricName)x0$1._1()).group();
            return !(string != null ? !string.equals(expectedGroup$1) : expectedGroup$1 != null);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsNames$2(String expectedGroup$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            String string = ((MetricName)x0$2._1()).group();
            return !(string != null ? !string.equals(expectedGroup$1) : expectedGroup$1 != null);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testMetricsNames$3(Set expectedMetrics$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            MetricName name = (MetricName)x0$3._1();
            Assertions.assertTrue((boolean)expectedMetrics$1.contains((Object)name));
            return;
        }
        throw new MatchError(null);
    }
}

