/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.util.concurrent.TimeUnit;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.Partition$;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.common.ErrorMapping$;
import kafka.common.NotLeaderForPartitionException;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.message.ByteBufferMessageSet;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.HighwaterMarkCheckpoint;
import kafka.server.ReplicaFetcherManager;
import kafka.server.ReplicaManager;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Time;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$Long$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tEg\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003\u0013A\u000b'\u000f^5uS>t'BA\u0002\u0005\u0003\u001d\u0019G.^:uKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0015\u0001\u0001\u0002\u0005\f\u001d!\tIa\"D\u0001\u000b\u0015\tYA\"\u0001\u0003mC:<'\"A\u0007\u0002\t)\fg/Y\u0005\u0003\u001f)\u0011aa\u00142kK\u000e$\bCA\t\u0015\u001b\u0005\u0011\"BA\n\u0005\u0003\u0015)H/\u001b7t\u0013\t)\"CA\u0004M_\u001e<\u0017N\\4\u0011\u0005]QR\"\u0001\r\u000b\u0005e!\u0011aB7fiJL7m]\u0005\u00037a\u0011\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011\r\u0002!Q1A\u0005\u0002\u0011\nQ\u0001^8qS\u000e,\u0012!\n\t\u0003M%r!!H\u0014\n\u0005!r\u0012A\u0002)sK\u0012,g-\u0003\u0002+W\t11\u000b\u001e:j]\u001eT!\u0001\u000b\u0010\t\u00115\u0002!\u0011!Q\u0001\n\u0015\na\u0001^8qS\u000e\u0004\u0003\u0002C\u0018\u0001\u0005\u000b\u0007I\u0011\u0001\u0019\u0002\u0017A\f'\u000f^5uS>t\u0017\nZ\u000b\u0002cA\u0011QDM\u0005\u0003gy\u00111!\u00138u\u0011!)\u0004A!A!\u0002\u0013\t\u0014\u0001\u00049beRLG/[8o\u0013\u0012\u0004\u0003\u0002C\u001c\u0001\u0005\u0003\u0007I\u0011\u0001\u0019\u0002#I,\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000f\u0003\u0005:\u0001\t\u0005\r\u0011\"\u0001;\u0003U\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN]0%KF$\"a\u000f \u0011\u0005ua\u0014BA\u001f\u001f\u0005\u0011)f.\u001b;\t\u000f}B\u0014\u0011!a\u0001c\u0005\u0019\u0001\u0010J\u0019\t\u0011\u0005\u0003!\u0011!Q!\nE\n!C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8sA!A1\t\u0001B\u0001B\u0003%A)\u0001\u0003uS6,\u0007CA\tF\u0013\t1%C\u0001\u0003US6,\u0007\u0002\u0003%\u0001\u0005\u000b\u0007I\u0011A%\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\t!\n\u0005\u0002L\u001d6\tAJ\u0003\u0002N\t\u000511/\u001a:wKJL!a\u0014'\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\"A\u0011\u000b\u0001B\u0001B\u0003%!*A\bsKBd\u0017nY1NC:\fw-\u001a:!\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0003\u0019a\u0014N\\5u}Q1Qk\u0016-Z5n\u0003\"A\u0016\u0001\u000e\u0003\tAQa\t*A\u0002\u0015BQa\f*A\u0002EBQa\u000e*A\u0002EBQa\u0011*A\u0002\u0011CQ\u0001\u0013*A\u0002)Cq!\u0018\u0001C\u0002\u0013%\u0001'A\u0007m_\u000e\fGN\u0011:pW\u0016\u0014\u0018\n\u001a\u0005\u0007?\u0002\u0001\u000b\u0011B\u0019\u0002\u001d1|7-\u00197Ce>\\WM]%eA!9\u0011\r\u0001b\u0001\n\u0013\u0011\u0017A\u00037pO6\u000bg.Y4feV\t1\r\u0005\u0002eO6\tQM\u0003\u0002g\t\u0005\u0019An\\4\n\u0005!,'A\u0003'pO6\u000bg.Y4fe\"1!\u000e\u0001Q\u0001\n\r\f1\u0002\\8h\u001b\u0006t\u0017mZ3sA!9A\u000e\u0001b\u0001\n\u0013i\u0017!\u0006:fa2L7-\u0019$fi\u000eDWM]'b]\u0006<WM]\u000b\u0002]B\u00111j\\\u0005\u0003a2\u0013QCU3qY&\u001c\u0017MR3uG\",'/T1oC\u001e,'\u000f\u0003\u0004s\u0001\u0001\u0006IA\\\u0001\u0017e\u0016\u0004H.[2b\r\u0016$8\r[3s\u001b\u0006t\u0017mZ3sA!9A\u000f\u0001b\u0001\n\u0013)\u0018\u0001\u0003>l\u00072LWM\u001c;\u0016\u0003Y\u0004\"a\u001e@\u000e\u0003aT!!\u001f>\u0002\u0011i\\7\r\\5f]RT!a\u001f?\u0002\r%\u0003\u0014\n^3d\u0015\u0005i\u0018aA8sO&\u0011q\u0010\u001f\u0002\t5.\u001cE.[3oi\"9\u00111\u0001\u0001!\u0002\u00131\u0018!\u0003>l\u00072LWM\u001c;!\u0011%\t9\u0001\u0001a\u0001\n\u0003\tI!\u0001\nmK\u0006$WM\u001d*fa2L7-Y%e\u001fB$XCAA\u0006!\u0011i\u0012QB\u0019\n\u0007\u0005=aD\u0001\u0004PaRLwN\u001c\u0005\n\u0003'\u0001\u0001\u0019!C\u0001\u0003+\ta\u0003\\3bI\u0016\u0014(+\u001a9mS\u000e\f\u0017\nZ(qi~#S-\u001d\u000b\u0004w\u0005]\u0001\"C \u0002\u0012\u0005\u0005\t\u0019AA\u0006\u0011!\tY\u0002\u0001Q!\n\u0005-\u0011a\u00057fC\u0012,'OU3qY&\u001c\u0017-\u00133PaR\u0004\u0003\"CA\u0010\u0001\u0001\u0007I\u0011AA\u0011\u00039IgnU=oGJ+\u0007\u000f\\5dCN,\"!a\t\u0011\r\u0005\u0015\u00121FA\u0018\u001b\t\t9CC\u0002\u0002*y\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti#a\n\u0003\u0007M+G\u000fE\u0002W\u0003cI1!a\r\u0003\u0005\u001d\u0011V\r\u001d7jG\u0006D\u0011\"a\u000e\u0001\u0001\u0004%\t!!\u000f\u0002%%t7+\u001f8d%\u0016\u0004H.[2bg~#S-\u001d\u000b\u0004w\u0005m\u0002\"C \u00026\u0005\u0005\t\u0019AA\u0012\u0011!\ty\u0004\u0001Q!\n\u0005\r\u0012aD5o'ft7MU3qY&\u001c\u0017m\u001d\u0011\t\u0013\u0005\r\u0003A1A\u0005\n\u0005\u0015\u0013AE1tg&<g.\u001a3SKBd\u0017nY1NCB,\"!a\u0012\u0011\rE\tI%MA\u0018\u0013\r\tYE\u0005\u0002\u0005!>|G\u000e\u0003\u0005\u0002P\u0001\u0001\u000b\u0011BA$\u0003M\t7o]5h]\u0016$'+\u001a9mS\u000e\fW*\u00199!\u0011%\t\u0019\u0006\u0001b\u0001\n\u0013\t)&A\nmK\u0006$WM]%teV\u0003H-\u0019;f\u0019>\u001c7.F\u0001\t\u0011\u001d\tI\u0006\u0001Q\u0001\n!\tA\u0003\\3bI\u0016\u0014\u0018j\u001d:Va\u0012\fG/\u001a'pG.\u0004\u0003\u0002CA/\u0001\u0001\u0007I\u0011\u0002\u0019\u0002\u0013i\\g+\u001a:tS>t\u0007\"CA1\u0001\u0001\u0007I\u0011BA2\u00035Q8NV3sg&|gn\u0018\u0013fcR\u00191(!\u001a\t\u0011}\ny&!AA\u0002EBq!!\u001b\u0001A\u0003&\u0011'\u0001\u0006{WZ+'o]5p]\u0002B\u0001\"!\u001c\u0001\u0001\u0004%I\u0001M\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007\u000eC\u0005\u0002r\u0001\u0001\r\u0011\"\u0003\u0002t\u0005yA.Z1eKJ,\u0005o\\2i?\u0012*\u0017\u000fF\u0002<\u0003kB\u0001bPA8\u0003\u0003\u0005\r!\r\u0005\b\u0003s\u0002\u0001\u0015)\u00032\u00031aW-\u00193fe\u0016\u0003xn\u00195!\u0011!\ti\b\u0001a\u0001\n\u0013\u0001\u0014aD2p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\t\u0013\u0005\u0005\u0005\u00011A\u0005\n\u0005\r\u0015aE2p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195`I\u0015\fHcA\u001e\u0002\u0006\"Aq(a \u0002\u0002\u0003\u0007\u0011\u0007C\u0004\u0002\n\u0002\u0001\u000b\u0015B\u0019\u0002!\r|g\u000e\u001e:pY2,'/\u00129pG\"\u0004\u0003\"CAG\u0001\t\u0007I\u0011BAH\u0003E\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM]\u000b\u0003\u0003#\u0003B!a%\u0002\u001e6\u0011\u0011Q\u0013\u0006\u0005\u0003/\u000bI*A\u0003m_\u001e$$NC\u0002\u0002\u001cr\fa!\u00199bG\",\u0017\u0002BAP\u0003+\u0013a\u0001T8hO\u0016\u0014\b\u0002CAR\u0001\u0001\u0006I!!%\u0002%M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'\u000f\t\u0005\b\u0003O\u0003A\u0011BAU\u00039I7OU3qY&\u001c\u0017\rT8dC2$B!a+\u00022B\u0019Q$!,\n\u0007\u0005=fDA\u0004C_>dW-\u00198\t\u000f\u0005M\u0016Q\u0015a\u0001c\u0005I!/\u001a9mS\u000e\f\u0017\n\u001a\u0005\b\u0003o\u0003A\u0011AA]\u0003EI7/\u00168eKJ\u0014V\r\u001d7jG\u0006$X\r\u001a\u000b\u0003\u0003WCq!!0\u0001\t\u0003\ty,\u0001\nhKR|%o\u0011:fCR,'+\u001a9mS\u000e\fG\u0003BA\u0018\u0003\u0003D\u0011\"a-\u0002<B\u0005\t\u0019A\u0019\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002H\u0006Qq-\u001a;SKBd\u0017nY1\u0015\t\u0005%\u00171\u001a\t\u0006;\u00055\u0011q\u0006\u0005\n\u0003g\u000b\u0019\r%AA\u0002EBq!a4\u0001\t\u0003\t\t.\u0001\u000bmK\u0006$WM\u001d*fa2L7-Y%g\u0019>\u001c\u0017\r\u001c\u000b\u0003\u0003\u0013Dq!!6\u0001\t\u0003\t9.A\u000bbI\u0012\u0014V\r\u001d7jG\u0006LeMT8u\u000bbL7\u000f^:\u0015\t\u0005=\u0012\u0011\u001c\u0005\t\u00037\f\u0019\u000e1\u0001\u00020\u00059!/\u001a9mS\u000e\f\u0007bBAp\u0001\u0011\u0005\u0011\u0011]\u0001\u0011CN\u001c\u0018n\u001a8fIJ+\u0007\u000f\\5dCN$\"!a\t\t\u000f\u0005\u0015\b\u0001\"\u0001\u0002h\u0006QQ.Y6f\u0019\u0016\fG-\u001a:\u0015\u0019\u0005-\u0016\u0011^Aw\u0003_\f\tP!\u0001\t\u000f\u0005-\u00181\u001da\u0001c\u0005a1m\u001c8ue>dG.\u001a:JI\"11%a9A\u0002\u0015BaaLAr\u0001\u0004\t\u0004\u0002CAz\u0003G\u0004\r!!>\u000271,\u0017\rZ3s\u0013N\u0014\u0018I\u001c3D_:$(o\u001c7mKJ,\u0005o\\2i!\u0011\t90!@\u000e\u0005\u0005e(bAA~\t\u0005Q1m\u001c8ue>dG.\u001a:\n\t\u0005}\u0018\u0011 \u0002\u001c\u0019\u0016\fG-\u001a:JgJ\fe\u000eZ\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\t\u000f\t\r\u00111\u001da\u0001c\u0005i1m\u001c:sK2\fG/[8o\u0013\u0012DqAa\u0002\u0001\t\u0003\u0011I!\u0001\u0007nC.,gi\u001c7m_^,'\u000f\u0006\b\u0002,\n-!Q\u0002B\b\u0005#\u0011\u0019Ba\b\t\u000f\u0005-(Q\u0001a\u0001c!11E!\u0002A\u0002\u0015Baa\fB\u0003\u0001\u0004\t\u0004\u0002CAz\u0005\u000b\u0001\r!!>\t\u0011\tU!Q\u0001a\u0001\u0005/\tA\"\u00197jm\u0016dU-\u00193feN\u0004b!!\n\u0002,\te\u0001c\u0001,\u0003\u001c%\u0019!Q\u0004\u0002\u0003\r\t\u0013xn[3s\u0011\u001d\u0011\u0019A!\u0002A\u0002EBqAa\t\u0001\t\u0003\u0011)#A\u0010va\u0012\fG/\u001a'fC\u0012,'\u000fS,B]\u0012l\u0015-\u001f2f\u000bb\u0004\u0018M\u001c3JgJ$Ra\u000fB\u0014\u0005SAq!a-\u0003\"\u0001\u0007\u0011\u0007\u0003\u0005\u0003,\t\u0005\u0002\u0019\u0001B\u0017\u0003\u0019ygMZ:fiB\u0019QDa\f\n\u0007\tEbD\u0001\u0003M_:<\u0007b\u0002B\u001b\u0001\u0011\u0005!qG\u0001\u001fG\",7m[#o_V<\u0007NU3qY&\u001c\u0017m\u001d*fC\u000eDwJ\u001a4tKR$bA!\u000f\u0003F\t%\u0003cB\u000f\u0003<\u0005-&qH\u0005\u0004\u0005{q\"A\u0002+va2,'\u0007E\u0002\u001e\u0005\u0003J1Aa\u0011\u001f\u0005\u0015\u0019\u0006n\u001c:u\u0011!\u00119Ea\rA\u0002\t5\u0012A\u0004:fcVL'/\u001a3PM\u001a\u001cX\r\u001e\u0005\b\u0005\u0017\u0012\u0019\u00041\u00012\u00031\u0011X-];je\u0016$\u0017iY6t\u0011\u001d\u0011y\u0005\u0001C\u0005\u0005#\na#\\1zE\u0016Len\u0019:f[\u0016tG\u000fT3bI\u0016\u0014\bj\u0016\u000b\u0004w\tM\u0003\u0002\u0003B+\u0005\u001b\u0002\r!a\f\u0002\u001b1,\u0017\rZ3s%\u0016\u0004H.[2b\u0011\u001d\u0011I\u0006\u0001C\u0001\u00057\na\"\\1zE\u0016\u001c\u0006N]5oW&\u001b(\u000fF\u0003<\u0005;\u0012\t\u0007\u0003\u0005\u0003`\t]\u0003\u0019\u0001B\u0017\u0003M\u0011X\r\u001d7jG\u0006l\u0015\r\u001f'bORKW.Z't\u0011!\u0011\u0019Ga\u0016A\u0002\t5\u0012!\u0006:fa2L7-Y'bq2\u000bw-T3tg\u0006<Wm\u001d\u0005\b\u0005O\u0002A\u0011\u0001B5\u0003Q9W\r^(vi>37+\u001f8d%\u0016\u0004H.[2bgRA\u00111\u0005B6\u0005[\u0012\t\b\u0003\u0005\u0003V\t\u0015\u0004\u0019AA\u0018\u0011!\u0011yG!\u001aA\u0002\t5\u0012\u0001E6fKBLenU=oGRKW.Z't\u0011!\u0011\u0019H!\u001aA\u0002\t5\u0012AE6fKBLenU=oG6+7o]1hKNDqAa\u001e\u0001\t\u0003\u0011I(\u0001\fbaB,g\u000eZ'fgN\fw-Z:U_2+\u0017\rZ3s)\u0011\u0011YH! \u0011\u000fu\u0011YD!\f\u0003.!A!q\u0010B;\u0001\u0004\u0011\t)\u0001\u0005nKN\u001c\u0018mZ3t!\u0011\u0011\u0019I!#\u000e\u0005\t\u0015%b\u0001BD\t\u00059Q.Z:tC\u001e,\u0017\u0002\u0002BF\u0005\u000b\u0013ACQ=uK\n+hMZ3s\u001b\u0016\u001c8/Y4f'\u0016$\bb\u0002BH\u0001\u0011%!\u0011S\u0001\nkB$\u0017\r^3JgJ$2a\u000fBJ\u0011!\u0011)J!$A\u0002\u0005\r\u0012A\u00028fo&\u001b(\u000fC\u0004\u0003\u001a\u0002!\tEa'\u0002\r\u0015\fX/\u00197t)\u0011\tYK!(\t\u0011\t}%q\u0013a\u0001\u0005C\u000bA\u0001\u001e5biB\u0019QDa)\n\u0007\t\u0015fDA\u0002B]fDqA!+\u0001\t\u0003\u0012Y+\u0001\u0005iCND7i\u001c3f)\u0005\t\u0004b\u0002BX\u0001\u0011\u0005#\u0011W\u0001\ti>\u001cFO]5oOR\tQ\u0005C\u0005\u00036\u0002\t\n\u0011\"\u0001\u00038\u0006ar-\u001a;Pe\u000e\u0013X-\u0019;f%\u0016\u0004H.[2bI\u0011,g-Y;mi\u0012\nTC\u0001B]U\r\t$1X\u0016\u0003\u0005{\u0003BAa0\u0003J6\u0011!\u0011\u0019\u0006\u0005\u0005\u0007\u0014)-A\u0005v]\u000eDWmY6fI*\u0019!q\u0019\u0010\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003L\n\u0005'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!q\u001a\u0001\u0012\u0002\u0013\u0005!qW\u0001\u0015O\u0016$(+\u001a9mS\u000e\fG\u0005Z3gCVdG\u000fJ\u0019")
public class Partition
implements Logging,
KafkaMetricsGroup,
ScalaObject {
    private final String topic;
    private final int partitionId;
    private int replicationFactor;
    public final Time kafka$cluster$Partition$$time;
    private final ReplicaManager replicaManager;
    private final int kafka$cluster$Partition$$localBrokerId;
    private final LogManager logManager;
    private final ReplicaFetcherManager replicaFetcherManager;
    private final ZkClient zkClient;
    private Option<Integer> leaderReplicaIdOpt;
    private Set<Replica> inSyncReplicas;
    private final Pool<Integer, Replica> assignedReplicaMap;
    private final Object leaderIsrUpdateLock;
    private int kafka$cluster$Partition$$zkVersion;
    private int leaderEpoch;
    private int controllerEpoch;
    private final Logger stateChangeLogger;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public Gauge newGauge(String string, Gauge gauge) {
        return KafkaMetricsGroup$class.newGauge(this, string, gauge);
    }

    @Override
    public Meter newMeter(String string, String string2, TimeUnit timeUnit) {
        return KafkaMetricsGroup$class.newMeter(this, string, string2, timeUnit);
    }

    @Override
    public Histogram newHistogram(String string, boolean bl) {
        return KafkaMetricsGroup$class.newHistogram(this, string, bl);
    }

    @Override
    public Timer newTimer(String string, TimeUnit timeUnit, TimeUnit timeUnit2) {
        return KafkaMetricsGroup$class.newTimer(this, string, timeUnit, timeUnit2);
    }

    @Override
    public /* synthetic */ boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        Partition partition = this;
        synchronized (partition) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 function0) {
        Logging$class.trace(this, function0);
    }

    public Object trace(Function0 function0) {
        return Logging$class.trace(this, function0);
    }

    public void trace(Function0 function0, Function0 function02) {
        Logging$class.trace(this, function0, function02);
    }

    public void swallowTrace(Function0 function0) {
        Logging$class.swallowTrace(this, function0);
    }

    public void debug(Function0 function0) {
        Logging$class.debug(this, function0);
    }

    public Object debug(Function0 function0) {
        return Logging$class.debug(this, function0);
    }

    public void debug(Function0 function0, Function0 function02) {
        Logging$class.debug(this, function0, function02);
    }

    public void swallowDebug(Function0 function0) {
        Logging$class.swallowDebug(this, function0);
    }

    public void info(Function0 function0) {
        Logging$class.info(this, function0);
    }

    public Object info(Function0 function0) {
        return Logging$class.info(this, function0);
    }

    public void info(Function0 function0, Function0 function02) {
        Logging$class.info(this, function0, function02);
    }

    public void swallowInfo(Function0 function0) {
        Logging$class.swallowInfo(this, function0);
    }

    public void warn(Function0 function0) {
        Logging$class.warn(this, function0);
    }

    public Object warn(Function0 function0) {
        return Logging$class.warn(this, function0);
    }

    public void warn(Function0 function0, Function0 function02) {
        Logging$class.warn(this, function0, function02);
    }

    public void swallowWarn(Function0 function0) {
        Logging$class.swallowWarn(this, function0);
    }

    public void swallow(Function0 function0) {
        Logging$class.swallow(this, function0);
    }

    public void error(Function0 function0) {
        Logging$class.error(this, function0);
    }

    public Object error(Function0 function0) {
        return Logging$class.error(this, function0);
    }

    public void error(Function0 function0, Function0 function02) {
        Logging$class.error(this, function0, function02);
    }

    public void swallowError(Function0 function0) {
        Logging$class.swallowError(this, function0);
    }

    public void fatal(Function0 function0) {
        Logging$class.fatal(this, function0);
    }

    public Object fatal(Function0 function0) {
        return Logging$class.fatal(this, function0);
    }

    public void fatal(Function0 function0, Function0 function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public /* synthetic */ int getReplica$default$1() {
        return this.kafka$cluster$Partition$$localBrokerId();
    }

    public /* synthetic */ int getOrCreateReplica$default$1() {
        return this.kafka$cluster$Partition$$localBrokerId();
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public int replicationFactor() {
        return this.replicationFactor;
    }

    public void replicationFactor_$eq(int n) {
        this.replicationFactor = n;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public final int kafka$cluster$Partition$$localBrokerId() {
        return this.kafka$cluster$Partition$$localBrokerId;
    }

    private LogManager logManager() {
        return this.logManager;
    }

    private ReplicaFetcherManager replicaFetcherManager() {
        return this.replicaFetcherManager;
    }

    private ZkClient zkClient() {
        return this.zkClient;
    }

    public Option<Integer> leaderReplicaIdOpt() {
        return this.leaderReplicaIdOpt;
    }

    public void leaderReplicaIdOpt_$eq(Option<Integer> option) {
        this.leaderReplicaIdOpt = option;
    }

    public Set<Replica> inSyncReplicas() {
        return this.inSyncReplicas;
    }

    public void inSyncReplicas_$eq(Set<Replica> set) {
        this.inSyncReplicas = set;
    }

    private Pool<Integer, Replica> assignedReplicaMap() {
        return this.assignedReplicaMap;
    }

    private Object leaderIsrUpdateLock() {
        return this.leaderIsrUpdateLock;
    }

    public final int kafka$cluster$Partition$$zkVersion() {
        return this.kafka$cluster$Partition$$zkVersion;
    }

    private void kafka$cluster$Partition$$zkVersion_$eq(int n) {
        this.kafka$cluster$Partition$$zkVersion = n;
    }

    private int leaderEpoch() {
        return this.leaderEpoch;
    }

    private void leaderEpoch_$eq(int n) {
        this.leaderEpoch = n;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private void controllerEpoch_$eq(int n) {
        this.controllerEpoch = n;
    }

    private Logger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private boolean isReplicaLocal(int n) {
        return n == this.kafka$cluster$Partition$$localBrokerId();
    }

    public boolean isUnderReplicated() {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Boolean bl = BoxesRunTime.boxToBoolean((this.inSyncReplicas().size() < this.replicationFactor() ? 1 : 0) != 0);
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }

    public Replica getOrCreateReplica(int n) {
        Option<Replica> option;
        block7: {
            Replica replica;
            block6: {
                Replica replica2;
                block5: {
                    Option<Replica> option2 = this.getReplica(n);
                    option = option2;
                    if (!(option instanceof Some)) break block5;
                    replica = (Replica)((Some)option).x();
                    break block6;
                }
                None$ none$ = None$.MODULE$;
                Option<Replica> option3 = option;
                if (none$ != null ? !none$.equals(option3) : option3 != null) break block7;
                if (this.isReplicaLocal(n)) {
                    Log log = this.logManager().getOrCreateLog(this.topic(), this.partitionId());
                    long l = Predef$.MODULE$.longWrapper(((HighwaterMarkCheckpoint)this.replicaManager().highWatermarkCheckpoints().apply((Object)log.dir().getParent())).read(this.topic(), this.partitionId())).min(log.logEndOffset());
                    Replica replica3 = new Replica(n, this, this.kafka$cluster$Partition$$time, l, (Option<Log>)new Some((Object)log));
                    replica2 = this.addReplicaIfNotExists(replica3);
                } else {
                    Replica replica4 = new Replica(n, this, this.kafka$cluster$Partition$$time, Replica$.MODULE$.init$default$4(), (Option<Log>)Replica$.MODULE$.init$default$5());
                    replica2 = this.addReplicaIfNotExists(replica4);
                }
                replica = (Replica)this.getReplica(n).get();
            }
            return replica;
        }
        throw new MatchError(option);
    }

    public Option<Replica> getReplica(int n) {
        Replica replica = this.assignedReplicaMap().get(BoxesRunTime.boxToInteger((int)n));
        return replica == null ? None$.MODULE$ : new Some((Object)replica);
    }

    public Option<Replica> leaderReplicaIfLocal() {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option<Integer> option;
            block6: {
                Option<Replica> option2;
                option = this.leaderReplicaIdOpt();
                if (option instanceof Some) {
                    option2 = BoxesRunTime.unboxToInt((Object)((Some)option).x()) == this.kafka$cluster$Partition$$localBrokerId() ? this.getReplica(this.kafka$cluster$Partition$$localBrokerId()) : None$.MODULE$;
                } else {
                    None$ none$ = None$.MODULE$;
                    Option<Integer> option3 = option;
                    if (none$ != null ? !none$.equals(option3) : option3 != null) break block6;
                    option2 = None$.MODULE$;
                }
                Option<Replica> option4 = option2;
                return option4;
            }
            throw new MatchError(option);
        }
    }

    public Replica addReplicaIfNotExists(Replica replica) {
        return this.assignedReplicaMap().putIfNotExists(BoxesRunTime.boxToInteger((int)replica.brokerId()), replica);
    }

    public Set<Replica> assignedReplicas() {
        return this.assignedReplicaMap().values().toSet();
    }

    public boolean makeLeader(int n, String string, int n2, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch, int n3) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch.leaderAndIsr();
            if (this.leaderEpoch() >= leaderAndIsr.leaderEpoch()) {
                this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Broker %d discarded the become-leader request with correlation id %d from controller %d epoch %d for partition [%s,%d] since current leader epoch %d is >= the request's leader epoch %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId()), BoxesRunTime.boxToInteger((int)n3), BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)leaderIsrAndControllerEpoch.controllerEpoch()), string, BoxesRunTime.boxToInteger((int)n2), BoxesRunTime.boxToInteger((int)this.leaderEpoch()), BoxesRunTime.boxToInteger((int)leaderAndIsr.leaderEpoch())})));
                return false;
            }
            this.controllerEpoch_$eq(leaderIsrAndControllerEpoch.controllerEpoch());
            this.replicaFetcherManager().removeFetcher(string, n2);
            scala.collection.immutable.Set set = ((TraversableOnce)leaderAndIsr.isr().map((Function1)new $anonfun$1(this), List$.MODULE$.canBuildFrom())).toSet();
            this.assignedReplicas().foreach((Function1)new $anonfun$makeLeader$1(this));
            this.inSyncReplicas_$eq((Set<Replica>)set);
            this.leaderEpoch_$eq(leaderAndIsr.leaderEpoch());
            this.kafka$cluster$Partition$$zkVersion_$eq(leaderAndIsr.zkVersion());
            this.leaderReplicaIdOpt_$eq((Option<Integer>)new Some((Object)BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId())));
            this.maybeIncrementLeaderHW((Replica)this.getReplica(this.getReplica$default$1()).get());
            Boolean bl = BoxesRunTime.boxToBoolean((boolean)true);
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }

    public boolean makeFollower(int n, String string, int n2, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch, Set<Broker> set, int n3) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option option;
            block9: {
                LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch.leaderAndIsr();
                if (this.leaderEpoch() >= leaderAndIsr.leaderEpoch()) {
                    this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Broker %d discarded the become-follower request with correlation id %d from controller %d epoch %d for partition [%s,%d] since current leader epoch %d is >= the request's leader epoch %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId()), BoxesRunTime.boxToInteger((int)n3), BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)leaderIsrAndControllerEpoch.controllerEpoch()), string, BoxesRunTime.boxToInteger((int)n2), BoxesRunTime.boxToInteger((int)this.leaderEpoch()), BoxesRunTime.boxToInteger((int)leaderAndIsr.leaderEpoch())})));
                    return false;
                }
                this.controllerEpoch_$eq(leaderIsrAndControllerEpoch.controllerEpoch());
                Replica replica = this.getOrCreateReplica(this.getOrCreateReplica$default$1());
                int n4 = leaderAndIsr.leader();
                option = set.find((Function1)new $anonfun$makeFollower$1(this, n4));
                if (option instanceof Some) {
                    this.replicaFetcherManager().removeFetcher(string, n2);
                    ((Log)replica.log().get()).truncateTo(replica.highWatermark());
                    this.inSyncReplicas_$eq((Set<Replica>)Set$.MODULE$.empty());
                    this.leaderEpoch_$eq(leaderAndIsr.leaderEpoch());
                    this.kafka$cluster$Partition$$zkVersion_$eq(leaderAndIsr.zkVersion());
                    this.leaderReplicaIdOpt_$eq((Option<Integer>)new Some((Object)BoxesRunTime.boxToInteger((int)n4)));
                    if (this.replicaManager().isShuttingDown().get()) {
                        this.stateChangeLogger().trace((Object)new StringBuilder().append((Object)"Broker %d ignored the become-follower state change with correlation id %d from ").append((Object)Predef$.MODULE$.augmentString(" controller %d epoch %d since it is shutting down").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId()), BoxesRunTime.boxToInteger((int)n3), BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)leaderIsrAndControllerEpoch.controllerEpoch())}))).toString());
                    } else {
                        this.replicaFetcherManager().addFetcher(string, n2, replica.logEndOffset(), (Broker)((Some)option).x());
                    }
                } else {
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block9;
                    this.stateChangeLogger().trace((Object)new StringBuilder().append((Object)"Broker %d aborted the become-follower state change with correlation id %d from ").append((Object)Predef$.MODULE$.augmentString(" controller %d epoch %d since leader %d for partition [%s,%d] is unavailable during the state change operation").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId()), BoxesRunTime.boxToInteger((int)n3), BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)leaderIsrAndControllerEpoch.controllerEpoch()), BoxesRunTime.boxToInteger((int)n4), string, BoxesRunTime.boxToInteger((int)n2)}))).toString());
                }
                Boolean bl = BoxesRunTime.boxToBoolean((boolean)true);
                return BoxesRunTime.unboxToBoolean((Object)bl);
            }
            throw new MatchError((Object)option);
        }
    }

    public void updateLeaderHWAndMaybeExpandIsr(int n, long l) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option<Replica> option;
            block9: {
                block8: {
                    BoxedUnit boxedUnit;
                    block7: {
                        Replica replica;
                        this.debug((Function0<String>)new $anonfun$updateLeaderHWAndMaybeExpandIsr$1(this, n, l));
                        Replica replica2 = this.getOrCreateReplica(n);
                        replica2.logEndOffset_$eq(l);
                        option = this.leaderReplicaIfLocal();
                        if (!(option instanceof Some)) break block7;
                        Some some = (Some)option;
                        Replica replica3 = replica = (Replica)some.x();
                        Replica replica4 = (Replica)this.getReplica(n).get();
                        long l2 = replica3.highWatermark();
                        if (!this.inSyncReplicas().contains((Object)replica4) && replica4.logEndOffset() >= l2) {
                            Set set = this.inSyncReplicas().$plus((Object)replica4);
                            this.info((Function0<String>)new $anonfun$updateLeaderHWAndMaybeExpandIsr$2(this, set));
                            this.updateIsr((Set<Replica>)set);
                            this.replicaManager().isrExpandRate().mark();
                        }
                        this.maybeIncrementLeaderHW(replica3);
                        boxedUnit = BoxedUnit.UNIT;
                        break block8;
                    }
                    None$ none$ = None$.MODULE$;
                    Option<Replica> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block9;
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError(option);
        }
    }

    public Tuple2<Boolean, Short> checkEnoughReplicasReachOffset(long l, int n) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option<Replica> option;
            block6: {
                Tuple2 tuple2;
                option = this.leaderReplicaIfLocal();
                if (option instanceof Some) {
                    int n2 = this.inSyncReplicas().count((Function1)new $anonfun$2(this, l));
                    this.trace((Function0<String>)new $anonfun$checkEnoughReplicasReachOffset$1(this, n, n2));
                    tuple2 = n < 0 && n2 >= this.inSyncReplicas().size() || n > 0 && n2 >= n ? new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NoError())) : new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NoError()));
                } else {
                    None$ none$ = None$.MODULE$;
                    Option<Replica> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NotLeaderForPartitionCode()));
                }
                Tuple2 tuple22 = tuple2;
                return tuple22;
            }
            throw new MatchError(option);
        }
    }

    private void maybeIncrementLeaderHW(Replica replica) {
        long l;
        Set set = (Set)this.inSyncReplicas().map((Function1)new $anonfun$3(this), Set$.MODULE$.canBuildFrom());
        long l2 = BoxesRunTime.unboxToLong((Object)set.min((Ordering)Ordering$Long$.MODULE$));
        if (l2 > (l = replica.highWatermark())) {
            replica.highWatermark_$eq(l2);
            this.debug((Function0<String>)new $anonfun$maybeIncrementLeaderHW$1(this, l2));
        } else {
            this.debug((Function0<String>)new $anonfun$maybeIncrementLeaderHW$2(this, set, l2, l));
        }
    }

    public void maybeShrinkIsr(long l, long l2) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option<Replica> option;
            block10: {
                block9: {
                    BoxedUnit boxedUnit;
                    block8: {
                        option = this.leaderReplicaIfLocal();
                        if (!(option instanceof Some)) break block8;
                        Some some = (Some)option;
                        Replica replica = (Replica)some.x();
                        Replica replica2 = replica;
                        Set<Replica> set = this.getOutOfSyncReplicas(replica2, l, l2);
                        if (set.size() > 0) {
                            Set set2 = (Set)this.inSyncReplicas().$minus$minus(set);
                            Predef$.MODULE$.assert(set2.size() > 0);
                            this.info((Function0<String>)new $anonfun$maybeShrinkIsr$1(this, set2));
                            this.updateIsr((Set<Replica>)set2);
                            this.maybeIncrementLeaderHW(replica2);
                            this.replicaManager().isrShrinkRate().mark();
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        break block9;
                    }
                    None$ none$ = None$.MODULE$;
                    Option<Replica> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block10;
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError(option);
        }
    }

    public Set<Replica> getOutOfSyncReplicas(Replica replica, long l, long l2) {
        Set set;
        Set set2;
        long l3 = replica.logEndOffset();
        Set set3 = this.inSyncReplicas().$minus((Object)replica);
        Set set4 = (Set)set3.filter((Function1)new $anonfun$4(this, l3));
        if (set4.size() > 0) {
            this.debug((Function0<String>)new $anonfun$getOutOfSyncReplicas$1(this, set4));
        }
        if ((set2 = (Set)set4.filter((Function1)new $anonfun$5(this, l))).size() > 0) {
            this.debug((Function0<String>)new $anonfun$getOutOfSyncReplicas$2(this, set2));
        }
        if ((set = (Set)set3.filter((Function1)new $anonfun$6(this, l2, l3))).size() > 0) {
            this.debug((Function0<String>)new $anonfun$getOutOfSyncReplicas$3(this, set));
        }
        return (Set)set2.$plus$plus((TraversableOnce)set);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Tuple2<Long, Long> appendMessagesToLeader(ByteBufferMessageSet byteBufferMessageSet) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option<Replica> option;
            Option<Replica> option2 = option = this.leaderReplicaIfLocal();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                Replica replica = (Replica)some.x();
                Replica replica2 = replica;
                Log log = (Log)replica2.log().get();
                Tuple2<Long, Long> tuple2 = log.append(byteBufferMessageSet, true);
                if (tuple2 == null) throw new MatchError(tuple2);
                Tuple2.mcLL.sp sp2 = new Tuple2.mcLL.sp(BoxesRunTime.unboxToLong((Object)tuple2._1()), BoxesRunTime.unboxToLong((Object)tuple2._2()));
                long l = sp2._1$mcL$sp();
                long l2 = sp2._2$mcL$sp();
                this.maybeIncrementLeaderHW(replica2);
                Tuple2.mcLL.sp sp3 = new Tuple2.mcLL.sp(l, l2);
                return (Tuple2)sp3;
            }
            {
                None$ none$ = None$.MODULE$;
                Option<Replica> option3 = option2;
                if (none$ == null) {
                    if (option3 == null) throw new NotLeaderForPartitionException(Predef$.MODULE$.augmentString("Leader not local for partition [%s,%d] on broker %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId())})));
                    throw new MatchError(option2);
                } else if (!none$.equals(option3)) throw new MatchError(option2);
                throw new NotLeaderForPartitionException(Predef$.MODULE$.augmentString("Leader not local for partition [%s,%d] on broker %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId())})));
            }
        }
    }

    private void updateIsr(Set<Replica> set) {
        this.debug((Function0<String>)new $anonfun$updateIsr$1(this, set));
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(this.kafka$cluster$Partition$$localBrokerId(), this.leaderEpoch(), (List<Integer>)((TraversableOnce)set.map((Function1)new $anonfun$7(this), Set$.MODULE$.canBuildFrom())).toList(), this.kafka$cluster$Partition$$zkVersion());
        Tuple2<Boolean, Integer> tuple2 = ZkUtils$.MODULE$.conditionalUpdatePersistentPath(this.zkClient(), ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(this.topic(), this.partitionId()), ZkUtils$.MODULE$.leaderAndIsrZkData(leaderAndIsr, this.controllerEpoch()), this.kafka$cluster$Partition$$zkVersion());
        if (tuple2 != null) {
            Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
            boolean bl = BoxesRunTime.unboxToBoolean((Object)tuple22._1());
            int n = tuple22._2$mcI$sp();
            if (bl) {
                this.inSyncReplicas_$eq(set);
                this.kafka$cluster$Partition$$zkVersion_$eq(n);
                this.trace((Function0<String>)new $anonfun$updateIsr$2(this, set));
            } else {
                this.info((Function0<String>)new $anonfun$updateIsr$3(this));
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public boolean equals(Object object) {
        if (object instanceof Partition) {
            Partition partition = (Partition)object;
            return this.topic().equals(partition.topic()) && this.partitionId() == partition.partitionId();
        }
        return false;
    }

    public int hashCode() {
        return 31 + this.topic().hashCode() + 17 * this.partitionId();
    }

    public String toString() {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(new StringBuilder().append((Object)"Topic: ").append((Object)this.topic()).toString());
            stringBuilder.append(new StringBuilder().append((Object)"; Partition: ").append((Object)BoxesRunTime.boxToInteger((int)this.partitionId())).toString());
            stringBuilder.append(new StringBuilder().append((Object)"; Leader: ").append(this.leaderReplicaIdOpt()).toString());
            stringBuilder.append(new StringBuilder().append((Object)"; AssignedReplicas: ").append((Object)this.assignedReplicaMap().keys().mkString(",")).toString());
            stringBuilder.append(new StringBuilder().append((Object)"; InSyncReplicas: ").append((Object)((TraversableOnce)this.inSyncReplicas().map((Function1)new $anonfun$toString$1(this), Set$.MODULE$.canBuildFrom())).mkString(",")).toString());
            String string = stringBuilder.toString();
            return string;
        }
    }

    public Partition(String string, int n, int n2, Time time, ReplicaManager replicaManager) {
        this.topic = string;
        this.partitionId = n;
        this.replicationFactor = n2;
        this.kafka$cluster$Partition$$time = time;
        this.replicaManager = replicaManager;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.kafka$cluster$Partition$$localBrokerId = replicaManager.config().brokerId();
        this.logManager = replicaManager.logManager();
        this.replicaFetcherManager = replicaManager.replicaFetcherManager();
        this.zkClient = replicaManager.zkClient();
        this.leaderReplicaIdOpt = None$.MODULE$;
        this.inSyncReplicas = Set$.MODULE$.empty();
        this.assignedReplicaMap = new Pool(Pool$.MODULE$.init$default$1());
        this.leaderIsrUpdateLock = new Object();
        this.kafka$cluster$Partition$$zkVersion = LeaderAndIsr$.MODULE$.initialZKVersion();
        this.leaderEpoch = LeaderAndIsr$.MODULE$.initialLeaderEpoch() - 1;
        this.controllerEpoch = KafkaController$.MODULE$.InitialControllerEpoch() - 1;
        this.logIdent_$eq(Predef$.MODULE$.augmentString("Partition [%s,%d] on broker %d: ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId())})));
        this.stateChangeLogger = Logger.getLogger((String)KafkaController$.MODULE$.stateChangeLogger());
        this.newGauge(new StringBuilder().append((Object)string).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)n)).append((Object)"-UnderReplicated").toString(), new $anon$1(this));
    }
}

