/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.io.IOException;
import kafka.api.FetchRequest;
import kafka.api.FetchResponse;
import kafka.api.FetchResponse$;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.OffsetResponse;
import kafka.api.OffsetResponse$;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.api.PartitionOffsetsResponse;
import kafka.api.RequestOrResponse;
import kafka.api.TopicMetadataRequest;
import kafka.api.TopicMetadataResponse;
import kafka.api.TopicMetadataResponse$;
import kafka.common.ErrorMapping$;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig$;
import kafka.consumer.FetchRequestAndResponseStats;
import kafka.consumer.FetchRequestAndResponseStatsRegistry$;
import kafka.consumer.SimpleConsumer$;
import kafka.metrics.KafkaTimer;
import kafka.network.BlockingChannel;
import kafka.network.BlockingChannel$;
import kafka.network.Receive;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003\u001dMKW\u000e\u001d7f\u0007>t7/^7fe*\u00111\u0001B\u0001\tG>t7/^7fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001A\u0001C\u0006\t\u0003\u00139i\u0011A\u0003\u0006\u0003\u00171\tA\u0001\\1oO*\tQ\"\u0001\u0003kCZ\f\u0017BA\b\u000b\u0005\u0019y%M[3diB\u0011\u0011\u0003F\u0007\u0002%)\u00111\u0003B\u0001\u0006kRLGn]\u0005\u0003+I\u0011q\u0001T8hO&tw\r\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002DA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002C\u000f\u0001\u0005\u000b\u0007I\u0011\u0001\u0010\u0002\t!|7\u000f^\u000b\u0002?A\u0011\u0001e\t\b\u0003/\u0005J!A\t\r\u0002\rA\u0013X\rZ3g\u0013\t!SE\u0001\u0004TiJLgn\u001a\u0006\u0003EaA\u0001b\n\u0001\u0003\u0002\u0003\u0006IaH\u0001\u0006Q>\u001cH\u000f\t\u0005\tS\u0001\u0011)\u0019!C\u0001U\u0005!\u0001o\u001c:u+\u0005Y\u0003CA\f-\u0013\ti\u0003DA\u0002J]RD\u0001b\f\u0001\u0003\u0002\u0003\u0006IaK\u0001\u0006a>\u0014H\u000f\t\u0005\tc\u0001\u0011)\u0019!C\u0001U\u0005I1o\u001c+j[\u0016|W\u000f\u001e\u0005\tg\u0001\u0011\t\u0011)A\u0005W\u0005Q1o\u001c+j[\u0016|W\u000f\u001e\u0011\t\u0011U\u0002!Q1A\u0005\u0002)\n!BY;gM\u0016\u00148+\u001b>f\u0011!9\u0004A!A!\u0002\u0013Y\u0013a\u00032vM\u001a,'oU5{K\u0002B\u0001\"\u000f\u0001\u0003\u0006\u0004%\tAH\u0001\tG2LWM\u001c;JI\"A1\b\u0001B\u0001B\u0003%q$A\u0005dY&,g\u000e^%eA!)Q\b\u0001C\u0001}\u00051A(\u001b8jiz\"baP!C\u0007\u0012+\u0005C\u0001!\u0001\u001b\u0005\u0011\u0001\"B\u000f=\u0001\u0004y\u0002\"B\u0015=\u0001\u0004Y\u0003\"B\u0019=\u0001\u0004Y\u0003\"B\u001b=\u0001\u0004Y\u0003\"B\u001d=\u0001\u0004y\u0002bB$\u0001\u0005\u0004%I\u0001S\u0001\u0005Y>\u001c7.F\u0001\t\u0011\u0019Q\u0005\u0001)A\u0005\u0011\u0005)An\\2lA!9A\n\u0001b\u0001\n\u0013i\u0015a\u00042m_\u000e\\\u0017N\\4DQ\u0006tg.\u001a7\u0016\u00039\u0003\"a\u0014*\u000e\u0003AS!!\u0015\u0003\u0002\u000f9,Go^8sW&\u00111\u000b\u0015\u0002\u0010\u00052|7m[5oO\u000eC\u0017M\u001c8fY\"1Q\u000b\u0001Q\u0001\n9\u000b\u0001C\u00197pG.LgnZ\"iC:tW\r\u001c\u0011\t\u000f]\u0003!\u0019!C\u0001=\u0005Q!M]8lKJLeNZ8\t\re\u0003\u0001\u0015!\u0003 \u0003-\u0011'o\\6fe&sgm\u001c\u0011\t\u000fm\u0003!\u0019!C\u00059\u0006ab-\u001a;dQJ+\u0017/^3ti\u0006sGMU3ta>t7/Z*uCR\u001cX#A/\u0011\u0005\u0001s\u0016BA0\u0003\u0005q1U\r^2i%\u0016\fX/Z:u\u0003:$'+Z:q_:\u001cXm\u0015;biNDa!\u0019\u0001!\u0002\u0013i\u0016!\b4fi\u000eD'+Z9vKN$\u0018I\u001c3SKN\u0004xN\\:f'R\fGo\u001d\u0011\t\u000f\r\u0004\u0001\u0019!C\u0005I\u0006A\u0011n]\"m_N,G-F\u0001f!\t9b-\u0003\u0002h1\t9!i\\8mK\u0006t\u0007bB5\u0001\u0001\u0004%IA[\u0001\rSN\u001cEn\\:fI~#S-\u001d\u000b\u0003W:\u0004\"a\u00067\n\u00055D\"\u0001B+oSRDqa\u001c5\u0002\u0002\u0003\u0007Q-A\u0002yIEBa!\u001d\u0001!B\u0013)\u0017!C5t\u00072|7/\u001a3!\u0011\u0015\u0019\b\u0001\"\u0003u\u0003\u001d\u0019wN\u001c8fGR$\u0012A\u0014\u0005\u0006m\u0002!Ia^\u0001\u000bI&\u001c8m\u001c8oK\u000e$H#A6\t\u000be\u0004A\u0011B<\u0002\u0013I,7m\u001c8oK\u000e$\b\"B>\u0001\t\u00039\u0018!B2m_N,\u0007\"B?\u0001\t\u0013q\u0018aC:f]\u0012\u0014V-];fgR$2a`A\u0003!\ry\u0015\u0011A\u0005\u0004\u0003\u0007\u0001&a\u0002*fG\u0016Lg/\u001a\u0005\b\u0003\u000fa\b\u0019AA\u0005\u0003\u001d\u0011X-];fgR\u0004B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001f!\u0011aA1qS&!\u00111CA\u0007\u0005E\u0011V-];fgR|%OU3ta>t7/\u001a\u0005\b\u0003/\u0001A\u0011AA\r\u0003\u0011\u0019XM\u001c3\u0015\t\u0005m\u0011\u0011\u0005\t\u0005\u0003\u0017\ti\"\u0003\u0003\u0002 \u00055!!\u0006+pa&\u001cW*\u001a;bI\u0006$\u0018MU3ta>t7/\u001a\u0005\t\u0003\u000f\t)\u00021\u0001\u0002$A!\u00111BA\u0013\u0013\u0011\t9#!\u0004\u0003)Q{\u0007/[2NKR\fG-\u0019;b%\u0016\fX/Z:u\u0011\u001d\tY\u0003\u0001C\u0001\u0003[\tQAZ3uG\"$B!a\f\u00026A!\u00111BA\u0019\u0013\u0011\t\u0019$!\u0004\u0003\u001b\u0019+Go\u00195SKN\u0004xN\\:f\u0011!\t9!!\u000bA\u0002\u0005]\u0002\u0003BA\u0006\u0003sIA!a\u000f\u0002\u000e\taa)\u001a;dQJ+\u0017/^3ti\"9\u0011q\b\u0001\u0005\u0002\u0005\u0005\u0013\u0001E4fi>3gm]3ug\n+gm\u001c:f)\u0011\t\u0019%!\u0013\u0011\t\u0005-\u0011QI\u0005\u0005\u0003\u000f\niA\u0001\bPM\u001a\u001cX\r\u001e*fgB|gn]3\t\u0011\u0005\u001d\u0011Q\ba\u0001\u0003\u0017\u0002B!a\u0003\u0002N%!\u0011qJA\u0007\u00055yeMZ:fiJ+\u0017/^3ti\"1\u00111\u000b\u0001\u0005\n]\f1cZ3u\u001fJl\u0015m[3D_:tWm\u0019;j_:Dq!a\u0016\u0001\t\u0003\tI&\u0001\ffCJd\u0017.Z:u\u001fJd\u0015\r^3ti>3gm]3u)!\tY&!\u0019\u0002r\u0005U\u0004cA\f\u0002^%\u0019\u0011q\f\r\u0003\t1{gn\u001a\u0005\t\u0003G\n)\u00061\u0001\u0002f\u0005\tBo\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\u0011\t\u0005\u001d\u0014QN\u0007\u0003\u0003SR1!a\u001b\u0005\u0003\u0019\u0019w.\\7p]&!\u0011qNA5\u0005E!v\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\u0005\t\u0003g\n)\u00061\u0001\u0002\\\u0005\u0001R-\u0019:mS\u0016\u001cHo\u0014:MCR,7\u000f\u001e\u0005\b\u0003o\n)\u00061\u0001,\u0003)\u0019wN\\:v[\u0016\u0014\u0018\n\u001a\u0015\u0004\u0001\u0005m\u0004cA\t\u0002~%\u0019\u0011q\u0010\n\u0003\u0015QD'/Z1eg\u00064W\r")
public class SimpleConsumer
implements Logging,
ScalaObject {
    private final String host;
    private final int port;
    private final int soTimeout;
    private final int bufferSize;
    private final String clientId;
    private final Object lock;
    private final BlockingChannel blockingChannel;
    private final String brokerInfo;
    private final FetchRequestAndResponseStats fetchRequestAndResponseStats;
    private boolean isClosed;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        SimpleConsumer simpleConsumer = this;
        synchronized (simpleConsumer) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 function0) {
        Logging$class.trace(this, function0);
    }

    public Object trace(Function0 function0) {
        return Logging$class.trace(this, function0);
    }

    public void trace(Function0 function0, Function0 function02) {
        Logging$class.trace(this, function0, function02);
    }

    public void swallowTrace(Function0 function0) {
        Logging$class.swallowTrace(this, function0);
    }

    public void debug(Function0 function0) {
        Logging$class.debug(this, function0);
    }

    public Object debug(Function0 function0) {
        return Logging$class.debug(this, function0);
    }

    public void debug(Function0 function0, Function0 function02) {
        Logging$class.debug(this, function0, function02);
    }

    public void swallowDebug(Function0 function0) {
        Logging$class.swallowDebug(this, function0);
    }

    public void info(Function0 function0) {
        Logging$class.info(this, function0);
    }

    public Object info(Function0 function0) {
        return Logging$class.info(this, function0);
    }

    public void info(Function0 function0, Function0 function02) {
        Logging$class.info(this, function0, function02);
    }

    public void swallowInfo(Function0 function0) {
        Logging$class.swallowInfo(this, function0);
    }

    public void warn(Function0 function0) {
        Logging$class.warn(this, function0);
    }

    public Object warn(Function0 function0) {
        return Logging$class.warn(this, function0);
    }

    public void warn(Function0 function0, Function0 function02) {
        Logging$class.warn(this, function0, function02);
    }

    public void swallowWarn(Function0 function0) {
        Logging$class.swallowWarn(this, function0);
    }

    public void swallow(Function0 function0) {
        Logging$class.swallow(this, function0);
    }

    public void error(Function0 function0) {
        Logging$class.error(this, function0);
    }

    public Object error(Function0 function0) {
        return Logging$class.error(this, function0);
    }

    public void error(Function0 function0, Function0 function02) {
        Logging$class.error(this, function0, function02);
    }

    public void swallowError(Function0 function0) {
        Logging$class.swallowError(this, function0);
    }

    public void fatal(Function0 function0) {
        Logging$class.fatal(this, function0);
    }

    public Object fatal(Function0 function0) {
        return Logging$class.fatal(this, function0);
    }

    public void fatal(Function0 function0, Function0 function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public int soTimeout() {
        return this.soTimeout;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public String clientId() {
        return this.clientId;
    }

    private Object lock() {
        return this.lock;
    }

    private BlockingChannel blockingChannel() {
        return this.blockingChannel;
    }

    public String brokerInfo() {
        return this.brokerInfo;
    }

    private FetchRequestAndResponseStats fetchRequestAndResponseStats() {
        return this.fetchRequestAndResponseStats;
    }

    private boolean isClosed() {
        return this.isClosed;
    }

    private void isClosed_$eq(boolean bl) {
        this.isClosed = bl;
    }

    private BlockingChannel connect() {
        this.close();
        this.blockingChannel().connect();
        return this.blockingChannel();
    }

    private void disconnect() {
        if (this.blockingChannel().isConnected()) {
            this.debug((Function0<String>)new $anonfun$disconnect$1(this));
            this.blockingChannel().disconnect();
        }
    }

    private void reconnect() {
        this.disconnect();
        this.connect();
    }

    public void close() {
        Object object = this.lock();
        synchronized (object) {
            this.disconnect();
            this.isClosed_$eq(true);
            return;
        }
    }

    public final Receive kafka$consumer$SimpleConsumer$$sendRequest(RequestOrResponse requestOrResponse) {
        Object object = this.lock();
        synchronized (object) {
            this.getOrMakeConnection();
            ObjectRef objectRef = new ObjectRef(null);
            this.liftedTree1$1(requestOrResponse, objectRef);
            Receive receive = (Receive)objectRef.elem;
            return receive;
        }
    }

    public TopicMetadataResponse send(TopicMetadataRequest topicMetadataRequest) {
        Receive receive = this.kafka$consumer$SimpleConsumer$$sendRequest(topicMetadataRequest);
        return TopicMetadataResponse$.MODULE$.readFrom(receive.buffer());
    }

    public FetchResponse fetch(FetchRequest fetchRequest) {
        ObjectRef objectRef = new ObjectRef(null);
        KafkaTimer kafkaTimer = this.fetchRequestAndResponseStats().getFetchRequestAndResponseStats(this.brokerInfo()).requestTimer();
        KafkaTimer kafkaTimer2 = this.fetchRequestAndResponseStats().getFetchRequestAndResponseAllBrokersStats().requestTimer();
        kafkaTimer2.time(new $anonfun$fetch$1(this, fetchRequest, objectRef, kafkaTimer));
        FetchResponse fetchResponse = FetchResponse$.MODULE$.readFrom(((Receive)objectRef.elem).buffer());
        int n = fetchResponse.sizeInBytes();
        this.fetchRequestAndResponseStats().getFetchRequestAndResponseStats(this.brokerInfo()).requestSizeHist().update(n);
        this.fetchRequestAndResponseStats().getFetchRequestAndResponseAllBrokersStats().requestSizeHist().update(n);
        return fetchResponse;
    }

    public OffsetResponse getOffsetsBefore(OffsetRequest offsetRequest) {
        return OffsetResponse$.MODULE$.readFrom(this.kafka$consumer$SimpleConsumer$$sendRequest(offsetRequest).buffer());
    }

    private void getOrMakeConnection() {
        if (!this.isClosed() && !this.blockingChannel().isConnected()) {
            this.connect();
        }
    }

    public long earliestOrLatestOffset(TopicAndPartition topicAndPartition, long l, int n) {
        int n2;
        Map map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)topicAndPartition).$minus$greater((Object)new PartitionOffsetRequestInfo(l, 1))}));
        String string = this.clientId();
        int n3 = n;
        short s = OffsetRequest$.MODULE$.apply$default$2();
        OffsetRequest offsetRequest = new OffsetRequest((Map<TopicAndPartition, PartitionOffsetRequestInfo>)map, s, n2 = OffsetRequest$.MODULE$.apply$default$3(), string, n3);
        PartitionOffsetsResponse partitionOffsetsResponse = (PartitionOffsetsResponse)this.getOffsetsBefore(offsetRequest).partitionErrorAndOffsets().apply((Object)topicAndPartition);
        short s2 = partitionOffsetsResponse.error();
        if (s2 == ErrorMapping$.MODULE$.NoError()) {
            long l2 = BoxesRunTime.unboxToLong((Object)partitionOffsetsResponse.offsets().head());
            return l2;
        }
        throw ErrorMapping$.MODULE$.exceptionFor(partitionOffsetsResponse.error());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void liftedTree1$1(RequestOrResponse requestOrResponse, ObjectRef objectRef) {
        try {
            this.blockingChannel().send(requestOrResponse);
            objectRef.elem = this.blockingChannel().receive();
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (IOException iOException) {
            this.info((Function0<String>)new $anonfun$liftedTree1$1$1(this), (Function0<Throwable>)new $anonfun$liftedTree1$1$2(this, iOException));
            try {
                this.reconnect();
                this.blockingChannel().send(requestOrResponse);
                objectRef.elem = this.blockingChannel().receive();
                return;
            }
            catch (IOException iOException2) {
                this.disconnect();
                throw iOException2;
            }
        }
    }

    public SimpleConsumer(String string, int n, int n2, int n3, String string2) {
        this.host = string;
        this.port = n;
        this.soTimeout = n2;
        this.bufferSize = n3;
        this.clientId = string2;
        Logging$class.$init$(this);
        ConsumerConfig$.MODULE$.validateClientId(string2);
        this.lock = new Object();
        this.blockingChannel = new BlockingChannel(string, n, n3, BlockingChannel$.MODULE$.UseDefaultBufferSize(), n2);
        this.brokerInfo = Predef$.MODULE$.augmentString("host_%s-port_%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, BoxesRunTime.boxToInteger((int)n)}));
        this.fetchRequestAndResponseStats = FetchRequestAndResponseStatsRegistry$.MODULE$.getFetchRequestAndResponseStats(string2);
        this.isClosed = false;
    }
}

