/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsr;
import kafka.api.RequestOrResponse;
import kafka.common.LeaderElectionNotNeededException;
import kafka.common.NoReplicaOnlineException;
import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NoOpLeaderSelector;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderSelector;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine$;
import kafka.controller.PartitionStateMachine$TopicChangeListener$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t5c\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003+A\u000b'\u000f^5uS>t7\u000b^1uK6\u000b7\r[5oK*\u00111\u0001B\u0001\u000bG>tGO]8mY\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0003\t\u0017!\tIa\"D\u0001\u000b\u0015\tYA\"\u0001\u0003mC:<'\"A\u0007\u0002\t)\fg/Y\u0005\u0003\u001f)\u0011aa\u00142kK\u000e$\bCA\t\u0015\u001b\u0005\u0011\"BA\n\u0005\u0003\u0015)H/\u001b7t\u0013\t)\"CA\u0004M_\u001e<\u0017N\\4\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t\u0007\u0001\u0011\t\u0011)A\u0005;A\u0011adH\u0007\u0002\u0005%\u0011\u0001E\u0001\u0002\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe\")!\u0005\u0001C\u0001G\u00051A(\u001b8jiz\"\"\u0001J\u0013\u0011\u0005y\u0001\u0001\"B\u0002\"\u0001\u0004i\u0002bB\u0014\u0001\u0005\u0004%I\u0001K\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$X#A\u0015\u0011\u0005yQ\u0013BA\u0016\u0003\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0005\u0007[\u0001\u0001\u000b\u0011B\u0015\u0002%\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000f\t\u0005\b_\u0001\u0011\r\u0011\"\u00031\u00031\u0019wN\u001c;s_2dWM]%e+\u0005\t\u0004CA\f3\u0013\t\u0019\u0004DA\u0002J]RDa!\u000e\u0001!\u0002\u0013\t\u0014!D2p]R\u0014x\u000e\u001c7fe&#\u0007\u0005C\u00048\u0001\t\u0007I\u0011\u0002\u001d\u0002\u0011i\\7\t\\5f]R,\u0012!\u000f\t\u0003u\u0005k\u0011a\u000f\u0006\u0003yu\n\u0001B_6dY&,g\u000e\u001e\u0006\u0003}}\na!\u0013\u0019Ji\u0016\u001c'\"\u0001!\u0002\u0007=\u0014x-\u0003\u0002Cw\tA!l[\"mS\u0016tG\u000f\u0003\u0004E\u0001\u0001\u0006I!O\u0001\nu.\u001cE.[3oi\u0002BqA\u0012\u0001A\u0002\u0013\u0005q)\u0001\bqCJ$\u0018\u000e^5p]N#\u0018\r^3\u0016\u0003!\u0003B!\u0013(Q-6\t!J\u0003\u0002L\u0019\u00069Q.\u001e;bE2,'BA'\u0019\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u001f*\u00131!T1q!\t\tF+D\u0001S\u0015\t\u0019F!\u0001\u0004d_6lwN\\\u0005\u0003+J\u0013\u0011\u0003V8qS\u000e\fe\u000e\u001a)beRLG/[8o!\tqr+\u0003\u0002Y\u0005\tq\u0001+\u0019:uSRLwN\\*uCR,\u0007b\u0002.\u0001\u0001\u0004%\taW\u0001\u0013a\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f?\u0012*\u0017\u000f\u0006\u0002]?B\u0011q#X\u0005\u0003=b\u0011A!\u00168ji\"9\u0001-WA\u0001\u0002\u0004A\u0015a\u0001=%c!1!\r\u0001Q!\n!\u000bq\u0002]1si&$\u0018n\u001c8Ti\u0006$X\r\t\u0005\bI\u0002\u0011\r\u0011\"\u0001f\u0003I\u0011'o\\6feJ+\u0017/^3ti\n\u000bGo\u00195\u0016\u0003\u0019\u0004\"AH4\n\u0005!\u0014!\u0001H\"p]R\u0014x\u000e\u001c7fe\n\u0013xn[3s%\u0016\fX/Z:u\u0005\u0006$8\r\u001b\u0005\u0007U\u0002\u0001\u000b\u0011\u00024\u0002'\t\u0014xn[3s%\u0016\fX/Z:u\u0005\u0006$8\r\u001b\u0011\t\u000f1\u0004!\u0019!C\u0005[\u0006Q\u0001.Y:Ti\u0006\u0014H/\u001a3\u0016\u00039\u0004\"a\u001c<\u000e\u0003AT!!\u001d:\u0002\r\u0005$x.\\5d\u0015\t\u0019H/\u0001\u0006d_:\u001cWO\u001d:f]RT!!\u001e\u0007\u0002\tU$\u0018\u000e\\\u0005\u0003oB\u0014Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007BB=\u0001A\u0003%a.A\u0006iCN\u001cF/\u0019:uK\u0012\u0004\u0003bB>\u0001\u0005\u0004%I\u0001`\u0001\u001c]>|\u0005\u000fU1si&$\u0018n\u001c8MK\u0006$WM]*fY\u0016\u001cGo\u001c:\u0016\u0003u\u0004\"A\b@\n\u0005}\u0014!A\u0005(p\u001fBdU-\u00193feN+G.Z2u_JDq!a\u0001\u0001A\u0003%Q0\u0001\u000fo_>\u0003\b+\u0019:uSRLwN\u001c'fC\u0012,'oU3mK\u000e$xN\u001d\u0011\t\u0013\u0005\u001d\u0001A1A\u0005\n\u0005%\u0011!E:uCR,7\t[1oO\u0016dunZ4feV\u0011\u00111\u0002\t\u0005\u0003\u001b\t9\"\u0004\u0002\u0002\u0010)!\u0011\u0011CA\n\u0003\u0015awn\u001a\u001bk\u0015\r\t)bP\u0001\u0007CB\f7\r[3\n\t\u0005e\u0011q\u0002\u0002\u0007\u0019><w-\u001a:\t\u0011\u0005u\u0001\u0001)A\u0005\u0003\u0017\t!c\u001d;bi\u0016\u001c\u0005.\u00198hK2{wmZ3sA!9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0012aB:uCJ$X\u000f\u001d\u000b\u00029\"9\u0011q\u0005\u0001\u0005\u0002\u0005\r\u0012!\u0005:fO&\u001cH/\u001a:MSN$XM\\3sg\"9\u00111\u0006\u0001\u0005\u0002\u0005\r\u0012\u0001C:ikR$wn\u001e8\t\u000f\u0005=\u0002\u0001\"\u0001\u0002$\u0005\tCO]5hO\u0016\u0014xJ\u001c7j]\u0016\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\u001c\u0005.\u00198hK\"9\u00111\u0007\u0001\u0005\u0002\u0005U\u0012A\u00055b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hKN$r\u0001XA\u001c\u0003\u0007\n9\u0005\u0003\u0005\u0002:\u0005E\u0002\u0019AA\u001e\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0006\u0003{\ty\u0004U\u0007\u0002\u0019&\u0019\u0011\u0011\t'\u0003\u0007M+G\u000fC\u0004\u0002F\u0005E\u0002\u0019\u0001,\u0002\u0017Q\f'oZ3u'R\fG/\u001a\u0005\u000b\u0003\u0013\n\t\u0004%AA\u0002\u0005-\u0013A\u00047fC\u0012,'oU3mK\u000e$xN\u001d\t\u0004=\u00055\u0013bAA(\u0005\t9\u0002+\u0019:uSRLwN\u001c'fC\u0012,'oU3mK\u000e$xN\u001d\u0005\b\u0003'\u0002A\u0011BA+\u0003EA\u0017M\u001c3mKN#\u0018\r^3DQ\u0006tw-\u001a\u000b\n9\u0006]\u0013\u0011NA7\u0003_B\u0001\"!\u0017\u0002R\u0001\u0007\u00111L\u0001\u0006i>\u0004\u0018n\u0019\t\u0005\u0003;\n\u0019GD\u0002\u0018\u0003?J1!!\u0019\u0019\u0003\u0019\u0001&/\u001a3fM&!\u0011QMA4\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\r\r\t\u000f\u0005-\u0014\u0011\u000ba\u0001c\u0005I\u0001/\u0019:uSRLwN\u001c\u0005\b\u0003\u000b\n\t\u00061\u0001W\u0011!\tI%!\u0015A\u0002\u0005-\u0003bBA:\u0001\u0011%\u00111E\u0001\u0019S:LG/[1mSj,\u0007+\u0019:uSRLwN\\*uCR,\u0007bBA<\u0001\u0011%\u0011\u0011P\u0001\u001aCN\u001cXM\u001d;WC2LG\r\u0015:fm&|Wo]*uCR,7\u000fF\u0004]\u0003w\ny(!#\t\u000f\u0005u\u0014Q\u000fa\u0001!\u0006\tBo\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\t\u0011\u0005\u0005\u0015Q\u000fa\u0001\u0003\u0007\u000b!B\u001a:p[N#\u0018\r^3t!\u0015\ti$!\"W\u0013\r\t9\t\u0014\u0002\u0004'\u0016\f\bbBA#\u0003k\u0002\rA\u0016\u0005\b\u0003\u001b\u0003A\u0011BAH\u0003i\t7o]5h]J+\u0007\u000f\\5dCN$v\u000eU1si&$\u0018n\u001c8t)\u0015a\u0016\u0011SAJ\u0011!\tI&a#A\u0002\u0005m\u0003bBA6\u0003\u0017\u0003\r!\r\u0005\b\u0003/\u0003A\u0011BAM\u0003\tJg.\u001b;jC2L'0\u001a'fC\u0012,'/\u00118e\u0013N\u0014hi\u001c:QCJ$\u0018\u000e^5p]R\u0019A,a'\t\u000f\u0005u\u0014Q\u0013a\u0001!\"9\u0011q\u0014\u0001\u0005\u0002\u0005\u0005\u0016aF3mK\u000e$H*Z1eKJ4uN\u001d)beRLG/[8o)\u001da\u00161UAS\u0003OC\u0001\"!\u0017\u0002\u001e\u0002\u0007\u00111\f\u0005\b\u0003W\ni\n1\u00012\u0011!\tI%!(A\u0002\u0005-\u0003bBAV\u0001\u0011%\u0011QV\u0001\u001ce\u0016<\u0017n\u001d;feR{\u0007/[2DQ\u0006tw-\u001a'jgR,g.\u001a:\u0015\u0005\u0005=\u0006CBAY\u0003g\u000b9,D\u0001u\u0013\r\t)\f\u001e\u0002\u0005\u0019&\u001cH\u000fE\u0002\n\u0003sK1!!\u001a\u000b\u0011\u001d\ti\f\u0001C\u0001\u0003\u007f\u000bqD]3hSN$XM\u001d)beRLG/[8o\u0007\"\fgnZ3MSN$XM\\3s)\u0011\ty+!1\t\u0011\u0005e\u00131\u0018a\u0001\u00037Bq!!2\u0001\t\u0013\t9-\u0001\u0013hKRdU-\u00193fe&\u001b(/\u00118e\u000bB|7\r[(s)\"\u0014xn^#yG\u0016\u0004H/[8o)\u0019\tI-a4\u0002RB\u0019a$a3\n\u0007\u00055'AA\u000eMK\u0006$WM]%te\u0006sGmQ8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u0005\t\u00033\n\u0019\r1\u0001\u0002\\!9\u00111NAb\u0001\u0004\tdACAk\u0001\u0011\u0005\t\u0011!\u0001\u0002X\n\u0019Bk\u001c9jG\u000eC\u0017M\\4f\u0019&\u001cH/\u001a8feN9\u00111\u001b\u0005\u0002ZB1\u0002c\u0001\u001e\u0002\\&\u0019\u0011Q\\\u001e\u0003!%S6n\u00115jY\u0012d\u0015n\u001d;f]\u0016\u0014\bb\u0002\u0012\u0002T\u0012\u0005\u0011\u0011\u001d\u000b\u0003\u0003G\u0004B!!:\u0002T6\t\u0001\u0001\u0003\u0005\u0002j\u0006MG\u0011AAv\u0003EA\u0017M\u001c3mK\u000eC\u0017\u000e\u001c3DQ\u0006tw-\u001a\u000b\u00069\u00065\u0018\u0011\u001f\u0005\t\u0003_\f9\u000f1\u0001\u0002\\\u0005Q\u0001/\u0019:f]R\u0004\u0016\r\u001e5\t\u0011\u0005M\u0018q\u001da\u0001\u0003k\f\u0001b\u00195jY\u0012\u0014XM\u001c\t\u0007\u0003c\u000b\u0019,a\u0017)\r\u0005\u001d\u0018\u0011`A\u0000!\r9\u00121`\u0005\u0004\u0003{D\"A\u0002;ie><8o\t\u0002\u0003\u0002A!!1\u0001B\n\u001d\u0011\u0011)Aa\u0004\u000f\t\t\u001d!QB\u0007\u0003\u0005\u0013Q1Aa\u0003\u0007\u0003\u0019a$o\\8u}%\t\u0011$C\u0002\u0003\u0012a\tq\u0001]1dW\u0006<W-\u0003\u0003\u0003\u0016\t]!!C#yG\u0016\u0004H/[8o\u0015\r\u0011\t\u0002\u0007\u0004\u000b\u00057\u0001A\u0011!A\u0001\u0002\tu!a\u0006)beRLG/[8o\u0007\"\fgnZ3MSN$XM\\3s'\u001d\u0011I\u0002CAm!YA1\"!\u0017\u0003\u001a\t\u0005\t\u0015!\u0003\u0002\\!9!E!\u0007\u0005\u0002\t\rB\u0003\u0002B\u0013\u0005O\u0001B!!:\u0003\u001a!A\u0011\u0011\fB\u0011\u0001\u0004\tY\u0006\u0003\u0005\u0002j\neA\u0011\u0001B\u0016)\u0015a&Q\u0006B\u0018\u0011!\tyO!\u000bA\u0002\u0005m\u0003\u0002CAz\u0005S\u0001\r!!>)\r\t%\u0012\u0011`A\u0000\u0011%\u0011)\u0004AI\u0001\n\u0003\u00119$\u0001\u000fiC:$G.Z*uCR,7\t[1oO\u0016\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\te\"\u0006BA&\u0005wY#A!\u0010\u0011\t\t}\"\u0011J\u0007\u0003\u0005\u0003RAAa\u0011\u0003F\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u000fB\u0012AC1o]>$\u0018\r^5p]&!!1\nB!\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class PartitionStateMachine
implements Logging,
ScalaObject {
    public final KafkaController kafka$controller$PartitionStateMachine$$controller;
    private final ControllerContext kafka$controller$PartitionStateMachine$$controllerContext;
    private final int controllerId;
    private final ZkClient kafka$controller$PartitionStateMachine$$zkClient;
    private Map<TopicAndPartition, PartitionState> partitionState;
    private final ControllerBrokerRequestBatch brokerRequestBatch;
    private final AtomicBoolean kafka$controller$PartitionStateMachine$$hasStarted;
    private final NoOpLeaderSelector noOpPartitionLeaderSelector;
    private final Logger stateChangeLogger;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        PartitionStateMachine partitionStateMachine = this;
        synchronized (partitionStateMachine) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 function0) {
        Logging$class.trace(this, function0);
    }

    public Object trace(Function0 function0) {
        return Logging$class.trace(this, function0);
    }

    public void trace(Function0 function0, Function0 function02) {
        Logging$class.trace(this, function0, function02);
    }

    public void swallowTrace(Function0 function0) {
        Logging$class.swallowTrace(this, function0);
    }

    public void debug(Function0 function0) {
        Logging$class.debug(this, function0);
    }

    public Object debug(Function0 function0) {
        return Logging$class.debug(this, function0);
    }

    public void debug(Function0 function0, Function0 function02) {
        Logging$class.debug(this, function0, function02);
    }

    public void swallowDebug(Function0 function0) {
        Logging$class.swallowDebug(this, function0);
    }

    public void info(Function0 function0) {
        Logging$class.info(this, function0);
    }

    public Object info(Function0 function0) {
        return Logging$class.info(this, function0);
    }

    public void info(Function0 function0, Function0 function02) {
        Logging$class.info(this, function0, function02);
    }

    public void swallowInfo(Function0 function0) {
        Logging$class.swallowInfo(this, function0);
    }

    public void warn(Function0 function0) {
        Logging$class.warn(this, function0);
    }

    public Object warn(Function0 function0) {
        return Logging$class.warn(this, function0);
    }

    public void warn(Function0 function0, Function0 function02) {
        Logging$class.warn(this, function0, function02);
    }

    public void swallowWarn(Function0 function0) {
        Logging$class.swallowWarn(this, function0);
    }

    public void swallow(Function0 function0) {
        Logging$class.swallow(this, function0);
    }

    public void error(Function0 function0) {
        Logging$class.error(this, function0);
    }

    public Object error(Function0 function0) {
        return Logging$class.error(this, function0);
    }

    public void error(Function0 function0, Function0 function02) {
        Logging$class.error(this, function0, function02);
    }

    public void swallowError(Function0 function0) {
        Logging$class.swallowError(this, function0);
    }

    public void fatal(Function0 function0) {
        Logging$class.fatal(this, function0);
    }

    public Object fatal(Function0 function0) {
        return Logging$class.fatal(this, function0);
    }

    public void fatal(Function0 function0, Function0 function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public /* synthetic */ PartitionLeaderSelector handleStateChanges$default$3() {
        return this.noOpPartitionLeaderSelector();
    }

    public final ControllerContext kafka$controller$PartitionStateMachine$$controllerContext() {
        return this.kafka$controller$PartitionStateMachine$$controllerContext;
    }

    private int controllerId() {
        return this.controllerId;
    }

    public final ZkClient kafka$controller$PartitionStateMachine$$zkClient() {
        return this.kafka$controller$PartitionStateMachine$$zkClient;
    }

    public Map<TopicAndPartition, PartitionState> partitionState() {
        return this.partitionState;
    }

    public void partitionState_$eq(Map<TopicAndPartition, PartitionState> map) {
        this.partitionState = map;
    }

    public ControllerBrokerRequestBatch brokerRequestBatch() {
        return this.brokerRequestBatch;
    }

    public final AtomicBoolean kafka$controller$PartitionStateMachine$$hasStarted() {
        return this.kafka$controller$PartitionStateMachine$$hasStarted;
    }

    private NoOpLeaderSelector noOpPartitionLeaderSelector() {
        return this.noOpPartitionLeaderSelector;
    }

    private Logger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public void startup() {
        this.initializePartitionState();
        this.kafka$controller$PartitionStateMachine$$hasStarted().set(true);
        this.triggerOnlinePartitionStateChange();
        this.info((Function0<String>)new $anonfun$startup$1(this));
    }

    public void registerListeners() {
        this.registerTopicChangeListener();
    }

    public void shutdown() {
        this.kafka$controller$PartitionStateMachine$$hasStarted().set(false);
        this.partitionState().clear();
    }

    public void triggerOnlinePartitionStateChange() {
        try {
            this.brokerRequestBatch().newBatch();
            this.partitionState().foreach((Function1)new $anonfun$triggerOnlinePartitionStateChange$1(this));
            this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$PartitionStateMachine$$controller.epoch(), this.kafka$controller$PartitionStateMachine$$controllerContext().correlationId().getAndIncrement(), this.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokers());
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new $anonfun$triggerOnlinePartitionStateChange$2(this), (Function0<Throwable>)new $anonfun$triggerOnlinePartitionStateChange$3(this, throwable));
        }
    }

    public void handleStateChanges(Set<TopicAndPartition> set, PartitionState partitionState, PartitionLeaderSelector partitionLeaderSelector) {
        this.info((Function0<String>)new $anonfun$handleStateChanges$1(this, set, partitionState));
        try {
            this.brokerRequestBatch().newBatch();
            set.foreach((Function1)new $anonfun$handleStateChanges$2(this, partitionState, partitionLeaderSelector));
            this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$PartitionStateMachine$$controller.epoch(), this.kafka$controller$PartitionStateMachine$$controllerContext().correlationId().getAndIncrement(), this.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokers());
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new $anonfun$handleStateChanges$3(this, partitionState), (Function0<Throwable>)new $anonfun$handleStateChanges$4(this, throwable));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void kafka$controller$PartitionStateMachine$$handleStateChange(String string, int n, PartitionState partitionState, PartitionLeaderSelector partitionLeaderSelector) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(string, n);
        if (!this.kafka$controller$PartitionStateMachine$$hasStarted().get()) throw new StateChangeFailedException(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change for partition %s to %s failed because the partition state machine has not started").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, partitionState})));
        PartitionState partitionState2 = (PartitionState)this.partitionState().getOrElseUpdate((Object)topicAndPartition, (Function0)new $anonfun$3(this));
        try {
            PartitionState partitionState3 = partitionState;
            NewPartition$ newPartition$ = NewPartition$.MODULE$;
            PartitionState partitionState4 = partitionState3;
            if (!(newPartition$ != null ? !newPartition$.equals(partitionState4) : partitionState4 != null)) {
                this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NonExistentPartition$[]{NonExistentPartition$.MODULE$})), NewPartition$.MODULE$);
                this.assignReplicasToPartitions(string, n);
                this.partitionState().put((Object)topicAndPartition, (Object)NewPartition$.MODULE$);
                String string2 = ((TraversableOnce)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition)).mkString(",");
                this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from NotExists to New with assigned replicas %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, string2})));
                return;
            } else {
                OnlinePartition$ onlinePartition$ = OnlinePartition$.MODULE$;
                PartitionState partitionState5 = partitionState3;
                if (!(onlinePartition$ != null ? !onlinePartition$.equals(partitionState5) : partitionState5 != null)) {
                    this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewPartition$.MODULE$, OnlinePartition$.MODULE$, OfflinePartition$.MODULE$})), OnlinePartition$.MODULE$);
                    PartitionState partitionState6 = (PartitionState)this.partitionState().apply((Object)topicAndPartition);
                    NewPartition$ newPartition$2 = NewPartition$.MODULE$;
                    PartitionState partitionState7 = partitionState6;
                    if (!(newPartition$2 != null ? !newPartition$2.equals(partitionState7) : partitionState7 != null)) {
                        this.initializeLeaderAndIsrForPartition(topicAndPartition);
                    } else {
                        OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
                        PartitionState partitionState8 = partitionState6;
                        if (!(offlinePartition$ != null ? !offlinePartition$.equals(partitionState8) : partitionState8 != null)) {
                            this.electLeaderForPartition(string, n, partitionLeaderSelector);
                        } else {
                            OnlinePartition$ onlinePartition$2 = OnlinePartition$.MODULE$;
                            PartitionState partitionState9 = partitionState6;
                            if (!(onlinePartition$2 != null ? !onlinePartition$2.equals(partitionState9) : partitionState9 != null)) {
                                this.electLeaderForPartition(string, n, partitionLeaderSelector);
                            }
                        }
                    }
                    this.partitionState().put((Object)topicAndPartition, (Object)OnlinePartition$.MODULE$);
                    int n2 = ((LeaderIsrAndControllerEpoch)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().apply((Object)topicAndPartition)).leaderAndIsr().leader();
                    this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s from %s to OnlinePartition with leader %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, this.partitionState().apply((Object)topicAndPartition), BoxesRunTime.boxToInteger((int)n2)})));
                    return;
                } else {
                    OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
                    PartitionState partitionState10 = partitionState3;
                    if (!(offlinePartition$ != null ? !offlinePartition$.equals(partitionState10) : partitionState10 != null)) {
                        this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewPartition$.MODULE$, OnlinePartition$.MODULE$})), OfflinePartition$.MODULE$);
                        this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from Online to Offline").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition})));
                        this.partitionState().put((Object)topicAndPartition, (Object)OfflinePartition$.MODULE$);
                        return;
                    } else {
                        NonExistentPartition$ nonExistentPartition$ = NonExistentPartition$.MODULE$;
                        PartitionState partitionState11 = partitionState3;
                        if (nonExistentPartition$ != null ? !nonExistentPartition$.equals(partitionState11) : partitionState11 != null) throw new MatchError((Object)partitionState3);
                        this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OfflinePartition$[]{OfflinePartition$.MODULE$})), NonExistentPartition$.MODULE$);
                        this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from Offline to NotExists").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition})));
                        this.partitionState().put((Object)topicAndPartition, (Object)NonExistentPartition$.MODULE$);
                    }
                }
            }
            return;
        }
        catch (Throwable throwable) {
            this.stateChangeLogger().error((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change for partition %s from %s to %s failed").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, partitionState2, partitionState})), throwable);
        }
    }

    private void initializePartitionState() {
        this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().foreach((Function1)new $anonfun$initializePartitionState$1(this));
    }

    private void assertValidPreviousStates(TopicAndPartition topicAndPartition, Seq<PartitionState> seq, PartitionState partitionState) {
        if (seq.contains(this.partitionState().apply((Object)topicAndPartition))) {
            return;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Partition %s should be in the %s states before moving to %s state").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, seq.mkString(","), partitionState}))).append((Object)Predef$.MODULE$.augmentString(". Instead it is in %s state").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionState().apply((Object)topicAndPartition)}))).toString());
    }

    private void assignReplicasToPartitions(String string, int n) {
        Seq<Integer> seq = ZkUtils$.MODULE$.getReplicasForPartition(this.kafka$controller$PartitionStateMachine$$controllerContext().zkClient(), string, n);
        this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().$plus$eq(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(string, n)).$minus$greater(seq));
    }

    private void initializeLeaderAndIsrForPartition(TopicAndPartition topicAndPartition) {
        Seq seq = (Seq)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
        Seq seq2 = (Seq)seq.filter((Function1)new $anonfun$1(this));
        int n = seq2.size();
        if (n == 0) {
            String string = Predef$.MODULE$.augmentString("encountered error during state change of partition %s from New to Online, assigned replicas are [%s], live brokers are [%s]. No assigned replica is alive.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, seq.mkString(","), this.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds()}));
            this.stateChangeLogger().error((Object)new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)string).toString());
            throw new StateChangeFailedException(string);
        }
        this.debug((Function0<String>)new $anonfun$initializeLeaderAndIsrForPartition$1(this, topicAndPartition, seq2));
        int n2 = BoxesRunTime.unboxToInt((Object)seq2.head());
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(new LeaderAndIsr(n2, (List<Integer>)seq2.toList()), this.kafka$controller$PartitionStateMachine$$controller.epoch());
        this.debug((Function0<String>)new $anonfun$initializeLeaderAndIsrForPartition$2(this, topicAndPartition, leaderIsrAndControllerEpoch));
        try {
            ZkUtils$.MODULE$.createPersistentPath(this.kafka$controller$PartitionStateMachine$$controllerContext().zkClient(), ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topicAndPartition.topic(), topicAndPartition.partition()), ZkUtils$.MODULE$.leaderAndIsrZkData(leaderIsrAndControllerEpoch.leaderAndIsr(), this.kafka$controller$PartitionStateMachine$$controller.epoch()));
            this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().put((Object)topicAndPartition, (Object)leaderIsrAndControllerEpoch);
            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Integer>)seq2, topicAndPartition.topic(), topicAndPartition.partition(), leaderIsrAndControllerEpoch, (Seq<Integer>)seq);
            return;
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch2 = (LeaderIsrAndControllerEpoch)ZkUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$PartitionStateMachine$$zkClient(), topicAndPartition.topic(), topicAndPartition.partition()).get();
            String string = Predef$.MODULE$.augmentString("encountered error while changing partition %s's state from New to Online since LeaderAndIsr path already exists with value %s and controller epoch %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, leaderIsrAndControllerEpoch2.leaderAndIsr().toString(), BoxesRunTime.boxToInteger((int)leaderIsrAndControllerEpoch2.controllerEpoch())}));
            this.stateChangeLogger().error((Object)new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)string).toString());
            throw new StateChangeFailedException(string);
        }
    }

    public void electLeaderForPartition(String string, int n, PartitionLeaderSelector partitionLeaderSelector) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(string, n);
        this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d started leader election for partition %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition})));
        try {
            Seq seq;
            LeaderAndIsr leaderAndIsr;
            block6: {
                Tuple2<LeaderAndIsr, Seq<Integer>> tuple2;
                block7: {
                    Tuple2<Boolean, Integer> tuple22;
                    boolean bl = false;
                    leaderAndIsr = null;
                    seq = (Seq)Seq$.MODULE$.empty();
                    while (true) {
                        if (bl) break block6;
                        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = this.getLeaderIsrAndEpochOrThrowException(string, n);
                        LeaderAndIsr leaderAndIsr2 = leaderIsrAndControllerEpoch.leaderAndIsr();
                        int n2 = leaderIsrAndControllerEpoch.controllerEpoch();
                        if (n2 > this.kafka$controller$PartitionStateMachine$$controller.epoch()) {
                            String string2 = Predef$.MODULE$.augmentString("aborted leader election for partition [%s,%d] since the LeaderAndIsr path was already written by another controller. This probably means that the current controller %d went through a soft failure and another controller was elected with epoch %d.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)n2)}));
                            this.stateChangeLogger().error((Object)new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)string2).toString());
                            throw new StateChangeFailedException(string2);
                        }
                        tuple2 = partitionLeaderSelector.selectLeader(topicAndPartition, leaderAndIsr2);
                        if (tuple2 == null) break block7;
                        Tuple2 tuple23 = new Tuple2(tuple2._1(), tuple2._2());
                        LeaderAndIsr leaderAndIsr3 = (LeaderAndIsr)tuple23._1();
                        Seq seq2 = (Seq)tuple23._2();
                        tuple22 = ZkUtils$.MODULE$.conditionalUpdatePersistentPath(this.kafka$controller$PartitionStateMachine$$zkClient(), ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(string, n), ZkUtils$.MODULE$.leaderAndIsrZkData(leaderAndIsr3, this.kafka$controller$PartitionStateMachine$$controller.epoch()), leaderAndIsr2.zkVersion());
                        if (tuple22 == null) break;
                        Tuple2 tuple24 = new Tuple2(tuple22._1(), tuple22._2());
                        boolean bl2 = BoxesRunTime.unboxToBoolean((Object)tuple24._1());
                        int n3 = tuple24._2$mcI$sp();
                        leaderAndIsr = leaderAndIsr3;
                        leaderAndIsr.zkVersion_$eq(n3);
                        bl = bl2;
                        seq = seq2;
                    }
                    throw new MatchError(tuple22);
                }
                throw new MatchError(tuple2);
            }
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.kafka$controller$PartitionStateMachine$$controller.epoch());
            this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().put((Object)new TopicAndPartition(string, n), (Object)leaderIsrAndControllerEpoch);
            this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d elected leader %d for Offline partition %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)leaderAndIsr.leader()), topicAndPartition})));
            Seq seq3 = (Seq)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)new TopicAndPartition(string, n));
            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Integer>)seq, string, n, leaderIsrAndControllerEpoch, (Seq<Integer>)seq3);
        }
        catch (Throwable throwable) {
            String string3 = Predef$.MODULE$.augmentString("encountered error while electing leader for partition %s due to: %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, throwable.getMessage()}));
            this.stateChangeLogger().error((Object)new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)string3).toString());
            throw new StateChangeFailedException(string3, throwable);
        }
        catch (NoReplicaOnlineException noReplicaOnlineException) {
            throw noReplicaOnlineException;
        }
        catch (LeaderElectionNotNeededException leaderElectionNotNeededException) {
            // empty catch block
        }
        this.debug((Function0<String>)new $anonfun$electLeaderForPartition$1(this));
    }

    private java.util.List<String> registerTopicChangeListener() {
        return this.kafka$controller$PartitionStateMachine$$zkClient().subscribeChildChanges(ZkUtils$.MODULE$.BrokerTopicsPath(), (IZkChildListener)new TopicChangeListener());
    }

    public java.util.List<String> registerPartitionChangeListener(String string) {
        return this.kafka$controller$PartitionStateMachine$$zkClient().subscribeChildChanges(ZkUtils$.MODULE$.getTopicPath(string), (IZkChildListener)new PartitionChangeListener(string));
    }

    private LeaderIsrAndControllerEpoch getLeaderIsrAndEpochOrThrowException(String string, int n) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(string, n);
        Option<LeaderIsrAndControllerEpoch> option = ZkUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$PartitionStateMachine$$zkClient(), string, n);
        if (option instanceof Some) {
            return (LeaderIsrAndControllerEpoch)((Some)option).x();
        }
        None$ none$ = None$.MODULE$;
        Option<LeaderIsrAndControllerEpoch> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            String string2 = Predef$.MODULE$.augmentString("LeaderAndIsr information doesn't exist for partition %s in %s state").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, this.partitionState().apply((Object)topicAndPartition)}));
            throw new StateChangeFailedException(string2);
        }
        throw new MatchError(option);
    }

    public PartitionStateMachine(KafkaController kafkaController) {
        this.kafka$controller$PartitionStateMachine$$controller = kafkaController;
        Logging$class.$init$(this);
        this.kafka$controller$PartitionStateMachine$$controllerContext = kafkaController.controllerContext();
        this.controllerId = kafkaController.config().brokerId();
        this.kafka$controller$PartitionStateMachine$$zkClient = this.kafka$controller$PartitionStateMachine$$controllerContext().zkClient();
        this.partitionState = Map$.MODULE$.empty();
        this.brokerRequestBatch = new ControllerBrokerRequestBatch(kafkaController.controllerContext(), (Function3<Integer, RequestOrResponse, Function1<RequestOrResponse, Object>, Object>)new $anonfun$2(this), this.controllerId(), kafkaController.clientId());
        this.kafka$controller$PartitionStateMachine$$hasStarted = new AtomicBoolean(false);
        this.noOpPartitionLeaderSelector = new NoOpLeaderSelector(this.kafka$controller$PartitionStateMachine$$controllerContext());
        this.logIdent_$eq(new StringBuilder().append((Object)"[Partition state machine on Controller ").append((Object)BoxesRunTime.boxToInteger((int)this.controllerId())).append((Object)"]: ").toString());
        this.stateChangeLogger = Logger.getLogger((String)KafkaController$.MODULE$.stateChangeLogger());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class TopicChangeListener
    implements IZkChildListener,
    Logging,
    ScalaObject {
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        public volatile int bitmap$0;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Logger logger() {
            if ((this.bitmap$0 & 1) != 0) return this.logger;
            TopicChangeListener topicChangeListener = this;
            synchronized (topicChangeListener) {
                if ((this.bitmap$0 & 1) == 0) {
                    this.logger = Logging$class.logger(this);
                    this.bitmap$0 |= 1;
                }
                return this.logger;
            }
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String string) {
            this.logIdent = string;
        }

        @Override
        public final Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
            this.loggerName = string;
        }

        @Override
        public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
            this.kafka$utils$Logging$$log4jController = log4jController$;
        }

        public void trace(Function0 function0) {
            Logging$class.trace(this, function0);
        }

        public Object trace(Function0 function0) {
            return Logging$class.trace(this, function0);
        }

        public void trace(Function0 function0, Function0 function02) {
            Logging$class.trace(this, function0, function02);
        }

        public void swallowTrace(Function0 function0) {
            Logging$class.swallowTrace(this, function0);
        }

        public void debug(Function0 function0) {
            Logging$class.debug(this, function0);
        }

        public Object debug(Function0 function0) {
            return Logging$class.debug(this, function0);
        }

        public void debug(Function0 function0, Function0 function02) {
            Logging$class.debug(this, function0, function02);
        }

        public void swallowDebug(Function0 function0) {
            Logging$class.swallowDebug(this, function0);
        }

        public void info(Function0 function0) {
            Logging$class.info(this, function0);
        }

        public Object info(Function0 function0) {
            return Logging$class.info(this, function0);
        }

        public void info(Function0 function0, Function0 function02) {
            Logging$class.info(this, function0, function02);
        }

        public void swallowInfo(Function0 function0) {
            Logging$class.swallowInfo(this, function0);
        }

        public void warn(Function0 function0) {
            Logging$class.warn(this, function0);
        }

        public Object warn(Function0 function0) {
            return Logging$class.warn(this, function0);
        }

        public void warn(Function0 function0, Function0 function02) {
            Logging$class.warn(this, function0, function02);
        }

        public void swallowWarn(Function0 function0) {
            Logging$class.swallowWarn(this, function0);
        }

        public void swallow(Function0 function0) {
            Logging$class.swallow(this, function0);
        }

        public void error(Function0 function0) {
            Logging$class.error(this, function0);
        }

        public Object error(Function0 function0) {
            return Logging$class.error(this, function0);
        }

        public void error(Function0 function0, Function0 function02) {
            Logging$class.error(this, function0, function02);
        }

        public void swallowError(Function0 function0) {
            Logging$class.swallowError(this, function0);
        }

        public void fatal(Function0 function0) {
            Logging$class.fatal(this, function0);
        }

        public Object fatal(Function0 function0) {
            return Logging$class.fatal(this, function0);
        }

        public void fatal(Function0 function0, Function0 function02) {
            Logging$class.fatal(this, function0, function02);
        }

        public void handleChildChange(String string, java.util.List<String> list) throws Exception {
            Object object = this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock();
            synchronized (object) {
                BoxedUnit boxedUnit;
                if (this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$hasStarted().get()) {
                    this.liftedTree1$1(string, list);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
        }

        public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer() {
            return PartitionStateMachine.this;
        }

        private final void liftedTree1$1(String string, java.util.List list) {
            try {
                this.debug((Function0<String>)new TopicChangeListener$$anonfun$liftedTree1$1$1(this, string, list));
                scala.collection.immutable.Set set = JavaConversions$.MODULE$.asBuffer(list).toSet();
                scala.collection.immutable.Set set2 = (scala.collection.immutable.Set)set.$minus$minus(this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics());
                scala.collection.immutable.Set set3 = (scala.collection.immutable.Set)this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics().$minus$minus((TraversableOnce)set);
                this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics_$eq((scala.collection.immutable.Set<String>)set);
                Map<TopicAndPartition, Seq<Integer>> map = ZkUtils$.MODULE$.getReplicaAssignmentForTopics(this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$zkClient(), (Seq<String>)set2.toSeq());
                this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment_$eq((Map<TopicAndPartition, Seq<Integer>>)((Map)this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().filter((Function1)new TopicChangeListener$$anonfun$liftedTree1$1$2(this, set3))));
                this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().$plus$plus$eq(map);
                this.info((Function0<String>)new TopicChangeListener$$anonfun$liftedTree1$1$3(this, set2, set3, map));
                if (set2.size() > 0) {
                    this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controller.onNewTopicCreation((scala.collection.immutable.Set<String>)set2, (scala.collection.immutable.Set<TopicAndPartition>)map.keySet().toSet());
                }
            }
            catch (Throwable throwable) {
                this.error((Function0<String>)new TopicChangeListener$$anonfun$liftedTree1$1$4(this), (Function0<Throwable>)new TopicChangeListener$$anonfun$liftedTree1$1$5(this, throwable));
            }
        }

        public TopicChangeListener() {
            if (PartitionStateMachine.this == null) {
                throw new NullPointerException();
            }
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[TopicChangeListener on Controller ").append((Object)BoxesRunTime.boxToInteger((int)PartitionStateMachine.this.kafka$controller$PartitionStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class PartitionChangeListener
    implements IZkChildListener,
    Logging,
    ScalaObject {
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        public volatile int bitmap$0;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Logger logger() {
            if ((this.bitmap$0 & 1) != 0) return this.logger;
            PartitionChangeListener partitionChangeListener = this;
            synchronized (partitionChangeListener) {
                if ((this.bitmap$0 & 1) == 0) {
                    this.logger = Logging$class.logger(this);
                    this.bitmap$0 |= 1;
                }
                return this.logger;
            }
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String string) {
            this.logIdent = string;
        }

        @Override
        public final Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
            this.loggerName = string;
        }

        @Override
        public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
            this.kafka$utils$Logging$$log4jController = log4jController$;
        }

        public void trace(Function0 function0) {
            Logging$class.trace(this, function0);
        }

        public Object trace(Function0 function0) {
            return Logging$class.trace(this, function0);
        }

        public void trace(Function0 function0, Function0 function02) {
            Logging$class.trace(this, function0, function02);
        }

        public void swallowTrace(Function0 function0) {
            Logging$class.swallowTrace(this, function0);
        }

        public void debug(Function0 function0) {
            Logging$class.debug(this, function0);
        }

        public Object debug(Function0 function0) {
            return Logging$class.debug(this, function0);
        }

        public void debug(Function0 function0, Function0 function02) {
            Logging$class.debug(this, function0, function02);
        }

        public void swallowDebug(Function0 function0) {
            Logging$class.swallowDebug(this, function0);
        }

        public void info(Function0 function0) {
            Logging$class.info(this, function0);
        }

        public Object info(Function0 function0) {
            return Logging$class.info(this, function0);
        }

        public void info(Function0 function0, Function0 function02) {
            Logging$class.info(this, function0, function02);
        }

        public void swallowInfo(Function0 function0) {
            Logging$class.swallowInfo(this, function0);
        }

        public void warn(Function0 function0) {
            Logging$class.warn(this, function0);
        }

        public Object warn(Function0 function0) {
            return Logging$class.warn(this, function0);
        }

        public void warn(Function0 function0, Function0 function02) {
            Logging$class.warn(this, function0, function02);
        }

        public void swallowWarn(Function0 function0) {
            Logging$class.swallowWarn(this, function0);
        }

        public void swallow(Function0 function0) {
            Logging$class.swallow(this, function0);
        }

        public void error(Function0 function0) {
            Logging$class.error(this, function0);
        }

        public Object error(Function0 function0) {
            return Logging$class.error(this, function0);
        }

        public void error(Function0 function0, Function0 function02) {
            Logging$class.error(this, function0, function02);
        }

        public void swallowError(Function0 function0) {
            Logging$class.swallowError(this, function0);
        }

        public void fatal(Function0 function0) {
            Logging$class.fatal(this, function0);
        }

        public Object fatal(Function0 function0) {
            return Logging$class.fatal(this, function0);
        }

        public void fatal(Function0 function0, Function0 function02) {
            Logging$class.fatal(this, function0, function02);
        }

        public void handleChildChange(String string, java.util.List<String> list) throws Exception {
            Object object = this.kafka$controller$PartitionStateMachine$PartitionChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock();
            synchronized (object) {
                return;
            }
        }

        public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$PartitionChangeListener$$$outer() {
            return PartitionStateMachine.this;
        }

        public PartitionChangeListener(String string) {
            if (PartitionStateMachine.this == null) {
                throw new NullPointerException();
            }
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[Controller ").append((Object)BoxesRunTime.boxToInteger((int)PartitionStateMachine.this.kafka$controller$PartitionStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
        }
    }
}

