/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.api.LeaderAndIsr;
import kafka.common.LeaderElectionNotNeededException;
import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.PartitionLeaderSelector;
import kafka.controller.PreferredReplicaPartitionLeaderSelector$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001=3\u0001\"\u0001\u0002\u0005\u0002\u0003\u0005\ta\u0002\u0002(!J,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u00148+\u001a7fGR|'O\u0003\u0002\u0004\t\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0003\u0001\u0011A!\"\u0004\u0005\u0002\n\u001d5\t!B\u0003\u0002\f\u0019\u0005!A.\u00198h\u0015\u0005i\u0011\u0001\u00026bm\u0006L!a\u0004\u0006\u0003\r=\u0013'.Z2u!\t\t\"#D\u0001\u0003\u0013\t\u0019\"AA\fQCJ$\u0018\u000e^5p]2+\u0017\rZ3s'\u0016dWm\u0019;peB\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003B\u0001\u0006kRLGn]\u0005\u00033Y\u0011q\u0001T8hO&tw\r\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBDA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000f\u0005\u0002\u0012G%\u0011AE\u0001\u0002\u0012\u0007>tGO]8mY\u0016\u00148i\u001c8uKb$\b\"\u0002\u0014\u0001\t\u00039\u0013A\u0002\u001fj]&$h\b\u0006\u0002)SA\u0011\u0011\u0003\u0001\u0005\u0006C\u0015\u0002\rA\t\u0005\u0006W\u0001!\t\u0001L\u0001\rg\u0016dWm\u0019;MK\u0006$WM\u001d\u000b\u0004[\u0015k\u0005\u0003B\u000e/aYJ!a\f\u000f\u0003\rQ+\b\u000f\\33!\t\tD'D\u00013\u0015\t\u0019D!A\u0002ba&L!!\u000e\u001a\u0003\u00191+\u0017\rZ3s\u0003:$\u0017j\u001d:\u0011\u0007]z$I\u0004\u00029{9\u0011\u0011\bP\u0007\u0002u)\u00111HB\u0001\u0007yI|w\u000e\u001e \n\u0003uI!A\u0010\u000f\u0002\u000fA\f7m[1hK&\u0011\u0001)\u0011\u0002\u0004'\u0016\f(B\u0001 \u001d!\tY2)\u0003\u0002E9\t\u0019\u0011J\u001c;\t\u000b\u0019S\u0003\u0019A$\u0002#Q|\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002I\u00176\t\u0011J\u0003\u0002K\t\u000511m\\7n_:L!\u0001T%\u0003#Q{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000eC\u0003OU\u0001\u0007\u0001'A\ndkJ\u0014XM\u001c;MK\u0006$WM]!oI&\u001b(\u000f")
public class PreferredReplicaPartitionLeaderSelector
implements PartitionLeaderSelector,
Logging,
ScalaObject {
    private final ControllerContext controllerContext;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        PreferredReplicaPartitionLeaderSelector preferredReplicaPartitionLeaderSelector = this;
        synchronized (preferredReplicaPartitionLeaderSelector) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 function0) {
        Logging$class.trace(this, function0);
    }

    public Object trace(Function0 function0) {
        return Logging$class.trace(this, function0);
    }

    public void trace(Function0 function0, Function0 function02) {
        Logging$class.trace(this, function0, function02);
    }

    public void swallowTrace(Function0 function0) {
        Logging$class.swallowTrace(this, function0);
    }

    public void debug(Function0 function0) {
        Logging$class.debug(this, function0);
    }

    public Object debug(Function0 function0) {
        return Logging$class.debug(this, function0);
    }

    public void debug(Function0 function0, Function0 function02) {
        Logging$class.debug(this, function0, function02);
    }

    public void swallowDebug(Function0 function0) {
        Logging$class.swallowDebug(this, function0);
    }

    public void info(Function0 function0) {
        Logging$class.info(this, function0);
    }

    public Object info(Function0 function0) {
        return Logging$class.info(this, function0);
    }

    public void info(Function0 function0, Function0 function02) {
        Logging$class.info(this, function0, function02);
    }

    public void swallowInfo(Function0 function0) {
        Logging$class.swallowInfo(this, function0);
    }

    public void warn(Function0 function0) {
        Logging$class.warn(this, function0);
    }

    public Object warn(Function0 function0) {
        return Logging$class.warn(this, function0);
    }

    public void warn(Function0 function0, Function0 function02) {
        Logging$class.warn(this, function0, function02);
    }

    public void swallowWarn(Function0 function0) {
        Logging$class.swallowWarn(this, function0);
    }

    public void swallow(Function0 function0) {
        Logging$class.swallow(this, function0);
    }

    public void error(Function0 function0) {
        Logging$class.error(this, function0);
    }

    public Object error(Function0 function0) {
        return Logging$class.error(this, function0);
    }

    public void error(Function0 function0, Function0 function02) {
        Logging$class.error(this, function0, function02);
    }

    public void swallowError(Function0 function0) {
        Logging$class.swallowError(this, function0);
    }

    public void fatal(Function0 function0) {
        Logging$class.fatal(this, function0);
    }

    public Object fatal(Function0 function0) {
        return Logging$class.fatal(this, function0);
    }

    public void fatal(Function0 function0, Function0 function02) {
        Logging$class.fatal(this, function0, function02);
    }

    @Override
    public Tuple2<LeaderAndIsr, Seq<Integer>> selectLeader(TopicAndPartition topicAndPartition, LeaderAndIsr leaderAndIsr) {
        Seq seq = (Seq)this.controllerContext.partitionReplicaAssignment().apply((Object)topicAndPartition);
        int n = BoxesRunTime.unboxToInt((Object)seq.head());
        int n2 = ((LeaderIsrAndControllerEpoch)this.controllerContext.partitionLeadershipInfo().apply((Object)topicAndPartition)).leaderAndIsr().leader();
        if (n2 == n) {
            throw new LeaderElectionNotNeededException(Predef$.MODULE$.augmentString("Preferred replica %d is already the current leader for partition %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n), topicAndPartition})));
        }
        this.info((Function0<String>)new $anonfun$selectLeader$2(this, topicAndPartition, n2));
        if (this.controllerContext.liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)n)) && leaderAndIsr.isr().contains((Object)BoxesRunTime.boxToInteger((int)n))) {
            return new Tuple2((Object)new LeaderAndIsr(n, leaderAndIsr.leaderEpoch() + 1, leaderAndIsr.isr(), leaderAndIsr.zkVersion() + 1), (Object)seq);
        }
        throw new StateChangeFailedException(new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Preferred replica %d for partition ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)}))).append((Object)Predef$.MODULE$.augmentString("%s is either not alive or not in the isr. Current leader and ISR: [%s]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, leaderAndIsr}))).toString());
    }

    public PreferredReplicaPartitionLeaderSelector(ControllerContext controllerContext) {
        this.controllerContext = controllerContext;
        Logging$class.$init$(this);
        this.logIdent_$eq("[PreferredReplicaPartitionLeaderSelector]: ");
    }
}

