/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.RequestOrResponse;
import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.ControllerStats$;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewReplica$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine$;
import kafka.controller.ReplicaStateMachine$BrokerChangeListener$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple3;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.List$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003'I+\u0007\u000f\\5dCN#\u0018\r^3NC\u000eD\u0017N\\3\u000b\u0005\r!\u0011AC2p]R\u0014x\u000e\u001c7fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001A\u0001C\u0006\t\u0003\u00139i\u0011A\u0003\u0006\u0003\u00171\tA\u0001\\1oO*\tQ\"\u0001\u0003kCZ\f\u0017BA\b\u000b\u0005\u0019y%M[3diB\u0011\u0011\u0003F\u0007\u0002%)\u00111\u0003B\u0001\u0006kRLGn]\u0005\u0003+I\u0011q\u0001T8hO&tw\r\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002DA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002C\u0002\u0001\u0005\u0003\u0005\u000b\u0011B\u000f\u0011\u0005yyR\"\u0001\u0002\n\u0005\u0001\u0012!aD&bM.\f7i\u001c8ue>dG.\u001a:\t\u000b\t\u0002A\u0011A\u0012\u0002\rqJg.\u001b;?)\t!S\u0005\u0005\u0002\u001f\u0001!)1!\ta\u0001;!9q\u0005\u0001b\u0001\n\u0013A\u0013!E2p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yiV\t\u0011\u0006\u0005\u0002\u001fU%\u00111F\u0001\u0002\u0012\u0007>tGO]8mY\u0016\u00148i\u001c8uKb$\bBB\u0017\u0001A\u0003%\u0011&\u0001\nd_:$(o\u001c7mKJ\u001cuN\u001c;fqR\u0004\u0003bB\u0018\u0001\u0005\u0004%I\u0001M\u0001\rG>tGO]8mY\u0016\u0014\u0018\nZ\u000b\u0002cA\u0011qCM\u0005\u0003ga\u00111!\u00138u\u0011\u0019)\u0004\u0001)A\u0005c\u0005i1m\u001c8ue>dG.\u001a:JI\u0002Bqa\u000e\u0001C\u0002\u0013%\u0001(\u0001\u0005{W\u000ec\u0017.\u001a8u+\u0005I\u0004C\u0001\u001eB\u001b\u0005Y$B\u0001\u001f>\u0003!Q8n\u00197jK:$(B\u0001 @\u0003\u0019I\u0005'\u0013;fG*\t\u0001)A\u0002pe\u001eL!AQ\u001e\u0003\u0011i[7\t\\5f]RDa\u0001\u0012\u0001!\u0002\u0013I\u0014!\u0003>l\u00072LWM\u001c;!\u0011\u001d1\u0005\u00011A\u0005\u0002\u001d\u000bAB]3qY&\u001c\u0017m\u0015;bi\u0016,\u0012\u0001\u0013\t\u0005\u0013:\u0003&,D\u0001K\u0015\tYE*A\u0004nkR\f'\r\\3\u000b\u00055C\u0012AC2pY2,7\r^5p]&\u0011qJ\u0013\u0002\u0004\u001b\u0006\u0004\b#B\fR'F\n\u0014B\u0001*\u0019\u0005\u0019!V\u000f\u001d7fgA\u0011Ak\u0016\b\u0003/UK!A\u0016\r\u0002\rA\u0013X\rZ3g\u0013\tA\u0016L\u0001\u0004TiJLgn\u001a\u0006\u0003-b\u0001\"AH.\n\u0005q\u0013!\u0001\u0004*fa2L7-Y*uCR,\u0007b\u00020\u0001\u0001\u0004%\taX\u0001\u0011e\u0016\u0004H.[2b'R\fG/Z0%KF$\"\u0001Y2\u0011\u0005]\t\u0017B\u00012\u0019\u0005\u0011)f.\u001b;\t\u000f\u0011l\u0016\u0011!a\u0001\u0011\u0006\u0019\u0001\u0010J\u0019\t\r\u0019\u0004\u0001\u0015)\u0003I\u00035\u0011X\r\u001d7jG\u0006\u001cF/\u0019;fA!9\u0001\u000e\u0001b\u0001\n\u0003I\u0017A\u00052s_.,'OU3rk\u0016\u001cHOQ1uG\",\u0012A\u001b\t\u0003=-L!\u0001\u001c\u0002\u00039\r{g\u000e\u001e:pY2,'O\u0011:pW\u0016\u0014(+Z9vKN$()\u0019;dQ\"1a\u000e\u0001Q\u0001\n)\f1C\u0019:pW\u0016\u0014(+Z9vKN$()\u0019;dQ\u0002Bq\u0001\u001d\u0001C\u0002\u0013%\u0011/\u0001\u0006iCN\u001cF/\u0019:uK\u0012,\u0012A\u001d\t\u0003gjl\u0011\u0001\u001e\u0006\u0003kZ\fa!\u0019;p[&\u001c'BA<y\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003s2\tA!\u001e;jY&\u00111\u0010\u001e\u0002\u000e\u0003R|W.[2C_>dW-\u00198\t\ru\u0004\u0001\u0015!\u0003s\u0003-A\u0017m]*uCJ$X\r\u001a\u0011\t\u0011}\u0004!\u0019!C\u0005\u0003\u0003\t\u0011c\u001d;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005=QBAA\u0004\u0015\u0011\tI!a\u0003\u0002\u000b1|w\r\u000e6\u000b\u0007\u00055q(\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003#\t9A\u0001\u0004M_\u001e<WM\u001d\u0005\t\u0003+\u0001\u0001\u0015!\u0003\u0002\u0004\u0005\u00112\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:!\u0011\u001d\tI\u0002\u0001C\u0001\u00037\tqa\u001d;beR,\b\u000fF\u0001a\u0011\u001d\ty\u0002\u0001C\u0001\u00037\t\u0011C]3hSN$XM\u001d'jgR,g.\u001a:t\u0011\u001d\t\u0019\u0003\u0001C\u0001\u00037\t\u0001b\u001d5vi\u0012|wO\u001c\u0005\b\u0003O\u0001A\u0011AA\u0015\u0003IA\u0017M\u001c3mKN#\u0018\r^3DQ\u0006tw-Z:\u0015\u000b\u0001\fY#!\u0010\t\u0011\u00055\u0012Q\u0005a\u0001\u0003_\t\u0001B]3qY&\u001c\u0017m\u001d\t\u0007\u0003c\t\u0019$a\u000e\u000e\u00031K1!!\u000eM\u0005\r\u0019V\r\u001e\t\u0004=\u0005e\u0012bAA\u001e\u0005\t\u0019\u0002+\u0019:uSRLwN\\!oIJ+\u0007\u000f\\5dC\"9\u0011qHA\u0013\u0001\u0004Q\u0016a\u0003;be\u001e,Go\u0015;bi\u0016Dq!a\u0011\u0001\t\u0003\t)%A\tiC:$G.Z*uCR,7\t[1oO\u0016$\u0012\u0002YA$\u0003\u0017\ny%a\u0015\t\u000f\u0005%\u0013\u0011\ta\u0001'\u0006)Ao\u001c9jG\"9\u0011QJA!\u0001\u0004\t\u0014!\u00039beRLG/[8o\u0011\u001d\t\t&!\u0011A\u0002E\n\u0011B]3qY&\u001c\u0017-\u00133\t\u000f\u0005}\u0012\u0011\ta\u00015\"9\u0011q\u000b\u0001\u0005\n\u0005e\u0013!G1tg\u0016\u0014HOV1mS\u0012\u0004&/\u001a<j_V\u001c8\u000b^1uKN$2\u0002YA.\u0003;\ny&!\u0019\u0002l!9\u0011\u0011JA+\u0001\u0004\u0019\u0006bBA'\u0003+\u0002\r!\r\u0005\b\u0003#\n)\u00061\u00012\u0011!\t\u0019'!\u0016A\u0002\u0005\u0015\u0014A\u00034s_6\u001cF/\u0019;fgB)\u0011\u0011GA45&\u0019\u0011\u0011\u000e'\u0003\u0007M+\u0017\u000fC\u0004\u0002@\u0005U\u0003\u0019\u0001.\t\u000f\u0005=\u0004\u0001\"\u0003\u0002r\u0005a\"/Z4jgR,'O\u0011:pW\u0016\u00148\t[1oO\u0016d\u0015n\u001d;f]\u0016\u0014HCAA:!\u0019\t)(a\u001e\u0002|5\t\u00010C\u0002\u0002za\u0014A\u0001T5tiB\u0019\u0011\"! \n\u0005aS\u0001bBAA\u0001\u0011%\u00111D\u0001\u0017S:LG/[1mSj,'+\u001a9mS\u000e\f7\u000b^1uK\"9\u0011Q\u0011\u0001\u0005\n\u0005\u001d\u0015AF4fi\u0006cGNU3qY&\u001c\u0017m](o\u0005J|7.\u001a:\u0015\r\u0005=\u0012\u0011RAH\u0011!\tY)a!A\u0002\u00055\u0015A\u0002;pa&\u001c7\u000fE\u0003\u00022\u0005\u001d4\u000b\u0003\u0005\u0002\u0012\u0006\r\u0005\u0019AAJ\u0003%\u0011'o\\6fe&#7\u000fE\u0003\u00022\u0005\u001d\u0014\u0007C\u0004\u0002\u0018\u0002!\t!!'\u0002;\u001d,G\u000fU1si&$\u0018n\u001c8t\u0003N\u001c\u0018n\u001a8fIR{'I]8lKJ$b!a'\u0002*\u0006-\u0006CBA\u0019\u0003O\ni\n\u0005\u0003\u0002 \u0006\u0015VBAAQ\u0015\r\t\u0019\u000bB\u0001\u0007G>lWn\u001c8\n\t\u0005\u001d\u0016\u0011\u0015\u0002\u0012)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007\u0002CAF\u0003+\u0003\r!!$\t\u000f\u00055\u0016Q\u0013a\u0001c\u0005A!M]8lKJLEM\u0002\u0006\u00022\u0002!\t\u0011!A\u0001\u0003g\u0013AC\u0011:pW\u0016\u00148\t[1oO\u0016d\u0015n\u001d;f]\u0016\u00148cBAX\u0011\u0005U\u0006C\u0006\t\u0004u\u0005]\u0016bAA]w\t\u0001\u0012JW6DQ&dG\rT5ti\u0016tWM\u001d\u0005\bE\u0005=F\u0011AA_)\t\ty\f\u0005\u0003\u0002B\u0006=V\"\u0001\u0001\t\u0011\u0005\u0015\u0017q\u0016C\u0001\u0003\u000f\f\u0011\u0003[1oI2,7\t[5mI\u000eC\u0017M\\4f)\u0015\u0001\u0017\u0011ZAg\u0011\u001d\tY-a1A\u0002M\u000b!\u0002]1sK:$\b+\u0019;i\u0011!\ty-a1A\u0002\u0005E\u0017!E2veJ,g\u000e\u001e\"s_.,'\u000fT5tiB)\u0011QOA<'\u0002")
public class ReplicaStateMachine
implements Logging,
ScalaObject {
    public final KafkaController kafka$controller$ReplicaStateMachine$$controller;
    private final ControllerContext kafka$controller$ReplicaStateMachine$$controllerContext;
    private final int controllerId;
    private final ZkClient kafka$controller$ReplicaStateMachine$$zkClient;
    private Map<Tuple3<String, Integer, Integer>, ReplicaState> replicaState;
    private final ControllerBrokerRequestBatch brokerRequestBatch;
    private final AtomicBoolean kafka$controller$ReplicaStateMachine$$hasStarted;
    private final Logger stateChangeLogger;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ReplicaStateMachine replicaStateMachine = this;
        synchronized (replicaStateMachine) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 function0) {
        Logging$class.trace(this, function0);
    }

    public Object trace(Function0 function0) {
        return Logging$class.trace(this, function0);
    }

    public void trace(Function0 function0, Function0 function02) {
        Logging$class.trace(this, function0, function02);
    }

    public void swallowTrace(Function0 function0) {
        Logging$class.swallowTrace(this, function0);
    }

    public void debug(Function0 function0) {
        Logging$class.debug(this, function0);
    }

    public Object debug(Function0 function0) {
        return Logging$class.debug(this, function0);
    }

    public void debug(Function0 function0, Function0 function02) {
        Logging$class.debug(this, function0, function02);
    }

    public void swallowDebug(Function0 function0) {
        Logging$class.swallowDebug(this, function0);
    }

    public void info(Function0 function0) {
        Logging$class.info(this, function0);
    }

    public Object info(Function0 function0) {
        return Logging$class.info(this, function0);
    }

    public void info(Function0 function0, Function0 function02) {
        Logging$class.info(this, function0, function02);
    }

    public void swallowInfo(Function0 function0) {
        Logging$class.swallowInfo(this, function0);
    }

    public void warn(Function0 function0) {
        Logging$class.warn(this, function0);
    }

    public Object warn(Function0 function0) {
        return Logging$class.warn(this, function0);
    }

    public void warn(Function0 function0, Function0 function02) {
        Logging$class.warn(this, function0, function02);
    }

    public void swallowWarn(Function0 function0) {
        Logging$class.swallowWarn(this, function0);
    }

    public void swallow(Function0 function0) {
        Logging$class.swallow(this, function0);
    }

    public void error(Function0 function0) {
        Logging$class.error(this, function0);
    }

    public Object error(Function0 function0) {
        return Logging$class.error(this, function0);
    }

    public void error(Function0 function0, Function0 function02) {
        Logging$class.error(this, function0, function02);
    }

    public void swallowError(Function0 function0) {
        Logging$class.swallowError(this, function0);
    }

    public void fatal(Function0 function0) {
        Logging$class.fatal(this, function0);
    }

    public Object fatal(Function0 function0) {
        return Logging$class.fatal(this, function0);
    }

    public void fatal(Function0 function0, Function0 function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public final ControllerContext kafka$controller$ReplicaStateMachine$$controllerContext() {
        return this.kafka$controller$ReplicaStateMachine$$controllerContext;
    }

    private int controllerId() {
        return this.controllerId;
    }

    public final ZkClient kafka$controller$ReplicaStateMachine$$zkClient() {
        return this.kafka$controller$ReplicaStateMachine$$zkClient;
    }

    public Map<Tuple3<String, Integer, Integer>, ReplicaState> replicaState() {
        return this.replicaState;
    }

    public void replicaState_$eq(Map<Tuple3<String, Integer, Integer>, ReplicaState> map) {
        this.replicaState = map;
    }

    public ControllerBrokerRequestBatch brokerRequestBatch() {
        return this.brokerRequestBatch;
    }

    public final AtomicBoolean kafka$controller$ReplicaStateMachine$$hasStarted() {
        return this.kafka$controller$ReplicaStateMachine$$hasStarted;
    }

    private Logger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public void startup() {
        this.initializeReplicaState();
        this.kafka$controller$ReplicaStateMachine$$hasStarted().set(true);
        this.handleStateChanges(this.getAllReplicasOnBroker((Seq<String>)this.kafka$controller$ReplicaStateMachine$$controllerContext().allTopics().toSeq(), (Seq<Integer>)this.kafka$controller$ReplicaStateMachine$$controllerContext().liveBrokerIds().toSeq()), OnlineReplica$.MODULE$);
        this.info((Function0<String>)new $anonfun$startup$1(this));
    }

    public void registerListeners() {
        this.registerBrokerChangeListener();
    }

    public void shutdown() {
        this.kafka$controller$ReplicaStateMachine$$hasStarted().set(false);
        this.replicaState().clear();
    }

    public void handleStateChanges(Set<PartitionAndReplica> set, ReplicaState replicaState) {
        this.info((Function0<String>)new $anonfun$handleStateChanges$1(this, set, replicaState));
        try {
            this.brokerRequestBatch().newBatch();
            set.foreach((Function1)new $anonfun$handleStateChanges$2(this, replicaState));
            this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$ReplicaStateMachine$$controller.epoch(), this.kafka$controller$ReplicaStateMachine$$controllerContext().correlationId().getAndIncrement(), this.kafka$controller$ReplicaStateMachine$$controllerContext().liveBrokers());
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new $anonfun$handleStateChanges$3(this, replicaState), (Function0<Throwable>)new $anonfun$handleStateChanges$4(this, throwable));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleStateChange(String string, int n, int n2, ReplicaState replicaState) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(string, n);
        if (!this.kafka$controller$ReplicaStateMachine$$hasStarted().get()) throw new StateChangeFailedException(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change of replica %d for partition %s to %s failed because replica state machine has not started").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)n2), topicAndPartition, replicaState})));
        try {
            boolean bl;
            this.replicaState().getOrElseUpdate((Object)new Tuple3((Object)string, (Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n2)), (Function0)new $anonfun$handleStateChange$2(this));
            Seq seq = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
            ReplicaState replicaState2 = replicaState;
            NewReplica$ newReplica$ = NewReplica$.MODULE$;
            ReplicaState replicaState3 = replicaState2;
            if (!(newReplica$ != null ? !newReplica$.equals(replicaState3) : replicaState3 != null)) {
                Option<LeaderIsrAndControllerEpoch> option;
                this.assertValidPreviousStates(string, n, n2, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NonExistentReplica$[]{NonExistentReplica$.MODULE$})), replicaState);
                Option<LeaderIsrAndControllerEpoch> option2 = option = ZkUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$ReplicaStateMachine$$zkClient(), string, n);
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch2 = leaderIsrAndControllerEpoch;
                    if (leaderIsrAndControllerEpoch2.leaderAndIsr().leader() == n2) {
                        throw new StateChangeFailedException(new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Replica %d for partition %s cannot be moved to NewReplica").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n2), topicAndPartition}))).append((Object)"state as it is being requested to become leader").toString());
                    }
                    this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Integer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{n2})), string, n, leaderIsrAndControllerEpoch2, (Seq<Integer>)seq);
                } else {
                    None$ none$ = None$.MODULE$;
                    Option<LeaderIsrAndControllerEpoch> option3 = option2;
                    if (none$ == null) {
                        if (option3 != null) {
                            throw new MatchError(option2);
                        }
                    } else if (!none$.equals(option3)) throw new MatchError(option2);
                }
                this.replicaState().put((Object)new Tuple3((Object)string, (Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n2)), (Object)NewReplica$.MODULE$);
                this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s to NewReplica").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)n2), topicAndPartition})));
                return;
            }
            NonExistentReplica$ nonExistentReplica$ = NonExistentReplica$.MODULE$;
            ReplicaState replicaState4 = replicaState2;
            if (!(nonExistentReplica$ != null ? !nonExistentReplica$.equals(replicaState4) : replicaState4 != null)) {
                this.assertValidPreviousStates(string, n, n2, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OfflineReplica$[]{OfflineReplica$.MODULE$})), replicaState);
                this.brokerRequestBatch().addStopReplicaRequestForBrokers((Seq<Integer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{n2})), string, n, true);
                Seq seq2 = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().put((Object)topicAndPartition, seq2.filterNot((Function1)new $anonfun$handleStateChange$1(this, n2)));
                this.replicaState().remove((Object)new Tuple3((Object)string, (Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n2)));
                this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s to NonExistentReplica").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)n2), topicAndPartition})));
                return;
            }
            OnlineReplica$ onlineReplica$ = OnlineReplica$.MODULE$;
            ReplicaState replicaState5 = replicaState2;
            if (!(onlineReplica$ != null ? !onlineReplica$.equals(replicaState5) : replicaState5 != null)) {
                this.assertValidPreviousStates(string, n, n2, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewReplica$.MODULE$, OnlineReplica$.MODULE$, OfflineReplica$.MODULE$})), replicaState);
                ReplicaState replicaState6 = (ReplicaState)this.replicaState().apply((Object)new Tuple3((Object)string, (Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n2)));
                NewReplica$ newReplica$2 = NewReplica$.MODULE$;
                ReplicaState replicaState7 = replicaState6;
                if (!(newReplica$2 != null ? !newReplica$2.equals(replicaState7) : replicaState7 != null)) {
                    Seq seq3 = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                    Object object = seq3.contains((Object)BoxesRunTime.boxToInteger((int)n2)) ? BoxedUnit.UNIT : this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().put((Object)topicAndPartition, seq3.$colon$plus((Object)BoxesRunTime.boxToInteger((int)n2), Seq$.MODULE$.canBuildFrom()));
                    this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s to OnlineReplica").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)n2), topicAndPartition})));
                } else {
                    Option option = this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionLeadershipInfo().get((Object)topicAndPartition);
                    if (option instanceof Some) {
                        this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Integer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{n2})), string, n, (LeaderIsrAndControllerEpoch)((Some)option).x(), (Seq<Integer>)seq);
                        this.replicaState().put((Object)new Tuple3((Object)string, (Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n2)), (Object)OnlineReplica$.MODULE$);
                        this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s to OnlineReplica").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)n2), topicAndPartition})));
                    } else {
                        None$ none$ = None$.MODULE$;
                        Option option4 = option;
                        if (none$ == null) {
                            if (option4 != null) {
                                throw new MatchError((Object)option);
                            }
                        } else if (!none$.equals(option4)) throw new MatchError((Object)option);
                    }
                }
                this.replicaState().put((Object)new Tuple3((Object)string, (Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n2)), (Object)OnlineReplica$.MODULE$);
                return;
            }
            OfflineReplica$ offlineReplica$ = OfflineReplica$.MODULE$;
            ReplicaState replicaState8 = replicaState2;
            if (offlineReplica$ == null) {
                if (replicaState8 != null) {
                    throw new MatchError((Object)replicaState2);
                }
            } else if (!offlineReplica$.equals(replicaState8)) throw new MatchError((Object)replicaState2);
            this.assertValidPreviousStates(string, n, n2, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewReplica$.MODULE$, OnlineReplica$.MODULE$})), replicaState);
            Option option = this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionLeadershipInfo().get((Object)topicAndPartition);
            if (option instanceof Some) {
                if (!((LeaderIsrAndControllerEpoch)((Some)option).x()).leaderAndIsr().isr().contains((Object)BoxesRunTime.boxToInteger((int)n2))) return;
                Option<LeaderIsrAndControllerEpoch> option5 = this.kafka$controller$ReplicaStateMachine$$controller.removeReplicaFromIsr(string, n, n2);
                if (option5 instanceof Some) {
                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch;
                    Some some = (Some)option5;
                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch3 = leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                    this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Integer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderIsrAndControllerEpoch3.leaderAndIsr().leader()})), string, n, leaderIsrAndControllerEpoch3, (Seq<Integer>)seq);
                    this.replicaState().put((Object)new Tuple3((Object)string, (Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n2)), (Object)OfflineReplica$.MODULE$);
                    this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s to OfflineReplica").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)n2), topicAndPartition})));
                    return;
                }
                None$ none$ = None$.MODULE$;
                Option<LeaderIsrAndControllerEpoch> option6 = option5;
                if (none$ == null) {
                    if (option6 != null) {
                        throw new MatchError(option5);
                    }
                } else if (!none$.equals(option6)) throw new MatchError(option5);
                bl = true;
            } else {
                None$ none$ = None$.MODULE$;
                Option option7 = option;
                if (none$ == null) {
                    if (option7 != null) {
                        throw new MatchError((Object)option);
                    }
                } else if (!none$.equals(option7)) throw new MatchError((Object)option);
                bl = true;
            }
            boolean bl2 = bl;
            if (!bl2) return;
            throw new StateChangeFailedException(Predef$.MODULE$.augmentString("Failed to change state of replica %d for partition %s since the leader and isr path in zookeeper is empty").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n2), topicAndPartition})));
        }
        catch (Throwable throwable) {
            this.stateChangeLogger().error((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change of replica %d for partition [%s,%d] to %s failed").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)n2), string, BoxesRunTime.boxToInteger((int)n), replicaState})), throwable);
        }
    }

    private void assertValidPreviousStates(String string, int n, int n2, Seq<ReplicaState> seq, ReplicaState replicaState) {
        Predef$.MODULE$.assert(seq.contains(this.replicaState().apply((Object)new Tuple3((Object)string, (Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n2)))), (Function0)new $anonfun$assertValidPreviousStates$1(this, string, n, n2, seq, replicaState));
    }

    private List<String> registerBrokerChangeListener() {
        return this.kafka$controller$ReplicaStateMachine$$zkClient().subscribeChildChanges(ZkUtils$.MODULE$.BrokerIdsPath(), (IZkChildListener)new BrokerChangeListener());
    }

    private void initializeReplicaState() {
        this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().foreach((Function1)new $anonfun$initializeReplicaState$1(this));
    }

    private Set<PartitionAndReplica> getAllReplicasOnBroker(Seq<String> seq, Seq<Integer> seq2) {
        return ((GenericTraversableTemplate)seq2.map((Function1)new $anonfun$getAllReplicasOnBroker$1(this, seq, seq2), Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.conforms()).toSet();
    }

    public Seq<TopicAndPartition> getPartitionsAssignedToBroker(Seq<String> seq, int n) {
        return ((MapLike)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().filter((Function1)new $anonfun$getPartitionsAssignedToBroker$1(this, n))).keySet().toSeq();
    }

    public ReplicaStateMachine(KafkaController kafkaController) {
        this.kafka$controller$ReplicaStateMachine$$controller = kafkaController;
        Logging$class.$init$(this);
        this.kafka$controller$ReplicaStateMachine$$controllerContext = kafkaController.controllerContext();
        this.controllerId = kafkaController.config().brokerId();
        this.kafka$controller$ReplicaStateMachine$$zkClient = this.kafka$controller$ReplicaStateMachine$$controllerContext().zkClient();
        this.replicaState = Map$.MODULE$.empty();
        this.brokerRequestBatch = new ControllerBrokerRequestBatch(kafkaController.controllerContext(), (Function3<Integer, RequestOrResponse, Function1<RequestOrResponse, Object>, Object>)new $anonfun$1(this), this.controllerId(), kafkaController.clientId());
        this.kafka$controller$ReplicaStateMachine$$hasStarted = new AtomicBoolean(false);
        this.logIdent_$eq(new StringBuilder().append((Object)"[Replica state machine on controller ").append((Object)BoxesRunTime.boxToInteger((int)kafkaController.config().brokerId())).append((Object)"]: ").toString());
        this.stateChangeLogger = Logger.getLogger((String)KafkaController$.MODULE$.stateChangeLogger());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class BrokerChangeListener
    implements IZkChildListener,
    Logging,
    ScalaObject {
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        public volatile int bitmap$0;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Logger logger() {
            if ((this.bitmap$0 & 1) != 0) return this.logger;
            BrokerChangeListener brokerChangeListener = this;
            synchronized (brokerChangeListener) {
                if ((this.bitmap$0 & 1) == 0) {
                    this.logger = Logging$class.logger(this);
                    this.bitmap$0 |= 1;
                }
                return this.logger;
            }
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String string) {
            this.logIdent = string;
        }

        @Override
        public final Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
            this.loggerName = string;
        }

        @Override
        public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
            this.kafka$utils$Logging$$log4jController = log4jController$;
        }

        public void trace(Function0 function0) {
            Logging$class.trace(this, function0);
        }

        public Object trace(Function0 function0) {
            return Logging$class.trace(this, function0);
        }

        public void trace(Function0 function0, Function0 function02) {
            Logging$class.trace(this, function0, function02);
        }

        public void swallowTrace(Function0 function0) {
            Logging$class.swallowTrace(this, function0);
        }

        public void debug(Function0 function0) {
            Logging$class.debug(this, function0);
        }

        public Object debug(Function0 function0) {
            return Logging$class.debug(this, function0);
        }

        public void debug(Function0 function0, Function0 function02) {
            Logging$class.debug(this, function0, function02);
        }

        public void swallowDebug(Function0 function0) {
            Logging$class.swallowDebug(this, function0);
        }

        public void info(Function0 function0) {
            Logging$class.info(this, function0);
        }

        public Object info(Function0 function0) {
            return Logging$class.info(this, function0);
        }

        public void info(Function0 function0, Function0 function02) {
            Logging$class.info(this, function0, function02);
        }

        public void swallowInfo(Function0 function0) {
            Logging$class.swallowInfo(this, function0);
        }

        public void warn(Function0 function0) {
            Logging$class.warn(this, function0);
        }

        public Object warn(Function0 function0) {
            return Logging$class.warn(this, function0);
        }

        public void warn(Function0 function0, Function0 function02) {
            Logging$class.warn(this, function0, function02);
        }

        public void swallowWarn(Function0 function0) {
            Logging$class.swallowWarn(this, function0);
        }

        public void swallow(Function0 function0) {
            Logging$class.swallow(this, function0);
        }

        public void error(Function0 function0) {
            Logging$class.error(this, function0);
        }

        public Object error(Function0 function0) {
            return Logging$class.error(this, function0);
        }

        public void error(Function0 function0, Function0 function02) {
            Logging$class.error(this, function0, function02);
        }

        public void swallowError(Function0 function0) {
            Logging$class.swallowError(this, function0);
        }

        public void fatal(Function0 function0) {
            Logging$class.fatal(this, function0);
        }

        public Object fatal(Function0 function0) {
            return Logging$class.fatal(this, function0);
        }

        public void fatal(Function0 function0, Function0 function02) {
            Logging$class.fatal(this, function0, function02);
        }

        public void handleChildChange(String string, List<String> list) {
            ControllerStats$.MODULE$.leaderElectionTimer().time(new BrokerChangeListener$$anonfun$handleChildChange$1(this, string, list));
        }

        public /* synthetic */ ReplicaStateMachine kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer() {
            return ReplicaStateMachine.this;
        }

        public BrokerChangeListener() {
            if (ReplicaStateMachine.this == null) {
                throw new NullPointerException();
            }
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[BrokerChangeListener on Controller ").append((Object)BoxesRunTime.boxToInteger((int)ReplicaStateMachine.this.kafka$controller$ReplicaStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
        }
    }
}

