/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.common.KafkaException;
import kafka.log.FileMessageSet$;
import kafka.log.LogFlushStats$;
import kafka.log.OffsetPosition;
import kafka.message.ByteBufferMessageSet;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003\u001d\u0019KG.Z'fgN\fw-Z*fi*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0003\b\u0015!\tIA\"D\u0001\u000b\u0015\tYA!A\u0004nKN\u001c\u0018mZ3\n\u00055Q!AC'fgN\fw-Z*fiB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbCA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002C\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002\t\u0019LG.Z\u000b\u0002;A\u0011adI\u0007\u0002?)\u0011\u0001%I\u0001\u0003S>T\u0011AI\u0001\u0005U\u00064\u0018-\u0003\u0002%?\t!a)\u001b7f\u0011!1\u0003A!A!\u0002\u0013i\u0012!\u00024jY\u0016\u0004\u0003\"\u0003\u0015\u0001\u0005\u000b\u0007I\u0011\u0001\u0002*\u0003\u001d\u0019\u0007.\u00198oK2,\u0012A\u000b\t\u0003WAj\u0011\u0001\f\u0006\u0003[9\n\u0001b\u00195b]:,Gn\u001d\u0006\u0003_\u0005\n1A\\5p\u0013\t\tDFA\u0006GS2,7\t[1o]\u0016d\u0007\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\u0002\u0011\rD\u0017M\u001c8fY\u0002B\u0011\"\u000e\u0001\u0003\u0006\u0004%\tA\u0001\u001c\u0002\u000bM$\u0018M\u001d;\u0016\u0003]\u0002\"!\u0006\u001d\n\u0005e2\"aA%oi\"A1\b\u0001B\u0001B\u0003%q'\u0001\u0004ti\u0006\u0014H\u000f\t\u0005\n{\u0001\u0011)\u0019!C\u0001\u0005Y\nQ\u0001\\5nSRD\u0001b\u0010\u0001\u0003\u0002\u0003\u0006IaN\u0001\u0007Y&l\u0017\u000e\u001e\u0011\t\u0011\u0005\u0003!\u0011!Q\u0001\n\t\u000b\u0001$\u001b8ji\u000eC\u0017M\u001c8fYB{7/\u001b;j_:$v.\u00128e!\t)2)\u0003\u0002E-\t9!i\\8mK\u0006t\u0007B\u0002$\u0001\t\u0003!q)\u0001\u0004=S:LGO\u0010\u000b\u0007\u0011*[E*\u0014(\u0011\u0005%\u0003Q\"\u0001\u0002\t\u000bm)\u0005\u0019A\u000f\t\u000b!*\u0005\u0019\u0001\u0016\t\u000fU*\u0005\u0013!a\u0001o!9Q(\u0012I\u0001\u0002\u00049\u0004bB!F!\u0003\u0005\rA\u0011\u0005\b!\u0002\u0011\r\u0011\"\u0003R\u0003\u0015y6/\u001b>f+\u0005\u0011\u0006CA*[\u001b\u0005!&BA+W\u0003\u0019\tGo\\7jG*\u0011q\u000bW\u0001\u000bG>t7-\u001e:sK:$(BA-\"\u0003\u0011)H/\u001b7\n\u0005m#&!D!u_6L7-\u00138uK\u001e,'\u000f\u0003\u0004^\u0001\u0001\u0006IAU\u0001\u0007?NL'0\u001a\u0011\t\u000b\u0019\u0003A\u0011A0\u0015\u0007!\u0003\u0017\rC\u0003\u001c=\u0002\u0007Q\u0004C\u0003)=\u0002\u0007!\u0006C\u0003G\u0001\u0011\u00051\r\u0006\u0002II\")1D\u0019a\u0001;!)a\r\u0001C\u0001O\u0006!!/Z1e)\rA\u0005N\u001b\u0005\u0006S\u0016\u0004\raN\u0001\ta>\u001c\u0018\u000e^5p]\")1.\u001aa\u0001o\u0005!1/\u001b>f\u0011\u0019i\u0007\u0001\"\u0001\u0003]\u0006I1/Z1sG\"4uN\u001d\u000b\u0004_J<\bCA%q\u0013\t\t(A\u0001\bPM\u001a\u001cX\r\u001e)pg&$\u0018n\u001c8\t\u000bMd\u0007\u0019\u0001;\u0002\u0019Q\f'oZ3u\u001f\u001a47/\u001a;\u0011\u0005U)\u0018B\u0001<\u0017\u0005\u0011auN\\4\t\u000bad\u0007\u0019A\u001c\u0002!M$\u0018M\u001d;j]\u001e\u0004vn]5uS>t\u0007\"\u0002>\u0001\t\u0003Y\u0018aB<sSR,Gk\u001c\u000b\u0007oq\f\u0019!a\u0002\t\u000buL\b\u0019\u0001@\u0002\u0017\u0011,7\u000f^\"iC:tW\r\u001c\t\u0003W}L1!!\u0001-\u0005Q9\u0015\r\u001e5fe&twMQ=uK\u000eC\u0017M\u001c8fY\"1\u0011QA=A\u0002Q\fQb\u001e:ji\u0016\u0004vn]5uS>t\u0007\"B6z\u0001\u00049\u0004bBA\u0006\u0001\u0011\u0005\u0013QB\u0001\tSR,'/\u0019;peV\u0011\u0011q\u0002\t\u0007\u0003#\t\t#a\n\u000f\t\u0005M\u0011Q\u0004\b\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011\u0004\u0004\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0012bAA\u0010-\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0012\u0003K\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u0003?1\u0002cA\u0005\u0002*%\u0019\u00111\u0006\u0006\u0003!5+7o]1hK\u0006sGm\u00144gg\u0016$\bbBA\u0018\u0001\u0011\u0005\u0011\u0011G\u0001\fg&TX-\u00138CsR,7\u000fF\u00018\u0011\u001d\t)\u0004\u0001C\u0001\u0003o\ta!\u00199qK:$G\u0003BA\u001d\u0003\u007f\u00012!FA\u001e\u0013\r\tiD\u0006\u0002\u0005+:LG\u000f\u0003\u0005\u0002B\u0005M\u0002\u0019AA\"\u0003!iWm]:bO\u0016\u001c\bcA\u0005\u0002F%\u0019\u0011q\t\u0006\u0003)\tKH/\u001a\"vM\u001a,'/T3tg\u0006<WmU3u\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001b\nQA\u001a7vg\"$\"!!\u000f\t\u000f\u0005E\u0003\u0001\"\u0001\u0002N\u0005)1\r\\8tK\"9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0013A\u00023fY\u0016$X\rF\u0001C\u0011\u001d\tY\u0006\u0001C\u0001\u0003;\n!\u0002\u001e:v]\u000e\fG/\u001a+p)\u0011\tI$a\u0018\t\u000f\u0005\u0005\u0014\u0011\fa\u0001o\u0005QA/\u0019:hKR\u001c\u0016N_3)\u0007\u0001\t)\u0007E\u0002\u0010\u0003OJ1!!\u001b\u0011\u00055qwN\u001c;ie\u0016\fGm]1gK\u001eI\u0011Q\u000e\u0002\u0002\u0002#\u0015\u0011qN\u0001\u000f\r&dW-T3tg\u0006<WmU3u!\rI\u0015\u0011\u000f\u0004\n\u0003\t!\u0019\u0011!E\u0003\u0003g\u001aR!!\u001d\u0002vQ\u0001B!a\u001e\u0002~5\u0011\u0011\u0011\u0010\u0006\u0004\u0003w\n\u0013\u0001\u00027b]\u001eLA!a \u0002z\t1qJ\u00196fGRDqARA9\t\u0003\t\u0019\t\u0006\u0002\u0002p!Q\u0011qQA9#\u0003%\t!!#\u0002\u001d%t\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0012\u0016\u0004o\u000555FAAH!\u0011\t\t*a'\u000e\u0005\u0005M%\u0002BAK\u0003/\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005ee#\u0001\u0006b]:|G/\u0019;j_:LA!!(\u0002\u0014\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\u0005\u0005\u0016\u0011OI\u0001\n\u0003\tI)\u0001\bj]&$H\u0005Z3gCVdG\u000f\n\u001b\t\u0015\u0005\u0015\u0016\u0011OI\u0001\n\u0003\t9+\u0001\bj]&$H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005%&f\u0001\"\u0002\u000e\u0002")
public class FileMessageSet
extends MessageSet
implements Logging,
ScalaObject {
    private final File file;
    private final FileChannel channel;
    private final int start;
    private final int limit;
    private final AtomicInteger _size;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final boolean init$default$5() {
        return FileMessageSet$.MODULE$.init$default$5();
    }

    public static final int init$default$4() {
        return FileMessageSet$.MODULE$.init$default$4();
    }

    public static final int init$default$3() {
        return FileMessageSet$.MODULE$.init$default$3();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        FileMessageSet fileMessageSet = this;
        synchronized (fileMessageSet) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 function0) {
        Logging$class.trace(this, function0);
    }

    public Object trace(Function0 function0) {
        return Logging$class.trace(this, function0);
    }

    public void trace(Function0 function0, Function0 function02) {
        Logging$class.trace(this, function0, function02);
    }

    public void swallowTrace(Function0 function0) {
        Logging$class.swallowTrace(this, function0);
    }

    public void debug(Function0 function0) {
        Logging$class.debug(this, function0);
    }

    public Object debug(Function0 function0) {
        return Logging$class.debug(this, function0);
    }

    public void debug(Function0 function0, Function0 function02) {
        Logging$class.debug(this, function0, function02);
    }

    public void swallowDebug(Function0 function0) {
        Logging$class.swallowDebug(this, function0);
    }

    public void info(Function0 function0) {
        Logging$class.info(this, function0);
    }

    public Object info(Function0 function0) {
        return Logging$class.info(this, function0);
    }

    public void info(Function0 function0, Function0 function02) {
        Logging$class.info(this, function0, function02);
    }

    public void swallowInfo(Function0 function0) {
        Logging$class.swallowInfo(this, function0);
    }

    public void warn(Function0 function0) {
        Logging$class.warn(this, function0);
    }

    public Object warn(Function0 function0) {
        return Logging$class.warn(this, function0);
    }

    public void warn(Function0 function0, Function0 function02) {
        Logging$class.warn(this, function0, function02);
    }

    public void swallowWarn(Function0 function0) {
        Logging$class.swallowWarn(this, function0);
    }

    public void swallow(Function0 function0) {
        Logging$class.swallow(this, function0);
    }

    public void error(Function0 function0) {
        Logging$class.error(this, function0);
    }

    public Object error(Function0 function0) {
        return Logging$class.error(this, function0);
    }

    public void error(Function0 function0, Function0 function02) {
        Logging$class.error(this, function0, function02);
    }

    public void swallowError(Function0 function0) {
        Logging$class.swallowError(this, function0);
    }

    public void fatal(Function0 function0) {
        Logging$class.fatal(this, function0);
    }

    public Object fatal(Function0 function0) {
        return Logging$class.fatal(this, function0);
    }

    public void fatal(Function0 function0, Function0 function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public File file() {
        return this.file;
    }

    public FileChannel channel() {
        return this.channel;
    }

    public int start() {
        return this.start;
    }

    public int limit() {
        return this.limit;
    }

    private AtomicInteger _size() {
        return this._size;
    }

    public FileMessageSet(File file, FileChannel fileChannel) {
        this(file, fileChannel, 0, Integer.MAX_VALUE, FileMessageSet$.MODULE$.init$default$5());
    }

    public FileMessageSet(File file) {
        this(file, Utils$.MODULE$.openChannel(file, true));
    }

    public FileMessageSet read(int n, int n2) {
        return new FileMessageSet(this.file(), this.channel(), this.start() + n, package$.MODULE$.min(this.start() + n + n2, this.sizeInBytes()), false);
    }

    public OffsetPosition searchFor(long l, int n) {
        int n2 = n;
        ByteBuffer byteBuffer = ByteBuffer.allocate(MessageSet$.MODULE$.LogOverhead());
        int n3 = this._size().get();
        while (n2 + MessageSet$.MODULE$.LogOverhead() < n3) {
            byteBuffer.rewind();
            this.channel().read(byteBuffer, n2);
            if (byteBuffer.hasRemaining()) {
                throw new IllegalStateException(Predef$.MODULE$.augmentString("Failed to read complete buffer for targetOffset %d startPosition %d in %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)l), BoxesRunTime.boxToInteger((int)n), this.file().getAbsolutePath()})));
            }
            byteBuffer.rewind();
            long l2 = byteBuffer.getLong();
            if (l2 >= l) {
                return new OffsetPosition(l2, n2);
            }
            int n4 = byteBuffer.getInt();
            n2 += MessageSet$.MODULE$.LogOverhead() + n4;
        }
        return null;
    }

    @Override
    public int writeTo(GatheringByteChannel gatheringByteChannel, long l, int n) {
        int n2 = package$.MODULE$.min((int)this.channel().size(), this.limit()) - this.start();
        if (n2 < this._size().get()) {
            throw new KafkaException(Predef$.MODULE$.augmentString("Size of FileMessageSet %s has been truncated during write: old size %d, new size %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)this._size().get()), BoxesRunTime.boxToInteger((int)n2)})));
        }
        int n3 = (int)this.channel().transferTo((long)this.start() + l, package$.MODULE$.min(n, this.sizeInBytes()), gatheringByteChannel);
        this.trace((Function0<String>)new $anonfun$writeTo$1(this, n, n3));
        return n3;
    }

    @Override
    public Iterator<MessageAndOffset> iterator() {
        return new $anon$1(this);
    }

    @Override
    public int sizeInBytes() {
        return this._size().get();
    }

    public void append(ByteBufferMessageSet byteBufferMessageSet) {
        int n = byteBufferMessageSet.writeTo(this.channel(), 0L, byteBufferMessageSet.sizeInBytes());
        this._size().getAndAdd(n);
    }

    public void flush() {
        LogFlushStats$.MODULE$.logFlushTimer().time(new $anonfun$flush$1(this));
    }

    public void close() {
        this.flush();
        this.channel().close();
    }

    public boolean delete() {
        Utils$.MODULE$.swallow((Function0<Object>)new $anonfun$delete$1(this));
        return this.file().delete();
    }

    public void truncateTo(int n) {
        if (n > this.sizeInBytes()) {
            throw new KafkaException(new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Attempt to truncate log segment to %d bytes failed since the current ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)}))).append((Object)Predef$.MODULE$.augmentString(" size of this log segment is only %d bytes").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.sizeInBytes())}))).toString());
        }
        this.channel().truncate(n);
        this.channel().position(n);
        this._size().set(n);
    }

    public FileMessageSet(File file, FileChannel fileChannel, int n, int n2, boolean bl) {
        Object object;
        this.file = file;
        this.channel = fileChannel;
        this.start = n;
        this.limit = n2;
        Logging$class.$init$(this);
        this._size = new AtomicInteger(package$.MODULE$.min((int)fileChannel.size(), n2) - n);
        if (bl) {
            this.debug((Function0<String>)new $anonfun$1(this));
            object = fileChannel.position(fileChannel.size());
        } else {
            object = BoxedUnit.UNIT;
        }
    }
}

