/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kafka.api.OffsetRequest$;
import kafka.common.InvalidMessageSizeException;
import kafka.common.InvalidOffsetException;
import kafka.common.KafkaException;
import kafka.common.KafkaStorageException;
import kafka.common.OffsetOutOfRangeException;
import kafka.log.Log$;
import kafka.log.Log$MessageSetAppendInfo$;
import kafka.log.LogSegment;
import kafka.log.SegmentList;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.InvalidMessageException;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.BrokerTopicStats$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Range;
import kafka.utils.Time;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$Long$;
import scala.reflect.ClassManifest;
import scala.reflect.ClassManifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0011Eq!B\u0001\u0003\u0011\u000b9\u0011a\u0001'pO*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019A!B\u0001C\u0001\u0002#\u00151BA\u0002M_\u001e\u001c2!\u0003\u0007\u0015!\ti!#D\u0001\u000f\u0015\ty\u0001#\u0001\u0003mC:<'\"A\t\u0002\t)\fg/Y\u0005\u0003'9\u0011aa\u00142kK\u000e$\bCA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"aC*dC2\fwJ\u00196fGRDQaG\u0005\u0005\u0002q\ta\u0001P5oSRtD#A\u0004\t\u000fyI!\u0019!C\u0001?\u0005iAj\\4GS2,7+\u001e4gSb,\u0012\u0001\t\t\u0003\u001b\u0005J!A\t\b\u0003\rM#(/\u001b8h\u0011\u0019!\u0013\u0002)A\u0005A\u0005qAj\\4GS2,7+\u001e4gSb\u0004\u0003b\u0002\u0014\n\u0005\u0004%\taH\u0001\u0010\u0013:$W\r\u001f$jY\u0016\u001cVO\u001a4jq\"1\u0001&\u0003Q\u0001\n\u0001\n\u0001#\u00138eKb4\u0015\u000e\\3Tk\u001a4\u0017\u000e\u001f\u0011\t\u000b)JA\u0011A\u0016\u0002\u0013\u0019Lg\u000e\u001a*b]\u001e,WC\u0001\u00173)\u0011ich\u0011%\u0011\u0007Uq\u0003'\u0003\u00020-\t1q\n\u001d;j_:\u0004\"!\r\u001a\r\u0001\u0011A1'\u000bC\u0001\u0002\u000b\u0007AGA\u0001U#\t)\u0004\b\u0005\u0002\u0016m%\u0011qG\u0006\u0002\b\u001d>$\b.\u001b8h!\tID(D\u0001;\u0015\tYD!A\u0003vi&d7/\u0003\u0002>u\t)!+\u00198hK\")q(\u000ba\u0001\u0001\u00061!/\u00198hKN\u00042!F!1\u0013\t\u0011eCA\u0003BeJ\f\u0017\u0010C\u0003ES\u0001\u0007Q)A\u0003wC2,X\r\u0005\u0002\u0016\r&\u0011qI\u0006\u0002\u0005\u0019>tw\rC\u0003JS\u0001\u0007!*A\u0005beJ\f\u0017pU5{KB\u0011QcS\u0005\u0003\u0019Z\u00111!\u00138u\u0011\u0015Q\u0013\u0002\"\u0001O+\ty%\u000bF\u0002Q'V\u00032!\u0006\u0018R!\t\t$\u000b\u0002\u00054\u001b\u0012\u0005\tQ1\u00015\u0011\u0015yT\n1\u0001U!\r)\u0012)\u0015\u0005\u0006\t6\u0003\r!\u0012\u0005\u0006/&!\t\u0001W\u0001\u0019M&dWM\\1nKB\u0013XMZ5y\rJ|Wn\u00144gg\u0016$HCA-`!\tQVL\u0004\u0002\u00167&\u0011ALF\u0001\u0007!J,G-\u001a4\n\u0005\tr&B\u0001/\u0017\u0011\u0015\u0001g\u000b1\u0001F\u0003\u0019ygMZ:fi\")!-\u0003C\u0001G\u0006YAn\\4GS2,g.Y7f)\r!'\u000e\u001c\t\u0003K\"l\u0011A\u001a\u0006\u0003OB\t!![8\n\u0005%4'\u0001\u0002$jY\u0016DQa[1A\u0002\u0011\f1\u0001Z5s\u0011\u0015\u0001\u0017\r1\u0001F\u0011\u0015q\u0017\u0002\"\u0001p\u00035Ig\u000eZ3y\r&dWM\\1nKR\u0019A\r]9\t\u000b-l\u0007\u0019\u00013\t\u000b\u0001l\u0007\u0019A#\t\u000bMLA\u0011\u0001;\u0002\u001f\u001d,G/R7qif|eMZ:fiN$2!^A\u0002!\r1h0\u0012\b\u0003ort!\u0001_>\u000e\u0003eT!A\u001f\u0004\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0012BA?\u0017\u0003\u001d\u0001\u0018mY6bO\u0016L1a`A\u0001\u0005\r\u0019V-\u001d\u0006\u0003{ZAa!!\u0002s\u0001\u0004)\u0015!\u0003;j[\u0016\u001cH/Y7q\u0011%\tI!CI\u0001\n\u0003\tY!\u0001\bj]&$H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u00055!f\u0001&\u0002\u0010-\u0012\u0011\u0011\u0003\t\u0005\u0003'\ti\"\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003%)hn\u00195fG.,GMC\u0002\u0002\u001cY\t!\"\u00198o_R\fG/[8o\u0013\u0011\ty\"!\u0006\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002$%\t\n\u0011\"\u0001\u0002&\u0005q\u0011N\\5uI\u0011,g-Y;mi\u0012*TCAA\u0014U\r)\u0015q\u0002\u0005\n\u0003WI\u0011\u0013!C\u0001\u0003\u0017\ta\"\u001b8ji\u0012\"WMZ1vYR$s\u0007C\u0005\u00020%\t\n\u0011\"\u0001\u0002\f\u0005q\u0011N\\5uI\u0011,g-Y;mi\u0012B\u0004\"CA\u001a\u0013E\u0005I\u0011AA\u001b\u00039Ig.\u001b;%I\u00164\u0017-\u001e7uIe*\"!a\u000e+\t\u0005e\u0012q\u0002\t\u0004s\u0005m\u0012bAA\u001fu\t!A+[7f\u0011%\t\t%CI\u0001\n\u0003\tY!A\bj]&$H\u0005Z3gCVdG\u000fJ\u00191\r)Q!\u0001\"A\u0001\u0002\u0003!\u0011QI\n\t\u0003\u0007b\u0011qIA')A\u0019\u0011(!\u0013\n\u0007\u0005-#HA\u0004M_\u001e<\u0017N\\4\u0011\t\u0005=\u0013QK\u0007\u0003\u0003#R1!a\u0015\u0005\u0003\u001diW\r\u001e:jGNLA!a\u0016\u0002R\t\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\t\u0015-\f\u0019E!b\u0001\n\u0003\tY&F\u0001e\u0011)\ty&a\u0011\u0003\u0002\u0003\u0006I\u0001Z\u0001\u0005I&\u0014\b\u0005C\u0006\u0002d\u0005\r#Q1A\u0005\u0002\u0005\u0015\u0014AD7bq2{wMR5mKNK'0Z\u000b\u0002\u0015\"Q\u0011\u0011NA\"\u0005\u0003\u0005\u000b\u0011\u0002&\u0002\u001f5\f\u0007\u0010T8h\r&dWmU5{K\u0002B1\"!\u001c\u0002D\t\u0015\r\u0011\"\u0001\u0002f\u0005qQ.\u0019=NKN\u001c\u0018mZ3TSj,\u0007BCA9\u0003\u0007\u0012\t\u0011)A\u0005\u0015\u0006yQ.\u0019=NKN\u001c\u0018mZ3TSj,\u0007\u0005C\u0006\u0002v\u0005\r#Q1A\u0005\u0002\u0005\u0015\u0014!\u00044mkND\u0017J\u001c;feZ\fG\u000e\u0003\u0006\u0002z\u0005\r#\u0011!Q\u0001\n)\u000baB\u001a7vg\"Le\u000e^3sm\u0006d\u0007\u0005C\u0006\u0002~\u0005\r#Q1A\u0005\u0002\u0005}\u0014A\u0004:pY2Le\u000e^3sm\u0006dWj]\u000b\u0002\u000b\"Q\u00111QA\"\u0005\u0003\u0005\u000b\u0011B#\u0002\u001fI|G\u000e\\%oi\u0016\u0014h/\u00197Ng\u0002B1\"a\"\u0002D\t\u0015\r\u0011\"\u0001\u0002\n\u0006ia.Z3egJ+7m\u001c<fef,\"!a#\u0011\u0007U\ti)C\u0002\u0002\u0010Z\u0011qAQ8pY\u0016\fg\u000eC\u0006\u0002\u0014\u0006\r#\u0011!Q\u0001\n\u0005-\u0015A\u00048fK\u0012\u001c(+Z2pm\u0016\u0014\u0018\u0010\t\u0005\f\u0003/\u000b\u0019E!b\u0001\n\u0003\t)'\u0001\u0007nCbLe\u000eZ3y'&TX\r\u0003\u0006\u0002\u001c\u0006\r#\u0011!Q\u0001\n)\u000bQ\"\\1y\u0013:$W\r_*ju\u0016\u0004\u0003bCAP\u0003\u0007\u0012)\u0019!C\u0001\u0003K\n!#\u001b8eKbLe\u000e^3sm\u0006d')\u001f;fg\"Q\u00111UA\"\u0005\u0003\u0005\u000b\u0011\u0002&\u0002'%tG-\u001a=J]R,'O^1m\u0005f$Xm\u001d\u0011\t\u0017\u0005\u001d\u00161\tB\u0001B\u0003%\u0011\u0011H\u0001\u0005i&lW\r\u0003\u0006\u0002,\u0006\r#\u0011!Q\u0001\n)\u000b\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\u0005\b7\u0005\rC\u0011AAX)Y\t\t,a-\u00026\u0006]\u0016\u0011XA^\u0003{\u000by,!1\u0002D\u0006\u0015\u0007c\u0001\u0005\u0002D!11.!,A\u0002\u0011Dq!a\u0019\u0002.\u0002\u0007!\nC\u0004\u0002n\u00055\u0006\u0019\u0001&\t\u0013\u0005U\u0014Q\u0016I\u0001\u0002\u0004Q\u0005\"CA?\u0003[\u0003\n\u00111\u0001F\u0011!\t9)!,A\u0002\u0005-\u0005\"CAL\u0003[\u0003\n\u00111\u0001K\u0011%\ty*!,\u0011\u0002\u0003\u0007!\n\u0003\u0006\u0002(\u00065\u0006\u0013!a\u0001\u0003sA\u0011\"a+\u0002.B\u0005\t\u0019\u0001&\t\u0015\u0005%\u00171\tb\u0001\n\u0013\tY-\u0001\u0003m_\u000e\\W#\u0001\u0007\t\u0011\u0005=\u00171\tQ\u0001\n1\tQ\u0001\\8dW\u0002B!\"a5\u0002D\t\u0007I\u0011BAk\u0003%)hN\u001a7vg\",G-\u0006\u0002\u0002XB!\u0011\u0011\\At\u001b\t\tYN\u0003\u0003\u0002^\u0006}\u0017AB1u_6L7M\u0003\u0003\u0002b\u0006\r\u0018AC2p]\u000e,(O]3oi*\u0019\u0011Q\u001d\t\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003S\fYNA\u0007Bi>l\u0017nY%oi\u0016<WM\u001d\u0005\n\u0003[\f\u0019\u0005)A\u0005\u0003/\f!\"\u001e8gYV\u001c\b.\u001a3!\u0011)\t\t0a\u0011C\u0002\u0013%\u00111_\u0001\u0010Y\u0006\u001cHO\u001a7vg\",G\rV5nKV\u0011\u0011Q\u001f\t\u0005\u00033\f90\u0003\u0003\u0002z\u0006m'AC!u_6L7\rT8oO\"I\u0011Q`A\"A\u0003%\u0011Q_\u0001\u0011Y\u0006\u001cHO\u001a7vg\",G\rV5nK\u0002B1B!\u0001\u0002D\t\u0007I\u0011\u0001\u0002\u0003\u0004\u0005A1/Z4nK:$8/\u0006\u0002\u0003\u0006A)\u0001Ba\u0002\u0003\f%\u0019!\u0011\u0002\u0002\u0003\u0017M+w-\\3oi2K7\u000f\u001e\t\u0004\u0011\t5\u0011b\u0001B\b\u0005\tQAj\\4TK\u001elWM\u001c;\t\u0013\tM\u00111\tQ\u0001\n\t\u0015\u0011!C:fO6,g\u000e^:!\u0011)\u00119\"a\u0011A\u0002\u0013%\u00111_\u0001\u000b]\u0016DHo\u00144gg\u0016$\bB\u0003B\u000e\u0003\u0007\u0002\r\u0011\"\u0003\u0003\u001e\u0005qa.\u001a=u\u001f\u001a47/\u001a;`I\u0015\fH\u0003\u0002B\u0010\u0005K\u00012!\u0006B\u0011\u0013\r\u0011\u0019C\u0006\u0002\u0005+:LG\u000f\u0003\u0006\u0003(\te\u0011\u0011!a\u0001\u0003k\f1\u0001\u001f\u00132\u0011%\u0011Y#a\u0011!B\u0013\t)0A\u0006oKb$xJ\u001a4tKR\u0004\u0003b\u0002B\u0018\u0003\u0007\"\taH\u0001\u0005]\u0006lW\r\u0003\u0005\u00034\u0005\rC\u0011\u0002B\u001b\u00031aw.\u00193TK\u001elWM\u001c;t)\t\u0011)\u0001\u0003\u0005\u0003:\u0005\rC\u0011\u0002B\u001e\u00039\u0011XmY8wKJ\u001cVmZ7f]R$BAa\b\u0003>!A!q\bB\u001c\u0001\u0004\u0011Y!A\u0004tK\u001elWM\u001c;\t\u0011\t\r\u00131\tC\u0001\u0003K\n\u0001C\\;nE\u0016\u0014xJZ*fO6,g\u000e^:\t\u0011\t\u001d\u00131\tC\u0001\u0005\u0013\nQa\u00197pg\u0016$\"Aa\b\t\u0011\t5\u00131\tC\u0001\u0005\u001f\na!\u00199qK:$GC\u0002B)\u0005/\u00129\u0007E\u0003\u0016\u0005'*U)C\u0002\u0003VY\u0011a\u0001V;qY\u0016\u0014\u0004\u0002\u0003B-\u0005\u0017\u0002\rAa\u0017\u0002\u00115,7o]1hKN\u0004BA!\u0018\u0003d5\u0011!q\f\u0006\u0004\u0005C\"\u0011aB7fgN\fw-Z\u0005\u0005\u0005K\u0012yF\u0001\u000bCsR,')\u001e4gKJlUm]:bO\u0016\u001cV\r\u001e\u0005\u000b\u0005S\u0012Y\u0005%AA\u0002\u0005-\u0015!D1tg&<gn\u00144gg\u0016$8OB\u0006\u0003n\u0005\rC\u0011!A\u0001\u0002\n=$\u0001F'fgN\fw-Z*fi\u0006\u0003\b/\u001a8e\u0013:4wn\u0005\u0004\u0003l1!\"\u0011\u000f\t\u0004+\tM\u0014b\u0001B;-\t9\u0001K]8ek\u000e$\bb\u0003B=\u0005W\u0012)\u001a!C\u0001\u0003\u007f\n1BZ5sgR|eMZ:fi\"Q!Q\u0010B6\u0005#\u0005\u000b\u0011B#\u0002\u0019\u0019L'o\u001d;PM\u001a\u001cX\r\u001e\u0011\t\u0017\t\u0005%1\u000eBK\u0002\u0013\u0005\u0011qP\u0001\u000bY\u0006\u001cHo\u00144gg\u0016$\bB\u0003BC\u0005W\u0012\t\u0012)A\u0005\u000b\u0006YA.Y:u\u001f\u001a47/\u001a;!\u0011-\u0011IIa\u001b\u0003\u0016\u0004%\tAa#\u0002\u000b\r|G-Z2\u0016\u0005\t5\u0005\u0003\u0002B/\u0005\u001fKAA!%\u0003`\t\u00012i\\7qe\u0016\u001c8/[8o\u0007>$Wm\u0019\u0005\f\u0005+\u0013YG!E!\u0002\u0013\u0011i)\u0001\u0004d_\u0012,7\r\t\u0005\f\u00053\u0013YG!f\u0001\n\u0003\t)'A\u0003d_VtG\u000f\u0003\u0006\u0003\u001e\n-$\u0011#Q\u0001\n)\u000baaY8v]R\u0004\u0003b\u0003BQ\u0005W\u0012)\u001a!C\u0001\u0003\u0013\u000b\u0001c\u001c4gg\u0016$8/T8o_R|g.[2\t\u0017\t\u0015&1\u000eB\tB\u0003%\u00111R\u0001\u0012_\u001a47/\u001a;t\u001b>tw\u000e^8oS\u000e\u0004\u0003bB\u000e\u0003l\u0011\u0005!\u0011\u0016\u000b\r\u0005W\u0013yK!-\u00034\nU&q\u0017\t\u0005\u0005[\u0013Y'\u0004\u0002\u0002D!9!\u0011\u0010BT\u0001\u0004)\u0005b\u0002BA\u0005O\u0003\r!\u0012\u0005\t\u0005\u0013\u00139\u000b1\u0001\u0003\u000e\"9!\u0011\u0014BT\u0001\u0004Q\u0005\u0002\u0003BQ\u0005O\u0003\r!a#\t\u0015\tm&1NA\u0001\n\u0003\u0011i,\u0001\u0003d_BLH\u0003\u0004BV\u0005\u007f\u0013\tMa1\u0003F\n\u001d\u0007\"\u0003B=\u0005s\u0003\n\u00111\u0001F\u0011%\u0011\tI!/\u0011\u0002\u0003\u0007Q\t\u0003\u0006\u0003\n\ne\u0006\u0013!a\u0001\u0005\u001bC\u0011B!'\u0003:B\u0005\t\u0019\u0001&\t\u0015\t\u0005&\u0011\u0018I\u0001\u0002\u0004\tY\t\u0003\u0006\u0003L\n-\u0014\u0013!C\u0001\u0003K\tabY8qs\u0012\"WMZ1vYR$\u0013\u0007\u0003\u0006\u0003P\n-\u0014\u0013!C\u0001\u0003K\tabY8qs\u0012\"WMZ1vYR$#\u0007\u0003\u0006\u0003T\n-\u0014\u0013!C\u0001\u0005+\fabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0003X*\"!QRA\b\u0011)\u0011YNa\u001b\u0012\u0002\u0013\u0005\u00111B\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0011)\u0011yNa\u001b\u0012\u0002\u0013\u0005!\u0011]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136+\t\u0011\u0019O\u000b\u0003\u0002\f\u0006=\u0001b\u0003Bt\u0005W\"\t\u0011!C!\u0005S\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002\u0015\"Y!Q\u001eB6\t\u0003\u0005I\u0011\tBx\u0003!!xn\u0015;sS:<G#A-\t\u0017\tM(1\u000eC\u0001\u0002\u0013\u0005#Q_\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005-%q\u001f\u0005\u000b\u0005O\u0011\t0!AA\u0002\te\bcA\u000b\u0003|&\u0019!Q \f\u0003\u0007\u0005s\u0017\u0010\u0003\u0006\u0004\u0002\t-D\u0011!A\u0005B}\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&D\bbCB\u0003\u0005W\"\t\u0011!C!\u0003K\nA\u0002\u001d:pIV\u001cG/\u0011:jifD1b!\u0003\u0003l\u0011\u0005\t\u0011\"\u0011\u0004\f\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B}\u0007\u001bA\u0011Ba\n\u0004\b\u0005\u0005\t\u0019\u0001&\t\u0017\rE!1\u000eC\u0001\u0002\u0013\u000531C\u0001\tG\u0006tW)];bYR!\u00111RB\u000b\u0011)\u00119ca\u0004\u0002\u0002\u0003\u0007!\u0011 \u0015\u0005\u0005W\u001aI\u0002E\u0002\u0016\u00077I1a!\b\u0017\u00051\u0019XM]5bY&T\u0018M\u00197f\u000f)\u0019\t#a\u0011\u0002\u0002#\u001511E\u0001\u0015\u001b\u0016\u001c8/Y4f'\u0016$\u0018\t\u001d9f]\u0012LeNZ8\u0011\t\t56Q\u0005\u0004\f\u0005[\n\u0019\u0005bA\u0001\u0012\u000b\u00199cE\u0003\u0004&\r%B\u0003E\u0007\u0004,\rER)\u0012BG\u0015\u0006-%1V\u0007\u0003\u0007[Q1aa\f\u0017\u0003\u001d\u0011XO\u001c;j[\u0016LAaa\r\u0004.\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001b\t\u000fm\u0019)\u0003\"\u0001\u00048Q\u001111\u0005\u0005\u000b\u0007w\u0019)#!A\u0005\u0002\u000eu\u0012!B1qa2LH\u0003\u0004BV\u0007\u007f\u0019\tea\u0011\u0004F\r\u001d\u0003b\u0002B=\u0007s\u0001\r!\u0012\u0005\b\u0005\u0003\u001bI\u00041\u0001F\u0011!\u0011Ii!\u000fA\u0002\t5\u0005b\u0002BM\u0007s\u0001\rA\u0013\u0005\t\u0005C\u001bI\u00041\u0001\u0002\f\"Q11JB\u0013\u0003\u0003%\ti!\u0014\u0002\u000fUt\u0017\r\u001d9msR!1qJB,!\u0011)bf!\u0015\u0011\u0015U\u0019\u0019&R#\u0003\u000e*\u000bY)C\u0002\u0004VY\u0011a\u0001V;qY\u0016,\u0004\u0002CB-\u0007\u0013\u0002\rAa+\u0002\u0007a$\u0003\u0007\u0003\u0005\u0004^\u0005\rC\u0011BB0\u0003q\tg.\u00197zu\u0016\fe\u000e\u001a,bY&$\u0017\r^3NKN\u001c\u0018mZ3TKR$BAa+\u0004b!A!\u0011LB.\u0001\u0004\u0011Y\u0006\u0003\u0005\u0004f\u0005\rC\u0011BB4\u0003A!(/[7J]Z\fG.\u001b3CsR,7\u000f\u0006\u0003\u0003\\\r%\u0004\u0002\u0003B-\u0007G\u0002\rAa\u0017\t\u0011\r5\u00141\tC\u0001\u0007_\nAA]3bIRA1\u0011OB<\u0007w\u001ay\b\u0005\u0003\u0003^\rM\u0014\u0002BB;\u0005?\u0012!\"T3tg\u0006<WmU3u\u0011\u001d\u0019Iha\u001bA\u0002\u0015\u000b1b\u001d;beR|eMZ:fi\"91QPB6\u0001\u0004Q\u0015!C7bq2+gn\u001a;i\u0011)\u0019\tia\u001b\u0011\u0002\u0003\u000711Q\u0001\n[\u0006DxJ\u001a4tKR\u00042!\u0006\u0018F\u0011!\u00199)a\u0011\u0005\u0002\r%\u0015\u0001E7be.$U\r\\3uK\u0012<\u0006.\u001b7f)\u0011\u0019Yi!$\u0011\tYt(1\u0002\u0005\t\u0007\u001f\u001b)\t1\u0001\u0004\u0012\u0006I\u0001O]3eS\u000e\fG/\u001a\t\b+\rM%1BAF\u0013\r\u0019)J\u0006\u0002\n\rVt7\r^5p]FB\u0001b!'\u0002D\u0011\u0005\u0011qP\u0001\u0005g&TX\r\u0003\u0005\u0004\u001e\u0006\rC\u0011AA@\u00031awnZ#oI>3gm]3u\u0011!\u0019\t+a\u0011\u0005\n\r\r\u0016!C7bs\n,'k\u001c7m)\u0011\u0011Ya!*\t\u0011\t}2q\u0014a\u0001\u0005\u0017A\u0001b!+\u0002D\u0011\u000511V\u0001\u0005e>dG\u000e\u0006\u0002\u0003\f!A1qVA\"\t\u0013\u0019\t,\u0001\u0007s_2dGk\\(gMN,G\u000f\u0006\u0003\u0003\f\rM\u0006bBB[\u0007[\u0003\r!R\u0001\n]\u0016<xJ\u001a4tKRD\u0001b!/\u0002D\u0011%11X\u0001\u000b[\u0006L(-\u001a$mkNDG\u0003\u0002B\u0010\u0007{Cqaa0\u00048\u0002\u0007!*\u0001\tok6\u0014WM](g\u001b\u0016\u001c8/Y4fg\"A11YA\"\t\u0003\u0011I%A\u0003gYV\u001c\b\u000e\u0003\u0005\u0004H\u0006\rC\u0011ABe\u0003A9W\r^(gMN,Go\u001d\"fM>\u0014X\rF\u0003v\u0007\u0017\u001ci\rC\u0004\u0002\u0006\r\u0015\u0007\u0019A#\t\u000f\r=7Q\u0019a\u0001\u0015\u0006iQ.\u0019=Ok6|eMZ:fiND\u0001ba5\u0002D\u0011\u0005!\u0011J\u0001\u0007I\u0016dW\r^3\t\u0011\r]\u00171\tC\u0001\u00073\fa\u0002Z3mKR,7+Z4nK:$8\u000fF\u0002K\u00077D\u0001B!\u0001\u0004V\u0002\u000711\u0012\u0005\t\u0007?\f\u0019\u0005\"\u0001\u0004b\u0006QAO];oG\u0006$X\rV8\u0015\t\t}11\u001d\u0005\b\u0007K\u001ci\u000e1\u0001F\u00031!\u0018M]4fi>3gm]3u\u0011!\u0019I/a\u0011\u0005\u0002\r-\u0018!\b;sk:\u001c\u0017\r^3B]\u0012\u001cF/\u0019:u/&$\bNT3x\u001f\u001a47/\u001a;\u0015\t\t}1Q\u001e\u0005\b\u0007k\u001b9\u000f1\u0001F\u0011!\u0019\t0a\u0011\u0005\u0002\t=\u0018!\u0003;pa&\u001cg*Y7f\u0011!\u0019)0a\u0011\u0005\u0002\r]\u0018AE4fi2\u000b7\u000f\u001e$mkNDW\r\u001a+j[\u0016$\u0012!\u0012\u0005\t\u0005[\f\u0019\u0005\"\u0011\u0004|R\t\u0001\u0005\u0003\u0006\u0004\u0000\u0006\r\u0013\u0013!C\u0001\u0005C\f\u0001#\u00199qK:$G\u0005Z3gCVdG\u000f\n\u001a\t\u0015\u0011\r\u00111II\u0001\n\u0003!)!\u0001\bsK\u0006$G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0011\u001d!\u0006BBB\u0003\u001fAC!a\u0011\u0005\fA\u0019\u0011\b\"\u0004\n\u0007\u0011=!H\u0001\u0006uQJ,\u0017\rZ:bM\u0016\u0004")
public class Log
implements Logging,
KafkaMetricsGroup,
ScalaObject {
    private final File dir;
    private final int maxLogFileSize;
    private final int maxMessageSize;
    private final int flushInterval;
    private final long rollIntervalMs;
    private final boolean needsRecovery;
    private final int maxIndexSize;
    private final int indexIntervalBytes;
    public final Time kafka$log$Log$$time;
    private final Object lock;
    private final AtomicInteger unflushed;
    private final AtomicLong lastflushedTime;
    private final SegmentList<LogSegment> segments;
    private AtomicLong kafka$log$Log$$nextOffset;
    private /* synthetic */ Log$MessageSetAppendInfo$ MessageSetAppendInfo$module;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final int init$default$10() {
        return Log$.MODULE$.init$default$10();
    }

    public static final Time init$default$9() {
        return Log$.MODULE$.init$default$9();
    }

    public static final int init$default$8() {
        return Log$.MODULE$.init$default$8();
    }

    public static final int init$default$7() {
        return Log$.MODULE$.init$default$7();
    }

    public static final long init$default$5() {
        return Log$.MODULE$.init$default$5();
    }

    public static final int init$default$4() {
        return Log$.MODULE$.init$default$4();
    }

    public static final Seq<Long> getEmptyOffsets(long l) {
        return Log$.MODULE$.getEmptyOffsets(l);
    }

    public static final File indexFilename(File file, long l) {
        return Log$.MODULE$.indexFilename(file, l);
    }

    public static final File logFilename(File file, long l) {
        return Log$.MODULE$.logFilename(file, l);
    }

    public static final String filenamePrefixFromOffset(long l) {
        return Log$.MODULE$.filenamePrefixFromOffset(l);
    }

    public static final <T extends Range> Option<T> findRange(T[] TArray, long l) {
        return Log$.MODULE$.findRange((Range[])TArray, l);
    }

    public static final <T extends Range> Option<T> findRange(T[] TArray, long l, int n) {
        return Log$.MODULE$.findRange((Range[])TArray, l, n);
    }

    public static final String IndexFileSuffix() {
        return Log$.MODULE$.IndexFileSuffix();
    }

    public static final String LogFileSuffix() {
        return Log$.MODULE$.LogFileSuffix();
    }

    public Gauge newGauge(String string, Gauge gauge) {
        return KafkaMetricsGroup$class.newGauge(this, string, gauge);
    }

    @Override
    public Meter newMeter(String string, String string2, TimeUnit timeUnit) {
        return KafkaMetricsGroup$class.newMeter(this, string, string2, timeUnit);
    }

    @Override
    public Histogram newHistogram(String string, boolean bl) {
        return KafkaMetricsGroup$class.newHistogram(this, string, bl);
    }

    @Override
    public Timer newTimer(String string, TimeUnit timeUnit, TimeUnit timeUnit2) {
        return KafkaMetricsGroup$class.newTimer(this, string, timeUnit, timeUnit2);
    }

    @Override
    public /* synthetic */ boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        Log log = this;
        synchronized (log) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 function0) {
        Logging$class.trace(this, function0);
    }

    public Object trace(Function0 function0) {
        return Logging$class.trace(this, function0);
    }

    public void trace(Function0 function0, Function0 function02) {
        Logging$class.trace(this, function0, function02);
    }

    public void swallowTrace(Function0 function0) {
        Logging$class.swallowTrace(this, function0);
    }

    public void debug(Function0 function0) {
        Logging$class.debug(this, function0);
    }

    public Object debug(Function0 function0) {
        return Logging$class.debug(this, function0);
    }

    public void debug(Function0 function0, Function0 function02) {
        Logging$class.debug(this, function0, function02);
    }

    public void swallowDebug(Function0 function0) {
        Logging$class.swallowDebug(this, function0);
    }

    public void info(Function0 function0) {
        Logging$class.info(this, function0);
    }

    public Object info(Function0 function0) {
        return Logging$class.info(this, function0);
    }

    public void info(Function0 function0, Function0 function02) {
        Logging$class.info(this, function0, function02);
    }

    public void swallowInfo(Function0 function0) {
        Logging$class.swallowInfo(this, function0);
    }

    public void warn(Function0 function0) {
        Logging$class.warn(this, function0);
    }

    public Object warn(Function0 function0) {
        return Logging$class.warn(this, function0);
    }

    public void warn(Function0 function0, Function0 function02) {
        Logging$class.warn(this, function0, function02);
    }

    public void swallowWarn(Function0 function0) {
        Logging$class.swallowWarn(this, function0);
    }

    public void swallow(Function0 function0) {
        Logging$class.swallow(this, function0);
    }

    public void error(Function0 function0) {
        Logging$class.error(this, function0);
    }

    public Object error(Function0 function0) {
        return Logging$class.error(this, function0);
    }

    public void error(Function0 function0, Function0 function02) {
        Logging$class.error(this, function0, function02);
    }

    public void swallowError(Function0 function0) {
        Logging$class.swallowError(this, function0);
    }

    public void fatal(Function0 function0) {
        Logging$class.fatal(this, function0);
    }

    public Object fatal(Function0 function0) {
        return Logging$class.fatal(this, function0);
    }

    public void fatal(Function0 function0, Function0 function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public /* synthetic */ Option read$default$3() {
        return None$.MODULE$;
    }

    public /* synthetic */ boolean append$default$2() {
        return true;
    }

    public File dir() {
        return this.dir;
    }

    public int maxLogFileSize() {
        return this.maxLogFileSize;
    }

    public int maxMessageSize() {
        return this.maxMessageSize;
    }

    public int flushInterval() {
        return this.flushInterval;
    }

    public long rollIntervalMs() {
        return this.rollIntervalMs;
    }

    public boolean needsRecovery() {
        return this.needsRecovery;
    }

    public int maxIndexSize() {
        return this.maxIndexSize;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    private Object lock() {
        return this.lock;
    }

    private AtomicInteger unflushed() {
        return this.unflushed;
    }

    private AtomicLong lastflushedTime() {
        return this.lastflushedTime;
    }

    public SegmentList<LogSegment> segments() {
        return this.segments;
    }

    public final AtomicLong kafka$log$Log$$nextOffset() {
        return this.kafka$log$Log$$nextOffset;
    }

    private void kafka$log$Log$$nextOffset_$eq(AtomicLong atomicLong) {
        this.kafka$log$Log$$nextOffset = atomicLong;
    }

    public String name() {
        return this.dir().getName();
    }

    private SegmentList<LogSegment> loadSegments() {
        Boolean bl;
        ArrayList<LogSegment> arrayList = new ArrayList<LogSegment>();
        File[] fileArray = this.dir().listFiles();
        if (fileArray != null) {
            Predef$.MODULE$.refArrayOps((Object[])fileArray).withFilter((Function1)new $anonfun$loadSegments$1(this)).foreach((Function1)new $anonfun$loadSegments$2(this, arrayList));
        }
        if (arrayList.size() == 0) {
            bl = BoxesRunTime.boxToBoolean((boolean)arrayList.add(new LogSegment(this.dir(), 0L, this.indexIntervalBytes(), this.maxIndexSize())));
        } else {
            Collections.sort(arrayList, new $anon$3(this));
            ((LogSegment)arrayList.get(arrayList.size() - 1)).index().resize(this.maxIndexSize());
            if (this.needsRecovery()) {
                LogSegment logSegment = (LogSegment)arrayList.get(arrayList.size() - 1);
                try {
                    this.recoverSegment(logSegment);
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    long l = logSegment.start();
                    this.warn((Function0<String>)new $anonfun$loadSegments$3(this, l));
                    logSegment.truncateTo(l);
                }
            }
            bl = BoxedUnit.UNIT;
        }
        LogSegment[] logSegmentArray = (LogSegment[])arrayList.toArray((Object[])new LogSegment[arrayList.size()]);
        Predef$.MODULE$.refArrayOps((Object[])logSegmentArray).foreach((Function1)new $anonfun$loadSegments$4(this));
        return new SegmentList<LogSegment>((Seq<LogSegment>)Predef$.MODULE$.wrapRefArray((Object[])logSegmentArray), (ClassManifest<LogSegment>)ClassManifest$.MODULE$.classType(LogSegment.class));
    }

    private void recoverSegment(LogSegment logSegment) {
        int n;
        this.info((Function0<String>)new $anonfun$recoverSegment$1(this, logSegment));
        logSegment.index().truncate();
        int n2 = 0;
        int n3 = 0;
        Iterator<MessageAndOffset> iterator = logSegment.messageSet().iterator();
        try {
            while (iterator.hasNext()) {
                MessageAndOffset messageAndOffset = (MessageAndOffset)iterator.next();
                messageAndOffset.message().ensureValid();
                if (n2 - n3 > this.indexIntervalBytes()) {
                    CompressionCodec compressionCodec = messageAndOffset.message().compressionCodec();
                    NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                    CompressionCodec compressionCodec2 = compressionCodec;
                    long l = !(noCompressionCodec$ != null ? !noCompressionCodec$.equals(compressionCodec2) : compressionCodec2 != null) ? messageAndOffset.offset() : ((MessageAndOffset)ByteBufferMessageSet$.MODULE$.decompress(messageAndOffset.message()).head()).offset();
                    logSegment.index().append(l, n2);
                    n3 = n2;
                }
                n2 += MessageSet$.MODULE$.entrySize(messageAndOffset.message());
            }
        }
        catch (InvalidMessageException invalidMessageException) {
            this.logger().warn((Object)new StringBuilder().append((Object)"Found invalid messages in log ").append((Object)this.name()).toString());
        }
        if ((n = logSegment.messageSet().sizeInBytes() - n2) > 0) {
            this.warn((Function0<String>)new $anonfun$recoverSegment$2(this, n));
        }
        logSegment.messageSet().truncateTo(n2);
    }

    public int numberOfSegments() {
        return ((LogSegment[])this.segments().view()).length;
    }

    public void close() {
        this.debug((Function0<String>)new $anonfun$close$1(this));
        Object object = this.lock();
        synchronized (object) {
            Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).foreach((Function1)new $anonfun$close$2(this));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Tuple2<Long, Long> append(ByteBufferMessageSet byteBufferMessageSet, boolean bl) {
        Tuple2.mcLL.sp sp2;
        MessageSetAppendInfo messageSetAppendInfo = this.analyzeAndValidateMessageSet(byteBufferMessageSet);
        if (messageSetAppendInfo.count() == 0) {
            sp2 = new Tuple2.mcLL.sp(-1L, -1L);
            return sp2;
        }
        ObjectRef objectRef = new ObjectRef((Object)this.trimInvalidBytes(byteBufferMessageSet));
        Tuple2 tuple2 = null;
        try {
            Tuple2.mcLL.sp sp3;
            Object object = this.lock();
            synchronized (object) {
                long l;
                long l2 = this.kafka$log$Log$$nextOffset().get();
                LogSegment logSegment = this.maybeRoll((LogSegment)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).last());
                if (bl) {
                    AtomicLong atomicLong = new AtomicLong(this.kafka$log$Log$$nextOffset().get());
                    this.liftedTree1$1(messageSetAppendInfo, objectRef, atomicLong);
                    long l3 = atomicLong.get() - 1L;
                    long l4 = l3 - l2 + 1L;
                    BrokerTopicStats$.MODULE$.getBrokerTopicStats(this.topicName()).messagesInRate().mark(l4);
                    BrokerTopicStats$.MODULE$.getBrokerAllTopicsStats().messagesInRate().mark(l4);
                    l = l3;
                } else {
                    Predef$.MODULE$.require(messageSetAppendInfo.offsetsMonotonic(), (Function0)new $anonfun$2(this, byteBufferMessageSet));
                    Predef$.MODULE$.require(messageSetAppendInfo.firstOffset() >= this.kafka$log$Log$$nextOffset().get(), (Function0)new $anonfun$3(this, messageSetAppendInfo));
                    l = messageSetAppendInfo.lastOffset();
                }
                long l5 = l;
                ((ByteBufferMessageSet)objectRef.elem).shallowIterator().foreach((Function1)new $anonfun$4(this));
                logSegment.append(l2, (ByteBufferMessageSet)objectRef.elem);
                this.kafka$log$Log$$nextOffset().set(l5 + 1L);
                this.trace((Function0<String>)new $anonfun$5(this, objectRef, l2));
                sp3 = new Tuple2.mcLL.sp(l2, l5);
            }
            Tuple2 tuple22 = (Tuple2)sp3;
            int n = (int)(tuple22._2$mcL$sp() - tuple22._1$mcL$sp() + 1L);
            this.maybeFlush(n);
            tuple2 = tuple22;
            sp2 = tuple2;
            return sp2;
        }
        catch (IOException iOException) {
            throw new KafkaStorageException(Predef$.MODULE$.augmentString("I/O exception in append to log '%s'").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name()})), iOException);
        }
    }

    private MessageSetAppendInfo analyzeAndValidateMessageSet(ByteBufferMessageSet byteBufferMessageSet) {
        IntRef intRef = new IntRef(0);
        LongRef longRef = new LongRef(-1L);
        LongRef longRef2 = new LongRef(-1L);
        ObjectRef objectRef = new ObjectRef((Object)NoCompressionCodec$.MODULE$);
        BooleanRef booleanRef = new BooleanRef(true);
        byteBufferMessageSet.shallowIterator().foreach((Function1)new $anonfun$analyzeAndValidateMessageSet$1(this, intRef, longRef, longRef2, objectRef, booleanRef));
        return new MessageSetAppendInfo(this, longRef.elem, longRef2.elem, (CompressionCodec)objectRef.elem, intRef.elem, booleanRef.elem);
    }

    private ByteBufferMessageSet trimInvalidBytes(ByteBufferMessageSet byteBufferMessageSet) {
        ByteBufferMessageSet byteBufferMessageSet2;
        int n = byteBufferMessageSet.validBytes();
        if (n < 0) {
            throw new InvalidMessageSizeException(new StringBuilder().append((Object)"Illegal length of message set ").append((Object)BoxesRunTime.boxToInteger((int)n)).append((Object)" Message set cannot be appended to log. Possible causes are corrupted produce requests").toString());
        }
        if (n == byteBufferMessageSet.sizeInBytes()) {
            byteBufferMessageSet2 = byteBufferMessageSet;
        } else {
            ByteBuffer byteBuffer = byteBufferMessageSet.buffer().duplicate();
            byteBuffer.limit(n);
            byteBufferMessageSet2 = new ByteBufferMessageSet(byteBuffer);
        }
        return byteBufferMessageSet2;
    }

    public MessageSet read(long l, int n, Option<Long> option) {
        this.trace((Function0<String>)new $anonfun$read$1(this, l, n));
        LogSegment[] logSegmentArray = (LogSegment[])this.segments().view();
        long l2 = ((LogSegment)Predef$.MODULE$.refArrayOps((Object[])logSegmentArray).head()).start();
        long l3 = this.kafka$log$Log$$nextOffset().get();
        if (l == l3) {
            return MessageSet$.MODULE$.Empty();
        }
        if (l > l3 || l < l2) {
            throw new OffsetOutOfRangeException(Predef$.MODULE$.augmentString("Request for offset %d but we only have log segments in the range %d to %d.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)l), BoxesRunTime.boxToLong((long)l2), BoxesRunTime.boxToLong((long)l3)})));
        }
        Option option2 = Log$.MODULE$.findRange(logSegmentArray, l, logSegmentArray.length);
        None$ none$ = None$.MODULE$;
        Option option3 = option2;
        if (!(none$ != null ? !none$.equals(option3) : option3 != null)) {
            throw new OffsetOutOfRangeException("Offset is earlier than the earliest offset");
        }
        if (option2 instanceof Some) {
            return ((LogSegment)((Some)option2).x()).read(l, n, option);
        }
        throw new MatchError((Object)option2);
    }

    public Seq<LogSegment> markDeletedWhile(Function1<LogSegment, Boolean> function1) {
        Object object = this.lock();
        synchronized (object) {
            Object object2;
            this.debug((Function0<String>)new $anonfun$markDeletedWhile$1(this));
            this.debug((Function0<String>)new $anonfun$markDeletedWhile$2(this));
            this.debug((Function0<String>)new $anonfun$markDeletedWhile$3(this));
            this.debug((Function0<String>)new $anonfun$markDeletedWhile$4(this));
            LogSegment[] logSegmentArray = (LogSegment[])this.segments().view();
            LogSegment[] logSegmentArray2 = (LogSegment[])Predef$.MODULE$.refArrayOps((Object[])logSegmentArray).takeWhile(function1);
            Predef$.MODULE$.refArrayOps((Object[])logSegmentArray2).foreach((Function1)new $anonfun$markDeletedWhile$5(this));
            int n = Predef$.MODULE$.refArrayOps((Object[])logSegmentArray2).size();
            if (n == Predef$.MODULE$.refArrayOps((Object[])logSegmentArray).size()) {
                if (logSegmentArray[n - 1].size() > 0L) {
                    object2 = this.roll();
                } else {
                    logSegmentArray[n - 1].messageSet().file().setLastModified(this.kafka$log$Log$$time.milliseconds());
                    --n;
                    object2 = BoxedUnit.UNIT;
                }
            } else {
                object2 = BoxedUnit.UNIT;
            }
            Seq<LogSegment> seq = this.segments().trunc(n);
            return seq;
        }
    }

    public long size() {
        return BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)new $anonfun$size$1(this)));
    }

    public long logEndOffset() {
        return this.kafka$log$Log$$nextOffset().get();
    }

    private LogSegment maybeRoll(LogSegment logSegment) {
        LogSegment logSegment2;
        if (logSegment.messageSet().sizeInBytes() > this.maxLogFileSize()) {
            this.info((Function0<String>)new $anonfun$maybeRoll$1(this));
            logSegment2 = this.roll();
        } else if (logSegment.firstAppendTime().isDefined() && this.kafka$log$Log$$time.milliseconds() - BoxesRunTime.unboxToLong((Object)logSegment.firstAppendTime().get()) > this.rollIntervalMs()) {
            this.info((Function0<String>)new $anonfun$maybeRoll$2(this));
            logSegment2 = this.roll();
        } else if (logSegment.index().isFull()) {
            this.info((Function0<String>)new $anonfun$maybeRoll$3(this, logSegment));
            logSegment2 = this.roll();
        } else {
            logSegment2 = logSegment;
        }
        return logSegment2;
    }

    public LogSegment roll() {
        Object object = this.lock();
        synchronized (object) {
            this.flush();
            LogSegment logSegment = this.rollToOffset(this.logEndOffset());
            return logSegment;
        }
    }

    private LogSegment rollToOffset(long l) {
        Option option;
        block6: {
            block5: {
                block4: {
                    File file = Log$.MODULE$.logFilename(this.dir(), l);
                    File file2 = Log$.MODULE$.indexFilename(this.dir(), l);
                    List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{file, file2})).withFilter((Function1)new $anonfun$rollToOffset$1(this)).foreach((Function1)new $anonfun$rollToOffset$2(this));
                    this.info((Function0<String>)new $anonfun$rollToOffset$3(this, file, file2));
                    option = Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).lastOption();
                    if (!(option instanceof Some)) break block4;
                    ((LogSegment)((Some)option).x()).index().trimToValidSize();
                    break block5;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
            }
            LogSegment[] logSegmentArray = (LogSegment[])this.segments().view();
            if (Predef$.MODULE$.refArrayOps((Object[])logSegmentArray).size() > 0 && ((LogSegment)Predef$.MODULE$.refArrayOps((Object[])logSegmentArray).last()).start() == l) {
                throw new KafkaException(Predef$.MODULE$.augmentString("Trying to roll a new log segment for topic partition %s with start offset %d while it already exists").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir().getName(), BoxesRunTime.boxToLong((long)l)})));
            }
            LogSegment logSegment = new LogSegment(this.dir(), l, this.indexIntervalBytes(), this.maxIndexSize());
            this.segments().append((Seq<LogSegment>)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{logSegment}), (ClassManifest<LogSegment>)ClassManifest$.MODULE$.classType(LogSegment.class));
            return logSegment;
        }
        throw new MatchError((Object)option);
    }

    private void maybeFlush(int n) {
        if (this.unflushed().addAndGet(n) >= this.flushInterval()) {
            this.flush();
        }
    }

    public void flush() {
        if (this.unflushed().get() == 0) {
            return;
        }
        Object object = this.lock();
        synchronized (object) {
            this.debug((Function0<String>)new $anonfun$flush$1(this));
            ((LogSegment)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).last()).flush();
            this.unflushed().set(0);
            this.lastflushedTime().set(this.kafka$log$Log$$time.milliseconds());
            return;
        }
    }

    public Seq<Long> getOffsetsBefore(long l, int n) {
        LogSegment[] logSegmentArray = (LogSegment[])this.segments().view();
        ObjectRef objectRef = new ObjectRef(null);
        objectRef.elem = ((LogSegment)Predef$.MODULE$.refArrayOps((Object[])logSegmentArray).last()).size() > 0L ? new Tuple2[logSegmentArray.length + 1] : new Tuple2[logSegmentArray.length];
        Predef$.MODULE$.intWrapper(0).until(logSegmentArray.length).foreach$mVc$sp((Function1)new $anonfun$getOffsetsBefore$1(this, logSegmentArray, objectRef));
        if (((LogSegment)Predef$.MODULE$.refArrayOps((Object[])logSegmentArray).last()).size() > 0L) {
            ((Tuple2[])objectRef.elem)[logSegmentArray.length] = new Tuple2.mcLL.sp(this.logEndOffset(), this.kafka$log$Log$$time.milliseconds());
        }
        IntRef intRef = new IntRef(-1);
        long l2 = l;
        if (l2 == OffsetRequest$.MODULE$.LatestTime()) {
            intRef.elem = ((Tuple2[])objectRef.elem).length - 1;
        } else if (l2 == OffsetRequest$.MODULE$.EarliestTime()) {
            intRef.elem = 0;
        } else {
            boolean bl = false;
            this.debug((Function0<String>)new $anonfun$getOffsetsBefore$4(this, objectRef));
            intRef.elem = ((Tuple2[])objectRef.elem).length - 1;
            while (intRef.elem >= 0 && !bl) {
                if (((Tuple2[])objectRef.elem)[intRef.elem]._2$mcL$sp() <= l) {
                    bl = true;
                    continue;
                }
                --intRef.elem;
            }
        }
        int n2 = Predef$.MODULE$.intWrapper(n).min(intRef.elem + 1);
        long[] lArray = new long[n2];
        Predef$.MODULE$.intWrapper(0).until(n2).foreach$mVc$sp((Function1)new $anonfun$getOffsetsBefore$2(this, objectRef, intRef, lArray));
        return (Seq)Predef$.MODULE$.longArrayOps(lArray).toSeq().sortBy((Function1)new $anonfun$getOffsetsBefore$3(this), (Ordering)Ordering$Long$.MODULE$);
    }

    public void delete() {
        this.deleteSegments((Seq<LogSegment>)Predef$.MODULE$.wrapRefArray((Object[])this.segments().contents().get()));
        Utils$.MODULE$.rm(this.dir());
    }

    public int deleteSegments(Seq<LogSegment> seq) {
        IntRef intRef = new IntRef(0);
        seq.foreach((Function1)new $anonfun$deleteSegments$1(this, intRef));
        return intRef.elem;
    }

    public void truncateTo(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(Predef$.MODULE$.augmentString("Cannot truncate to a negative offset (%d).").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)l)})));
        }
        Object object = this.lock();
        synchronized (object) {
            Option option;
            block12: {
                block9: {
                    BoxedUnit boxedUnit;
                    block11: {
                        LogSegment logSegment;
                        block10: {
                            block8: {
                                LogSegment[] logSegmentArray = (LogSegment[])Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).filter((Function1)new $anonfun$6(this, l));
                                int n = Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).size();
                                int n2 = this.deleteSegments((Seq<LogSegment>)Predef$.MODULE$.wrapRefArray((Object[])logSegmentArray));
                                if (n2 != Predef$.MODULE$.refArrayOps((Object[])logSegmentArray).size()) {
                                    this.error((Function0<String>)new $anonfun$truncateTo$1(this, l));
                                }
                                if (n2 != n) break block8;
                                this.segments().trunc(Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).size());
                                this.rollToOffset(l);
                                this.kafka$log$Log$$nextOffset().set(l);
                                boxedUnit = BoxedUnit.UNIT;
                                break block9;
                            }
                            if (l <= this.logEndOffset()) break block10;
                            this.error((Function0<String>)new $anonfun$truncateTo$2(this, l));
                            boxedUnit = BoxedUnit.UNIT;
                            break block9;
                        }
                        Option option2 = Log$.MODULE$.findRange((Range[])this.segments().view(), l);
                        option = option2;
                        if (!(option instanceof Some)) break block11;
                        Some some = (Some)option;
                        LogSegment logSegment2 = logSegment = (LogSegment)some.x();
                        int n = Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).indexOf((Object)logSegment2);
                        this.segments().truncLast(n);
                        logSegment2.truncateTo(l);
                        this.kafka$log$Log$$nextOffset().set(l);
                        this.info((Function0<String>)new $anonfun$truncateTo$3(this, l));
                        boxedUnit = BoxedUnit.UNIT;
                        break block9;
                    }
                    None$ none$ = None$.MODULE$;
                    Option option3 = option;
                    if (none$ != null ? !none$.equals(option3) : option3 != null) break block12;
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError((Object)option);
        }
    }

    public void truncateAndStartWithNewOffset(long l) {
        Object object = this.lock();
        synchronized (object) {
            Seq<LogSegment> seq = this.segments().trunc(Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).size());
            this.info((Function0<String>)new $anonfun$truncateAndStartWithNewOffset$1(this, l));
            this.deleteSegments(seq);
            this.segments().append((Seq<LogSegment>)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{new LogSegment(this.dir(), l, this.indexIntervalBytes(), this.maxIndexSize())}), (ClassManifest<LogSegment>)ClassManifest$.MODULE$.classType(LogSegment.class));
            this.kafka$log$Log$$nextOffset().set(l);
            return;
        }
    }

    public String topicName() {
        return this.name().substring(0, this.name().lastIndexOf("-"));
    }

    public long getLastFlushedTime() {
        return this.lastflushedTime().get();
    }

    public String toString() {
        return new StringBuilder().append((Object)"Log(").append((Object)this.dir()).append((Object)")").toString();
    }

    public final /* synthetic */ Log$MessageSetAppendInfo$ MessageSetAppendInfo() {
        if (this.MessageSetAppendInfo$module == null) {
            this.MessageSetAppendInfo$module = new Log$MessageSetAppendInfo$(this);
        }
        return this.MessageSetAppendInfo$module;
    }

    private final void liftedTree1$1(MessageSetAppendInfo messageSetAppendInfo, ObjectRef objectRef, AtomicLong atomicLong) {
        try {
            objectRef.elem = ((ByteBufferMessageSet)objectRef.elem).assignOffsets(atomicLong, messageSetAppendInfo.codec());
            return;
        }
        catch (IOException iOException) {
            throw new KafkaException(Predef$.MODULE$.augmentString("Error in validating messages while appending to log '%s'").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name()})), iOException);
        }
    }

    public Log(File file, int n, int n2, int n3, long l, boolean bl, int n4, int n5, Time time, int n6) {
        this.dir = file;
        this.maxLogFileSize = n;
        this.maxMessageSize = n2;
        this.flushInterval = n3;
        this.rollIntervalMs = l;
        this.needsRecovery = bl;
        this.maxIndexSize = n4;
        this.indexIntervalBytes = n5;
        this.kafka$log$Log$$time = time;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.logIdent_$eq(new StringBuilder().append((Object)"[Kafka Log on Broker ").append((Object)BoxesRunTime.boxToInteger((int)n6)).append((Object)"], ").toString());
        this.lock = new Object();
        this.unflushed = new AtomicInteger(0);
        this.lastflushedTime = new AtomicLong(System.currentTimeMillis());
        this.segments = this.loadSegments();
        this.kafka$log$Log$$nextOffset = new AtomicLong(((LogSegment)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).last()).nextOffset());
        this.info((Function0<String>)new $anonfun$1(this));
        this.newGauge(new StringBuilder().append((Object)this.name()).append((Object)"-").append((Object)"NumLogSegments").toString(), new $anon$1(this));
        this.newGauge(new StringBuilder().append((Object)this.name()).append((Object)"-").append((Object)"LogEndOffset").toString(), new $anon$2(this));
    }

    public class MessageSetAppendInfo
    implements ScalaObject,
    Product,
    Serializable {
        private final long firstOffset;
        private final long lastOffset;
        private final CompressionCodec codec;
        private final int count;
        private final boolean offsetsMonotonic;
        public final /* synthetic */ Log $outer;

        public Iterator productIterator() {
            return Product.class.productIterator((Product)this);
        }

        public Iterator productElements() {
            return Product.class.productElements((Product)this);
        }

        public /* synthetic */ boolean copy$default$5() {
            return this.offsetsMonotonic();
        }

        public /* synthetic */ int copy$default$4() {
            return this.count();
        }

        public /* synthetic */ CompressionCodec copy$default$3() {
            return this.codec();
        }

        public /* synthetic */ long copy$default$2() {
            return this.lastOffset();
        }

        public /* synthetic */ long copy$default$1() {
            return this.firstOffset();
        }

        public long firstOffset() {
            return this.firstOffset;
        }

        public long lastOffset() {
            return this.lastOffset;
        }

        public CompressionCodec codec() {
            return this.codec;
        }

        public int count() {
            return this.count;
        }

        public boolean offsetsMonotonic() {
            return this.offsetsMonotonic;
        }

        public /* synthetic */ MessageSetAppendInfo copy(long l, long l2, CompressionCodec compressionCodec, int n, boolean bl) {
            return new MessageSetAppendInfo(this.kafka$log$Log$MessageSetAppendInfo$$$outer(), l, l2, compressionCodec, n, bl);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            boolean bl;
            boolean bl2;
            int n;
            int n2;
            CompressionCodec compressionCodec;
            CompressionCodec compressionCodec2;
            long l;
            long l2;
            if (this == object) return true;
            Object object2 = object;
            if (!(object2 instanceof MessageSetAppendInfo)) return false;
            if (((MessageSetAppendInfo)object2).kafka$log$Log$MessageSetAppendInfo$$$outer() != this.kafka$log$Log$MessageSetAppendInfo$$$outer()) return false;
            MessageSetAppendInfo messageSetAppendInfo = (MessageSetAppendInfo)object2;
            long l3 = messageSetAppendInfo.firstOffset();
            long l4 = l3;
            if (!this.gd1$1(l4, l2 = (l = messageSetAppendInfo.lastOffset()), compressionCodec2 = (compressionCodec = messageSetAppendInfo.codec()), n2 = (n = messageSetAppendInfo.count()), bl2 = (bl = messageSetAppendInfo.offsetsMonotonic()))) return false;
            boolean bl3 = ((MessageSetAppendInfo)object).canEqual(this);
            if (!bl3) return false;
            return true;
        }

        public String productPrefix() {
            return "MessageSetAppendInfo";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                }
                case 4: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.offsetsMonotonic());
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToInteger((int)this.count());
                    break;
                }
                case 2: {
                    object = this.codec();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.lastOffset());
                    break;
                }
                case 0: {
                    object = BoxesRunTime.boxToLong((long)this.firstOffset());
                }
            }
            return object;
        }

        public boolean canEqual(Object object) {
            return object instanceof MessageSetAppendInfo;
        }

        public /* synthetic */ Log kafka$log$Log$MessageSetAppendInfo$$$outer() {
            return this.$outer;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final /* synthetic */ boolean gd1$1(long l, long l2, CompressionCodec compressionCodec, int n, boolean bl) {
            if (l != this.firstOffset()) return false;
            if (l2 != this.lastOffset()) return false;
            CompressionCodec compressionCodec2 = compressionCodec;
            CompressionCodec compressionCodec3 = this.codec();
            if (compressionCodec2 == null) {
                if (compressionCodec3 != null) {
                    return false;
                }
            } else if (!compressionCodec2.equals(compressionCodec3)) return false;
            if (n != this.count()) return false;
            if (bl != this.offsetsMonotonic()) return false;
            return true;
        }

        public MessageSetAppendInfo(Log log, long l, long l2, CompressionCodec compressionCodec, int n, boolean bl) {
            this.firstOffset = l;
            this.lastOffset = l2;
            this.codec = compressionCodec;
            this.count = n;
            this.offsetsMonotonic = bl;
            if (log == null) {
                throw new NullPointerException();
            }
            this.$outer = log;
            Product.class.$init$((Product)this);
        }
    }
}

