/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import kafka.log.FileMessageSet;
import kafka.log.Log$;
import kafka.log.LogSegment$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import kafka.message.ByteBufferMessageSet;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Range;
import kafka.utils.Range$class;
import kafka.utils.SystemTime$;
import kafka.utils.Time;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003\u00151{wmU3h[\u0016tGO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0003\u0001\u0011A1\u0012\u0004\u0005\u0002\n\u001d5\t!B\u0003\u0002\f\u0019\u0005!A.\u00198h\u0015\u0005i\u0011\u0001\u00026bm\u0006L!a\u0004\u0006\u0003\r=\u0013'.Z2u!\t\tB#D\u0001\u0013\u0015\t\u0019B!A\u0003vi&d7/\u0003\u0002\u0016%\t)!+\u00198hKB\u0011\u0011cF\u0005\u00031I\u0011q\u0001T8hO&tw\r\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2DA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002\u0003\u0011\u0001\u0005\u000b\u0007I\u0011A\u0011\u0002\u00155,7o]1hKN+G/F\u0001#!\t\u0019C%D\u0001\u0003\u0013\t)#A\u0001\bGS2,W*Z:tC\u001e,7+\u001a;\t\u0011\u001d\u0002!\u0011!Q\u0001\n\t\n1\"\\3tg\u0006<WmU3uA!A\u0011\u0006\u0001BC\u0002\u0013\u0005!&A\u0003j]\u0012,\u00070F\u0001,!\t\u0019C&\u0003\u0002.\u0005\tYqJ\u001a4tKRLe\u000eZ3y\u0011!y\u0003A!A!\u0002\u0013Y\u0013AB5oI\u0016D\b\u0005\u0003\u00052\u0001\t\u0015\r\u0011\"\u00013\u0003\u0015\u0019H/\u0019:u+\u0005\u0019\u0004C\u0001\u000e5\u0013\t)4D\u0001\u0003M_:<\u0007\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\u0002\rM$\u0018M\u001d;!\u0011!I\u0004A!b\u0001\n\u0003Q\u0014AE5oI\u0016D\u0018J\u001c;feZ\fGNQ=uKN,\u0012a\u000f\t\u00035qJ!!P\u000e\u0003\u0007%sG\u000f\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003<\u0003MIg\u000eZ3y\u0013:$XM\u001d<bY\nKH/Z:!\u0011!\t\u0005A!A!\u0002\u0013\u0011\u0015\u0001\u0002;j[\u0016\u0004\"!E\"\n\u0005\u0011\u0013\"\u0001\u0002+j[\u0016DQA\u0012\u0001\u0005\u0002\u001d\u000ba\u0001P5oSRtDC\u0002%J\u0015.cU\n\u0005\u0002$\u0001!)\u0001%\u0012a\u0001E!)\u0011&\u0012a\u0001W!)\u0011'\u0012a\u0001g!)\u0011(\u0012a\u0001w!)\u0011)\u0012a\u0001\u0005\"9q\n\u0001a\u0001\n\u0003\u0001\u0016a\u00044jeN$\u0018\t\u001d9f]\u0012$\u0016.\\3\u0016\u0003E\u00032A\u0007*4\u0013\t\u00196D\u0001\u0004PaRLwN\u001c\u0005\b+\u0002\u0001\r\u0011\"\u0001W\u0003M1\u0017N]:u\u0003B\u0004XM\u001c3US6,w\fJ3r)\t9&\f\u0005\u0002\u001b1&\u0011\u0011l\u0007\u0002\u0005+:LG\u000fC\u0004\\)\u0006\u0005\t\u0019A)\u0002\u0007a$\u0013\u0007\u0003\u0004^\u0001\u0001\u0006K!U\u0001\u0011M&\u00148\u000f^!qa\u0016tG\rV5nK\u0002Bqa\u0018\u0001A\u0002\u0013\u0005!(\u0001\rcsR,7oU5oG\u0016d\u0015m\u001d;J]\u0012,\u00070\u00128uefDq!\u0019\u0001A\u0002\u0013\u0005!-\u0001\u000fcsR,7oU5oG\u0016d\u0015m\u001d;J]\u0012,\u00070\u00128uef|F%Z9\u0015\u0005]\u001b\u0007bB.a\u0003\u0003\u0005\ra\u000f\u0005\u0007K\u0002\u0001\u000b\u0015B\u001e\u00023\tLH/Z:TS:\u001cW\rT1ti&sG-\u001a=F]R\u0014\u0018\u0010\t\u0005\bO\u0002\u0001\r\u0011\"\u0001i\u0003\u001d!W\r\\3uK\u0012,\u0012!\u001b\t\u00035)L!a[\u000e\u0003\u000f\t{w\u000e\\3b]\"9Q\u000e\u0001a\u0001\n\u0003q\u0017a\u00033fY\u0016$X\rZ0%KF$\"aV8\t\u000fmc\u0017\u0011!a\u0001S\"1\u0011\u000f\u0001Q!\n%\f\u0001\u0002Z3mKR,G\r\t\u0015\u0003aN\u0004\"A\u0007;\n\u0005U\\\"\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u000b\u0019\u0003A\u0011A<\u0015\u0011!C\u0018\u0011AA\u0003\u0003\u000fAQ!\u001f<A\u0002i\f1\u0001Z5s!\tYh0D\u0001}\u0015\tiH\"\u0001\u0002j_&\u0011q\u0010 \u0002\u0005\r&dW\r\u0003\u0004\u0002\u0004Y\u0004\raM\u0001\fgR\f'\u000f^(gMN,G\u000fC\u0003:m\u0002\u00071\b\u0003\u0004\u0002\nY\u0004\raO\u0001\r[\u0006D\u0018J\u001c3fqNK'0\u001a\u0005\u0007\u0003\u001b\u0001A\u0011\u0001\u001a\u0002\tML'0\u001a\u0005\b\u0003#\u0001A\u0011AA\n\u0003U)\b\u000fZ1uK\u001aK'o\u001d;BaB,g\u000e\u001a+j[\u0016$\u0012a\u0016\u0005\b\u0003/\u0001A\u0011AA\r\u0003\u0019\t\u0007\u000f]3oIR)q+a\u0007\u0002 !9\u0011QDA\u000b\u0001\u0004\u0019\u0014AB8gMN,G\u000f\u0003\u0005\u0002\"\u0005U\u0001\u0019AA\u0012\u0003!iWm]:bO\u0016\u001c\b\u0003BA\u0013\u0003Wi!!a\n\u000b\u0007\u0005%B!A\u0004nKN\u001c\u0018mZ3\n\t\u00055\u0012q\u0005\u0002\u0015\u0005f$XMQ;gM\u0016\u0014X*Z:tC\u001e,7+\u001a;\t\u000f\u0005E\u0002\u0001\"\u0003\u00024\u0005yAO]1og2\fG/Z(gMN,G\u000f\u0006\u0003\u00026\u0005m\u0002cA\u0012\u00028%\u0019\u0011\u0011\b\u0002\u0003\u001d=3gm]3u!>\u001c\u0018\u000e^5p]\"9\u0011QDA\u0018\u0001\u0004\u0019\u0004bBA \u0001\u0011\u0005\u0011\u0011I\u0001\u0005e\u0016\fG\r\u0006\u0005\u0002D\u0005%\u00131JA(!\u0011\t)#!\u0012\n\t\u0005\u001d\u0013q\u0005\u0002\u000b\u001b\u0016\u001c8/Y4f'\u0016$\bbBA\u0002\u0003{\u0001\ra\r\u0005\b\u0003\u001b\ni\u00041\u0001<\u0003\u001di\u0017\r_*ju\u0016Dq!!\u0015\u0002>\u0001\u0007\u0011+A\u0005nCb|eMZ:fi\"9\u0011Q\u000b\u0001\u0005B\u0005]\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005e\u0003cA\u0005\u0002\\%\u0019\u0011Q\f\u0006\u0003\rM#(/\u001b8h\u0011\u001d\t\t\u0007\u0001C\u0001\u0003G\n!\u0002\u001e:v]\u000e\fG/\u001a+p)\r9\u0016Q\r\u0005\b\u0003;\ty\u00061\u00014\u0011\u001d\tI\u0007\u0001C\u0001\u0003W\n!B\\3yi>3gm]3u)\u0005\u0019\u0004bBA8\u0001\u0011\u0005\u00111C\u0001\u0006M2,8\u000f\u001b\u0005\b\u0003g\u0002A\u0011AA\n\u0003\u0015\u0019Gn\\:fQ\r\u0001\u0011q\u000f\t\u0004#\u0005e\u0014bAA>%\tian\u001c8uQJ,\u0017\rZ:bM\u0016\u0004")
public class LogSegment
implements Range,
Logging,
ScalaObject {
    private final FileMessageSet messageSet;
    private final OffsetIndex index;
    private final long start;
    private final int indexIntervalBytes;
    private final Time time;
    private Option<Long> firstAppendTime;
    private int bytesSinceLastIndexEntry;
    private volatile boolean deleted;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        LogSegment logSegment = this;
        synchronized (logSegment) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 function0) {
        Logging$class.trace(this, function0);
    }

    public Object trace(Function0 function0) {
        return Logging$class.trace(this, function0);
    }

    public void trace(Function0 function0, Function0 function02) {
        Logging$class.trace(this, function0, function02);
    }

    public void swallowTrace(Function0 function0) {
        Logging$class.swallowTrace(this, function0);
    }

    public void debug(Function0 function0) {
        Logging$class.debug(this, function0);
    }

    public Object debug(Function0 function0) {
        return Logging$class.debug(this, function0);
    }

    public void debug(Function0 function0, Function0 function02) {
        Logging$class.debug(this, function0, function02);
    }

    public void swallowDebug(Function0 function0) {
        Logging$class.swallowDebug(this, function0);
    }

    public void info(Function0 function0) {
        Logging$class.info(this, function0);
    }

    public Object info(Function0 function0) {
        return Logging$class.info(this, function0);
    }

    public void info(Function0 function0, Function0 function02) {
        Logging$class.info(this, function0, function02);
    }

    public void swallowInfo(Function0 function0) {
        Logging$class.swallowInfo(this, function0);
    }

    public void warn(Function0 function0) {
        Logging$class.warn(this, function0);
    }

    public Object warn(Function0 function0) {
        return Logging$class.warn(this, function0);
    }

    public void warn(Function0 function0, Function0 function02) {
        Logging$class.warn(this, function0, function02);
    }

    public void swallowWarn(Function0 function0) {
        Logging$class.swallowWarn(this, function0);
    }

    public void swallow(Function0 function0) {
        Logging$class.swallow(this, function0);
    }

    public void error(Function0 function0) {
        Logging$class.error(this, function0);
    }

    public Object error(Function0 function0) {
        return Logging$class.error(this, function0);
    }

    public void error(Function0 function0, Function0 function02) {
        Logging$class.error(this, function0, function02);
    }

    public void swallowError(Function0 function0) {
        Logging$class.swallowError(this, function0);
    }

    public void fatal(Function0 function0) {
        Logging$class.fatal(this, function0);
    }

    public Object fatal(Function0 function0) {
        return Logging$class.fatal(this, function0);
    }

    public void fatal(Function0 function0, Function0 function02) {
        Logging$class.fatal(this, function0, function02);
    }

    @Override
    public boolean isEmpty() {
        return Range$class.isEmpty(this);
    }

    @Override
    public boolean contains(long l) {
        return Range$class.contains(this, l);
    }

    public FileMessageSet messageSet() {
        return this.messageSet;
    }

    public OffsetIndex index() {
        return this.index;
    }

    @Override
    public long start() {
        return this.start;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public Option<Long> firstAppendTime() {
        return this.firstAppendTime;
    }

    public void firstAppendTime_$eq(Option<Long> option) {
        this.firstAppendTime = option;
    }

    public int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    public void bytesSinceLastIndexEntry_$eq(int n) {
        this.bytesSinceLastIndexEntry = n;
    }

    public boolean deleted() {
        return this.deleted;
    }

    public void deleted_$eq(boolean bl) {
        this.deleted = bl;
    }

    public LogSegment(File file, long l, int n, int n2) {
        this(new FileMessageSet(Log$.MODULE$.logFilename(file, l)), new OffsetIndex(Log$.MODULE$.indexFilename(file, l), l, n2), l, n, SystemTime$.MODULE$);
    }

    @Override
    public long size() {
        return this.messageSet().sizeInBytes();
    }

    public void updateFirstAppendTime() {
        if (this.firstAppendTime().isEmpty()) {
            this.firstAppendTime_$eq((Option<Long>)new Some((Object)BoxesRunTime.boxToLong((long)this.time.milliseconds())));
        }
    }

    public void append(long l, ByteBufferMessageSet byteBufferMessageSet) {
        if (byteBufferMessageSet.sizeInBytes() > 0) {
            this.trace((Function0<String>)new $anonfun$append$1(this, l, byteBufferMessageSet));
            if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
                this.index().append(l, this.messageSet().sizeInBytes());
                this.bytesSinceLastIndexEntry_$eq(0);
            }
            this.messageSet().append(byteBufferMessageSet);
            this.updateFirstAppendTime();
            this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + byteBufferMessageSet.sizeInBytes());
        }
    }

    private OffsetPosition translateOffset(long l) {
        OffsetPosition offsetPosition = this.index().lookup(l);
        return this.messageSet().searchFor(l, offsetPosition.position());
    }

    public MessageSet read(long l, int n, Option<Long> option) {
        Option<Long> option2;
        block9: {
            int n2;
            OffsetPosition offsetPosition;
            block8: {
                int n3;
                block7: {
                    if (n < 0) {
                        throw new IllegalArgumentException(Predef$.MODULE$.augmentString("Invalid max size for log read (%d)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})));
                    }
                    if (n == 0) {
                        return MessageSet$.MODULE$.Empty();
                    }
                    n3 = this.messageSet().sizeInBytes();
                    offsetPosition = this.translateOffset(l);
                    if (offsetPosition == null) {
                        return MessageSet$.MODULE$.Empty();
                    }
                    option2 = option;
                    None$ none$ = None$.MODULE$;
                    Option<Long> option3 = option2;
                    if (none$ != null ? !none$.equals(option3) : option3 != null) break block7;
                    n2 = n;
                    break block8;
                }
                if (!(option2 instanceof Some)) break block9;
                Some some = (Some)option2;
                long l2 = BoxesRunTime.unboxToLong((Object)some.x());
                long l3 = l2;
                if (l3 < l) {
                    throw new IllegalArgumentException(Predef$.MODULE$.augmentString("Attempt to read with a maximum offset (%d) less than the start offset (%d).").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)l3), BoxesRunTime.boxToLong((long)l)})));
                }
                OffsetPosition offsetPosition2 = this.translateOffset(l3);
                int n4 = offsetPosition2 == null ? n3 : offsetPosition2.position();
                n2 = package$.MODULE$.min(n4 - offsetPosition.position(), n);
            }
            int n5 = n2;
            return this.messageSet().read(offsetPosition.position(), n5);
        }
        throw new MatchError(option2);
    }

    @Override
    public String toString() {
        return new StringBuilder().append((Object)"LogSegment(start=").append((Object)BoxesRunTime.boxToLong((long)this.start())).append((Object)", size=").append((Object)BoxesRunTime.boxToLong((long)this.size())).append((Object)")").toString();
    }

    public void truncateTo(long l) {
        OffsetPosition offsetPosition = this.translateOffset(l);
        if (offsetPosition == null) {
            return;
        }
        this.index().truncateTo(l);
        this.index().resize(this.index().maxIndexSize());
        this.messageSet().truncateTo(offsetPosition.position());
        if (this.messageSet().sizeInBytes() == 0) {
            this.firstAppendTime_$eq((Option<Long>)None$.MODULE$);
        }
    }

    public long nextOffset() {
        Option option;
        block4: {
            long l;
            block3: {
                block2: {
                    MessageSet messageSet = this.read(this.index().lastOffset(), this.messageSet().sizeInBytes(), (Option<Long>)None$.MODULE$);
                    option = messageSet.lastOption();
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                    l = this.start();
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                l = ((MessageAndOffset)((Some)option).x()).nextOffset();
            }
            return l;
        }
        throw new MatchError((Object)option);
    }

    public void flush() {
        this.messageSet().flush();
        this.index().flush();
    }

    public void close() {
        Utils$.MODULE$.swallow((Function0<Object>)new $anonfun$close$1(this));
        Utils$.MODULE$.swallow((Function0<Object>)new $anonfun$close$2(this));
    }

    public LogSegment(FileMessageSet fileMessageSet, OffsetIndex offsetIndex, long l, int n, Time time) {
        this.messageSet = fileMessageSet;
        this.index = offsetIndex;
        this.start = l;
        this.indexIntervalBytes = n;
        this.time = time;
        Range$class.$init$(this);
        Logging$class.$init$(this);
        this.firstAppendTime = fileMessageSet.sizeInBytes() > 0 ? new Some((Object)BoxesRunTime.boxToLong((long)time.milliseconds())) : None$.MODULE$;
        this.bytesSinceLastIndexEntry = 0;
        this.deleted = false;
    }
}

