/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.common.InvalidOffsetException;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003\u0017=3gm]3u\u0013:$W\r\u001f\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0005\u0001!\u0001b\u0003\u0005\u0002\n\u001d5\t!B\u0003\u0002\f\u0019\u0005!A.\u00198h\u0015\u0005i\u0011\u0001\u00026bm\u0006L!a\u0004\u0006\u0003\r=\u0013'.Z2u!\t\tB#D\u0001\u0013\u0015\t\u0019B!A\u0003vi&d7/\u0003\u0002\u0016%\t9Aj\\4hS:<\u0007CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"aC*dC2\fwJ\u00196fGRD\u0001\"\b\u0001\u0003\u0006\u0004%\tAH\u0001\u0005M&dW-F\u0001 !\t\u00013%D\u0001\"\u0015\t\u0011C\"\u0001\u0002j_&\u0011A%\t\u0002\u0005\r&dW\r\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003 \u0003\u00151\u0017\u000e\\3!\u0011!A\u0003A!b\u0001\n\u0003I\u0013A\u00032bg\u0016|eMZ:fiV\t!\u0006\u0005\u0002\u0018W%\u0011A\u0006\u0007\u0002\u0005\u0019>tw\r\u0003\u0005/\u0001\t\u0005\t\u0015!\u0003+\u0003-\u0011\u0017m]3PM\u001a\u001cX\r\u001e\u0011\t\u0011A\u0002!Q1A\u0005\u0002E\nA\"\\1y\u0013:$W\r_*ju\u0016,\u0012A\r\t\u0003/MJ!\u0001\u000e\r\u0003\u0007%sG\u000f\u0003\u00057\u0001\t\u0005\t\u0015!\u00033\u00035i\u0017\r_%oI\u0016D8+\u001b>fA!)\u0001\b\u0001C\u0001s\u00051A(\u001b8jiz\"BA\u000f\u001f>}A\u00111\bA\u0007\u0002\u0005!)Qd\u000ea\u0001?!)\u0001f\u000ea\u0001U!9\u0001g\u000eI\u0001\u0002\u0004\u0011\u0004b\u0002!\u0001\u0001\u0004%I!Q\u0001\u0005[6\f\u0007/F\u0001C!\t\u0019e)D\u0001E\u0015\t)E\"A\u0002oS>L!a\u0012#\u0003!5\u000b\u0007\u000f]3e\u0005f$XMQ;gM\u0016\u0014\bbB%\u0001\u0001\u0004%IAS\u0001\t[6\f\u0007o\u0018\u0013fcR\u00111J\u0014\t\u0003/1K!!\u0014\r\u0003\tUs\u0017\u000e\u001e\u0005\b\u001f\"\u000b\t\u00111\u0001C\u0003\rAH%\r\u0005\u0007#\u0002\u0001\u000b\u0015\u0002\"\u0002\u000b5l\u0017\r\u001d\u0011\t\u000fM\u0003\u0001\u0019!C\u0005)\u0006!1/\u001b>f+\u0005)\u0006C\u0001,^\u001b\u00059&B\u0001-Z\u0003\u0019\tGo\\7jG*\u0011!lW\u0001\u000bG>t7-\u001e:sK:$(B\u0001/\r\u0003\u0011)H/\u001b7\n\u0005y;&!D!u_6L7-\u00138uK\u001e,'\u000fC\u0004a\u0001\u0001\u0007I\u0011B1\u0002\u0011ML'0Z0%KF$\"a\u00132\t\u000f={\u0016\u0011!a\u0001+\"1A\r\u0001Q!\nU\u000bQa]5{K\u0002BqA\u001a\u0001A\u0002\u0013\u0005\u0011&\u0001\u0006mCN$xJ\u001a4tKRDq\u0001\u001b\u0001A\u0002\u0013\u0005\u0011.\u0001\bmCN$xJ\u001a4tKR|F%Z9\u0015\u0005-S\u0007bB(h\u0003\u0003\u0005\rA\u000b\u0005\u0007Y\u0002\u0001\u000b\u0015\u0002\u0016\u0002\u00171\f7\u000f^(gMN,G\u000f\t\u0005\u0006]\u0002!\t!M\u0001\u000b[\u0006DXI\u001c;sS\u0016\u001c\b\"\u00029\u0001\t\u0013\t\u0018A\u0004:fC\u0012d\u0015m\u001d;PM\u001a\u001cX\r\u001e\u000b\u0002U!)1\u000f\u0001C\u0001i\u00061An\\8lkB$\"!\u001e=\u0011\u0005m2\u0018BA<\u0003\u00059yeMZ:fiB{7/\u001b;j_:DQ!\u001f:A\u0002)\nA\u0002^1sO\u0016$xJ\u001a4tKRDQa\u001f\u0001\u0005\nq\fA\"\u001b8eKb\u001cFn\u001c;G_J$BAM?\u0002\u0006!)aP\u001fa\u0001\u007f\u0006\u0019\u0011\u000e\u001a=\u0011\u0007\r\u000b\t!C\u0002\u0002\u0004\u0011\u0013!BQ=uK\n+hMZ3s\u0011\u0015I(\u00101\u0001+\u0011\u001d\tI\u0001\u0001C\u0005\u0003\u0017\taB]3mCRLg/Z(gMN,G\u000fF\u00033\u0003\u001b\t\t\u0002C\u0004\u0002\u0010\u0005\u001d\u0001\u0019A@\u0002\r\t,hMZ3s\u0011\u001d\t\u0019\"a\u0002A\u0002I\n\u0011A\u001c\u0005\b\u0003/\u0001A\u0011BA\r\u0003!\u0001\b._:jG\u0006dG#\u0002\u001a\u0002\u001c\u0005u\u0001bBA\b\u0003+\u0001\ra \u0005\b\u0003'\t)\u00021\u00013\u0011\u001d\t\t\u0003\u0001C\u0001\u0003G\tQ!\u001a8uef$2!^A\u0013\u0011\u001d\t\u0019\"a\bA\u0002IBq!!\u000b\u0001\t\u0003\tY#\u0001\u0004baB,g\u000e\u001a\u000b\u0006\u0017\u00065\u0012\u0011\u0007\u0005\b\u0003_\t9\u00031\u0001+\u0003\u0019ygMZ:fi\"9\u00111GA\u0014\u0001\u0004\u0011\u0014\u0001\u00039pg&$\u0018n\u001c8\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:\u00051\u0011n\u001d$vY2,\"!a\u000f\u0011\u0007]\ti$C\u0002\u0002@a\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002D\u0001!\t!!\u0012\u0002\u0011Q\u0014XO\\2bi\u0016$\u0012a\u0013\u0005\b\u0003\u0013\u0002A\u0011AA&\u0003)!(/\u001e8dCR,Gk\u001c\u000b\u0004\u0017\u00065\u0003bBA\u0018\u0003\u000f\u0002\rA\u000b\u0005\b\u0003#\u0002A\u0011BA*\u0003E!(/\u001e8dCR,Gk\\#oiJLWm\u001d\u000b\u0004\u0017\u0006U\u0003bBA,\u0003\u001f\u0002\rAM\u0001\bK:$(/[3t\u0011\u001d\tY\u0006\u0001C\u0001\u0003\u000b\nq\u0002\u001e:j[R{g+\u00197jINK'0\u001a\u0005\b\u0003?\u0002A\u0011AA1\u0003\u0019\u0011Xm]5{KR\u00191*a\u0019\t\u000f\u0005\u0015\u0014Q\fa\u0001e\u00059a.Z<TSj,\u0007bBA5\u0001\u0011\u0005\u0011QI\u0001\u0006M2,8\u000f\u001b\u0005\b\u0003[\u0002A\u0011AA8\u0003\u0019!W\r\\3uKR\u0011\u00111\b\u0005\b\u0003/\u0002A\u0011AA:)\u0005\u0011\u0004bBA<\u0001\u0011\u0005\u0011QI\u0001\u0006G2|7/\u001a\u0005\b\u0003w\u0002A\u0011BA?\u0003Q\u0011x.\u001e8e)>,\u00050Y2u\u001bVdG/\u001b9mKR)!'a \u0002\u0004\"9\u0011\u0011QA=\u0001\u0004\u0011\u0014A\u00028v[\n,'\u000fC\u0004\u0002\u0006\u0006e\u0004\u0019\u0001\u001a\u0002\r\u0019\f7\r^8s\u000f%\tIIAA\u0001\u0012\u000b\tY)A\u0006PM\u001a\u001cX\r^%oI\u0016D\bcA\u001e\u0002\u000e\u001aI\u0011A\u0001C\u0002\u0002#\u0015\u0011qR\n\u0005\u0003\u001bCa\u0003C\u00049\u0003\u001b#\t!a%\u0015\u0005\u0005-\u0005BCAL\u0003\u001b\u000b\n\u0011\"\u0001\u0002\u001a\u0006q\u0011N\\5uI\u0011,g-Y;mi\u0012\u001aTCAANU\r\u0011\u0014QT\u0016\u0003\u0003?\u0003B!!)\u0002,6\u0011\u00111\u0015\u0006\u0005\u0003K\u000b9+A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0016\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002.\u0006\r&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class OffsetIndex
implements Logging,
ScalaObject {
    private final File file;
    private final long baseOffset;
    private final int maxIndexSize;
    private MappedByteBuffer kafka$log$OffsetIndex$$mmap;
    private AtomicInteger kafka$log$OffsetIndex$$size;
    private long lastOffset;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final int init$default$3() {
        return OffsetIndex$.MODULE$.init$default$3();
    }

    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        OffsetIndex offsetIndex = this;
        synchronized (offsetIndex) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 function0) {
        Logging$class.trace(this, function0);
    }

    public Object trace(Function0 function0) {
        return Logging$class.trace(this, function0);
    }

    public void trace(Function0 function0, Function0 function02) {
        Logging$class.trace(this, function0, function02);
    }

    public void swallowTrace(Function0 function0) {
        Logging$class.swallowTrace(this, function0);
    }

    public void debug(Function0 function0) {
        Logging$class.debug(this, function0);
    }

    public Object debug(Function0 function0) {
        return Logging$class.debug(this, function0);
    }

    public void debug(Function0 function0, Function0 function02) {
        Logging$class.debug(this, function0, function02);
    }

    public void swallowDebug(Function0 function0) {
        Logging$class.swallowDebug(this, function0);
    }

    public void info(Function0 function0) {
        Logging$class.info(this, function0);
    }

    public Object info(Function0 function0) {
        return Logging$class.info(this, function0);
    }

    public void info(Function0 function0, Function0 function02) {
        Logging$class.info(this, function0, function02);
    }

    public void swallowInfo(Function0 function0) {
        Logging$class.swallowInfo(this, function0);
    }

    public void warn(Function0 function0) {
        Logging$class.warn(this, function0);
    }

    public Object warn(Function0 function0) {
        return Logging$class.warn(this, function0);
    }

    public void warn(Function0 function0, Function0 function02) {
        Logging$class.warn(this, function0, function02);
    }

    public void swallowWarn(Function0 function0) {
        Logging$class.swallowWarn(this, function0);
    }

    public void swallow(Function0 function0) {
        Logging$class.swallow(this, function0);
    }

    public void error(Function0 function0) {
        Logging$class.error(this, function0);
    }

    public Object error(Function0 function0) {
        return Logging$class.error(this, function0);
    }

    public void error(Function0 function0, Function0 function02) {
        Logging$class.error(this, function0, function02);
    }

    public void swallowError(Function0 function0) {
        Logging$class.swallowError(this, function0);
    }

    public void fatal(Function0 function0) {
        Logging$class.fatal(this, function0);
    }

    public Object fatal(Function0 function0) {
        return Logging$class.fatal(this, function0);
    }

    public void fatal(Function0 function0, Function0 function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public File file() {
        return this.file;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int maxIndexSize() {
        return this.maxIndexSize;
    }

    public final MappedByteBuffer kafka$log$OffsetIndex$$mmap() {
        return this.kafka$log$OffsetIndex$$mmap;
    }

    private void kafka$log$OffsetIndex$$mmap_$eq(MappedByteBuffer mappedByteBuffer) {
        this.kafka$log$OffsetIndex$$mmap = mappedByteBuffer;
    }

    public final AtomicInteger kafka$log$OffsetIndex$$size() {
        return this.kafka$log$OffsetIndex$$size;
    }

    private void kafka$log$OffsetIndex$$size_$eq(AtomicInteger atomicInteger) {
        this.kafka$log$OffsetIndex$$size = atomicInteger;
    }

    public long lastOffset() {
        return this.lastOffset;
    }

    public void lastOffset_$eq(long l) {
        this.lastOffset = l;
    }

    public int maxEntries() {
        return this.kafka$log$OffsetIndex$$mmap().limit() / 8;
    }

    private long readLastOffset() {
        int n = this.kafka$log$OffsetIndex$$size().get();
        int n2 = n == 0 ? 0 : this.relativeOffset(this.kafka$log$OffsetIndex$$mmap(), n - 1);
        return this.baseOffset() + (long)n2;
    }

    public OffsetPosition lookup(long l) {
        ByteBuffer byteBuffer = this.kafka$log$OffsetIndex$$mmap().duplicate();
        int n = this.indexSlotFor(byteBuffer, l);
        return n == -1 ? new OffsetPosition(this.baseOffset(), 0) : new OffsetPosition(this.baseOffset() + (long)this.relativeOffset(byteBuffer, n), this.physical(byteBuffer, n));
    }

    private int indexSlotFor(ByteBuffer byteBuffer, long l) {
        long l2 = l - this.baseOffset();
        if (this.entries() == 0) {
            return -1;
        }
        if ((long)this.relativeOffset(byteBuffer, 0) > l2) {
            return -1;
        }
        int n = 0;
        int n2 = this.entries() - 1;
        while (n < n2) {
            int n3 = (int)package$.MODULE$.ceil((double)n2 / 2.0 + (double)n / 2.0);
            int n4 = this.relativeOffset(byteBuffer, n3);
            if ((long)n4 == l2) {
                return n3;
            }
            if ((long)n4 < l2) {
                n = n3;
                continue;
            }
            n2 = n3 - 1;
        }
        return n;
    }

    private int relativeOffset(ByteBuffer byteBuffer, int n) {
        return byteBuffer.getInt(n * 8);
    }

    private int physical(ByteBuffer byteBuffer, int n) {
        return byteBuffer.getInt(n * 8 + 4);
    }

    public OffsetPosition entry(int n) {
        if (n >= this.entries()) {
            throw new IllegalArgumentException(Predef$.MODULE$.augmentString("Attempt to fetch the %dth entry from an index of size %d.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)this.entries())})));
        }
        ByteBuffer byteBuffer = this.kafka$log$OffsetIndex$$mmap().duplicate();
        return new OffsetPosition(this.relativeOffset(byteBuffer, n), this.physical(byteBuffer, n));
    }

    public void append(long l, int n) {
        OffsetIndex offsetIndex = this;
        synchronized (offsetIndex) {
            Predef$.MODULE$.require(!this.isFull(), (Function0)new $anonfun$append$1(this));
            if (this.kafka$log$OffsetIndex$$size().get() == 0 || l > this.lastOffset()) {
                this.debug((Function0<String>)new $anonfun$append$2(this, l, n));
                this.kafka$log$OffsetIndex$$mmap().putInt((int)(l - this.baseOffset()));
                this.kafka$log$OffsetIndex$$mmap().putInt(n);
                this.kafka$log$OffsetIndex$$size().incrementAndGet();
                this.lastOffset_$eq(l);
                Predef$.MODULE$.require(this.entries() * 8 == this.kafka$log$OffsetIndex$$mmap().position(), (Function0)new $anonfun$append$3(this));
                return;
            }
            throw new InvalidOffsetException(Predef$.MODULE$.augmentString("Attempt to append an offset (%d) to position %d no larger than the last offset appended (%d) to %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)l), BoxesRunTime.boxToInteger((int)this.entries()), BoxesRunTime.boxToLong((long)this.lastOffset()), this.file().getName()})));
        }
    }

    public boolean isFull() {
        return this.entries() >= this.maxEntries();
    }

    public void truncate() {
        this.truncateToEntries(0);
    }

    public void truncateTo(long l) {
        OffsetIndex offsetIndex = this;
        synchronized (offsetIndex) {
            ByteBuffer byteBuffer = this.kafka$log$OffsetIndex$$mmap().duplicate();
            int n = this.indexSlotFor(byteBuffer, l);
            int n2 = n < 0 ? 0 : ((long)this.relativeOffset(byteBuffer, n) == l - this.baseOffset() ? n : n + 1);
            this.truncateToEntries(n2);
            return;
        }
    }

    private void truncateToEntries(int n) {
        this.kafka$log$OffsetIndex$$size().set(n);
        this.kafka$log$OffsetIndex$$mmap().position(this.kafka$log$OffsetIndex$$size().get() * 8);
        this.lastOffset_$eq(this.readLastOffset());
    }

    public void trimToValidSize() {
        OffsetIndex offsetIndex = this;
        synchronized (offsetIndex) {
            this.resize(this.entries() * 8);
            return;
        }
    }

    public void resize(int n) {
        OffsetIndex offsetIndex = this;
        synchronized (offsetIndex) {
            this.flush();
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.file(), "rws");
            int n2 = this.roundToExactMultiple(n, 8);
            this.liftedTree2$1(randomAccessFile, n2);
            return;
        }
    }

    public void flush() {
        OffsetIndex offsetIndex = this;
        synchronized (offsetIndex) {
            this.kafka$log$OffsetIndex$$mmap().force();
            return;
        }
    }

    public boolean delete() {
        this.info((Function0<String>)new $anonfun$delete$1(this));
        return this.file().delete();
    }

    public int entries() {
        return this.kafka$log$OffsetIndex$$size().get();
    }

    public void close() {
        this.trimToValidSize();
    }

    private int roundToExactMultiple(int n, int n2) {
        return n2 * (n / n2);
    }

    private final MappedByteBuffer liftedTree1$1(boolean bl, RandomAccessFile randomAccessFile) {
        MappedByteBuffer mappedByteBuffer = null;
        try {
            long l;
            if (bl) {
                if (this.maxIndexSize() < 8) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid max index size: ").append((Object)BoxesRunTime.boxToInteger((int)this.maxIndexSize())).toString());
                }
                randomAccessFile.setLength(this.roundToExactMultiple(this.maxIndexSize(), 8));
            }
            if ((l = randomAccessFile.length()) < 0L || l % 8L != 0L) {
                throw new IllegalStateException(new StringBuilder().append((Object)"Index file ").append((Object)this.file().getName()).append((Object)" is corrupt, found ").append((Object)BoxesRunTime.boxToLong((long)l)).append((Object)" bytes which is not positive or not a multiple of 8.").toString());
            }
            MappedByteBuffer mappedByteBuffer2 = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, l);
            Buffer buffer = bl ? mappedByteBuffer2.position(0) : mappedByteBuffer2.position(this.roundToExactMultiple(mappedByteBuffer2.limit(), 8));
            mappedByteBuffer = mappedByteBuffer2;
            return mappedByteBuffer;
        }
        finally {
            Utils$.MODULE$.swallow((Function0<Object>)new $anonfun$liftedTree1$1$1(this, randomAccessFile));
        }
    }

    private final Buffer liftedTree2$1(RandomAccessFile randomAccessFile, int n) {
        Buffer buffer = null;
        try {
            randomAccessFile.setLength(n);
            int n2 = this.kafka$log$OffsetIndex$$mmap().position();
            this.kafka$log$OffsetIndex$$mmap_$eq(randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, n));
            buffer = this.kafka$log$OffsetIndex$$mmap().position(n2);
            return buffer;
        }
        finally {
            Utils$.MODULE$.swallow((Function0<Object>)new $anonfun$liftedTree2$1$1(this, randomAccessFile));
        }
    }

    public OffsetIndex(File file, long l, int n) {
        this.file = file;
        this.baseOffset = l;
        this.maxIndexSize = n;
        Logging$class.$init$(this);
        boolean bl = file.createNewFile();
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        this.kafka$log$OffsetIndex$$mmap = this.liftedTree1$1(bl, randomAccessFile);
        this.kafka$log$OffsetIndex$$size = new AtomicInteger(this.kafka$log$OffsetIndex$$mmap().position() / 8);
        this.lastOffset = this.readLastOffset();
        this.debug((Function0<String>)new $anonfun$1(this));
    }
}

