/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import kafka.network.BoundedByteBufferReceive$;
import kafka.network.InvalidRequestException;
import kafka.network.Receive;
import kafka.network.Receive$class;
import kafka.network.Transmission$class;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001!4\u0011\"\u0001\u0002\u0005\u0002\u0003\u0005\t\u0001\u0002\u0004\u00031\t{WO\u001c3fI\nKH/\u001a\"vM\u001a,'OU3dK&4XM\u0003\u0002\u0004\t\u00059a.\u001a;x_J\\'\"A\u0003\u0002\u000b-\fgm[1\u0014\u000b\u00019qbE\r\u0011\u0005!iQ\"A\u0005\u000b\u0005)Y\u0011\u0001\u00027b]\u001eT\u0011\u0001D\u0001\u0005U\u00064\u0018-\u0003\u0002\u000f\u0013\t1qJ\u00196fGR\u0004\"\u0001E\t\u000e\u0003\tI!A\u0005\u0002\u0003\u000fI+7-Z5wKB\u0011AcF\u0007\u0002+)\u0011a\u0003B\u0001\u0006kRLGn]\u0005\u00031U\u0011q\u0001T8hO&tw\r\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2DA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002\u0003\u0011\u0001\u0005\u000b\u0007I\u0011\u0001\u0012\u0002\u000f5\f\u0007pU5{K\u000e\u0001Q#A\u0012\u0011\u0005i!\u0013BA\u0013\u001c\u0005\rIe\u000e\u001e\u0005\tO\u0001\u0011\t\u0011)A\u0005G\u0005AQ.\u0019=TSj,\u0007\u0005C\u0003*\u0001\u0011\u0005!&\u0001\u0004=S:LGO\u0010\u000b\u0003W1\u0002\"\u0001\u0005\u0001\t\u000b\u0001B\u0003\u0019A\u0012\t\u000f9\u0002!\u0019!C\u0005_\u0005Q1/\u001b>f\u0005V4g-\u001a:\u0016\u0003A\u0002\"!\r\u001b\u000e\u0003IR!aM\u0006\u0002\u00079Lw.\u0003\u00026e\tQ!)\u001f;f\u0005V4g-\u001a:\t\r]\u0002\u0001\u0015!\u00031\u0003-\u0019\u0018N_3Ck\u001a4WM\u001d\u0011\t\u000fe\u0002\u0001\u0019!C\u0005_\u0005i1m\u001c8uK:$()\u001e4gKJDqa\u000f\u0001A\u0002\u0013%A(A\td_:$XM\u001c;Ck\u001a4WM]0%KF$\"!\u0010!\u0011\u0005iq\u0014BA \u001c\u0005\u0011)f.\u001b;\t\u000f\u0005S\u0014\u0011!a\u0001a\u0005\u0019\u0001\u0010J\u0019\t\r\r\u0003\u0001\u0015)\u00031\u00039\u0019wN\u001c;f]R\u0014UO\u001a4fe\u0002BQ!\u000b\u0001\u0005\u0002\u0015#\u0012a\u000b\u0005\b\u000f\u0002\u0001\r\u0011\"\u0001I\u0003!\u0019w.\u001c9mKR,W#A%\u0011\u0005iQ\u0015BA&\u001c\u0005\u001d\u0011un\u001c7fC:Dq!\u0014\u0001A\u0002\u0013\u0005a*\u0001\u0007d_6\u0004H.\u001a;f?\u0012*\u0017\u000f\u0006\u0002>\u001f\"9\u0011\tTA\u0001\u0002\u0004I\u0005BB)\u0001A\u0003&\u0011*A\u0005d_6\u0004H.\u001a;fA!)1\u000b\u0001C\u0001_\u00051!-\u001e4gKJDQ!\u0016\u0001\u0005\u0002Y\u000b\u0001B]3bI\u001a\u0013x.\u001c\u000b\u0003G]CQ\u0001\u0017+A\u0002e\u000bqa\u00195b]:,G\u000e\u0005\u0002[;6\t1L\u0003\u0002]e\u0005A1\r[1o]\u0016d7/\u0003\u0002_7\n\u0019\"+Z1eC\ndWMQ=uK\u000eC\u0017M\u001c8fY\")\u0001\r\u0001C\u0005C\u0006\u0011\"-\u001f;f\u0005V4g-\u001a:BY2|7-\u0019;f)\t\u0001$\rC\u0003d?\u0002\u00071%\u0001\u0003tSj,\u0007F\u0001\u0001f!\t!b-\u0003\u0002h+\tian\u001c8uQJ,\u0017\rZ:bM\u0016\u0004")
public class BoundedByteBufferReceive
implements Receive,
Logging,
ScalaObject {
    private final int maxSize;
    private final ByteBuffer sizeBuffer;
    private ByteBuffer contentBuffer;
    private boolean complete;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public int readCompletely(ReadableByteChannel readableByteChannel) {
        return Receive$class.readCompletely(this, readableByteChannel);
    }

    public void expectIncomplete() {
        Transmission$class.expectIncomplete(this);
    }

    public void expectComplete() {
        Transmission$class.expectComplete(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        BoundedByteBufferReceive boundedByteBufferReceive = this;
        synchronized (boundedByteBufferReceive) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 function0) {
        Logging$class.trace(this, function0);
    }

    public Object trace(Function0 function0) {
        return Logging$class.trace(this, function0);
    }

    public void trace(Function0 function0, Function0 function02) {
        Logging$class.trace(this, function0, function02);
    }

    public void swallowTrace(Function0 function0) {
        Logging$class.swallowTrace(this, function0);
    }

    public void debug(Function0 function0) {
        Logging$class.debug(this, function0);
    }

    public Object debug(Function0 function0) {
        return Logging$class.debug(this, function0);
    }

    public void debug(Function0 function0, Function0 function02) {
        Logging$class.debug(this, function0, function02);
    }

    public void swallowDebug(Function0 function0) {
        Logging$class.swallowDebug(this, function0);
    }

    public void info(Function0 function0) {
        Logging$class.info(this, function0);
    }

    public Object info(Function0 function0) {
        return Logging$class.info(this, function0);
    }

    public void info(Function0 function0, Function0 function02) {
        Logging$class.info(this, function0, function02);
    }

    public void swallowInfo(Function0 function0) {
        Logging$class.swallowInfo(this, function0);
    }

    public void warn(Function0 function0) {
        Logging$class.warn(this, function0);
    }

    public Object warn(Function0 function0) {
        return Logging$class.warn(this, function0);
    }

    public void warn(Function0 function0, Function0 function02) {
        Logging$class.warn(this, function0, function02);
    }

    public void swallowWarn(Function0 function0) {
        Logging$class.swallowWarn(this, function0);
    }

    public void swallow(Function0 function0) {
        Logging$class.swallow(this, function0);
    }

    public void error(Function0 function0) {
        Logging$class.error(this, function0);
    }

    public Object error(Function0 function0) {
        return Logging$class.error(this, function0);
    }

    public void error(Function0 function0, Function0 function02) {
        Logging$class.error(this, function0, function02);
    }

    public void swallowError(Function0 function0) {
        Logging$class.swallowError(this, function0);
    }

    public void fatal(Function0 function0) {
        Logging$class.fatal(this, function0);
    }

    public Object fatal(Function0 function0) {
        return Logging$class.fatal(this, function0);
    }

    public void fatal(Function0 function0, Function0 function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public int maxSize() {
        return this.maxSize;
    }

    private ByteBuffer sizeBuffer() {
        return this.sizeBuffer;
    }

    private ByteBuffer contentBuffer() {
        return this.contentBuffer;
    }

    private void contentBuffer_$eq(ByteBuffer byteBuffer) {
        this.contentBuffer = byteBuffer;
    }

    public BoundedByteBufferReceive() {
        this(Integer.MAX_VALUE);
    }

    public boolean complete() {
        return this.complete;
    }

    public void complete_$eq(boolean bl) {
        this.complete = bl;
    }

    public ByteBuffer buffer() {
        this.expectComplete();
        return this.contentBuffer();
    }

    public int readFrom(ReadableByteChannel readableByteChannel) {
        this.expectIncomplete();
        int n = 0;
        if (this.sizeBuffer().remaining() > 0) {
            n += Utils$.MODULE$.read(readableByteChannel, this.sizeBuffer());
        }
        if (this.contentBuffer() == null && !this.sizeBuffer().hasRemaining()) {
            this.sizeBuffer().rewind();
            int n2 = this.sizeBuffer().getInt();
            if (n2 <= 0) {
                throw new InvalidRequestException(Predef$.MODULE$.augmentString("%d is not a valid request size.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n2)})));
            }
            if (n2 > this.maxSize()) {
                throw new InvalidRequestException(Predef$.MODULE$.augmentString("Request of length %d is not valid, it is larger than the maximum size of %d bytes.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n2), BoxesRunTime.boxToInteger((int)this.maxSize())})));
            }
            this.contentBuffer_$eq(this.byteBufferAllocate(n2));
        }
        if (this.contentBuffer() != null) {
            n = Utils$.MODULE$.read(readableByteChannel, this.contentBuffer());
            if (!this.contentBuffer().hasRemaining()) {
                this.contentBuffer().rewind();
                this.complete_$eq(true);
            }
        }
        return n;
    }

    private ByteBuffer byteBufferAllocate(int n) {
        ByteBuffer byteBuffer = null;
        try {
            byteBuffer = ByteBuffer.allocate(n);
            return byteBuffer;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.error((Function0<String>)new $anonfun$byteBufferAllocate$1(this, n), (Function0<Throwable>)new $anonfun$byteBufferAllocate$2(this, outOfMemoryError));
            throw outOfMemoryError;
        }
    }

    public BoundedByteBufferReceive(int n) {
        this.maxSize = n;
        Logging$class.$init$(this);
        Transmission$class.$init$(this);
        Receive$class.$init$(this);
        this.sizeBuffer = ByteBuffer.allocate(4);
        this.contentBuffer = null;
        this.complete = false;
    }
}

