/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.TopicMetadata;
import kafka.metrics.KafkaMetricsReporter$;
import kafka.producer.KeyedMessage;
import kafka.producer.Partitioner;
import kafka.producer.Producer$;
import kafka.producer.ProducerClosedException;
import kafka.producer.ProducerConfig;
import kafka.producer.ProducerPool;
import kafka.producer.ProducerTopicStats;
import kafka.producer.ProducerTopicStatsRegistry$;
import kafka.producer.async.DefaultEventHandler;
import kafka.producer.async.DefaultEventHandler$;
import kafka.producer.async.EventHandler;
import kafka.producer.async.ProducerSendThread;
import kafka.serializer.Encoder;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0002\u0015:pIV\u001cWM\u001d\u0006\u0003\u0007\u0011\t\u0001\u0002\u001d:pIV\u001cWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u0001Qc\u0001\u00052wM!\u0001!C\t\u0018!\tQq\"D\u0001\f\u0015\taQ\"\u0001\u0003mC:<'\"\u0001\b\u0002\t)\fg/Y\u0005\u0003!-\u0011aa\u00142kK\u000e$\bC\u0001\n\u0016\u001b\u0005\u0019\"B\u0001\u000b\u0005\u0003\u0015)H/\u001b7t\u0013\t12CA\u0004M_\u001e<\u0017N\\4\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t=\u0001\u0011)\u0019!C\u0001?\u000511m\u001c8gS\u001e,\u0012\u0001\t\t\u0003C\tj\u0011AA\u0005\u0003G\t\u0011a\u0002\u0015:pIV\u001cWM]\"p]\u001aLw\r\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003!\u0003\u001d\u0019wN\u001c4jO\u0002B\u0001b\n\u0001\u0003\u0006\u0004%I\u0001K\u0001\rKZ,g\u000e\u001e%b]\u0012dWM]\u000b\u0002SA!!&L\u0018;\u001b\u0005Y#B\u0001\u0017\u0003\u0003\u0015\t7/\u001f8d\u0013\tq3F\u0001\u0007Fm\u0016tG\u000fS1oI2,'\u000f\u0005\u00021c1\u0001A\u0001\u0003\u001a\u0001\t\u0003\u0005)\u0019A\u001a\u0003\u0003-\u000b\"\u0001N\u001c\u0011\u0005a)\u0014B\u0001\u001c\u001a\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\u0007\u001d\n\u0005eJ\"aA!osB\u0011\u0001g\u000f\u0003\ty\u0001!\t\u0011!b\u0001g\t\ta\u000b\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003*\u00035)g/\u001a8u\u0011\u0006tG\r\\3sA!)\u0001\t\u0001C\u0001\u0003\u00061A(\u001b8jiz\"2AQ\"E!\u0011\t\u0003a\f\u001e\t\u000byy\u0004\u0019\u0001\u0011\t\u000b\u001dz\u0004\u0019A\u0015\t\u000f\u0019\u0003!\u0019!C\u0005\u000f\u0006Y\u0001.Y:TQV$Hm\\<o+\u0005A\u0005CA%Q\u001b\u0005Q%BA&M\u0003\u0019\tGo\\7jG*\u0011QJT\u0001\u000bG>t7-\u001e:sK:$(BA(\u000e\u0003\u0011)H/\u001b7\n\u0005ES%!D!u_6L7MQ8pY\u0016\fg\u000e\u0003\u0004T\u0001\u0001\u0006I\u0001S\u0001\rQ\u0006\u001c8\u000b[;uI><h\u000e\t\u0005\b+\u0002\u0011\r\u0011\"\u0003W\u0003\u0015\tX/Z;f+\u00059\u0006c\u0001-Z76\tA*\u0003\u0002[\u0019\n\u0019B*\u001b8lK\u0012\u0014En\\2lS:<\u0017+^3vKB!\u0011\u0005X\u0018;\u0013\ti&A\u0001\u0007LKf,G-T3tg\u0006<W\r\u0003\u0004`\u0001\u0001\u0006IaV\u0001\u0007cV,W/\u001a\u0011\t\u000f\u0005\u0004!\u0019!C\u0005E\u00061!/\u00198e_6,\u0012a\u0019\t\u0003I\u0016l\u0011AT\u0005\u0003M:\u0013aAU1oI>l\u0007B\u00025\u0001A\u0003%1-A\u0004sC:$w.\u001c\u0011\t\u000f)\u0004\u0001\u0019!C\u0005W\u0006!1/\u001f8d+\u0005a\u0007C\u0001\rn\u0013\tq\u0017DA\u0004C_>dW-\u00198\t\u000fA\u0004\u0001\u0019!C\u0005c\u0006A1/\u001f8d?\u0012*\u0017\u000f\u0006\u0002skB\u0011\u0001d]\u0005\u0003if\u0011A!\u00168ji\"9ao\\A\u0001\u0002\u0004a\u0017a\u0001=%c!1\u0001\u0010\u0001Q!\n1\fQa]=oG\u0002BqA\u001f\u0001A\u0002\u0013%10\u0001\nqe>$WoY3s'\u0016tG\r\u00165sK\u0006$W#\u0001?\u0011\t)jxFO\u0005\u0003}.\u0012!\u0003\u0015:pIV\u001cWM]*f]\u0012$\u0006N]3bI\"I\u0011\u0011\u0001\u0001A\u0002\u0013%\u00111A\u0001\u0017aJ|G-^2feN+g\u000e\u001a+ie\u0016\fGm\u0018\u0013fcR\u0019!/!\u0002\t\u000fY|\u0018\u0011!a\u0001y\"9\u0011\u0011\u0002\u0001!B\u0013a\u0018a\u00059s_\u0012,8-\u001a:TK:$G\u000b\u001b:fC\u0012\u0004\u0003\"CA\u0007\u0001\t\u0007I\u0011BA\b\u0003I\u0001(o\u001c3vG\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0016\u0005\u0005E\u0001cA\u0011\u0002\u0014%\u0019\u0011Q\u0003\u0002\u0003%A\u0013x\u000eZ;dKJ$v\u000e]5d'R\fGo\u001d\u0005\t\u00033\u0001\u0001\u0015!\u0003\u0002\u0012\u0005\u0019\u0002O]8ek\u000e,'\u000fV8qS\u000e\u001cF/\u0019;tA!1\u0001\t\u0001C\u0001\u0003;!2AQA\u0010\u0011\u0019q\u00121\u0004a\u0001A!9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0012\u0001B:f]\u0012$2A]A\u0014\u0011!\tI#!\tA\u0002\u0005-\u0012\u0001C7fgN\fw-Z:\u0011\ta\ticW\u0005\u0004\u0003_I\"A\u0003\u001fsKB,\u0017\r^3e}!9\u00111\u0007\u0001\u0005\n\u0005U\u0012a\u0003:fG>\u0014Hm\u0015;biN$2A]A\u001c\u0011!\tI#!\rA\u0002\u0005e\u0002#BA\u001e\u0003\u0017Zf\u0002BA\u001f\u0003\u000frA!a\u0010\u0002F5\u0011\u0011\u0011\t\u0006\u0004\u0003\u00072\u0011A\u0002\u001fs_>$h(C\u0001\u001b\u0013\r\tI%G\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti%a\u0014\u0003\u0007M+\u0017OC\u0002\u0002JeAq!a\u0015\u0001\t\u0013\t)&A\u0005bgft7mU3oIR\u0019!/a\u0016\t\u0011\u0005%\u0012\u0011\u000ba\u0001\u0003sAq!a\u0017\u0001\t\u0003\ti&A\u0003dY>\u001cX\rF\u0001s\u0001")
public class Producer<K, V>
implements Logging,
ScalaObject {
    private final ProducerConfig config;
    private final EventHandler<K, V> eventHandler;
    private final AtomicBoolean hasShutdown;
    private final LinkedBlockingQueue kafka$producer$Producer$$queue;
    private final Random random;
    private boolean sync;
    private ProducerSendThread<K, V> producerSendThread;
    private final ProducerTopicStats kafka$producer$Producer$$producerTopicStats;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        Producer producer = this;
        synchronized (producer) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 function0) {
        Logging$class.trace(this, function0);
    }

    public Object trace(Function0 function0) {
        return Logging$class.trace(this, function0);
    }

    public void trace(Function0 function0, Function0 function02) {
        Logging$class.trace(this, function0, function02);
    }

    public void swallowTrace(Function0 function0) {
        Logging$class.swallowTrace(this, function0);
    }

    public void debug(Function0 function0) {
        Logging$class.debug(this, function0);
    }

    public Object debug(Function0 function0) {
        return Logging$class.debug(this, function0);
    }

    public void debug(Function0 function0, Function0 function02) {
        Logging$class.debug(this, function0, function02);
    }

    public void swallowDebug(Function0 function0) {
        Logging$class.swallowDebug(this, function0);
    }

    public void info(Function0 function0) {
        Logging$class.info(this, function0);
    }

    public Object info(Function0 function0) {
        return Logging$class.info(this, function0);
    }

    public void info(Function0 function0, Function0 function02) {
        Logging$class.info(this, function0, function02);
    }

    public void swallowInfo(Function0 function0) {
        Logging$class.swallowInfo(this, function0);
    }

    public void warn(Function0 function0) {
        Logging$class.warn(this, function0);
    }

    public Object warn(Function0 function0) {
        return Logging$class.warn(this, function0);
    }

    public void warn(Function0 function0, Function0 function02) {
        Logging$class.warn(this, function0, function02);
    }

    public void swallowWarn(Function0 function0) {
        Logging$class.swallowWarn(this, function0);
    }

    public void swallow(Function0 function0) {
        Logging$class.swallow(this, function0);
    }

    public void error(Function0 function0) {
        Logging$class.error(this, function0);
    }

    public Object error(Function0 function0) {
        return Logging$class.error(this, function0);
    }

    public void error(Function0 function0, Function0 function02) {
        Logging$class.error(this, function0, function02);
    }

    public void swallowError(Function0 function0) {
        Logging$class.swallowError(this, function0);
    }

    public void fatal(Function0 function0) {
        Logging$class.fatal(this, function0);
    }

    public Object fatal(Function0 function0) {
        return Logging$class.fatal(this, function0);
    }

    public void fatal(Function0 function0, Function0 function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public ProducerConfig config() {
        return this.config;
    }

    private EventHandler<K, V> eventHandler() {
        return this.eventHandler;
    }

    private AtomicBoolean hasShutdown() {
        return this.hasShutdown;
    }

    public final LinkedBlockingQueue kafka$producer$Producer$$queue() {
        return this.kafka$producer$Producer$$queue;
    }

    private Random random() {
        return this.random;
    }

    private boolean sync() {
        return this.sync;
    }

    private void sync_$eq(boolean bl) {
        this.sync = bl;
    }

    private ProducerSendThread<K, V> producerSendThread() {
        return this.producerSendThread;
    }

    private void producerSendThread_$eq(ProducerSendThread<K, V> producerSendThread) {
        this.producerSendThread = producerSendThread;
    }

    public final ProducerTopicStats kafka$producer$Producer$$producerTopicStats() {
        return this.kafka$producer$Producer$$producerTopicStats;
    }

    public Producer(ProducerConfig producerConfig) {
        this(producerConfig, new DefaultEventHandler(producerConfig, (Partitioner)Utils$.MODULE$.createObject(producerConfig.partitionerClass(), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{producerConfig.props()})), (Encoder)Utils$.MODULE$.createObject(producerConfig.serializerClass(), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{producerConfig.props()})), (Encoder)Utils$.MODULE$.createObject(producerConfig.keySerializerClass(), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{producerConfig.props()})), new ProducerPool(producerConfig), (HashMap<String, TopicMetadata>)DefaultEventHandler$.MODULE$.init$default$6()));
    }

    public void send(Seq<KeyedMessage<K, V>> seq) {
        boolean bl;
        block6: {
            block5: {
                block4: {
                    if (this.hasShutdown().get()) {
                        throw new ProducerClosedException();
                    }
                    this.recordStats(seq);
                    bl = this.sync();
                    if (!bl) break block4;
                    this.eventHandler().handle(seq);
                    break block5;
                }
                if (bl) break block6;
                this.asyncSend(seq);
            }
            return;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private void recordStats(Seq<KeyedMessage<K, V>> seq) {
        seq.foreach((Function1)new $anonfun$recordStats$1(this));
    }

    private void asyncSend(Seq<KeyedMessage<K, V>> seq) {
        seq.foreach((Function1)new $anonfun$asyncSend$1(this));
    }

    public void close() {
        boolean bl = this.hasShutdown().compareAndSet(false, true);
        if (bl) {
            this.info((Function0<String>)new $anonfun$close$1(this));
            if (this.producerSendThread() != null) {
                this.producerSendThread().shutdown();
            }
            this.eventHandler().close();
        }
    }

    public Producer(ProducerConfig producerConfig, EventHandler<K, V> eventHandler) {
        String string;
        block3: {
            block2: {
                this.config = producerConfig;
                this.eventHandler = eventHandler;
                Logging$class.$init$(this);
                this.hasShutdown = new AtomicBoolean(false);
                this.kafka$producer$Producer$$queue = new LinkedBlockingQueue(producerConfig.queueBufferingMaxMessages());
                this.random = new Random();
                this.sync = true;
                this.producerSendThread = null;
                String string2 = string = producerConfig.producerType();
                String string3 = "sync";
                if (!(string2 == null ? string3 != null : !string2.equals(string3))) break block2;
                String string4 = string;
                String string5 = "async";
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block3;
                this.sync_$eq(false);
                this.producerSendThread_$eq(new ProducerSendThread<K, V>(new StringBuilder().append((Object)"ProducerSendThread-").append((Object)producerConfig.clientId()).toString(), this.kafka$producer$Producer$$queue(), eventHandler, producerConfig.queueBufferingMaxMs(), producerConfig.batchNumMessages(), producerConfig.clientId()));
                this.producerSendThread().start();
            }
            this.kafka$producer$Producer$$producerTopicStats = ProducerTopicStatsRegistry$.MODULE$.getProducerTopicStats(producerConfig.clientId());
            KafkaMetricsReporter$.MODULE$.startReporters(producerConfig.props());
            return;
        }
        throw new MatchError(string);
    }
}

