/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer.async;

import java.util.concurrent.atomic.AtomicInteger;
import kafka.api.ProducerRequest;
import kafka.api.ProducerResponse;
import kafka.api.TopicMetadata;
import kafka.common.FailedToSendMessageException;
import kafka.common.KafkaException;
import kafka.common.LeaderNotAvailableException;
import kafka.common.NoBrokersForPartitionException;
import kafka.common.TopicAndPartition;
import kafka.common.UnknownTopicOrPartitionException;
import kafka.message.ByteBufferMessageSet;
import kafka.message.Message;
import kafka.producer.BrokerPartitionInfo;
import kafka.producer.KeyedMessage;
import kafka.producer.PartitionAndLeader;
import kafka.producer.Partitioner;
import kafka.producer.ProducerConfig;
import kafka.producer.ProducerPool;
import kafka.producer.ProducerStats;
import kafka.producer.ProducerStatsRegistry$;
import kafka.producer.ProducerTopicStats;
import kafka.producer.ProducerTopicStatsRegistry$;
import kafka.producer.SyncProducer;
import kafka.producer.async.DefaultEventHandler$;
import kafka.producer.async.DefaultEventHandler$$anonfun$kafka$producer$async$DefaultEventHandler$;
import kafka.producer.async.EventHandler;
import kafka.serializer.Encoder;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.SystemTime$;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t}d\u0001B\u0001\u0003\u0001%\u00111\u0003R3gCVdG/\u0012<f]RD\u0015M\u001c3mKJT!a\u0001\u0003\u0002\u000b\u0005\u001c\u0018P\\2\u000b\u0005\u00151\u0011\u0001\u00039s_\u0012,8-\u001a:\u000b\u0003\u001d\tQa[1gW\u0006\u001c\u0001!F\u0002\u000b3\u0019\u001aR\u0001A\u0006\u0014Q9\u0002\"\u0001D\t\u000e\u00035Q!AD\b\u0002\t1\fgn\u001a\u0006\u0002!\u0005!!.\u0019<b\u0013\t\u0011RB\u0001\u0004PE*,7\r\u001e\t\u0005)U9R%D\u0001\u0003\u0013\t1\"A\u0001\u0007Fm\u0016tG\u000fS1oI2,'\u000f\u0005\u0002\u001931\u0001A\u0001\u0003\u000e\u0001\t\u0003\u0005)\u0019A\u000e\u0003\u0003-\u000b\"\u0001\b\u0012\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0003}\tQa]2bY\u0006L!!\t\u0010\u0003\u000f9{G\u000f[5oOB\u0011QdI\u0005\u0003Iy\u00111!\u00118z!\tAb\u0005\u0002\u0005(\u0001\u0011\u0005\tQ1\u0001\u001c\u0005\u00051\u0006CA\u0015-\u001b\u0005Q#BA\u0016\u0007\u0003\u0015)H/\u001b7t\u0013\ti#FA\u0004M_\u001e<\u0017N\\4\u0011\u0005uy\u0013B\u0001\u0019\u001f\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011I\u0002!\u0011!Q\u0001\nM\naaY8oM&<\u0007C\u0001\u001b6\u001b\u0005!\u0011B\u0001\u001c\u0005\u00059\u0001&o\u001c3vG\u0016\u00148i\u001c8gS\u001eD\u0001\u0002\u000f\u0001\u0003\u0006\u0004%I!O\u0001\fa\u0006\u0014H/\u001b;j_:,'/F\u0001;!\r!4hF\u0005\u0003y\u0011\u00111\u0002U1si&$\u0018n\u001c8fe\"Aa\b\u0001B\u0001B\u0003%!(\u0001\u0007qCJ$\u0018\u000e^5p]\u0016\u0014\b\u0005\u0003\u0005A\u0001\t\u0015\r\u0011\"\u0003B\u0003\u001d)gnY8eKJ,\u0012A\u0011\t\u0004\u0007\u001a+S\"\u0001#\u000b\u0005\u00153\u0011AC:fe&\fG.\u001b>fe&\u0011q\t\u0012\u0002\b\u000b:\u001cw\u000eZ3s\u0011!I\u0005A!A!\u0002\u0013\u0011\u0015\u0001C3oG>$WM\u001d\u0011\t\u0011-\u0003!Q1A\u0005\n1\u000b!b[3z\u000b:\u001cw\u000eZ3s+\u0005i\u0005cA\"G/!Aq\n\u0001B\u0001B\u0003%Q*A\u0006lKf,enY8eKJ\u0004\u0003\u0002C)\u0001\u0005\u000b\u0007I\u0011\u0002*\u0002\u0019A\u0014x\u000eZ;dKJ\u0004vn\u001c7\u0016\u0003M\u0003\"\u0001\u000e+\n\u0005U#!\u0001\u0004)s_\u0012,8-\u001a:Q_>d\u0007\u0002C,\u0001\u0005\u0003\u0005\u000b\u0011B*\u0002\u001bA\u0014x\u000eZ;dKJ\u0004vn\u001c7!\u0011!I\u0006A!b\u0001\n\u0013Q\u0016a\u0005;pa&\u001c\u0007+\u0019:uSRLwN\\%oM>\u001cX#A.\u0011\tq\u000b7M[\u0007\u0002;*\u0011alX\u0001\b[V$\u0018M\u00197f\u0015\t\u0001g$\u0001\u0006d_2dWm\u0019;j_:L!AY/\u0003\u000f!\u000b7\u000f['baB\u0011Am\u001a\b\u0003;\u0015L!A\u001a\u0010\u0002\rA\u0013X\rZ3g\u0013\tA\u0017N\u0001\u0004TiJLgn\u001a\u0006\u0003Mz\u0001\"a\u001b8\u000e\u00031T!!\u001c\u0004\u0002\u0007\u0005\u0004\u0018.\u0003\u0002pY\niAk\u001c9jG6+G/\u00193bi\u0006D\u0001\"\u001d\u0001\u0003\u0002\u0003\u0006IaW\u0001\u0015i>\u0004\u0018n\u0019)beRLG/[8o\u0013:4wn\u001d\u0011\t\u000bM\u0004A\u0011\u0001;\u0002\rqJg.\u001b;?)\u001d)ho\u001e=zun\u0004B\u0001\u0006\u0001\u0018K!)!G\u001da\u0001g!)\u0001H\u001da\u0001u!)\u0001I\u001da\u0001\u0005\")1J\u001da\u0001\u001b\")\u0011K\u001da\u0001'\"9\u0011L\u001dI\u0001\u0002\u0004Y\u0006bB?\u0001\u0005\u0004%\tA`\u0001\u0007SN\u001c\u0016P\\2\u0016\u0003}\u00042!HA\u0001\u0013\r\t\u0019A\b\u0002\b\u0005>|G.Z1o\u0011\u001d\t9\u0001\u0001Q\u0001\n}\fq![:Ts:\u001c\u0007\u0005C\u0005\u0002\f\u0001\u0011\r\u0011\"\u0001\u0002\u000e\u0005\u0001\u0002/\u0019:uSRLwN\\\"pk:$XM]\u000b\u0003\u0003\u001f\u0001B!!\u0005\u0002 5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u00033\tY\"\u0001\u0006d_:\u001cWO\u001d:f]RT1!!\b\u0010\u0003\u0011)H/\u001b7\n\t\u0005\u0005\u00121\u0003\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\t\u0011\u0005\u0015\u0002\u0001)A\u0005\u0003\u001f\t\u0011\u0003]1si&$\u0018n\u001c8D_VtG/\u001a:!\u0011%\tI\u0003\u0001b\u0001\n\u0003\ti!A\u0007d_J\u0014X\r\\1uS>t\u0017\n\u001a\u0005\t\u0003[\u0001\u0001\u0015!\u0003\u0002\u0010\u0005q1m\u001c:sK2\fG/[8o\u0013\u0012\u0004\u0003\"CA\u0019\u0001\t\u0007I\u0011AA\u001a\u0003M\u0011'o\\6feB\u000b'\u000f^5uS>t\u0017J\u001c4p+\t\t)\u0004E\u00025\u0003oI1!!\u000f\u0005\u0005M\u0011%o\\6feB\u000b'\u000f^5uS>t\u0017J\u001c4p\u0011!\ti\u0004\u0001Q\u0001\n\u0005U\u0012\u0001\u00062s_.,'\u000fU1si&$\u0018n\u001c8J]\u001a|\u0007\u0005C\u0005\u0002B\u0001\u0011\r\u0011\"\u0003\u0002D\u0005!An\\2l+\u0005Y\u0001bBA$\u0001\u0001\u0006IaC\u0001\u0006Y>\u001c7\u000e\t\u0005\n\u0003\u0017\u0002!\u0019!C\u0005\u0003\u001b\nA\u0004^8qS\u000elU\r^1eCR\f'+\u001a4sKND\u0017J\u001c;feZ\fG.\u0006\u0002\u0002PA\u0019Q$!\u0015\n\u0007\u0005McDA\u0002J]RD\u0001\"a\u0016\u0001A\u0003%\u0011qJ\u0001\u001ei>\u0004\u0018nY'fi\u0006$\u0017\r^1SK\u001a\u0014Xm\u001d5J]R,'O^1mA!I\u00111\f\u0001A\u0002\u0013%\u0011QL\u0001\u001dY\u0006\u001cH\u000fV8qS\u000elU\r^1eCR\f'+\u001a4sKNDG+[7f+\t\ty\u0006E\u0002\u001e\u0003CJ1!a\u0019\u001f\u0005\u0011auN\\4\t\u0013\u0005\u001d\u0004\u00011A\u0005\n\u0005%\u0014\u0001\t7bgR$v\u000e]5d\u001b\u0016$\u0018\rZ1uCJ+gM]3tQRKW.Z0%KF$B!a\u001b\u0002rA\u0019Q$!\u001c\n\u0007\u0005=dD\u0001\u0003V]&$\bBCA:\u0003K\n\t\u00111\u0001\u0002`\u0005\u0019\u0001\u0010J\u0019\t\u0011\u0005]\u0004\u0001)Q\u0005\u0003?\nQ\u0004\\1tiR{\u0007/[2NKR\fG-\u0019;b%\u00164'/Z:i)&lW\r\t\u0005\n\u0003w\u0002!\u0019!C\u0005\u0003{\na\u0003^8qS\u000elU\r^1eCR\fGk\u001c*fMJ,7\u000f[\u000b\u0003\u0003\u007f\u0002B\u0001XAAG&\u0019\u00111Q/\u0003\u0007M+G\u000f\u0003\u0005\u0002\b\u0002\u0001\u000b\u0011BA@\u0003]!x\u000e]5d\u001b\u0016$\u0018\rZ1uCR{'+\u001a4sKND\u0007\u0005C\u0005\u0002\f\u0002\u0011\r\u0011\"\u0003\u0002\u000e\u0006i\u0001O]8ek\u000e,'o\u0015;biN,\"!a$\u0011\u0007Q\n\t*C\u0002\u0002\u0014\u0012\u0011Q\u0002\u0015:pIV\u001cWM]*uCR\u001c\b\u0002CAL\u0001\u0001\u0006I!a$\u0002\u001dA\u0014x\u000eZ;dKJ\u001cF/\u0019;tA!I\u00111\u0014\u0001C\u0002\u0013%\u0011QT\u0001\u0013aJ|G-^2feR{\u0007/[2Ti\u0006$8/\u0006\u0002\u0002 B\u0019A'!)\n\u0007\u0005\rFA\u0001\nQe>$WoY3s)>\u0004\u0018nY*uCR\u001c\b\u0002CAT\u0001\u0001\u0006I!a(\u0002'A\u0014x\u000eZ;dKJ$v\u000e]5d'R\fGo\u001d\u0011\t\u000f\u0005-\u0006\u0001\"\u0001\u0002.\u00061\u0001.\u00198eY\u0016$B!a\u001b\u00020\"A\u0011\u0011WAU\u0001\u0004\t\u0019,\u0001\u0004fm\u0016tGo\u001d\t\u0007\u0003k\u000b9,a/\u000e\u0003}K1!!/`\u0005\r\u0019V-\u001d\t\u0006i\u0005uv#J\u0005\u0004\u0003\u007f#!\u0001D&fs\u0016$W*Z:tC\u001e,\u0007bBAb\u0001\u0011%\u0011QY\u0001\u0017I&\u001c\b/\u0019;dQN+'/[1mSj,G\rR1uCR!\u0011qYAl!\u0019\t),a.\u0002JB1A'!0\u0018\u0003\u0017\u0004B!!4\u0002T6\u0011\u0011q\u001a\u0006\u0004\u0003#4\u0011aB7fgN\fw-Z\u0005\u0005\u0003+\fyMA\u0004NKN\u001c\u0018mZ3\t\u0011\u0005e\u0017\u0011\u0019a\u0001\u0003\u000f\f\u0001\"\\3tg\u0006<Wm\u001d\u0005\b\u0003;\u0004A\u0011AAp\u0003%\u0019XM]5bY&TX\r\u0006\u0003\u0002H\u0006\u0005\b\u0002CAY\u00037\u0004\r!a-\t\u000f\u0005\u0015\b\u0001\"\u0001\u0002h\u0006\u0019\u0002/\u0019:uSRLwN\\!oI\u000e{G\u000e\\1uKR!\u0011\u0011\u001eB\u0003!\u0015i\u00121^Ax\u0013\r\tiO\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0011\u0005U\u0016\u0011_A(\u0003kL1!a=`\u0005\ri\u0015\r\u001d\t\b9\u0006]\u0018\u0011`Ad\u0013\r\t\u00190\u0018\t\u0005\u0003w\u0014\t!\u0004\u0002\u0002~*\u0019\u0011q \u0004\u0002\r\r|W.\\8o\u0013\u0011\u0011\u0019!!@\u0003#Q{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0002Z\u0006\r\b\u0019AAd\u0011\u001d\u0011I\u0001\u0001C\u0005\u0005\u0017\t\u0001dZ3u!\u0006\u0014H/\u001b;j_:d\u0015n\u001d;G_J$v\u000e]5d)\u0011\u0011iA!\u0006\u0011\r\u0005U\u0016q\u0017B\b!\r!$\u0011C\u0005\u0004\u0005'!!A\u0005)beRLG/[8o\u0003:$G*Z1eKJD\u0001Ba\u0006\u0003\b\u0001\u0007\u0011\u0011Z\u0001\u0002[\"9!1\u0004\u0001\u0005\n\tu\u0011\u0001D4fiB\u000b'\u000f^5uS>tG\u0003CA(\u0005?\u0011\u0019Ca\n\t\u000f\t\u0005\"\u0011\u0004a\u0001G\u0006)Ao\u001c9jG\"9!Q\u0005B\r\u0001\u00049\u0012aA6fs\"A!\u0011\u0006B\r\u0001\u0004\u0011i!\u0001\nu_BL7\rU1si&$\u0018n\u001c8MSN$\bb\u0002B\u0017\u0001\u0011%!qF\u0001\u0005g\u0016tG\r\u0006\u0004\u00032\tM\"q\u0007\t\u0007\u0003k\u000b9,!?\t\u0011\tU\"1\u0006a\u0001\u0003\u001f\n\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\u0005\t\u0005s\u0011Y\u00031\u0001\u0003<\u0005\u0001R.Z:tC\u001e,7\u000fU3s)>\u0004\u0018n\u0019\t\b9\u0006]\u0018\u0011 B\u001f!\u0011\tiMa\u0010\n\t\t\u0005\u0013q\u001a\u0002\u0015\u0005f$XMQ;gM\u0016\u0014X*Z:tC\u001e,7+\u001a;\t\u000f\t\u0015\u0003\u0001\"\u0003\u0003H\u0005\u0011rM]8va6+7o]1hKN$vnU3u)\u0011\u0011YD!\u0013\t\u0011\t-#1\ta\u0001\u0003k\fA$\\3tg\u0006<Wm\u001d)feR{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0003P\u0001!\tA!\u0015\u0002\u000b\rdwn]3\u0015\u0005\u0005-t!\u0003B+\u0005\u0005\u0005\tR\u0001B,\u0003M!UMZ1vYR,e/\u001a8u\u0011\u0006tG\r\\3s!\r!\"\u0011\f\u0004\n\u0003\t!\u0019\u0011!E\u0003\u00057\u001aBA!\u0017\f]!91O!\u0017\u0005\u0002\t}CC\u0001B,\u0011)\u0011\u0019G!\u0017\u0012\u0002\u0013\u0005!QM\u0001\u000fS:LG\u000f\n3fM\u0006,H\u000e\u001e\u00137+\u0019\u00119Ga\u001f\u0003~)\u001a1L!\u001b,\u0005\t-\u0004\u0003\u0002B7\u0005oj!Aa\u001c\u000b\t\tE$1O\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u001e\u001f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005s\u0012yGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$\u0011B\u0007B1\t\u0003\u0005)\u0019A\u000e\u0005\u0013\u001d\u0012\t\u0007\"A\u0001\u0006\u0004Y\u0002")
public class DefaultEventHandler<K, V>
implements EventHandler<K, V>,
Logging,
ScalaObject {
    public final ProducerConfig kafka$producer$async$DefaultEventHandler$$config;
    private final Partitioner<K> partitioner;
    private final Encoder kafka$producer$async$DefaultEventHandler$$encoder;
    private final Encoder kafka$producer$async$DefaultEventHandler$$keyEncoder;
    private final ProducerPool producerPool;
    private final HashMap<String, TopicMetadata> topicPartitionInfos;
    private final boolean isSync;
    private final AtomicInteger partitionCounter;
    private final AtomicInteger correlationId;
    private final BrokerPartitionInfo brokerPartitionInfo;
    private final Object lock;
    private final int topicMetadataRefreshInterval;
    private long lastTopicMetadataRefreshTime;
    private final Set kafka$producer$async$DefaultEventHandler$$topicMetadataToRefresh;
    private final ProducerStats kafka$producer$async$DefaultEventHandler$$producerStats;
    private final ProducerTopicStats kafka$producer$async$DefaultEventHandler$$producerTopicStats;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final HashMap init$default$6() {
        return DefaultEventHandler$.MODULE$.init$default$6();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        DefaultEventHandler defaultEventHandler = this;
        synchronized (defaultEventHandler) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 function0) {
        Logging$class.trace(this, function0);
    }

    public Object trace(Function0 function0) {
        return Logging$class.trace(this, function0);
    }

    public void trace(Function0 function0, Function0 function02) {
        Logging$class.trace(this, function0, function02);
    }

    public void swallowTrace(Function0 function0) {
        Logging$class.swallowTrace(this, function0);
    }

    public void debug(Function0 function0) {
        Logging$class.debug(this, function0);
    }

    public Object debug(Function0 function0) {
        return Logging$class.debug(this, function0);
    }

    public void debug(Function0 function0, Function0 function02) {
        Logging$class.debug(this, function0, function02);
    }

    public void swallowDebug(Function0 function0) {
        Logging$class.swallowDebug(this, function0);
    }

    public void info(Function0 function0) {
        Logging$class.info(this, function0);
    }

    public Object info(Function0 function0) {
        return Logging$class.info(this, function0);
    }

    public void info(Function0 function0, Function0 function02) {
        Logging$class.info(this, function0, function02);
    }

    public void swallowInfo(Function0 function0) {
        Logging$class.swallowInfo(this, function0);
    }

    public void warn(Function0 function0) {
        Logging$class.warn(this, function0);
    }

    public Object warn(Function0 function0) {
        return Logging$class.warn(this, function0);
    }

    public void warn(Function0 function0, Function0 function02) {
        Logging$class.warn(this, function0, function02);
    }

    public void swallowWarn(Function0 function0) {
        Logging$class.swallowWarn(this, function0);
    }

    public void swallow(Function0 function0) {
        Logging$class.swallow(this, function0);
    }

    public void error(Function0 function0) {
        Logging$class.error(this, function0);
    }

    public Object error(Function0 function0) {
        return Logging$class.error(this, function0);
    }

    public void error(Function0 function0, Function0 function02) {
        Logging$class.error(this, function0, function02);
    }

    public void swallowError(Function0 function0) {
        Logging$class.swallowError(this, function0);
    }

    public void fatal(Function0 function0) {
        Logging$class.fatal(this, function0);
    }

    public Object fatal(Function0 function0) {
        return Logging$class.fatal(this, function0);
    }

    public void fatal(Function0 function0, Function0 function02) {
        Logging$class.fatal(this, function0, function02);
    }

    private Partitioner<K> partitioner() {
        return this.partitioner;
    }

    public final Encoder kafka$producer$async$DefaultEventHandler$$encoder() {
        return this.kafka$producer$async$DefaultEventHandler$$encoder;
    }

    public final Encoder kafka$producer$async$DefaultEventHandler$$keyEncoder() {
        return this.kafka$producer$async$DefaultEventHandler$$keyEncoder;
    }

    private ProducerPool producerPool() {
        return this.producerPool;
    }

    private HashMap<String, TopicMetadata> topicPartitionInfos() {
        return this.topicPartitionInfos;
    }

    public boolean isSync() {
        return this.isSync;
    }

    public AtomicInteger partitionCounter() {
        return this.partitionCounter;
    }

    public AtomicInteger correlationId() {
        return this.correlationId;
    }

    public BrokerPartitionInfo brokerPartitionInfo() {
        return this.brokerPartitionInfo;
    }

    private Object lock() {
        return this.lock;
    }

    private int topicMetadataRefreshInterval() {
        return this.topicMetadataRefreshInterval;
    }

    private long lastTopicMetadataRefreshTime() {
        return this.lastTopicMetadataRefreshTime;
    }

    private void lastTopicMetadataRefreshTime_$eq(long l) {
        this.lastTopicMetadataRefreshTime = l;
    }

    public final Set kafka$producer$async$DefaultEventHandler$$topicMetadataToRefresh() {
        return this.kafka$producer$async$DefaultEventHandler$$topicMetadataToRefresh;
    }

    public final ProducerStats kafka$producer$async$DefaultEventHandler$$producerStats() {
        return this.kafka$producer$async$DefaultEventHandler$$producerStats;
    }

    public final ProducerTopicStats kafka$producer$async$DefaultEventHandler$$producerTopicStats() {
        return this.kafka$producer$async$DefaultEventHandler$$producerTopicStats;
    }

    @Override
    public void handle(Seq<KeyedMessage<K, V>> seq) {
        Object object = this.lock();
        synchronized (object) {
            Seq<KeyedMessage<K, Message>> seq2 = this.serialize(seq);
            seq2.foreach((Function1)new $anonfun$handle$3(this));
            ObjectRef objectRef = new ObjectRef(seq2);
            IntRef intRef = new IntRef(this.kafka$producer$async$DefaultEventHandler$$config.messageSendMaxRetries() + 1);
            int n = this.correlationId().get();
            this.debug((Function0<String>)new $anonfun$handle$4(this, seq));
            while (intRef.elem > 0 && ((Seq)objectRef.elem).size() > 0) {
                this.kafka$producer$async$DefaultEventHandler$$topicMetadataToRefresh().$plus$plus$eq((TraversableOnce)((Seq)objectRef.elem).map((Function1)new $anonfun$handle$5(this), Seq$.MODULE$.canBuildFrom()));
                if (this.topicMetadataRefreshInterval() >= 0 && SystemTime$.MODULE$.milliseconds() - this.lastTopicMetadataRefreshTime() > (long)this.topicMetadataRefreshInterval()) {
                    Utils$.MODULE$.swallowError((Function0<Object>)new $anonfun$handle$1(this));
                    this.kafka$producer$async$DefaultEventHandler$$topicMetadataToRefresh().clear();
                    this.lastTopicMetadataRefreshTime_$eq(SystemTime$.MODULE$.milliseconds());
                }
                objectRef.elem = this.dispatchSerializedData((Seq)objectRef.elem);
                if (((Seq)objectRef.elem).size() <= 0) continue;
                this.info((Function0<String>)new $anonfun$handle$6(this, intRef));
                Thread.sleep(this.kafka$producer$async$DefaultEventHandler$$config.retryBackoffMs());
                Utils$.MODULE$.swallowError((Function0<Object>)new $anonfun$handle$2(this, objectRef));
                --intRef.elem;
                this.kafka$producer$async$DefaultEventHandler$$producerStats().resendRate().mark();
            }
            if (((Seq)objectRef.elem).size() > 0) {
                this.kafka$producer$async$DefaultEventHandler$$producerStats().failedSendRate().mark();
                int n2 = this.correlationId().get();
                this.error((Function0<String>)new $anonfun$handle$7(this, objectRef, n, n2));
                throw new FailedToSendMessageException(new StringBuilder().append((Object)"Failed to send messages after ").append((Object)BoxesRunTime.boxToInteger((int)this.kafka$producer$async$DefaultEventHandler$$config.messageSendMaxRetries())).append((Object)" tries.").toString(), null);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Seq<KeyedMessage<K, Message>> dispatchSerializedData(Seq<KeyedMessage<K, Message>> arrayBuffer) {
        ArrayBuffer arrayBuffer2;
        ArrayBuffer arrayBuffer3;
        Option<Map<Integer, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>>>> option = this.partitionAndCollate((Seq<KeyedMessage<K, Message>>)arrayBuffer);
        Option<Map<Integer, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>>>> option2 = option;
        if (option2 instanceof Some) {
            arrayBuffer3 = new ArrayBuffer();
            try {
                ((IterableLike)((Some)option2).x()).foreach((Function1)new $anonfun$dispatchSerializedData$1(this, arrayBuffer3));
            }
            catch (Throwable throwable) {
                this.error((Function0<String>)new $anonfun$dispatchSerializedData$2(this), (Function0<Throwable>)new $anonfun$dispatchSerializedData$3(this, throwable));
            }
        } else {
            None$ none$ = None$.MODULE$;
            Option<Map<Integer, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>>>> option3 = option2;
            if (none$ == null) {
                if (option3 != null) {
                    throw new MatchError(option2);
                }
            } else if (!none$.equals(option3)) throw new MatchError(option2);
            arrayBuffer2 = arrayBuffer;
            return arrayBuffer2;
        }
        arrayBuffer2 = arrayBuffer3;
        return arrayBuffer2;
    }

    public Seq<KeyedMessage<K, Message>> serialize(Seq<KeyedMessage<K, V>> seq) {
        ArrayBuffer arrayBuffer = new ArrayBuffer(seq.size());
        seq.map((Function1)new $anonfun$serialize$1(this, arrayBuffer), Seq$.MODULE$.canBuildFrom());
        return arrayBuffer;
    }

    public Option<Map<Integer, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>>>> partitionAndCollate(Seq<KeyedMessage<K, Message>> seq) {
        HashMap hashMap = new HashMap();
        None$ none$ = null;
        try {
            seq.foreach((Function1)new $anonfun$partitionAndCollate$1(this, hashMap));
            none$ = new Some((Object)hashMap);
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new $anonfun$partitionAndCollate$4(this, throwable));
            none$ = None$.MODULE$;
        }
        catch (LeaderNotAvailableException leaderNotAvailableException) {
            this.warn((Function0<String>)new $anonfun$partitionAndCollate$3(this, leaderNotAvailableException));
            none$ = None$.MODULE$;
        }
        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
            this.warn((Function0<String>)new $anonfun$partitionAndCollate$2(this, unknownTopicOrPartitionException));
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public final Seq kafka$producer$async$DefaultEventHandler$$getPartitionListForTopic(KeyedMessage keyedMessage) {
        Seq<PartitionAndLeader> seq = this.brokerPartitionInfo().getBrokerPartitionInfo(keyedMessage.topic(), this.correlationId().getAndIncrement());
        this.debug((Function0<String>)new $anonfun$kafka$producer$async$DefaultEventHandler$$getPartitionListForTopic$1(this, keyedMessage, seq));
        int n = seq.length();
        if (n == 0) {
            throw new NoBrokersForPartitionException(new StringBuilder().append((Object)"Partition key = ").append(keyedMessage.key()).toString());
        }
        return seq;
    }

    public final int kafka$producer$async$DefaultEventHandler$$getPartition(String string, Object object, Seq seq) {
        int n;
        int n2;
        int n3 = seq.size();
        if (n3 <= 0) {
            throw new UnknownTopicOrPartitionException(new StringBuilder().append((Object)"Topic ").append((Object)string).append((Object)" doesn't exist").toString());
        }
        if (object == null) {
            Seq seq2 = (Seq)seq.filter((Function1)new $anonfun$2(this));
            if (seq2.isEmpty()) {
                throw new LeaderNotAvailableException(new StringBuilder().append((Object)"No leader for any partition in topic ").append((Object)string).toString());
            }
            int n4 = Utils$.MODULE$.abs(this.partitionCounter().getAndIncrement()) % seq2.size();
            n2 = ((PartitionAndLeader)seq2.apply(n4)).partitionId();
        } else {
            n2 = n = this.partitioner().partition(object, n3);
        }
        if (n < 0 || n >= n3) {
            throw new UnknownTopicOrPartitionException(new StringBuilder().append((Object)"Invalid partition id: ").append((Object)BoxesRunTime.boxToInteger((int)n)).append((Object)" for topic ").append((Object)string).append((Object)"; Valid values are in the inclusive range of [0, ").append((Object)BoxesRunTime.boxToInteger((int)(n3 - 1))).append((Object)"]").toString());
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Seq kafka$producer$async$DefaultEventHandler$$send(int n, scala.collection.mutable.Map map) {
        List list;
        if (n < 0) {
            this.warn((Function0<String>)new $anonfun$kafka$producer$async$DefaultEventHandler$$send$1(this, map));
            list = map.keys().toSeq();
            return list;
        }
        if (map.size() <= 0) {
            list = List$.MODULE$.empty();
            return list;
        }
        int n2 = this.correlationId().getAndIncrement();
        ProducerRequest producerRequest = new ProducerRequest(n2, this.kafka$producer$async$DefaultEventHandler$$config.clientId(), this.kafka$producer$async$DefaultEventHandler$$config.requestRequiredAcks(), this.kafka$producer$async$DefaultEventHandler$$config.requestTimeoutMs(), (scala.collection.mutable.Map<TopicAndPartition, ByteBufferMessageSet>)map);
        Seq seq3 = (Seq)Seq$.MODULE$.empty();
        Seq seq = null;
        try {
            Seq seq2;
            SyncProducer syncProducer = this.producerPool().getProducer(n);
            this.debug((Function0<String>)new $anonfun$kafka$producer$async$DefaultEventHandler$$send$2(this, n, map, n2, syncProducer));
            ProducerResponse producerResponse = syncProducer.send(producerRequest);
            this.debug((Function0<String>)new $anonfun$kafka$producer$async$DefaultEventHandler$$send$3(this, n, map, n2, syncProducer));
            if (producerResponse == null) {
                seq2 = (Seq)Seq$.MODULE$.empty();
            } else {
                Seq seq4;
                if (producerResponse.status().size() != producerRequest.data().size()) {
                    throw new KafkaException(Predef$.MODULE$.augmentString("Incomplete response (%s) for producer request (%s)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{producerResponse, producerRequest})));
                }
                if (this.logger().isTraceEnabled()) {
                    Map map2 = (Map)producerResponse.status().filter((Function1)new $anonfun$3(this));
                    map2.foreach((Function1)new $anonfun$kafka$producer$async$DefaultEventHandler$$send$4(this, map));
                }
                if ((seq3 = (Seq)(seq4 = ((IterableLike)producerResponse.status().filter((Function1)new $anonfun$4(this))).toSeq()).map((Function1)new $anonfun$kafka$producer$async$DefaultEventHandler$$send$5(this), Seq$.MODULE$.canBuildFrom())).size() > 0) {
                    String string = ((TraversableOnce)((TraversableLike)seq4.sortWith((Function2)new $anonfun$5(this))).map((Function1)new $anonfun$6(this), Seq$.MODULE$.canBuildFrom())).mkString(",");
                    this.warn((Function0<String>)new $anonfun$kafka$producer$async$DefaultEventHandler$$send$6(this, n2, string));
                }
                seq2 = seq3;
            }
            seq = seq2;
        }
        catch (Throwable throwable) {
            this.warn((Function0<String>)new $anonfun$kafka$producer$async$DefaultEventHandler$$send$7(this, n, map, n2), (Function0<Throwable>)new $anonfun$kafka$producer$async$DefaultEventHandler$$send$8(this, throwable));
            seq = map.keys().toSeq();
        }
        list = seq;
        return list;
    }

    public final scala.collection.mutable.Map kafka$producer$async$DefaultEventHandler$$groupMessagesToSet(scala.collection.mutable.Map map) {
        scala.collection.mutable.Map map2 = (scala.collection.mutable.Map)map.map((Function1)new $anonfun$7(this), Map$.MODULE$.canBuildFrom());
        return map2;
    }

    @Override
    public void close() {
        if (this.producerPool() != null) {
            this.producerPool().close();
        }
    }

    public DefaultEventHandler(ProducerConfig producerConfig, Partitioner<K> partitioner, Encoder<V> encoder, Encoder<K> encoder2, ProducerPool producerPool, HashMap<String, TopicMetadata> hashMap) {
        this.kafka$producer$async$DefaultEventHandler$$config = producerConfig;
        this.partitioner = partitioner;
        this.kafka$producer$async$DefaultEventHandler$$encoder = encoder;
        this.kafka$producer$async$DefaultEventHandler$$keyEncoder = encoder2;
        this.producerPool = producerPool;
        this.topicPartitionInfos = hashMap;
        Logging$class.$init$(this);
        String string = producerConfig.producerType();
        this.isSync = !("sync" != null ? !"sync".equals(string) : string != null);
        this.partitionCounter = new AtomicInteger(0);
        this.correlationId = new AtomicInteger(0);
        this.brokerPartitionInfo = new BrokerPartitionInfo(producerConfig, producerPool, hashMap);
        this.lock = new Object();
        this.topicMetadataRefreshInterval = producerConfig.topicMetadataRefreshIntervalMs();
        this.lastTopicMetadataRefreshTime = 0L;
        this.kafka$producer$async$DefaultEventHandler$$topicMetadataToRefresh = Set$.MODULE$.empty();
        this.kafka$producer$async$DefaultEventHandler$$producerStats = ProducerStatsRegistry$.MODULE$.getProducerStats(producerConfig.clientId());
        this.kafka$producer$async$DefaultEventHandler$$producerTopicStats = ProducerTopicStatsRegistry$.MODULE$.getProducerTopicStats(producerConfig.clientId());
    }
}

