/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.api.FetchRequest;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.api.FetchResponsePartitionData;
import kafka.cluster.Broker;
import kafka.common.ClientIdAndBroker;
import kafka.common.TopicAndPartition;
import kafka.consumer.PartitionTopicInfo$;
import kafka.consumer.SimpleConsumer;
import kafka.server.AbstractFetcherThread$;
import kafka.server.FetcherLagStats;
import kafka.server.FetcherStats;
import kafka.utils.ShutdownableThread;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.generic.Growable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\t\u0015b\u0001C\u0001\u0003\t\u0003\u0005\u0019\u0011A\u0004\u0003+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bI*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q!a\u0003\u0003\u0002\u000bU$\u0018\u000e\\:\n\u00055Q!AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012\u0004\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u00111bU2bY\u0006|%M[3di\"IQ\u0003\u0001B\u0001B\u0003%a#H\u0001\u0005]\u0006lW\r\u0005\u0002\u001859\u0011q\u0002G\u0005\u00033A\ta\u0001\u0015:fI\u00164\u0017BA\u000e\u001d\u0005\u0019\u0019FO]5oO*\u0011\u0011\u0004E\u0005\u0003+1A\u0001b\b\u0001\u0003\u0002\u0003\u0006IAF\u0001\tG2LWM\u001c;JI\"A\u0011\u0005\u0001B\u0001B\u0003%!%\u0001\u0007t_V\u00148-\u001a\"s_.,'\u000f\u0005\u0002$M5\tAE\u0003\u0002&\t\u000591\r\\;ti\u0016\u0014\u0018BA\u0014%\u0005\u0019\u0011%o\\6fe\"A\u0011\u0006\u0001B\u0001B\u0003%!&A\u0007t_\u000e\\W\r\u001e+j[\u0016|W\u000f\u001e\t\u0003\u001f-J!\u0001\f\t\u0003\u0007%sG\u000f\u0003\u0005/\u0001\t\u0005\t\u0015!\u0003+\u0003A\u0019xnY6fi\n+hMZ3s'&TX\r\u0003\u00051\u0001\t\u0005\t\u0015!\u0003+\u0003%1W\r^2i'&TX\r\u0003\u00053\u0001\t\u0005\t\u0015!\u0003+\u0003=1W\r^2iKJ\u0014%o\\6fe&#\u0007\u0002\u0003\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\u0002\u000f5\f\u0007pV1ji\"Aa\u0007\u0001B\u0001B\u0003%!&\u0001\u0005nS:\u0014\u0015\u0010^3t\u0011%A\u0004A!A!\u0002\u0013ID(A\bjg&sG/\u001a:skB$\u0018N\u00197f!\ty!(\u0003\u0002<!\t9!i\\8mK\u0006t\u0017B\u0001\u001d\r\u0011\u0015q\u0004\u0001\"\u0001@\u0003\u0019a\u0014N\\5u}QY\u0001IQ\"E\u000b\u001a;\u0005*\u0013&L!\t\t\u0005!D\u0001\u0003\u0011\u0015)R\b1\u0001\u0017\u0011\u0015yR\b1\u0001\u0017\u0011\u0015\tS\b1\u0001#\u0011\u0015IS\b1\u0001+\u0011\u0015qS\b1\u0001+\u0011\u0015\u0001T\b1\u0001+\u0011\u001d\u0011T\b%AA\u0002)Bq\u0001N\u001f\u0011\u0002\u0003\u0007!\u0006C\u00047{A\u0005\t\u0019\u0001\u0016\t\u000faj\u0004\u0013!a\u0001s!9Q\n\u0001b\u0001\n\u0013q\u0015\u0001\u00049beRLG/[8o\u001b\u0006\u0004X#A(\u0011\tA+v+X\u0007\u0002#*\u0011!kU\u0001\b[V$\u0018M\u00197f\u0015\t!\u0006#\u0001\u0006d_2dWm\u0019;j_:L!AV)\u0003\u000f!\u000b7\u000f['baB\u0011\u0001lW\u0007\u00023*\u0011!\fB\u0001\u0007G>lWn\u001c8\n\u0005qK&!\u0005+pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]B\u0011qBX\u0005\u0003?B\u0011A\u0001T8oO\"1\u0011\r\u0001Q\u0001\n=\u000bQ\u0002]1si&$\u0018n\u001c8NCB\u0004\u0003bB2\u0001\u0005\u0004%I\u0001Z\u0001\u0011a\u0006\u0014H/\u001b;j_:l\u0015\r\u001d'pG.,\u0012!\u001a\t\u0003M>l\u0011a\u001a\u0006\u0003Q&\fQ\u0001\\8dWNT!A[6\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002m[\u0006!Q\u000f^5m\u0015\u0005q\u0017\u0001\u00026bm\u0006L!\u0001]4\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u0011\u0019\u0011\b\u0001)A\u0005K\u0006\t\u0002/\u0019:uSRLwN\\'ba2{7m\u001b\u0011\t\u000fQ\u0004!\u0019!C\u0005k\u0006\u0001\u0002/\u0019:uSRLwN\\'ba\u000e{g\u000eZ\u000b\u0002mB\u0011am^\u0005\u0003q\u001e\u0014\u0011bQ8oI&$\u0018n\u001c8\t\ri\u0004\u0001\u0015!\u0003w\u0003E\u0001\u0018M\u001d;ji&|g.T1q\u0007>tG\r\t\u0005\by\u0002\u0011\r\u0011\"\u0001~\u00039\u0019\u0018.\u001c9mK\u000e{gn];nKJ,\u0012A \t\u0004\u007f\u0006\u0015QBAA\u0001\u0015\r\t\u0019\u0001B\u0001\tG>t7/^7fe&!\u0011qAA\u0001\u00059\u0019\u0016.\u001c9mK\u000e{gn];nKJDq!a\u0003\u0001A\u0003%a0A\btS6\u0004H.Z\"p]N,X.\u001a:!\u0011%\ty\u0001\u0001b\u0001\n\u0013\t\t\"\u0001\u0006ce>\\WM]%oM>,\u0012A\u0006\u0005\b\u0003+\u0001\u0001\u0015!\u0003\u0017\u0003-\u0011'o\\6fe&sgm\u001c\u0011\t\u0013\u0005e\u0001A1A\u0005\n\u0005m\u0011\u0001C7fiJL7-\u00133\u0016\u0005\u0005u\u0001c\u0001-\u0002 %\u0019\u0011\u0011E-\u0003#\rc\u0017.\u001a8u\u0013\u0012\fe\u000e\u001a\"s_.,'\u000f\u0003\u0005\u0002&\u0001\u0001\u000b\u0011BA\u000f\u0003%iW\r\u001e:jG&#\u0007\u0005C\u0005\u0002*\u0001\u0011\r\u0011\"\u0001\u0002,\u0005aa-\u001a;dQ\u0016\u00148\u000b^1ugV\u0011\u0011Q\u0006\t\u0004\u0003\u0006=\u0012bAA\u0019\u0005\taa)\u001a;dQ\u0016\u00148\u000b^1ug\"A\u0011Q\u0007\u0001!\u0002\u0013\ti#A\u0007gKR\u001c\u0007.\u001a:Ti\u0006$8\u000f\t\u0005\n\u0003s\u0001!\u0019!C\u0001\u0003w\tqBZ3uG\",'\u000fT1h'R\fGo]\u000b\u0003\u0003{\u00012!QA \u0013\r\t\tE\u0001\u0002\u0010\r\u0016$8\r[3s\u0019\u0006<7\u000b^1ug\"A\u0011Q\t\u0001!\u0002\u0013\ti$\u0001\tgKR\u001c\u0007.\u001a:MC\u001e\u001cF/\u0019;tA!I\u0011\u0011\n\u0001C\u0002\u0013\u0005\u00111J\u0001\u0014M\u0016$8\r\u001b*fcV,7\u000f\u001e\"vS2$WM]\u000b\u0003\u0003\u001b\u0002B!a\u0014\u0002V5\u0011\u0011\u0011\u000b\u0006\u0004\u0003'\"\u0011aA1qS&!\u0011qKA)\u0005M1U\r^2i%\u0016\fX/Z:u\u0005VLG\u000eZ3s\u0011!\tY\u0006\u0001Q\u0001\n\u00055\u0013\u0001\u00064fi\u000eD'+Z9vKN$()^5mI\u0016\u0014\b\u0005C\u0004\u0002`\u00011\t!!\u0019\u0002)A\u0014xnY3tgB\u000b'\u000f^5uS>tG)\u0019;b)!\t\u0019'!\u001b\u0002n\u0005E\u0004cA\b\u0002f%\u0019\u0011q\r\t\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003W\ni\u00061\u0001X\u0003E!x\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003_\ni\u00061\u0001^\u0003-1W\r^2i\u001f\u001a47/\u001a;\t\u0011\u0005M\u0014Q\fa\u0001\u0003k\nQ\u0002]1si&$\u0018n\u001c8ECR\f\u0007\u0003BA(\u0003oJA!!\u001f\u0002R\tQb)\u001a;dQJ+7\u000f]8og\u0016\u0004\u0016M\u001d;ji&|g\u000eR1uC\"9\u0011Q\u0010\u0001\u0007\u0002\u0005}\u0014A\u00065b]\u0012dWm\u00144gg\u0016$x*\u001e;PMJ\u000bgnZ3\u0015\u0007u\u000b\t\tC\u0004\u0002l\u0005m\u0004\u0019A,\t\u000f\u0005\u0015\u0005A\"\u0001\u0002\b\u0006Q\u0002.\u00198eY\u0016\u0004\u0016M\u001d;ji&|gn],ji\",%O]8sgR!\u00111MAE\u0011!\tY)a!A\u0002\u00055\u0015A\u00039beRLG/[8ogB)\u0011qRAP/:!\u0011\u0011SAN\u001d\u0011\t\u0019*!'\u000e\u0005\u0005U%bAAL\r\u00051AH]8pizJ\u0011!E\u0005\u0004\u0003;\u0003\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003C\u000b\u0019K\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\ti\n\u0005\u0005\b\u0003O\u0003A\u0011IAU\u0003!\u0019\b.\u001e;e_^tGCAA2\u0011\u001d\ti\u000b\u0001C!\u0003S\u000ba\u0001Z8X_J\\\u0007bBAY\u0001\u0011%\u00111W\u0001\u0014aJ|7-Z:t\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u000b\u0005\u0003G\n)\f\u0003\u0005\u00028\u0006=\u0006\u0019AA]\u000311W\r^2i%\u0016\fX/Z:u!\u0011\ty%a/\n\t\u0005u\u0016\u0011\u000b\u0002\r\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u0005\b\u0003\u0003\u0004A\u0011AAb\u00031\tG\r\u001a)beRLG/[8o)!\t\u0019'!2\u0002J\u00065\u0007bBAd\u0003\u007f\u0003\rAF\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0003\u0017\fy\f1\u0001+\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\t\u000f\u0005=\u0017q\u0018a\u0001;\u0006i\u0011N\\5uS\u0006dwJ\u001a4tKRDq!a5\u0001\t\u0003\t).A\bsK6|g/\u001a)beRLG/[8o)\u0019\t\u0019'a6\u0002Z\"9\u0011qYAi\u0001\u00041\u0002bBAf\u0003#\u0004\rA\u000b\u0005\b\u0003;\u0004A\u0011AAp\u00039\u0001\u0018M\u001d;ji&|gnQ8v]R$\u0012AK\u0004\n\u0003G\u0014\u0011\u0011!E\u0003\u0003K\fQ#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG\rE\u0002B\u0003O4\u0011\"\u0001\u0002\u0005\u0004\u0003E)!!;\u0014\u000b\u0005\u001d\u00181\u001e\b\u0011\t\u00055\u00181_\u0007\u0003\u0003_T1!!=n\u0003\u0011a\u0017M\\4\n\t\u0005U\u0018q\u001e\u0002\u0007\u001f\nTWm\u0019;\t\u000fy\n9\u000f\"\u0001\u0002zR\u0011\u0011Q\u001d\u0005\u000b\u0003{\f9/%A\u0005\u0002\u0005}\u0018AD5oSR$C-\u001a4bk2$HeN\u000b\u0003\u0005\u0003Q3A\u000bB\u0002W\t\u0011)\u0001\u0005\u0003\u0003\b\tEQB\u0001B\u0005\u0015\u0011\u0011YA!\u0004\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\b!\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tM!\u0011\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007B\u0003B\f\u0003O\f\n\u0011\"\u0001\u0002\u0000\u0006q\u0011N\\5uI\u0011,g-Y;mi\u0012B\u0004B\u0003B\u000e\u0003O\f\n\u0011\"\u0001\u0002\u0000\u0006q\u0011N\\5uI\u0011,g-Y;mi\u0012J\u0004B\u0003B\u0010\u0003O\f\n\u0011\"\u0001\u0003\"\u0005y\u0011N\\5uI\u0011,g-Y;mi\u0012\n\u0004'\u0006\u0002\u0003$)\u001a\u0011Ha\u0001")
public abstract class AbstractFetcherThread
extends ShutdownableThread
implements ScalaObject {
    public final Broker kafka$server$AbstractFetcherThread$$sourceBroker;
    public final int kafka$server$AbstractFetcherThread$$fetchSize;
    private final HashMap kafka$server$AbstractFetcherThread$$partitionMap;
    private final ReentrantLock partitionMapLock;
    private final Condition partitionMapCond;
    private final SimpleConsumer simpleConsumer;
    private final String brokerInfo;
    private final ClientIdAndBroker metricId;
    private final FetcherStats fetcherStats;
    private final FetcherLagStats fetcherLagStats;
    private final FetchRequestBuilder fetchRequestBuilder;

    public static final boolean init$default$10() {
        return AbstractFetcherThread$.MODULE$.init$default$10();
    }

    public static final int init$default$9() {
        return AbstractFetcherThread$.MODULE$.init$default$9();
    }

    public static final int init$default$8() {
        return AbstractFetcherThread$.MODULE$.init$default$8();
    }

    public static final int init$default$7() {
        return AbstractFetcherThread$.MODULE$.init$default$7();
    }

    public final HashMap kafka$server$AbstractFetcherThread$$partitionMap() {
        return this.kafka$server$AbstractFetcherThread$$partitionMap;
    }

    private ReentrantLock partitionMapLock() {
        return this.partitionMapLock;
    }

    private Condition partitionMapCond() {
        return this.partitionMapCond;
    }

    public SimpleConsumer simpleConsumer() {
        return this.simpleConsumer;
    }

    private String brokerInfo() {
        return this.brokerInfo;
    }

    private ClientIdAndBroker metricId() {
        return this.metricId;
    }

    public FetcherStats fetcherStats() {
        return this.fetcherStats;
    }

    public FetcherLagStats fetcherLagStats() {
        return this.fetcherLagStats;
    }

    public FetchRequestBuilder fetchRequestBuilder() {
        return this.fetchRequestBuilder;
    }

    public abstract void processPartitionData(TopicAndPartition var1, long var2, FetchResponsePartitionData var4);

    public abstract long handleOffsetOutOfRange(TopicAndPartition var1);

    public abstract void handlePartitionsWithErrors(Iterable<TopicAndPartition> var1);

    @Override
    public void shutdown() {
        super.shutdown();
        this.simpleConsumer().close();
    }

    @Override
    public void doWork() {
        this.partitionMapLock().lock();
        Object object = this.kafka$server$AbstractFetcherThread$$partitionMap().isEmpty() ? BoxesRunTime.boxToBoolean((boolean)this.partitionMapCond().await(200L, TimeUnit.MILLISECONDS)) : BoxedUnit.UNIT;
        this.kafka$server$AbstractFetcherThread$$partitionMap().foreach((Function1)new $anonfun$doWork$1(this));
        FetchRequest fetchRequest = this.fetchRequestBuilder().build();
        if (!fetchRequest.requestInfo().isEmpty()) {
            this.processFetchRequest(fetchRequest);
        }
        return;
        finally {
            this.partitionMapLock().unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processFetchRequest(FetchRequest fetchRequest) {
        HashSet hashSet = new HashSet();
        FetchResponse fetchResponse = null;
        BoxedUnit boxedUnit = null;
        try {
            this.trace((Function0<String>)new $anonfun$processFetchRequest$1(this, fetchRequest));
            fetchResponse = this.simpleConsumer().fetch(fetchRequest);
            boxedUnit = BoxedUnit.UNIT;
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit2;
            if (this.isRunning().get()) {
                this.warn((Function0<String>)new $anonfun$processFetchRequest$2(this, fetchRequest), (Function0<Throwable>)new $anonfun$processFetchRequest$3(this, throwable));
                ReentrantLock reentrantLock = this.partitionMapLock();
                synchronized (reentrantLock) {
                    Growable growable = hashSet.$plus$plus$eq((TraversableOnce)this.kafka$server$AbstractFetcherThread$$partitionMap().keys());
                    // MONITOREXIT @DISABLED, blocks:[1, 3, 4, 11] lbl17 : MonitorExitStatement: MONITOREXIT : var6_6
                    boxedUnit2 = growable;
                }
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            boxedUnit = boxedUnit2;
        }
        this.fetcherStats().requestRate().mark();
        if (fetchResponse != null) {
            this.partitionMapLock().lock();
            fetchResponse.data().foreach((Function1)new $anonfun$processFetchRequest$4(this, fetchRequest, hashSet));
        }
        if (hashSet.size() > 0) {
            this.debug((Function0<String>)new $anonfun$processFetchRequest$5(this, hashSet));
            this.handlePartitionsWithErrors((Iterable<TopicAndPartition>)hashSet);
        }
        return;
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public void addPartition(String string, int n, long l) {
        this.partitionMapLock().lockInterruptibly();
        try {
            TopicAndPartition topicAndPartition = new TopicAndPartition(string, n);
            this.kafka$server$AbstractFetcherThread$$partitionMap().put((Object)topicAndPartition, (Object)(PartitionTopicInfo$.MODULE$.isOffsetInvalid(l) ? BoxesRunTime.boxToLong((long)this.handleOffsetOutOfRange(topicAndPartition)) : BoxesRunTime.boxToLong((long)l)));
            this.partitionMapCond().signalAll();
            return;
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public void removePartition(String string, int n) {
        this.partitionMapLock().lockInterruptibly();
        try {
            this.kafka$server$AbstractFetcherThread$$partitionMap().remove((Object)new TopicAndPartition(string, n));
            return;
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public int partitionCount() {
        this.partitionMapLock().lockInterruptibly();
        int n = 0;
        try {
            n = this.kafka$server$AbstractFetcherThread$$partitionMap().size();
            return n;
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public AbstractFetcherThread(String string, String string2, Broker broker, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.kafka$server$AbstractFetcherThread$$sourceBroker = broker;
        this.kafka$server$AbstractFetcherThread$$fetchSize = n3;
        super(string, bl);
        this.kafka$server$AbstractFetcherThread$$partitionMap = new HashMap();
        this.partitionMapLock = new ReentrantLock();
        this.partitionMapCond = this.partitionMapLock().newCondition();
        this.simpleConsumer = new SimpleConsumer(broker.host(), broker.port(), n, n2, string2);
        this.brokerInfo = Predef$.MODULE$.augmentString("host_%s-port_%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{broker.host(), BoxesRunTime.boxToInteger((int)broker.port())}));
        this.metricId = new ClientIdAndBroker(string2, this.brokerInfo());
        this.fetcherStats = new FetcherStats(this.metricId());
        this.fetcherLagStats = new FetcherLagStats(this.metricId());
        this.fetchRequestBuilder = new FetchRequestBuilder().clientId(string2).replicaId(n4).maxWait(n5).minBytes(n6);
    }
}

