/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.TopicAndPartition;
import kafka.server.HighwaterMarkCheckpoint$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001u<Q!\u0001\u0002\t\u0006\u001d\tq\u0003S5hQ^\fG/\u001a:NCJ\\7\t[3dWB|\u0017N\u001c;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"\u0001C\u0005\u000e\u0003\t1\u0001B\u0003\u0002\u0005\u0002\u0003E)a\u0003\u0002\u0018\u0011&<\u0007n^1uKJl\u0015M]6DQ\u0016\u001c7\u000e]8j]R\u001c2!\u0003\u0007\u0015!\ti!#D\u0001\u000f\u0015\ty\u0001#\u0001\u0003mC:<'\"A\t\u0002\t)\fg/Y\u0005\u0003'9\u0011aa\u00142kK\u000e$\bCA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"aC*dC2\fwJ\u00196fGRDQaG\u0005\u0005\u0002q\ta\u0001P5oSRtD#A\u0004\t\u000fyI!\u0019!C\u0001?\u0005)\u0002.[4i/\u0006$XM]7be.4\u0015\u000e\\3OC6,W#\u0001\u0011\u0011\u00055\t\u0013B\u0001\u0012\u000f\u0005\u0019\u0019FO]5oO\"1A%\u0003Q\u0001\n\u0001\na\u0003[5hQ^\u000bG/\u001a:nCJ\\g)\u001b7f\u001d\u0006lW\r\t\u0005\bM%\u0011\r\u0011\"\u0001(\u0003}\u0019WO\u001d:f]RD\u0015n\u001a5xCR,'/T1sW\u001aKG.\u001a,feNLwN\\\u000b\u0002QA\u0011Q#K\u0005\u0003UY\u00111!\u00138u\u0011\u0019a\u0013\u0002)A\u0005Q\u0005\u00013-\u001e:sK:$\b*[4io\u0006$XM]'be.4\u0015\u000e\\3WKJ\u001c\u0018n\u001c8!\r!Q!\u0001\"A\u0001\u0002\u0003q3\u0003B\u0017\r_Q\u0001\"\u0001M\u001a\u000e\u0003ER!A\r\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005Q\n$a\u0002'pO\u001eLgn\u001a\u0005\tm5\u0012)\u0019!C\u0001o\u0005!\u0001/\u0019;i+\u0005A\u0004CA\u001d=\u001d\t)\"(\u0003\u0002<-\u00051\u0001K]3eK\u001aL!AI\u001f\u000b\u0005m2\u0002\u0002C .\u0005\u0003\u0005\u000b\u0011\u0002\u001d\u0002\u000bA\fG\u000f\u001b\u0011\t\u000bmiC\u0011A!\u0015\u0005\t\u001b\u0005C\u0001\u0005.\u0011\u00151\u0004\t1\u00019\u0011\u001d)UF1A\u0005\u0002}\tAA\\1nK\"1q)\fQ\u0001\n\u0001\nQA\\1nK\u0002Bq!S\u0017C\u0002\u0013%!*\u0001\u0004io\u001aKG.Z\u000b\u0002\u0017B\u0011AjT\u0007\u0002\u001b*\u0011a\nE\u0001\u0003S>L!\u0001U'\u0003\t\u0019KG.\u001a\u0005\u0007%6\u0002\u000b\u0011B&\u0002\u000f!<h)\u001b7fA!9A+\fb\u0001\n\u0013)\u0016A\u00035x\r&dW\rT8dWV\ta\u000b\u0005\u0002X=6\t\u0001L\u0003\u0002Z5\u0006)An\\2lg*\u00111\fX\u0001\u000bG>t7-\u001e:sK:$(BA/\u0011\u0003\u0011)H/\u001b7\n\u0005}C&!\u0004*fK:$(/\u00198u\u0019>\u001c7\u000e\u0003\u0004b[\u0001\u0006IAV\u0001\fQ^4\u0015\u000e\\3M_\u000e\\\u0007\u0005C\u0003d[\u0011\u0005A-A\u0003xe&$X\r\u0006\u0002fQB\u0011QCZ\u0005\u0003OZ\u0011A!\u00168ji\")\u0011N\u0019a\u0001U\u0006Q\u0002.[4io\u0006$XM]'be.\u001c\b+\u001a:QCJ$\u0018\u000e^5p]B!\u0011h[7t\u0013\taWHA\u0002NCB\u0004\"A\\9\u000e\u0003=T!\u0001\u001d\u0003\u0002\r\r|W.\\8o\u0013\t\u0011xNA\tU_BL7-\u00118e!\u0006\u0014H/\u001b;j_:\u0004\"!\u0006;\n\u0005U4\"\u0001\u0002'p]\u001eDQa^\u0017\u0005\u0002a\fAA]3bIR\u00191/_>\t\u000bi4\b\u0019\u0001\u001d\u0002\u000bQ|\u0007/[2\t\u000bq4\b\u0019\u0001\u0015\u0002\u0013A\f'\u000f^5uS>t\u0007")
public class HighwaterMarkCheckpoint
implements Logging,
ScalaObject {
    private final String path;
    private final String name;
    private final File hwFile;
    private final ReentrantLock hwFileLock;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final int currentHighwaterMarkFileVersion() {
        return HighwaterMarkCheckpoint$.MODULE$.currentHighwaterMarkFileVersion();
    }

    public static final String highWatermarkFileName() {
        return HighwaterMarkCheckpoint$.MODULE$.highWatermarkFileName();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        HighwaterMarkCheckpoint highwaterMarkCheckpoint = this;
        synchronized (highwaterMarkCheckpoint) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 function0) {
        Logging$class.trace(this, function0);
    }

    public Object trace(Function0 function0) {
        return Logging$class.trace(this, function0);
    }

    public void trace(Function0 function0, Function0 function02) {
        Logging$class.trace(this, function0, function02);
    }

    public void swallowTrace(Function0 function0) {
        Logging$class.swallowTrace(this, function0);
    }

    public void debug(Function0 function0) {
        Logging$class.debug(this, function0);
    }

    public Object debug(Function0 function0) {
        return Logging$class.debug(this, function0);
    }

    public void debug(Function0 function0, Function0 function02) {
        Logging$class.debug(this, function0, function02);
    }

    public void swallowDebug(Function0 function0) {
        Logging$class.swallowDebug(this, function0);
    }

    public void info(Function0 function0) {
        Logging$class.info(this, function0);
    }

    public Object info(Function0 function0) {
        return Logging$class.info(this, function0);
    }

    public void info(Function0 function0, Function0 function02) {
        Logging$class.info(this, function0, function02);
    }

    public void swallowInfo(Function0 function0) {
        Logging$class.swallowInfo(this, function0);
    }

    public void warn(Function0 function0) {
        Logging$class.warn(this, function0);
    }

    public Object warn(Function0 function0) {
        return Logging$class.warn(this, function0);
    }

    public void warn(Function0 function0, Function0 function02) {
        Logging$class.warn(this, function0, function02);
    }

    public void swallowWarn(Function0 function0) {
        Logging$class.swallowWarn(this, function0);
    }

    public void swallow(Function0 function0) {
        Logging$class.swallow(this, function0);
    }

    public void error(Function0 function0) {
        Logging$class.error(this, function0);
    }

    public Object error(Function0 function0) {
        return Logging$class.error(this, function0);
    }

    public void error(Function0 function0, Function0 function02) {
        Logging$class.error(this, function0, function02);
    }

    public void swallowError(Function0 function0) {
        Logging$class.swallowError(this, function0);
    }

    public void fatal(Function0 function0) {
        Logging$class.fatal(this, function0);
    }

    public Object fatal(Function0 function0) {
        return Logging$class.fatal(this, function0);
    }

    public void fatal(Function0 function0, Function0 function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public String path() {
        return this.path;
    }

    public String name() {
        return this.name;
    }

    private File hwFile() {
        return this.hwFile;
    }

    private ReentrantLock hwFileLock() {
        return this.hwFileLock;
    }

    public void write(Map<TopicAndPartition, Long> map) {
        this.hwFileLock().lock();
        try {
            File file = new File(Predef$.MODULE$.any2stringadd((Object)this.hwFile()).$plus(".tmp"));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(((Object)BoxesRunTime.boxToInteger((int)HighwaterMarkCheckpoint$.MODULE$.currentHighwaterMarkFileVersion())).toString());
            bufferedWriter.newLine();
            bufferedWriter.write(((Object)BoxesRunTime.boxToInteger((int)map.size())).toString());
            bufferedWriter.newLine();
            map.foreach((Function1)new $anonfun$write$1(this, bufferedWriter));
            bufferedWriter.flush();
            bufferedWriter.close();
            if (!file.renameTo(this.hwFile())) {
                this.hwFile().delete();
                if (!file.renameTo(this.hwFile())) {
                    this.fatal((Function0<String>)new $anonfun$write$2(this));
                    System.exit(1);
                }
            }
            return;
        }
        finally {
            this.hwFileLock().unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long read(String string, int n) {
        this.hwFileLock().lock();
        long l = 0L;
        try {
            long l2;
            long l3 = this.hwFile().length();
            if (l3 == 0L) {
                this.warn((Function0<String>)new $anonfun$read$1(this, string, n));
                l2 = 0L;
            } else {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(this.hwFile()));
                short s = Predef$.MODULE$.augmentString(bufferedReader.readLine()).toShort();
                short s2 = s;
                if (s2 == HighwaterMarkCheckpoint$.MODULE$.currentHighwaterMarkFileVersion()) {
                    Option option;
                    int n2 = Predef$.MODULE$.augmentString(bufferedReader.readLine()).toInt();
                    IndexedSeq indexedSeq = (IndexedSeq)((TraversableLike)Predef$.MODULE$.intWrapper(0).until(n2)).map((Function1)new $anonfun$1(this, bufferedReader), IndexedSeq$.MODULE$.canBuildFrom());
                    bufferedReader.close();
                    Option option2 = option = indexedSeq.toMap(Predef$.MODULE$.conforms()).get((Object)new TopicAndPartition(string, n));
                    if (option2 instanceof Some) {
                        long l4;
                        Some some = (Some)option2;
                        long l5 = l4 = BoxesRunTime.unboxToLong((Object)some.x());
                        this.debug((Function0<String>)new $anonfun$read$2(this, string, n, l5));
                        l2 = l5;
                    } else {
                        None$ none$ = None$.MODULE$;
                        Option option3 = option2;
                        if (none$ != null ? !none$.equals(option3) : option3 != null) throw new MatchError((Object)option2);
                        this.warn((Function0<String>)new $anonfun$read$3(this, string, n));
                        l2 = 0L;
                    }
                } else {
                    this.fatal((Function0<String>)new $anonfun$read$4(this, s));
                    System.exit(1);
                    l2 = -1L;
                }
            }
            l = l2;
            return l;
        }
        finally {
            this.hwFileLock().unlock();
        }
    }

    public HighwaterMarkCheckpoint(String string) {
        this.path = string;
        Logging$class.$init$(this);
        this.name = new StringBuilder().append((Object)string).append((Object)File.separator).append((Object)HighwaterMarkCheckpoint$.MODULE$.highWatermarkFileName()).toString();
        this.hwFile = new File(this.name());
        this.hwFileLock = new ReentrantLock();
    }
}

