/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.SocketChannel;
import kafka.common.ErrorMapping$;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.network.Send;
import kafka.network.Send$class;
import kafka.network.Transmission$class;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001i4\u0011\"\u0001\u0002\u0005\u0002\u0003\u0005\tA\u0001\u0004\u0003\u001d5+7o]1hKN+GoU3oI*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001cB\u0001A\u0004\u0010+A\u0011\u0001\"D\u0007\u0002\u0013)\u0011!bC\u0001\u0005Y\u0006twMC\u0001\r\u0003\u0011Q\u0017M^1\n\u00059I!AB(cU\u0016\u001cG\u000f\u0005\u0002\u0011'5\t\u0011C\u0003\u0002\u0013\t\u00059a.\u001a;x_J\\\u0017B\u0001\u000b\u0012\u0005\u0011\u0019VM\u001c3\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t9\u0001\u0011)\u0019!C\u0001=\u0005AQ.Z:tC\u001e,7o\u0001\u0001\u0016\u0003}\u0001\"\u0001I\u0012\u000e\u0003\u0005R!A\t\u0003\u0002\u000f5,7o]1hK&\u0011A%\t\u0002\u000b\u001b\u0016\u001c8/Y4f'\u0016$\b\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\u00135,7o]1hKN\u0004\u0003\u0002\u0003\u0015\u0001\u0005\u000b\u0007I\u0011A\u0015\u0002\u0013\u0015\u0014(o\u001c:D_\u0012,W#\u0001\u0016\u0011\u0005YY\u0013B\u0001\u0017\u0018\u0005\u0015\u0019\u0006n\u001c:u\u0011!q\u0003A!A!\u0002\u0013Q\u0013AC3se>\u00148i\u001c3fA!)\u0001\u0007\u0001C\u0001c\u00051A(\u001b8jiz\"2A\r\u001b6!\t\u0019\u0004!D\u0001\u0003\u0011\u0015ar\u00061\u0001 \u0011\u0015As\u00061\u0001+\u0011\u001d9\u0004\u00011A\u0005\na\nAa]3oiV\t\u0011\b\u0005\u0002\u0017u%\u00111h\u0006\u0002\u0004\u0013:$\bbB\u001f\u0001\u0001\u0004%IAP\u0001\tg\u0016tGo\u0018\u0013fcR\u0011qH\u0011\t\u0003-\u0001K!!Q\f\u0003\tUs\u0017\u000e\u001e\u0005\b\u0007r\n\t\u00111\u0001:\u0003\rAH%\r\u0005\u0007\u000b\u0002\u0001\u000b\u0015B\u001d\u0002\u000bM,g\u000e\u001e\u0011\t\u000f\u001d\u0003!\u0019!C\u0005q\u0005!1/\u001b>f\u0011\u0019I\u0005\u0001)A\u0005s\u0005)1/\u001b>fA!91\n\u0001b\u0001\n\u0013a\u0015A\u00025fC\u0012,'/F\u0001N!\tq\u0015+D\u0001P\u0015\t\u00016\"A\u0002oS>L!AU(\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000f\u0003\u0004U\u0001\u0001\u0006I!T\u0001\bQ\u0016\fG-\u001a:!\u0011\u001d1\u0006\u00011A\u0005\u0002]\u000b\u0001bY8na2,G/Z\u000b\u00021B\u0011a#W\u0005\u00035^\u0011qAQ8pY\u0016\fg\u000eC\u0004]\u0001\u0001\u0007I\u0011A/\u0002\u0019\r|W\u000e\u001d7fi\u0016|F%Z9\u0015\u0005}r\u0006bB\"\\\u0003\u0003\u0005\r\u0001\u0017\u0005\u0007A\u0002\u0001\u000b\u0015\u0002-\u0002\u0013\r|W\u000e\u001d7fi\u0016\u0004\u0003\"\u0002\u0019\u0001\t\u0003\u0011GC\u0001\u001ad\u0011\u0015a\u0012\r1\u0001 \u0011\u0015\u0001\u0004\u0001\"\u0001f)\u0005\u0011\u0004\"B4\u0001\t\u0003A\u0017aB<sSR,Gk\u001c\u000b\u0003s%DQA\u001b4A\u0002-\fqa\u00195b]:,G\u000e\u0005\u0002m_6\tQN\u0003\u0002o\u001f\u0006A1\r[1o]\u0016d7/\u0003\u0002q[\n!r)\u0019;iKJLgn\u001a\"zi\u0016\u001c\u0005.\u00198oK2DQA\u001d\u0001\u0005\u0002a\n\u0001b]3oINK'0\u001a\u0015\u0003\u0001Q\u0004\"!\u001e=\u000e\u0003YT!a\u001e\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005e4(!\u00048p]RD'/Z1eg\u00064W\r")
public class MessageSetSend
implements Send,
ScalaObject {
    private final MessageSet messages;
    private final short errorCode;
    private int sent;
    private final int size;
    private final ByteBuffer header;
    private boolean complete;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public int writeCompletely(GatheringByteChannel gatheringByteChannel) {
        return Send$class.writeCompletely(this, gatheringByteChannel);
    }

    public void expectIncomplete() {
        Transmission$class.expectIncomplete(this);
    }

    public void expectComplete() {
        Transmission$class.expectComplete(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        MessageSetSend messageSetSend = this;
        synchronized (messageSetSend) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 function0) {
        Logging$class.trace(this, function0);
    }

    public Object trace(Function0 function0) {
        return Logging$class.trace(this, function0);
    }

    public void trace(Function0 function0, Function0 function02) {
        Logging$class.trace(this, function0, function02);
    }

    public void swallowTrace(Function0 function0) {
        Logging$class.swallowTrace(this, function0);
    }

    public void debug(Function0 function0) {
        Logging$class.debug(this, function0);
    }

    public Object debug(Function0 function0) {
        return Logging$class.debug(this, function0);
    }

    public void debug(Function0 function0, Function0 function02) {
        Logging$class.debug(this, function0, function02);
    }

    public void swallowDebug(Function0 function0) {
        Logging$class.swallowDebug(this, function0);
    }

    public void info(Function0 function0) {
        Logging$class.info(this, function0);
    }

    public Object info(Function0 function0) {
        return Logging$class.info(this, function0);
    }

    public void info(Function0 function0, Function0 function02) {
        Logging$class.info(this, function0, function02);
    }

    public void swallowInfo(Function0 function0) {
        Logging$class.swallowInfo(this, function0);
    }

    public void warn(Function0 function0) {
        Logging$class.warn(this, function0);
    }

    public Object warn(Function0 function0) {
        return Logging$class.warn(this, function0);
    }

    public void warn(Function0 function0, Function0 function02) {
        Logging$class.warn(this, function0, function02);
    }

    public void swallowWarn(Function0 function0) {
        Logging$class.swallowWarn(this, function0);
    }

    public void swallow(Function0 function0) {
        Logging$class.swallow(this, function0);
    }

    public void error(Function0 function0) {
        Logging$class.error(this, function0);
    }

    public Object error(Function0 function0) {
        return Logging$class.error(this, function0);
    }

    public void error(Function0 function0, Function0 function02) {
        Logging$class.error(this, function0, function02);
    }

    public void swallowError(Function0 function0) {
        Logging$class.swallowError(this, function0);
    }

    public void fatal(Function0 function0) {
        Logging$class.fatal(this, function0);
    }

    public Object fatal(Function0 function0) {
        return Logging$class.fatal(this, function0);
    }

    public void fatal(Function0 function0, Function0 function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public MessageSet messages() {
        return this.messages;
    }

    public short errorCode() {
        return this.errorCode;
    }

    private int sent() {
        return this.sent;
    }

    private void sent_$eq(int n) {
        this.sent = n;
    }

    private int size() {
        return this.size;
    }

    private ByteBuffer header() {
        return this.header;
    }

    public boolean complete() {
        return this.complete;
    }

    public void complete_$eq(boolean bl) {
        this.complete = bl;
    }

    public MessageSetSend(MessageSet messageSet) {
        this(messageSet, ErrorMapping$.MODULE$.NoError());
    }

    public MessageSetSend() {
        this(MessageSet$.MODULE$.Empty());
    }

    public int writeTo(GatheringByteChannel gatheringByteChannel) {
        this.expectIncomplete();
        int n = 0;
        if (this.header().hasRemaining()) {
            n += gatheringByteChannel.write(this.header());
        }
        if (!this.header().hasRemaining()) {
            int n2 = this.messages().writeTo(gatheringByteChannel, this.sent(), this.size() - this.sent());
            n += n2;
            this.sent_$eq(this.sent() + n2);
        }
        if (this.logger().isTraceEnabled() && gatheringByteChannel instanceof SocketChannel) {
            SocketChannel socketChannel = (SocketChannel)gatheringByteChannel;
            this.logger().trace((Object)new StringBuilder().append(this.sent()).append((Object)" bytes written to ").append((Object)socketChannel.socket().getRemoteSocketAddress()).append((Object)" expecting to send ").append((Object)BoxesRunTime.boxToInteger((int)this.size())).append((Object)" bytes").toString());
        }
        if (this.sent() >= this.size()) {
            this.complete_$eq(true);
        }
        return n;
    }

    public int sendSize() {
        return this.size() + this.header().capacity();
    }

    public MessageSetSend(MessageSet messageSet, short s) {
        this.messages = messageSet;
        this.errorCode = s;
        Logging$class.$init$(this);
        Transmission$class.$init$(this);
        Send$class.$init$(this);
        this.sent = 0;
        this.size = messageSet.sizeInBytes();
        this.header = ByteBuffer.allocate(6);
        this.header().putInt(this.size() + 2);
        this.header().putShort(s);
        this.header().rewind();
        this.complete = false;
    }
}

