/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.OutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.api.PartitionOffsetsResponse;
import kafka.common.BrokerNotAvailableException;
import kafka.common.TopicAndPartition;
import kafka.consumer.SimpleConsumer;
import kafka.tools.ConsumerOffsetChecker$;
import kafka.tools.ConsumerOffsetChecker$$anonfun$kafka$tools$ConsumerOffsetChecker$;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$Int$;
import scala.math.Ordering$String$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ConsumerOffsetChecker$
implements Logging,
ScalaObject {
    public static final ConsumerOffsetChecker$ MODULE$;
    private final scala.collection.mutable.Map<Integer, Option<SimpleConsumer>> consumerMap;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ConsumerOffsetChecker$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ConsumerOffsetChecker$ consumerOffsetChecker$ = this;
        synchronized (consumerOffsetChecker$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 function0) {
        Logging$class.trace(this, function0);
    }

    public Object trace(Function0 function0) {
        return Logging$class.trace(this, function0);
    }

    public void trace(Function0 function0, Function0 function02) {
        Logging$class.trace(this, function0, function02);
    }

    public void swallowTrace(Function0 function0) {
        Logging$class.swallowTrace(this, function0);
    }

    public void debug(Function0 function0) {
        Logging$class.debug(this, function0);
    }

    public Object debug(Function0 function0) {
        return Logging$class.debug(this, function0);
    }

    public void debug(Function0 function0, Function0 function02) {
        Logging$class.debug(this, function0, function02);
    }

    public void swallowDebug(Function0 function0) {
        Logging$class.swallowDebug(this, function0);
    }

    public void info(Function0 function0) {
        Logging$class.info(this, function0);
    }

    public Object info(Function0 function0) {
        return Logging$class.info(this, function0);
    }

    public void info(Function0 function0, Function0 function02) {
        Logging$class.info(this, function0, function02);
    }

    public void swallowInfo(Function0 function0) {
        Logging$class.swallowInfo(this, function0);
    }

    public void warn(Function0 function0) {
        Logging$class.warn(this, function0);
    }

    public Object warn(Function0 function0) {
        return Logging$class.warn(this, function0);
    }

    public void warn(Function0 function0, Function0 function02) {
        Logging$class.warn(this, function0, function02);
    }

    public void swallowWarn(Function0 function0) {
        Logging$class.swallowWarn(this, function0);
    }

    public void swallow(Function0 function0) {
        Logging$class.swallow(this, function0);
    }

    public void error(Function0 function0) {
        Logging$class.error(this, function0);
    }

    public Object error(Function0 function0) {
        return Logging$class.error(this, function0);
    }

    public void error(Function0 function0, Function0 function02) {
        Logging$class.error(this, function0, function02);
    }

    public void swallowError(Function0 function0) {
        Logging$class.swallowError(this, function0);
    }

    public void fatal(Function0 function0) {
        Logging$class.fatal(this, function0);
    }

    public Object fatal(Function0 function0) {
        return Logging$class.fatal(this, function0);
    }

    public void fatal(Function0 function0, Function0 function02) {
        Logging$class.fatal(this, function0, function02);
    }

    private scala.collection.mutable.Map<Integer, Option<SimpleConsumer>> consumerMap() {
        return this.consumerMap;
    }

    public final Option kafka$tools$ConsumerOffsetChecker$$getConsumer(ZkClient zkClient, int n) {
        None$ none$ = null;
        try {
            Object object;
            Option<Object> option;
            Option option2 = (Option)ZkUtils$.MODULE$.readDataMaybeNull(zkClient, new StringBuilder().append((Object)ZkUtils$.MODULE$.BrokerIdsPath()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)n)).toString())._1();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String string = (String)some.x();
                String string2 = string;
                option = Json$.MODULE$.parseFull(string2);
                if (!(option instanceof Some)) {
                    None$ none$2 = None$.MODULE$;
                    Option<Object> option3 = option;
                    if (!(none$2 != null ? !none$2.equals(option3) : option3 != null)) {
                        throw new BrokerNotAvailableException(Predef$.MODULE$.augmentString("Broker id %d does not exist").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})));
                    }
                    throw new MatchError(option);
                }
            } else {
                None$ none$3 = None$.MODULE$;
                Option option4 = option2;
                if (!(none$3 != null ? !none$3.equals(option4) : option4 != null)) {
                    throw new BrokerNotAvailableException(Predef$.MODULE$.augmentString("Broker id %d does not exist").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})));
                }
                throw new MatchError((Object)option2);
            }
            Some some = (Some)option;
            Object object2 = object = some.x();
            Map map = (Map)object2;
            String string = (String)map.get((Object)"host").get();
            int n2 = BoxesRunTime.unboxToInt((Object)map.get((Object)"port").get());
            none$ = new Some((Object)new SimpleConsumer(string, n2, 10000, 100000, "ConsumerOffsetChecker"));
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new anonfun$kafka$tools$ConsumerOffsetChecker$$getConsumer$1(), (Function0<Throwable>)new anonfun$kafka$tools$ConsumerOffsetChecker$$getConsumer$2(throwable));
            none$ = None$.MODULE$;
        }
        return none$;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void kafka$tools$ConsumerOffsetChecker$$processPartition(ZkClient zkClient, String string, String string2, int n) {
        long l = Predef$.MODULE$.augmentString((String)ZkUtils$.MODULE$.readData(zkClient, Predef$.MODULE$.augmentString("/consumers/%s/offsets/%s/%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, string2, BoxesRunTime.boxToInteger((int)n)})))._1()).toLong();
        Option option = (Option)ZkUtils$.MODULE$.readDataMaybeNull(zkClient, Predef$.MODULE$.augmentString("/consumers/%s/owners/%s/%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, string2, BoxesRunTime.boxToInteger((int)n)})))._1();
        Option<Integer> option2 = ZkUtils$.MODULE$.getLeaderForPartition(zkClient, string2, n);
        if (option2 instanceof Some) {
            int n2;
            Some some = (Some)option2;
            int n3 = n2 = BoxesRunTime.unboxToInt((Object)some.x());
            Option option3 = (Option)this.consumerMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)n3), (Function0)new anonfun.1(zkClient, n3));
            Option option4 = option3;
            if (option4 instanceof Some) {
                Object object;
                SimpleConsumer simpleConsumer;
                Some some2 = (Some)option4;
                SimpleConsumer simpleConsumer2 = simpleConsumer = (SimpleConsumer)some2.x();
                TopicAndPartition topicAndPartition = new TopicAndPartition(string2, n);
                OffsetRequest offsetRequest = new OffsetRequest((scala.collection.immutable.Map<TopicAndPartition, PartitionOffsetRequestInfo>)((scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)topicAndPartition).$minus$greater((Object)new PartitionOffsetRequestInfo(OffsetRequest$.MODULE$.LatestTime(), 1))}))), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
                long l2 = BoxesRunTime.unboxToLong((Object)((PartitionOffsetsResponse)simpleConsumer2.getOffsetsBefore(offsetRequest).partitionErrorAndOffsets().apply((Object)topicAndPartition)).offsets().head());
                long l3 = l2 - l;
                StringOps stringOps = Predef$.MODULE$.augmentString("%-15s %-30s %-3s %-15s %-15s %-15s %s");
                Object[] objectArray = new Object[7];
                objectArray[0] = string;
                objectArray[1] = string2;
                objectArray[2] = BoxesRunTime.boxToInteger((int)n);
                objectArray[3] = BoxesRunTime.boxToLong((long)l);
                objectArray[4] = BoxesRunTime.boxToLong((long)l2);
                objectArray[5] = BoxesRunTime.boxToLong((long)l3);
                Option option5 = option;
                if (option5 instanceof Some) {
                    object = ((Some)option5).x();
                } else {
                    None$ none$ = None$.MODULE$;
                    Option option6 = option5;
                    if (none$ == null) {
                        if (option6 != null) {
                            throw new MatchError((Object)option5);
                        }
                    } else if (!none$.equals(option6)) throw new MatchError((Object)option5);
                    object = "none";
                }
                objectArray[6] = object;
                Predef$.MODULE$.println((Object)stringOps.format((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray)));
                simpleConsumer2.close();
                return;
            }
            None$ none$ = None$.MODULE$;
            Option option7 = option4;
            if (none$ == null) {
                if (option7 == null) return;
                throw new MatchError((Object)option4);
            }
            if (none$.equals(option7)) return;
            throw new MatchError((Object)option4);
        }
        None$ none$ = None$.MODULE$;
        Option<Integer> option8 = option2;
        if (none$ == null) {
            if (option8 != null) {
                throw new MatchError(option2);
            }
        } else if (!none$.equals(option8)) throw new MatchError(option2);
        this.error((Function0<String>)new anonfun$kafka$tools$ConsumerOffsetChecker$$processPartition$1(string2, n));
    }

    public final void kafka$tools$ConsumerOffsetChecker$$processTopic(ZkClient zkClient, String string, String string2) {
        Option option;
        block4: {
            block3: {
                block2: {
                    scala.collection.mutable.Map<String, Seq<Integer>> map = ZkUtils$.MODULE$.getPartitionsForTopics(zkClient, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{string2}))));
                    option = map.get((Object)string2);
                    if (!(option instanceof Some)) break block2;
                    ((IterableLike)((SeqLike)((Some)option).x()).sorted((Ordering)Ordering$Int$.MODULE$)).foreach((Function1)new anonfun$kafka$tools$ConsumerOffsetChecker$$processTopic$1(zkClient, string, string2));
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    private void printBrokerInfo() {
        Predef$.MODULE$.println((Object)"BROKER INFO");
        this.consumerMap().foreach((Function1)new anonfun.printBrokerInfo.1());
    }

    public void main(String[] stringArray) {
        OptionParser optionParser = new OptionParser();
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec = optionParser.accepts("zkconnect", "ZooKeeper connect string.").withRequiredArg().defaultsTo((Object)"localhost:2181", (Object[])new String[0]).ofType(String.class);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec2 = optionParser.accepts("topic", "Comma-separated list of consumer topics (all topics if absent).").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec3 = optionParser.accepts("group", "Consumer group.").withRequiredArg().ofType(String.class);
        optionParser.accepts("broker-info", "Print broker info");
        optionParser.accepts("help", "Print this message.");
        OptionSet optionSet = optionParser.parse(stringArray);
        if (optionSet.has("help")) {
            optionParser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{argumentAcceptingOptionSpec3})).foreach((Function1)new anonfun.main.1(optionParser, optionSet));
        String string = (String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec);
        String string2 = (String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec3);
        None$ none$ = optionSet.has((OptionSpec)argumentAcceptingOptionSpec2) ? new Some(optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec2)) : None$.MODULE$;
        ObjectRef objectRef = new ObjectRef(null);
        try {
            None$ none$2;
            block12: {
                List list;
                block11: {
                    block10: {
                        objectRef.elem = new ZkClient(string, 30000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
                        none$2 = none$;
                        if (!(none$2 instanceof Some)) break block10;
                        list = Predef$.MODULE$.refArrayOps((Object[])((String)((Some)none$2).x()).split(",")).view().toList();
                        break block11;
                    }
                    None$ none$3 = None$.MODULE$;
                    None$ none$4 = none$2;
                    if (none$3 != null ? !none$3.equals(none$4) : none$4 != null) break block12;
                    list = ZkUtils$.MODULE$.getChildren((ZkClient)objectRef.elem, Predef$.MODULE$.augmentString("/consumers/%s/offsets").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string2}))).toList();
                }
                List list2 = list;
                this.debug((Function0<String>)new anonfun.main.2(string, string2, list2));
                Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("%-15s %-30s %-3s %-15s %-15s %-15s %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Group", "Topic", "Pid", "Offset", "logSize", "Lag", "Owner"})));
                ((LinearSeqOptimized)list2.sorted((Ordering)Ordering$String$.MODULE$)).foreach((Function1)new anonfun.main.3(string2, objectRef));
                if (optionSet.has("broker-info")) {
                    this.printBrokerInfo();
                }
                return;
            }
            throw new MatchError((Object)none$2);
        }
        finally {
            this.consumerMap().values().foreach((Function1)new anonfun.main.4());
            if ((ZkClient)objectRef.elem != null) {
                ((ZkClient)objectRef.elem).close();
            }
        }
    }

    private ConsumerOffsetChecker$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.consumerMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }
}

