/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.api.FetchRequestBuilder;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionMetadata;
import kafka.api.Request$;
import kafka.api.TopicMetadata;
import kafka.client.ClientUtils$;
import kafka.cluster.Broker;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig$;
import kafka.consumer.DefaultMessageFormatter;
import kafka.consumer.MessageFormatter;
import kafka.consumer.MessageFormatter$;
import kafka.consumer.SimpleConsumer;
import kafka.tools.SimpleConsumerShell$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class SimpleConsumerShell$
implements Logging,
ScalaObject {
    public static final SimpleConsumerShell$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new SimpleConsumerShell$();
    }

    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        SimpleConsumerShell$ simpleConsumerShell$ = this;
        synchronized (simpleConsumerShell$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 function0) {
        Logging$class.trace(this, function0);
    }

    public Object trace(Function0 function0) {
        return Logging$class.trace(this, function0);
    }

    public void trace(Function0 function0, Function0 function02) {
        Logging$class.trace(this, function0, function02);
    }

    public void swallowTrace(Function0 function0) {
        Logging$class.swallowTrace(this, function0);
    }

    public void debug(Function0 function0) {
        Logging$class.debug(this, function0);
    }

    public Object debug(Function0 function0) {
        return Logging$class.debug(this, function0);
    }

    public void debug(Function0 function0, Function0 function02) {
        Logging$class.debug(this, function0, function02);
    }

    public void swallowDebug(Function0 function0) {
        Logging$class.swallowDebug(this, function0);
    }

    public void info(Function0 function0) {
        Logging$class.info(this, function0);
    }

    public Object info(Function0 function0) {
        return Logging$class.info(this, function0);
    }

    public void info(Function0 function0, Function0 function02) {
        Logging$class.info(this, function0, function02);
    }

    public void swallowInfo(Function0 function0) {
        Logging$class.swallowInfo(this, function0);
    }

    public void warn(Function0 function0) {
        Logging$class.warn(this, function0);
    }

    public Object warn(Function0 function0) {
        return Logging$class.warn(this, function0);
    }

    public void warn(Function0 function0, Function0 function02) {
        Logging$class.warn(this, function0, function02);
    }

    public void swallowWarn(Function0 function0) {
        Logging$class.swallowWarn(this, function0);
    }

    public void swallow(Function0 function0) {
        Logging$class.swallow(this, function0);
    }

    public void error(Function0 function0) {
        Logging$class.error(this, function0);
    }

    public Object error(Function0 function0) {
        return Logging$class.error(this, function0);
    }

    public void error(Function0 function0, Function0 function02) {
        Logging$class.error(this, function0, function02);
    }

    public void swallowError(Function0 function0) {
        Logging$class.swallowError(this, function0);
    }

    public void fatal(Function0 function0) {
        Logging$class.fatal(this, function0);
    }

    public Object fatal(Function0 function0) {
        return Logging$class.fatal(this, function0);
    }

    public void fatal(Function0 function0, Function0 function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public int UseLeaderReplica() {
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void main(String[] stringArray) {
        ObjectRef objectRef;
        FetchRequestBuilder fetchRequestBuilder;
        Properties properties;
        Class<?> clazz;
        boolean bl;
        boolean bl2;
        boolean bl3;
        int n;
        String string;
        int n2;
        LongRef longRef;
        int n3;
        int n4;
        String string2;
        block14: {
            Seq<PartitionMetadata> seq;
            Option option;
            OptionParser optionParser = new OptionParser();
            ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec = optionParser.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
            ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec2 = optionParser.accepts("topic", "REQUIRED: The topic to consume from.").withRequiredArg().describedAs("topic").ofType(String.class);
            ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec3 = optionParser.accepts("partition", "The partition to consume from.").withRequiredArg().describedAs("partition").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0), (Object[])new Integer[0]);
            ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec4 = optionParser.accepts("replica", "The replica id to consume from, default -1 means leader broker.").withRequiredArg().describedAs("replica id").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(this.UseLeaderReplica()), (Object[])new Integer[0]);
            ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec5 = optionParser.accepts("offset", "The offset id to consume from, default to -2 which means from beginning; while value -1 means from end").withRequiredArg().describedAs("consume offset").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(OffsetRequest$.MODULE$.EarliestTime()), (Object[])new Long[0]);
            ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec6 = optionParser.accepts("clientId", "The ID of this client.").withRequiredArg().describedAs("clientId").ofType(String.class).defaultsTo((Object)"SimpleConsumerShell", (Object[])new String[0]);
            ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec7 = optionParser.accepts("fetchsize", "The fetch size of each request.").withRequiredArg().describedAs("fetchsize").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x100000), (Object[])new Integer[0]);
            ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec8 = optionParser.accepts("formatter", "The name of a class to use for formatting kafka messages for display.").withRequiredArg().describedAs("class").ofType(String.class).defaultsTo((Object)DefaultMessageFormatter.class.getName(), (Object[])new String[0]);
            ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec9 = optionParser.accepts("property").withRequiredArg().describedAs("prop").ofType(String.class);
            OptionSpecBuilder optionSpecBuilder = optionParser.accepts("print-offsets", "Print the offsets returned by the iterator");
            ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec10 = optionParser.accepts("max-wait-ms", "The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1000), (Object[])new Integer[0]);
            ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec11 = optionParser.accepts("max-messages", "The number of messages to consume").withRequiredArg().describedAs("max-messages").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(Integer.MAX_VALUE), (Object[])new Integer[0]);
            OptionSpecBuilder optionSpecBuilder2 = optionParser.accepts("skip-message-on-error", "If there is an error when processing a message, skip it instead of halt.");
            OptionSpecBuilder optionSpecBuilder3 = optionParser.accepts("no-wait-at-logend", "If set, when the simple consumer reaches the end of the Log, it will stop, not waiting for new produced messages");
            OptionSet optionSet = optionParser.parse(stringArray);
            List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{argumentAcceptingOptionSpec, argumentAcceptingOptionSpec2, argumentAcceptingOptionSpec3})).foreach((Function1)new anonfun.main.1(optionParser, optionSet));
            string2 = (String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec2);
            n4 = (Integer)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec3);
            n3 = (Integer)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec4);
            longRef = new LongRef(((Long)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec5)).longValue());
            n2 = (Integer)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec7);
            string = ((String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec6)).toString();
            int n5 = (Integer)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec10);
            n = (Integer)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec11);
            bl3 = optionSet.has((OptionSpec)optionSpecBuilder2);
            bl2 = optionSet.has((OptionSpec)optionSpecBuilder);
            bl = optionSet.has((OptionSpec)optionSpecBuilder3);
            clazz = Class.forName((String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec8));
            properties = MessageFormatter$.MODULE$.tryParseFormatterArgs((Iterable<String>)JavaConversions$.MODULE$.asBuffer(optionSet.valuesOf((OptionSpec)argumentAcceptingOptionSpec9)));
            fetchRequestBuilder = new FetchRequestBuilder().clientId(string).replicaId(Request$.MODULE$.DebuggingConsumerId()).maxWait(n5).minBytes(ConsumerConfig$.MODULE$.MinFetchBytes());
            this.info((Function0<String>)new anonfun.main.2());
            Seq<Broker> seq2 = ClientUtils$.MODULE$.parseBrokerList((String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec));
            Seq<TopicMetadata> seq3 = ClientUtils$.MODULE$.fetchTopicMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{string2}))), seq2, string, n5, ClientUtils$.MODULE$.fetchTopicMetadata$default$5()).topicsMetadata();
            if (seq3.size() != 1 || !((TopicMetadata)seq3.apply(0)).topic().equals(string2)) {
                System.err.println(Predef$.MODULE$.augmentString("Error: no valid topic metadata for topic: %s, what we get from server is only: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string2, seq3})));
                System.exit(1);
            }
            if (!(option = (seq = ((TopicMetadata)seq3.apply(0)).partitionsMetadata()).find((Function1)new anonfun.1(n4))).isDefined()) {
                System.err.println(Predef$.MODULE$.augmentString("Error: partition %d does not exist for topic %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n4), string2})));
                System.exit(1);
            }
            objectRef = new ObjectRef(null);
            Option option2 = null;
            if (n3 == this.UseLeaderReplica()) {
                option2 = ((PartitionMetadata)option.get()).leader();
                if (!option2.isDefined()) {
                    System.err.println(Predef$.MODULE$.augmentString("Error: user speicifies to fetch from leader for partition (%s, %d) which has not been elected yet").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n3), string2, BoxesRunTime.boxToInteger((int)n4)})));
                    System.exit(1);
                }
            } else {
                Seq<Broker> seq4 = ((PartitionMetadata)option.get()).replicas();
                option2 = seq4.find((Function1)new anonfun.main.3(n3));
                if (!option2.isDefined()) {
                    System.err.println(Predef$.MODULE$.augmentString("Error: replica %d does not exist for partition (%s, %d)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n3), string2, BoxesRunTime.boxToInteger((int)n4)})));
                    System.exit(1);
                }
            }
            objectRef.elem = (Broker)option2.get();
            if (longRef.elem < OffsetRequest$.MODULE$.EarliestTime()) {
                System.err.println(Predef$.MODULE$.augmentString("Invalid starting offset: %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)longRef.elem)})));
                System.exit(1);
            }
            if (longRef.elem < 0L) {
                SimpleConsumer simpleConsumer = new SimpleConsumer(((Broker)objectRef.elem).host(), ((Broker)objectRef.elem).port(), ConsumerConfig$.MODULE$.SocketTimeout(), ConsumerConfig$.MODULE$.SocketBufferSize(), string);
                try {
                    longRef.elem = simpleConsumer.earliestOrLatestOffset(new TopicAndPartition(string2, n4), longRef.elem, Request$.MODULE$.DebuggingConsumerId());
                    if (simpleConsumer != null) {
                        simpleConsumer.close();
                    }
                }
                catch (Throwable throwable) {
                    try {
                        System.err.println(new StringBuilder().append((Object)"Error in getting earliest or latest offset due to: ").append((Object)Utils$.MODULE$.stackTrace(throwable)).toString());
                        System.exit(1);
                    }
                    finally {
                        if (simpleConsumer == null) break block14;
                        simpleConsumer.close();
                    }
                }
            }
        }
        MessageFormatter messageFormatter = (MessageFormatter)clazz.newInstance();
        messageFormatter.init(properties);
        String string3 = n3 > 0 ? "leader" : "replica";
        this.info((Function0<String>)new anonfun.main.4(string2, n4, n3, longRef, objectRef, string3));
        SimpleConsumer simpleConsumer = new SimpleConsumer(((Broker)objectRef.elem).host(), ((Broker)objectRef.elem).port(), 10000, 65536, string);
        Thread thread = Utils$.MODULE$.newThread("kafka-simpleconsumer-shell", new anon.1(string2, n4, n3, longRef, n2, n, bl3, bl2, bl, fetchRequestBuilder, messageFormatter, simpleConsumer), false);
        thread.start();
        thread.join();
        System.out.flush();
        messageFormatter.close();
        simpleConsumer.close();
    }

    private SimpleConsumerShell$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

