/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.zip.CRC32;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.common.KafkaException;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.Ordering$String$;
import scala.package$;
import scala.reflect.ClassManifest;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.NoManifest$;
import scala.reflect.OptManifest;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class Utils$
implements Logging,
ScalaObject {
    public static final Utils$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new Utils$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 function0) {
        Logging$class.trace(this, function0);
    }

    public Object trace(Function0 function0) {
        return Logging$class.trace(this, function0);
    }

    public void trace(Function0 function0, Function0 function02) {
        Logging$class.trace(this, function0, function02);
    }

    public void swallowTrace(Function0 function0) {
        Logging$class.swallowTrace(this, function0);
    }

    public void debug(Function0 function0) {
        Logging$class.debug(this, function0);
    }

    public Object debug(Function0 function0) {
        return Logging$class.debug(this, function0);
    }

    public void debug(Function0 function0, Function0 function02) {
        Logging$class.debug(this, function0, function02);
    }

    public void swallowDebug(Function0 function0) {
        Logging$class.swallowDebug(this, function0);
    }

    public void info(Function0 function0) {
        Logging$class.info(this, function0);
    }

    public Object info(Function0 function0) {
        return Logging$class.info(this, function0);
    }

    public void info(Function0 function0, Function0 function02) {
        Logging$class.info(this, function0, function02);
    }

    public void swallowInfo(Function0 function0) {
        Logging$class.swallowInfo(this, function0);
    }

    public void warn(Function0 function0) {
        Logging$class.warn(this, function0);
    }

    public Object warn(Function0 function0) {
        return Logging$class.warn(this, function0);
    }

    public void warn(Function0 function0, Function0 function02) {
        Logging$class.warn(this, function0, function02);
    }

    public void swallowWarn(Function0 function0) {
        Logging$class.swallowWarn(this, function0);
    }

    public void swallow(Function0 function0) {
        Logging$class.swallow(this, function0);
    }

    public void error(Function0 function0) {
        Logging$class.error(this, function0);
    }

    public Object error(Function0 function0) {
        return Logging$class.error(this, function0);
    }

    public void error(Function0 function0, Function0 function02) {
        Logging$class.error(this, function0, function02);
    }

    public void swallowError(Function0 function0) {
        Logging$class.swallowError(this, function0);
    }

    public void fatal(Function0 function0) {
        Logging$class.fatal(this, function0);
    }

    public Object fatal(Function0 function0) {
        return Logging$class.fatal(this, function0);
    }

    public void fatal(Function0 function0, Function0 function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public /* synthetic */ String readString$default$2() {
        return Charset.defaultCharset().toString();
    }

    public /* synthetic */ Charset readFileAsString$default$2() {
        return Charset.defaultCharset();
    }

    public Runnable runnable(Function0<Object> function0) {
        return new anon.1(function0);
    }

    public Runnable loggedRunnable(Function0<Object> function0, String string) {
        return new anon.2(function0, string);
    }

    public Thread daemonThread(Runnable runnable) {
        return this.newThread(runnable, true);
    }

    public Thread daemonThread(String string, Runnable runnable) {
        return this.newThread(string, runnable, true);
    }

    public Thread daemonThread(String string, Function0<Object> function0) {
        return this.daemonThread(string, this.runnable(function0));
    }

    public Thread newThread(String string, Runnable runnable, boolean bl) {
        Thread thread = new Thread(runnable, string);
        thread.setDaemon(bl);
        thread.setUncaughtExceptionHandler(new anon.3());
        return thread;
    }

    public Thread newThread(Runnable runnable, boolean bl) {
        Thread thread = new Thread(runnable);
        thread.setDaemon(bl);
        thread.setUncaughtExceptionHandler(new anon.4());
        return thread;
    }

    public byte[] readBytes(ByteBuffer byteBuffer) {
        return this.readBytes(byteBuffer, 0, byteBuffer.limit());
    }

    public byte[] readBytes(ByteBuffer byteBuffer, int n, int n2) {
        Buffer buffer;
        byte[] byArray = new byte[n2];
        if (byteBuffer.hasArray()) {
            System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset() + n, byArray, 0, n2);
            buffer = BoxedUnit.UNIT;
        } else {
            byteBuffer.mark();
            byteBuffer.get(byArray);
            buffer = byteBuffer.reset();
        }
        return byArray;
    }

    public Properties loadProps(String string) {
        FileInputStream fileInputStream = new FileInputStream(string);
        Properties properties = new Properties();
        properties.load(fileInputStream);
        return properties;
    }

    public FileChannel openChannel(File file, boolean bl) {
        return bl ? new RandomAccessFile(file, "rw").getChannel() : new FileInputStream(file).getChannel();
    }

    public void swallow(Function2<Object, Throwable, Object> function2, Function0<Object> function0) {
        try {
            function0.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            function2.apply((Object)throwable.getMessage(), (Object)throwable);
        }
    }

    public boolean equal(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        Object object = new Object();
        boolean bl = false;
        try {
            if (byteBuffer.position() != byteBuffer2.position()) {
                return false;
            }
            if (byteBuffer.remaining() != byteBuffer2.remaining()) {
                return false;
            }
            Predef$.MODULE$.intWrapper(0).until(byteBuffer.remaining()).foreach$mVc$sp((Function1)new anonfun.equal.1(byteBuffer, byteBuffer2, object));
            return true;
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                bl = BoxesRunTime.unboxToBoolean((Object)nonLocalReturnControl.value());
                return bl;
            }
            throw nonLocalReturnControl;
        }
    }

    public String readString(ByteBuffer byteBuffer, String string) {
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        return new String(byArray, string);
    }

    public void croak(String string) {
        System.err.println(string);
        System.exit(1);
    }

    public void rm(String string) {
        this.rm(new File(string));
    }

    public void rm(Seq<String> seq) {
        seq.map((Function1)new anonfun.rm.1(), Seq$.MODULE$.canBuildFrom());
    }

    public void rm(File file) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                Predef$.MODULE$.refArrayOps((Object[])fileArray).foreach((Function1)new anonfun.rm.2());
            }
            file.delete();
        } else {
            file.delete();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean registerMBean(Object object, String string) {
        boolean bl = false;
        try {
            MBeanServer mBeanServer;
            MBeanServer mBeanServer2 = mBeanServer = ManagementFactory.getPlatformMBeanServer();
            synchronized (mBeanServer2) {
                ObjectName objectName = new ObjectName(string);
                if (mBeanServer.isRegistered(objectName)) {
                    mBeanServer.unregisterMBean(objectName);
                }
                mBeanServer.registerMBean(object, objectName);
                Boolean bl2 = BoxesRunTime.boxToBoolean((boolean)true);
                return BoxesRunTime.unboxToBoolean((Object)bl2);
            }
        }
        catch (Exception exception) {
            this.error((Function0<String>)new anonfun.registerMBean.1(string), (Function0<Throwable>)new anonfun.registerMBean.2(exception));
            return false;
        }
    }

    public void unregisterMBean(String string) {
        MBeanServer mBeanServer;
        MBeanServer mBeanServer2 = mBeanServer = ManagementFactory.getPlatformMBeanServer();
        synchronized (mBeanServer2) {
            BoxedUnit boxedUnit;
            ObjectName objectName = new ObjectName(string);
            if (mBeanServer.isRegistered(objectName)) {
                mBeanServer.unregisterMBean(objectName);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public long readUnsignedInt(ByteBuffer byteBuffer) {
        return (long)byteBuffer.getInt() & 0xFFFFFFFFL;
    }

    public long readUnsignedInt(ByteBuffer byteBuffer, int n) {
        return (long)byteBuffer.getInt(n) & 0xFFFFFFFFL;
    }

    public void writetUnsignedInt(ByteBuffer byteBuffer, long l) {
        byteBuffer.putInt((int)(l & 0xFFFFFFFFL));
    }

    public void writeUnsignedInt(ByteBuffer byteBuffer, int n, long l) {
        byteBuffer.putInt(n, (int)(l & 0xFFFFFFFFL));
    }

    public long crc32(byte[] byArray) {
        return this.crc32(byArray, 0, byArray.length);
    }

    public long crc32(byte[] byArray, int n, int n2) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, n, n2);
        return cRC32.getValue();
    }

    public int hashcode(Seq<Object> seq) {
        if (seq == null) {
            return 0;
        }
        int n = 1;
        int n2 = 0;
        while (n2 < seq.length()) {
            if (seq.apply(n2) == null) continue;
            n = 31 * n + seq.apply(n2).hashCode();
            ++n2;
        }
        return n;
    }

    public <K, V> Map<K, List<V>> groupby(Iterable<V> iterable, Function1<V, K> function1) {
        HashMap hashMap = new HashMap();
        iterable.foreach((Function1)new anonfun.groupby.1(function1, hashMap));
        return hashMap;
    }

    public int read(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) {
        int n = readableByteChannel.read(byteBuffer);
        if (n == -1) {
            throw new EOFException("Received -1 when reading from channel, socket has likely been closed.");
        }
        if (BoxesRunTime.boxToInteger((int)n) instanceof Integer) {
            return n;
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    public <V> V notNull(V v) {
        if (v == null) {
            throw new KafkaException("Value cannot be null.");
        }
        return v;
    }

    public Tuple2<String, Integer> parseHostPort(String string) {
        String[] stringArray = string.split(":");
        return new Tuple2((Object)stringArray[0], (Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.augmentString(stringArray[1]).toInt()));
    }

    public String stackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public Map<String, String> parseCsvMap(String string) {
        HashMap hashMap = new HashMap();
        if ("".equals(string)) {
            return hashMap;
        }
        String[][] stringArray = (String[][])Predef$.MODULE$.refArrayOps((Object[])string.split("\\s*,\\s*")).map((Function1)new anonfun.2(), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.arrayType((OptManifest)ClassManifest$.MODULE$.classType(String.class))));
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])stringArray).map((Function1)new anonfun.parseCsvMap.1(), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(Tuple2.class, (OptManifest)ClassManifest$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{ClassManifest$.MODULE$.classType(String.class)}))))).toMap(Predef$.MODULE$.conforms());
    }

    public Seq<String> parseCsvList(String string) {
        return string == null || string.isEmpty() ? (Seq)Seq$.MODULE$.empty() : Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])string.split("\\s*,\\s*")).filter((Function1)new anonfun.parseCsvList.1()));
    }

    public <T> T createObject(String string, Seq<Object> seq) {
        Class<?> clazz = Class.forName(string);
        Constructor<?> constructor = clazz.getConstructor((Class[])((TraversableOnce)seq.map((Function1)new anonfun.3(), Seq$.MODULE$.canBuildFrom())).toArray(ClassManifest$.MODULE$.classType(Class.class, (OptManifest)NoManifest$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[0]))));
        return (T)constructor.newInstance((Object[])seq.toArray((ClassManifest)Manifest$.MODULE$.Object()));
    }

    public boolean nullOrEmpty(String string) {
        return string == null || string.equals("");
    }

    public String mergeJsonFields(Seq<String> seq) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{ ");
        stringBuilder.append(((TraversableOnce)((TraversableLike)seq.sorted((Ordering)Ordering$String$.MODULE$)).map((Function1)new anonfun.mergeJsonFields.1(), Seq$.MODULE$.canBuildFrom())).mkString(", "));
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    public Seq<String> mapToJsonFields(Map<String, String> map, boolean bl) {
        ListBuffer listBuffer = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        ((LinearSeqOptimized)map.toList().sorted(Ordering$.MODULE$.Tuple2((Ordering)Ordering$String$.MODULE$, (Ordering)Ordering$String$.MODULE$))).foreach((Function1)new anonfun.mapToJsonFields.1(bl, listBuffer, stringBuilder));
        return listBuffer;
    }

    public String mapToJson(Map<String, String> map, boolean bl) {
        return this.mergeJsonFields(this.mapToJsonFields(map, bl));
    }

    public String seqToJson(Seq<String> seq, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ ");
        StringBuilder stringBuilder2 = bl ? stringBuilder.append(((TraversableOnce)seq.map((Function1)new anonfun.seqToJson.1(), Seq$.MODULE$.canBuildFrom())).mkString(", ")) : stringBuilder.append(seq.mkString(", "));
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }

    public String mapWithSeqValuesToJson(Map<String, Seq<Integer>> map) {
        return this.mergeJsonFields(this.mapToJsonFields((Map<String, String>)((Map)map.map((Function1)new anonfun.mapWithSeqValuesToJson.1(), Map$.MODULE$.canBuildFrom())), false));
    }

    public <T> Iterator<T> circularIterator(Iterable<T> iterable) {
        Stream stream = (Stream)package$.MODULE$.Stream().continually((Function0)new anonfun.1()).flatMap((Function1)new anonfun.4(iterable), Stream$.MODULE$.canBuildFrom());
        return stream.iterator();
    }

    public String readFileAsString(String string, Charset charset) {
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        String string2 = null;
        try {
            FileChannel fileChannel = fileInputStream.getChannel();
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
            string2 = charset.decode(mappedByteBuffer).toString();
            return string2;
        }
        finally {
            fileInputStream.close();
        }
    }

    public int abs(int n) {
        return n & Integer.MAX_VALUE;
    }

    private Utils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

