/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import kafka.admin.AdministrationException;
import kafka.admin.PreferredReplicaLeaderElectionCommand$;
import kafka.api.LeaderAndIsr;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.Cluster;
import kafka.common.KafkaException;
import kafka.common.NoEpochForPartitionException;
import kafka.common.TopicAndPartition;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReassignedPartitionsContext;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.ZKGroupDirs;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.log4j.Logger;
import org.apache.zookeeper.data.Stat;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$Int$;
import scala.math.Ordering$String$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ZkUtils$
implements Logging,
ScalaObject {
    public static final ZkUtils$ MODULE$;
    private final String ConsumersPath;
    private final String BrokerIdsPath;
    private final String BrokerTopicsPath;
    private final String ControllerPath;
    private final String ControllerEpochPath;
    private final String ReassignPartitionsPath;
    private final String PreferredReplicaLeaderElectionPath;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ZkUtils$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ZkUtils$ zkUtils$ = this;
        synchronized (zkUtils$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 function0) {
        Logging$class.trace(this, function0);
    }

    public Object trace(Function0 function0) {
        return Logging$class.trace(this, function0);
    }

    public void trace(Function0 function0, Function0 function02) {
        Logging$class.trace(this, function0, function02);
    }

    public void swallowTrace(Function0 function0) {
        Logging$class.swallowTrace(this, function0);
    }

    public void debug(Function0 function0) {
        Logging$class.debug(this, function0);
    }

    public Object debug(Function0 function0) {
        return Logging$class.debug(this, function0);
    }

    public void debug(Function0 function0, Function0 function02) {
        Logging$class.debug(this, function0, function02);
    }

    public void swallowDebug(Function0 function0) {
        Logging$class.swallowDebug(this, function0);
    }

    public void info(Function0 function0) {
        Logging$class.info(this, function0);
    }

    public Object info(Function0 function0) {
        return Logging$class.info(this, function0);
    }

    public void info(Function0 function0, Function0 function02) {
        Logging$class.info(this, function0, function02);
    }

    public void swallowInfo(Function0 function0) {
        Logging$class.swallowInfo(this, function0);
    }

    public void warn(Function0 function0) {
        Logging$class.warn(this, function0);
    }

    public Object warn(Function0 function0) {
        return Logging$class.warn(this, function0);
    }

    public void warn(Function0 function0, Function0 function02) {
        Logging$class.warn(this, function0, function02);
    }

    public void swallowWarn(Function0 function0) {
        Logging$class.swallowWarn(this, function0);
    }

    public void swallow(Function0 function0) {
        Logging$class.swallow(this, function0);
    }

    public void error(Function0 function0) {
        Logging$class.error(this, function0);
    }

    public Object error(Function0 function0) {
        return Logging$class.error(this, function0);
    }

    public void error(Function0 function0, Function0 function02) {
        Logging$class.error(this, function0, function02);
    }

    public void swallowError(Function0 function0) {
        Logging$class.swallowError(this, function0);
    }

    public void fatal(Function0 function0) {
        Logging$class.fatal(this, function0);
    }

    public Object fatal(Function0 function0) {
        return Logging$class.fatal(this, function0);
    }

    public void fatal(Function0 function0, Function0 function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public /* synthetic */ String createSequentialPersistentPath$default$3() {
        return "";
    }

    public /* synthetic */ String createPersistentPath$default$3() {
        return "";
    }

    public String ConsumersPath() {
        return this.ConsumersPath;
    }

    public String BrokerIdsPath() {
        return this.BrokerIdsPath;
    }

    public String BrokerTopicsPath() {
        return this.BrokerTopicsPath;
    }

    public String ControllerPath() {
        return this.ControllerPath;
    }

    public String ControllerEpochPath() {
        return this.ControllerEpochPath;
    }

    public String ReassignPartitionsPath() {
        return this.ReassignPartitionsPath;
    }

    public String PreferredReplicaLeaderElectionPath() {
        return this.PreferredReplicaLeaderElectionPath;
    }

    public String getTopicPath(String string) {
        return new StringBuilder().append((Object)this.BrokerTopicsPath()).append((Object)"/").append((Object)string).toString();
    }

    public String getTopicPartitionsPath(String string) {
        return new StringBuilder().append((Object)this.getTopicPath(string)).append((Object)"/partitions").toString();
    }

    public int getController(ZkClient zkClient) {
        Option option = (Option)this.readDataMaybeNull(zkClient, this.ControllerPath())._1();
        if (option instanceof Some) {
            return Predef$.MODULE$.augmentString((String)((Some)option).x()).toInt();
        }
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new KafkaException("Controller doesn't exist");
        }
        throw new MatchError((Object)option);
    }

    public String getTopicPartitionPath(String string, int n) {
        return new StringBuilder().append((Object)this.getTopicPartitionsPath(string)).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)n)).toString();
    }

    public String getTopicPartitionLeaderAndIsrPath(String string, int n) {
        return new StringBuilder().append((Object)this.getTopicPartitionPath(string, n)).append((Object)"/").append((Object)"state").toString();
    }

    public Seq<Integer> getSortedBrokerList(ZkClient zkClient) {
        return (Seq)((SeqLike)this.getChildren(zkClient, this.BrokerIdsPath()).map((Function1)new anonfun.getSortedBrokerList.1(), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering$Int$.MODULE$);
    }

    public Seq<Broker> getAllBrokersInCluster(ZkClient zkClient) {
        Seq seq = (Seq)this.getChildrenParentMayNotExist(zkClient, this.BrokerIdsPath()).sorted((Ordering)Ordering$String$.MODULE$);
        return (Seq)((TraversableLike)((TraversableLike)((TraversableLike)seq.map((Function1)new anonfun.getAllBrokersInCluster.1(), Seq$.MODULE$.canBuildFrom())).map((Function1)new anonfun.getAllBrokersInCluster.2(zkClient), Seq$.MODULE$.canBuildFrom())).filter((Function1)new anonfun.getAllBrokersInCluster.3())).map((Function1)new anonfun.getAllBrokersInCluster.4(), Seq$.MODULE$.canBuildFrom());
    }

    public Option<LeaderIsrAndControllerEpoch> getLeaderIsrAndEpochForPartition(ZkClient zkClient, String string, int n) {
        Option option;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    String string2 = this.getTopicPartitionLeaderAndIsrPath(string, n);
                    Tuple2<Option<String>, Stat> tuple2 = this.readDataMaybeNull(zkClient, string2);
                    Option option2 = (Option)tuple2._1();
                    Stat stat = (Stat)tuple2._2();
                    option = option2;
                    if (!(option instanceof Some)) break block2;
                    none$ = this.parseLeaderAndIsr((String)((Some)option).x(), string, n, stat);
                    break block3;
                }
                None$ none$2 = None$.MODULE$;
                Option option3 = option;
                if (none$2 != null ? !none$2.equals(option3) : option3 != null) break block4;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError((Object)option);
    }

    public Option<LeaderAndIsr> getLeaderAndIsrForPartition(ZkClient zkClient, String string, int n) {
        return this.getLeaderIsrAndEpochForPartition(zkClient, string, n).map((Function1)new anonfun.getLeaderAndIsrForPartition.1());
    }

    public Option<LeaderIsrAndControllerEpoch> parseLeaderAndIsr(String string, String string2, int n, Stat stat) {
        Option<Object> option;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    Object object;
                    option = Json$.MODULE$.parseFull(string);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Object object2 = object = some.x();
                    Map map = (Map)object2;
                    int n2 = BoxesRunTime.unboxToInt((Object)map.get((Object)"leader").get());
                    int n3 = BoxesRunTime.unboxToInt((Object)map.get((Object)"leader_epoch").get());
                    List list = (List)map.get((Object)"isr").get();
                    int n4 = BoxesRunTime.unboxToInt((Object)map.get((Object)"controller_epoch").get());
                    int n5 = stat.getVersion();
                    this.debug((Function0<String>)new anonfun.parseLeaderAndIsr.1(string2, n, n2, n3, list, n5));
                    none$ = new Some((Object)new LeaderIsrAndControllerEpoch(new LeaderAndIsr(n2, n3, (List<Integer>)list, n5), n4));
                    break block3;
                }
                None$ none$2 = None$.MODULE$;
                Option<Object> option2 = option;
                if (none$2 != null ? !none$2.equals(option2) : option2 != null) break block4;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError(option);
    }

    public Option<Integer> getLeaderForPartition(ZkClient zkClient, String string, int n) {
        Option option;
        block6: {
            None$ none$;
            block4: {
                block2: {
                    Option<Object> option2;
                    block5: {
                        block3: {
                            Option option3 = (Option)this.readDataMaybeNull(zkClient, this.getTopicPartitionLeaderAndIsrPath(string, n))._1();
                            option = option3;
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            String string2 = (String)some.x();
                            String string3 = string2;
                            option2 = Json$.MODULE$.parseFull(string3);
                            if (!(option2 instanceof Some)) break block3;
                            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)((Map)((Some)option2).x()).get((Object)"leader").get())));
                            break block4;
                        }
                        None$ none$2 = None$.MODULE$;
                        Option<Object> option4 = option2;
                        if (none$2 != null ? !none$2.equals(option4) : option4 != null) break block5;
                        none$ = None$.MODULE$;
                        break block4;
                    }
                    throw new MatchError(option2);
                }
                None$ none$3 = None$.MODULE$;
                Option option5 = option;
                if (none$3 != null ? !none$3.equals(option5) : option5 != null) break block6;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError((Object)option);
    }

    public int getEpochForPartition(ZkClient zkClient, String string, int n) {
        Option option = (Option)this.readDataMaybeNull(zkClient, this.getTopicPartitionLeaderAndIsrPath(string, n))._1();
        Option option2 = option;
        if (option2 instanceof Some) {
            String string2;
            Some some = (Some)option2;
            String string3 = string2 = (String)some.x();
            Option<Object> option3 = Json$.MODULE$.parseFull(string3);
            None$ none$ = None$.MODULE$;
            Option<Object> option4 = option3;
            if (!(none$ != null ? !none$.equals(option4) : option4 != null)) {
                throw new NoEpochForPartitionException(Predef$.MODULE$.augmentString("No epoch, leaderAndISR data for partition [%s,%d] is invalid").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, BoxesRunTime.boxToInteger((int)n)})));
            }
            if (option3 instanceof Some) {
                return BoxesRunTime.unboxToInt((Object)((Map)((Some)option3).x()).get((Object)"leader_epoch").get());
            }
            throw new MatchError(option3);
        }
        None$ none$ = None$.MODULE$;
        Option option5 = option2;
        if (!(none$ != null ? !none$.equals(option5) : option5 != null)) {
            throw new NoEpochForPartitionException(Predef$.MODULE$.augmentString("No epoch, ISR path for partition [%s,%d] is empty").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, BoxesRunTime.boxToInteger((int)n)})));
        }
        throw new MatchError((Object)option2);
    }

    public Seq<Integer> getInSyncReplicasForPartition(ZkClient zkClient, String string, int n) {
        Option option;
        block6: {
            Seq seq;
            block4: {
                block2: {
                    Option<Object> option2;
                    block5: {
                        block3: {
                            Option option3 = (Option)this.readDataMaybeNull(zkClient, this.getTopicPartitionLeaderAndIsrPath(string, n))._1();
                            option = option3;
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            String string2 = (String)some.x();
                            String string3 = string2;
                            option2 = Json$.MODULE$.parseFull(string3);
                            if (!(option2 instanceof Some)) break block3;
                            seq = (Seq)((Map)((Some)option2).x()).get((Object)"isr").get();
                            break block4;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<Object> option4 = option2;
                        if (none$ != null ? !none$.equals(option4) : option4 != null) break block5;
                        seq = (Seq)Seq$.MODULE$.empty();
                        break block4;
                    }
                    throw new MatchError(option2);
                }
                None$ none$ = None$.MODULE$;
                Option option5 = option;
                if (none$ != null ? !none$.equals(option5) : option5 != null) break block6;
                seq = (Seq)Seq$.MODULE$.empty();
            }
            return seq;
        }
        throw new MatchError((Object)option);
    }

    public Seq<Integer> getReplicasForPartition(ZkClient zkClient, String string, int n) {
        Option option;
        block10: {
            Seq seq;
            block6: {
                block2: {
                    Option<Object> option2;
                    block9: {
                        block3: {
                            Option option3;
                            block8: {
                                block4: {
                                    Option option4;
                                    block7: {
                                        block5: {
                                            Option option5 = (Option)this.readDataMaybeNull(zkClient, this.getTopicPath(string))._1();
                                            option = option5;
                                            if (!(option instanceof Some)) break block2;
                                            Some some = (Some)option;
                                            String string2 = (String)some.x();
                                            String string3 = string2;
                                            option2 = Json$.MODULE$.parseFull(string3);
                                            if (!(option2 instanceof Some)) break block3;
                                            Some some2 = (Some)option2;
                                            Object object = some2.x();
                                            Object object2 = object;
                                            option3 = ((Map)object2).get((Object)"partitions");
                                            if (!(option3 instanceof Some)) break block4;
                                            Some some3 = (Some)option3;
                                            Object object3 = some3.x();
                                            Object object4 = object3;
                                            option4 = ((Map)object4).get((Object)((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                                            if (!(option4 instanceof Some)) break block5;
                                            seq = (Seq)((Some)option4).x();
                                            break block6;
                                        }
                                        None$ none$ = None$.MODULE$;
                                        Option option6 = option4;
                                        if (none$ != null ? !none$.equals(option6) : option6 != null) break block7;
                                        seq = (Seq)Seq$.MODULE$.empty();
                                        break block6;
                                    }
                                    throw new MatchError((Object)option4);
                                }
                                None$ none$ = None$.MODULE$;
                                Option option7 = option3;
                                if (none$ != null ? !none$.equals(option7) : option7 != null) break block8;
                                seq = (Seq)Seq$.MODULE$.empty();
                                break block6;
                            }
                            throw new MatchError((Object)option3);
                        }
                        None$ none$ = None$.MODULE$;
                        Option<Object> option8 = option2;
                        if (none$ != null ? !none$.equals(option8) : option8 != null) break block9;
                        seq = (Seq)Seq$.MODULE$.empty();
                        break block6;
                    }
                    throw new MatchError(option2);
                }
                None$ none$ = None$.MODULE$;
                Option option9 = option;
                if (none$ != null ? !none$.equals(option9) : option9 != null) break block10;
                seq = (Seq)Seq$.MODULE$.empty();
            }
            return seq;
        }
        throw new MatchError((Object)option);
    }

    public boolean isPartitionOnBroker(ZkClient zkClient, String string, int n, int n2) {
        Seq<Integer> seq = this.getReplicasForPartition(zkClient, string, n);
        this.debug((Function0<String>)new anonfun.isPartitionOnBroker.1(string, n, seq));
        return seq.contains((Object)((Object)BoxesRunTime.boxToInteger((int)n2)).toString());
    }

    public void registerBrokerInZk(ZkClient zkClient, int n, String string, int n2, int n3) {
        String string2 = new StringBuilder().append((Object)this.BrokerIdsPath()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)n)).toString();
        String string3 = Utils$.MODULE$.mergeJsonFields((Seq<String>)((Seq)Utils$.MODULE$.mapToJsonFields((Map<String, String>)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)"host").$minus$greater((Object)string)})), true).$plus$plus(Utils$.MODULE$.mapToJsonFields((Map<String, String>)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)"version").$minus$greater((Object)((Object)BoxesRunTime.boxToInteger((int)1)).toString()), Predef$.MODULE$.any2ArrowAssoc((Object)"jmx_port").$minus$greater((Object)((Object)BoxesRunTime.boxToInteger((int)n3)).toString()), Predef$.MODULE$.any2ArrowAssoc((Object)"port").$minus$greater((Object)((Object)BoxesRunTime.boxToInteger((int)n2)).toString())})), false), Seq$.MODULE$.canBuildFrom())));
        try {
            this.createEphemeralPathExpectConflict(zkClient, string2, string3);
            this.info((Function0<String>)new anonfun.registerBrokerInZk.1(n, string, n2, string2));
            return;
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            throw new RuntimeException(new StringBuilder().append((Object)"A broker is already registered on the path ").append((Object)string2).append((Object)". This probably ").append((Object)"indicates that you either have configured a brokerid that is already in use, or ").append((Object)"else you have shutdown this broker and restarted it faster than the zookeeper ").append((Object)"timeout so it appears to be re-registering.").toString());
        }
    }

    public String getConsumerPartitionOwnerPath(String string, String string2, int n) {
        ZKGroupTopicDirs zKGroupTopicDirs = new ZKGroupTopicDirs(string, string2);
        return new StringBuilder().append((Object)zKGroupTopicDirs.consumerOwnerDir()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)n)).toString();
    }

    public String leaderAndIsrZkData(LeaderAndIsr leaderAndIsr, int n) {
        String string = Utils$.MODULE$.seqToJson((Seq<String>)((Seq)leaderAndIsr.isr().map((Function1)new anonfun.1(), List$.MODULE$.canBuildFrom())), false);
        return Utils$.MODULE$.mapToJson((Map<String, String>)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)"version").$minus$greater((Object)((Object)BoxesRunTime.boxToInteger((int)1)).toString()), Predef$.MODULE$.any2ArrowAssoc((Object)"leader").$minus$greater((Object)((Object)BoxesRunTime.boxToInteger((int)leaderAndIsr.leader())).toString()), Predef$.MODULE$.any2ArrowAssoc((Object)"leader_epoch").$minus$greater((Object)((Object)BoxesRunTime.boxToInteger((int)leaderAndIsr.leaderEpoch())).toString()), Predef$.MODULE$.any2ArrowAssoc((Object)"controller_epoch").$minus$greater((Object)((Object)BoxesRunTime.boxToInteger((int)n)).toString()), Predef$.MODULE$.any2ArrowAssoc((Object)"isr").$minus$greater((Object)string)})), false);
    }

    public String replicaAssignmentZkdata(Map<String, Seq<Integer>> map) {
        String string = Utils$.MODULE$.mapWithSeqValuesToJson(map);
        return Utils$.MODULE$.mapToJson((Map<String, String>)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)"version").$minus$greater((Object)((Object)BoxesRunTime.boxToInteger((int)1)).toString()), Predef$.MODULE$.any2ArrowAssoc((Object)"partitions").$minus$greater((Object)string)})), false);
    }

    public void makeSurePersistentPathExists(ZkClient zkClient, String string) {
        if (!zkClient.exists(string)) {
            zkClient.createPersistent(string, true);
        }
    }

    private void createParentPath(ZkClient zkClient, String string) {
        String string2 = string.substring(0, string.lastIndexOf(47));
        if (string2.length() != 0) {
            zkClient.createPersistent(string2, true);
        }
    }

    private void createEphemeralPath(ZkClient zkClient, String string, String string2) {
        try {
            zkClient.createEphemeral(string, (Object)string2);
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(zkClient, string);
            zkClient.createEphemeral(string, (Object)string2);
        }
    }

    public void createEphemeralPathExpectConflict(ZkClient zkClient, String string, String string2) {
        ObjectRef objectRef;
        ZkNodeExistsException zkNodeExistsException2;
        block6: {
            try {
                this.createEphemeralPath(zkClient, string, string2);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            catch (ZkNodeExistsException zkNodeExistsException2) {
                objectRef = new ObjectRef(null);
                try {
                    objectRef.elem = (String)this.readData(zkClient, string)._1();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                catch (ZkNoNodeException zkNoNodeException) {
                    // empty catch block
                }
                if ((String)objectRef.elem == null) break block6;
                String string3 = (String)objectRef.elem;
                String string4 = string2;
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block6;
                this.info((Function0<String>)new anonfun.createEphemeralPathExpectConflict.2(string, string2));
            }
            return;
        }
        this.info((Function0<String>)new anonfun.createEphemeralPathExpectConflict.1(string, string2, objectRef));
        throw zkNodeExistsException2;
    }

    public void createPersistentPath(ZkClient zkClient, String string, String string2) {
        try {
            zkClient.createPersistent(string, (Object)string2);
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(zkClient, string);
            zkClient.createPersistent(string, (Object)string2);
        }
    }

    public String createSequentialPersistentPath(ZkClient zkClient, String string, String string2) {
        return zkClient.createPersistentSequential(string, (Object)string2);
    }

    public void updatePersistentPath(ZkClient zkClient, String string, String string2) {
        try {
            zkClient.writeData(string, (Object)string2);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(zkClient, string);
            try {
                zkClient.createPersistent(string, (Object)string2);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            catch (ZkNodeExistsException zkNodeExistsException) {
                zkClient.writeData(string, (Object)string2);
            }
        }
    }

    public Tuple2<Boolean, Integer> conditionalUpdatePersistentPath(ZkClient zkClient, String string, String string2, int n) {
        Tuple2 tuple2 = null;
        try {
            Stat stat = zkClient.writeDataReturnStat(string, (Object)string2, n);
            this.debug((Function0<String>)new anonfun.conditionalUpdatePersistentPath.1(string, string2, n, stat));
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)stat.getVersion()));
        }
        catch (Exception exception) {
            this.error((Function0<String>)new anonfun.conditionalUpdatePersistentPath.2(string, string2, n, exception));
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        }
        return tuple2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<Boolean, Integer> conditionalUpdatePersistentPathIfExists(ZkClient zkClient, String string, String string2, int n) {
        Tuple2 tuple2 = null;
        try {
            Stat stat = zkClient.writeDataReturnStat(string, (Object)string2, n);
            this.debug((Function0<String>)new anonfun.conditionalUpdatePersistentPathIfExists.1(string, string2, n, stat));
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)stat.getVersion()));
        }
        catch (Exception exception) {
            this.error((Function0<String>)new anonfun.conditionalUpdatePersistentPathIfExists.2(string, string2, n, exception));
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        }
        catch (ZkNoNodeException zkNoNodeException) {
            throw zkNoNodeException;
        }
    }

    public void updateEphemeralPath(ZkClient zkClient, String string, String string2) {
        try {
            zkClient.writeData(string, (Object)string2);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(zkClient, string);
            zkClient.createEphemeral(string, (Object)string2);
        }
    }

    public boolean deletePath(ZkClient zkClient, String string) {
        boolean bl = false;
        try {
            bl = zkClient.delete(string);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.info((Function0<String>)new anonfun.deletePath.1(string));
            bl = false;
        }
        return bl;
    }

    public void deletePathRecursive(ZkClient zkClient, String string) {
        try {
            zkClient.deleteRecursive(string);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.info((Function0<String>)new anonfun.deletePathRecursive.1(string));
        }
    }

    public void maybeDeletePath(String string, String string2) {
        try {
            ZkClient zkClient = new ZkClient(string, 30000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
            zkClient.deleteRecursive(string2);
            zkClient.close();
        }
        catch (Throwable throwable) {}
    }

    public Tuple2<String, Stat> readData(ZkClient zkClient, String string) {
        Stat stat = new Stat();
        String string2 = (String)zkClient.readData(string, stat);
        return new Tuple2((Object)string2, (Object)stat);
    }

    public Tuple2<Option<String>, Stat> readDataMaybeNull(ZkClient zkClient, String string) {
        Stat stat = new Stat();
        Tuple2 tuple2 = null;
        try {
            tuple2 = new Tuple2((Object)new Some(zkClient.readData(string, stat)), (Object)stat);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)stat);
        }
        Tuple2 tuple22 = tuple2;
        return tuple22;
    }

    public Seq<String> getChildren(ZkClient zkClient, String string) {
        return JavaConversions$.MODULE$.asBuffer(zkClient.getChildren(string));
    }

    public Seq<String> getChildrenParentMayNotExist(ZkClient zkClient, String string) {
        Buffer buffer = null;
        try {
            buffer = JavaConversions$.MODULE$.asBuffer(zkClient.getChildren(string));
            return buffer;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            return Nil$.MODULE$;
        }
    }

    public boolean pathExists(ZkClient zkClient, String string) {
        return zkClient.exists(string);
    }

    public String getLastPart(String string) {
        return string.substring(string.lastIndexOf(47) + 1);
    }

    public Cluster getCluster(ZkClient zkClient) {
        Cluster cluster = new Cluster();
        Seq<String> seq = this.getChildrenParentMayNotExist(zkClient, this.BrokerIdsPath());
        seq.foreach((Function1)new anonfun.getCluster.1(zkClient, cluster));
        return cluster;
    }

    public scala.collection.mutable.Map<TopicAndPartition, LeaderIsrAndControllerEpoch> getPartitionLeaderAndIsrForTopics(ZkClient zkClient, Set<TopicAndPartition> set) {
        HashMap hashMap = new HashMap();
        set.foreach((Function1)new anonfun.getPartitionLeaderAndIsrForTopics.1(zkClient, hashMap));
        return hashMap;
    }

    public scala.collection.mutable.Map<TopicAndPartition, Seq<Integer>> getReplicaAssignmentForTopics(ZkClient zkClient, Seq<String> seq) {
        HashMap hashMap = new HashMap();
        seq.foreach((Function1)new anonfun.getReplicaAssignmentForTopics.1(zkClient, hashMap));
        return hashMap;
    }

    public scala.collection.mutable.Map<String, Map<Integer, Seq<Integer>>> getPartitionAssignmentForTopics(ZkClient zkClient, Seq<String> seq) {
        HashMap hashMap = new HashMap();
        seq.foreach((Function1)new anonfun.getPartitionAssignmentForTopics.1(zkClient, hashMap));
        return hashMap;
    }

    public scala.collection.mutable.Map<Tuple2<String, Integer>, Seq<Integer>> getReplicaAssignmentFromPartitionAssignment(scala.collection.mutable.Map<String, Map<Integer, Seq<Integer>>> map) {
        HashMap hashMap = new HashMap();
        map.foreach((Function1)new anonfun.getReplicaAssignmentFromPartitionAssignment.1(hashMap));
        return hashMap;
    }

    public scala.collection.mutable.Map<String, Seq<Integer>> getPartitionsForTopics(ZkClient zkClient, Seq<String> seq) {
        return (scala.collection.mutable.Map)this.getPartitionAssignmentForTopics(zkClient, seq).map((Function1)new anonfun.getPartitionsForTopics.1(), Map$.MODULE$.canBuildFrom());
    }

    public Seq<Tuple2<String, Integer>> getPartitionsAssignedToBroker(ZkClient zkClient, Seq<String> seq, int n) {
        scala.collection.mutable.Map<String, Map<Integer, Seq<Integer>>> map = this.getPartitionAssignmentForTopics(zkClient, seq);
        return ((IterableLike)((GenericTraversableTemplate)map.map((Function1)new anonfun.getPartitionsAssignedToBroker.1(n), Iterable$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.conforms())).toSeq();
    }

    public Map<TopicAndPartition, ReassignedPartitionsContext> getPartitionsBeingReassigned(ZkClient zkClient) {
        Option option;
        block4: {
            scala.collection.immutable.Map map;
            block3: {
                block2: {
                    String string;
                    Option option2 = (Option)this.readDataMaybeNull(zkClient, this.ReassignPartitionsPath())._1();
                    option = option2;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String string2 = string = (String)some.x();
                    Map<TopicAndPartition, Seq<Integer>> map2 = this.parsePartitionReassignmentData(string2);
                    map = (Map)map2.map((Function1)new anonfun.getPartitionsBeingReassigned.1(), scala.collection.Map$.MODULE$.canBuildFrom());
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option3 = option;
                if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                map = scala.collection.Map$.MODULE$.empty();
            }
            return map;
        }
        throw new MatchError((Object)option);
    }

    public Map<TopicAndPartition, Seq<Integer>> parsePartitionReassignmentData(String string) {
        Option<Object> option;
        block9: {
            scala.collection.mutable.Map map;
            block8: {
                block7: {
                    map = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                    option = Json$.MODULE$.parseFull(string);
                    if (!(option instanceof Some)) break block7;
                    Some some = (Some)option;
                    Object object = some.x();
                    Object object2 = object;
                    Option option2 = ((Map)object2).get((Object)"partitions");
                    if (option2 instanceof Some) {
                        ((Seq)((Some)option2).x()).foreach((Function1)new anonfun.parsePartitionReassignmentData.1(map));
                    } else {
                        None$ none$ = None$.MODULE$;
                        Option option3 = option2;
                        if (none$ == null ? option3 != null : !none$.equals(option3)) {
                            throw new MatchError((Object)option2);
                        }
                    }
                    break block8;
                }
                None$ none$ = None$.MODULE$;
                Option<Object> option4 = option;
                if (none$ != null ? !none$.equals(option4) : option4 != null) break block9;
            }
            return map;
        }
        throw new MatchError(option);
    }

    public String getPartitionReassignmentZkData(Map<TopicAndPartition, Seq<Integer>> map) {
        ObjectRef objectRef = new ObjectRef((Object)((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))));
        map.foreach((Function1)new anonfun.getPartitionReassignmentZkData.1(objectRef));
        return Utils$.MODULE$.mapToJson((Map<String, String>)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)"version").$minus$greater((Object)((Object)BoxesRunTime.boxToInteger((int)1)).toString()), Predef$.MODULE$.any2ArrowAssoc((Object)"partitions").$minus$greater((Object)Utils$.MODULE$.seqToJson((Seq<String>)((ListBuffer)objectRef.elem).toSeq(), false))})), false);
    }

    public void updatePartitionReassignmentData(ZkClient zkClient, Map<TopicAndPartition, Seq<Integer>> map) {
        String string = this.ReassignPartitionsPath();
        int n = map.size();
        if (n == 0) {
            this.deletePath(zkClient, string);
            this.info((Function0<String>)new anonfun.updatePartitionReassignmentData.1(string));
        } else {
            String string2 = this.getPartitionReassignmentZkData(map);
            try {
                this.updatePersistentPath(zkClient, string, string2);
                this.info((Function0<String>)new anonfun.updatePartitionReassignmentData.2(string2));
            }
            catch (Throwable throwable) {
                throw new AdministrationException(throwable.toString());
            }
            catch (ZkNoNodeException zkNoNodeException) {
                this.createPersistentPath(zkClient, string, string2);
                this.debug((Function0<String>)new anonfun.updatePartitionReassignmentData.3(string, string2));
            }
        }
    }

    public Set<PartitionAndReplica> getAllReplicasOnBroker(ZkClient zkClient, Seq<String> seq, Seq<Integer> seq2) {
        return (Set)Set$.MODULE$.empty().$plus$plus((TraversableOnce)((GenericTraversableTemplate)seq2.map((Function1)new anonfun.getAllReplicasOnBroker.1(zkClient, seq, seq2), Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.conforms()));
    }

    public Set<TopicAndPartition> getPartitionsUndergoingPreferredReplicaElection(ZkClient zkClient) {
        Option option;
        block4: {
            Set set;
            block3: {
                block2: {
                    Option option2 = (Option)this.readDataMaybeNull(zkClient, this.PreferredReplicaLeaderElectionPath())._1();
                    option = option2;
                    if (!(option instanceof Some)) break block2;
                    set = PreferredReplicaLeaderElectionCommand$.MODULE$.parsePreferredReplicaElectionData((String)((Some)option).x());
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option3 = option;
                if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                set = Set$.MODULE$.empty();
            }
            return set;
        }
        throw new MatchError((Object)option);
    }

    public void deletePartition(ZkClient zkClient, int n, String string) {
        String string2 = new StringBuilder().append((Object)this.BrokerIdsPath()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)n)).toString();
        zkClient.delete(string2);
        String string3 = new StringBuilder().append((Object)this.BrokerTopicsPath()).append((Object)"/").append((Object)string).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)n)).toString();
        zkClient.delete(string3);
    }

    public Seq<String> getConsumersInGroup(ZkClient zkClient, String string) {
        ZKGroupDirs zKGroupDirs = new ZKGroupDirs(string);
        return this.getChildren(zkClient, zKGroupDirs.consumerRegistryDir());
    }

    public scala.collection.mutable.Map<String, List<String>> getConsumersPerTopic(ZkClient zkClient, String string) {
        ZKGroupDirs zKGroupDirs = new ZKGroupDirs(string);
        Seq<String> seq = this.getChildrenParentMayNotExist(zkClient, zKGroupDirs.consumerRegistryDir());
        HashMap hashMap = new HashMap();
        seq.foreach((Function1)new anonfun.getConsumersPerTopic.1(zkClient, string, hashMap));
        hashMap.foreach((Function1)new anonfun.getConsumersPerTopic.2(hashMap));
        return hashMap;
    }

    public Option<Broker> getBrokerInfo(ZkClient zkClient, int n) {
        Option option;
        block4: {
            Some some;
            block3: {
                block2: {
                    option = (Option)this.readDataMaybeNull(zkClient, new StringBuilder().append((Object)this.BrokerIdsPath()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)n)).toString())._1();
                    if (!(option instanceof Some)) break block2;
                    some = new Some((Object)Broker$.MODULE$.createBroker(n, (String)((Some)option).x()));
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                some = None$.MODULE$;
            }
            return some;
        }
        throw new MatchError((Object)option);
    }

    public Seq<String> getAllTopics(ZkClient zkClient) {
        Seq seq = this.getChildrenParentMayNotExist(zkClient, this.BrokerTopicsPath());
        return seq == null ? (Seq)Seq$.MODULE$.empty() : seq;
    }

    public Set<TopicAndPartition> getAllPartitions(ZkClient zkClient) {
        Seq<String> seq = this.getChildrenParentMayNotExist(zkClient, this.BrokerTopicsPath());
        return seq == null ? Set$.MODULE$.empty() : ((GenericTraversableTemplate)seq.map((Function1)new anonfun.getAllPartitions.1(zkClient), Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.conforms()).toSet();
    }

    private ZkUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.ConsumersPath = "/consumers";
        this.BrokerIdsPath = "/brokers/ids";
        this.BrokerTopicsPath = "/brokers/topics";
        this.ControllerPath = "/controller";
        this.ControllerEpochPath = "/controller_epoch";
        this.ReassignPartitionsPath = "/admin/reassign_partitions";
        this.PreferredReplicaLeaderElectionPath = "/admin/preferred_replica_election";
    }
}

