/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kafka.consumer.ConsumerTopicStats;
import kafka.consumer.ConsumerTopicStatsRegistry$;
import kafka.consumer.FetchedDataChunk;
import kafka.consumer.PartitionTopicInfo$;
import kafka.message.ByteBufferMessageSet;
import kafka.message.MessageAndOffset;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\u0001\u0003\u0001\u001d\u0011!\u0003U1si&$\u0018n\u001c8U_BL7-\u00138g_*\u00111\u0001B\u0001\tG>t7/^7fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001A\u0001C\u0006\t\u0003\u00139i\u0011A\u0003\u0006\u0003\u00171\tA\u0001\\1oO*\tQ\"\u0001\u0003kCZ\f\u0017BA\b\u000b\u0005\u0019y%M[3diB\u0011\u0011\u0003F\u0007\u0002%)\u00111\u0003B\u0001\u0006kRLGn]\u0005\u0003+I\u0011q\u0001T8hO&tw\r\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002DA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002C\u000f\u0001\u0005\u000b\u0007I\u0011\u0001\u0010\u0002\u000bQ|\u0007/[2\u0016\u0003}\u0001\"\u0001I\u0012\u000f\u0005]\t\u0013B\u0001\u0012\u0019\u0003\u0019\u0001&/\u001a3fM&\u0011A%\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\tB\u0002\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\rQ|\u0007/[2!\u0011!I\u0003A!b\u0001\n\u0003Q\u0013a\u00039beRLG/[8o\u0013\u0012,\u0012a\u000b\t\u0003/1J!!\f\r\u0003\u0007%sG\u000f\u0003\u00050\u0001\t\u0005\t\u0015!\u0003,\u00031\u0001\u0018M\u001d;ji&|g.\u00133!\u0011!\t\u0004A!b\u0001\n\u0013\u0011\u0014AC2ik:\\\u0017+^3vKV\t1\u0007E\u00025smj\u0011!\u000e\u0006\u0003m]\n!bY8oGV\u0014(/\u001a8u\u0015\tAD\"\u0001\u0003vi&d\u0017B\u0001\u001e6\u00055\u0011En\\2lS:<\u0017+^3vKB\u0011A(P\u0007\u0002\u0005%\u0011aH\u0001\u0002\u0011\r\u0016$8\r[3e\t\u0006$\u0018m\u00115v].D\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006IaM\u0001\fG\",hn[)vKV,\u0007\u0005\u0003\u0005C\u0001\t\u0015\r\u0011\"\u0003D\u00039\u0019wN\\:v[\u0016$wJ\u001a4tKR,\u0012\u0001\u0012\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000fV\na!\u0019;p[&\u001c\u0017BA%G\u0005)\tEo\\7jG2{gn\u001a\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\t\u0006y1m\u001c8tk6,Gm\u00144gg\u0016$\b\u0005\u0003\u0005N\u0001\t\u0015\r\u0011\"\u0003D\u000351W\r^2iK\u0012|eMZ:fi\"Aq\n\u0001B\u0001B\u0003%A)\u0001\bgKR\u001c\u0007.\u001a3PM\u001a\u001cX\r\u001e\u0011\t\u0011E\u0003!Q1A\u0005\nI\u000b\u0011BZ3uG\"\u001c\u0016N_3\u0016\u0003M\u0003\"!\u0012+\n\u0005U3%!D!u_6L7-\u00138uK\u001e,'\u000f\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003T\u0003)1W\r^2i'&TX\r\t\u0005\t3\u0002\u0011)\u0019!C\u0005=\u0005A1\r\\5f]RLE\r\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003 \u0003%\u0019G.[3oi&#\u0007\u0005C\u0003^\u0001\u0011\u0005a,\u0001\u0004=S:LGO\u0010\u000b\t?\u0002\f'm\u00193fMB\u0011A\b\u0001\u0005\u0006;q\u0003\ra\b\u0005\u0006Sq\u0003\ra\u000b\u0005\u0006cq\u0003\ra\r\u0005\u0006\u0005r\u0003\r\u0001\u0012\u0005\u0006\u001br\u0003\r\u0001\u0012\u0005\u0006#r\u0003\ra\u0015\u0005\u00063r\u0003\ra\b\u0005\bQ\u0002\u0011\r\u0011\"\u0003j\u0003I\u0019wN\\:v[\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0016\u0003)\u0004\"\u0001P6\n\u00051\u0014!AE\"p]N,X.\u001a:U_BL7m\u0015;biNDaA\u001c\u0001!\u0002\u0013Q\u0017aE2p]N,X.\u001a:U_BL7m\u0015;biN\u0004\u0003\"\u00029\u0001\t\u0003\t\u0018\u0001E4fi\u000e{gn];nK>3gm]3u)\u0005\u0011\bCA\ft\u0013\t!\bD\u0001\u0003M_:<\u0007\"\u0002<\u0001\t\u0003\t\u0018AD4fi\u001a+Go\u00195PM\u001a\u001cX\r\u001e\u0005\u0006q\u0002!\t!_\u0001\u0013e\u0016\u001cX\r^\"p]N,X.Z(gMN,G\u000f\u0006\u0002{{B\u0011qc_\u0005\u0003yb\u0011A!\u00168ji\")ap\u001ea\u0001e\u0006\u0001b.Z<D_:\u001cX/\\3PM\u001a\u001cX\r\u001e\u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u0003A\u0011Xm]3u\r\u0016$8\r[(gMN,G\u000fF\u0002{\u0003\u000bAa!a\u0002\u0000\u0001\u0004\u0011\u0018A\u00048fo\u001a+Go\u00195PM\u001a\u001cX\r\u001e\u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0003\u001d)g.];fk\u0016$2A_A\b\u0011!\t\t\"!\u0003A\u0002\u0005M\u0011\u0001C7fgN\fw-Z:\u0011\t\u0005U\u00111D\u0007\u0003\u0003/Q1!!\u0007\u0005\u0003\u001diWm]:bO\u0016LA!!\b\u0002\u0018\t!\")\u001f;f\u0005V4g-\u001a:NKN\u001c\u0018mZ3TKRDq!!\t\u0001\t\u0003\n\u0019#\u0001\u0005u_N#(/\u001b8h)\u0005yraBA\u0014\u0005!\u0015\u0011\u0011F\u0001\u0013!\u0006\u0014H/\u001b;j_:$v\u000e]5d\u0013:4w\u000eE\u0002=\u0003W1a!\u0001\u0002\t\u0006\u000552\u0003BA\u0016\u0011YAq!XA\u0016\t\u0003\t\t\u0004\u0006\u0002\u0002*!Q\u0011QGA\u0016\u0005\u0004%\t!a\u000e\u0002\u001b%sg/\u00197jI>3gm]3u+\u0005\u0011\b\u0002CA\u001e\u0003W\u0001\u000b\u0011\u0002:\u0002\u001d%sg/\u00197jI>3gm]3uA!A\u0011qHA\u0016\t\u0003\t\t%A\bjg>3gm]3u\u0013:4\u0018\r\\5e)\u0011\t\u0019%!\u0013\u0011\u0007]\t)%C\u0002\u0002Ha\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002L\u0005u\u0002\u0019\u0001:\u0002\r=4gm]3u\u0001")
public class PartitionTopicInfo
implements Logging,
ScalaObject {
    private final String topic;
    private final int partitionId;
    private final BlockingQueue<FetchedDataChunk> chunkQueue;
    private final AtomicLong kafka$consumer$PartitionTopicInfo$$consumedOffset;
    private final AtomicLong kafka$consumer$PartitionTopicInfo$$fetchedOffset;
    private final AtomicInteger fetchSize;
    private final String clientId;
    private final ConsumerTopicStats consumerTopicStats;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final boolean isOffsetInvalid(long l) {
        return PartitionTopicInfo$.MODULE$.isOffsetInvalid(l);
    }

    public static final long InvalidOffset() {
        return PartitionTopicInfo$.MODULE$.InvalidOffset();
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    private BlockingQueue<FetchedDataChunk> chunkQueue() {
        return this.chunkQueue;
    }

    public final AtomicLong kafka$consumer$PartitionTopicInfo$$consumedOffset() {
        return this.kafka$consumer$PartitionTopicInfo$$consumedOffset;
    }

    public final AtomicLong kafka$consumer$PartitionTopicInfo$$fetchedOffset() {
        return this.kafka$consumer$PartitionTopicInfo$$fetchedOffset;
    }

    private AtomicInteger fetchSize() {
        return this.fetchSize;
    }

    private String clientId() {
        return this.clientId;
    }

    private ConsumerTopicStats consumerTopicStats() {
        return this.consumerTopicStats;
    }

    public long getConsumeOffset() {
        return this.kafka$consumer$PartitionTopicInfo$$consumedOffset().get();
    }

    public long getFetchOffset() {
        return this.kafka$consumer$PartitionTopicInfo$$fetchedOffset().get();
    }

    public void resetConsumeOffset(long newConsumeOffset$1) {
        this.kafka$consumer$PartitionTopicInfo$$consumedOffset().set(newConsumeOffset$1);
        this.debug((Function0<String>)new Serializable(this, newConsumeOffset$1){
            public static final long serialVersionUID;
            private final PartitionTopicInfo $outer;
            private final long newConsumeOffset$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"reset consume offset of ").append((Object)this.$outer).append((Object)" to ").append((Object)BoxesRunTime.boxToLong((long)this.newConsumeOffset$1)).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.newConsumeOffset$1 = l;
            }
        });
    }

    public void resetFetchOffset(long newFetchOffset$1) {
        this.kafka$consumer$PartitionTopicInfo$$fetchedOffset().set(newFetchOffset$1);
        this.debug((Function0<String>)new Serializable(this, newFetchOffset$1){
            public static final long serialVersionUID;
            private final PartitionTopicInfo $outer;
            private final long newFetchOffset$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("reset fetch offset of ( %s ) to %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer, BoxesRunTime.boxToLong((long)this.newFetchOffset$1)}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.newFetchOffset$1 = l;
            }
        });
    }

    public void enqueue(ByteBufferMessageSet messages) {
        int size2 = messages.validBytes();
        if (size2 > 0) {
            long next$1 = ((MessageAndOffset)messages.shallowIterator().toSeq().last()).nextOffset();
            this.trace((Function0<String>)new Serializable(this, next$1){
                public static final long serialVersionUID;
                private final PartitionTopicInfo $outer;
                private final long next$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Updating fetch offset = ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.kafka$consumer$PartitionTopicInfo$$fetchedOffset().get())).append((Object)" to ").append((Object)BoxesRunTime.boxToLong((long)this.next$1)).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.next$1 = l;
                }
            });
            this.chunkQueue().put(new FetchedDataChunk(messages, this, this.kafka$consumer$PartitionTopicInfo$$fetchedOffset().get()));
            this.kafka$consumer$PartitionTopicInfo$$fetchedOffset().set(next$1);
            this.debug((Function0<String>)new Serializable(this, next$1){
                public static final long serialVersionUID;
                private final PartitionTopicInfo $outer;
                private final long next$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("updated fetch offset of (%s) to %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer, BoxesRunTime.boxToLong((long)this.next$1)}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.next$1 = l;
                }
            });
            this.consumerTopicStats().getConsumerTopicStats(this.topic()).byteRate().mark((long)size2);
            this.consumerTopicStats().getConsumerAllTopicStats().byteRate().mark((long)size2);
        } else if (messages.sizeInBytes() > 0) {
            this.chunkQueue().put(new FetchedDataChunk(messages, this, this.kafka$consumer$PartitionTopicInfo$$fetchedOffset().get()));
        }
    }

    public String toString() {
        return new StringBuilder().append((Object)this.topic()).append((Object)":").append((Object)((Object)BoxesRunTime.boxToInteger((int)this.partitionId())).toString()).append((Object)": fetched offset = ").append((Object)BoxesRunTime.boxToLong((long)this.kafka$consumer$PartitionTopicInfo$$fetchedOffset().get())).append((Object)": consumed offset = ").append((Object)BoxesRunTime.boxToLong((long)this.kafka$consumer$PartitionTopicInfo$$consumedOffset().get())).toString();
    }

    public PartitionTopicInfo(String topic, int partitionId, BlockingQueue<FetchedDataChunk> chunkQueue, AtomicLong consumedOffset, AtomicLong fetchedOffset, AtomicInteger fetchSize, String clientId) {
        this.topic = topic;
        this.partitionId = partitionId;
        this.chunkQueue = chunkQueue;
        this.kafka$consumer$PartitionTopicInfo$$consumedOffset = consumedOffset;
        this.kafka$consumer$PartitionTopicInfo$$fetchedOffset = fetchedOffset;
        this.fetchSize = fetchSize;
        this.clientId = clientId;
        Logging$class.$init$(this);
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;
            private final PartitionTopicInfo $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"initial consumer offset of ").append((Object)this.$outer).append((Object)" is ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.kafka$consumer$PartitionTopicInfo$$consumedOffset().get())).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;
            private final PartitionTopicInfo $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"initial fetch offset of ").append((Object)this.$outer).append((Object)" is ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.kafka$consumer$PartitionTopicInfo$$fetchedOffset().get())).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.consumerTopicStats = ConsumerTopicStatsRegistry$.MODULE$.getConsumerTopicStat(clientId);
    }
}

