/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsr;
import kafka.api.RequestOrResponse;
import kafka.common.LeaderElectionNotNeededException;
import kafka.common.NoReplicaOnlineException;
import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NoOpLeaderSelector;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderSelector;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine$AddPartitionsListener$;
import kafka.controller.PartitionStateMachine$DeleteTopicsListener$;
import kafka.controller.PartitionStateMachine$TopicChangeListener$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ReplicationUtils$;
import kafka.utils.Utils$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\tUg\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003U1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tWM\u0003\u0002\u0004\t\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\u0011A1\u0002CA\u0005\u000f\u001b\u0005Q!BA\u0006\r\u0003\u0011a\u0017M\\4\u000b\u00035\tAA[1wC&\u0011qB\u0003\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005E!R\"\u0001\n\u000b\u0005M!\u0011!B;uS2\u001c\u0018BA\u000b\u0013\u0005\u001daunZ4j]\u001e\u0004\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u00111bU2bY\u0006|%M[3di\"A1\u0001\u0001B\u0001B\u0003%Q\u0004\u0005\u0002\u001f?5\t!!\u0003\u0002!\u0005\ty1*\u00194lC\u000e{g\u000e\u001e:pY2,'\u000fC\u0003#\u0001\u0011\u00051%\u0001\u0004=S:LGO\u0010\u000b\u0003I\u0015\u0002\"A\b\u0001\t\u000b\r\t\u0003\u0019A\u000f\t\u000f\u001d\u0002!\u0019!C\u0005Q\u0005\t2m\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0016\u0003%\u0002\"A\b\u0016\n\u0005-\u0012!!E\"p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yi\"1Q\u0006\u0001Q\u0001\n%\n!cY8oiJ|G\u000e\\3s\u0007>tG/\u001a=uA!9q\u0006\u0001b\u0001\n\u0013\u0001\u0014\u0001D2p]R\u0014x\u000e\u001c7fe&#W#A\u0019\u0011\u0005]\u0011\u0014BA\u001a\u0019\u0005\rIe\u000e\u001e\u0005\u0007k\u0001\u0001\u000b\u0011B\u0019\u0002\u001b\r|g\u000e\u001e:pY2,'/\u00133!\u0011\u001d9\u0004A1A\u0005\na\n\u0001B_6DY&,g\u000e^\u000b\u0002sA\u0011!(Q\u0007\u0002w)\u0011A(P\u0001\tu.\u001cG.[3oi*\u0011ahP\u0001\u0007\u0013BJE/Z2\u000b\u0003\u0001\u000b1a\u001c:h\u0013\t\u00115H\u0001\u0005[W\u000ec\u0017.\u001a8u\u0011\u0019!\u0005\u0001)A\u0005s\u0005I!p[\"mS\u0016tG\u000f\t\u0005\b\r\u0002\u0011\r\u0011\"\u0003H\u00039\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016,\u0012\u0001\u0013\t\u0005\u0013:\u0003f+D\u0001K\u0015\tYE*A\u0004nkR\f'\r\\3\u000b\u00055C\u0012AC2pY2,7\r^5p]&\u0011qJ\u0013\u0002\u0004\u001b\u0006\u0004\bCA)U\u001b\u0005\u0011&BA*\u0005\u0003\u0019\u0019w.\\7p]&\u0011QK\u0015\u0002\u0012)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007C\u0001\u0010X\u0013\tA&A\u0001\bQCJ$\u0018\u000e^5p]N#\u0018\r^3\t\ri\u0003\u0001\u0015!\u0003I\u0003=\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016\u0004\u0003b\u0002/\u0001\u0005\u0004%I!X\u0001\u0013EJ|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007.F\u0001_!\tqr,\u0003\u0002a\u0005\ta2i\u001c8ue>dG.\u001a:Ce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007B\u00022\u0001A\u0003%a,A\nce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007\u0005C\u0004e\u0001\t\u0007I\u0011B3\u0002\u0015!\f7o\u0015;beR,G-F\u0001g!\t9g.D\u0001i\u0015\tI'.\u0001\u0004bi>l\u0017n\u0019\u0006\u0003W2\f!bY8oGV\u0014(/\u001a8u\u0015\tiG\"\u0001\u0003vi&d\u0017BA8i\u00055\tEo\\7jG\n{w\u000e\\3b]\"1\u0011\u000f\u0001Q\u0001\n\u0019\f1\u0002[1t'R\f'\u000f^3eA!91\u000f\u0001b\u0001\n\u0013!\u0018a\u00078p\u001fB\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u00148+\u001a7fGR|'/F\u0001v!\tqb/\u0003\u0002x\u0005\t\u0011bj\\(q\u0019\u0016\fG-\u001a:TK2,7\r^8s\u0011\u0019I\b\u0001)A\u0005k\u0006abn\\(q!\u0006\u0014H/\u001b;j_:dU-\u00193feN+G.Z2u_J\u0004\u0003bB>\u0001\u0005\u0004%I\u0001`\u0001\u0014i>\u0004\u0018nY\"iC:<W\rT5ti\u0016tWM]\u000b\u0002{B\u0011ap`\u0007\u0002\u0001\u00191\u0011\u0011\u0001\u0001\u0001\u0003\u0007\u00111\u0003V8qS\u000e\u001c\u0005.\u00198hK2K7\u000f^3oKJ\u001cba \u0005\u0002\u0006A1\u0002c\u0001\u001e\u0002\b%\u0019\u0011\u0011B\u001e\u0003!%S6n\u00115jY\u0012d\u0015n\u001d;f]\u0016\u0014\bB\u0002\u0012\u0000\t\u0003\ti\u0001F\u0001~\u0011\u001d\t\tb C\u0001\u0003'\t\u0011\u0003[1oI2,7\t[5mI\u000eC\u0017M\\4f)\u0019\t)\"a\u0007\u0002.A\u0019q#a\u0006\n\u0007\u0005e\u0001D\u0001\u0003V]&$\b\u0002CA\u000f\u0003\u001f\u0001\r!a\b\u0002\u0015A\f'/\u001a8u!\u0006$\b\u000e\u0005\u0003\u0002\"\u0005\u001dbbA\f\u0002$%\u0019\u0011Q\u0005\r\u0002\rA\u0013X\rZ3g\u0013\u0011\tI#a\u000b\u0003\rM#(/\u001b8h\u0015\r\t)\u0003\u0007\u0005\t\u0003_\ty\u00011\u0001\u00022\u0005A1\r[5mIJ,g\u000e\u0005\u0004\u00024\u0005U\u0012qD\u0007\u0002Y&\u0019\u0011q\u00077\u0003\t1K7\u000f\u001e\u0015\u0007\u0003\u001f\tY$!\u0011\u0011\u0007]\ti$C\u0002\u0002@a\u0011a\u0001\u001e5s_^\u001c8EAA\"!\u0011\t)%!\u0016\u000f\t\u0005\u001d\u0013\u0011\u000b\b\u0005\u0003\u0013\ny%\u0004\u0002\u0002L)\u0019\u0011Q\n\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0012bAA*1\u00059\u0001/Y2lC\u001e,\u0017\u0002BA,\u00033\u0012\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0007\u0005M\u0003\u0004C\u0004\u0002^\u0001\u0001\u000b\u0011B?\u0002)Q|\u0007/[2DQ\u0006tw-\u001a'jgR,g.\u001a:!\u0011%\t\t\u0007\u0001b\u0001\n\u0013\t\u0019'\u0001\u000beK2,G/\u001a+pa&\u001c7\u000fT5ti\u0016tWM]\u000b\u0003\u0003K\u00022A`A4\r\u0019\tI\u0007\u0001\u0001\u0002l\t!B)\u001a7fi\u0016$v\u000e]5dg2K7\u000f^3oKJ\u001cr!a\u001a\t\u0003\u000b\u0001b\u0003C\u0004#\u0003O\"\t!a\u001c\u0015\u0005\u0005\u0015\u0004\u0002C\u001c\u0002h\t\u0007I\u0011\u0001\u001d\t\u000f\u0011\u000b9\u0007)A\u0005s!A\u0011\u0011CA4\t\u0003\t9\b\u0006\u0004\u0002\u0016\u0005e\u00141\u0010\u0005\t\u0003;\t)\b1\u0001\u0002 !A\u0011qFA;\u0001\u0004\t\t\u0004\u000b\u0004\u0002v\u0005m\u0012\u0011\t\u0005\t\u0003\u0003\u000b9\u0007\"\u0001\u0002\u0004\u0006\t\u0002.\u00198eY\u0016$\u0015\r^1EK2,G/\u001a3\u0015\t\u0005U\u0011Q\u0011\u0005\t\u0003\u000f\u000by\b1\u0001\u0002 \u0005AA-\u0019;b!\u0006$\b\u000e\u000b\u0004\u0002\u0000\u0005m\u0012\u0011\t\u0005\t\u0003\u001b\u0003\u0001\u0015!\u0003\u0002f\u0005)B-\u001a7fi\u0016$v\u000e]5dg2K7\u000f^3oKJ\u0004\u0003\"CAI\u0001\t\u0007I\u0011BAJ\u0003U\tG\r\u001a)beRLG/[8og2K7\u000f^3oKJ,\"!!&\u0011\r%s\u0015qDAL!\rq\u0018\u0011\u0014\u0004\u0007\u00037\u0003\u0001!!(\u0003+\u0005#G\rU1si&$\u0018n\u001c8t\u0019&\u001cH/\u001a8feN9\u0011\u0011\u0014\u0005\u0002 B1\u0002c\u0001\u001e\u0002\"&\u0019\u00111U\u001e\u0003\u001f%S6\u000eR1uC2K7\u000f^3oKJD1\"a*\u0002\u001a\n\u0005\t\u0015!\u0003\u0002 \u0005)Ao\u001c9jG\"9!%!'\u0005\u0002\u0005-F\u0003BAL\u0003[C\u0001\"a*\u0002*\u0002\u0007\u0011q\u0004\u0005\t\u0003c\u000bI\n\"\u0001\u00024\u0006\u0001\u0002.\u00198eY\u0016$\u0015\r^1DQ\u0006tw-\u001a\u000b\u0007\u0003+\t),a.\t\u0011\u0005\u001d\u0015q\u0016a\u0001\u0003?Aq!!/\u00020\u0002\u0007\u0001\"\u0001\u0003eCR\f\u0007FBAX\u0003w\t\t\u0005\u0003\u0005\u0002\u0002\u0006eE\u0011AA`)\u0011\t)\"!1\t\u0011\u0005u\u0011Q\u0018a\u0001\u0003?Ac!!0\u0002<\u0005\u0005\u0003\u0002CAd\u0001\u0001\u0006I!!&\u0002-\u0005$G\rU1si&$\u0018n\u001c8t\u0019&\u001cH/\u001a8fe\u0002B\u0011\"a3\u0001\u0005\u0004%I!!4\u0002#M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/\u0006\u0002\u0002PB!\u0011\u0011[Al\u001d\rq\u00121[\u0005\u0004\u0003+\u0014\u0011aD&bM.\f7i\u001c8ue>dG.\u001a:\n\t\u0005e\u00171\u001c\u0002\u0012'R\fG/Z\"iC:<W\rT8hO\u0016\u0014(bAAk\u0005!A\u0011q\u001c\u0001!\u0002\u0013\ty-\u0001\nti\u0006$Xm\u00115b]\u001e,Gj\\4hKJ\u0004\u0003bBAr\u0001\u0011\u0005\u0011Q]\u0001\bgR\f'\u000f^;q)\t\t)\u0002C\u0004\u0002j\u0002!\t!!:\u0002#I,w-[:uKJd\u0015n\u001d;f]\u0016\u00148\u000fC\u0004\u0002n\u0002!\t!!:\u0002'\u0011,'/Z4jgR,'\u000fT5ti\u0016tWM]:\t\u000f\u0005E\b\u0001\"\u0001\u0002f\u0006A1\u000f[;uI><h\u000eC\u0004\u0002v\u0002!\t!!:\u0002CQ\u0014\u0018nZ4fe>sG.\u001b8f!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0007\"\fgnZ3\t\u000f\u0005e\b\u0001\"\u0001\u0002|\u0006\t\u0002/\u0019:uSRLwN\\:J]N#\u0018\r^3\u0015\t\u0005u(Q\u0001\t\u0006\u0003\u007f\u0014\t\u0001U\u0007\u0002\u0019&\u0019!1\u0001'\u0003\u0007M+G\u000fC\u0004\u0003\b\u0005]\b\u0019\u0001,\u0002\u000bM$\u0018\r^3\t\u000f\t-\u0001\u0001\"\u0001\u0003\u000e\u0005\u0011\u0002.\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3t))\t)Ba\u0004\u0003\u0014\t]!\u0011\u0005\u0005\t\u0005#\u0011I\u00011\u0001\u0002~\u0006Q\u0001/\u0019:uSRLwN\\:\t\u000f\tU!\u0011\u0002a\u0001-\u0006YA/\u0019:hKR\u001cF/\u0019;f\u0011)\u0011IB!\u0003\u0011\u0002\u0003\u0007!1D\u0001\u000fY\u0016\fG-\u001a:TK2,7\r^8s!\rq\"QD\u0005\u0004\u0005?\u0011!a\u0006)beRLG/[8o\u0019\u0016\fG-\u001a:TK2,7\r^8s\u0011)\u0011\u0019C!\u0003\u0011\u0002\u0003\u0007!QE\u0001\nG\u0006dGNY1dWN\u00042A\bB\u0014\u0013\r\u0011IC\u0001\u0002\n\u0007\u0006dGNY1dWNDqA!\f\u0001\t\u0013\u0011y#A\tiC:$G.Z*uCR,7\t[1oO\u0016$B\"!\u0006\u00032\tM\"q\u0007B\u001d\u0005wA\u0001\"a*\u0003,\u0001\u0007\u0011q\u0004\u0005\b\u0005k\u0011Y\u00031\u00012\u0003%\u0001\u0018M\u001d;ji&|g\u000eC\u0004\u0003\u0016\t-\u0002\u0019\u0001,\t\u0011\te!1\u0006a\u0001\u00057A\u0001Ba\t\u0003,\u0001\u0007!Q\u0005\u0005\b\u0005\u007f\u0001A\u0011BAs\u0003aIg.\u001b;jC2L'0\u001a)beRLG/[8o'R\fG/\u001a\u0005\b\u0005\u0007\u0002A\u0011\u0002B#\u0003e\t7o]3siZ\u000bG.\u001b3Qe\u00164\u0018n\\;t'R\fG/Z:\u0015\u0011\u0005U!q\tB&\u0005+BqA!\u0013\u0003B\u0001\u0007\u0001+A\tu_BL7-\u00118e!\u0006\u0014H/\u001b;j_:D\u0001B!\u0014\u0003B\u0001\u0007!qJ\u0001\u000bMJ|Wn\u0015;bi\u0016\u001c\b#BA\u0000\u0005#2\u0016b\u0001B*\u0019\n\u00191+Z9\t\u000f\tU!\u0011\ta\u0001-\"9!\u0011\f\u0001\u0005\n\tm\u0013AG1tg&<gNU3qY&\u001c\u0017m\u001d+p!\u0006\u0014H/\u001b;j_:\u001cHCBA\u000b\u0005;\u0012y\u0006\u0003\u0005\u0002(\n]\u0003\u0019AA\u0010\u0011\u001d\u0011)Da\u0016A\u0002EBqAa\u0019\u0001\t\u0013\u0011)'\u0001\u0012j]&$\u0018.\u00197ju\u0016dU-\u00193fe\u0006sG-S:s\r>\u0014\b+\u0019:uSRLwN\u001c\u000b\u0005\u0003+\u00119\u0007C\u0004\u0003J\t\u0005\u0004\u0019\u0001)\t\u000f\t-\u0004\u0001\"\u0001\u0003n\u00059R\r\\3di2+\u0017\rZ3s\r>\u0014\b+\u0019:uSRLwN\u001c\u000b\t\u0003+\u0011yG!\u001d\u0003t!A\u0011q\u0015B5\u0001\u0004\ty\u0002C\u0004\u00036\t%\u0004\u0019A\u0019\t\u0011\te!\u0011\u000ea\u0001\u00057AqAa\u001e\u0001\t\u0013\u0011I(A\u000esK\u001eL7\u000f^3s)>\u0004\u0018nY\"iC:<W\rT5ti\u0016tWM\u001d\u000b\u0003\u0005w\u0002b!a\r\u00026\tu\u0004cA\u0005\u0003\u0000%\u0019\u0011\u0011\u0006\u0006\t\u000f\t\r\u0005\u0001\"\u0003\u0002f\u0006iB-\u001a:fO&\u001cH/\u001a:U_BL7m\u00115b]\u001e,G*[:uK:,'\u000fC\u0004\u0003\b\u0002!\tA!#\u0002?I,w-[:uKJ\u0004\u0016M\u001d;ji&|gn\u00115b]\u001e,G*[:uK:,'\u000f\u0006\u0003\u0002\u0016\t-\u0005\u0002CAT\u0005\u000b\u0003\r!a\b\t\u000f\t=\u0005\u0001\"\u0001\u0003\u0012\u0006\tC-\u001a:fO&\u001cH/\u001a:QCJ$\u0018\u000e^5p]\u000eC\u0017M\\4f\u0019&\u001cH/\u001a8feR!!1\u0013BM!\u00159\"QSAL\u0013\r\u00119\n\u0007\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005\u001d&Q\u0012a\u0001\u0003?AqA!(\u0001\t\u0013\u0011I(A\u000esK\u001eL7\u000f^3s\t\u0016dW\r^3U_BL7\rT5ti\u0016tWM\u001d\u0005\b\u0005C\u0003A\u0011BAs\u0003u!WM]3hSN$XM\u001d#fY\u0016$X\rV8qS\u000ed\u0015n\u001d;f]\u0016\u0014\bb\u0002BS\u0001\u0011%!qU\u0001%O\u0016$H*Z1eKJL5O]!oI\u0016\u0003xn\u00195PeRC'o\\<Fq\u000e,\u0007\u000f^5p]R1!\u0011\u0016BX\u0005c\u00032A\bBV\u0013\r\u0011iK\u0001\u0002\u001c\u0019\u0016\fG-\u001a:JgJ\fe\u000eZ\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\t\u0011\u0005\u001d&1\u0015a\u0001\u0003?AqA!\u000e\u0003$\u0002\u0007\u0011\u0007C\u0005\u00036\u0002\t\n\u0011\"\u0001\u00038\u0006a\u0002.\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3tI\u0011,g-Y;mi\u0012\u001aTC\u0001B]U\u0011\u0011YBa/,\u0005\tu\u0006\u0003\u0002B`\u0005\u0013l!A!1\u000b\t\t\r'QY\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa2\u0019\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0017\u0014\tMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011Ba4\u0001#\u0003%\tA!5\u00029!\fg\u000e\u001a7f'R\fG/Z\"iC:<Wm\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!1\u001b\u0016\u0005\u0005K\u0011Y\f")
public class PartitionStateMachine
implements Logging,
ScalaObject {
    public final KafkaController kafka$controller$PartitionStateMachine$$controller;
    private final ControllerContext kafka$controller$PartitionStateMachine$$controllerContext;
    private final int kafka$controller$PartitionStateMachine$$controllerId;
    private final ZkClient kafka$controller$PartitionStateMachine$$zkClient;
    private final Map<TopicAndPartition, PartitionState> kafka$controller$PartitionStateMachine$$partitionState;
    private final ControllerBrokerRequestBatch brokerRequestBatch;
    private final AtomicBoolean kafka$controller$PartitionStateMachine$$hasStarted;
    private final NoOpLeaderSelector noOpPartitionLeaderSelector;
    private final TopicChangeListener topicChangeListener;
    private final DeleteTopicsListener deleteTopicsListener;
    private final Map<String, AddPartitionsListener> addPartitionsListener;
    private final KafkaController.StateChangeLogger stateChangeLogger;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public final ControllerContext kafka$controller$PartitionStateMachine$$controllerContext() {
        return this.kafka$controller$PartitionStateMachine$$controllerContext;
    }

    public final int kafka$controller$PartitionStateMachine$$controllerId() {
        return this.kafka$controller$PartitionStateMachine$$controllerId;
    }

    public final ZkClient kafka$controller$PartitionStateMachine$$zkClient() {
        return this.kafka$controller$PartitionStateMachine$$zkClient;
    }

    public final Map<TopicAndPartition, PartitionState> kafka$controller$PartitionStateMachine$$partitionState() {
        return this.kafka$controller$PartitionStateMachine$$partitionState;
    }

    private ControllerBrokerRequestBatch brokerRequestBatch() {
        return this.brokerRequestBatch;
    }

    public final AtomicBoolean kafka$controller$PartitionStateMachine$$hasStarted() {
        return this.kafka$controller$PartitionStateMachine$$hasStarted;
    }

    private NoOpLeaderSelector noOpPartitionLeaderSelector() {
        return this.noOpPartitionLeaderSelector;
    }

    private TopicChangeListener topicChangeListener() {
        return this.topicChangeListener;
    }

    private DeleteTopicsListener deleteTopicsListener() {
        return this.deleteTopicsListener;
    }

    private Map<String, AddPartitionsListener> addPartitionsListener() {
        return this.addPartitionsListener;
    }

    private KafkaController.StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public void startup() {
        this.initializePartitionState();
        this.kafka$controller$PartitionStateMachine$$hasStarted().set(true);
        this.triggerOnlinePartitionStateChange();
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;
            private final PartitionStateMachine $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Started partition state machine with initial state -> ").append((Object)this.$outer.kafka$controller$PartitionStateMachine$$partitionState().toString()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void registerListeners() {
        this.registerTopicChangeListener();
        if (this.kafka$controller$PartitionStateMachine$$controller.config().deleteTopicEnable()) {
            this.registerDeleteTopicListener();
        }
    }

    public void deregisterListeners() {
        this.deregisterTopicChangeListener();
        this.addPartitionsListener().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final PartitionStateMachine $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<String, AddPartitionsListener> tuple2) {
                Tuple2<String, AddPartitionsListener> tuple22 = tuple2;
                if (tuple22 != null) {
                    this.$outer.kafka$controller$PartitionStateMachine$$zkClient().unsubscribeDataChanges(ZkUtils$.MODULE$.getTopicPath((String)tuple22._1()), (IZkDataListener)tuple22._2());
                    return;
                }
                throw new MatchError(tuple22);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.addPartitionsListener().clear();
        if (this.kafka$controller$PartitionStateMachine$$controller.config().deleteTopicEnable()) {
            this.deregisterDeleteTopicListener();
        }
    }

    public void shutdown() {
        this.kafka$controller$PartitionStateMachine$$hasStarted().set(false);
        this.kafka$controller$PartitionStateMachine$$partitionState().clear();
        this.deregisterListeners();
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Stopped partition state machine";
            }
        });
    }

    public void triggerOnlinePartitionStateChange() {
        try {
            this.brokerRequestBatch().newBatch();
            ((TraversableLike)this.kafka$controller$PartitionStateMachine$$partitionState().filter((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Tuple2<TopicAndPartition, PartitionState> tuple2) {
                    Tuple2<TopicAndPartition, PartitionState> tuple22 = tuple2;
                    return tuple22 != null;
                }
            })).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID;
                private final PartitionStateMachine $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Tuple2<TopicAndPartition, PartitionState> tuple2) {
                    Tuple2<TopicAndPartition, PartitionState> tuple22 = tuple2;
                    if (tuple22 != null) {
                        return !this.$outer.kafka$controller$PartitionStateMachine$$controller.deleteTopicManager().isTopicQueuedUpForDeletion(((TopicAndPartition)tuple22._1()).topic());
                    }
                    throw new MatchError(tuple22);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID;
                private final PartitionStateMachine $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Tuple2<TopicAndPartition, PartitionState> tuple2) {
                    Tuple2<TopicAndPartition, PartitionState> tuple22 = tuple2;
                    if (tuple22 != null) {
                        TopicAndPartition topicAndPartition = (TopicAndPartition)tuple22._1();
                        PartitionState partitionState = (PartitionState)tuple22._2();
                        TopicAndPartition topicAndPartition2 = topicAndPartition;
                        PartitionState partitionState2 = partitionState;
                        if (partitionState2.equals(OfflinePartition$.MODULE$) || partitionState2.equals(NewPartition$.MODULE$)) {
                            this.$outer.kafka$controller$PartitionStateMachine$$handleStateChange(topicAndPartition2.topic(), topicAndPartition2.partition(), OnlinePartition$.MODULE$, this.$outer.kafka$controller$PartitionStateMachine$$controller.offlinePartitionSelector(), new Callbacks.CallbackBuilder().build());
                        }
                        return;
                    }
                    throw new MatchError(tuple22);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$PartitionStateMachine$$controller.epoch(), this.kafka$controller$PartitionStateMachine$$controllerContext().correlationId().getAndIncrement());
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Error while moving some partitions to the online state";
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID;
                private final Throwable e$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Throwable apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = throwable;
                }
            });
        }
    }

    public Set<TopicAndPartition> partitionsInState(PartitionState state$1) {
        return ((MapLike)this.kafka$controller$PartitionStateMachine$$partitionState().filter((Function1)new Serializable(this, state$1){
            public static final long serialVersionUID;
            private final PartitionState state$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<TopicAndPartition, PartitionState> p) {
                Object object = p._2();
                PartitionState partitionState = this.state$1;
                return !(object != null ? !object.equals(partitionState) : partitionState != null);
            }
            {
                this.state$1 = partitionState;
            }
        })).keySet();
    }

    public void handleStateChanges(Set<TopicAndPartition> partitions$1, PartitionState targetState$1, PartitionLeaderSelector leaderSelector$1, Callbacks callbacks$1) {
        this.info((Function0<String>)new Serializable(this, partitions$1, targetState$1){
            public static final long serialVersionUID;
            private final Set partitions$1;
            private final PartitionState targetState$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Invoking state change to %s for partitions %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1, this.partitions$1.mkString(",")}));
            }
            {
                this.partitions$1 = set;
                this.targetState$1 = partitionState;
            }
        });
        try {
            this.brokerRequestBatch().newBatch();
            partitions$1.foreach((Function1)new Serializable(this, targetState$1, leaderSelector$1, callbacks$1){
                public static final long serialVersionUID;
                private final PartitionStateMachine $outer;
                private final PartitionState targetState$1;
                private final PartitionLeaderSelector leaderSelector$1;
                private final Callbacks callbacks$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(TopicAndPartition topicAndPartition) {
                    this.$outer.kafka$controller$PartitionStateMachine$$handleStateChange(topicAndPartition.topic(), topicAndPartition.partition(), this.targetState$1, this.leaderSelector$1, this.callbacks$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.targetState$1 = partitionState;
                    this.leaderSelector$1 = partitionLeaderSelector;
                    this.callbacks$1 = callbacks;
                }
            });
            this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$PartitionStateMachine$$controller.epoch(), this.kafka$controller$PartitionStateMachine$$controllerContext().correlationId().getAndIncrement());
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this, targetState$1){
                public static final long serialVersionUID;
                private final PartitionState targetState$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Error while moving some partitions to %s state").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1}));
                }
                {
                    this.targetState$1 = partitionState;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID;
                private final Throwable e$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Throwable apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = throwable;
                }
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void kafka$controller$PartitionStateMachine$$handleStateChange(String topic, int partition, PartitionState targetState$2, PartitionLeaderSelector leaderSelector, Callbacks callbacks) {
        TopicAndPartition topicAndPartition$1 = new TopicAndPartition(topic, partition);
        if (!this.kafka$controller$PartitionStateMachine$$hasStarted().get()) throw new StateChangeFailedException(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change for partition %s to %s failed because the partition state machine has not started").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition$1, targetState$2})));
        PartitionState currState$1 = (PartitionState)this.kafka$controller$PartitionStateMachine$$partitionState().getOrElseUpdate((Object)topicAndPartition$1, (Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final NonExistentPartition$ apply() {
                return NonExistentPartition$.MODULE$;
            }
        });
        try {
            PartitionState partitionState = targetState$2;
            NewPartition$ newPartition$ = NewPartition$.MODULE$;
            PartitionState partitionState2 = partitionState;
            if (!(newPartition$ != null ? !newPartition$.equals(partitionState2) : partitionState2 != null)) {
                this.assertValidPreviousStates(topicAndPartition$1, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NonExistentPartition$[]{NonExistentPartition$.MODULE$})), NewPartition$.MODULE$);
                this.assignReplicasToPartitions(topic, partition);
                this.kafka$controller$PartitionStateMachine$$partitionState().put((Object)topicAndPartition$1, (Object)NewPartition$.MODULE$);
                String assignedReplicas$1 = ((TraversableOnce)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition$1)).mkString(",");
                this.stateChangeLogger().trace((Function0<String>)new Serializable(this, targetState$2, topicAndPartition$1, currState$1, assignedReplicas$1){
                    public static final long serialVersionUID;
                    private final PartitionStateMachine $outer;
                    private final PartitionState targetState$2;
                    private final TopicAndPartition topicAndPartition$1;
                    private final PartitionState currState$1;
                    private final String assignedReplicas$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from %s to %s with assigned replicas %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch()), this.topicAndPartition$1, this.currState$1, this.targetState$2, this.assignedReplicas$1}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.targetState$2 = partitionState;
                        this.topicAndPartition$1 = topicAndPartition;
                        this.currState$1 = partitionState2;
                        this.assignedReplicas$1 = string;
                    }
                });
                return;
            } else {
                OnlinePartition$ onlinePartition$ = OnlinePartition$.MODULE$;
                PartitionState partitionState3 = partitionState;
                if (!(onlinePartition$ != null ? !onlinePartition$.equals(partitionState3) : partitionState3 != null)) {
                    this.assertValidPreviousStates(topicAndPartition$1, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewPartition$.MODULE$, OnlinePartition$.MODULE$, OfflinePartition$.MODULE$})), OnlinePartition$.MODULE$);
                    PartitionState partitionState4 = (PartitionState)this.kafka$controller$PartitionStateMachine$$partitionState().apply((Object)topicAndPartition$1);
                    NewPartition$ newPartition$2 = NewPartition$.MODULE$;
                    PartitionState partitionState5 = partitionState4;
                    if (!(newPartition$2 != null ? !newPartition$2.equals(partitionState5) : partitionState5 != null)) {
                        this.initializeLeaderAndIsrForPartition(topicAndPartition$1);
                    } else {
                        OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
                        PartitionState partitionState6 = partitionState4;
                        if (!(offlinePartition$ != null ? !offlinePartition$.equals(partitionState6) : partitionState6 != null)) {
                            this.electLeaderForPartition(topic, partition, leaderSelector);
                        } else {
                            OnlinePartition$ onlinePartition$2 = OnlinePartition$.MODULE$;
                            PartitionState partitionState7 = partitionState4;
                            if (!(onlinePartition$2 != null ? !onlinePartition$2.equals(partitionState7) : partitionState7 != null)) {
                                this.electLeaderForPartition(topic, partition, leaderSelector);
                            }
                        }
                    }
                    this.kafka$controller$PartitionStateMachine$$partitionState().put((Object)topicAndPartition$1, (Object)OnlinePartition$.MODULE$);
                    int leader$1 = ((LeaderIsrAndControllerEpoch)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().apply((Object)topicAndPartition$1)).leaderAndIsr().leader();
                    this.stateChangeLogger().trace((Function0<String>)new Serializable(this, targetState$2, topicAndPartition$1, currState$1, leader$1){
                        public static final long serialVersionUID;
                        private final PartitionStateMachine $outer;
                        private final PartitionState targetState$2;
                        private final TopicAndPartition topicAndPartition$1;
                        private final PartitionState currState$1;
                        private final int leader$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s from %s to %s with leader %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch()), this.topicAndPartition$1, this.currState$1, this.targetState$2, BoxesRunTime.boxToInteger((int)this.leader$1)}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.targetState$2 = partitionState;
                            this.topicAndPartition$1 = topicAndPartition;
                            this.currState$1 = partitionState2;
                            this.leader$1 = n;
                        }
                    });
                    return;
                } else {
                    OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
                    PartitionState partitionState8 = partitionState;
                    if (!(offlinePartition$ != null ? !offlinePartition$.equals(partitionState8) : partitionState8 != null)) {
                        this.assertValidPreviousStates(topicAndPartition$1, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewPartition$.MODULE$, OnlinePartition$.MODULE$, OfflinePartition$.MODULE$})), OfflinePartition$.MODULE$);
                        this.stateChangeLogger().trace((Function0<String>)new Serializable(this, targetState$2, topicAndPartition$1, currState$1){
                            public static final long serialVersionUID;
                            private final PartitionStateMachine $outer;
                            private final PartitionState targetState$2;
                            private final TopicAndPartition topicAndPartition$1;
                            private final PartitionState currState$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from %s to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch()), this.topicAndPartition$1, this.currState$1, this.targetState$2}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.targetState$2 = partitionState;
                                this.topicAndPartition$1 = topicAndPartition;
                                this.currState$1 = partitionState2;
                            }
                        });
                        this.kafka$controller$PartitionStateMachine$$partitionState().put((Object)topicAndPartition$1, (Object)OfflinePartition$.MODULE$);
                        return;
                    } else {
                        NonExistentPartition$ nonExistentPartition$ = NonExistentPartition$.MODULE$;
                        PartitionState partitionState9 = partitionState;
                        if (nonExistentPartition$ != null ? !nonExistentPartition$.equals(partitionState9) : partitionState9 != null) throw new MatchError((Object)partitionState);
                        this.assertValidPreviousStates(topicAndPartition$1, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OfflinePartition$[]{OfflinePartition$.MODULE$})), NonExistentPartition$.MODULE$);
                        this.stateChangeLogger().trace((Function0<String>)new Serializable(this, targetState$2, topicAndPartition$1, currState$1){
                            public static final long serialVersionUID;
                            private final PartitionStateMachine $outer;
                            private final PartitionState targetState$2;
                            private final TopicAndPartition topicAndPartition$1;
                            private final PartitionState currState$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from %s to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch()), this.topicAndPartition$1, this.currState$1, this.targetState$2}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.targetState$2 = partitionState;
                                this.topicAndPartition$1 = topicAndPartition;
                                this.currState$1 = partitionState2;
                            }
                        });
                        this.kafka$controller$PartitionStateMachine$$partitionState().put((Object)topicAndPartition$1, (Object)NonExistentPartition$.MODULE$);
                    }
                }
            }
            return;
        }
        catch (Throwable throwable) {
            this.stateChangeLogger().error((Function0<String>)new Serializable(this, targetState$2, topicAndPartition$1, currState$1){
                public static final long serialVersionUID;
                private final PartitionStateMachine $outer;
                private final PartitionState targetState$2;
                private final TopicAndPartition topicAndPartition$1;
                private final PartitionState currState$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change for partition %s from %s to %s failed").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch()), this.topicAndPartition$1, this.currState$1, this.targetState$2}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.targetState$2 = partitionState;
                    this.topicAndPartition$1 = topicAndPartition;
                    this.currState$1 = partitionState2;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID;
                private final Throwable t$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Throwable apply() {
                    return this.t$1;
                }
                {
                    this.t$1 = throwable;
                }
            });
        }
    }

    public Callbacks handleStateChanges$default$4() {
        return new Callbacks.CallbackBuilder().build();
    }

    public PartitionLeaderSelector handleStateChanges$default$3() {
        return this.noOpPartitionLeaderSelector();
    }

    private void initializePartitionState() {
        ((IterableLike)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().filter((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple22 = tuple2;
                return tuple22 != null;
            }
        })).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final PartitionStateMachine $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Option<PartitionState> apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple22;
                block2: {
                    Option option;
                    block7: {
                        Option option2;
                        block5: {
                            TopicAndPartition topicPartition;
                            block3: {
                                boolean bl;
                                block6: {
                                    block4: {
                                        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch;
                                        TopicAndPartition topicAndPartition;
                                        tuple22 = tuple2;
                                        if (tuple22 == null) break block2;
                                        topicPartition = topicAndPartition = (TopicAndPartition)tuple22._1();
                                        option = this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().get((Object)topicPartition);
                                        if (!(option instanceof Some)) break block3;
                                        Some some = (Some)option;
                                        LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                                        bl = this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)currentLeaderIsrAndEpoch.leaderAndIsr().leader()));
                                        if (!bl) break block4;
                                        option2 = this.$outer.kafka$controller$PartitionStateMachine$$partitionState().put((Object)topicPartition, (Object)OnlinePartition$.MODULE$);
                                        break block5;
                                    }
                                    if (bl) break block6;
                                    option2 = this.$outer.kafka$controller$PartitionStateMachine$$partitionState().put((Object)topicPartition, (Object)OfflinePartition$.MODULE$);
                                    break block5;
                                }
                                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                            }
                            None$ none$ = None$.MODULE$;
                            Option option3 = option;
                            if (none$ != null ? !none$.equals(option3) : option3 != null) break block7;
                            option2 = this.$outer.kafka$controller$PartitionStateMachine$$partitionState().put((Object)topicPartition, (Object)NewPartition$.MODULE$);
                        }
                        return option2;
                    }
                    throw new MatchError((Object)option);
                }
                throw new MatchError(tuple22);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    private void assertValidPreviousStates(TopicAndPartition topicAndPartition, Seq<PartitionState> fromStates, PartitionState targetState) {
        if (fromStates.contains(this.kafka$controller$PartitionStateMachine$$partitionState().apply((Object)topicAndPartition))) {
            return;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Partition %s should be in the %s states before moving to %s state").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, fromStates.mkString(","), targetState}))).append((Object)Predef$.MODULE$.augmentString(". Instead it is in %s state").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$controller$PartitionStateMachine$$partitionState().apply((Object)topicAndPartition)}))).toString());
    }

    private void assignReplicasToPartitions(String topic, int partition) {
        Seq<Object> assignedReplicas = ZkUtils$.MODULE$.getReplicasForPartition(this.kafka$controller$PartitionStateMachine$$controllerContext().zkClient(), topic, partition);
        this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().$plus$eq(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(topic, partition)).$minus$greater(assignedReplicas));
    }

    private void initializeLeaderAndIsrForPartition(TopicAndPartition topicAndPartition$2) {
        Seq replicaAssignment = (Seq)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition$2);
        Seq liveAssignedReplicas$1 = (Seq)replicaAssignment.filter((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final PartitionStateMachine $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(int r) {
                return this.apply$mcZI$sp(r);
            }

            public boolean apply$mcZI$sp(int v1) {
                return this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)v1));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        int n = liveAssignedReplicas$1.size();
        if (n == 0) {
            String failMsg$1 = Predef$.MODULE$.augmentString("encountered error during state change of partition %s from New to Online, assigned replicas are [%s], live brokers are [%s]. No assigned replica is alive.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition$2, replicaAssignment.mkString(","), this.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds()}));
            this.stateChangeLogger().error((Function0<String>)new Serializable(this, failMsg$1){
                public static final long serialVersionUID;
                private final PartitionStateMachine $outer;
                private final String failMsg$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)this.failMsg$1).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.failMsg$1 = string;
                }
            });
            throw new StateChangeFailedException(failMsg$1);
        }
        this.debug((Function0<String>)new Serializable(this, topicAndPartition$2, liveAssignedReplicas$1){
            public static final long serialVersionUID;
            private final TopicAndPartition topicAndPartition$2;
            private final Seq liveAssignedReplicas$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Live assigned replicas for partition %s are: [%s]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$2, this.liveAssignedReplicas$1}));
            }
            {
                this.topicAndPartition$2 = topicAndPartition;
                this.liveAssignedReplicas$1 = seq;
            }
        });
        int leader = BoxesRunTime.unboxToInt((Object)liveAssignedReplicas$1.head());
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1 = new LeaderIsrAndControllerEpoch(new LeaderAndIsr(leader, (List<Object>)liveAssignedReplicas$1.toList()), this.kafka$controller$PartitionStateMachine$$controller.epoch());
        this.debug((Function0<String>)new Serializable(this, topicAndPartition$2, leaderIsrAndControllerEpoch$1){
            public static final long serialVersionUID;
            private final TopicAndPartition topicAndPartition$2;
            private final LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Initializing leader and isr for partition %s to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$2, this.leaderIsrAndControllerEpoch$1}));
            }
            {
                this.topicAndPartition$2 = topicAndPartition;
                this.leaderIsrAndControllerEpoch$1 = leaderIsrAndControllerEpoch;
            }
        });
        try {
            ZkUtils$.MODULE$.createPersistentPath(this.kafka$controller$PartitionStateMachine$$controllerContext().zkClient(), ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topicAndPartition$2.topic(), topicAndPartition$2.partition()), ZkUtils$.MODULE$.leaderAndIsrZkData(leaderIsrAndControllerEpoch$1.leaderAndIsr(), this.kafka$controller$PartitionStateMachine$$controller.epoch()));
            this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().put((Object)topicAndPartition$2, (Object)leaderIsrAndControllerEpoch$1);
            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)liveAssignedReplicas$1, topicAndPartition$2.topic(), topicAndPartition$2.partition(), leaderIsrAndControllerEpoch$1, (Seq<Object>)replicaAssignment, (Function1<RequestOrResponse, BoxedUnit>)this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
            return;
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            LeaderIsrAndControllerEpoch leaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$PartitionStateMachine$$zkClient(), topicAndPartition$2.topic(), topicAndPartition$2.partition()).get();
            String failMsg$2 = Predef$.MODULE$.augmentString("encountered error while changing partition %s's state from New to Online since LeaderAndIsr path already exists with value %s and controller epoch %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition$2, leaderIsrAndEpoch.leaderAndIsr().toString(), BoxesRunTime.boxToInteger((int)leaderIsrAndEpoch.controllerEpoch())}));
            this.stateChangeLogger().error((Function0<String>)new Serializable(this, failMsg$2){
                public static final long serialVersionUID;
                private final PartitionStateMachine $outer;
                private final String failMsg$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)this.failMsg$2).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.failMsg$2 = string;
                }
            });
            throw new StateChangeFailedException(failMsg$2);
        }
    }

    public void electLeaderForPartition(String topic, int partition, PartitionLeaderSelector leaderSelector) {
        TopicAndPartition topicAndPartition$3 = new TopicAndPartition(topic, partition);
        this.stateChangeLogger().trace((Function0<String>)new Serializable(this, topicAndPartition$3){
            public static final long serialVersionUID;
            private final PartitionStateMachine $outer;
            private final TopicAndPartition topicAndPartition$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Controller %d epoch %d started leader election for partition %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch()), this.topicAndPartition$3}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topicAndPartition$3 = topicAndPartition;
            }
        });
        try {
            Seq replicasForThisPartition;
            ObjectRef newLeaderAndIsr$1;
            block6: {
                Tuple2<LeaderAndIsr, Seq<Object>> tuple2;
                block7: {
                    Tuple2<Object, Object> tuple22;
                    boolean zookeeperPathUpdateSucceeded = false;
                    newLeaderAndIsr$1 = new ObjectRef(null);
                    replicasForThisPartition = (Seq)Seq$.MODULE$.empty();
                    while (true) {
                        if (zookeeperPathUpdateSucceeded) break block6;
                        LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = this.getLeaderIsrAndEpochOrThrowException(topic, partition);
                        LeaderAndIsr currentLeaderAndIsr = currentLeaderIsrAndEpoch.leaderAndIsr();
                        int controllerEpoch = currentLeaderIsrAndEpoch.controllerEpoch();
                        if (controllerEpoch > this.kafka$controller$PartitionStateMachine$$controller.epoch()) {
                            String failMsg$3 = Predef$.MODULE$.augmentString("aborted leader election for partition [%s,%d] since the LeaderAndIsr path was already written by another controller. This probably means that the current controller %d went through a soft failure and another controller was elected with epoch %d.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)controllerEpoch)}));
                            this.stateChangeLogger().error((Function0<String>)new Serializable(this, failMsg$3){
                                public static final long serialVersionUID;
                                private final PartitionStateMachine $outer;
                                private final String failMsg$3;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)this.failMsg$3).toString();
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.failMsg$3 = string;
                                }
                            });
                            throw new StateChangeFailedException(failMsg$3);
                        }
                        tuple2 = leaderSelector.selectLeader(topicAndPartition$3, currentLeaderAndIsr);
                        if (tuple2 == null) break block7;
                        Tuple2 tuple23 = new Tuple2(tuple2._1(), tuple2._2());
                        LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple23._1();
                        Seq replicas = (Seq)tuple23._2();
                        tuple22 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.kafka$controller$PartitionStateMachine$$zkClient(), topic, partition, leaderAndIsr, this.kafka$controller$PartitionStateMachine$$controller.epoch(), currentLeaderAndIsr.zkVersion());
                        if (tuple22 == null) break;
                        Tuple2 tuple24 = new Tuple2(tuple22._1(), tuple22._2());
                        boolean updateSucceeded = BoxesRunTime.unboxToBoolean((Object)tuple24._1());
                        int newVersion = tuple24._2$mcI$sp();
                        newLeaderAndIsr$1.elem = leaderAndIsr;
                        ((LeaderAndIsr)newLeaderAndIsr$1.elem).zkVersion_$eq(newVersion);
                        zookeeperPathUpdateSucceeded = updateSucceeded;
                        replicasForThisPartition = replicas;
                    }
                    throw new MatchError(tuple22);
                }
                throw new MatchError(tuple2);
            }
            LeaderIsrAndControllerEpoch newLeaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch((LeaderAndIsr)newLeaderAndIsr$1.elem, this.kafka$controller$PartitionStateMachine$$controller.epoch());
            this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().put((Object)new TopicAndPartition(topic, partition), (Object)newLeaderIsrAndControllerEpoch);
            this.stateChangeLogger().trace((Function0<String>)new Serializable(this, topicAndPartition$3, newLeaderAndIsr$1){
                public static final long serialVersionUID;
                private final PartitionStateMachine $outer;
                private final TopicAndPartition topicAndPartition$3;
                private final ObjectRef newLeaderAndIsr$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Controller %d epoch %d elected leader %d for Offline partition %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)((LeaderAndIsr)this.newLeaderAndIsr$1.elem).leader()), this.topicAndPartition$3}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.topicAndPartition$3 = topicAndPartition;
                    this.newLeaderAndIsr$1 = objectRef;
                }
            });
            Seq replicas = (Seq)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)new TopicAndPartition(topic, partition));
            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)replicasForThisPartition, topic, partition, newLeaderIsrAndControllerEpoch, (Seq<Object>)replicas, (Function1<RequestOrResponse, BoxedUnit>)this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
        }
        catch (Throwable throwable) {
            String failMsg$4 = Predef$.MODULE$.augmentString("encountered error while electing leader for partition %s due to: %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition$3, throwable.getMessage()}));
            this.stateChangeLogger().error((Function0<String>)new Serializable(this, failMsg$4){
                public static final long serialVersionUID;
                private final PartitionStateMachine $outer;
                private final String failMsg$4;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)this.failMsg$4).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.failMsg$4 = string;
                }
            });
            throw new StateChangeFailedException(failMsg$4, throwable);
        }
        catch (NoReplicaOnlineException noReplicaOnlineException) {
            throw noReplicaOnlineException;
        }
        catch (LeaderElectionNotNeededException leaderElectionNotNeededException) {
            // empty catch block
        }
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;
            private final PartitionStateMachine $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("After leader election, leader cache is updated to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Tuple2<TopicAndPartition, LeaderIsrAndControllerEpoch> apply(Tuple2<TopicAndPartition, LeaderIsrAndControllerEpoch> l) {
                        return new Tuple2(l._1(), l._2());
                    }
                }, Map$.MODULE$.canBuildFrom())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    private java.util.List<String> registerTopicChangeListener() {
        return this.kafka$controller$PartitionStateMachine$$zkClient().subscribeChildChanges(ZkUtils$.MODULE$.BrokerTopicsPath(), (IZkChildListener)this.topicChangeListener());
    }

    private void deregisterTopicChangeListener() {
        this.kafka$controller$PartitionStateMachine$$zkClient().unsubscribeChildChanges(ZkUtils$.MODULE$.BrokerTopicsPath(), (IZkChildListener)this.topicChangeListener());
    }

    public void registerPartitionChangeListener(String topic) {
        this.addPartitionsListener().put((Object)topic, (Object)new AddPartitionsListener(this, topic));
        this.kafka$controller$PartitionStateMachine$$zkClient().subscribeDataChanges(ZkUtils$.MODULE$.getTopicPath(topic), (IZkDataListener)this.addPartitionsListener().apply((Object)topic));
    }

    public Option<AddPartitionsListener> deregisterPartitionChangeListener(String topic) {
        this.kafka$controller$PartitionStateMachine$$zkClient().unsubscribeDataChanges(ZkUtils$.MODULE$.getTopicPath(topic), (IZkDataListener)this.addPartitionsListener().apply((Object)topic));
        return this.addPartitionsListener().remove((Object)topic);
    }

    private java.util.List<String> registerDeleteTopicListener() {
        return this.kafka$controller$PartitionStateMachine$$zkClient().subscribeChildChanges(ZkUtils$.MODULE$.DeleteTopicsPath(), (IZkChildListener)this.deleteTopicsListener());
    }

    private void deregisterDeleteTopicListener() {
        this.kafka$controller$PartitionStateMachine$$zkClient().unsubscribeChildChanges(ZkUtils$.MODULE$.DeleteTopicsPath(), (IZkChildListener)this.deleteTopicsListener());
    }

    private LeaderIsrAndControllerEpoch getLeaderIsrAndEpochOrThrowException(String topic, int partition) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
        Option<LeaderIsrAndControllerEpoch> option = ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$PartitionStateMachine$$zkClient(), topic, partition);
        if (option instanceof Some) {
            return (LeaderIsrAndControllerEpoch)((Some)option).x();
        }
        None$ none$ = None$.MODULE$;
        Option<LeaderIsrAndControllerEpoch> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            String failMsg = Predef$.MODULE$.augmentString("LeaderAndIsr information doesn't exist for partition %s in %s state").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, this.kafka$controller$PartitionStateMachine$$partitionState().apply((Object)topicAndPartition)}));
            throw new StateChangeFailedException(failMsg);
        }
        throw new MatchError(option);
    }

    public PartitionStateMachine(KafkaController controller) {
        this.kafka$controller$PartitionStateMachine$$controller = controller;
        Logging$class.$init$(this);
        this.kafka$controller$PartitionStateMachine$$controllerContext = controller.controllerContext();
        this.kafka$controller$PartitionStateMachine$$controllerId = controller.config().brokerId();
        this.kafka$controller$PartitionStateMachine$$zkClient = this.kafka$controller$PartitionStateMachine$$controllerContext().zkClient();
        this.kafka$controller$PartitionStateMachine$$partitionState = Map$.MODULE$.empty();
        this.brokerRequestBatch = new ControllerBrokerRequestBatch(controller);
        this.kafka$controller$PartitionStateMachine$$hasStarted = new AtomicBoolean(false);
        this.noOpPartitionLeaderSelector = new NoOpLeaderSelector(this.kafka$controller$PartitionStateMachine$$controllerContext());
        this.topicChangeListener = new TopicChangeListener(this);
        this.deleteTopicsListener = new DeleteTopicsListener(this);
        this.addPartitionsListener = Map$.MODULE$.empty();
        this.stateChangeLogger = KafkaController$.MODULE$.stateChangeLogger();
        this.logIdent_$eq(new StringBuilder().append((Object)"[Partition state machine on Controller ").append((Object)BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controllerId())).append((Object)"]: ").toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TopicChangeListener
    implements IZkChildListener,
    Logging,
    ScalaObject {
        public final PartitionStateMachine $outer;
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        public volatile int bitmap$0;

        public void handleChildChange(String parentPath$1, java.util.List<String> children$1) throws Exception {
            Utils$.MODULE$.inLock(this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock(), new Serializable(this, parentPath$1, children$1){
                public static final long serialVersionUID;
                private final TopicChangeListener $outer;
                public final String parentPath$1;
                public final java.util.List children$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    if (this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$hasStarted().get()) {
                        try {
                            this.$outer.debug((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID;
                                private final TopicChangeListener$$anonfun$handleChildChange$1 $outer;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return Predef$.MODULE$.augmentString("Topic change listener fired for path %s with children %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.parentPath$1, JavaConversions$.MODULE$.asScalaBuffer(this.$outer.children$1).mkString(",")}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            scala.collection.immutable.Set currentChildren = JavaConversions$.MODULE$.asScalaBuffer(this.children$1).toSet();
                            scala.collection.immutable.Set newTopics$1 = (scala.collection.immutable.Set)currentChildren.$minus$minus(this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics());
                            Set deletedTopics$1 = (Set)this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics().$minus$minus((GenTraversableOnce)currentChildren);
                            this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics_$eq((Set<String>)currentChildren);
                            Map<TopicAndPartition, Seq<Object>> addedPartitionReplicaAssignment$1 = ZkUtils$.MODULE$.getReplicaAssignmentForTopics(this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$zkClient(), (Seq<String>)newTopics$1.toSeq());
                            this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment_$eq((Map<TopicAndPartition, Seq<Object>>)((Map)this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().filter((Function1)new Serializable(this, deletedTopics$1){
                                public static final long serialVersionUID;
                                private final Set deletedTopics$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> p) {
                                    return !this.deletedTopics$1.contains((Object)((TopicAndPartition)p._1()).topic());
                                }
                                {
                                    this.deletedTopics$1 = set;
                                }
                            })));
                            this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().$plus$plus$eq(addedPartitionReplicaAssignment$1);
                            this.$outer.info((Function0<String>)new Serializable(this, newTopics$1, deletedTopics$1, addedPartitionReplicaAssignment$1){
                                public static final long serialVersionUID;
                                private final scala.collection.immutable.Set newTopics$1;
                                private final Set deletedTopics$1;
                                private final Map addedPartitionReplicaAssignment$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return Predef$.MODULE$.augmentString("New topics: [%s], deleted topics: [%s], new partition replica assignment [%s]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newTopics$1, this.deletedTopics$1, this.addedPartitionReplicaAssignment$1}));
                                }
                                {
                                    this.newTopics$1 = set;
                                    this.deletedTopics$1 = set2;
                                    this.addedPartitionReplicaAssignment$1 = map;
                                }
                            });
                            if (newTopics$1.size() > 0) {
                                this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controller.onNewTopicCreation((Set<String>)newTopics$1, (Set<TopicAndPartition>)addedPartitionReplicaAssignment$1.keySet().toSet());
                            }
                        }
                        catch (Throwable throwable) {
                            this.$outer.error((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return "Error while handling new topic";
                                }
                            }, (Function0<Throwable>)new Serializable(this, throwable){
                                public static final long serialVersionUID;
                                private final Throwable e$3;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final Throwable apply() {
                                    return this.e$3;
                                }
                                {
                                    this.e$3 = throwable;
                                }
                            });
                        }
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.parentPath$1 = string;
                    this.children$1 = list;
                }
            });
        }

        public PartitionStateMachine kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer() {
            return this.$outer;
        }

        public TopicChangeListener(PartitionStateMachine $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[TopicChangeListener on Controller ").append((Object)BoxesRunTime.boxToInteger((int)$outer.kafka$controller$PartitionStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DeleteTopicsListener
    implements IZkChildListener,
    Logging,
    ScalaObject {
        private final ZkClient zkClient;
        public final PartitionStateMachine $outer;
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        public volatile int bitmap$0;

        public ZkClient zkClient() {
            return this.zkClient;
        }

        public void handleChildChange(String parentPath, java.util.List<String> children$2) throws Exception {
            Utils$.MODULE$.inLock(this.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock(), new Serializable(this, children$2){
                public static final long serialVersionUID;
                private final DeleteTopicsListener $outer;
                private final java.util.List children$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    ObjectRef topicsToBeDeleted$1 = new ObjectRef((Object)JavaConversions$.MODULE$.asScalaBuffer(this.children$2).toSet());
                    this.$outer.debug((Function0<String>)new Serializable(this, topicsToBeDeleted$1){
                        public static final long serialVersionUID;
                        private final ObjectRef topicsToBeDeleted$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Delete topics listener fired for topics %s to be deleted").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((scala.collection.immutable.Set)this.topicsToBeDeleted$1.elem).mkString(",")}));
                        }
                        {
                            this.topicsToBeDeleted$1 = objectRef;
                        }
                    });
                    scala.collection.immutable.Set nonExistentTopics$1 = (scala.collection.immutable.Set)((scala.collection.immutable.Set)topicsToBeDeleted$1.elem).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID;
                        private final DeleteTopicsListener$$anonfun$handleChildChange$2 $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final boolean apply(String t) {
                            return !this.$outer.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$anonfun$$$outer().kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics().contains((Object)t);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    if (nonExistentTopics$1.size() > 0) {
                        this.$outer.warn((Function0<String>)new Serializable(this, nonExistentTopics$1){
                            public static final long serialVersionUID;
                            private final scala.collection.immutable.Set nonExistentTopics$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return new StringBuilder().append((Object)"Ignoring request to delete non-existing topics ").append((Object)this.nonExistentTopics$1.mkString(",")).toString();
                            }
                            {
                                this.nonExistentTopics$1 = set;
                            }
                        });
                        nonExistentTopics$1.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID;
                            private final DeleteTopicsListener$$anonfun$handleChildChange$2 $outer;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final void apply(String topic) {
                                ZkUtils$.MODULE$.deletePathRecursive(this.$outer.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$anonfun$$$outer().zkClient(), ZkUtils$.MODULE$.getDeleteTopicPath(topic));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    topicsToBeDeleted$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)topicsToBeDeleted$1.elem).$minus$minus((GenTraversableOnce)nonExistentTopics$1);
                    if (((scala.collection.immutable.Set)topicsToBeDeleted$1.elem).size() > 0) {
                        this.$outer.info((Function0<String>)new Serializable(this, topicsToBeDeleted$1){
                            public static final long serialVersionUID;
                            private final ObjectRef topicsToBeDeleted$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return new StringBuilder().append((Object)"Starting topic deletion for topics ").append((Object)((scala.collection.immutable.Set)this.topicsToBeDeleted$1.elem).mkString(",")).toString();
                            }
                            {
                                this.topicsToBeDeleted$1 = objectRef;
                            }
                        });
                        ((scala.collection.immutable.Set)topicsToBeDeleted$1.elem).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID;
                            private final DeleteTopicsListener$$anonfun$handleChildChange$2 $outer;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final void apply(String topic) {
                                boolean preferredReplicaElectionInProgress = ((SetLike)this.$outer.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$anonfun$$$outer().kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionsUndergoingPreferredReplicaElection().map((Function1)new Serializable(this){
                                    public static final long serialVersionUID;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final String apply(TopicAndPartition topicAndPartition) {
                                        return topicAndPartition.topic();
                                    }
                                }, scala.collection.mutable.Set$.MODULE$.canBuildFrom())).contains((Object)topic);
                                boolean partitionReassignmentInProgress = ((SetLike)this.$outer.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$anonfun$$$outer().kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionsBeingReassigned().keySet().map((Function1)new Serializable(this){
                                    public static final long serialVersionUID;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final String apply(TopicAndPartition topicAndPartition) {
                                        return topicAndPartition.topic();
                                    }
                                }, Set$.MODULE$.canBuildFrom())).contains((Object)topic);
                                if (preferredReplicaElectionInProgress || partitionReassignmentInProgress) {
                                    this.$outer.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$anonfun$$$outer().kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controller.deleteTopicManager().markTopicIneligibleForDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.$outer.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controller.deleteTopicManager().enqueueTopicsForDeletion((Set<String>)((scala.collection.immutable.Set)topicsToBeDeleted$1.elem));
                    }
                }

                public DeleteTopicsListener kafka$controller$PartitionStateMachine$DeleteTopicsListener$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.children$2 = list;
                }
            });
        }

        public void handleDataDeleted(String dataPath) throws Exception {
        }

        public PartitionStateMachine kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer() {
            return this.$outer;
        }

        public DeleteTopicsListener(PartitionStateMachine $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[DeleteTopicsListener on ").append((Object)BoxesRunTime.boxToInteger((int)$outer.kafka$controller$PartitionStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
            this.zkClient = $outer.kafka$controller$PartitionStateMachine$$controllerContext().zkClient();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AddPartitionsListener
    implements IZkDataListener,
    Logging,
    ScalaObject {
        public final String kafka$controller$PartitionStateMachine$AddPartitionsListener$$topic;
        public final PartitionStateMachine $outer;
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        public volatile int bitmap$0;

        public void handleDataChange(String dataPath$1, Object data$1) throws Exception {
            Utils$.MODULE$.inLock(this.kafka$controller$PartitionStateMachine$AddPartitionsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock(), new Serializable(this, dataPath$1, data$1){
                public static final long serialVersionUID;
                private final AddPartitionsListener $outer;
                public final String dataPath$1;
                public final Object data$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    try {
                        this.$outer.info((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID;
                            private final AddPartitionsListener$$anonfun$handleDataChange$1 $outer;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return new StringBuilder().append((Object)"Add Partition triggered ").append((Object)this.$outer.data$1.toString()).append((Object)" for path ").append((Object)this.$outer.dataPath$1).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        Map<TopicAndPartition, Seq<Object>> partitionReplicaAssignment = ZkUtils$.MODULE$.getReplicaAssignmentForTopics(this.$outer.kafka$controller$PartitionStateMachine$AddPartitionsListener$$$outer().kafka$controller$PartitionStateMachine$$zkClient(), (Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.kafka$controller$PartitionStateMachine$AddPartitionsListener$$topic})));
                        Map partitionsToBeAdded$1 = (Map)partitionReplicaAssignment.filter((Function1)new Serializable(this){
                            public static final long serialVersionUID;
                            private final AddPartitionsListener$$anonfun$handleDataChange$1 $outer;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> p) {
                                return !this.$outer.kafka$controller$PartitionStateMachine$AddPartitionsListener$$anonfun$$$outer().kafka$controller$PartitionStateMachine$AddPartitionsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().contains(p._1());
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        if (this.$outer.kafka$controller$PartitionStateMachine$AddPartitionsListener$$$outer().kafka$controller$PartitionStateMachine$$controller.deleteTopicManager().isTopicQueuedUpForDeletion(this.$outer.kafka$controller$PartitionStateMachine$AddPartitionsListener$$topic)) {
                            this.$outer.error((Function0<String>)new Serializable(this, partitionsToBeAdded$1){
                                public static final long serialVersionUID;
                                private final AddPartitionsListener$$anonfun$handleDataChange$1 $outer;
                                private final Map partitionsToBeAdded$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return Predef$.MODULE$.augmentString("Skipping adding partitions %s for topic %s since it is currently being deleted").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.partitionsToBeAdded$1.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final int apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                                            return ((TopicAndPartition)tuple2._1()).partition();
                                        }
                                    }, Iterable$.MODULE$.canBuildFrom())).mkString(","), this.$outer.kafka$controller$PartitionStateMachine$AddPartitionsListener$$anonfun$$$outer().kafka$controller$PartitionStateMachine$AddPartitionsListener$$topic}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.partitionsToBeAdded$1 = map;
                                }
                            });
                        } else if (partitionsToBeAdded$1.size() > 0) {
                            this.$outer.info((Function0<String>)new Serializable(this, partitionsToBeAdded$1){
                                public static final long serialVersionUID;
                                private final Map partitionsToBeAdded$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return Predef$.MODULE$.augmentString("New partitions to be added %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionsToBeAdded$1}));
                                }
                                {
                                    this.partitionsToBeAdded$1 = map;
                                }
                            });
                            this.$outer.kafka$controller$PartitionStateMachine$AddPartitionsListener$$$outer().kafka$controller$PartitionStateMachine$$controller.onNewPartitionCreation((Set<TopicAndPartition>)partitionsToBeAdded$1.keySet().toSet());
                        }
                    }
                    catch (Throwable throwable) {
                        this.$outer.error((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID;
                            private final AddPartitionsListener$$anonfun$handleDataChange$1 $outer;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return new StringBuilder().append((Object)"Error while handling add partitions for data path ").append((Object)this.$outer.dataPath$1).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, (Function0<Throwable>)new Serializable(this, throwable){
                            public static final long serialVersionUID;
                            private final Throwable e$4;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final Throwable apply() {
                                return this.e$4;
                            }
                            {
                                this.e$4 = throwable;
                            }
                        });
                    }
                }

                public AddPartitionsListener kafka$controller$PartitionStateMachine$AddPartitionsListener$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.dataPath$1 = string;
                    this.data$1 = object;
                }
            });
        }

        public void handleDataDeleted(String parentPath) throws Exception {
        }

        public PartitionStateMachine kafka$controller$PartitionStateMachine$AddPartitionsListener$$$outer() {
            return this.$outer;
        }

        public AddPartitionsListener(PartitionStateMachine $outer, String topic) {
            this.kafka$controller$PartitionStateMachine$AddPartitionsListener$$topic = topic;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[AddPartitionsListener on ").append((Object)BoxesRunTime.boxToInteger((int)$outer.kafka$controller$PartitionStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
        }
    }
}

