/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import kafka.network.InvalidRequestException;
import kafka.network.Receive;
import kafka.network.Receive$class;
import kafka.network.Transmission$class;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001!4Q!\u0001\u0002\u0001\t\u0019\u0011\u0001DQ8v]\u0012,GMQ=uK\n+hMZ3s%\u0016\u001cW-\u001b<f\u0015\t\u0019A!A\u0004oKR<xN]6\u000b\u0003\u0015\tQa[1gW\u0006\u001cR\u0001A\u0004\u0010'e\u0001\"\u0001C\u0007\u000e\u0003%Q!AC\u0006\u0002\t1\fgn\u001a\u0006\u0002\u0019\u0005!!.\u0019<b\u0013\tq\u0011B\u0001\u0004PE*,7\r\u001e\t\u0003!Ei\u0011AA\u0005\u0003%\t\u0011qAU3dK&4X\r\u0005\u0002\u0015/5\tQC\u0003\u0002\u0017\t\u0005)Q\u000f^5mg&\u0011\u0001$\u0006\u0002\b\u0019><w-\u001b8h!\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011\u0001\u0002!Q1A\u0005\u0002\t\nq!\\1y'&TXm\u0001\u0001\u0016\u0003\r\u0002\"A\u0007\u0013\n\u0005\u0015Z\"aA%oi\"Aq\u0005\u0001B\u0001B\u0003%1%\u0001\u0005nCb\u001c\u0016N_3!\u0011\u0015I\u0003\u0001\"\u0001+\u0003\u0019a\u0014N\\5u}Q\u00111\u0006\f\t\u0003!\u0001AQ\u0001\t\u0015A\u0002\rBqA\f\u0001C\u0002\u0013%q&\u0001\u0006tSj,')\u001e4gKJ,\u0012\u0001\r\t\u0003cQj\u0011A\r\u0006\u0003g-\t1A\\5p\u0013\t)$G\u0001\u0006CsR,')\u001e4gKJDaa\u000e\u0001!\u0002\u0013\u0001\u0014aC:ju\u0016\u0014UO\u001a4fe\u0002Bq!\u000f\u0001A\u0002\u0013%q&A\u0007d_:$XM\u001c;Ck\u001a4WM\u001d\u0005\bw\u0001\u0001\r\u0011\"\u0003=\u0003E\u0019wN\u001c;f]R\u0014UO\u001a4fe~#S-\u001d\u000b\u0003{\u0001\u0003\"A\u0007 \n\u0005}Z\"\u0001B+oSRDq!\u0011\u001e\u0002\u0002\u0003\u0007\u0001'A\u0002yIEBaa\u0011\u0001!B\u0013\u0001\u0014AD2p]R,g\u000e\u001e\"vM\u001a,'\u000f\t\u0005\u0006S\u0001!\t!\u0012\u000b\u0002W!9q\t\u0001a\u0001\n\u0003A\u0015\u0001C2p[BdW\r^3\u0016\u0003%\u0003\"A\u0007&\n\u0005-[\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u001b\u0002\u0001\r\u0011\"\u0001O\u00031\u0019w.\u001c9mKR,w\fJ3r)\tit\nC\u0004B\u0019\u0006\u0005\t\u0019A%\t\rE\u0003\u0001\u0015)\u0003J\u0003%\u0019w.\u001c9mKR,\u0007\u0005C\u0003T\u0001\u0011\u0005q&\u0001\u0004ck\u001a4WM\u001d\u0005\u0006+\u0002!\tAV\u0001\te\u0016\fGM\u0012:p[R\u00111e\u0016\u0005\u00061R\u0003\r!W\u0001\bG\"\fgN\\3m!\tQV,D\u0001\\\u0015\ta&'\u0001\u0005dQ\u0006tg.\u001a7t\u0013\tq6LA\nSK\u0006$\u0017M\u00197f\u0005f$Xm\u00115b]:,G\u000eC\u0003a\u0001\u0011%\u0011-\u0001\ncsR,')\u001e4gKJ\fE\u000e\\8dCR,GC\u0001\u0019c\u0011\u0015\u0019w\f1\u0001$\u0003\u0011\u0019\u0018N_3)\u0005\u0001)\u0007C\u0001\u000bg\u0013\t9WCA\u0007o_:$\bN]3bIN\fg-\u001a")
public class BoundedByteBufferReceive
implements Receive,
Logging,
ScalaObject {
    private final int maxSize;
    private final ByteBuffer sizeBuffer;
    private ByteBuffer contentBuffer;
    private boolean complete;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public int maxSize() {
        return this.maxSize;
    }

    private ByteBuffer sizeBuffer() {
        return this.sizeBuffer;
    }

    private ByteBuffer contentBuffer() {
        return this.contentBuffer;
    }

    private void contentBuffer_$eq(ByteBuffer byteBuffer) {
        this.contentBuffer = byteBuffer;
    }

    @Override
    public boolean complete() {
        return this.complete;
    }

    public void complete_$eq(boolean bl) {
        this.complete = bl;
    }

    @Override
    public ByteBuffer buffer() {
        this.expectComplete();
        return this.contentBuffer();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readFrom(ReadableByteChannel channel) {
        void var2_2;
        this.expectIncomplete();
        int read2 = 0;
        if (this.sizeBuffer().remaining() > 0) {
            read2 += Utils$.MODULE$.read(channel, this.sizeBuffer());
        }
        if (this.contentBuffer() == null && !this.sizeBuffer().hasRemaining()) {
            this.sizeBuffer().rewind();
            int size2 = this.sizeBuffer().getInt();
            if (size2 <= 0) {
                throw new InvalidRequestException(Predef$.MODULE$.augmentString("%d is not a valid request size.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size2)})));
            }
            if (size2 > this.maxSize()) {
                throw new InvalidRequestException(Predef$.MODULE$.augmentString("Request of length %d is not valid, it is larger than the maximum size of %d bytes.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size2), BoxesRunTime.boxToInteger((int)this.maxSize())})));
            }
            this.contentBuffer_$eq(this.byteBufferAllocate(size2));
        }
        if (this.contentBuffer() != null) {
            read2 = Utils$.MODULE$.read(channel, this.contentBuffer());
            if (!this.contentBuffer().hasRemaining()) {
                this.contentBuffer().rewind();
                this.complete_$eq(true);
            }
        }
        return (int)var2_2;
    }

    private ByteBuffer byteBufferAllocate(int size$1) {
        ByteBuffer buffer = null;
        try {
            buffer = ByteBuffer.allocate(size$1);
            return buffer;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.error((Function0<String>)new Serializable(this, size$1){
                public static final long serialVersionUID;
                private final int size$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"OOME with size ").append((Object)BoxesRunTime.boxToInteger((int)this.size$1)).toString();
                }
                {
                    this.size$1 = n;
                }
            }, (Function0<Throwable>)new Serializable(this, outOfMemoryError){
                public static final long serialVersionUID;
                private final OutOfMemoryError e$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final OutOfMemoryError apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = outOfMemoryError;
                }
            });
            throw outOfMemoryError;
        }
    }

    public BoundedByteBufferReceive(int maxSize) {
        this.maxSize = maxSize;
        Logging$class.$init$(this);
        Transmission$class.$init$(this);
        Receive$class.$init$(this);
        this.sizeBuffer = ByteBuffer.allocate(4);
        this.contentBuffer = null;
        this.complete = false;
    }

    public BoundedByteBufferReceive() {
        this(Integer.MAX_VALUE);
    }
}

